#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-basic-val-array-empty
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-basic-val-array-empty.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\'''
) -L list-closed-array-basic-basic-val-array-empty.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[]'\'''
)

