#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-plain-object-plain-val-object-basic-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-plain-object-plain-val-object-basic-basic2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":456}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":456}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":456}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":456}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":456}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":456}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":456}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":456}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":456}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":456}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":456}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":456}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":null,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":null
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":null}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":false}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":true}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":123}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":456}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":false,"baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":false
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":null}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":false}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":true}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":123}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":456}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"foo"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":"bar"}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":{}}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"faa":true,"baa":[]}
json: error: <stdin>:1:12:            ^
{"faa":true
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":null}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":false}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":true}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":123}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":456}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"foo"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":"bar"}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":{}}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"faa":123,"baa":[]}
json: error: <stdin>:1:11:           ^
{"faa":123
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":null}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":false}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":true}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":123}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":456}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"foo"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":"bar"}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":{}}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"faa":"foo","baa":[]}
json: error: <stdin>:1:13:             ^
{"faa":"foo"
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
) -L list-plain-object-plain-val-object-basic-basic2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"faa":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"faa":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"faa":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"faa":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"faa":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"faa":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"faa":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"faa":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"faa":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"faa":"foo","baa":[]}'\'''
)

