#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list9
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list9.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},{"plain":"bar"}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":null}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":false}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":true}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [456,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: ["baz","baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},{"plain":123}]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
) -L open-array-list9.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":null},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":false},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":true},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":123},{"plain":"bar"}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":null}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":false}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":true}]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '["baz","baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''["baz","baz"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":[{"plain":"bar"},{"plain":123}]}}'\'' <<< '\''[[],[]]'\'''
)

