#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def-gcc:node-closed-array-any2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-closed-array-any2.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }
$ json <<< '\''{"type":"array","args":["type","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["type","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["type","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["type","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["type","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["type","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["type","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["null","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["boolean","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["number","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["string","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["object","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","type"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","null"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","boolean"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","number"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","string"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","object"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};
$ json <<< '\''{"type":"array","args":["array","array"]}'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t* __2[] = {
    &__0,
    &__1,
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__3
};'
) -L node-closed-array-any2.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'1i\\\\\\#include "json-type.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee /dev/fd/2|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'

echo '$ json <<< '\''{"type":"array","args":["type","type"]}'\'''
json <<< '{"type":"array","args":["type","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["type","null"]}'\'''
json <<< '{"type":"array","args":["type","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["type","boolean"]}'\'''
json <<< '{"type":"array","args":["type","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["type","number"]}'\'''
json <<< '{"type":"array","args":["type","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["type","string"]}'\'''
json <<< '{"type":"array","args":["type","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["type","object"]}'\'''
json <<< '{"type":"array","args":["type","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["type","array"]}'\'''
json <<< '{"type":"array","args":["type","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["type","array"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","type"]}'\'''
json <<< '{"type":"array","args":["null","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","null"]}'\'''
json <<< '{"type":"array","args":["null","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","boolean"]}'\'''
json <<< '{"type":"array","args":["null","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","number"]}'\'''
json <<< '{"type":"array","args":["null","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","string"]}'\'''
json <<< '{"type":"array","args":["null","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","object"]}'\'''
json <<< '{"type":"array","args":["null","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["null","array"]}'\'''
json <<< '{"type":"array","args":["null","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["null","array"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","type"]}'\'''
json <<< '{"type":"array","args":["boolean","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","null"]}'\'''
json <<< '{"type":"array","args":["boolean","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","boolean"]}'\'''
json <<< '{"type":"array","args":["boolean","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","number"]}'\'''
json <<< '{"type":"array","args":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","string"]}'\'''
json <<< '{"type":"array","args":["boolean","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","object"]}'\'''
json <<< '{"type":"array","args":["boolean","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["boolean","array"]}'\'''
json <<< '{"type":"array","args":["boolean","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["boolean","array"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","type"]}'\'''
json <<< '{"type":"array","args":["number","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","null"]}'\'''
json <<< '{"type":"array","args":["number","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","boolean"]}'\'''
json <<< '{"type":"array","args":["number","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","number"]}'\'''
json <<< '{"type":"array","args":["number","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","string"]}'\'''
json <<< '{"type":"array","args":["number","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","object"]}'\'''
json <<< '{"type":"array","args":["number","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["number","array"]}'\'''
json <<< '{"type":"array","args":["number","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["number","array"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","type"]}'\'''
json <<< '{"type":"array","args":["string","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","null"]}'\'''
json <<< '{"type":"array","args":["string","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","boolean"]}'\'''
json <<< '{"type":"array","args":["string","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","number"]}'\'''
json <<< '{"type":"array","args":["string","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","string"]}'\'''
json <<< '{"type":"array","args":["string","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","object"]}'\'''
json <<< '{"type":"array","args":["string","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["string","array"]}'\'''
json <<< '{"type":"array","args":["string","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["string","array"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","type"]}'\'''
json <<< '{"type":"array","args":["object","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","null"]}'\'''
json <<< '{"type":"array","args":["object","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","boolean"]}'\'''
json <<< '{"type":"array","args":["object","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","number"]}'\'''
json <<< '{"type":"array","args":["object","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","string"]}'\'''
json <<< '{"type":"array","args":["object","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","object"]}'\'''
json <<< '{"type":"array","args":["object","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["object","array"]}'\'''
json <<< '{"type":"array","args":["object","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["object","array"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","type"]}'\'''
json <<< '{"type":"array","args":["array","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","type"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","null"]}'\'''
json <<< '{"type":"array","args":["array","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","null"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","boolean"]}'\'''
json <<< '{"type":"array","args":["array","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","boolean"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","number"]}'\'''
json <<< '{"type":"array","args":["array","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","number"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","string"]}'\'''
json <<< '{"type":"array","args":["array","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","string"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","object"]}'\'''
json <<< '{"type":"array","args":["array","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","object"]}'\'''

echo '$ json <<< '\''{"type":"array","args":["array","array"]}'\'''
json <<< '{"type":"array","args":["array","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":["array","array"]}'\'''
)

