#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def-gcc:node-list-dict-any
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-list-dict-any.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]}]}'\'''
) -L node-list-dict-any.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'1i\\\\\\#include "json-type.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee /dev/fd/2|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]}]}'\'''
)

