#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:text-type-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L text-type-lib.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json -TA ../lib/test-type.json
[
    {
        "name": "foo",
        "type": "type"
    }
]
$ json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ json -Tv ../lib/test-type.json
$ json -Tc ../lib/test-type.json
$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; }
$ json -Tp ../lib/test-type.json
$ json -Ta ../lib/test-type.json'
) -L text-type-lib.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json -TA ../lib/test-type.json'
json -TA ../lib/test-type.json 2>&1 ||
echo 'command failed: json -TA ../lib/test-type.json'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ json -Tv ../lib/test-type.json'
json -Tv ../lib/test-type.json 2>&1 ||
echo 'command failed: json -Tv ../lib/test-type.json'

echo '$ json -Tc ../lib/test-type.json'
json -Tc ../lib/test-type.json 2>&1 ||
echo 'command failed: json -Tc ../lib/test-type.json'

echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V "$@"|LD_LIBRARY_PATH=../lib ../src/json --parse-only --verbose; }'

echo '$ json -Tp ../lib/test-type.json'
json -Tp ../lib/test-type.json 2>&1 ||
echo 'command failed: json -Tp ../lib/test-type.json'

echo '$ json -Ta ../lib/test-type.json'
json -Ta ../lib/test-type.json 2>&1 ||
echo 'command failed: json -Ta ../lib/test-type.json'
)

