#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:github-text-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L github-text-lib.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ norm() { sed -r '\''/^\/\/|^\s*$/d;s/^#/\\\0/'\'' ${1:+"$1"}; }
$ diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.json|json -P)
$ json -Td libs/github/github.json|norm
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __5[] = {
    {
        .name = (const uchar_t*) "name",
        .type = &__2
    },
    {
        .name = (const uchar_t*) "email",
        .type = &__3
    },
    {
        .name = (const uchar_t*) "date",
        .type = &__4
    }
};
static const struct json_type_node_t __6 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __5,
        .size = 3
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __10[] = {
    {
        .name = (const uchar_t*) "name",
        .type = &__7
    },
    {
        .name = (const uchar_t*) "email",
        .type = &__8
    },
    {
        .name = (const uchar_t*) "date",
        .type = &__9
    }
};
static const struct json_type_node_t __11 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __10,
        .size = 3
    }
};
static const struct json_type_node_t __12 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __13 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __14 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __15[] = {
    {
        .name = (const uchar_t*) "sha",
        .type = &__13
    },
    {
        .name = (const uchar_t*) "url",
        .type = &__14
    }
};
static const struct json_type_node_t __16 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __15,
        .size = 2
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __18 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __19 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __20 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __21 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __22 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __23 = {
    .sym = NULL,
    .VAL = &__21
};
static const struct json_type_trie_node_t __24 = {
    .sym = &__21,
    .EQ = &__23
};
static const struct json_type_trie_node_t __25 = {
    .sym = NULL,
    .VAL = &__22
};
static const struct json_type_trie_node_t __26 = {
    .sym = &__22,
    .lo = &__24,
    .EQ = &__25
};
static const struct json_type_trie_t __27 = {
    .root = &__26
};
static const struct json_type_list_attr_t __28 = {
    .any = &__27
};
static const struct json_type_node_t* __29[] = {
    &__21,
    &__22,
    NULL
};
static const struct json_type_node_t __30 = {
    .type = json_type_list_node_type,
    .attr.list = &__28,
    .node.list = {
        .args = __29,
        .size = 2
    }
};
static const struct json_type_node_t __31 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __32 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_trie_node_t __33 = {
    .sym = NULL,
    .VAL = &__31
};
static const struct json_type_trie_node_t __34 = {
    .sym = &__31,
    .EQ = &__33
};
static const struct json_type_trie_node_t __35 = {
    .sym = NULL,
    .VAL = &__32
};
static const struct json_type_trie_node_t __36 = {
    .sym = &__32,
    .lo = &__34,
    .EQ = &__35
};
static const struct json_type_trie_t __37 = {
    .root = &__36
};
static const struct json_type_list_attr_t __38 = {
    .any = &__37
};
static const struct json_type_node_t* __39[] = {
    &__31,
    &__32,
    NULL
};
static const struct json_type_node_t __40 = {
    .type = json_type_list_node_type,
    .attr.list = &__38,
    .node.list = {
        .args = __39,
        .size = 2
    }
};
static const struct json_type_object_node_arg_t __41[] = {
    {
        .name = (const uchar_t*) "verified",
        .type = &__19
    },
    {
        .name = (const uchar_t*) "reason",
        .type = &__20
    },
    {
        .name = (const uchar_t*) "signature",
        .type = &__30
    },
    {
        .name = (const uchar_t*) "payload",
        .type = &__40
    }
};
static const struct json_type_node_t __42 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __41,
        .size = 4
    }
};
static const struct json_type_object_node_arg_t __43[] = {
    {
        .name = (const uchar_t*) "author",
        .type = &__6
    },
    {
        .name = (const uchar_t*) "committer",
        .type = &__11
    },
    {
        .name = (const uchar_t*) "message",
        .type = &__12
    },
    {
        .name = (const uchar_t*) "tree",
        .type = &__16
    },
    {
        .name = (const uchar_t*) "url",
        .type = &__17
    },
    {
        .name = (const uchar_t*) "comment_count",
        .type = &__18
    },
    {
        .name = (const uchar_t*) "verification",
        .type = &__42
    }
};
static const struct json_type_node_t __44 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __43,
        .size = 7
    }
};
static const struct json_type_node_t __45 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __46 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __47 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __48 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __49 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __50 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __51 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __52 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __53 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __54 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __55 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __56 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __57 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __58 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __59 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __60 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __61 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __62 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __63 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __64 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __65 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __66 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __67 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __68[] = {
    {
        .name = (const uchar_t*) "login",
        .type = &__50
    },
    {
        .name = (const uchar_t*) "id",
        .type = &__51
    },
    {
        .name = (const uchar_t*) "node_id",
        .type = &__52
    },
    {
        .name = (const uchar_t*) "avatar_url",
        .type = &__53
    },
    {
        .name = (const uchar_t*) "gravatar_id",
        .type = &__54
    },
    {
        .name = (const uchar_t*) "url",
        .type = &__55
    },
    {
        .name = (const uchar_t*) "html_url",
        .type = &__56
    },
    {
        .name = (const uchar_t*) "followers_url",
        .type = &__57
    },
    {
        .name = (const uchar_t*) "following_url",
        .type = &__58
    },
    {
        .name = (const uchar_t*) "gists_url",
        .type = &__59
    },
    {
        .name = (const uchar_t*) "starred_url",
        .type = &__60
    },
    {
        .name = (const uchar_t*) "subscriptions_url",
        .type = &__61
    },
    {
        .name = (const uchar_t*) "organizations_url",
        .type = &__62
    },
    {
        .name = (const uchar_t*) "repos_url",
        .type = &__63
    },
    {
        .name = (const uchar_t*) "events_url",
        .type = &__64
    },
    {
        .name = (const uchar_t*) "received_events_url",
        .type = &__65
    },
    {
        .name = (const uchar_t*) "type",
        .type = &__66
    },
    {
        .name = (const uchar_t*) "site_admin",
        .type = &__67
    }
};
static const struct json_type_node_t __69 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __68,
        .size = 18
    }
};
static const struct json_type_trie_node_t __70 = {
    .sym = NULL,
    .VAL = &__48
};
static const struct json_type_trie_node_t __71 = {
    .sym = &__48,
    .EQ = &__70
};
static const struct json_type_trie_node_t __72 = {
    .sym = NULL,
    .VAL = &__49
};
static const struct json_type_trie_node_t __73 = {
    .sym = &__49,
    .lo = &__71,
    .EQ = &__72
};
static const struct json_type_trie_t __74 = {
    .root = &__73
};
static const struct json_type_object_trie_node_t __75 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__69
};
static const struct json_type_object_trie_node_t __76 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__67
    },
    .EQ = &__75
};
static const struct json_type_object_trie_node_t __77 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "site_admin"
    },
    .EQ = &__76
};
static const struct json_type_object_trie_node_t __78 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__66
    },
    .EQ = &__77
};
static const struct json_type_object_trie_node_t __79 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "type"
    },
    .EQ = &__78
};
static const struct json_type_object_trie_node_t __80 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__65
    },
    .EQ = &__79
};
static const struct json_type_object_trie_node_t __81 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "received_events_url"
    },
    .EQ = &__80
};
static const struct json_type_object_trie_node_t __82 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__64
    },
    .EQ = &__81
};
static const struct json_type_object_trie_node_t __83 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "events_url"
    },
    .EQ = &__82
};
static const struct json_type_object_trie_node_t __84 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__63
    },
    .EQ = &__83
};
static const struct json_type_object_trie_node_t __85 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "repos_url"
    },
    .EQ = &__84
};
static const struct json_type_object_trie_node_t __86 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__62
    },
    .EQ = &__85
};
static const struct json_type_object_trie_node_t __87 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "organizations_url"
    },
    .EQ = &__86
};
static const struct json_type_object_trie_node_t __88 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__61
    },
    .EQ = &__87
};
static const struct json_type_object_trie_node_t __89 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "subscriptions_url"
    },
    .EQ = &__88
};
static const struct json_type_object_trie_node_t __90 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__60
    },
    .EQ = &__89
};
static const struct json_type_object_trie_node_t __91 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "starred_url"
    },
    .EQ = &__90
};
static const struct json_type_object_trie_node_t __92 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__59
    },
    .EQ = &__91
};
static const struct json_type_object_trie_node_t __93 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "gists_url"
    },
    .EQ = &__92
};
static const struct json_type_object_trie_node_t __94 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__58
    },
    .EQ = &__93
};
static const struct json_type_object_trie_node_t __95 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "following_url"
    },
    .EQ = &__94
};
static const struct json_type_object_trie_node_t __96 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__57
    },
    .EQ = &__95
};
static const struct json_type_object_trie_node_t __97 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "followers_url"
    },
    .EQ = &__96
};
static const struct json_type_object_trie_node_t __98 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__56
    },
    .EQ = &__97
};
static const struct json_type_object_trie_node_t __99 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "html_url"
    },
    .EQ = &__98
};
static const struct json_type_object_trie_node_t __100 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__55
    },
    .EQ = &__99
};
static const struct json_type_object_trie_node_t __101 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "url"
    },
    .EQ = &__100
};
static const struct json_type_object_trie_node_t __102 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__54
    },
    .EQ = &__101
};
static const struct json_type_object_trie_node_t __103 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "gravatar_id"
    },
    .EQ = &__102
};
static const struct json_type_object_trie_node_t __104 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__53
    },
    .EQ = &__103
};
static const struct json_type_object_trie_node_t __105 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "avatar_url"
    },
    .EQ = &__104
};
static const struct json_type_object_trie_node_t __106 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__52
    },
    .EQ = &__105
};
static const struct json_type_object_trie_node_t __107 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "node_id"
    },
    .EQ = &__106
};
static const struct json_type_object_trie_node_t __108 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__51
    },
    .EQ = &__107
};
static const struct json_type_object_trie_node_t __109 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "id"
    },
    .EQ = &__108
};
static const struct json_type_object_trie_node_t __110 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__50
    },
    .EQ = &__109
};
static const struct json_type_object_trie_node_t __111 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "login"
    },
    .EQ = &__110
};
static const struct json_type_object_trie_t __112 = {
    .root = &__111
};
static const struct json_type_list_attr_t __113 = {
    .any = &__74,
    .object = &__112
};
static const struct json_type_node_t* __114[] = {
    &__48,
    &__49,
    &__69,
    NULL
};
static const struct json_type_node_t __115 = {
    .type = json_type_list_node_type,
    .attr.list = &__113,
    .node.list = {
        .args = __114,
        .size = 3
    }
};
static const struct json_type_node_t __116 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __117 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __118 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __119 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __120 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __121 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __122 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __123 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __124 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __125 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __126 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __127 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __128 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __129 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __130 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __131 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __132 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __133 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __134 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __135 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_object_node_arg_t __136[] = {
    {
        .name = (const uchar_t*) "login",
        .type = &__118
    },
    {
        .name = (const uchar_t*) "id",
        .type = &__119
    },
    {
        .name = (const uchar_t*) "node_id",
        .type = &__120
    },
    {
        .name = (const uchar_t*) "avatar_url",
        .type = &__121
    },
    {
        .name = (const uchar_t*) "gravatar_id",
        .type = &__122
    },
    {
        .name = (const uchar_t*) "url",
        .type = &__123
    },
    {
        .name = (const uchar_t*) "html_url",
        .type = &__124
    },
    {
        .name = (const uchar_t*) "followers_url",
        .type = &__125
    },
    {
        .name = (const uchar_t*) "following_url",
        .type = &__126
    },
    {
        .name = (const uchar_t*) "gists_url",
        .type = &__127
    },
    {
        .name = (const uchar_t*) "starred_url",
        .type = &__128
    },
    {
        .name = (const uchar_t*) "subscriptions_url",
        .type = &__129
    },
    {
        .name = (const uchar_t*) "organizations_url",
        .type = &__130
    },
    {
        .name = (const uchar_t*) "repos_url",
        .type = &__131
    },
    {
        .name = (const uchar_t*) "events_url",
        .type = &__132
    },
    {
        .name = (const uchar_t*) "received_events_url",
        .type = &__133
    },
    {
        .name = (const uchar_t*) "type",
        .type = &__134
    },
    {
        .name = (const uchar_t*) "site_admin",
        .type = &__135
    }
};
static const struct json_type_node_t __137 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __136,
        .size = 18
    }
};
static const struct json_type_trie_node_t __138 = {
    .sym = NULL,
    .VAL = &__116
};
static const struct json_type_trie_node_t __139 = {
    .sym = &__116,
    .EQ = &__138
};
static const struct json_type_trie_node_t __140 = {
    .sym = NULL,
    .VAL = &__117
};
static const struct json_type_trie_node_t __141 = {
    .sym = &__117,
    .lo = &__139,
    .EQ = &__140
};
static const struct json_type_trie_t __142 = {
    .root = &__141
};
static const struct json_type_object_trie_node_t __143 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__137
};
static const struct json_type_object_trie_node_t __144 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__135
    },
    .EQ = &__143
};
static const struct json_type_object_trie_node_t __145 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "site_admin"
    },
    .EQ = &__144
};
static const struct json_type_object_trie_node_t __146 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__134
    },
    .EQ = &__145
};
static const struct json_type_object_trie_node_t __147 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "type"
    },
    .EQ = &__146
};
static const struct json_type_object_trie_node_t __148 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__133
    },
    .EQ = &__147
};
static const struct json_type_object_trie_node_t __149 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "received_events_url"
    },
    .EQ = &__148
};
static const struct json_type_object_trie_node_t __150 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__132
    },
    .EQ = &__149
};
static const struct json_type_object_trie_node_t __151 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "events_url"
    },
    .EQ = &__150
};
static const struct json_type_object_trie_node_t __152 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__131
    },
    .EQ = &__151
};
static const struct json_type_object_trie_node_t __153 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "repos_url"
    },
    .EQ = &__152
};
static const struct json_type_object_trie_node_t __154 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__130
    },
    .EQ = &__153
};
static const struct json_type_object_trie_node_t __155 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "organizations_url"
    },
    .EQ = &__154
};
static const struct json_type_object_trie_node_t __156 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__129
    },
    .EQ = &__155
};
static const struct json_type_object_trie_node_t __157 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "subscriptions_url"
    },
    .EQ = &__156
};
static const struct json_type_object_trie_node_t __158 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__128
    },
    .EQ = &__157
};
static const struct json_type_object_trie_node_t __159 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "starred_url"
    },
    .EQ = &__158
};
static const struct json_type_object_trie_node_t __160 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__127
    },
    .EQ = &__159
};
static const struct json_type_object_trie_node_t __161 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "gists_url"
    },
    .EQ = &__160
};
static const struct json_type_object_trie_node_t __162 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__126
    },
    .EQ = &__161
};
static const struct json_type_object_trie_node_t __163 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "following_url"
    },
    .EQ = &__162
};
static const struct json_type_object_trie_node_t __164 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__125
    },
    .EQ = &__163
};
static const struct json_type_object_trie_node_t __165 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "followers_url"
    },
    .EQ = &__164
};
static const struct json_type_object_trie_node_t __166 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__124
    },
    .EQ = &__165
};
static const struct json_type_object_trie_node_t __167 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "html_url"
    },
    .EQ = &__166
};
static const struct json_type_object_trie_node_t __168 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__123
    },
    .EQ = &__167
};
static const struct json_type_object_trie_node_t __169 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "url"
    },
    .EQ = &__168
};
static const struct json_type_object_trie_node_t __170 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__122
    },
    .EQ = &__169
};
static const struct json_type_object_trie_node_t __171 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "gravatar_id"
    },
    .EQ = &__170
};
static const struct json_type_object_trie_node_t __172 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__121
    },
    .EQ = &__171
};
static const struct json_type_object_trie_node_t __173 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "avatar_url"
    },
    .EQ = &__172
};
static const struct json_type_object_trie_node_t __174 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__120
    },
    .EQ = &__173
};
static const struct json_type_object_trie_node_t __175 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "node_id"
    },
    .EQ = &__174
};
static const struct json_type_object_trie_node_t __176 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__119
    },
    .EQ = &__175
};
static const struct json_type_object_trie_node_t __177 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "id"
    },
    .EQ = &__176
};
static const struct json_type_object_trie_node_t __178 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__118
    },
    .EQ = &__177
};
static const struct json_type_object_trie_node_t __179 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "login"
    },
    .EQ = &__178
};
static const struct json_type_object_trie_t __180 = {
    .root = &__179
};
static const struct json_type_list_attr_t __181 = {
    .any = &__142,
    .object = &__180
};
static const struct json_type_node_t* __182[] = {
    &__116,
    &__117,
    &__137,
    NULL
};
static const struct json_type_node_t __183 = {
    .type = json_type_list_node_type,
    .attr.list = &__181,
    .node.list = {
        .args = __182,
        .size = 3
    }
};
static const struct json_type_node_t __184 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __185 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __186 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_object_node_arg_t __187[] = {
    {
        .name = (const uchar_t*) "sha",
        .type = &__184
    },
    {
        .name = (const uchar_t*) "url",
        .type = &__185
    },
    {
        .name = (const uchar_t*) "html_url",
        .type = &__186
    }
};
static const struct json_type_node_t __188 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __187,
        .size = 3
    }
};
static const struct json_type_node_t __189 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__188
    }
};
static const struct json_type_object_node_arg_t __190[] = {
    {
        .name = (const uchar_t*) "sha",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "node_id",
        .type = &__1
    },
    {
        .name = (const uchar_t*) "commit",
        .type = &__44
    },
    {
        .name = (const uchar_t*) "url",
        .type = &__45
    },
    {
        .name = (const uchar_t*) "html_url",
        .type = &__46
    },
    {
        .name = (const uchar_t*) "comments_url",
        .type = &__47
    },
    {
        .name = (const uchar_t*) "author",
        .type = &__115
    },
    {
        .name = (const uchar_t*) "committer",
        .type = &__183
    },
    {
        .name = (const uchar_t*) "parents",
        .type = &__189
    }
};
static const struct json_type_node_t __191 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __190,
        .size = 9
    }
};
static const struct json_type_node_t __192 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__191
    }
};
static const struct json_type_defs_arg_t __193[] = {
    {
        .name = (const uchar_t*) "commits",
        .type = &__192
    }
};
static const struct json_type_defs_t __194 = {
    .args = __193,
    .size = 1
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__194
};
$ json -Tv libs/github/github.json
$ json -Tc libs/github/github.json'
) -L github-text-lib.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ norm() { sed -r '\''/^\/\/|^\s*$/d;s/^#/\\\0/'\'' ${1:+"$1"}; }'
norm() { sed -r '/^\/\/|^\s*$/d;s/^#/\\\0/' ${1:+"$1"}; } 2>&1 ||
echo 'command failed: norm() { sed -r '\''/^\/\/|^\s*$/d;s/^#/\\\0/'\'' ${1:+"$1"}; }'

echo '$ diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.json|json -P)'
diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.json|json -P) 2>&1 ||
echo 'command failed: diff -u -Ljson <(json -P libs/github/github.json) -Llib <(json -Tp libs/github/github.json|json -P)'

echo '$ json -Td libs/github/github.json|norm'
json -Td libs/github/github.json|norm 2>&1 ||
echo 'command failed: json -Td libs/github/github.json|norm'

echo '$ json -Tv libs/github/github.json'
json -Tv libs/github/github.json 2>&1 ||
echo 'command failed: json -Tv libs/github/github.json'

echo '$ json -Tc libs/github/github.json'
json -Tc libs/github/github.json 2>&1 ||
echo 'command failed: json -Tc libs/github/github.json'
)

