#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:github-text-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L github-text-lib.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; }
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }
$ norm() { sed -r '\''/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/'\'' ${1:+"$1"}; }
$ diff -u -Ljson <(json -P libs/github-litex/github-litex.json) -Llib <(json-litex -P libs/github-litex/github-litex.json|json -P)
$ json-litex -D libs/github-litex/github-litex.json|norm
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
    . . .
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "^[0-9a-f]{40}$"
    },
    {
        .text = (const uchar_t*) "^[a-z0-9]{78}[a-z0-9=]{2}$",
        .opts = I
    },
    {
        .text = (const uchar_t*) "^[[:print:]\\p{L}]+$",
        .opts = I
    },
    {
        .text = (const uchar_t*) "^[[:print:]]*[a-z0-9._-]+@[a-z0-9._-]+$|^\\(no_default\\)$",
        .opts = I
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/repos/gcc-mirror/gcc/git/trees/[0-9a-f]{40}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/repos/gcc-mirror/gcc/git/commits/[0-9a-f]{40}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/repos/gcc-mirror/gcc/commits/[0-9a-f]{40}$"
    },
    {
        .text = (const uchar_t*) "^https://github\\.com/gcc-mirror/gcc/commit/[0-9a-f]{40}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/repos/gcc-mirror/gcc/commits/[0-9a-f]{40}/comments$"
    },
    {
        .text = (const uchar_t*) "^[a-z0-9_-]+$",
        .opts = I
    },
    {
        .text = (const uchar_t*) "^[a-z0-9]{14,}[a-z0-9=]{2}$",
        .opts = I
    },
    {
        .text = (const uchar_t*) "^https://avatars\\d+\\.githubusercontent\\.com/u/\\d+\\?v=\\d+$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+$"
    },
    {
        .text = (const uchar_t*) "^https://github\\.com/[a-zA-Z0-9_-]+$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/followers$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/following\\{/other_user\\}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/gists\\{/gist_id\\}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/starred\\{/owner\\}\\{/repo\\}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/subscriptions$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/orgs$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/repos$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/events\\{/privacy\\}$"
    },
    {
        .text = (const uchar_t*) "^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/received_events$"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 6976
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 23
};
static const struct json_litex_object_node_arg_t __174[];
static const struct json_litex_node_t __175;
static const struct json_litex_object_node_arg_t __170[];
static const struct json_litex_node_t __171;
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[0-9a-f]{40}$/"
    },
    .attr.string = &__4,
    .path = __170 + 0,
    .parent = &__171
};
static const struct json_litex_expr_node_t __6[] = {
    match_rex(1)
};
static const struct json_litex_expr_def_t __7 = {
    .nodes = __6,
    .size = 1
};
static const struct json_litex_node_t __8 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[a-z0-9]{78}[a-z0-9=]{2}$/I"
    },
    .attr.string = &__7,
    .path = __170 + 1,
    .parent = &__171
};
static const struct json_litex_object_node_arg_t __62[];
static const struct json_litex_node_t __63;
static const struct json_litex_object_node_arg_t __20[];
static const struct json_litex_node_t __21;
static const struct json_litex_expr_node_t __9[] = {
    match_rex(2)
};
static const struct json_litex_expr_def_t __10 = {
    .nodes = __9,
    .size = 1
};
static const struct json_litex_node_t __11 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[[:print:]\\p{L}]+$/I"
    },
    .attr.string = &__10,
    .path = __20 + 0,
    .parent = &__21
};
static const struct json_litex_expr_node_t __12[] = {
    match_rex(3)
};
static const struct json_litex_expr_def_t __13 = {
    .nodes = __12,
    .size = 1
};
static const struct json_litex_node_t __14 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[[:print:]]*[a-z0-9._-]+@[a-z0-9._-]+$|^\\(no_default\\)$/I"
    },
    .attr.string = &__13,
    .path = __20 + 1,
    .parent = &__21
};
static const struct json_litex_expr_node_t __15[] = {
    const_str("%FT%TZ"),
    call_builtin(date)
};
static const struct json_litex_expr_def_t __16 = {
    .nodes = __15,
    .size = 2
};
static const struct json_litex_node_t __17 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "date(`%FT%TZ`)"
    },
    .attr.string = &__16,
    .path = __20 + 2,
    .parent = &__21
};
static inline bool equal(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == *q;
}
static const struct json_litex_node_t* __18(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''d'\'':
        if (equal(p, "ate"))
            return &__17;
        return NULL;
    case '\''e'\'':
        if (equal(p, "mail"))
            return &__14;
        return NULL;
    case '\''n'\'':
        if (equal(p, "ame"))
            return &__11;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __19 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __18
};
static const struct json_litex_object_node_arg_t __20[] = {
    {
        .key = {
            .val = (const uchar_t*) "name"
        },
        .val = &__11
    },
    {
        .key = {
            .val = (const uchar_t*) "email"
        },
        .val = &__14
    },
    {
        .key = {
            .val = (const uchar_t*) "date"
        },
        .val = &__17
    }
};
static const struct json_litex_node_t __21 = {
    .type = json_litex_object_node_type,
    .attr.object = &__19,
    .node.object = {
        .args = __20,
        .size = 3
    },
    .path = __62 + 0,
    .parent = &__63
};
static const struct json_litex_object_node_arg_t __27[];
static const struct json_litex_node_t __28;
static const struct json_litex_node_t __22 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[[:print:]\\p{L}]+$/I"
    },
    .attr.string = &__10,
    .path = __27 + 0,
    .parent = &__28
};
static const struct json_litex_node_t __23 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[[:print:]]*[a-z0-9._-]+@[a-z0-9._-]+$|^\\(no_default\\)$/I"
    },
    .attr.string = &__13,
    .path = __27 + 1,
    .parent = &__28
};
static const struct json_litex_node_t __24 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "date(`%FT%TZ`)"
    },
    .attr.string = &__16,
    .path = __27 + 2,
    .parent = &__28
};
static const struct json_litex_node_t* __25(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''d'\'':
        if (equal(p, "ate"))
            return &__24;
        return NULL;
    case '\''e'\'':
        if (equal(p, "mail"))
            return &__23;
        return NULL;
    case '\''n'\'':
        if (equal(p, "ame"))
            return &__22;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __26 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __25
};
static const struct json_litex_object_node_arg_t __27[] = {
    {
        .key = {
            .val = (const uchar_t*) "name"
        },
        .val = &__22
    },
    {
        .key = {
            .val = (const uchar_t*) "email"
        },
        .val = &__23
    },
    {
        .key = {
            .val = (const uchar_t*) "date"
        },
        .val = &__24
    }
};
static const struct json_litex_node_t __28 = {
    .type = json_litex_object_node_type,
    .attr.object = &__26,
    .node.object = {
        .args = __27,
        .size = 3
    },
    .path = __62 + 1,
    .parent = &__63
};
static const struct json_litex_expr_node_t __29[] = {
    call_builtin(string)
};
static const struct json_litex_expr_def_t __30 = {
    .nodes = __29,
    .size = 1
};
static const struct json_litex_node_t __31 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "string"
    },
    .attr.string = &__30,
    .path = __62 + 2,
    .parent = &__63
};
static const struct json_litex_object_node_arg_t __38[];
static const struct json_litex_node_t __39;
static const struct json_litex_node_t __32 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[0-9a-f]{40}$/"
    },
    .attr.string = &__4,
    .path = __38 + 0,
    .parent = &__39
};
static const struct json_litex_expr_node_t __33[] = {
    match_rex(4)
};
static const struct json_litex_expr_def_t __34 = {
    .nodes = __33,
    .size = 1
};
static const struct json_litex_node_t __35 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/repos/gcc-mirror/gcc/git/trees/[0-9a-f]{40}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__34,
    .path = __38 + 1,
    .parent = &__39
};
static const struct json_litex_node_t* __36(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''s'\'':
        if (equal(p, "ha"))
            return &__32;
        return NULL;
    case '\''u'\'':
        if (equal(p, "rl"))
            return &__35;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __37 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __36
};
static const struct json_litex_object_node_arg_t __38[] = {
    {
        .key = {
            .val = (const uchar_t*) "sha"
        },
        .val = &__32
    },
    {
        .key = {
            .val = (const uchar_t*) "url"
        },
        .val = &__35
    }
};
static const struct json_litex_node_t __39 = {
    .type = json_litex_object_node_type,
    .attr.object = &__37,
    .node.object = {
        .args = __38,
        .size = 2
    },
    .path = __62 + 3,
    .parent = &__63
};
static const struct json_litex_expr_node_t __40[] = {
    match_rex(5)
};
static const struct json_litex_expr_def_t __41 = {
    .nodes = __40,
    .size = 1
};
static const struct json_litex_node_t __42 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t'\''^https://api\\.github\\.com/repos/gcc-mirror/gcc/git/commits/[0-9a-f]{40}$'\''\n\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__41,
    .path = __62 + 4,
    .parent = &__63
};
static const struct json_litex_expr_node_t __43[] = {
    const_num(8),
    call_builtin(uint)
};
static const struct json_litex_expr_def_t __44 = {
    .nodes = __43,
    .size = 2
};
static const struct json_litex_node_t __45 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "uint(8)"
    },
    .attr.string = &__44,
    .path = __62 + 5,
    .parent = &__63
};
static const struct json_litex_object_node_arg_t __58[];
static const struct json_litex_node_t __59;
static const struct json_litex_expr_node_t __46[] = {
    call_builtin(boolean)
};
static const struct json_litex_expr_def_t __47 = {
    .nodes = __46,
    .size = 1
};
static const struct json_litex_node_t __48 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "bool"
    },
    .attr.string = &__47,
    .path = __58 + 0,
    .parent = &__59
};
static const struct json_litex_expr_node_t __49[] = {
    match_str("unsigned"),
    jump_true(4, false),
    match_str("valid"),
    jump_true(2, false),
    match_str("unknown_key")
};
static const struct json_litex_expr_def_t __50 = {
    .nodes = __49,
    .size = 5
};
static const struct json_litex_node_t __51 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`unsigned`||`valid`||`unknown_key`"
    },
    .attr.string = &__50,
    .path = __58 + 1,
    .parent = &__59
};
static const struct json_litex_expr_node_t __52[] = {
    call_builtin(null),
    jump_true(4, false),
    call_builtin(len),
    const_num(0),
    cmp_op(gt)
};
static const struct json_litex_expr_def_t __53 = {
    .nodes = __52,
    .size = 5
};
static const struct json_litex_node_t __54 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null || len > 0"
    },
    .attr.string = &__53,
    .path = __58 + 2,
    .parent = &__59
};
static const struct json_litex_node_t __55 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null || len > 0"
    },
    .attr.string = &__53,
    .path = __58 + 3,
    .parent = &__59
};
static const struct json_litex_node_t* __56(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''p'\'':
        if (equal(p, "ayload"))
            return &__55;
        return NULL;
    case '\''r'\'':
        if (equal(p, "eason"))
            return &__51;
        return NULL;
    case '\''s'\'':
        if (equal(p, "ignature"))
            return &__54;
        return NULL;
    case '\''v'\'':
        if (equal(p, "erified"))
            return &__48;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __57 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __56
};
static const struct json_litex_object_node_arg_t __58[] = {
    {
        .key = {
            .val = (const uchar_t*) "verified"
        },
        .val = &__48
    },
    {
        .key = {
            .val = (const uchar_t*) "reason"
        },
        .val = &__51
    },
    {
        .key = {
            .val = (const uchar_t*) "signature"
        },
        .val = &__54
    },
    {
        .key = {
            .val = (const uchar_t*) "payload"
        },
        .val = &__55
    }
};
static const struct json_litex_node_t __59 = {
    .type = json_litex_object_node_type,
    .attr.object = &__57,
    .node.object = {
        .args = __58,
        .size = 4
    },
    .path = __62 + 6,
    .parent = &__63
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __60(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''a'\'':
        if (equal(p, "uthor"))
            return &__21;
        return NULL;
    case '\''c'\'':
        if (prefix("omm", p)) {
            p += 3;
            switch (*p ++) {
            case '\''e'\'':
                if (equal(p, "nt_count"))
                    return &__45;
                return NULL;
            case '\''i'\'':
                if (equal(p, "tter"))
                    return &__28;
            }
        }
        return NULL;
    case '\''m'\'':
        if (equal(p, "essage"))
            return &__31;
        return NULL;
    case '\''t'\'':
        if (equal(p, "ree"))
            return &__39;
        return NULL;
    case '\''u'\'':
        if (equal(p, "rl"))
            return &__42;
        return NULL;
    case '\''v'\'':
        if (equal(p, "erification"))
            return &__59;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __61 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __60
};
static const struct json_litex_object_node_arg_t __62[] = {
    {
        .key = {
            .val = (const uchar_t*) "author"
        },
        .val = &__21
    },
    {
        .key = {
            .val = (const uchar_t*) "committer"
        },
        .val = &__28
    },
    {
        .key = {
            .val = (const uchar_t*) "message"
        },
        .val = &__31
    },
    {
        .key = {
            .val = (const uchar_t*) "tree"
        },
        .val = &__39
    },
    {
        .key = {
            .val = (const uchar_t*) "url"
        },
        .val = &__42
    },
    {
        .key = {
            .val = (const uchar_t*) "comment_count"
        },
        .val = &__45
    },
    {
        .key = {
            .val = (const uchar_t*) "verification"
        },
        .val = &__59
    }
};
static const struct json_litex_node_t __63 = {
    .type = json_litex_object_node_type,
    .attr.object = &__61,
    .node.object = {
        .args = __62,
        .size = 7
    },
    .path = __170 + 2,
    .parent = &__171
};
static const struct json_litex_expr_node_t __64[] = {
    match_rex(6)
};
static const struct json_litex_expr_def_t __65 = {
    .nodes = __64,
    .size = 1
};
static const struct json_litex_node_t __66 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t'\''^https://api\\.github\\.com/repos/gcc-mirror/gcc/commits/[0-9a-f]{40}$'\''\n\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__65,
    .path = __170 + 3,
    .parent = &__171
};
static const struct json_litex_expr_node_t __67[] = {
    match_rex(7)
};
static const struct json_litex_expr_def_t __68 = {
    .nodes = __67,
    .size = 1
};
static const struct json_litex_node_t __69 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t'\''^https://github\\.com/gcc-mirror/gcc/commit/[0-9a-f]{40}$'\''\n\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__68,
    .path = __170 + 4,
    .parent = &__171
};
static const struct json_litex_expr_node_t __70[] = {
    match_rex(8)
};
static const struct json_litex_expr_def_t __71 = {
    .nodes = __70,
    .size = 1
};
static const struct json_litex_node_t __72 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t'\''^https://api\\.github\\.com/repos/gcc-mirror/gcc/commits/[0-9a-f]{40}/comments$'\''\n\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__71,
    .path = __170 + 5,
    .parent = &__171
};
static const struct json_litex_node_t __134;
static const struct json_litex_object_node_arg_t __127[];
static const struct json_litex_node_t __128;
static const struct json_litex_expr_node_t __73[] = {
    match_rex(9)
};
static const struct json_litex_expr_def_t __74 = {
    .nodes = __73,
    .size = 1
};
static const struct json_litex_node_t __75 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[a-z0-9_-]+$/I"
    },
    .attr.string = &__74,
    .path = __127 + 0,
    .parent = &__128
};
static const struct json_litex_expr_node_t __76[] = {
    const_num(32),
    call_builtin(uint)
};
static const struct json_litex_expr_def_t __77 = {
    .nodes = __76,
    .size = 2
};
static const struct json_litex_node_t __78 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "uint(32)"
    },
    .attr.string = &__77,
    .path = __127 + 1,
    .parent = &__128
};
static const struct json_litex_expr_node_t __79[] = {
    match_rex(10)
};
static const struct json_litex_expr_def_t __80 = {
    .nodes = __79,
    .size = 1
};
static const struct json_litex_node_t __81 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[a-z0-9]{14,}[a-z0-9=]{2}$/I"
    },
    .attr.string = &__80,
    .path = __127 + 2,
    .parent = &__128
};
static const struct json_litex_expr_node_t __82[] = {
    match_rex(11)
};
static const struct json_litex_expr_def_t __83 = {
    .nodes = __82,
    .size = 1
};
static const struct json_litex_node_t __84 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://avatars\\d+\\.githubusercontent\\.com/u/\\d+\\?v=\\d+$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__83,
    .path = __127 + 3,
    .parent = &__128
};
static const struct json_litex_expr_node_t __85[] = {
    call_builtin(string),
    jump_false(4, false),
    call_builtin(len),
    const_num(0),
    cmp_op(eq)
};
static const struct json_litex_expr_def_t __86 = {
    .nodes = __85,
    .size = 5
};
static const struct json_litex_node_t __87 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "string && len == 0"
    },
    .attr.string = &__86,
    .path = __127 + 4,
    .parent = &__128
};
static const struct json_litex_expr_node_t __88[] = {
    match_rex(12)
};
static const struct json_litex_expr_def_t __89 = {
    .nodes = __88,
    .size = 1
};
static const struct json_litex_node_t __90 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__89,
    .path = __127 + 5,
    .parent = &__128
};
static const struct json_litex_expr_node_t __91[] = {
    match_rex(13)
};
static const struct json_litex_expr_def_t __92 = {
    .nodes = __91,
    .size = 1
};
static const struct json_litex_node_t __93 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://github\\.com/[a-zA-Z0-9_-]+$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__92,
    .path = __127 + 6,
    .parent = &__128
};
static const struct json_litex_expr_node_t __94[] = {
    match_rex(14)
};
static const struct json_litex_expr_def_t __95 = {
    .nodes = __94,
    .size = 1
};
static const struct json_litex_node_t __96 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/followers$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__95,
    .path = __127 + 7,
    .parent = &__128
};
static const struct json_litex_expr_node_t __97[] = {
    match_rex(15)
};
static const struct json_litex_expr_def_t __98 = {
    .nodes = __97,
    .size = 1
};
static const struct json_litex_node_t __99 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/following\\{/other_user\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__98,
    .path = __127 + 8,
    .parent = &__128
};
static const struct json_litex_expr_node_t __100[] = {
    match_rex(16)
};
static const struct json_litex_expr_def_t __101 = {
    .nodes = __100,
    .size = 1
};
static const struct json_litex_node_t __102 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/gists\\{/gist_id\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__101,
    .path = __127 + 9,
    .parent = &__128
};
static const struct json_litex_expr_node_t __103[] = {
    match_rex(17)
};
static const struct json_litex_expr_def_t __104 = {
    .nodes = __103,
    .size = 1
};
static const struct json_litex_node_t __105 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/starred\\{/owner\\}\\{/repo\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__104,
    .path = __127 + 10,
    .parent = &__128
};
static const struct json_litex_expr_node_t __106[] = {
    match_rex(18)
};
static const struct json_litex_expr_def_t __107 = {
    .nodes = __106,
    .size = 1
};
static const struct json_litex_node_t __108 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/subscriptions$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__107,
    .path = __127 + 11,
    .parent = &__128
};
static const struct json_litex_expr_node_t __109[] = {
    match_rex(19)
};
static const struct json_litex_expr_def_t __110 = {
    .nodes = __109,
    .size = 1
};
static const struct json_litex_node_t __111 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/orgs$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__110,
    .path = __127 + 12,
    .parent = &__128
};
static const struct json_litex_expr_node_t __112[] = {
    match_rex(20)
};
static const struct json_litex_expr_def_t __113 = {
    .nodes = __112,
    .size = 1
};
static const struct json_litex_node_t __114 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/repos$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__113,
    .path = __127 + 13,
    .parent = &__128
};
static const struct json_litex_expr_node_t __115[] = {
    match_rex(21)
};
static const struct json_litex_expr_def_t __116 = {
    .nodes = __115,
    .size = 1
};
static const struct json_litex_node_t __117 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/events\\{/privacy\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__116,
    .path = __127 + 14,
    .parent = &__128
};
static const struct json_litex_expr_node_t __118[] = {
    match_rex(22)
};
static const struct json_litex_expr_def_t __119 = {
    .nodes = __118,
    .size = 1
};
static const struct json_litex_node_t __120 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/received_events$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__119,
    .path = __127 + 15,
    .parent = &__128
};
static const struct json_litex_expr_node_t __121[] = {
    match_str("User")
};
static const struct json_litex_expr_def_t __122 = {
    .nodes = __121,
    .size = 1
};
static const struct json_litex_node_t __123 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`User`"
    },
    .attr.string = &__122,
    .path = __127 + 16,
    .parent = &__128
};
static const struct json_litex_node_t __124 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "bool"
    },
    .attr.string = &__47,
    .path = __127 + 17,
    .parent = &__128
};
static const struct json_litex_node_t* __125(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''a'\'':
        if (equal(p, "vatar_url"))
            return &__84;
        return NULL;
    case '\''e'\'':
        if (equal(p, "vents_url"))
            return &__117;
        return NULL;
    case '\''f'\'':
        if (prefix("ollow", p)) {
            p += 5;
            switch (*p ++) {
            case '\''e'\'':
                if (equal(p, "rs_url"))
                    return &__96;
                return NULL;
            case '\''i'\'':
                if (equal(p, "ng_url"))
                    return &__99;
            }
        }
        return NULL;
    case '\''g'\'':
        switch (*p ++) {
        case '\''i'\'':
            if (equal(p, "sts_url"))
                return &__102;
            return NULL;
        case '\''r'\'':
            if (equal(p, "avatar_id"))
                return &__87;
        }
        return NULL;
    case '\''h'\'':
        if (equal(p, "tml_url"))
            return &__93;
        return NULL;
    case '\''i'\'':
        if (*p ++ == '\''d'\'' &&
            *p == 0)
            return &__78;
        return NULL;
    case '\''l'\'':
        if (equal(p, "ogin"))
            return &__75;
        return NULL;
    case '\''n'\'':
        if (equal(p, "ode_id"))
            return &__81;
        return NULL;
    case '\''o'\'':
        if (equal(p, "rganizations_url"))
            return &__111;
        return NULL;
    case '\''r'\'':
        if (*p ++ == '\''e'\'') {
            switch (*p ++) {
            case '\''c'\'':
                if (equal(p, "eived_events_url"))
                    return &__120;
                return NULL;
            case '\''p'\'':
                if (equal(p, "os_url"))
                    return &__114;
            }
        }
        return NULL;
    case '\''s'\'':
        switch (*p ++) {
        case '\''i'\'':
            if (equal(p, "te_admin"))
                return &__124;
            return NULL;
        case '\''t'\'':
            if (equal(p, "arred_url"))
                return &__105;
            return NULL;
        case '\''u'\'':
            if (equal(p, "bscriptions_url"))
                return &__108;
        }
        return NULL;
    case '\''t'\'':
        if (equal(p, "ype"))
            return &__123;
        return NULL;
    case '\''u'\'':
        if (equal(p, "rl"))
            return &__90;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __126 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __125
};
static const struct json_litex_object_node_arg_t __127[] = {
    {
        .key = {
            .val = (const uchar_t*) "login"
        },
        .val = &__75
    },
    {
        .key = {
            .val = (const uchar_t*) "id"
        },
        .val = &__78
    },
    {
        .key = {
            .val = (const uchar_t*) "node_id"
        },
        .val = &__81
    },
    {
        .key = {
            .val = (const uchar_t*) "avatar_url"
        },
        .val = &__84
    },
    {
        .key = {
            .val = (const uchar_t*) "gravatar_id"
        },
        .val = &__87
    },
    {
        .key = {
            .val = (const uchar_t*) "url"
        },
        .val = &__90
    },
    {
        .key = {
            .val = (const uchar_t*) "html_url"
        },
        .val = &__93
    },
    {
        .key = {
            .val = (const uchar_t*) "followers_url"
        },
        .val = &__96
    },
    {
        .key = {
            .val = (const uchar_t*) "following_url"
        },
        .val = &__99
    },
    {
        .key = {
            .val = (const uchar_t*) "gists_url"
        },
        .val = &__102
    },
    {
        .key = {
            .val = (const uchar_t*) "starred_url"
        },
        .val = &__105
    },
    {
        .key = {
            .val = (const uchar_t*) "subscriptions_url"
        },
        .val = &__108
    },
    {
        .key = {
            .val = (const uchar_t*) "organizations_url"
        },
        .val = &__111
    },
    {
        .key = {
            .val = (const uchar_t*) "repos_url"
        },
        .val = &__114
    },
    {
        .key = {
            .val = (const uchar_t*) "events_url"
        },
        .val = &__117
    },
    {
        .key = {
            .val = (const uchar_t*) "received_events_url"
        },
        .val = &__120
    },
    {
        .key = {
            .val = (const uchar_t*) "type"
        },
        .val = &__123
    },
    {
        .key = {
            .val = (const uchar_t*) "site_admin"
        },
        .val = &__124
    }
};
static const struct json_litex_node_t __128 = {
    .type = json_litex_object_node_type,
    .attr.object = &__126,
    .node.object = {
        .args = __127,
        .size = 18
    },
    .parent = &__134
};
static const struct json_litex_expr_node_t __129[] = {
    call_builtin(null)
};
static const struct json_litex_expr_def_t __130 = {
    .nodes = __129,
    .size = 1
};
static const struct json_litex_node_t __131 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null"
    },
    .attr.string = &__130,
    .parent = &__134
};
static const struct json_litex_array_attr_t __132 = {
    .string = &__131,
    .object = &__128
};
static const struct json_litex_node_t* __133[] = {
    &__128,
    &__131,
    NULL
};
static const struct json_litex_node_t __134 = {
    .type = json_litex_array_node_type,
    .attr.array = &__132,
    .node.array = {
        .args = __133,
        .size = 2
    },
    .path = __170 + 6,
    .parent = &__171
};
static const struct json_litex_node_t __160;
static const struct json_litex_object_node_arg_t __155[];
static const struct json_litex_node_t __156;
static const struct json_litex_node_t __135 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[a-z0-9_-]+$/I"
    },
    .attr.string = &__74,
    .path = __155 + 0,
    .parent = &__156
};
static const struct json_litex_node_t __136 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "uint(32)"
    },
    .attr.string = &__77,
    .path = __155 + 1,
    .parent = &__156
};
static const struct json_litex_node_t __137 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[a-z0-9]{14,}[a-z0-9=]{2}$/I"
    },
    .attr.string = &__80,
    .path = __155 + 2,
    .parent = &__156
};
static const struct json_litex_node_t __138 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://avatars\\d+\\.githubusercontent\\.com/u/\\d+\\?v=\\d+$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__83,
    .path = __155 + 3,
    .parent = &__156
};
static const struct json_litex_node_t __139 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "string && len == 0"
    },
    .attr.string = &__86,
    .path = __155 + 4,
    .parent = &__156
};
static const struct json_litex_node_t __140 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__89,
    .path = __155 + 5,
    .parent = &__156
};
static const struct json_litex_node_t __141 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://github\\.com/[a-zA-Z0-9_-]+$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__92,
    .path = __155 + 6,
    .parent = &__156
};
static const struct json_litex_node_t __142 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/followers$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__95,
    .path = __155 + 7,
    .parent = &__156
};
static const struct json_litex_node_t __143 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/following\\{/other_user\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__98,
    .path = __155 + 8,
    .parent = &__156
};
static const struct json_litex_node_t __144 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/gists\\{/gist_id\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__101,
    .path = __155 + 9,
    .parent = &__156
};
static const struct json_litex_node_t __145 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/starred\\{/owner\\}\\{/repo\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__104,
    .path = __155 + 10,
    .parent = &__156
};
static const struct json_litex_node_t __146 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/subscriptions$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__107,
    .path = __155 + 11,
    .parent = &__156
};
static const struct json_litex_node_t __147 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/orgs$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__110,
    .path = __155 + 12,
    .parent = &__156
};
static const struct json_litex_node_t __148 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/repos$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__113,
    .path = __155 + 13,
    .parent = &__156
};
static const struct json_litex_node_t __149 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/events\\{/privacy\\}$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__116,
    .path = __155 + 14,
    .parent = &__156
};
static const struct json_litex_node_t __150 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t\t'\''^https://api\\.github\\.com/users/[a-zA-Z0-9_-]+/received_events$'\''\n\t\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__119,
    .path = __155 + 15,
    .parent = &__156
};
static const struct json_litex_node_t __151 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`User`"
    },
    .attr.string = &__122,
    .path = __155 + 16,
    .parent = &__156
};
static const struct json_litex_node_t __152 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "bool"
    },
    .attr.string = &__47,
    .path = __155 + 17,
    .parent = &__156
};
static const struct json_litex_node_t* __153(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''a'\'':
        if (equal(p, "vatar_url"))
            return &__138;
        return NULL;
    case '\''e'\'':
        if (equal(p, "vents_url"))
            return &__149;
        return NULL;
    case '\''f'\'':
        if (prefix("ollow", p)) {
            p += 5;
            switch (*p ++) {
            case '\''e'\'':
                if (equal(p, "rs_url"))
                    return &__142;
                return NULL;
            case '\''i'\'':
                if (equal(p, "ng_url"))
                    return &__143;
            }
        }
        return NULL;
    case '\''g'\'':
        switch (*p ++) {
        case '\''i'\'':
            if (equal(p, "sts_url"))
                return &__144;
            return NULL;
        case '\''r'\'':
            if (equal(p, "avatar_id"))
                return &__139;
        }
        return NULL;
    case '\''h'\'':
        if (equal(p, "tml_url"))
            return &__141;
        return NULL;
    case '\''i'\'':
        if (*p ++ == '\''d'\'' &&
            *p == 0)
            return &__136;
        return NULL;
    case '\''l'\'':
        if (equal(p, "ogin"))
            return &__135;
        return NULL;
    case '\''n'\'':
        if (equal(p, "ode_id"))
            return &__137;
        return NULL;
    case '\''o'\'':
        if (equal(p, "rganizations_url"))
            return &__147;
        return NULL;
    case '\''r'\'':
        if (*p ++ == '\''e'\'') {
            switch (*p ++) {
            case '\''c'\'':
                if (equal(p, "eived_events_url"))
                    return &__150;
                return NULL;
            case '\''p'\'':
                if (equal(p, "os_url"))
                    return &__148;
            }
        }
        return NULL;
    case '\''s'\'':
        switch (*p ++) {
        case '\''i'\'':
            if (equal(p, "te_admin"))
                return &__152;
            return NULL;
        case '\''t'\'':
            if (equal(p, "arred_url"))
                return &__145;
            return NULL;
        case '\''u'\'':
            if (equal(p, "bscriptions_url"))
                return &__146;
        }
        return NULL;
    case '\''t'\'':
        if (equal(p, "ype"))
            return &__151;
        return NULL;
    case '\''u'\'':
        if (equal(p, "rl"))
            return &__140;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __154 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __153
};
static const struct json_litex_object_node_arg_t __155[] = {
    {
        .key = {
            .val = (const uchar_t*) "login"
        },
        .val = &__135
    },
    {
        .key = {
            .val = (const uchar_t*) "id"
        },
        .val = &__136
    },
    {
        .key = {
            .val = (const uchar_t*) "node_id"
        },
        .val = &__137
    },
    {
        .key = {
            .val = (const uchar_t*) "avatar_url"
        },
        .val = &__138
    },
    {
        .key = {
            .val = (const uchar_t*) "gravatar_id"
        },
        .val = &__139
    },
    {
        .key = {
            .val = (const uchar_t*) "url"
        },
        .val = &__140
    },
    {
        .key = {
            .val = (const uchar_t*) "html_url"
        },
        .val = &__141
    },
    {
        .key = {
            .val = (const uchar_t*) "followers_url"
        },
        .val = &__142
    },
    {
        .key = {
            .val = (const uchar_t*) "following_url"
        },
        .val = &__143
    },
    {
        .key = {
            .val = (const uchar_t*) "gists_url"
        },
        .val = &__144
    },
    {
        .key = {
            .val = (const uchar_t*) "starred_url"
        },
        .val = &__145
    },
    {
        .key = {
            .val = (const uchar_t*) "subscriptions_url"
        },
        .val = &__146
    },
    {
        .key = {
            .val = (const uchar_t*) "organizations_url"
        },
        .val = &__147
    },
    {
        .key = {
            .val = (const uchar_t*) "repos_url"
        },
        .val = &__148
    },
    {
        .key = {
            .val = (const uchar_t*) "events_url"
        },
        .val = &__149
    },
    {
        .key = {
            .val = (const uchar_t*) "received_events_url"
        },
        .val = &__150
    },
    {
        .key = {
            .val = (const uchar_t*) "type"
        },
        .val = &__151
    },
    {
        .key = {
            .val = (const uchar_t*) "site_admin"
        },
        .val = &__152
    }
};
static const struct json_litex_node_t __156 = {
    .type = json_litex_object_node_type,
    .attr.object = &__154,
    .node.object = {
        .args = __155,
        .size = 18
    },
    .parent = &__160
};
static const struct json_litex_node_t __157 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null"
    },
    .attr.string = &__130,
    .parent = &__160
};
static const struct json_litex_array_attr_t __158 = {
    .string = &__157,
    .object = &__156
};
static const struct json_litex_node_t* __159[] = {
    &__156,
    &__157,
    NULL
};
static const struct json_litex_node_t __160 = {
    .type = json_litex_array_node_type,
    .attr.array = &__158,
    .node.array = {
        .args = __159,
        .size = 2
    },
    .path = __170 + 7,
    .parent = &__171
};
static const struct json_litex_object_node_arg_t __166[];
static const struct json_litex_node_t __167;
static const struct json_litex_node_t __161 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[0-9a-f]{40}$/"
    },
    .attr.string = &__4,
    .path = __166 + 0,
    .parent = &__167
};
static const struct json_litex_node_t __162 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t'\''^https://api\\.github\\.com/repos/gcc-mirror/gcc/commits/[0-9a-f]{40}$'\''\n\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__65,
    .path = __166 + 1,
    .parent = &__167
};
static const struct json_litex_node_t __163 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "\n\t\t\t\t'\''^https://github\\.com/gcc-mirror/gcc/commit/[0-9a-f]{40}$'\''\n\t\t\t",
        .delim = (const uchar_t*) ""
    },
    .attr.string = &__68,
    .path = __166 + 2,
    .parent = &__167
};
static const struct json_litex_node_t* __164(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''h'\'':
        if (equal(p, "tml_url"))
            return &__163;
        return NULL;
    case '\''s'\'':
        if (equal(p, "ha"))
            return &__161;
        return NULL;
    case '\''u'\'':
        if (equal(p, "rl"))
            return &__162;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __165 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __164
};
static const struct json_litex_object_node_arg_t __166[] = {
    {
        .key = {
            .val = (const uchar_t*) "sha"
        },
        .val = &__161
    },
    {
        .key = {
            .val = (const uchar_t*) "url"
        },
        .val = &__162
    },
    {
        .key = {
            .val = (const uchar_t*) "html_url"
        },
        .val = &__163
    }
};
static const struct json_litex_node_t __167 = {
    .type = json_litex_object_node_type,
    .attr.object = &__165,
    .node.object = {
        .args = __166,
        .size = 3
    },
    .path = __170 + 8,
    .parent = &__171
};
static const struct json_litex_node_t* __168(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''a'\'':
        if (equal(p, "uthor"))
            return &__134;
        return NULL;
    case '\''c'\'':
        if (prefix("omm", p)) {
            p += 3;
            switch (*p ++) {
            case '\''e'\'':
                if (equal(p, "nts_url"))
                    return &__72;
                return NULL;
            case '\''i'\'':
                if (*p ++ == '\''t'\'') {
                    if (*p == 0)
                        return &__63;
                    if (equal(p, "ter"))
                        return &__160;
                }
            }
        }
        return NULL;
    case '\''h'\'':
        if (equal(p, "tml_url"))
            return &__69;
        return NULL;
    case '\''n'\'':
        if (equal(p, "ode_id"))
            return &__8;
        return NULL;
    case '\''p'\'':
        if (equal(p, "arents"))
            return &__167;
        return NULL;
    case '\''s'\'':
        if (equal(p, "ha"))
            return &__5;
        return NULL;
    case '\''u'\'':
        if (equal(p, "rl"))
            return &__66;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __169 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __168
};
static const struct json_litex_object_node_arg_t __170[] = {
    {
        .key = {
            .val = (const uchar_t*) "sha"
        },
        .val = &__5
    },
    {
        .key = {
            .val = (const uchar_t*) "node_id"
        },
        .val = &__8
    },
    {
        .key = {
            .val = (const uchar_t*) "commit"
        },
        .val = &__63
    },
    {
        .key = {
            .val = (const uchar_t*) "url"
        },
        .val = &__66
    },
    {
        .key = {
            .val = (const uchar_t*) "html_url"
        },
        .val = &__69
    },
    {
        .key = {
            .val = (const uchar_t*) "comments_url"
        },
        .val = &__72
    },
    {
        .key = {
            .val = (const uchar_t*) "author"
        },
        .val = &__134
    },
    {
        .key = {
            .val = (const uchar_t*) "committer"
        },
        .val = &__160
    },
    {
        .key = {
            .val = (const uchar_t*) "parents"
        },
        .val = &__167
    }
};
static const struct json_litex_node_t __171 = {
    .type = json_litex_object_node_type,
    .attr.object = &__169,
    .node.object = {
        .args = __170,
        .size = 9
    },
    .path = __174 + 0,
    .parent = &__175
};
static const struct json_litex_node_t* __172(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "commits"))
        return &__171;
    return NULL;
}
static const struct json_litex_object_attr_t __173 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __172
};
static const struct json_litex_object_node_arg_t __174[] = {
    {
        .key = {
            .val = (const uchar_t*) "commits"
        },
        .val = &__171
    }
};
static const struct json_litex_node_t __175 = {
    .type = json_litex_object_node_type,
    .attr.object = &__173,
    .node.object = {
        .args = __174,
        .size = 1
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__175
};
$ json-litex -V libs/github-litex/github-litex.json'
) -L github-text-lib.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; }'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }'

echo '$ norm() { sed -r '\''/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/'\'' ${1:+"$1"}; }'
norm() { sed -r '/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/' ${1:+"$1"}; } 2>&1 ||
echo 'command failed: norm() { sed -r '\''/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/'\'' ${1:+"$1"}; }'

echo '$ diff -u -Ljson <(json -P libs/github-litex/github-litex.json) -Llib <(json-litex -P libs/github-litex/github-litex.json|json -P)'
diff -u -Ljson <(json -P libs/github-litex/github-litex.json) -Llib <(json-litex -P libs/github-litex/github-litex.json|json -P) 2>&1 ||
echo 'command failed: diff -u -Ljson <(json -P libs/github-litex/github-litex.json) -Llib <(json-litex -P libs/github-litex/github-litex.json|json -P)'

echo '$ json-litex -D libs/github-litex/github-litex.json|norm'
json-litex -D libs/github-litex/github-litex.json|norm 2>&1 ||
echo 'command failed: json-litex -D libs/github-litex/github-litex.json|norm'

echo '$ json-litex -V libs/github-litex/github-litex.json'
json-litex -V libs/github-litex/github-litex.json 2>&1 ||
echo 'command failed: json-litex -V libs/github-litex/github-litex.json'
)

