#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:array2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L array2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --parse --verbose "$@"; }
$ json <<< '\''['\''
json: error: <stdin>:2:1: parse error: unexpected token
json: error: <stdin>:2:1: [
json: error: <stdin>:2:1:  ^
command failed: json <<< '\''['\''
$ json <<< '\'']'\''
json: error: <stdin>:1:1: parse error: unexpected token
json: error: <stdin>:1:1: ]
json: error: <stdin>:1:1: ^
command failed: json <<< '\'']'\''
$ json <<< '\''[,]'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: [,]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[,]'\''
$ json <<< '\''[:]'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: [:]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[:]'\''
$ json <<< '\''[null,]'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: [null,]
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''[null,]'\''
$ json <<< '\''[,null]'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: [,null]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[,null]'\''
$ json <<< '\''[false:]'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: [false:]
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''[false:]'\''
$ json <<< '\''[:false]'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: [:false]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[:false]'\''
$ json <<< '\''[0,1,]'\''
json: error: <stdin>:1:6: parse error: unexpected token
json: error: <stdin>:1:6: [0,1,]
json: error: <stdin>:1:6:      ^
command failed: json <<< '\''[0,1,]'\''
$ json <<< '\''[0,1:]'\''
json: error: <stdin>:1:5: parse error: unexpected token
json: error: <stdin>:1:5: [0,1:]
json: error: <stdin>:1:5:     ^
command failed: json <<< '\''[0,1:]'\''
$ json <<< '\''[0,1,2,3,]'\''
json: error: <stdin>:1:10: parse error: unexpected token
json: error: <stdin>:1:10: [0,1,2,3,]
json: error: <stdin>:1:10:          ^
command failed: json <<< '\''[0,1,2,3,]'\''
$ json <<< '\''[0,1,2,3:]'\''
json: error: <stdin>:1:9: parse error: unexpected token
json: error: <stdin>:1:9: [0,1,2,3:]
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''[0,1,2,3:]'\'''
) -L array2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --parse --verbose "$@"; }'
json() { json0 --parse --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --parse --verbose "$@"; }'

echo '$ json <<< '\''['\'''
json <<< '[' 2>&1 ||
echo 'command failed: json <<< '\''['\'''

echo '$ json <<< '\'']'\'''
json <<< ']' 2>&1 ||
echo 'command failed: json <<< '\'']'\'''

echo '$ json <<< '\''[,]'\'''
json <<< '[,]' 2>&1 ||
echo 'command failed: json <<< '\''[,]'\'''

echo '$ json <<< '\''[:]'\'''
json <<< '[:]' 2>&1 ||
echo 'command failed: json <<< '\''[:]'\'''

echo '$ json <<< '\''[null,]'\'''
json <<< '[null,]' 2>&1 ||
echo 'command failed: json <<< '\''[null,]'\'''

echo '$ json <<< '\''[,null]'\'''
json <<< '[,null]' 2>&1 ||
echo 'command failed: json <<< '\''[,null]'\'''

echo '$ json <<< '\''[false:]'\'''
json <<< '[false:]' 2>&1 ||
echo 'command failed: json <<< '\''[false:]'\'''

echo '$ json <<< '\''[:false]'\'''
json <<< '[:false]' 2>&1 ||
echo 'command failed: json <<< '\''[:false]'\'''

echo '$ json <<< '\''[0,1,]'\'''
json <<< '[0,1,]' 2>&1 ||
echo 'command failed: json <<< '\''[0,1,]'\'''

echo '$ json <<< '\''[0,1:]'\'''
json <<< '[0,1:]' 2>&1 ||
echo 'command failed: json <<< '\''[0,1:]'\'''

echo '$ json <<< '\''[0,1,2,3,]'\'''
json <<< '[0,1,2,3,]' 2>&1 ||
echo 'command failed: json <<< '\''[0,1,2,3,]'\'''

echo '$ json <<< '\''[0,1,2,3:]'\'''
json <<< '[0,1,2,3:]' 2>&1 ||
echo 'command failed: json <<< '\''[0,1,2,3:]'\'''
)

