#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:error-context4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L error-context4.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 -lOV "$@"; }
$ json -b1 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b1 -e1 <<< $'\''87654321\n\n~'\''
$ json -b2 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b2 -e1 <<< $'\''87654321\n\n~'\''
$ json -b3 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b3 -e1 <<< $'\''87654321\n\n~'\''
$ json -b4 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b4 -e1 <<< $'\''87654321\n\n~'\''
$ json -b5 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b5 -e1 <<< $'\''87654321\n\n~'\''
$ json -b6 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b6 -e1 <<< $'\''87654321\n\n~'\''
$ json -b7 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b7 -e1 <<< $'\''87654321\n\n~'\''
$ json -b8 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b8 -e1 <<< $'\''87654321\n\n~'\''
$ json -b9 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b9 -e1 <<< $'\''87654321\n\n~'\''
$ json -b10 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b10 -e1 <<< $'\''87654321\n\n~'\''
$ json -b11 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b11 -e1 <<< $'\''87654321\n\n~'\''
$ json -b12 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b12 -e1 <<< $'\''87654321\n\n~'\''
$ json -b13 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b13 -e1 <<< $'\''87654321\n\n~'\''
$ json -b14 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b14 -e1 <<< $'\''87654321\n\n~'\''
$ json -b15 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b15 -e1 <<< $'\''87654321\n\n~'\''
$ json -b16 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b16 -e1 <<< $'\''87654321\n\n~'\''
$ json -b17 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b17 -e1 <<< $'\''87654321\n\n~'\''
$ json -b18 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b18 -e1 <<< $'\''87654321\n\n~'\''
$ json -b19 -e1 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n~
json: error: <stdin>:3:1:   ^
command failed: json -b19 -e1 <<< $'\''87654321\n\n~'\''
$ json -b1 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b1 -e2 <<< $'\''87654321\n\n~'\''
$ json -b2 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b2 -e2 <<< $'\''87654321\n\n~'\''
$ json -b3 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b3 -e2 <<< $'\''87654321\n\n~'\''
$ json -b4 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b4 -e2 <<< $'\''87654321\n\n~'\''
$ json -b5 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b5 -e2 <<< $'\''87654321\n\n~'\''
$ json -b6 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b6 -e2 <<< $'\''87654321\n\n~'\''
$ json -b7 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b7 -e2 <<< $'\''87654321\n\n~'\''
$ json -b8 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b8 -e2 <<< $'\''87654321\n\n~'\''
$ json -b9 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b9 -e2 <<< $'\''87654321\n\n~'\''
$ json -b10 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b10 -e2 <<< $'\''87654321\n\n~'\''
$ json -b11 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b11 -e2 <<< $'\''87654321\n\n~'\''
$ json -b12 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b12 -e2 <<< $'\''87654321\n\n~'\''
$ json -b13 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b13 -e2 <<< $'\''87654321\n\n~'\''
$ json -b14 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b14 -e2 <<< $'\''87654321\n\n~'\''
$ json -b15 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b15 -e2 <<< $'\''87654321\n\n~'\''
$ json -b16 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b16 -e2 <<< $'\''87654321\n\n~'\''
$ json -b17 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b17 -e2 <<< $'\''87654321\n\n~'\''
$ json -b18 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b18 -e2 <<< $'\''87654321\n\n~'\''
$ json -b19 -e2 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: \n\n~
json: error: <stdin>:3:1:     ^
command failed: json -b19 -e2 <<< $'\''87654321\n\n~'\''
$ json -b1 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b1 -e3 <<< $'\''87654321\n\n~'\''
$ json -b2 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b2 -e3 <<< $'\''87654321\n\n~'\''
$ json -b3 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b3 -e3 <<< $'\''87654321\n\n~'\''
$ json -b4 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b4 -e3 <<< $'\''87654321\n\n~'\''
$ json -b5 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b5 -e3 <<< $'\''87654321\n\n~'\''
$ json -b6 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b6 -e3 <<< $'\''87654321\n\n~'\''
$ json -b7 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b7 -e3 <<< $'\''87654321\n\n~'\''
$ json -b8 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b8 -e3 <<< $'\''87654321\n\n~'\''
$ json -b9 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b9 -e3 <<< $'\''87654321\n\n~'\''
$ json -b10 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b10 -e3 <<< $'\''87654321\n\n~'\''
$ json -b11 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b11 -e3 <<< $'\''87654321\n\n~'\''
$ json -b12 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b12 -e3 <<< $'\''87654321\n\n~'\''
$ json -b13 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b13 -e3 <<< $'\''87654321\n\n~'\''
$ json -b14 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b14 -e3 <<< $'\''87654321\n\n~'\''
$ json -b15 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b15 -e3 <<< $'\''87654321\n\n~'\''
$ json -b16 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b16 -e3 <<< $'\''87654321\n\n~'\''
$ json -b17 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b17 -e3 <<< $'\''87654321\n\n~'\''
$ json -b18 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b18 -e3 <<< $'\''87654321\n\n~'\''
$ json -b19 -e3 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 1\n\n~
json: error: <stdin>:3:1:      ^
command failed: json -b19 -e3 <<< $'\''87654321\n\n~'\''
$ json -b1 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b1 -e4 <<< $'\''87654321\n\n~'\''
$ json -b2 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b2 -e4 <<< $'\''87654321\n\n~'\''
$ json -b3 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b3 -e4 <<< $'\''87654321\n\n~'\''
$ json -b4 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b4 -e4 <<< $'\''87654321\n\n~'\''
$ json -b5 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b5 -e4 <<< $'\''87654321\n\n~'\''
$ json -b6 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b6 -e4 <<< $'\''87654321\n\n~'\''
$ json -b7 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b7 -e4 <<< $'\''87654321\n\n~'\''
$ json -b8 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b8 -e4 <<< $'\''87654321\n\n~'\''
$ json -b9 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b9 -e4 <<< $'\''87654321\n\n~'\''
$ json -b10 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b10 -e4 <<< $'\''87654321\n\n~'\''
$ json -b11 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b11 -e4 <<< $'\''87654321\n\n~'\''
$ json -b12 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b12 -e4 <<< $'\''87654321\n\n~'\''
$ json -b13 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b13 -e4 <<< $'\''87654321\n\n~'\''
$ json -b14 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b14 -e4 <<< $'\''87654321\n\n~'\''
$ json -b15 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b15 -e4 <<< $'\''87654321\n\n~'\''
$ json -b16 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b16 -e4 <<< $'\''87654321\n\n~'\''
$ json -b17 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b17 -e4 <<< $'\''87654321\n\n~'\''
$ json -b18 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b18 -e4 <<< $'\''87654321\n\n~'\''
$ json -b19 -e4 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 21\n\n~
json: error: <stdin>:3:1:       ^
command failed: json -b19 -e4 <<< $'\''87654321\n\n~'\''
$ json -b1 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b1 -e5 <<< $'\''87654321\n\n~'\''
$ json -b2 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b2 -e5 <<< $'\''87654321\n\n~'\''
$ json -b3 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b3 -e5 <<< $'\''87654321\n\n~'\''
$ json -b4 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b4 -e5 <<< $'\''87654321\n\n~'\''
$ json -b5 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b5 -e5 <<< $'\''87654321\n\n~'\''
$ json -b6 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b6 -e5 <<< $'\''87654321\n\n~'\''
$ json -b7 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b7 -e5 <<< $'\''87654321\n\n~'\''
$ json -b8 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b8 -e5 <<< $'\''87654321\n\n~'\''
$ json -b9 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b9 -e5 <<< $'\''87654321\n\n~'\''
$ json -b10 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b10 -e5 <<< $'\''87654321\n\n~'\''
$ json -b11 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b11 -e5 <<< $'\''87654321\n\n~'\''
$ json -b12 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b12 -e5 <<< $'\''87654321\n\n~'\''
$ json -b13 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b13 -e5 <<< $'\''87654321\n\n~'\''
$ json -b14 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b14 -e5 <<< $'\''87654321\n\n~'\''
$ json -b15 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b15 -e5 <<< $'\''87654321\n\n~'\''
$ json -b16 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b16 -e5 <<< $'\''87654321\n\n~'\''
$ json -b17 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b17 -e5 <<< $'\''87654321\n\n~'\''
$ json -b18 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b18 -e5 <<< $'\''87654321\n\n~'\''
$ json -b19 -e5 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 321\n\n~
json: error: <stdin>:3:1:        ^
command failed: json -b19 -e5 <<< $'\''87654321\n\n~'\''
$ json -b1 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b1 -e6 <<< $'\''87654321\n\n~'\''
$ json -b2 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b2 -e6 <<< $'\''87654321\n\n~'\''
$ json -b3 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b3 -e6 <<< $'\''87654321\n\n~'\''
$ json -b4 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b4 -e6 <<< $'\''87654321\n\n~'\''
$ json -b5 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b5 -e6 <<< $'\''87654321\n\n~'\''
$ json -b6 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b6 -e6 <<< $'\''87654321\n\n~'\''
$ json -b7 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b7 -e6 <<< $'\''87654321\n\n~'\''
$ json -b8 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b8 -e6 <<< $'\''87654321\n\n~'\''
$ json -b9 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b9 -e6 <<< $'\''87654321\n\n~'\''
$ json -b10 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b10 -e6 <<< $'\''87654321\n\n~'\''
$ json -b11 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b11 -e6 <<< $'\''87654321\n\n~'\''
$ json -b12 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b12 -e6 <<< $'\''87654321\n\n~'\''
$ json -b13 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b13 -e6 <<< $'\''87654321\n\n~'\''
$ json -b14 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b14 -e6 <<< $'\''87654321\n\n~'\''
$ json -b15 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b15 -e6 <<< $'\''87654321\n\n~'\''
$ json -b16 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b16 -e6 <<< $'\''87654321\n\n~'\''
$ json -b17 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b17 -e6 <<< $'\''87654321\n\n~'\''
$ json -b18 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b18 -e6 <<< $'\''87654321\n\n~'\''
$ json -b19 -e6 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 4321\n\n~
json: error: <stdin>:3:1:         ^
command failed: json -b19 -e6 <<< $'\''87654321\n\n~'\''
$ json -b1 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b1 -e7 <<< $'\''87654321\n\n~'\''
$ json -b2 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b2 -e7 <<< $'\''87654321\n\n~'\''
$ json -b3 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b3 -e7 <<< $'\''87654321\n\n~'\''
$ json -b4 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b4 -e7 <<< $'\''87654321\n\n~'\''
$ json -b5 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b5 -e7 <<< $'\''87654321\n\n~'\''
$ json -b6 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b6 -e7 <<< $'\''87654321\n\n~'\''
$ json -b7 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b7 -e7 <<< $'\''87654321\n\n~'\''
$ json -b8 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b8 -e7 <<< $'\''87654321\n\n~'\''
$ json -b9 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b9 -e7 <<< $'\''87654321\n\n~'\''
$ json -b10 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b10 -e7 <<< $'\''87654321\n\n~'\''
$ json -b11 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b11 -e7 <<< $'\''87654321\n\n~'\''
$ json -b12 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b12 -e7 <<< $'\''87654321\n\n~'\''
$ json -b13 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b13 -e7 <<< $'\''87654321\n\n~'\''
$ json -b14 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b14 -e7 <<< $'\''87654321\n\n~'\''
$ json -b15 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b15 -e7 <<< $'\''87654321\n\n~'\''
$ json -b16 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b16 -e7 <<< $'\''87654321\n\n~'\''
$ json -b17 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b17 -e7 <<< $'\''87654321\n\n~'\''
$ json -b18 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b18 -e7 <<< $'\''87654321\n\n~'\''
$ json -b19 -e7 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 54321\n\n~
json: error: <stdin>:3:1:          ^
command failed: json -b19 -e7 <<< $'\''87654321\n\n~'\''
$ json -b1 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b1 -e8 <<< $'\''87654321\n\n~'\''
$ json -b2 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b2 -e8 <<< $'\''87654321\n\n~'\''
$ json -b3 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b3 -e8 <<< $'\''87654321\n\n~'\''
$ json -b4 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b4 -e8 <<< $'\''87654321\n\n~'\''
$ json -b5 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b5 -e8 <<< $'\''87654321\n\n~'\''
$ json -b6 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b6 -e8 <<< $'\''87654321\n\n~'\''
$ json -b7 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b7 -e8 <<< $'\''87654321\n\n~'\''
$ json -b8 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b8 -e8 <<< $'\''87654321\n\n~'\''
$ json -b9 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b9 -e8 <<< $'\''87654321\n\n~'\''
$ json -b10 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b10 -e8 <<< $'\''87654321\n\n~'\''
$ json -b11 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b11 -e8 <<< $'\''87654321\n\n~'\''
$ json -b12 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b12 -e8 <<< $'\''87654321\n\n~'\''
$ json -b13 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b13 -e8 <<< $'\''87654321\n\n~'\''
$ json -b14 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b14 -e8 <<< $'\''87654321\n\n~'\''
$ json -b15 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b15 -e8 <<< $'\''87654321\n\n~'\''
$ json -b16 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b16 -e8 <<< $'\''87654321\n\n~'\''
$ json -b17 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b17 -e8 <<< $'\''87654321\n\n~'\''
$ json -b18 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b18 -e8 <<< $'\''87654321\n\n~'\''
$ json -b19 -e8 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 654321\n\n~
json: error: <stdin>:3:1:           ^
command failed: json -b19 -e8 <<< $'\''87654321\n\n~'\''
$ json -b1 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b1 -e9 <<< $'\''87654321\n\n~'\''
$ json -b2 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b2 -e9 <<< $'\''87654321\n\n~'\''
$ json -b3 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b3 -e9 <<< $'\''87654321\n\n~'\''
$ json -b4 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b4 -e9 <<< $'\''87654321\n\n~'\''
$ json -b5 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b5 -e9 <<< $'\''87654321\n\n~'\''
$ json -b6 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b6 -e9 <<< $'\''87654321\n\n~'\''
$ json -b7 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b7 -e9 <<< $'\''87654321\n\n~'\''
$ json -b8 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b8 -e9 <<< $'\''87654321\n\n~'\''
$ json -b9 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b9 -e9 <<< $'\''87654321\n\n~'\''
$ json -b10 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b10 -e9 <<< $'\''87654321\n\n~'\''
$ json -b11 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b11 -e9 <<< $'\''87654321\n\n~'\''
$ json -b12 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b12 -e9 <<< $'\''87654321\n\n~'\''
$ json -b13 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b13 -e9 <<< $'\''87654321\n\n~'\''
$ json -b14 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b14 -e9 <<< $'\''87654321\n\n~'\''
$ json -b15 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b15 -e9 <<< $'\''87654321\n\n~'\''
$ json -b16 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b16 -e9 <<< $'\''87654321\n\n~'\''
$ json -b17 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b17 -e9 <<< $'\''87654321\n\n~'\''
$ json -b18 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b18 -e9 <<< $'\''87654321\n\n~'\''
$ json -b19 -e9 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 7654321\n\n~
json: error: <stdin>:3:1:            ^
command failed: json -b19 -e9 <<< $'\''87654321\n\n~'\''
$ json -b1 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b1 -e10 <<< $'\''87654321\n\n~'\''
$ json -b2 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b2 -e10 <<< $'\''87654321\n\n~'\''
$ json -b3 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b3 -e10 <<< $'\''87654321\n\n~'\''
$ json -b4 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b4 -e10 <<< $'\''87654321\n\n~'\''
$ json -b5 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b5 -e10 <<< $'\''87654321\n\n~'\''
$ json -b6 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b6 -e10 <<< $'\''87654321\n\n~'\''
$ json -b7 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b7 -e10 <<< $'\''87654321\n\n~'\''
$ json -b8 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b8 -e10 <<< $'\''87654321\n\n~'\''
$ json -b9 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b9 -e10 <<< $'\''87654321\n\n~'\''
$ json -b10 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b10 -e10 <<< $'\''87654321\n\n~'\''
$ json -b11 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b11 -e10 <<< $'\''87654321\n\n~'\''
$ json -b12 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b12 -e10 <<< $'\''87654321\n\n~'\''
$ json -b13 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b13 -e10 <<< $'\''87654321\n\n~'\''
$ json -b14 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b14 -e10 <<< $'\''87654321\n\n~'\''
$ json -b15 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b15 -e10 <<< $'\''87654321\n\n~'\''
$ json -b16 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b16 -e10 <<< $'\''87654321\n\n~'\''
$ json -b17 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b17 -e10 <<< $'\''87654321\n\n~'\''
$ json -b18 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b18 -e10 <<< $'\''87654321\n\n~'\''
$ json -b19 -e10 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b19 -e10 <<< $'\''87654321\n\n~'\''
$ json -b1 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b1 -e11 <<< $'\''87654321\n\n~'\''
$ json -b2 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b2 -e11 <<< $'\''87654321\n\n~'\''
$ json -b3 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b3 -e11 <<< $'\''87654321\n\n~'\''
$ json -b4 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b4 -e11 <<< $'\''87654321\n\n~'\''
$ json -b5 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b5 -e11 <<< $'\''87654321\n\n~'\''
$ json -b6 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b6 -e11 <<< $'\''87654321\n\n~'\''
$ json -b7 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b7 -e11 <<< $'\''87654321\n\n~'\''
$ json -b8 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b8 -e11 <<< $'\''87654321\n\n~'\''
$ json -b9 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b9 -e11 <<< $'\''87654321\n\n~'\''
$ json -b10 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b10 -e11 <<< $'\''87654321\n\n~'\''
$ json -b11 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b11 -e11 <<< $'\''87654321\n\n~'\''
$ json -b12 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b12 -e11 <<< $'\''87654321\n\n~'\''
$ json -b13 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b13 -e11 <<< $'\''87654321\n\n~'\''
$ json -b14 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b14 -e11 <<< $'\''87654321\n\n~'\''
$ json -b15 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b15 -e11 <<< $'\''87654321\n\n~'\''
$ json -b16 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b16 -e11 <<< $'\''87654321\n\n~'\''
$ json -b17 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b17 -e11 <<< $'\''87654321\n\n~'\''
$ json -b18 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b18 -e11 <<< $'\''87654321\n\n~'\''
$ json -b19 -e11 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b19 -e11 <<< $'\''87654321\n\n~'\''
$ json -b1 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b1 -e12 <<< $'\''87654321\n\n~'\''
$ json -b2 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b2 -e12 <<< $'\''87654321\n\n~'\''
$ json -b3 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b3 -e12 <<< $'\''87654321\n\n~'\''
$ json -b4 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b4 -e12 <<< $'\''87654321\n\n~'\''
$ json -b5 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b5 -e12 <<< $'\''87654321\n\n~'\''
$ json -b6 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b6 -e12 <<< $'\''87654321\n\n~'\''
$ json -b7 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b7 -e12 <<< $'\''87654321\n\n~'\''
$ json -b8 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b8 -e12 <<< $'\''87654321\n\n~'\''
$ json -b9 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b9 -e12 <<< $'\''87654321\n\n~'\''
$ json -b10 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b10 -e12 <<< $'\''87654321\n\n~'\''
$ json -b11 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b11 -e12 <<< $'\''87654321\n\n~'\''
$ json -b12 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b12 -e12 <<< $'\''87654321\n\n~'\''
$ json -b13 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b13 -e12 <<< $'\''87654321\n\n~'\''
$ json -b14 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b14 -e12 <<< $'\''87654321\n\n~'\''
$ json -b15 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b15 -e12 <<< $'\''87654321\n\n~'\''
$ json -b16 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b16 -e12 <<< $'\''87654321\n\n~'\''
$ json -b17 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b17 -e12 <<< $'\''87654321\n\n~'\''
$ json -b18 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b18 -e12 <<< $'\''87654321\n\n~'\''
$ json -b19 -e12 <<< $'\''87654321\n\n~'\''
json: error: <stdin>:3:1: lex error: invalid char
json: error: <stdin>:3:1: 87654321\n\n~
json: error: <stdin>:3:1:             ^
command failed: json -b19 -e12 <<< $'\''87654321\n\n~'\'''
) -L error-context4.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 -lOV "$@"; }'
json() { json0 -lOV "$@"; } 2>&1 ||
echo 'command failed: json() { json0 -lOV "$@"; }'

echo '$ json -b1 -e1 <<< $'\''87654321\n\n~'\'''
json -b1 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e1 <<< $'\''87654321\n\n~'\'''
json -b2 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e1 <<< $'\''87654321\n\n~'\'''
json -b3 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e1 <<< $'\''87654321\n\n~'\'''
json -b4 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e1 <<< $'\''87654321\n\n~'\'''
json -b5 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e1 <<< $'\''87654321\n\n~'\'''
json -b6 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e1 <<< $'\''87654321\n\n~'\'''
json -b7 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e1 <<< $'\''87654321\n\n~'\'''
json -b8 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e1 <<< $'\''87654321\n\n~'\'''
json -b9 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e1 <<< $'\''87654321\n\n~'\'''
json -b10 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e1 <<< $'\''87654321\n\n~'\'''
json -b11 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e1 <<< $'\''87654321\n\n~'\'''
json -b12 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e1 <<< $'\''87654321\n\n~'\'''
json -b13 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e1 <<< $'\''87654321\n\n~'\'''
json -b14 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e1 <<< $'\''87654321\n\n~'\'''
json -b15 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e1 <<< $'\''87654321\n\n~'\'''
json -b16 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e1 <<< $'\''87654321\n\n~'\'''
json -b17 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e1 <<< $'\''87654321\n\n~'\'''
json -b18 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e1 <<< $'\''87654321\n\n~'\'''
json -b19 -e1 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e1 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e2 <<< $'\''87654321\n\n~'\'''
json -b1 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e2 <<< $'\''87654321\n\n~'\'''
json -b2 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e2 <<< $'\''87654321\n\n~'\'''
json -b3 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e2 <<< $'\''87654321\n\n~'\'''
json -b4 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e2 <<< $'\''87654321\n\n~'\'''
json -b5 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e2 <<< $'\''87654321\n\n~'\'''
json -b6 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e2 <<< $'\''87654321\n\n~'\'''
json -b7 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e2 <<< $'\''87654321\n\n~'\'''
json -b8 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e2 <<< $'\''87654321\n\n~'\'''
json -b9 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e2 <<< $'\''87654321\n\n~'\'''
json -b10 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e2 <<< $'\''87654321\n\n~'\'''
json -b11 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e2 <<< $'\''87654321\n\n~'\'''
json -b12 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e2 <<< $'\''87654321\n\n~'\'''
json -b13 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e2 <<< $'\''87654321\n\n~'\'''
json -b14 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e2 <<< $'\''87654321\n\n~'\'''
json -b15 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e2 <<< $'\''87654321\n\n~'\'''
json -b16 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e2 <<< $'\''87654321\n\n~'\'''
json -b17 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e2 <<< $'\''87654321\n\n~'\'''
json -b18 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e2 <<< $'\''87654321\n\n~'\'''
json -b19 -e2 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e2 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e3 <<< $'\''87654321\n\n~'\'''
json -b1 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e3 <<< $'\''87654321\n\n~'\'''
json -b2 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e3 <<< $'\''87654321\n\n~'\'''
json -b3 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e3 <<< $'\''87654321\n\n~'\'''
json -b4 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e3 <<< $'\''87654321\n\n~'\'''
json -b5 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e3 <<< $'\''87654321\n\n~'\'''
json -b6 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e3 <<< $'\''87654321\n\n~'\'''
json -b7 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e3 <<< $'\''87654321\n\n~'\'''
json -b8 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e3 <<< $'\''87654321\n\n~'\'''
json -b9 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e3 <<< $'\''87654321\n\n~'\'''
json -b10 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e3 <<< $'\''87654321\n\n~'\'''
json -b11 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e3 <<< $'\''87654321\n\n~'\'''
json -b12 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e3 <<< $'\''87654321\n\n~'\'''
json -b13 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e3 <<< $'\''87654321\n\n~'\'''
json -b14 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e3 <<< $'\''87654321\n\n~'\'''
json -b15 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e3 <<< $'\''87654321\n\n~'\'''
json -b16 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e3 <<< $'\''87654321\n\n~'\'''
json -b17 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e3 <<< $'\''87654321\n\n~'\'''
json -b18 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e3 <<< $'\''87654321\n\n~'\'''
json -b19 -e3 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e3 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e4 <<< $'\''87654321\n\n~'\'''
json -b1 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e4 <<< $'\''87654321\n\n~'\'''
json -b2 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e4 <<< $'\''87654321\n\n~'\'''
json -b3 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e4 <<< $'\''87654321\n\n~'\'''
json -b4 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e4 <<< $'\''87654321\n\n~'\'''
json -b5 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e4 <<< $'\''87654321\n\n~'\'''
json -b6 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e4 <<< $'\''87654321\n\n~'\'''
json -b7 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e4 <<< $'\''87654321\n\n~'\'''
json -b8 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e4 <<< $'\''87654321\n\n~'\'''
json -b9 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e4 <<< $'\''87654321\n\n~'\'''
json -b10 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e4 <<< $'\''87654321\n\n~'\'''
json -b11 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e4 <<< $'\''87654321\n\n~'\'''
json -b12 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e4 <<< $'\''87654321\n\n~'\'''
json -b13 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e4 <<< $'\''87654321\n\n~'\'''
json -b14 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e4 <<< $'\''87654321\n\n~'\'''
json -b15 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e4 <<< $'\''87654321\n\n~'\'''
json -b16 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e4 <<< $'\''87654321\n\n~'\'''
json -b17 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e4 <<< $'\''87654321\n\n~'\'''
json -b18 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e4 <<< $'\''87654321\n\n~'\'''
json -b19 -e4 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e4 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e5 <<< $'\''87654321\n\n~'\'''
json -b1 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e5 <<< $'\''87654321\n\n~'\'''
json -b2 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e5 <<< $'\''87654321\n\n~'\'''
json -b3 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e5 <<< $'\''87654321\n\n~'\'''
json -b4 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e5 <<< $'\''87654321\n\n~'\'''
json -b5 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e5 <<< $'\''87654321\n\n~'\'''
json -b6 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e5 <<< $'\''87654321\n\n~'\'''
json -b7 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e5 <<< $'\''87654321\n\n~'\'''
json -b8 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e5 <<< $'\''87654321\n\n~'\'''
json -b9 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e5 <<< $'\''87654321\n\n~'\'''
json -b10 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e5 <<< $'\''87654321\n\n~'\'''
json -b11 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e5 <<< $'\''87654321\n\n~'\'''
json -b12 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e5 <<< $'\''87654321\n\n~'\'''
json -b13 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e5 <<< $'\''87654321\n\n~'\'''
json -b14 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e5 <<< $'\''87654321\n\n~'\'''
json -b15 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e5 <<< $'\''87654321\n\n~'\'''
json -b16 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e5 <<< $'\''87654321\n\n~'\'''
json -b17 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e5 <<< $'\''87654321\n\n~'\'''
json -b18 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e5 <<< $'\''87654321\n\n~'\'''
json -b19 -e5 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e5 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e6 <<< $'\''87654321\n\n~'\'''
json -b1 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e6 <<< $'\''87654321\n\n~'\'''
json -b2 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e6 <<< $'\''87654321\n\n~'\'''
json -b3 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e6 <<< $'\''87654321\n\n~'\'''
json -b4 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e6 <<< $'\''87654321\n\n~'\'''
json -b5 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e6 <<< $'\''87654321\n\n~'\'''
json -b6 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e6 <<< $'\''87654321\n\n~'\'''
json -b7 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e6 <<< $'\''87654321\n\n~'\'''
json -b8 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e6 <<< $'\''87654321\n\n~'\'''
json -b9 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e6 <<< $'\''87654321\n\n~'\'''
json -b10 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e6 <<< $'\''87654321\n\n~'\'''
json -b11 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e6 <<< $'\''87654321\n\n~'\'''
json -b12 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e6 <<< $'\''87654321\n\n~'\'''
json -b13 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e6 <<< $'\''87654321\n\n~'\'''
json -b14 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e6 <<< $'\''87654321\n\n~'\'''
json -b15 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e6 <<< $'\''87654321\n\n~'\'''
json -b16 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e6 <<< $'\''87654321\n\n~'\'''
json -b17 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e6 <<< $'\''87654321\n\n~'\'''
json -b18 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e6 <<< $'\''87654321\n\n~'\'''
json -b19 -e6 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e6 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e7 <<< $'\''87654321\n\n~'\'''
json -b1 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e7 <<< $'\''87654321\n\n~'\'''
json -b2 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e7 <<< $'\''87654321\n\n~'\'''
json -b3 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e7 <<< $'\''87654321\n\n~'\'''
json -b4 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e7 <<< $'\''87654321\n\n~'\'''
json -b5 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e7 <<< $'\''87654321\n\n~'\'''
json -b6 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e7 <<< $'\''87654321\n\n~'\'''
json -b7 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e7 <<< $'\''87654321\n\n~'\'''
json -b8 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e7 <<< $'\''87654321\n\n~'\'''
json -b9 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e7 <<< $'\''87654321\n\n~'\'''
json -b10 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e7 <<< $'\''87654321\n\n~'\'''
json -b11 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e7 <<< $'\''87654321\n\n~'\'''
json -b12 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e7 <<< $'\''87654321\n\n~'\'''
json -b13 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e7 <<< $'\''87654321\n\n~'\'''
json -b14 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e7 <<< $'\''87654321\n\n~'\'''
json -b15 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e7 <<< $'\''87654321\n\n~'\'''
json -b16 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e7 <<< $'\''87654321\n\n~'\'''
json -b17 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e7 <<< $'\''87654321\n\n~'\'''
json -b18 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e7 <<< $'\''87654321\n\n~'\'''
json -b19 -e7 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e7 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e8 <<< $'\''87654321\n\n~'\'''
json -b1 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e8 <<< $'\''87654321\n\n~'\'''
json -b2 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e8 <<< $'\''87654321\n\n~'\'''
json -b3 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e8 <<< $'\''87654321\n\n~'\'''
json -b4 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e8 <<< $'\''87654321\n\n~'\'''
json -b5 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e8 <<< $'\''87654321\n\n~'\'''
json -b6 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e8 <<< $'\''87654321\n\n~'\'''
json -b7 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e8 <<< $'\''87654321\n\n~'\'''
json -b8 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e8 <<< $'\''87654321\n\n~'\'''
json -b9 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e8 <<< $'\''87654321\n\n~'\'''
json -b10 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e8 <<< $'\''87654321\n\n~'\'''
json -b11 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e8 <<< $'\''87654321\n\n~'\'''
json -b12 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e8 <<< $'\''87654321\n\n~'\'''
json -b13 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e8 <<< $'\''87654321\n\n~'\'''
json -b14 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e8 <<< $'\''87654321\n\n~'\'''
json -b15 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e8 <<< $'\''87654321\n\n~'\'''
json -b16 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e8 <<< $'\''87654321\n\n~'\'''
json -b17 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e8 <<< $'\''87654321\n\n~'\'''
json -b18 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e8 <<< $'\''87654321\n\n~'\'''
json -b19 -e8 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e8 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e9 <<< $'\''87654321\n\n~'\'''
json -b1 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e9 <<< $'\''87654321\n\n~'\'''
json -b2 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e9 <<< $'\''87654321\n\n~'\'''
json -b3 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e9 <<< $'\''87654321\n\n~'\'''
json -b4 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e9 <<< $'\''87654321\n\n~'\'''
json -b5 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e9 <<< $'\''87654321\n\n~'\'''
json -b6 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e9 <<< $'\''87654321\n\n~'\'''
json -b7 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e9 <<< $'\''87654321\n\n~'\'''
json -b8 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e9 <<< $'\''87654321\n\n~'\'''
json -b9 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e9 <<< $'\''87654321\n\n~'\'''
json -b10 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e9 <<< $'\''87654321\n\n~'\'''
json -b11 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e9 <<< $'\''87654321\n\n~'\'''
json -b12 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e9 <<< $'\''87654321\n\n~'\'''
json -b13 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e9 <<< $'\''87654321\n\n~'\'''
json -b14 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e9 <<< $'\''87654321\n\n~'\'''
json -b15 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e9 <<< $'\''87654321\n\n~'\'''
json -b16 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e9 <<< $'\''87654321\n\n~'\'''
json -b17 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e9 <<< $'\''87654321\n\n~'\'''
json -b18 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e9 <<< $'\''87654321\n\n~'\'''
json -b19 -e9 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e9 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e10 <<< $'\''87654321\n\n~'\'''
json -b1 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e10 <<< $'\''87654321\n\n~'\'''
json -b2 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e10 <<< $'\''87654321\n\n~'\'''
json -b3 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e10 <<< $'\''87654321\n\n~'\'''
json -b4 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e10 <<< $'\''87654321\n\n~'\'''
json -b5 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e10 <<< $'\''87654321\n\n~'\'''
json -b6 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e10 <<< $'\''87654321\n\n~'\'''
json -b7 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e10 <<< $'\''87654321\n\n~'\'''
json -b8 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e10 <<< $'\''87654321\n\n~'\'''
json -b9 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e10 <<< $'\''87654321\n\n~'\'''
json -b10 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e10 <<< $'\''87654321\n\n~'\'''
json -b11 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e10 <<< $'\''87654321\n\n~'\'''
json -b12 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e10 <<< $'\''87654321\n\n~'\'''
json -b13 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e10 <<< $'\''87654321\n\n~'\'''
json -b14 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e10 <<< $'\''87654321\n\n~'\'''
json -b15 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e10 <<< $'\''87654321\n\n~'\'''
json -b16 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e10 <<< $'\''87654321\n\n~'\'''
json -b17 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e10 <<< $'\''87654321\n\n~'\'''
json -b18 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e10 <<< $'\''87654321\n\n~'\'''
json -b19 -e10 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e10 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e11 <<< $'\''87654321\n\n~'\'''
json -b1 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e11 <<< $'\''87654321\n\n~'\'''
json -b2 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e11 <<< $'\''87654321\n\n~'\'''
json -b3 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e11 <<< $'\''87654321\n\n~'\'''
json -b4 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e11 <<< $'\''87654321\n\n~'\'''
json -b5 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e11 <<< $'\''87654321\n\n~'\'''
json -b6 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e11 <<< $'\''87654321\n\n~'\'''
json -b7 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e11 <<< $'\''87654321\n\n~'\'''
json -b8 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e11 <<< $'\''87654321\n\n~'\'''
json -b9 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e11 <<< $'\''87654321\n\n~'\'''
json -b10 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e11 <<< $'\''87654321\n\n~'\'''
json -b11 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e11 <<< $'\''87654321\n\n~'\'''
json -b12 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e11 <<< $'\''87654321\n\n~'\'''
json -b13 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e11 <<< $'\''87654321\n\n~'\'''
json -b14 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e11 <<< $'\''87654321\n\n~'\'''
json -b15 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e11 <<< $'\''87654321\n\n~'\'''
json -b16 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e11 <<< $'\''87654321\n\n~'\'''
json -b17 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e11 <<< $'\''87654321\n\n~'\'''
json -b18 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e11 <<< $'\''87654321\n\n~'\'''
json -b19 -e11 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e11 <<< $'\''87654321\n\n~'\'''

echo '$ json -b1 -e12 <<< $'\''87654321\n\n~'\'''
json -b1 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b1 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b2 -e12 <<< $'\''87654321\n\n~'\'''
json -b2 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b2 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b3 -e12 <<< $'\''87654321\n\n~'\'''
json -b3 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b3 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b4 -e12 <<< $'\''87654321\n\n~'\'''
json -b4 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b4 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b5 -e12 <<< $'\''87654321\n\n~'\'''
json -b5 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b5 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b6 -e12 <<< $'\''87654321\n\n~'\'''
json -b6 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b6 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b7 -e12 <<< $'\''87654321\n\n~'\'''
json -b7 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b7 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b8 -e12 <<< $'\''87654321\n\n~'\'''
json -b8 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b8 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b9 -e12 <<< $'\''87654321\n\n~'\'''
json -b9 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b9 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b10 -e12 <<< $'\''87654321\n\n~'\'''
json -b10 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b10 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b11 -e12 <<< $'\''87654321\n\n~'\'''
json -b11 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b11 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b12 -e12 <<< $'\''87654321\n\n~'\'''
json -b12 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b12 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b13 -e12 <<< $'\''87654321\n\n~'\'''
json -b13 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b13 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b14 -e12 <<< $'\''87654321\n\n~'\'''
json -b14 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b14 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b15 -e12 <<< $'\''87654321\n\n~'\'''
json -b15 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b15 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b16 -e12 <<< $'\''87654321\n\n~'\'''
json -b16 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b16 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b17 -e12 <<< $'\''87654321\n\n~'\'''
json -b17 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b17 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b18 -e12 <<< $'\''87654321\n\n~'\'''
json -b18 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b18 -e12 <<< $'\''87654321\n\n~'\'''

echo '$ json -b19 -e12 <<< $'\''87654321\n\n~'\'''
json -b19 -e12 <<< $'87654321\n\n~' 2>&1 ||
echo 'command failed: json -b19 -e12 <<< $'\''87654321\n\n~'\'''
)

