#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def:node-list-dict-any2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-list-dict-any2.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\''
json: error: <stdin>:1:24: attribute error: invalid "list" type object: element is a "dict" (the "list" begins at 1:1)
command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
) -L node-list-dict-any2.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"faa","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
json <<< '{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"faa","type":"object"}]}]}'\'''
)

