#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:obj-type-basic3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L obj-type-basic3.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''[{"name":"foo","type":"n"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"n"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"n"}]'\''
$ json <<< '\''[{"name":"foo","type":"n?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"n?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"n?"}]'\''
$ json <<< '\''[{"name":"foo","type":"nu"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"nu"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"nu"}]'\''
$ json <<< '\''[{"name":"foo","type":"nu?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"nu?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"nu?"}]'\''
$ json <<< '\''[{"name":"foo","type":"nul"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"nul"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"nul"}]'\''
$ json <<< '\''[{"name":"foo","type":"nul?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"nul?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"nul?"}]'\''
$ json <<< '\''[{"name":"foo","type":"null"}]'\''
[
    {
        "name": "foo",
        "type": "null"
    }
]
$ json <<< '\''[{"name":"foo","type":"null?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"null?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"null?"}]'\''
$ json <<< '\''[{"name":"foo","type":"t"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"t"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"t"}]'\''
$ json <<< '\''[{"name":"foo","type":"t?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"t?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"t?"}]'\''
$ json <<< '\''[{"name":"foo","type":"ty"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"ty"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"ty"}]'\''
$ json <<< '\''[{"name":"foo","type":"ty?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"ty?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"ty?"}]'\''
$ json <<< '\''[{"name":"foo","type":"typ"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"typ"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"typ"}]'\''
$ json <<< '\''[{"name":"foo","type":"typ?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"typ?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"typ?"}]'\''
$ json <<< '\''[{"name":"foo","type":"type"}]'\''
[
    {
        "name": "foo",
        "type": "type"
    }
]
$ json <<< '\''[{"name":"foo","type":"type?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"type?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"type?"}]'\''
$ json <<< '\''[{"name":"foo","type":"b"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"b"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"b"}]'\''
$ json <<< '\''[{"name":"foo","type":"b?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"b?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"b?"}]'\''
$ json <<< '\''[{"name":"foo","type":"bo"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"bo"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"bo"}]'\''
$ json <<< '\''[{"name":"foo","type":"bo?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"bo?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"bo?"}]'\''
$ json <<< '\''[{"name":"foo","type":"boo"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boo"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boo"}]'\''
$ json <<< '\''[{"name":"foo","type":"boo?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boo?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boo?"}]'\''
$ json <<< '\''[{"name":"foo","type":"bool"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"bool"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"bool"}]'\''
$ json <<< '\''[{"name":"foo","type":"bool?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"bool?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"bool?"}]'\''
$ json <<< '\''[{"name":"foo","type":"boole"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boole"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boole"}]'\''
$ json <<< '\''[{"name":"foo","type":"boole?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boole?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boole?"}]'\''
$ json <<< '\''[{"name":"foo","type":"boolea"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boolea"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boolea"}]'\''
$ json <<< '\''[{"name":"foo","type":"boolea?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boolea?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boolea?"}]'\''
$ json <<< '\''[{"name":"foo","type":"boolean"}]'\''
[
    {
        "name": "foo",
        "type": "boolean"
    }
]
$ json <<< '\''[{"name":"foo","type":"boolean?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"boolean?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"boolean?"}]'\''
$ json <<< '\''[{"name":"foo","type":"n"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"n"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"n"}]'\''
$ json <<< '\''[{"name":"foo","type":"n?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"n?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"n?"}]'\''
$ json <<< '\''[{"name":"foo","type":"nu"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"nu"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"nu"}]'\''
$ json <<< '\''[{"name":"foo","type":"nu?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"nu?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"nu?"}]'\''
$ json <<< '\''[{"name":"foo","type":"num"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"num"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"num"}]'\''
$ json <<< '\''[{"name":"foo","type":"num?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"num?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"num?"}]'\''
$ json <<< '\''[{"name":"foo","type":"numb"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"numb"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"numb"}]'\''
$ json <<< '\''[{"name":"foo","type":"numb?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"numb?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"numb?"}]'\''
$ json <<< '\''[{"name":"foo","type":"numbe"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"numbe"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"numbe"}]'\''
$ json <<< '\''[{"name":"foo","type":"numbe?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"numbe?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"numbe?"}]'\''
$ json <<< '\''[{"name":"foo","type":"number"}]'\''
[
    {
        "name": "foo",
        "type": "number"
    }
]
$ json <<< '\''[{"name":"foo","type":"number?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"number?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"number?"}]'\''
$ json <<< '\''[{"name":"foo","type":"s"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"s"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"s"}]'\''
$ json <<< '\''[{"name":"foo","type":"s?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"s?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"s?"}]'\''
$ json <<< '\''[{"name":"foo","type":"st"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"st"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"st"}]'\''
$ json <<< '\''[{"name":"foo","type":"st?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"st?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"st?"}]'\''
$ json <<< '\''[{"name":"foo","type":"str"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"str"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"str"}]'\''
$ json <<< '\''[{"name":"foo","type":"str?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"str?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"str?"}]'\''
$ json <<< '\''[{"name":"foo","type":"stri"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"stri"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"stri"}]'\''
$ json <<< '\''[{"name":"foo","type":"stri?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"stri?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"stri?"}]'\''
$ json <<< '\''[{"name":"foo","type":"strin"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"strin"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"strin"}]'\''
$ json <<< '\''[{"name":"foo","type":"strin?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"strin?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"strin?"}]'\''
$ json <<< '\''[{"name":"foo","type":"string"}]'\''
[
    {
        "name": "foo",
        "type": "string"
    }
]
$ json <<< '\''[{"name":"foo","type":"string?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"string?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"string?"}]'\''
$ json <<< '\''[{"name":"foo","type":"o"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"o"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"o"}]'\''
$ json <<< '\''[{"name":"foo","type":"o?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"o?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"o?"}]'\''
$ json <<< '\''[{"name":"foo","type":"ob"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"ob"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"ob"}]'\''
$ json <<< '\''[{"name":"foo","type":"ob?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"ob?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"ob?"}]'\''
$ json <<< '\''[{"name":"foo","type":"obj"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"obj"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"obj"}]'\''
$ json <<< '\''[{"name":"foo","type":"obj?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"obj?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"obj?"}]'\''
$ json <<< '\''[{"name":"foo","type":"obje"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"obje"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"obje"}]'\''
$ json <<< '\''[{"name":"foo","type":"obje?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"obje?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"obje?"}]'\''
$ json <<< '\''[{"name":"foo","type":"objec"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"objec"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"objec"}]'\''
$ json <<< '\''[{"name":"foo","type":"objec?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"objec?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"objec?"}]'\''
$ json <<< '\''[{"name":"foo","type":"object"}]'\''
[
    {
        "name": "foo",
        "type": "object"
    }
]
$ json <<< '\''[{"name":"foo","type":"object?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"object?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"object?"}]'\''
$ json <<< '\''[{"name":"foo","type":"a"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"a"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"a"}]'\''
$ json <<< '\''[{"name":"foo","type":"a?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"a?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"a?"}]'\''
$ json <<< '\''[{"name":"foo","type":"ar"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"ar"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"ar"}]'\''
$ json <<< '\''[{"name":"foo","type":"ar?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"ar?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"ar?"}]'\''
$ json <<< '\''[{"name":"foo","type":"arr"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"arr"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"arr"}]'\''
$ json <<< '\''[{"name":"foo","type":"arr?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"arr?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"arr?"}]'\''
$ json <<< '\''[{"name":"foo","type":"arra"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"arra"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"arra"}]'\''
$ json <<< '\''[{"name":"foo","type":"arra?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"arra?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"arra?"}]'\''
$ json <<< '\''[{"name":"foo","type":"array"}]'\''
[
    {
        "name": "foo",
        "type": "array"
    }
]
$ json <<< '\''[{"name":"foo","type":"array?"}]'\''
json: error: <stdin>:1:23: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:23: [{"name":"foo","type":"array?"}]
json: error: <stdin>:1:23:                       ^
command failed: json <<< '\''[{"name":"foo","type":"array?"}]'\'''
) -L obj-type-basic3.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''[{"name":"foo","type":"n"}]'\'''
json <<< '[{"name":"foo","type":"n"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"n"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"n?"}]'\'''
json <<< '[{"name":"foo","type":"n?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"n?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"nu"}]'\'''
json <<< '[{"name":"foo","type":"nu"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"nu"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"nu?"}]'\'''
json <<< '[{"name":"foo","type":"nu?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"nu?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"nul"}]'\'''
json <<< '[{"name":"foo","type":"nul"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"nul"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"nul?"}]'\'''
json <<< '[{"name":"foo","type":"nul?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"nul?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"null"}]'\'''
json <<< '[{"name":"foo","type":"null"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"null"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"null?"}]'\'''
json <<< '[{"name":"foo","type":"null?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"null?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"t"}]'\'''
json <<< '[{"name":"foo","type":"t"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"t"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"t?"}]'\'''
json <<< '[{"name":"foo","type":"t?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"t?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"ty"}]'\'''
json <<< '[{"name":"foo","type":"ty"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"ty"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"ty?"}]'\'''
json <<< '[{"name":"foo","type":"ty?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"ty?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"typ"}]'\'''
json <<< '[{"name":"foo","type":"typ"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"typ"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"typ?"}]'\'''
json <<< '[{"name":"foo","type":"typ?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"typ?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"type"}]'\'''
json <<< '[{"name":"foo","type":"type"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"type"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"type?"}]'\'''
json <<< '[{"name":"foo","type":"type?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"type?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"b"}]'\'''
json <<< '[{"name":"foo","type":"b"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"b"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"b?"}]'\'''
json <<< '[{"name":"foo","type":"b?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"b?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"bo"}]'\'''
json <<< '[{"name":"foo","type":"bo"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"bo"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"bo?"}]'\'''
json <<< '[{"name":"foo","type":"bo?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"bo?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boo"}]'\'''
json <<< '[{"name":"foo","type":"boo"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boo"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boo?"}]'\'''
json <<< '[{"name":"foo","type":"boo?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boo?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"bool"}]'\'''
json <<< '[{"name":"foo","type":"bool"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"bool"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"bool?"}]'\'''
json <<< '[{"name":"foo","type":"bool?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"bool?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boole"}]'\'''
json <<< '[{"name":"foo","type":"boole"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boole"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boole?"}]'\'''
json <<< '[{"name":"foo","type":"boole?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boole?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boolea"}]'\'''
json <<< '[{"name":"foo","type":"boolea"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boolea"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boolea?"}]'\'''
json <<< '[{"name":"foo","type":"boolea?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boolea?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boolean"}]'\'''
json <<< '[{"name":"foo","type":"boolean"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boolean"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"boolean?"}]'\'''
json <<< '[{"name":"foo","type":"boolean?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"boolean?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"n"}]'\'''
json <<< '[{"name":"foo","type":"n"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"n"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"n?"}]'\'''
json <<< '[{"name":"foo","type":"n?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"n?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"nu"}]'\'''
json <<< '[{"name":"foo","type":"nu"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"nu"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"nu?"}]'\'''
json <<< '[{"name":"foo","type":"nu?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"nu?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"num"}]'\'''
json <<< '[{"name":"foo","type":"num"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"num"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"num?"}]'\'''
json <<< '[{"name":"foo","type":"num?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"num?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"numb"}]'\'''
json <<< '[{"name":"foo","type":"numb"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"numb"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"numb?"}]'\'''
json <<< '[{"name":"foo","type":"numb?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"numb?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"numbe"}]'\'''
json <<< '[{"name":"foo","type":"numbe"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"numbe"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"numbe?"}]'\'''
json <<< '[{"name":"foo","type":"numbe?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"numbe?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"number"}]'\'''
json <<< '[{"name":"foo","type":"number"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"number"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"number?"}]'\'''
json <<< '[{"name":"foo","type":"number?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"number?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"s"}]'\'''
json <<< '[{"name":"foo","type":"s"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"s"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"s?"}]'\'''
json <<< '[{"name":"foo","type":"s?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"s?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"st"}]'\'''
json <<< '[{"name":"foo","type":"st"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"st"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"st?"}]'\'''
json <<< '[{"name":"foo","type":"st?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"st?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"str"}]'\'''
json <<< '[{"name":"foo","type":"str"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"str"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"str?"}]'\'''
json <<< '[{"name":"foo","type":"str?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"str?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"stri"}]'\'''
json <<< '[{"name":"foo","type":"stri"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"stri"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"stri?"}]'\'''
json <<< '[{"name":"foo","type":"stri?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"stri?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"strin"}]'\'''
json <<< '[{"name":"foo","type":"strin"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"strin"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"strin?"}]'\'''
json <<< '[{"name":"foo","type":"strin?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"strin?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"string"}]'\'''
json <<< '[{"name":"foo","type":"string"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"string"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"string?"}]'\'''
json <<< '[{"name":"foo","type":"string?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"string?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"o"}]'\'''
json <<< '[{"name":"foo","type":"o"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"o"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"o?"}]'\'''
json <<< '[{"name":"foo","type":"o?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"o?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"ob"}]'\'''
json <<< '[{"name":"foo","type":"ob"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"ob"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"ob?"}]'\'''
json <<< '[{"name":"foo","type":"ob?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"ob?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"obj"}]'\'''
json <<< '[{"name":"foo","type":"obj"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"obj"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"obj?"}]'\'''
json <<< '[{"name":"foo","type":"obj?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"obj?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"obje"}]'\'''
json <<< '[{"name":"foo","type":"obje"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"obje"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"obje?"}]'\'''
json <<< '[{"name":"foo","type":"obje?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"obje?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"objec"}]'\'''
json <<< '[{"name":"foo","type":"objec"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"objec"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"objec?"}]'\'''
json <<< '[{"name":"foo","type":"objec?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"objec?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"object"}]'\'''
json <<< '[{"name":"foo","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"object"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"object?"}]'\'''
json <<< '[{"name":"foo","type":"object?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"object?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"a"}]'\'''
json <<< '[{"name":"foo","type":"a"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"a"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"a?"}]'\'''
json <<< '[{"name":"foo","type":"a?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"a?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"ar"}]'\'''
json <<< '[{"name":"foo","type":"ar"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"ar"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"ar?"}]'\'''
json <<< '[{"name":"foo","type":"ar?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"ar?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"arr"}]'\'''
json <<< '[{"name":"foo","type":"arr"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"arr"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"arr?"}]'\'''
json <<< '[{"name":"foo","type":"arr?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"arr?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"arra"}]'\'''
json <<< '[{"name":"foo","type":"arra"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"arra"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"arra?"}]'\'''
json <<< '[{"name":"foo","type":"arra?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"arra?"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"array"}]'\'''
json <<< '[{"name":"foo","type":"array"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"array"}]'\'''

echo '$ json <<< '\''[{"name":"foo","type":"array?"}]'\'''
json <<< '[{"name":"foo","type":"array?"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"foo","type":"array?"}]'\'''
)

