#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number12
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number12.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --no-literal-value "$@"; }
$ echo -n 0|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 0
json: error: <stdin>:1:1: ^
command failed: echo -n 0|json -b 1
$ echo -n 0|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 0
json: error: <stdin>:1:1: ^
command failed: echo -n 0|json -b 2
$ echo -n 1|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 1
json: error: <stdin>:1:1: ^
command failed: echo -n 1|json -b 1
$ echo -n 1|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 1
json: error: <stdin>:1:1: ^
command failed: echo -n 1|json -b 2
$ echo -n 2|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 2
json: error: <stdin>:1:1: ^
command failed: echo -n 2|json -b 1
$ echo -n 2|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 2
json: error: <stdin>:1:1: ^
command failed: echo -n 2|json -b 2
$ echo -n 3|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 3
json: error: <stdin>:1:1: ^
command failed: echo -n 3|json -b 1
$ echo -n 3|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 3
json: error: <stdin>:1:1: ^
command failed: echo -n 3|json -b 2
$ echo -n 4|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 4
json: error: <stdin>:1:1: ^
command failed: echo -n 4|json -b 1
$ echo -n 4|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 4
json: error: <stdin>:1:1: ^
command failed: echo -n 4|json -b 2
$ echo -n 5|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 5
json: error: <stdin>:1:1: ^
command failed: echo -n 5|json -b 1
$ echo -n 5|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 5
json: error: <stdin>:1:1: ^
command failed: echo -n 5|json -b 2
$ echo -n 6|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 6
json: error: <stdin>:1:1: ^
command failed: echo -n 6|json -b 1
$ echo -n 6|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 6
json: error: <stdin>:1:1: ^
command failed: echo -n 6|json -b 2
$ echo -n 7|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 7
json: error: <stdin>:1:1: ^
command failed: echo -n 7|json -b 1
$ echo -n 7|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 7
json: error: <stdin>:1:1: ^
command failed: echo -n 7|json -b 2
$ echo -n 8|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 8
json: error: <stdin>:1:1: ^
command failed: echo -n 8|json -b 1
$ echo -n 8|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 8
json: error: <stdin>:1:1: ^
command failed: echo -n 8|json -b 2
$ echo -n 9|json -b 1
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 9
json: error: <stdin>:1:1: ^
command failed: echo -n 9|json -b 1
$ echo -n 9|json -b 2
json: error: <stdin>:1:1: parse error: literal values are not allowed
json: error: <stdin>:1:1: 9
json: error: <stdin>:1:1: ^
command failed: echo -n 9|json -b 2'
) -L number12.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --no-literal-value "$@"; }'
json() { json0 --no-literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --no-literal-value "$@"; }'

echo '$ echo -n 0|json -b 1'
echo -n 0|json -b 1 2>&1 ||
echo 'command failed: echo -n 0|json -b 1'

echo '$ echo -n 0|json -b 2'
echo -n 0|json -b 2 2>&1 ||
echo 'command failed: echo -n 0|json -b 2'

echo '$ echo -n 1|json -b 1'
echo -n 1|json -b 1 2>&1 ||
echo 'command failed: echo -n 1|json -b 1'

echo '$ echo -n 1|json -b 2'
echo -n 1|json -b 2 2>&1 ||
echo 'command failed: echo -n 1|json -b 2'

echo '$ echo -n 2|json -b 1'
echo -n 2|json -b 1 2>&1 ||
echo 'command failed: echo -n 2|json -b 1'

echo '$ echo -n 2|json -b 2'
echo -n 2|json -b 2 2>&1 ||
echo 'command failed: echo -n 2|json -b 2'

echo '$ echo -n 3|json -b 1'
echo -n 3|json -b 1 2>&1 ||
echo 'command failed: echo -n 3|json -b 1'

echo '$ echo -n 3|json -b 2'
echo -n 3|json -b 2 2>&1 ||
echo 'command failed: echo -n 3|json -b 2'

echo '$ echo -n 4|json -b 1'
echo -n 4|json -b 1 2>&1 ||
echo 'command failed: echo -n 4|json -b 1'

echo '$ echo -n 4|json -b 2'
echo -n 4|json -b 2 2>&1 ||
echo 'command failed: echo -n 4|json -b 2'

echo '$ echo -n 5|json -b 1'
echo -n 5|json -b 1 2>&1 ||
echo 'command failed: echo -n 5|json -b 1'

echo '$ echo -n 5|json -b 2'
echo -n 5|json -b 2 2>&1 ||
echo 'command failed: echo -n 5|json -b 2'

echo '$ echo -n 6|json -b 1'
echo -n 6|json -b 1 2>&1 ||
echo 'command failed: echo -n 6|json -b 1'

echo '$ echo -n 6|json -b 2'
echo -n 6|json -b 2 2>&1 ||
echo 'command failed: echo -n 6|json -b 2'

echo '$ echo -n 7|json -b 1'
echo -n 7|json -b 1 2>&1 ||
echo 'command failed: echo -n 7|json -b 1'

echo '$ echo -n 7|json -b 2'
echo -n 7|json -b 2 2>&1 ||
echo 'command failed: echo -n 7|json -b 2'

echo '$ echo -n 8|json -b 1'
echo -n 8|json -b 1 2>&1 ||
echo 'command failed: echo -n 8|json -b 1'

echo '$ echo -n 8|json -b 2'
echo -n 8|json -b 2 2>&1 ||
echo 'command failed: echo -n 8|json -b 2'

echo '$ echo -n 9|json -b 1'
echo -n 9|json -b 1 2>&1 ||
echo 'command failed: echo -n 9|json -b 1'

echo '$ echo -n 9|json -b 2'
echo -n 9|json -b 2 2>&1 ||
echo 'command failed: echo -n 9|json -b 2'
)

