#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-plain-closed-array-plain-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-plain-closed-array-plain-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
) -L list-closed-array-plain-closed-array-plain-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"}]},{"type":"array","args":[{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
)

