#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:dyn-lib4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dyn-lib4.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ json() { json0 -F "$@"; }
$ json ../lib/test-filter.so -- libs/test-type/test-type.so
json: warning: action `-F|--filterlib-exec'\'': ignoring the filter command line arguments since input file was given
usage: test-filter.so [ACTION|OPTION]...
where actions are specified as:
  -G|--generic         print out the text '\''generic action'\''
the options are:
  -f|--fail=WHERE      set where the filter to fail or make
     --no-fail           it to not fail at all; WHERE can be
                         any of: '\''init'\'', '\''handler'\'' or '\''exec'\''
  -d|--dump-options    print parsed options and exit
  -v|--version         print version numbers and exit
  -?|--help            display this help info and exit
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -V ../lib/test-filter.so -- libs/test-type/test-type.so
json: warning: action `-F|--filterlib-exec'\'': ignoring the filter command line arguments since input file was given
usage: test-filter.so [ACTION|OPTION]...
where actions are specified as:
  -G|--generic         print out the text '\''generic action'\''
the options are:
  -f|--fail=WHERE      set where the filter to fail or make
     --no-fail           it to not fail at all; WHERE can be
                         any of: '\''init'\'', '\''handler'\'' or '\''exec'\''
  -d|--dump-options    print parsed options and exit
  -v|--version         print version numbers and exit
  -?|--help            display this help info and exit
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e
json: warning: action `-F|--filterlib-exec'\'': multiple filter command line arguments groups given
test-filter.so: generic action
$ json() { json0 -f "$@" <<< '\'''\''; }
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found
command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found
command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found
command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so
$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found
command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e
$ json -V ../lib/test-filter.so -- libs/test-type/test-type.so
json: error: libs/test-type/test-type.so: filter library: '\''filter_get_version'\'' symbol not found: dlsym failed: libs/test-type/test-type.so: undefined symbol: test_type_filter_get_version
command failed: json -V ../lib/test-filter.so -- libs/test-type/test-type.so
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found: dlsym failed: libs/test-type/test-type.so: undefined symbol: test_type_filter_get_version
command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found: dlsym failed: libs/test-type/test-type.so: undefined symbol: test_type_filter_get_version
command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found: dlsym failed: libs/test-type/test-type.so: undefined symbol: test_type_filter_get_version
command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so
$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e
json: error: libs/test-type/test-type.so: filter library #2: '\''filter_get_version'\'' symbol not found: dlsym failed: libs/test-type/test-type.so: undefined symbol: test_type_filter_get_version
command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'
) -L dyn-lib4.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ json() { json0 -F "$@"; }'
json() { json0 -F "$@"; } 2>&1 ||
echo 'command failed: json() { json0 -F "$@"; }'

echo '$ json ../lib/test-filter.so -- libs/test-type/test-type.so'
json ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'

echo '$ json -V ../lib/test-filter.so -- libs/test-type/test-type.so'
json -V ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json -V ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'

echo '$ json() { json0 -f "$@" <<< '\'''\''; }'
json() { json0 -f "$@" <<< ''; } 2>&1 ||
echo 'command failed: json() { json0 -f "$@" <<< '\'''\''; }'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'

echo '$ json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'
json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'

echo '$ json -V ../lib/test-filter.so -- libs/test-type/test-type.so'
json -V ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json -V ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so -- ./foo.so'

echo '$ json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'
json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e 2>&1 ||
echo 'command failed: json -V -- ../lib/test-filter.so -- libs/test-type/test-type.so a b c -- ./foo.so d e'
)

