#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-plain-val-object-fuu-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-plain-val-object-fuu-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"baz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":"buz"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "bar" or "foo"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
) -L list-object-foo-basic-object-bar-plain-val-object-fuu-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"baz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":"buz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":"buz"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":{"plain":"buz"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
)

