#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:trim5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L trim5.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 1
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 2
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 3
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 4
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 5
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 6
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 7
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 8
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 9
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 10
A\f\fB
$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 11
A\f\fB
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 1
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 2
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 3
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 4
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 5
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 6
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 7
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 8
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 9
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 10
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 11
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 12
A\f\f\u0081
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12
A\f\f\u0801
$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13
A\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 1
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 2
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 3
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 4
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 5
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 6
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 7
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 8
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 9
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 10
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 11
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 12
\u0080\f\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 1
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 2
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 3
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 4
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 5
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 6
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 7
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 8
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 9
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 10
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 11
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 12
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 13
\u0080\f\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0080\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 1
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 2
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 3
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 4
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 5
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 6
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 7
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 8
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 9
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 10
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 11
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 12
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 13
\u0800\f\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 1
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 2
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 3
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 4
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 5
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 6
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 7
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 8
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 9
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 10
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 11
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 12
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 13
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 14
\u0800\f\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\f\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 15
\u0800\f\f\u0801
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 1
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 2
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 3
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 4
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 5
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 6
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 7
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 8
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 9
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 10
A\n\nB
$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 11
A\n\nB
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 1
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 2
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 3
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 4
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 5
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 6
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 7
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 8
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 9
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 10
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 11
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 12
A\n\n\u0081
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12
A\n\n\u0801
$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13
A\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 1
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 2
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 3
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 4
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 5
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 6
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 7
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 8
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 9
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 10
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 11
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 12
\u0080\n\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 1
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 2
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 3
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 4
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 5
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 6
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 7
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 8
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 9
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 10
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 11
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 12
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 13
\u0080\n\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0080\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 1
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 2
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 3
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 4
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 5
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 6
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 7
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 8
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 9
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 10
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 11
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 12
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 13
\u0800\n\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 1
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 2
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 3
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 4
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 5
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 6
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 7
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 8
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 9
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 10
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 11
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 12
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 13
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 14
\u0800\n\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\n\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 15
\u0800\n\n\u0801
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 1
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 2
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 3
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 4
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 5
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 6
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 7
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 8
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 9
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 10
A\r\rB
$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 11
A\r\rB
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 1
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 2
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 3
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 4
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 5
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 6
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 7
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 8
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 9
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 10
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 11
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 12
A\r\r\u0081
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12
A\r\r\u0801
$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13
A\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 1
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 2
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 3
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 4
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 5
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 6
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 7
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 8
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 9
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 10
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 11
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 12
\u0080\r\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 1
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 2
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 3
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 4
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 5
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 6
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 7
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 8
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 9
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 10
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 11
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 12
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 13
\u0080\r\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0080\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 1
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 2
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 3
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 4
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 5
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 6
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 7
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 8
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 9
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 10
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 11
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 12
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 13
\u0800\r\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 1
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 2
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 3
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 4
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 5
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 6
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 7
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 8
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 9
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 10
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 11
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 12
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 13
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 14
\u0800\r\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\r\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 15
\u0800\r\r\u0801
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 1
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 2
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 3
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 4
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 5
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 6
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 7
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 8
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 9
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 10
A\t\tB
$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 11
A\t\tB
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 1
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 2
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 3
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 4
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 5
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 6
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 7
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 8
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 9
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 10
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 11
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 12
A\t\t\u0081
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12
A\t\t\u0801
$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13
A\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 1
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 2
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 3
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 4
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 5
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 6
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 7
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 8
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 9
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 10
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 11
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 12
\u0080\t\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 1
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 2
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 3
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 4
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 5
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 6
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 7
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 8
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 9
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 10
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 11
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 12
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 13
\u0080\t\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0080\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 1
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 2
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 3
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 4
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 5
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 6
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 7
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 8
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 9
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 10
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 11
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 12
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 13
\u0800\t\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 1
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 2
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 3
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 4
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 5
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 6
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 7
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 8
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 9
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 10
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 11
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 12
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 13
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 14
\u0800\t\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\t\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 15
\u0800\t\t\u0801
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 1
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 2
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 3
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 4
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 5
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 6
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 7
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 8
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 9
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 10
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 11
A\u000b\u000bB
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 1
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 2
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 3
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 4
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 5
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 6
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 7
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 8
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 9
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 10
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 11
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 12
A\u000b\u000b\u0081
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13
A\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 1
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 2
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 3
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 4
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 5
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 6
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 7
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 8
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 9
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 10
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 11
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 12
\u0080\u000b\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 1
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 2
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 3
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 4
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 5
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 6
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 7
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 8
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 9
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 10
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 11
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 12
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 13
\u0080\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0080\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 1
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 2
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 3
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 4
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 5
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 6
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 7
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 8
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 9
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 10
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 11
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 12
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 13
\u0800\u000b\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 1
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 2
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 3
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 4
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 5
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 6
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 7
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 8
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 9
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 10
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 11
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 12
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 13
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 14
\u0800\u000b\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 15
\u0800\u000b\u000b\u0801
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 1
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 2
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 3
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 4
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 5
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 6
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 7
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 8
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 9
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 10
A  B
$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 11
A  B
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 1
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 2
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 3
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 4
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 5
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 6
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 7
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 8
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 9
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 10
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 11
A  \u0081
$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 12
A  \u0081
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 1
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 2
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 3
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 4
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 5
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 6
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 7
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 8
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 9
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 10
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 11
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 12
A  \u0801
$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 13
A  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 1
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 2
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 3
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 4
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 5
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 6
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 7
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 8
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 9
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 10
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 11
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 12
\u0080  B
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 1
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 2
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 3
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 4
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 5
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 6
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 7
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 8
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 9
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 10
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 11
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 12
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 13
\u0080  \u0081
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080  \u0801
$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 14
\u0080  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 1
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 2
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 3
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 4
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 5
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 6
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 7
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 8
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 9
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 10
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 11
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 12
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 13
\u0800  B
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 1
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 2
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 3
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 4
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 5
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 6
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 7
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 8
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 9
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 10
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 11
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 12
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 13
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 14
\u0800  \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800  \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 15
\u0800  \u0801'
) -L trim5.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\f\fB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\fB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\f\f\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\tA\f\f\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\f\fB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\fB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\f\fB\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\fB\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xc2\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 15'
echo -ne '\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'|json -b 15 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\f\xe0\xa0\x81\v\v\v'\''|json -b 15'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\n\nB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\nB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\n\n\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\tA\n\n\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\n\nB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\nB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\n\nB\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\nB\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xc2\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 15'
echo -ne '\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'|json -b 15 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\n\xe0\xa0\x81\v\v\v'\''|json -b 15'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\r\rB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\rB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\r\r\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\tA\r\r\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\r\rB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\rB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\r\rB\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\rB\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xc2\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 15'
echo -ne '\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'|json -b 15 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\r\xe0\xa0\x81\v\v\v'\''|json -b 15'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\t\tB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\tB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\t\t\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\tA\t\t\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\t\tB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\tB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\t\tB\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\tB\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xc2\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 15'
echo -ne '\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'|json -b 15 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\t\xe0\xa0\x81\v\v\v'\''|json -b 15'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\v\vB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\vB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\v\v\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\tA\v\v\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\v\vB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\vB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\v\vB\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\vB\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xc2\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 15'
echo -ne '\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'|json -b 15 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\v\xe0\xa0\x81\v\v\v'\''|json -b 15'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA  B\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA  B\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA  B\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA  B\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA  B\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA  B\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA  B\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA  B\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA  B\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA  B\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA  B\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  B\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA  \xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\tA  \xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA  \xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80  B\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  B\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80  \xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80  \xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80  B\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  B\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xc2\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 15'
echo -ne '\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'|json -b 15 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80  \xe0\xa0\x81\v\v\v'\''|json -b 15'
)

