#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:op6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L op6.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }
$ test-expr '\''((a >= b) != c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= b) != c) && d'\'' '\''(a >= b) != c && d'\''
OK
$ diff-expr '\''((a >= b) != c) && d'\'' '\''a >= b != c && d'\''
OK
$ diff-expr '\''((a >= b) != c) && d'\'' '\''(a >= b != c) && d'\''
OK
$ test-expr '\''((a >= b) != c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= b) != c) && D'\'' '\''(a >= b) != c && D'\''
OK
$ diff-expr '\''((a >= b) != c) && D'\'' '\''a >= b != c && D'\''
OK
$ diff-expr '\''((a >= b) != c) && D'\'' '\''(a >= b != c) && D'\''
OK
$ test-expr '\''((a >= b) != C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= b) != C) && d'\'' '\''(a >= b) != C && d'\''
OK
$ diff-expr '\''((a >= b) != C) && d'\'' '\''a >= b != C && d'\''
OK
$ diff-expr '\''((a >= b) != C) && d'\'' '\''(a >= b != C) && d'\''
OK
$ test-expr '\''((a >= b) != C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= b) != C) && D'\'' '\''(a >= b) != C && D'\''
OK
$ diff-expr '\''((a >= b) != C) && D'\'' '\''a >= b != C && D'\''
OK
$ diff-expr '\''((a >= b) != C) && D'\'' '\''(a >= b != C) && D'\''
OK
$ test-expr '\''((a >= B) != c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= B) != c) && d'\'' '\''(a >= B) != c && d'\''
OK
$ diff-expr '\''((a >= B) != c) && d'\'' '\''a >= B != c && d'\''
OK
$ diff-expr '\''((a >= B) != c) && d'\'' '\''(a >= B != c) && d'\''
OK
$ test-expr '\''((a >= B) != c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= B) != c) && D'\'' '\''(a >= B) != c && D'\''
OK
$ diff-expr '\''((a >= B) != c) && D'\'' '\''a >= B != c && D'\''
OK
$ diff-expr '\''((a >= B) != c) && D'\'' '\''(a >= B != c) && D'\''
OK
$ test-expr '\''((a >= B) != C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= B) != C) && d'\'' '\''(a >= B) != C && d'\''
OK
$ diff-expr '\''((a >= B) != C) && d'\'' '\''a >= B != C && d'\''
OK
$ diff-expr '\''((a >= B) != C) && d'\'' '\''(a >= B != C) && d'\''
OK
$ test-expr '\''((a >= B) != C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= B) != C) && D'\'' '\''(a >= B) != C && D'\''
OK
$ diff-expr '\''((a >= B) != C) && D'\'' '\''a >= B != C && D'\''
OK
$ diff-expr '\''((a >= B) != C) && D'\'' '\''(a >= B != C) && D'\''
OK
$ test-expr '\''((A >= b) != c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= b) != c) && d'\'' '\''(A >= b) != c && d'\''
OK
$ diff-expr '\''((A >= b) != c) && d'\'' '\''A >= b != c && d'\''
OK
$ diff-expr '\''((A >= b) != c) && d'\'' '\''(A >= b != c) && d'\''
OK
$ test-expr '\''((A >= b) != c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= b) != c) && D'\'' '\''(A >= b) != c && D'\''
OK
$ diff-expr '\''((A >= b) != c) && D'\'' '\''A >= b != c && D'\''
OK
$ diff-expr '\''((A >= b) != c) && D'\'' '\''(A >= b != c) && D'\''
OK
$ test-expr '\''((A >= b) != C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= b) != C) && d'\'' '\''(A >= b) != C && d'\''
OK
$ diff-expr '\''((A >= b) != C) && d'\'' '\''A >= b != C && d'\''
OK
$ diff-expr '\''((A >= b) != C) && d'\'' '\''(A >= b != C) && d'\''
OK
$ test-expr '\''((A >= b) != C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= b) != C) && D'\'' '\''(A >= b) != C && D'\''
OK
$ diff-expr '\''((A >= b) != C) && D'\'' '\''A >= b != C && D'\''
OK
$ diff-expr '\''((A >= b) != C) && D'\'' '\''(A >= b != C) && D'\''
OK
$ test-expr '\''((A >= B) != c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= B) != c) && d'\'' '\''(A >= B) != c && d'\''
OK
$ diff-expr '\''((A >= B) != c) && d'\'' '\''A >= B != c && d'\''
OK
$ diff-expr '\''((A >= B) != c) && d'\'' '\''(A >= B != c) && d'\''
OK
$ test-expr '\''((A >= B) != c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= B) != c) && D'\'' '\''(A >= B) != c && D'\''
OK
$ diff-expr '\''((A >= B) != c) && D'\'' '\''A >= B != c && D'\''
OK
$ diff-expr '\''((A >= B) != c) && D'\'' '\''(A >= B != c) && D'\''
OK
$ test-expr '\''((A >= B) != C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= B) != C) && d'\'' '\''(A >= B) != C && d'\''
OK
$ diff-expr '\''((A >= B) != C) && d'\'' '\''A >= B != C && d'\''
OK
$ diff-expr '\''((A >= B) != C) && d'\'' '\''(A >= B != C) && d'\''
OK
$ test-expr '\''((A >= B) != C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= B) != C) && D'\'' '\''(A >= B) != C && D'\''
OK
$ diff-expr '\''((A >= B) != C) && D'\'' '\''A >= B != C && D'\''
OK
$ diff-expr '\''((A >= B) != C) && D'\'' '\''(A >= B != C) && D'\''
OK
$ test-expr '\''((a >= b) != c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= b) != c) || d'\'' '\''(a >= b) != c || d'\''
OK
$ diff-expr '\''((a >= b) != c) || d'\'' '\''a >= b != c || d'\''
OK
$ diff-expr '\''((a >= b) != c) || d'\'' '\''(a >= b != c) || d'\''
OK
$ test-expr '\''((a >= b) != c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= b) != c) || D'\'' '\''(a >= b) != c || D'\''
OK
$ diff-expr '\''((a >= b) != c) || D'\'' '\''a >= b != c || D'\''
OK
$ diff-expr '\''((a >= b) != c) || D'\'' '\''(a >= b != c) || D'\''
OK
$ test-expr '\''((a >= b) != C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= b) != C) || d'\'' '\''(a >= b) != C || d'\''
OK
$ diff-expr '\''((a >= b) != C) || d'\'' '\''a >= b != C || d'\''
OK
$ diff-expr '\''((a >= b) != C) || d'\'' '\''(a >= b != C) || d'\''
OK
$ test-expr '\''((a >= b) != C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= b) != C) || D'\'' '\''(a >= b) != C || D'\''
OK
$ diff-expr '\''((a >= b) != C) || D'\'' '\''a >= b != C || D'\''
OK
$ diff-expr '\''((a >= b) != C) || D'\'' '\''(a >= b != C) || D'\''
OK
$ test-expr '\''((a >= B) != c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= B) != c) || d'\'' '\''(a >= B) != c || d'\''
OK
$ diff-expr '\''((a >= B) != c) || d'\'' '\''a >= B != c || d'\''
OK
$ diff-expr '\''((a >= B) != c) || d'\'' '\''(a >= B != c) || d'\''
OK
$ test-expr '\''((a >= B) != c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= B) != c) || D'\'' '\''(a >= B) != c || D'\''
OK
$ diff-expr '\''((a >= B) != c) || D'\'' '\''a >= B != c || D'\''
OK
$ diff-expr '\''((a >= B) != c) || D'\'' '\''(a >= B != c) || D'\''
OK
$ test-expr '\''((a >= B) != C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= B) != C) || d'\'' '\''(a >= B) != C || d'\''
OK
$ diff-expr '\''((a >= B) != C) || d'\'' '\''a >= B != C || d'\''
OK
$ diff-expr '\''((a >= B) != C) || d'\'' '\''(a >= B != C) || d'\''
OK
$ test-expr '\''((a >= B) != C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= B) != C) || D'\'' '\''(a >= B) != C || D'\''
OK
$ diff-expr '\''((a >= B) != C) || D'\'' '\''a >= B != C || D'\''
OK
$ diff-expr '\''((a >= B) != C) || D'\'' '\''(a >= B != C) || D'\''
OK
$ test-expr '\''((A >= b) != c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= b) != c) || d'\'' '\''(A >= b) != c || d'\''
OK
$ diff-expr '\''((A >= b) != c) || d'\'' '\''A >= b != c || d'\''
OK
$ diff-expr '\''((A >= b) != c) || d'\'' '\''(A >= b != c) || d'\''
OK
$ test-expr '\''((A >= b) != c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= b) != c) || D'\'' '\''(A >= b) != c || D'\''
OK
$ diff-expr '\''((A >= b) != c) || D'\'' '\''A >= b != c || D'\''
OK
$ diff-expr '\''((A >= b) != c) || D'\'' '\''(A >= b != c) || D'\''
OK
$ test-expr '\''((A >= b) != C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= b) != C) || d'\'' '\''(A >= b) != C || d'\''
OK
$ diff-expr '\''((A >= b) != C) || d'\'' '\''A >= b != C || d'\''
OK
$ diff-expr '\''((A >= b) != C) || d'\'' '\''(A >= b != C) || d'\''
OK
$ test-expr '\''((A >= b) != C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= b) != C) || D'\'' '\''(A >= b) != C || D'\''
OK
$ diff-expr '\''((A >= b) != C) || D'\'' '\''A >= b != C || D'\''
OK
$ diff-expr '\''((A >= b) != C) || D'\'' '\''(A >= b != C) || D'\''
OK
$ test-expr '\''((A >= B) != c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= B) != c) || d'\'' '\''(A >= B) != c || d'\''
OK
$ diff-expr '\''((A >= B) != c) || d'\'' '\''A >= B != c || d'\''
OK
$ diff-expr '\''((A >= B) != c) || d'\'' '\''(A >= B != c) || d'\''
OK
$ test-expr '\''((A >= B) != c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= B) != c) || D'\'' '\''(A >= B) != c || D'\''
OK
$ diff-expr '\''((A >= B) != c) || D'\'' '\''A >= B != c || D'\''
OK
$ diff-expr '\''((A >= B) != c) || D'\'' '\''(A >= B != c) || D'\''
OK
$ test-expr '\''((A >= B) != C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= B) != C) || d'\'' '\''(A >= B) != C || d'\''
OK
$ diff-expr '\''((A >= B) != C) || d'\'' '\''A >= B != C || d'\''
OK
$ diff-expr '\''((A >= B) != C) || d'\'' '\''(A >= B != C) || d'\''
OK
$ test-expr '\''((A >= B) != C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= B) != C) || D'\'' '\''(A >= B) != C || D'\''
OK
$ diff-expr '\''((A >= B) != C) || D'\'' '\''A >= B != C || D'\''
OK
$ diff-expr '\''((A >= B) != C) || D'\'' '\''(A >= B != C) || D'\''
OK
$ test-expr '\''((a >= b) && c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a >= b) && c) || d'\'' '\''(a >= b) && c || d'\''
OK
$ diff-expr '\''((a >= b) && c) || d'\'' '\''a >= b && c || d'\''
OK
$ diff-expr '\''((a >= b) && c) || d'\'' '\''(a >= b && c) || d'\''
OK
$ test-expr '\''((a >= b) && c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a >= b) && c) || D'\'' '\''(a >= b) && c || D'\''
OK
$ diff-expr '\''((a >= b) && c) || D'\'' '\''a >= b && c || D'\''
OK
$ diff-expr '\''((a >= b) && c) || D'\'' '\''(a >= b && c) || D'\''
OK
$ test-expr '\''((a >= b) && C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= b) && C) || d'\'' '\''(a >= b) && C || d'\''
OK
$ diff-expr '\''((a >= b) && C) || d'\'' '\''a >= b && C || d'\''
OK
$ diff-expr '\''((a >= b) && C) || d'\'' '\''(a >= b && C) || d'\''
OK
$ test-expr '\''((a >= b) && C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= b) && C) || D'\'' '\''(a >= b) && C || D'\''
OK
$ diff-expr '\''((a >= b) && C) || D'\'' '\''a >= b && C || D'\''
OK
$ diff-expr '\''((a >= b) && C) || D'\'' '\''(a >= b && C) || D'\''
OK
$ test-expr '\''((a >= B) && c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a >= B) && c) || d'\'' '\''(a >= B) && c || d'\''
OK
$ diff-expr '\''((a >= B) && c) || d'\'' '\''a >= B && c || d'\''
OK
$ diff-expr '\''((a >= B) && c) || d'\'' '\''(a >= B && c) || d'\''
OK
$ test-expr '\''((a >= B) && c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a >= B) && c) || D'\'' '\''(a >= B) && c || D'\''
OK
$ diff-expr '\''((a >= B) && c) || D'\'' '\''a >= B && c || D'\''
OK
$ diff-expr '\''((a >= B) && c) || D'\'' '\''(a >= B && c) || D'\''
OK
$ test-expr '\''((a >= B) && C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= B) && C) || d'\'' '\''(a >= B) && C || d'\''
OK
$ diff-expr '\''((a >= B) && C) || d'\'' '\''a >= B && C || d'\''
OK
$ diff-expr '\''((a >= B) && C) || d'\'' '\''(a >= B && C) || d'\''
OK
$ test-expr '\''((a >= B) && C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= B) && C) || D'\'' '\''(a >= B) && C || D'\''
OK
$ diff-expr '\''((a >= B) && C) || D'\'' '\''a >= B && C || D'\''
OK
$ diff-expr '\''((a >= B) && C) || D'\'' '\''(a >= B && C) || D'\''
OK
$ test-expr '\''((A >= b) && c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A >= b) && c) || d'\'' '\''(A >= b) && c || d'\''
OK
$ diff-expr '\''((A >= b) && c) || d'\'' '\''A >= b && c || d'\''
OK
$ diff-expr '\''((A >= b) && c) || d'\'' '\''(A >= b && c) || d'\''
OK
$ test-expr '\''((A >= b) && c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A >= b) && c) || D'\'' '\''(A >= b) && c || D'\''
OK
$ diff-expr '\''((A >= b) && c) || D'\'' '\''A >= b && c || D'\''
OK
$ diff-expr '\''((A >= b) && c) || D'\'' '\''(A >= b && c) || D'\''
OK
$ test-expr '\''((A >= b) && C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= b) && C) || d'\'' '\''(A >= b) && C || d'\''
OK
$ diff-expr '\''((A >= b) && C) || d'\'' '\''A >= b && C || d'\''
OK
$ diff-expr '\''((A >= b) && C) || d'\'' '\''(A >= b && C) || d'\''
OK
$ test-expr '\''((A >= b) && C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= b) && C) || D'\'' '\''(A >= b) && C || D'\''
OK
$ diff-expr '\''((A >= b) && C) || D'\'' '\''A >= b && C || D'\''
OK
$ diff-expr '\''((A >= b) && C) || D'\'' '\''(A >= b && C) || D'\''
OK
$ test-expr '\''((A >= B) && c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A >= B) && c) || d'\'' '\''(A >= B) && c || d'\''
OK
$ diff-expr '\''((A >= B) && c) || d'\'' '\''A >= B && c || d'\''
OK
$ diff-expr '\''((A >= B) && c) || d'\'' '\''(A >= B && c) || d'\''
OK
$ test-expr '\''((A >= B) && c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A >= B) && c) || D'\'' '\''(A >= B) && c || D'\''
OK
$ diff-expr '\''((A >= B) && c) || D'\'' '\''A >= B && c || D'\''
OK
$ diff-expr '\''((A >= B) && c) || D'\'' '\''(A >= B && c) || D'\''
OK
$ test-expr '\''((A >= B) && C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= B) && C) || d'\'' '\''(A >= B) && C || d'\''
OK
$ diff-expr '\''((A >= B) && C) || d'\'' '\''A >= B && C || d'\''
OK
$ diff-expr '\''((A >= B) && C) || d'\'' '\''(A >= B && C) || d'\''
OK
$ test-expr '\''((A >= B) && C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= B) && C) || D'\'' '\''(A >= B) && C || D'\''
OK
$ diff-expr '\''((A >= B) && C) || D'\'' '\''A >= B && C || D'\''
OK
$ diff-expr '\''((A >= B) && C) || D'\'' '\''(A >= B && C) || D'\''
OK
$ test-expr '\''((a != b) && c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a != b) && c) || d'\'' '\''(a != b) && c || d'\''
OK
$ diff-expr '\''((a != b) && c) || d'\'' '\''a != b && c || d'\''
OK
$ diff-expr '\''((a != b) && c) || d'\'' '\''(a != b && c) || d'\''
OK
$ test-expr '\''((a != b) && c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a != b) && c) || D'\'' '\''(a != b) && c || D'\''
OK
$ diff-expr '\''((a != b) && c) || D'\'' '\''a != b && c || D'\''
OK
$ diff-expr '\''((a != b) && c) || D'\'' '\''(a != b && c) || D'\''
OK
$ test-expr '\''((a != b) && C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != b) && C) || d'\'' '\''(a != b) && C || d'\''
OK
$ diff-expr '\''((a != b) && C) || d'\'' '\''a != b && C || d'\''
OK
$ diff-expr '\''((a != b) && C) || d'\'' '\''(a != b && C) || d'\''
OK
$ test-expr '\''((a != b) && C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a != b) && C) || D'\'' '\''(a != b) && C || D'\''
OK
$ diff-expr '\''((a != b) && C) || D'\'' '\''a != b && C || D'\''
OK
$ diff-expr '\''((a != b) && C) || D'\'' '\''(a != b && C) || D'\''
OK
$ test-expr '\''((a != B) && c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a != B) && c) || d'\'' '\''(a != B) && c || d'\''
OK
$ diff-expr '\''((a != B) && c) || d'\'' '\''a != B && c || d'\''
OK
$ diff-expr '\''((a != B) && c) || d'\'' '\''(a != B && c) || d'\''
OK
$ test-expr '\''((a != B) && c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a != B) && c) || D'\'' '\''(a != B) && c || D'\''
OK
$ diff-expr '\''((a != B) && c) || D'\'' '\''a != B && c || D'\''
OK
$ diff-expr '\''((a != B) && c) || D'\'' '\''(a != B && c) || D'\''
OK
$ test-expr '\''((a != B) && C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != B) && C) || d'\'' '\''(a != B) && C || d'\''
OK
$ diff-expr '\''((a != B) && C) || d'\'' '\''a != B && C || d'\''
OK
$ diff-expr '\''((a != B) && C) || d'\'' '\''(a != B && C) || d'\''
OK
$ test-expr '\''((a != B) && C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a != B) && C) || D'\'' '\''(a != B) && C || D'\''
OK
$ diff-expr '\''((a != B) && C) || D'\'' '\''a != B && C || D'\''
OK
$ diff-expr '\''((a != B) && C) || D'\'' '\''(a != B && C) || D'\''
OK
$ test-expr '\''((A != b) && c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A != b) && c) || d'\'' '\''(A != b) && c || d'\''
OK
$ diff-expr '\''((A != b) && c) || d'\'' '\''A != b && c || d'\''
OK
$ diff-expr '\''((A != b) && c) || d'\'' '\''(A != b && c) || d'\''
OK
$ test-expr '\''((A != b) && c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A != b) && c) || D'\'' '\''(A != b) && c || D'\''
OK
$ diff-expr '\''((A != b) && c) || D'\'' '\''A != b && c || D'\''
OK
$ diff-expr '\''((A != b) && c) || D'\'' '\''(A != b && c) || D'\''
OK
$ test-expr '\''((A != b) && C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != b) && C) || d'\'' '\''(A != b) && C || d'\''
OK
$ diff-expr '\''((A != b) && C) || d'\'' '\''A != b && C || d'\''
OK
$ diff-expr '\''((A != b) && C) || d'\'' '\''(A != b && C) || d'\''
OK
$ test-expr '\''((A != b) && C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A != b) && C) || D'\'' '\''(A != b) && C || D'\''
OK
$ diff-expr '\''((A != b) && C) || D'\'' '\''A != b && C || D'\''
OK
$ diff-expr '\''((A != b) && C) || D'\'' '\''(A != b && C) || D'\''
OK
$ test-expr '\''((A != B) && c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A != B) && c) || d'\'' '\''(A != B) && c || d'\''
OK
$ diff-expr '\''((A != B) && c) || d'\'' '\''A != B && c || d'\''
OK
$ diff-expr '\''((A != B) && c) || d'\'' '\''(A != B && c) || d'\''
OK
$ test-expr '\''((A != B) && c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A != B) && c) || D'\'' '\''(A != B) && c || D'\''
OK
$ diff-expr '\''((A != B) && c) || D'\'' '\''A != B && c || D'\''
OK
$ diff-expr '\''((A != B) && c) || D'\'' '\''(A != B && c) || D'\''
OK
$ test-expr '\''((A != B) && C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != B) && C) || d'\'' '\''(A != B) && C || d'\''
OK
$ diff-expr '\''((A != B) && C) || d'\'' '\''A != B && C || d'\''
OK
$ diff-expr '\''((A != B) && C) || d'\'' '\''(A != B && C) || d'\''
OK
$ test-expr '\''((A != B) && C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false*(6)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A != B) && C) || D'\'' '\''(A != B) && C || D'\''
OK
$ diff-expr '\''((A != B) && C) || D'\'' '\''A != B && C || D'\''
OK
$ diff-expr '\''((A != B) && C) || D'\'' '\''(A != B && C) || D'\''
OK
$ test-expr '\''a >= ((b != c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((b != c) && d)'\'' '\''a >= (b != c && d)'\''
OK
$ test-expr '\''a >= ((b != c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((b != c) && D)'\'' '\''a >= (b != c && D)'\''
OK
$ test-expr '\''a >= ((b != C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((b != C) && d)'\'' '\''a >= (b != C && d)'\''
OK
$ test-expr '\''a >= ((b != C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((b != C) && D)'\'' '\''a >= (b != C && D)'\''
OK
$ test-expr '\''a >= ((B != c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((B != c) && d)'\'' '\''a >= (B != c && d)'\''
OK
$ test-expr '\''a >= ((B != c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((B != c) && D)'\'' '\''a >= (B != c && D)'\''
OK
$ test-expr '\''a >= ((B != C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((B != C) && d)'\'' '\''a >= (B != C && d)'\''
OK
$ test-expr '\''a >= ((B != C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((B != C) && D)'\'' '\''a >= (B != C && D)'\''
OK
$ test-expr '\''A >= ((b != c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((b != c) && d)'\'' '\''A >= (b != c && d)'\''
OK
$ test-expr '\''A >= ((b != c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((b != c) && D)'\'' '\''A >= (b != c && D)'\''
OK
$ test-expr '\''A >= ((b != C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((b != C) && d)'\'' '\''A >= (b != C && d)'\''
OK
$ test-expr '\''A >= ((b != C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((b != C) && D)'\'' '\''A >= (b != C && D)'\''
OK
$ test-expr '\''A >= ((B != c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((B != c) && d)'\'' '\''A >= (B != c && d)'\''
OK
$ test-expr '\''A >= ((B != c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((B != c) && D)'\'' '\''A >= (B != c && D)'\''
OK
$ test-expr '\''A >= ((B != C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((B != C) && d)'\'' '\''A >= (B != C && d)'\''
OK
$ test-expr '\''A >= ((B != C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((B != C) && D)'\'' '\''A >= (B != C && D)'\''
OK
$ test-expr '\''a >= ((b != c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((b != c) || d)'\'' '\''a >= (b != c || d)'\''
OK
$ test-expr '\''a >= ((b != c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((b != c) || D)'\'' '\''a >= (b != c || D)'\''
OK
$ test-expr '\''a >= ((b != C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((b != C) || d)'\'' '\''a >= (b != C || d)'\''
OK
$ test-expr '\''a >= ((b != C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((b != C) || D)'\'' '\''a >= (b != C || D)'\''
OK
$ test-expr '\''a >= ((B != c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((B != c) || d)'\'' '\''a >= (B != c || d)'\''
OK
$ test-expr '\''a >= ((B != c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((B != c) || D)'\'' '\''a >= (B != c || D)'\''
OK
$ test-expr '\''a >= ((B != C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((B != C) || d)'\'' '\''a >= (B != C || d)'\''
OK
$ test-expr '\''a >= ((B != C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((B != C) || D)'\'' '\''a >= (B != C || D)'\''
OK
$ test-expr '\''A >= ((b != c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((b != c) || d)'\'' '\''A >= (b != c || d)'\''
OK
$ test-expr '\''A >= ((b != c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((b != c) || D)'\'' '\''A >= (b != c || D)'\''
OK
$ test-expr '\''A >= ((b != C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((b != C) || d)'\'' '\''A >= (b != C || d)'\''
OK
$ test-expr '\''A >= ((b != C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((b != C) || D)'\'' '\''A >= (b != C || D)'\''
OK
$ test-expr '\''A >= ((B != c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((B != c) || d)'\'' '\''A >= (B != c || d)'\''
OK
$ test-expr '\''A >= ((B != c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((B != c) || D)'\'' '\''A >= (B != c || D)'\''
OK
$ test-expr '\''A >= ((B != C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((B != C) || d)'\'' '\''A >= (B != C || d)'\''
OK
$ test-expr '\''A >= ((B != C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((B != C) || D)'\'' '\''A >= (B != C || D)'\''
OK
$ test-expr '\''a >= ((b && c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ diff-expr '\''a >= ((b && c) || d)'\'' '\''a >= (b && c || d)'\''
OK
$ test-expr '\''a >= ((b && c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''a >= ((b && c) || D)'\'' '\''a >= (b && c || D)'\''
OK
$ test-expr '\''a >= ((b && C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((b && C) || d)'\'' '\''a >= (b && C || d)'\''
OK
$ test-expr '\''a >= ((b && C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((b && C) || D)'\'' '\''a >= (b && C || D)'\''
OK
$ test-expr '\''a >= ((B && c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ diff-expr '\''a >= ((B && c) || d)'\'' '\''a >= (B && c || d)'\''
OK
$ test-expr '\''a >= ((B && c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''a >= ((B && c) || D)'\'' '\''a >= (B && c || D)'\''
OK
$ test-expr '\''a >= ((B && C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= ((B && C) || d)'\'' '\''a >= (B && C || d)'\''
OK
$ test-expr '\''a >= ((B && C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= ((B && C) || D)'\'' '\''a >= (B && C || D)'\''
OK
$ test-expr '\''A >= ((b && c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ diff-expr '\''A >= ((b && c) || d)'\'' '\''A >= (b && c || d)'\''
OK
$ test-expr '\''A >= ((b && c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''A >= ((b && c) || D)'\'' '\''A >= (b && c || D)'\''
OK
$ test-expr '\''A >= ((b && C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((b && C) || d)'\'' '\''A >= (b && C || d)'\''
OK
$ test-expr '\''A >= ((b && C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((b && C) || D)'\'' '\''A >= (b && C || D)'\''
OK
$ test-expr '\''A >= ((B && c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ diff-expr '\''A >= ((B && c) || d)'\'' '\''A >= (B && c || d)'\''
OK
$ test-expr '\''A >= ((B && c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''A >= ((B && c) || D)'\'' '\''A >= (B && c || D)'\''
OK
$ test-expr '\''A >= ((B && C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= ((B && C) || d)'\'' '\''A >= (B && C || d)'\''
OK
$ test-expr '\''A >= ((B && C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= ((B && C) || D)'\'' '\''A >= (B && C || D)'\''
OK
$ test-expr '\''a != ((b && c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ diff-expr '\''a != ((b && c) || d)'\'' '\''a != (b && c || d)'\''
OK
$ test-expr '\''a != ((b && c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''a != ((b && c) || D)'\'' '\''a != (b && c || D)'\''
OK
$ test-expr '\''a != ((b && C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((b && C) || d)'\'' '\''a != (b && C || d)'\''
OK
$ test-expr '\''a != ((b && C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((b && C) || D)'\'' '\''a != (b && C || D)'\''
OK
$ test-expr '\''a != ((B && c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ diff-expr '\''a != ((B && c) || d)'\'' '\''a != (B && c || d)'\''
OK
$ test-expr '\''a != ((B && c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''a != ((B && c) || D)'\'' '\''a != (B && c || D)'\''
OK
$ test-expr '\''a != ((B && C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((B && C) || d)'\'' '\''a != (B && C || d)'\''
OK
$ test-expr '\''a != ((B && C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((B && C) || D)'\'' '\''a != (B && C || D)'\''
OK
$ test-expr '\''A != ((b && c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ diff-expr '\''A != ((b && c) || d)'\'' '\''A != (b && c || d)'\''
OK
$ test-expr '\''A != ((b && c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''A != ((b && c) || D)'\'' '\''A != (b && c || D)'\''
OK
$ test-expr '\''A != ((b && C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((b && C) || d)'\'' '\''A != (b && C || d)'\''
OK
$ test-expr '\''A != ((b && C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((b && C) || D)'\'' '\''A != (b && C || D)'\''
OK
$ test-expr '\''A != ((B && c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ diff-expr '\''A != ((B && c) || d)'\'' '\''A != (B && c || d)'\''
OK
$ test-expr '\''A != ((B && c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''A != ((B && c) || D)'\'' '\''A != (B && c || D)'\''
OK
$ test-expr '\''A != ((B && C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((B && C) || d)'\'' '\''A != (B && C || d)'\''
OK
$ test-expr '\''A != ((B && C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((B && C) || D)'\'' '\''A != (B && C || D)'\''
OK
$ test-expr '\''(a >= (b != c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (b != c)) && d'\'' '\''a >= (b != c) && d'\''
OK
$ test-expr '\''(a >= (b != c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (b != c)) && D'\'' '\''a >= (b != c) && D'\''
OK
$ test-expr '\''(a >= (b != C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (b != C)) && d'\'' '\''a >= (b != C) && d'\''
OK
$ test-expr '\''(a >= (b != C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (b != C)) && D'\'' '\''a >= (b != C) && D'\''
OK
$ test-expr '\''(a >= (B != c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (B != c)) && d'\'' '\''a >= (B != c) && d'\''
OK
$ test-expr '\''(a >= (B != c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (B != c)) && D'\'' '\''a >= (B != c) && D'\''
OK
$ test-expr '\''(a >= (B != C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (B != C)) && d'\'' '\''a >= (B != C) && d'\''
OK
$ test-expr '\''(a >= (B != C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (B != C)) && D'\'' '\''a >= (B != C) && D'\''
OK
$ test-expr '\''(A >= (b != c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (b != c)) && d'\'' '\''A >= (b != c) && d'\''
OK
$ test-expr '\''(A >= (b != c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (b != c)) && D'\'' '\''A >= (b != c) && D'\''
OK
$ test-expr '\''(A >= (b != C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (b != C)) && d'\'' '\''A >= (b != C) && d'\''
OK
$ test-expr '\''(A >= (b != C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (b != C)) && D'\'' '\''A >= (b != C) && D'\''
OK
$ test-expr '\''(A >= (B != c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (B != c)) && d'\'' '\''A >= (B != c) && d'\''
OK
$ test-expr '\''(A >= (B != c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (B != c)) && D'\'' '\''A >= (B != c) && D'\''
OK
$ test-expr '\''(A >= (B != C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (B != C)) && d'\'' '\''A >= (B != C) && d'\''
OK
$ test-expr '\''(A >= (B != C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (B != C)) && D'\'' '\''A >= (B != C) && D'\''
OK
$ test-expr '\''(a >= (b != c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (b != c)) || d'\'' '\''a >= (b != c) || d'\''
OK
$ test-expr '\''(a >= (b != c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (b != c)) || D'\'' '\''a >= (b != c) || D'\''
OK
$ test-expr '\''(a >= (b != C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (b != C)) || d'\'' '\''a >= (b != C) || d'\''
OK
$ test-expr '\''(a >= (b != C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (b != C)) || D'\'' '\''a >= (b != C) || D'\''
OK
$ test-expr '\''(a >= (B != c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (B != c)) || d'\'' '\''a >= (B != c) || d'\''
OK
$ test-expr '\''(a >= (B != c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (B != c)) || D'\'' '\''a >= (B != c) || D'\''
OK
$ test-expr '\''(a >= (B != C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (B != C)) || d'\'' '\''a >= (B != C) || d'\''
OK
$ test-expr '\''(a >= (B != C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (B != C)) || D'\'' '\''a >= (B != C) || D'\''
OK
$ test-expr '\''(A >= (b != c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (b != c)) || d'\'' '\''A >= (b != c) || d'\''
OK
$ test-expr '\''(A >= (b != c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (b != c)) || D'\'' '\''A >= (b != c) || D'\''
OK
$ test-expr '\''(A >= (b != C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (b != C)) || d'\'' '\''A >= (b != C) || d'\''
OK
$ test-expr '\''(A >= (b != C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (b != C)) || D'\'' '\''A >= (b != C) || D'\''
OK
$ test-expr '\''(A >= (B != c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (B != c)) || d'\'' '\''A >= (B != c) || d'\''
OK
$ test-expr '\''(A >= (B != c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (B != c)) || D'\'' '\''A >= (B != c) || D'\''
OK
$ test-expr '\''(A >= (B != C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (B != C)) || d'\'' '\''A >= (B != C) || d'\''
OK
$ test-expr '\''(A >= (B != C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (B != C)) || D'\'' '\''A >= (B != C) || D'\''
OK
$ test-expr '\''(a >= (b && c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a >= (b && c)) || d'\'' '\''a >= (b && c) || d'\''
OK
$ test-expr '\''(a >= (b && c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(a >= (b && c)) || D'\'' '\''a >= (b && c) || D'\''
OK
$ test-expr '\''(a >= (b && C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (b && C)) || d'\'' '\''a >= (b && C) || d'\''
OK
$ test-expr '\''(a >= (b && C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (b && C)) || D'\'' '\''a >= (b && C) || D'\''
OK
$ test-expr '\''(a >= (B && c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a >= (B && c)) || d'\'' '\''a >= (B && c) || d'\''
OK
$ test-expr '\''(a >= (B && c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(a >= (B && c)) || D'\'' '\''a >= (B && c) || D'\''
OK
$ test-expr '\''(a >= (B && C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (B && C)) || d'\'' '\''a >= (B && C) || d'\''
OK
$ test-expr '\''(a >= (B && C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (B && C)) || D'\'' '\''a >= (B && C) || D'\''
OK
$ test-expr '\''(A >= (b && c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A >= (b && c)) || d'\'' '\''A >= (b && c) || d'\''
OK
$ test-expr '\''(A >= (b && c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(A >= (b && c)) || D'\'' '\''A >= (b && c) || D'\''
OK
$ test-expr '\''(A >= (b && C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (b && C)) || d'\'' '\''A >= (b && C) || d'\''
OK
$ test-expr '\''(A >= (b && C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (b && C)) || D'\'' '\''A >= (b && C) || D'\''
OK
$ test-expr '\''(A >= (B && c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A >= (B && c)) || d'\'' '\''A >= (B && c) || d'\''
OK
$ test-expr '\''(A >= (B && c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(A >= (B && c)) || D'\'' '\''A >= (B && c) || D'\''
OK
$ test-expr '\''(A >= (B && C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (B && C)) || d'\'' '\''A >= (B && C) || d'\''
OK
$ test-expr '\''(A >= (B && C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (B && C)) || D'\'' '\''A >= (B && C) || D'\''
OK
$ test-expr '\''(a != (b && c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a != (b && c)) || d'\'' '\''a != (b && c) || d'\''
OK
$ test-expr '\''(a != (b && c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(a != (b && c)) || D'\'' '\''a != (b && c) || D'\''
OK
$ test-expr '\''(a != (b && C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (b && C)) || d'\'' '\''a != (b && C) || d'\''
OK
$ test-expr '\''(a != (b && C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (b && C)) || D'\'' '\''a != (b && C) || D'\''
OK
$ test-expr '\''(a != (B && c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a != (B && c)) || d'\'' '\''a != (B && c) || d'\''
OK
$ test-expr '\''(a != (B && c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(a != (B && c)) || D'\'' '\''a != (B && c) || D'\''
OK
$ test-expr '\''(a != (B && C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (B && C)) || d'\'' '\''a != (B && C) || d'\''
OK
$ test-expr '\''(a != (B && C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (B && C)) || D'\'' '\''a != (B && C) || D'\''
OK
$ test-expr '\''(A != (b && c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A != (b && c)) || d'\'' '\''A != (b && c) || d'\''
OK
$ test-expr '\''(A != (b && c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(A != (b && c)) || D'\'' '\''A != (b && c) || D'\''
OK
$ test-expr '\''(A != (b && C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (b && C)) || d'\'' '\''A != (b && C) || d'\''
OK
$ test-expr '\''(A != (b && C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (b && C)) || D'\'' '\''A != (b && C) || D'\''
OK
$ test-expr '\''(A != (B && c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A != (B && c)) || d'\'' '\''A != (B && c) || d'\''
OK
$ test-expr '\''(A != (B && c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''(A != (B && c)) || D'\'' '\''A != (B && c) || D'\''
OK
$ test-expr '\''(A != (B && C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (B && C)) || d'\'' '\''A != (B && C) || d'\''
OK
$ test-expr '\''(A != (B && C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (B && C)) || D'\'' '\''A != (B && C) || D'\''
OK
$ test-expr '\''(a >= b) != (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= b) != (c && d)'\'' '\''a >= b != (c && d)'\''
OK
$ test-expr '\''(a >= b) != (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) != (c && D)'\'' '\''a >= b != (c && D)'\''
OK
$ test-expr '\''(a >= b) != (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= b) != (C && d)'\'' '\''a >= b != (C && d)'\''
OK
$ test-expr '\''(a >= b) != (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) != (C && D)'\'' '\''a >= b != (C && D)'\''
OK
$ test-expr '\''(a >= B) != (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= B) != (c && d)'\'' '\''a >= B != (c && d)'\''
OK
$ test-expr '\''(a >= B) != (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) != (c && D)'\'' '\''a >= B != (c && D)'\''
OK
$ test-expr '\''(a >= B) != (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= B) != (C && d)'\'' '\''a >= B != (C && d)'\''
OK
$ test-expr '\''(a >= B) != (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) != (C && D)'\'' '\''a >= B != (C && D)'\''
OK
$ test-expr '\''(A >= b) != (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= b) != (c && d)'\'' '\''A >= b != (c && d)'\''
OK
$ test-expr '\''(A >= b) != (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) != (c && D)'\'' '\''A >= b != (c && D)'\''
OK
$ test-expr '\''(A >= b) != (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= b) != (C && d)'\'' '\''A >= b != (C && d)'\''
OK
$ test-expr '\''(A >= b) != (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) != (C && D)'\'' '\''A >= b != (C && D)'\''
OK
$ test-expr '\''(A >= B) != (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= B) != (c && d)'\'' '\''A >= B != (c && d)'\''
OK
$ test-expr '\''(A >= B) != (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) != (c && D)'\'' '\''A >= B != (c && D)'\''
OK
$ test-expr '\''(A >= B) != (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= B) != (C && d)'\'' '\''A >= B != (C && d)'\''
OK
$ test-expr '\''(A >= B) != (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) != (C && D)'\'' '\''A >= B != (C && D)'\''
OK
$ test-expr '\''(a >= b) != (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= b) != (c || d)'\'' '\''a >= b != (c || d)'\''
OK
$ test-expr '\''(a >= b) != (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) != (c || D)'\'' '\''a >= b != (c || D)'\''
OK
$ test-expr '\''(a >= b) != (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= b) != (C || d)'\'' '\''a >= b != (C || d)'\''
OK
$ test-expr '\''(a >= b) != (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) != (C || D)'\'' '\''a >= b != (C || D)'\''
OK
$ test-expr '\''(a >= B) != (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= B) != (c || d)'\'' '\''a >= B != (c || d)'\''
OK
$ test-expr '\''(a >= B) != (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) != (c || D)'\'' '\''a >= B != (c || D)'\''
OK
$ test-expr '\''(a >= B) != (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(a >= B) != (C || d)'\'' '\''a >= B != (C || d)'\''
OK
$ test-expr '\''(a >= B) != (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) != (C || D)'\'' '\''a >= B != (C || D)'\''
OK
$ test-expr '\''(A >= b) != (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= b) != (c || d)'\'' '\''A >= b != (c || d)'\''
OK
$ test-expr '\''(A >= b) != (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) != (c || D)'\'' '\''A >= b != (c || D)'\''
OK
$ test-expr '\''(A >= b) != (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= b) != (C || d)'\'' '\''A >= b != (C || d)'\''
OK
$ test-expr '\''(A >= b) != (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) != (C || D)'\'' '\''A >= b != (C || D)'\''
OK
$ test-expr '\''(A >= B) != (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= B) != (c || d)'\'' '\''A >= B != (c || d)'\''
OK
$ test-expr '\''(A >= B) != (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) != (c || D)'\'' '\''A >= B != (c || D)'\''
OK
$ test-expr '\''(A >= B) != (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''(A >= B) != (C || d)'\'' '\''A >= B != (C || d)'\''
OK
$ test-expr '\''(A >= B) != (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) != (C || D)'\'' '\''A >= B != (C || D)'\''
OK
$ test-expr '\''(a >= b) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= b) && (c || d)'\'' '\''a >= b && (c || d)'\''
OK
$ test-expr '\''(a >= b) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= b) && (c || D)'\'' '\''a >= b && (c || D)'\''
OK
$ test-expr '\''(a >= b) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= b) && (C || d)'\'' '\''a >= b && (C || d)'\''
OK
$ test-expr '\''(a >= b) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= b) && (C || D)'\'' '\''a >= b && (C || D)'\''
OK
$ test-expr '\''(a >= B) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= B) && (c || d)'\'' '\''a >= B && (c || d)'\''
OK
$ test-expr '\''(a >= B) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= B) && (c || D)'\'' '\''a >= B && (c || D)'\''
OK
$ test-expr '\''(a >= B) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= B) && (C || d)'\'' '\''a >= B && (C || d)'\''
OK
$ test-expr '\''(a >= B) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= B) && (C || D)'\'' '\''a >= B && (C || D)'\''
OK
$ test-expr '\''(A >= b) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= b) && (c || d)'\'' '\''A >= b && (c || d)'\''
OK
$ test-expr '\''(A >= b) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= b) && (c || D)'\'' '\''A >= b && (c || D)'\''
OK
$ test-expr '\''(A >= b) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= b) && (C || d)'\'' '\''A >= b && (C || d)'\''
OK
$ test-expr '\''(A >= b) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= b) && (C || D)'\'' '\''A >= b && (C || D)'\''
OK
$ test-expr '\''(A >= B) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= B) && (c || d)'\'' '\''A >= B && (c || d)'\''
OK
$ test-expr '\''(A >= B) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= B) && (c || D)'\'' '\''A >= B && (c || D)'\''
OK
$ test-expr '\''(A >= B) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= B) && (C || d)'\'' '\''A >= B && (C || d)'\''
OK
$ test-expr '\''(A >= B) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= B) && (C || D)'\'' '\''A >= B && (C || D)'\''
OK
$ test-expr '\''(a != b) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != b) && (c || d)'\'' '\''a != b && (c || d)'\''
OK
$ test-expr '\''(a != b) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != b) && (c || D)'\'' '\''a != b && (c || D)'\''
OK
$ test-expr '\''(a != b) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != b) && (C || d)'\'' '\''a != b && (C || d)'\''
OK
$ test-expr '\''(a != b) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != b) && (C || D)'\'' '\''a != b && (C || D)'\''
OK
$ test-expr '\''(a != B) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != B) && (c || d)'\'' '\''a != B && (c || d)'\''
OK
$ test-expr '\''(a != B) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != B) && (c || D)'\'' '\''a != B && (c || D)'\''
OK
$ test-expr '\''(a != B) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != B) && (C || d)'\'' '\''a != B && (C || d)'\''
OK
$ test-expr '\''(a != B) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != B) && (C || D)'\'' '\''a != B && (C || D)'\''
OK
$ test-expr '\''(A != b) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != b) && (c || d)'\'' '\''A != b && (c || d)'\''
OK
$ test-expr '\''(A != b) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != b) && (c || D)'\'' '\''A != b && (c || D)'\''
OK
$ test-expr '\''(A != b) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != b) && (C || d)'\'' '\''A != b && (C || d)'\''
OK
$ test-expr '\''(A != b) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != b) && (C || D)'\'' '\''A != b && (C || D)'\''
OK
$ test-expr '\''(A != B) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != B) && (c || d)'\'' '\''A != B && (c || d)'\''
OK
$ test-expr '\''(A != B) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != B) && (c || D)'\'' '\''A != B && (c || D)'\''
OK
$ test-expr '\''(A != B) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != B) && (C || d)'\'' '\''A != B && (C || d)'\''
OK
$ test-expr '\''(A != B) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != B) && (C || D)'\'' '\''A != B && (C || D)'\''
OK
$ test-expr '\''a >= (b != (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (b != (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (b != (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (b != (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (B != (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (B != (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (B != (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (B != (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (b != (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (b != (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (b != (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (b != (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (B != (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (B != (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (B != (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (B != (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (b != (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (b != (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (b != (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (b != (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (B != (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (B != (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (B != (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= (B != (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (b != (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (b != (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (b != (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (b != (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (B != (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (B != (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= (B != (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= (B != (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= (b && (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''a >= (b && (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''a >= (b && (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''a >= (b && (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''a >= (B && (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''a >= (B && (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''a >= (B && (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''a >= (B && (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''A >= (b && (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''A >= (b && (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''A >= (b && (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''A >= (b && (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''A >= (B && (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''A >= (B && (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''A >= (B && (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''A >= (B && (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''a != (b && (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''a != (b && (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a != (b && (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''a != (b && (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a != (B && (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''a != (B && (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a != (B && (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''a != (B && (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''A != (b && (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''A != (b && (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''A != (b && (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''A != (b && (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''A != (B && (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''A != (B && (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''A != (B && (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''A != (B && (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''((a >= b) && c) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a >= b) && c) != d'\'' '\''(a >= b && c) != d'\''
OK
$ test-expr '\''((a >= b) && c) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a >= b) && c) != D'\'' '\''(a >= b && c) != D'\''
OK
$ test-expr '\''((a >= b) && C) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a >= b) && C) != d'\'' '\''(a >= b && C) != d'\''
OK
$ test-expr '\''((a >= b) && C) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a >= b) && C) != D'\'' '\''(a >= b && C) != D'\''
OK
$ test-expr '\''((a >= B) && c) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a >= B) && c) != d'\'' '\''(a >= B && c) != d'\''
OK
$ test-expr '\''((a >= B) && c) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a >= B) && c) != D'\'' '\''(a >= B && c) != D'\''
OK
$ test-expr '\''((a >= B) && C) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a >= B) && C) != d'\'' '\''(a >= B && C) != d'\''
OK
$ test-expr '\''((a >= B) && C) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a >= B) && C) != D'\'' '\''(a >= B && C) != D'\''
OK
$ test-expr '\''((A >= b) && c) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A >= b) && c) != d'\'' '\''(A >= b && c) != d'\''
OK
$ test-expr '\''((A >= b) && c) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A >= b) && c) != D'\'' '\''(A >= b && c) != D'\''
OK
$ test-expr '\''((A >= b) && C) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A >= b) && C) != d'\'' '\''(A >= b && C) != d'\''
OK
$ test-expr '\''((A >= b) && C) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A >= b) && C) != D'\'' '\''(A >= b && C) != D'\''
OK
$ test-expr '\''((A >= B) && c) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A >= B) && c) != d'\'' '\''(A >= B && c) != d'\''
OK
$ test-expr '\''((A >= B) && c) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A >= B) && c) != D'\'' '\''(A >= B && c) != D'\''
OK
$ test-expr '\''((A >= B) && C) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A >= B) && C) != d'\'' '\''(A >= B && C) != d'\''
OK
$ test-expr '\''((A >= B) && C) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A >= B) && C) != D'\'' '\''(A >= B && C) != D'\''
OK
$ test-expr '\''((a >= b) || c) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a >= b) || c) != d'\'' '\''(a >= b || c) != d'\''
OK
$ test-expr '\''((a >= b) || c) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a >= b) || c) != D'\'' '\''(a >= b || c) != D'\''
OK
$ test-expr '\''((a >= b) || C) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a >= b) || C) != d'\'' '\''(a >= b || C) != d'\''
OK
$ test-expr '\''((a >= b) || C) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a >= b) || C) != D'\'' '\''(a >= b || C) != D'\''
OK
$ test-expr '\''((a >= B) || c) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a >= B) || c) != d'\'' '\''(a >= B || c) != d'\''
OK
$ test-expr '\''((a >= B) || c) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a >= B) || c) != D'\'' '\''(a >= B || c) != D'\''
OK
$ test-expr '\''((a >= B) || C) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a >= B) || C) != d'\'' '\''(a >= B || C) != d'\''
OK
$ test-expr '\''((a >= B) || C) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a >= B) || C) != D'\'' '\''(a >= B || C) != D'\''
OK
$ test-expr '\''((A >= b) || c) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A >= b) || c) != d'\'' '\''(A >= b || c) != d'\''
OK
$ test-expr '\''((A >= b) || c) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A >= b) || c) != D'\'' '\''(A >= b || c) != D'\''
OK
$ test-expr '\''((A >= b) || C) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A >= b) || C) != d'\'' '\''(A >= b || C) != d'\''
OK
$ test-expr '\''((A >= b) || C) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A >= b) || C) != D'\'' '\''(A >= b || C) != D'\''
OK
$ test-expr '\''((A >= B) || c) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A >= B) || c) != d'\'' '\''(A >= B || c) != d'\''
OK
$ test-expr '\''((A >= B) || c) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A >= B) || c) != D'\'' '\''(A >= B || c) != D'\''
OK
$ test-expr '\''((A >= B) || C) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A >= B) || C) != d'\'' '\''(A >= B || C) != d'\''
OK
$ test-expr '\''((A >= B) || C) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A >= B) || C) != D'\'' '\''(A >= B || C) != D'\''
OK
$ test-expr '\''((a >= b) || c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a >= b) || c) && d'\'' '\''(a >= b || c) && d'\''
OK
$ test-expr '\''((a >= b) || c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a >= b) || c) && D'\'' '\''(a >= b || c) && D'\''
OK
$ test-expr '\''((a >= b) || C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= b) || C) && d'\'' '\''(a >= b || C) && d'\''
OK
$ test-expr '\''((a >= b) || C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= b) || C) && D'\'' '\''(a >= b || C) && D'\''
OK
$ test-expr '\''((a >= B) || c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a >= B) || c) && d'\'' '\''(a >= B || c) && d'\''
OK
$ test-expr '\''((a >= B) || c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a >= B) || c) && D'\'' '\''(a >= B || c) && D'\''
OK
$ test-expr '\''((a >= B) || C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a >= B) || C) && d'\'' '\''(a >= B || C) && d'\''
OK
$ test-expr '\''((a >= B) || C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a >= B) || C) && D'\'' '\''(a >= B || C) && D'\''
OK
$ test-expr '\''((A >= b) || c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A >= b) || c) && d'\'' '\''(A >= b || c) && d'\''
OK
$ test-expr '\''((A >= b) || c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A >= b) || c) && D'\'' '\''(A >= b || c) && D'\''
OK
$ test-expr '\''((A >= b) || C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= b) || C) && d'\'' '\''(A >= b || C) && d'\''
OK
$ test-expr '\''((A >= b) || C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= b) || C) && D'\'' '\''(A >= b || C) && D'\''
OK
$ test-expr '\''((A >= B) || c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A >= B) || c) && d'\'' '\''(A >= B || c) && d'\''
OK
$ test-expr '\''((A >= B) || c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A >= B) || c) && D'\'' '\''(A >= B || c) && D'\''
OK
$ test-expr '\''((A >= B) || C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A >= B) || C) && d'\'' '\''(A >= B || C) && d'\''
OK
$ test-expr '\''((A >= B) || C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A >= B) || C) && D'\'' '\''(A >= B || C) && D'\''
OK
$ test-expr '\''((a != b) || c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a != b) || c) && d'\'' '\''(a != b || c) && d'\''
OK
$ test-expr '\''((a != b) || c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a != b) || c) && D'\'' '\''(a != b || c) && D'\''
OK
$ test-expr '\''((a != b) || C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != b) || C) && d'\'' '\''(a != b || C) && d'\''
OK
$ test-expr '\''((a != b) || C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a != b) || C) && D'\'' '\''(a != b || C) && D'\''
OK
$ test-expr '\''((a != B) || c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a != B) || c) && d'\'' '\''(a != B || c) && d'\''
OK
$ test-expr '\''((a != B) || c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a != B) || c) && D'\'' '\''(a != B || c) && D'\''
OK
$ test-expr '\''((a != B) || C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != B) || C) && d'\'' '\''(a != B || C) && d'\''
OK
$ test-expr '\''((a != B) || C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a != B) || C) && D'\'' '\''(a != B || C) && D'\''
OK
$ test-expr '\''((A != b) || c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A != b) || c) && d'\'' '\''(A != b || c) && d'\''
OK
$ test-expr '\''((A != b) || c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A != b) || c) && D'\'' '\''(A != b || c) && D'\''
OK
$ test-expr '\''((A != b) || C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != b) || C) && d'\'' '\''(A != b || C) && d'\''
OK
$ test-expr '\''((A != b) || C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A != b) || C) && D'\'' '\''(A != b || C) && D'\''
OK
$ test-expr '\''((A != B) || c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A != B) || c) && d'\'' '\''(A != B || c) && d'\''
OK
$ test-expr '\''((A != B) || c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A != B) || c) && D'\'' '\''(A != B || c) && D'\''
OK
$ test-expr '\''((A != B) || C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != B) || C) && d'\'' '\''(A != B || C) && d'\''
OK
$ test-expr '\''((A != B) || C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true*(6)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A != B) || C) && D'\'' '\''(A != B || C) && D'\''
OK
$ test-expr '\''a >= ((b && c) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((b && c) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((b && C) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((b && C) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((B && c) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((B && c) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((B && C) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((B && C) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((b && c) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((b && c) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((b && C) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((b && C) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((B && c) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((B && c) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((B && C) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((B && C) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((b || c) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((b || c) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((b || C) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((b || C) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((B || c) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((B || c) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''a >= ((B || C) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((B || C) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((b || c) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((b || c) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((b || C) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((b || C) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((B || c) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((B || c) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''A >= ((B || C) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''A >= ((B || C) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''a >= ((b || c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''a >= ((b || c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''a >= ((b || C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''a >= ((b || C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''a >= ((B || c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''a >= ((B || c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''a >= ((B || C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''a >= ((B || C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''A >= ((b || c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''A >= ((b || c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''A >= ((b || C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''A >= ((b || C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''A >= ((B || c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''A >= ((B || c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''A >= ((B || C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''A >= ((B || C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''a != ((b || c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''a != ((b || c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a != ((b || C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''a != ((b || C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a != ((B || c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''a != ((B || c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a != ((B || C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''a != ((B || C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''A != ((b || c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''A != ((b || c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''A != ((b || C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''A != ((b || C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''A != ((B || c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''A != ((B || c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''A != ((B || C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''A != ((B || C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(a >= (b && c)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a >= (b && c)) != d'\'' '\''a >= (b && c) != d'\''
OK
$ test-expr '\''(a >= (b && c)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a >= (b && c)) != D'\'' '\''a >= (b && c) != D'\''
OK
$ test-expr '\''(a >= (b && C)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= (b && C)) != d'\'' '\''a >= (b && C) != d'\''
OK
$ test-expr '\''(a >= (b && C)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= (b && C)) != D'\'' '\''a >= (b && C) != D'\''
OK
$ test-expr '\''(a >= (B && c)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a >= (B && c)) != d'\'' '\''a >= (B && c) != d'\''
OK
$ test-expr '\''(a >= (B && c)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a >= (B && c)) != D'\'' '\''a >= (B && c) != D'\''
OK
$ test-expr '\''(a >= (B && C)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= (B && C)) != d'\'' '\''a >= (B && C) != d'\''
OK
$ test-expr '\''(a >= (B && C)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= (B && C)) != D'\'' '\''a >= (B && C) != D'\''
OK
$ test-expr '\''(A >= (b && c)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A >= (b && c)) != d'\'' '\''A >= (b && c) != d'\''
OK
$ test-expr '\''(A >= (b && c)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A >= (b && c)) != D'\'' '\''A >= (b && c) != D'\''
OK
$ test-expr '\''(A >= (b && C)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= (b && C)) != d'\'' '\''A >= (b && C) != d'\''
OK
$ test-expr '\''(A >= (b && C)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= (b && C)) != D'\'' '\''A >= (b && C) != D'\''
OK
$ test-expr '\''(A >= (B && c)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A >= (B && c)) != d'\'' '\''A >= (B && c) != d'\''
OK
$ test-expr '\''(A >= (B && c)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A >= (B && c)) != D'\'' '\''A >= (B && c) != D'\''
OK
$ test-expr '\''(A >= (B && C)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= (B && C)) != d'\'' '\''A >= (B && C) != d'\''
OK
$ test-expr '\''(A >= (B && C)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= (B && C)) != D'\'' '\''A >= (B && C) != D'\''
OK
$ test-expr '\''(a >= (b || c)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a >= (b || c)) != d'\'' '\''a >= (b || c) != d'\''
OK
$ test-expr '\''(a >= (b || c)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a >= (b || c)) != D'\'' '\''a >= (b || c) != D'\''
OK
$ test-expr '\''(a >= (b || C)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= (b || C)) != d'\'' '\''a >= (b || C) != d'\''
OK
$ test-expr '\''(a >= (b || C)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= (b || C)) != D'\'' '\''a >= (b || C) != D'\''
OK
$ test-expr '\''(a >= (B || c)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a >= (B || c)) != d'\'' '\''a >= (B || c) != d'\''
OK
$ test-expr '\''(a >= (B || c)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a >= (B || c)) != D'\'' '\''a >= (B || c) != D'\''
OK
$ test-expr '\''(a >= (B || C)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= (B || C)) != d'\'' '\''a >= (B || C) != d'\''
OK
$ test-expr '\''(a >= (B || C)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= (B || C)) != D'\'' '\''a >= (B || C) != D'\''
OK
$ test-expr '\''(A >= (b || c)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A >= (b || c)) != d'\'' '\''A >= (b || c) != d'\''
OK
$ test-expr '\''(A >= (b || c)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A >= (b || c)) != D'\'' '\''A >= (b || c) != D'\''
OK
$ test-expr '\''(A >= (b || C)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= (b || C)) != d'\'' '\''A >= (b || C) != d'\''
OK
$ test-expr '\''(A >= (b || C)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= (b || C)) != D'\'' '\''A >= (b || C) != D'\''
OK
$ test-expr '\''(A >= (B || c)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A >= (B || c)) != d'\'' '\''A >= (B || c) != d'\''
OK
$ test-expr '\''(A >= (B || c)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A >= (B || c)) != D'\'' '\''A >= (B || c) != D'\''
OK
$ test-expr '\''(A >= (B || C)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= (B || C)) != d'\'' '\''A >= (B || C) != d'\''
OK
$ test-expr '\''(A >= (B || C)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= (B || C)) != D'\'' '\''A >= (B || C) != D'\''
OK
$ test-expr '\''(a >= (b || c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a >= (b || c)) && d'\'' '\''a >= (b || c) && d'\''
OK
$ test-expr '\''(a >= (b || c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(a >= (b || c)) && D'\'' '\''a >= (b || c) && D'\''
OK
$ test-expr '\''(a >= (b || C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (b || C)) && d'\'' '\''a >= (b || C) && d'\''
OK
$ test-expr '\''(a >= (b || C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (b || C)) && D'\'' '\''a >= (b || C) && D'\''
OK
$ test-expr '\''(a >= (B || c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a >= (B || c)) && d'\'' '\''a >= (B || c) && d'\''
OK
$ test-expr '\''(a >= (B || c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(a >= (B || c)) && D'\'' '\''a >= (B || c) && D'\''
OK
$ test-expr '\''(a >= (B || C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= (B || C)) && d'\'' '\''a >= (B || C) && d'\''
OK
$ test-expr '\''(a >= (B || C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= (B || C)) && D'\'' '\''a >= (B || C) && D'\''
OK
$ test-expr '\''(A >= (b || c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A >= (b || c)) && d'\'' '\''A >= (b || c) && d'\''
OK
$ test-expr '\''(A >= (b || c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(A >= (b || c)) && D'\'' '\''A >= (b || c) && D'\''
OK
$ test-expr '\''(A >= (b || C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (b || C)) && d'\'' '\''A >= (b || C) && d'\''
OK
$ test-expr '\''(A >= (b || C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (b || C)) && D'\'' '\''A >= (b || C) && D'\''
OK
$ test-expr '\''(A >= (B || c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A >= (B || c)) && d'\'' '\''A >= (B || c) && d'\''
OK
$ test-expr '\''(A >= (B || c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(A >= (B || c)) && D'\'' '\''A >= (B || c) && D'\''
OK
$ test-expr '\''(A >= (B || C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= (B || C)) && d'\'' '\''A >= (B || C) && d'\''
OK
$ test-expr '\''(A >= (B || C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= (B || C)) && D'\'' '\''A >= (B || C) && D'\''
OK
$ test-expr '\''(a != (b || c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a != (b || c)) && d'\'' '\''a != (b || c) && d'\''
OK
$ test-expr '\''(a != (b || c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(a != (b || c)) && D'\'' '\''a != (b || c) && D'\''
OK
$ test-expr '\''(a != (b || C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (b || C)) && d'\'' '\''a != (b || C) && d'\''
OK
$ test-expr '\''(a != (b || C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (b || C)) && D'\'' '\''a != (b || C) && D'\''
OK
$ test-expr '\''(a != (B || c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(a != (B || c)) && d'\'' '\''a != (B || c) && d'\''
OK
$ test-expr '\''(a != (B || c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(a != (B || c)) && D'\'' '\''a != (B || c) && D'\''
OK
$ test-expr '\''(a != (B || C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (B || C)) && d'\'' '\''a != (B || C) && d'\''
OK
$ test-expr '\''(a != (B || C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (B || C)) && D'\'' '\''a != (B || C) && D'\''
OK
$ test-expr '\''(A != (b || c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A != (b || c)) && d'\'' '\''A != (b || c) && d'\''
OK
$ test-expr '\''(A != (b || c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(A != (b || c)) && D'\'' '\''A != (b || c) && D'\''
OK
$ test-expr '\''(A != (b || C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (b || C)) && d'\'' '\''A != (b || C) && d'\''
OK
$ test-expr '\''(A != (b || C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (b || C)) && D'\'' '\''A != (b || C) && D'\''
OK
$ test-expr '\''(A != (B || c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''(A != (B || c)) && d'\'' '\''A != (B || c) && d'\''
OK
$ test-expr '\''(A != (B || c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''(A != (B || c)) && D'\'' '\''A != (B || c) && D'\''
OK
$ test-expr '\''(A != (B || C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (B || C)) && d'\'' '\''A != (B || C) && d'\''
OK
$ test-expr '\''(A != (B || C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (B || C)) && D'\'' '\''A != (B || C) && D'\''
OK
$ test-expr '\''(a >= b) && (c != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) && (c != d)'\'' '\''a >= b && (c != d)'\''
OK
$ diff-expr '\''(a >= b) && (c != d)'\'' '\''a >= b && c != d'\''
OK
$ diff-expr '\''(a >= b) && (c != d)'\'' '\''(a >= b) && c != d'\''
OK
$ test-expr '\''(a >= b) && (c != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) && (c != D)'\'' '\''a >= b && (c != D)'\''
OK
$ diff-expr '\''(a >= b) && (c != D)'\'' '\''a >= b && c != D'\''
OK
$ diff-expr '\''(a >= b) && (c != D)'\'' '\''(a >= b) && c != D'\''
OK
$ test-expr '\''(a >= b) && (C != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) && (C != d)'\'' '\''a >= b && (C != d)'\''
OK
$ diff-expr '\''(a >= b) && (C != d)'\'' '\''a >= b && C != d'\''
OK
$ diff-expr '\''(a >= b) && (C != d)'\'' '\''(a >= b) && C != d'\''
OK
$ test-expr '\''(a >= b) && (C != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) && (C != D)'\'' '\''a >= b && (C != D)'\''
OK
$ diff-expr '\''(a >= b) && (C != D)'\'' '\''a >= b && C != D'\''
OK
$ diff-expr '\''(a >= b) && (C != D)'\'' '\''(a >= b) && C != D'\''
OK
$ test-expr '\''(a >= B) && (c != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) && (c != d)'\'' '\''a >= B && (c != d)'\''
OK
$ diff-expr '\''(a >= B) && (c != d)'\'' '\''a >= B && c != d'\''
OK
$ diff-expr '\''(a >= B) && (c != d)'\'' '\''(a >= B) && c != d'\''
OK
$ test-expr '\''(a >= B) && (c != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) && (c != D)'\'' '\''a >= B && (c != D)'\''
OK
$ diff-expr '\''(a >= B) && (c != D)'\'' '\''a >= B && c != D'\''
OK
$ diff-expr '\''(a >= B) && (c != D)'\'' '\''(a >= B) && c != D'\''
OK
$ test-expr '\''(a >= B) && (C != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) && (C != d)'\'' '\''a >= B && (C != d)'\''
OK
$ diff-expr '\''(a >= B) && (C != d)'\'' '\''a >= B && C != d'\''
OK
$ diff-expr '\''(a >= B) && (C != d)'\'' '\''(a >= B) && C != d'\''
OK
$ test-expr '\''(a >= B) && (C != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) && (C != D)'\'' '\''a >= B && (C != D)'\''
OK
$ diff-expr '\''(a >= B) && (C != D)'\'' '\''a >= B && C != D'\''
OK
$ diff-expr '\''(a >= B) && (C != D)'\'' '\''(a >= B) && C != D'\''
OK
$ test-expr '\''(A >= b) && (c != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) && (c != d)'\'' '\''A >= b && (c != d)'\''
OK
$ diff-expr '\''(A >= b) && (c != d)'\'' '\''A >= b && c != d'\''
OK
$ diff-expr '\''(A >= b) && (c != d)'\'' '\''(A >= b) && c != d'\''
OK
$ test-expr '\''(A >= b) && (c != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) && (c != D)'\'' '\''A >= b && (c != D)'\''
OK
$ diff-expr '\''(A >= b) && (c != D)'\'' '\''A >= b && c != D'\''
OK
$ diff-expr '\''(A >= b) && (c != D)'\'' '\''(A >= b) && c != D'\''
OK
$ test-expr '\''(A >= b) && (C != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) && (C != d)'\'' '\''A >= b && (C != d)'\''
OK
$ diff-expr '\''(A >= b) && (C != d)'\'' '\''A >= b && C != d'\''
OK
$ diff-expr '\''(A >= b) && (C != d)'\'' '\''(A >= b) && C != d'\''
OK
$ test-expr '\''(A >= b) && (C != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) && (C != D)'\'' '\''A >= b && (C != D)'\''
OK
$ diff-expr '\''(A >= b) && (C != D)'\'' '\''A >= b && C != D'\''
OK
$ diff-expr '\''(A >= b) && (C != D)'\'' '\''(A >= b) && C != D'\''
OK
$ test-expr '\''(A >= B) && (c != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) && (c != d)'\'' '\''A >= B && (c != d)'\''
OK
$ diff-expr '\''(A >= B) && (c != d)'\'' '\''A >= B && c != d'\''
OK
$ diff-expr '\''(A >= B) && (c != d)'\'' '\''(A >= B) && c != d'\''
OK
$ test-expr '\''(A >= B) && (c != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) && (c != D)'\'' '\''A >= B && (c != D)'\''
OK
$ diff-expr '\''(A >= B) && (c != D)'\'' '\''A >= B && c != D'\''
OK
$ diff-expr '\''(A >= B) && (c != D)'\'' '\''(A >= B) && c != D'\''
OK
$ test-expr '\''(A >= B) && (C != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) && (C != d)'\'' '\''A >= B && (C != d)'\''
OK
$ diff-expr '\''(A >= B) && (C != d)'\'' '\''A >= B && C != d'\''
OK
$ diff-expr '\''(A >= B) && (C != d)'\'' '\''(A >= B) && C != d'\''
OK
$ test-expr '\''(A >= B) && (C != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) && (C != D)'\'' '\''A >= B && (C != D)'\''
OK
$ diff-expr '\''(A >= B) && (C != D)'\'' '\''A >= B && C != D'\''
OK
$ diff-expr '\''(A >= B) && (C != D)'\'' '\''(A >= B) && C != D'\''
OK
$ test-expr '\''(a >= b) || (c != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) || (c != d)'\'' '\''a >= b || (c != d)'\''
OK
$ diff-expr '\''(a >= b) || (c != d)'\'' '\''a >= b || c != d'\''
OK
$ diff-expr '\''(a >= b) || (c != d)'\'' '\''(a >= b) || c != d'\''
OK
$ test-expr '\''(a >= b) || (c != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) || (c != D)'\'' '\''a >= b || (c != D)'\''
OK
$ diff-expr '\''(a >= b) || (c != D)'\'' '\''a >= b || c != D'\''
OK
$ diff-expr '\''(a >= b) || (c != D)'\'' '\''(a >= b) || c != D'\''
OK
$ test-expr '\''(a >= b) || (C != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) || (C != d)'\'' '\''a >= b || (C != d)'\''
OK
$ diff-expr '\''(a >= b) || (C != d)'\'' '\''a >= b || C != d'\''
OK
$ diff-expr '\''(a >= b) || (C != d)'\'' '\''(a >= b) || C != d'\''
OK
$ test-expr '\''(a >= b) || (C != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= b) || (C != D)'\'' '\''a >= b || (C != D)'\''
OK
$ diff-expr '\''(a >= b) || (C != D)'\'' '\''a >= b || C != D'\''
OK
$ diff-expr '\''(a >= b) || (C != D)'\'' '\''(a >= b) || C != D'\''
OK
$ test-expr '\''(a >= B) || (c != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) || (c != d)'\'' '\''a >= B || (c != d)'\''
OK
$ diff-expr '\''(a >= B) || (c != d)'\'' '\''a >= B || c != d'\''
OK
$ diff-expr '\''(a >= B) || (c != d)'\'' '\''(a >= B) || c != d'\''
OK
$ test-expr '\''(a >= B) || (c != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) || (c != D)'\'' '\''a >= B || (c != D)'\''
OK
$ diff-expr '\''(a >= B) || (c != D)'\'' '\''a >= B || c != D'\''
OK
$ diff-expr '\''(a >= B) || (c != D)'\'' '\''(a >= B) || c != D'\''
OK
$ test-expr '\''(a >= B) || (C != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) || (C != d)'\'' '\''a >= B || (C != d)'\''
OK
$ diff-expr '\''(a >= B) || (C != d)'\'' '\''a >= B || C != d'\''
OK
$ diff-expr '\''(a >= B) || (C != d)'\'' '\''(a >= B) || C != d'\''
OK
$ test-expr '\''(a >= B) || (C != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a >= B) || (C != D)'\'' '\''a >= B || (C != D)'\''
OK
$ diff-expr '\''(a >= B) || (C != D)'\'' '\''a >= B || C != D'\''
OK
$ diff-expr '\''(a >= B) || (C != D)'\'' '\''(a >= B) || C != D'\''
OK
$ test-expr '\''(A >= b) || (c != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) || (c != d)'\'' '\''A >= b || (c != d)'\''
OK
$ diff-expr '\''(A >= b) || (c != d)'\'' '\''A >= b || c != d'\''
OK
$ diff-expr '\''(A >= b) || (c != d)'\'' '\''(A >= b) || c != d'\''
OK
$ test-expr '\''(A >= b) || (c != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) || (c != D)'\'' '\''A >= b || (c != D)'\''
OK
$ diff-expr '\''(A >= b) || (c != D)'\'' '\''A >= b || c != D'\''
OK
$ diff-expr '\''(A >= b) || (c != D)'\'' '\''(A >= b) || c != D'\''
OK
$ test-expr '\''(A >= b) || (C != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) || (C != d)'\'' '\''A >= b || (C != d)'\''
OK
$ diff-expr '\''(A >= b) || (C != d)'\'' '\''A >= b || C != d'\''
OK
$ diff-expr '\''(A >= b) || (C != d)'\'' '\''(A >= b) || C != d'\''
OK
$ test-expr '\''(A >= b) || (C != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= b) || (C != D)'\'' '\''A >= b || (C != D)'\''
OK
$ diff-expr '\''(A >= b) || (C != D)'\'' '\''A >= b || C != D'\''
OK
$ diff-expr '\''(A >= b) || (C != D)'\'' '\''(A >= b) || C != D'\''
OK
$ test-expr '\''(A >= B) || (c != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) || (c != d)'\'' '\''A >= B || (c != d)'\''
OK
$ diff-expr '\''(A >= B) || (c != d)'\'' '\''A >= B || c != d'\''
OK
$ diff-expr '\''(A >= B) || (c != d)'\'' '\''(A >= B) || c != d'\''
OK
$ test-expr '\''(A >= B) || (c != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) || (c != D)'\'' '\''A >= B || (c != D)'\''
OK
$ diff-expr '\''(A >= B) || (c != D)'\'' '\''A >= B || c != D'\''
OK
$ diff-expr '\''(A >= B) || (c != D)'\'' '\''(A >= B) || c != D'\''
OK
$ test-expr '\''(A >= B) || (C != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) || (C != d)'\'' '\''A >= B || (C != d)'\''
OK
$ diff-expr '\''(A >= B) || (C != d)'\'' '\''A >= B || C != d'\''
OK
$ diff-expr '\''(A >= B) || (C != d)'\'' '\''(A >= B) || C != d'\''
OK
$ test-expr '\''(A >= B) || (C != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A >= B) || (C != D)'\'' '\''A >= B || (C != D)'\''
OK
$ diff-expr '\''(A >= B) || (C != D)'\'' '\''A >= B || C != D'\''
OK
$ diff-expr '\''(A >= B) || (C != D)'\'' '\''(A >= B) || C != D'\''
OK
$ test-expr '\''(a >= b) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= b) || (c && d)'\'' '\''a >= b || (c && d)'\''
OK
$ diff-expr '\''(a >= b) || (c && d)'\'' '\''a >= b || c && d'\''
OK
$ diff-expr '\''(a >= b) || (c && d)'\'' '\''(a >= b) || c && d'\''
OK
$ test-expr '\''(a >= b) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= b) || (c && D)'\'' '\''a >= b || (c && D)'\''
OK
$ diff-expr '\''(a >= b) || (c && D)'\'' '\''a >= b || c && D'\''
OK
$ diff-expr '\''(a >= b) || (c && D)'\'' '\''(a >= b) || c && D'\''
OK
$ test-expr '\''(a >= b) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= b) || (C && d)'\'' '\''a >= b || (C && d)'\''
OK
$ diff-expr '\''(a >= b) || (C && d)'\'' '\''a >= b || C && d'\''
OK
$ diff-expr '\''(a >= b) || (C && d)'\'' '\''(a >= b) || C && d'\''
OK
$ test-expr '\''(a >= b) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= b) || (C && D)'\'' '\''a >= b || (C && D)'\''
OK
$ diff-expr '\''(a >= b) || (C && D)'\'' '\''a >= b || C && D'\''
OK
$ diff-expr '\''(a >= b) || (C && D)'\'' '\''(a >= b) || C && D'\''
OK
$ test-expr '\''(a >= B) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= B) || (c && d)'\'' '\''a >= B || (c && d)'\''
OK
$ diff-expr '\''(a >= B) || (c && d)'\'' '\''a >= B || c && d'\''
OK
$ diff-expr '\''(a >= B) || (c && d)'\'' '\''(a >= B) || c && d'\''
OK
$ test-expr '\''(a >= B) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= B) || (c && D)'\'' '\''a >= B || (c && D)'\''
OK
$ diff-expr '\''(a >= B) || (c && D)'\'' '\''a >= B || c && D'\''
OK
$ diff-expr '\''(a >= B) || (c && D)'\'' '\''(a >= B) || c && D'\''
OK
$ test-expr '\''(a >= B) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a >= B) || (C && d)'\'' '\''a >= B || (C && d)'\''
OK
$ diff-expr '\''(a >= B) || (C && d)'\'' '\''a >= B || C && d'\''
OK
$ diff-expr '\''(a >= B) || (C && d)'\'' '\''(a >= B) || C && d'\''
OK
$ test-expr '\''(a >= B) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a >= B) || (C && D)'\'' '\''a >= B || (C && D)'\''
OK
$ diff-expr '\''(a >= B) || (C && D)'\'' '\''a >= B || C && D'\''
OK
$ diff-expr '\''(a >= B) || (C && D)'\'' '\''(a >= B) || C && D'\''
OK
$ test-expr '\''(A >= b) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= b) || (c && d)'\'' '\''A >= b || (c && d)'\''
OK
$ diff-expr '\''(A >= b) || (c && d)'\'' '\''A >= b || c && d'\''
OK
$ diff-expr '\''(A >= b) || (c && d)'\'' '\''(A >= b) || c && d'\''
OK
$ test-expr '\''(A >= b) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= b) || (c && D)'\'' '\''A >= b || (c && D)'\''
OK
$ diff-expr '\''(A >= b) || (c && D)'\'' '\''A >= b || c && D'\''
OK
$ diff-expr '\''(A >= b) || (c && D)'\'' '\''(A >= b) || c && D'\''
OK
$ test-expr '\''(A >= b) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= b) || (C && d)'\'' '\''A >= b || (C && d)'\''
OK
$ diff-expr '\''(A >= b) || (C && d)'\'' '\''A >= b || C && d'\''
OK
$ diff-expr '\''(A >= b) || (C && d)'\'' '\''(A >= b) || C && d'\''
OK
$ test-expr '\''(A >= b) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= b) || (C && D)'\'' '\''A >= b || (C && D)'\''
OK
$ diff-expr '\''(A >= b) || (C && D)'\'' '\''A >= b || C && D'\''
OK
$ diff-expr '\''(A >= b) || (C && D)'\'' '\''(A >= b) || C && D'\''
OK
$ test-expr '\''(A >= B) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= B) || (c && d)'\'' '\''A >= B || (c && d)'\''
OK
$ diff-expr '\''(A >= B) || (c && d)'\'' '\''A >= B || c && d'\''
OK
$ diff-expr '\''(A >= B) || (c && d)'\'' '\''(A >= B) || c && d'\''
OK
$ test-expr '\''(A >= B) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= B) || (c && D)'\'' '\''A >= B || (c && D)'\''
OK
$ diff-expr '\''(A >= B) || (c && D)'\'' '\''A >= B || c && D'\''
OK
$ diff-expr '\''(A >= B) || (c && D)'\'' '\''(A >= B) || c && D'\''
OK
$ test-expr '\''(A >= B) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A >= B) || (C && d)'\'' '\''A >= B || (C && d)'\''
OK
$ diff-expr '\''(A >= B) || (C && d)'\'' '\''A >= B || C && d'\''
OK
$ diff-expr '\''(A >= B) || (C && d)'\'' '\''(A >= B) || C && d'\''
OK
$ test-expr '\''(A >= B) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A >= B) || (C && D)'\'' '\''A >= B || (C && D)'\''
OK
$ diff-expr '\''(A >= B) || (C && D)'\'' '\''A >= B || C && D'\''
OK
$ diff-expr '\''(A >= B) || (C && D)'\'' '\''(A >= B) || C && D'\''
OK
$ test-expr '\''(a != b) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != b) || (c && d)'\'' '\''a != b || (c && d)'\''
OK
$ diff-expr '\''(a != b) || (c && d)'\'' '\''a != b || c && d'\''
OK
$ diff-expr '\''(a != b) || (c && d)'\'' '\''(a != b) || c && d'\''
OK
$ test-expr '\''(a != b) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != b) || (c && D)'\'' '\''a != b || (c && D)'\''
OK
$ diff-expr '\''(a != b) || (c && D)'\'' '\''a != b || c && D'\''
OK
$ diff-expr '\''(a != b) || (c && D)'\'' '\''(a != b) || c && D'\''
OK
$ test-expr '\''(a != b) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != b) || (C && d)'\'' '\''a != b || (C && d)'\''
OK
$ diff-expr '\''(a != b) || (C && d)'\'' '\''a != b || C && d'\''
OK
$ diff-expr '\''(a != b) || (C && d)'\'' '\''(a != b) || C && d'\''
OK
$ test-expr '\''(a != b) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != b) || (C && D)'\'' '\''a != b || (C && D)'\''
OK
$ diff-expr '\''(a != b) || (C && D)'\'' '\''a != b || C && D'\''
OK
$ diff-expr '\''(a != b) || (C && D)'\'' '\''(a != b) || C && D'\''
OK
$ test-expr '\''(a != B) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != B) || (c && d)'\'' '\''a != B || (c && d)'\''
OK
$ diff-expr '\''(a != B) || (c && d)'\'' '\''a != B || c && d'\''
OK
$ diff-expr '\''(a != B) || (c && d)'\'' '\''(a != B) || c && d'\''
OK
$ test-expr '\''(a != B) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != B) || (c && D)'\'' '\''a != B || (c && D)'\''
OK
$ diff-expr '\''(a != B) || (c && D)'\'' '\''a != B || c && D'\''
OK
$ diff-expr '\''(a != B) || (c && D)'\'' '\''(a != B) || c && D'\''
OK
$ test-expr '\''(a != B) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != B) || (C && d)'\'' '\''a != B || (C && d)'\''
OK
$ diff-expr '\''(a != B) || (C && d)'\'' '\''a != B || C && d'\''
OK
$ diff-expr '\''(a != B) || (C && d)'\'' '\''(a != B) || C && d'\''
OK
$ test-expr '\''(a != B) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != B) || (C && D)'\'' '\''a != B || (C && D)'\''
OK
$ diff-expr '\''(a != B) || (C && D)'\'' '\''a != B || C && D'\''
OK
$ diff-expr '\''(a != B) || (C && D)'\'' '\''(a != B) || C && D'\''
OK
$ test-expr '\''(A != b) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != b) || (c && d)'\'' '\''A != b || (c && d)'\''
OK
$ diff-expr '\''(A != b) || (c && d)'\'' '\''A != b || c && d'\''
OK
$ diff-expr '\''(A != b) || (c && d)'\'' '\''(A != b) || c && d'\''
OK
$ test-expr '\''(A != b) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != b) || (c && D)'\'' '\''A != b || (c && D)'\''
OK
$ diff-expr '\''(A != b) || (c && D)'\'' '\''A != b || c && D'\''
OK
$ diff-expr '\''(A != b) || (c && D)'\'' '\''(A != b) || c && D'\''
OK
$ test-expr '\''(A != b) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != b) || (C && d)'\'' '\''A != b || (C && d)'\''
OK
$ diff-expr '\''(A != b) || (C && d)'\'' '\''A != b || C && d'\''
OK
$ diff-expr '\''(A != b) || (C && d)'\'' '\''(A != b) || C && d'\''
OK
$ test-expr '\''(A != b) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != b) || (C && D)'\'' '\''A != b || (C && D)'\''
OK
$ diff-expr '\''(A != b) || (C && D)'\'' '\''A != b || C && D'\''
OK
$ diff-expr '\''(A != b) || (C && D)'\'' '\''(A != b) || C && D'\''
OK
$ test-expr '\''(A != B) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != B) || (c && d)'\'' '\''A != B || (c && d)'\''
OK
$ diff-expr '\''(A != B) || (c && d)'\'' '\''A != B || c && d'\''
OK
$ diff-expr '\''(A != B) || (c && d)'\'' '\''(A != B) || c && d'\''
OK
$ test-expr '\''(A != B) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != B) || (c && D)'\'' '\''A != B || (c && D)'\''
OK
$ diff-expr '\''(A != B) || (c && D)'\'' '\''A != B || c && D'\''
OK
$ diff-expr '\''(A != B) || (c && D)'\'' '\''(A != B) || c && D'\''
OK
$ test-expr '\''(A != B) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != B) || (C && d)'\'' '\''A != B || (C && d)'\''
OK
$ diff-expr '\''(A != B) || (C && d)'\'' '\''A != B || C && d'\''
OK
$ diff-expr '\''(A != B) || (C && d)'\'' '\''(A != B) || C && d'\''
OK
$ test-expr '\''(A != B) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != B) || (C && D)'\'' '\''A != B || (C && D)'\''
OK
$ diff-expr '\''(A != B) || (C && D)'\'' '\''A != B || C && D'\''
OK
$ diff-expr '\''(A != B) || (C && D)'\'' '\''(A != B) || C && D'\''
OK
$ test-expr '\''a >= (b && (c != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b && (c != d))'\'' '\''a >= (b && c != d)'\''
OK
$ test-expr '\''a >= (b && (c != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b && (c != D))'\'' '\''a >= (b && c != D)'\''
OK
$ test-expr '\''a >= (b && (C != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b && (C != d))'\'' '\''a >= (b && C != d)'\''
OK
$ test-expr '\''a >= (b && (C != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b && (C != D))'\'' '\''a >= (b && C != D)'\''
OK
$ test-expr '\''a >= (B && (c != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B && (c != d))'\'' '\''a >= (B && c != d)'\''
OK
$ test-expr '\''a >= (B && (c != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B && (c != D))'\'' '\''a >= (B && c != D)'\''
OK
$ test-expr '\''a >= (B && (C != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B && (C != d))'\'' '\''a >= (B && C != d)'\''
OK
$ test-expr '\''a >= (B && (C != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B && (C != D))'\'' '\''a >= (B && C != D)'\''
OK
$ test-expr '\''A >= (b && (c != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b && (c != d))'\'' '\''A >= (b && c != d)'\''
OK
$ test-expr '\''A >= (b && (c != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b && (c != D))'\'' '\''A >= (b && c != D)'\''
OK
$ test-expr '\''A >= (b && (C != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b && (C != d))'\'' '\''A >= (b && C != d)'\''
OK
$ test-expr '\''A >= (b && (C != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b && (C != D))'\'' '\''A >= (b && C != D)'\''
OK
$ test-expr '\''A >= (B && (c != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B && (c != d))'\'' '\''A >= (B && c != d)'\''
OK
$ test-expr '\''A >= (B && (c != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B && (c != D))'\'' '\''A >= (B && c != D)'\''
OK
$ test-expr '\''A >= (B && (C != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B && (C != d))'\'' '\''A >= (B && C != d)'\''
OK
$ test-expr '\''A >= (B && (C != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B && (C != D))'\'' '\''A >= (B && C != D)'\''
OK
$ test-expr '\''a >= (b || (c != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b || (c != d))'\'' '\''a >= (b || c != d)'\''
OK
$ test-expr '\''a >= (b || (c != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b || (c != D))'\'' '\''a >= (b || c != D)'\''
OK
$ test-expr '\''a >= (b || (C != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b || (C != d))'\'' '\''a >= (b || C != d)'\''
OK
$ test-expr '\''a >= (b || (C != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (b || (C != D))'\'' '\''a >= (b || C != D)'\''
OK
$ test-expr '\''a >= (B || (c != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B || (c != d))'\'' '\''a >= (B || c != d)'\''
OK
$ test-expr '\''a >= (B || (c != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B || (c != D))'\'' '\''a >= (B || c != D)'\''
OK
$ test-expr '\''a >= (B || (C != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B || (C != d))'\'' '\''a >= (B || C != d)'\''
OK
$ test-expr '\''a >= (B || (C != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a >= (B || (C != D))'\'' '\''a >= (B || C != D)'\''
OK
$ test-expr '\''A >= (b || (c != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b || (c != d))'\'' '\''A >= (b || c != d)'\''
OK
$ test-expr '\''A >= (b || (c != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b || (c != D))'\'' '\''A >= (b || c != D)'\''
OK
$ test-expr '\''A >= (b || (C != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b || (C != d))'\'' '\''A >= (b || C != d)'\''
OK
$ test-expr '\''A >= (b || (C != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (b || (C != D))'\'' '\''A >= (b || C != D)'\''
OK
$ test-expr '\''A >= (B || (c != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B || (c != d))'\'' '\''A >= (B || c != d)'\''
OK
$ test-expr '\''A >= (B || (c != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B || (c != D))'\'' '\''A >= (B || c != D)'\''
OK
$ test-expr '\''A >= (B || (C != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B || (C != d))'\'' '\''A >= (B || C != d)'\''
OK
$ test-expr '\''A >= (B || (C != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A >= (B || (C != D))'\'' '\''A >= (B || C != D)'\''
OK
$ test-expr '\''a >= (b || (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= (b || (c && d))'\'' '\''a >= (b || c && d)'\''
OK
$ test-expr '\''a >= (b || (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= (b || (c && D))'\'' '\''a >= (b || c && D)'\''
OK
$ test-expr '\''a >= (b || (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= (b || (C && d))'\'' '\''a >= (b || C && d)'\''
OK
$ test-expr '\''a >= (b || (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= (b || (C && D))'\'' '\''a >= (b || C && D)'\''
OK
$ test-expr '\''a >= (B || (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= (B || (c && d))'\'' '\''a >= (B || c && d)'\''
OK
$ test-expr '\''a >= (B || (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= (B || (c && D))'\'' '\''a >= (B || c && D)'\''
OK
$ test-expr '\''a >= (B || (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a >= (B || (C && d))'\'' '\''a >= (B || C && d)'\''
OK
$ test-expr '\''a >= (B || (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a >= (B || (C && D))'\'' '\''a >= (B || C && D)'\''
OK
$ test-expr '\''A >= (b || (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= (b || (c && d))'\'' '\''A >= (b || c && d)'\''
OK
$ test-expr '\''A >= (b || (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= (b || (c && D))'\'' '\''A >= (b || c && D)'\''
OK
$ test-expr '\''A >= (b || (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= (b || (C && d))'\'' '\''A >= (b || C && d)'\''
OK
$ test-expr '\''A >= (b || (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= (b || (C && D))'\'' '\''A >= (b || C && D)'\''
OK
$ test-expr '\''A >= (B || (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= (B || (c && d))'\'' '\''A >= (B || c && d)'\''
OK
$ test-expr '\''A >= (B || (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= (B || (c && D))'\'' '\''A >= (B || c && D)'\''
OK
$ test-expr '\''A >= (B || (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A >= (B || (C && d))'\'' '\''A >= (B || C && d)'\''
OK
$ test-expr '\''A >= (B || (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A >= (B || (C && D))'\'' '\''A >= (B || C && D)'\''
OK
$ test-expr '\''a != (b || (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != (b || (c && d))'\'' '\''a != (b || c && d)'\''
OK
$ test-expr '\''a != (b || (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != (b || (c && D))'\'' '\''a != (b || c && D)'\''
OK
$ test-expr '\''a != (b || (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != (b || (C && d))'\'' '\''a != (b || C && d)'\''
OK
$ test-expr '\''a != (b || (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != (b || (C && D))'\'' '\''a != (b || C && D)'\''
OK
$ test-expr '\''a != (B || (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != (B || (c && d))'\'' '\''a != (B || c && d)'\''
OK
$ test-expr '\''a != (B || (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != (B || (c && D))'\'' '\''a != (B || c && D)'\''
OK
$ test-expr '\''a != (B || (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != (B || (C && d))'\'' '\''a != (B || C && d)'\''
OK
$ test-expr '\''a != (B || (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != (B || (C && D))'\'' '\''a != (B || C && D)'\''
OK
$ test-expr '\''A != (b || (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != (b || (c && d))'\'' '\''A != (b || c && d)'\''
OK
$ test-expr '\''A != (b || (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != (b || (c && D))'\'' '\''A != (b || c && D)'\''
OK
$ test-expr '\''A != (b || (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != (b || (C && d))'\'' '\''A != (b || C && d)'\''
OK
$ test-expr '\''A != (b || (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != (b || (C && D))'\'' '\''A != (b || C && D)'\''
OK
$ test-expr '\''A != (B || (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != (B || (c && d))'\'' '\''A != (B || c && d)'\''
OK
$ test-expr '\''A != (B || (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != (B || (c && D))'\'' '\''A != (B || c && D)'\''
OK
$ test-expr '\''A != (B || (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != (B || (C && d))'\'' '\''A != (B || C && d)'\''
OK
$ test-expr '\''A != (B || (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != (B || (C && D))'\'' '\''A != (B || C && D)'\''
OK
$ test-expr '\''((a != b) >= c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != b) >= c) && d'\'' '\''(a != b) >= c && d'\''
OK
$ test-expr '\''((a != b) >= c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a != b) >= c) && D'\'' '\''(a != b) >= c && D'\''
OK
$ test-expr '\''((a != b) >= C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != b) >= C) && d'\'' '\''(a != b) >= C && d'\''
OK
$ test-expr '\''((a != b) >= C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a != b) >= C) && D'\'' '\''(a != b) >= C && D'\''
OK
$ test-expr '\''((a != B) >= c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != B) >= c) && d'\'' '\''(a != B) >= c && d'\''
OK
$ test-expr '\''((a != B) >= c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a != B) >= c) && D'\'' '\''(a != B) >= c && D'\''
OK
$ test-expr '\''((a != B) >= C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != B) >= C) && d'\'' '\''(a != B) >= C && d'\''
OK
$ test-expr '\''((a != B) >= C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a != B) >= C) && D'\'' '\''(a != B) >= C && D'\''
OK
$ test-expr '\''((A != b) >= c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != b) >= c) && d'\'' '\''(A != b) >= c && d'\''
OK
$ test-expr '\''((A != b) >= c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A != b) >= c) && D'\'' '\''(A != b) >= c && D'\''
OK
$ test-expr '\''((A != b) >= C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != b) >= C) && d'\'' '\''(A != b) >= C && d'\''
OK
$ test-expr '\''((A != b) >= C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A != b) >= C) && D'\'' '\''(A != b) >= C && D'\''
OK
$ test-expr '\''((A != B) >= c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != B) >= c) && d'\'' '\''(A != B) >= c && d'\''
OK
$ test-expr '\''((A != B) >= c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A != B) >= c) && D'\'' '\''(A != B) >= c && D'\''
OK
$ test-expr '\''((A != B) >= C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != B) >= C) && d'\'' '\''(A != B) >= C && d'\''
OK
$ test-expr '\''((A != B) >= C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A != B) >= C) && D'\'' '\''(A != B) >= C && D'\''
OK
$ test-expr '\''((a != b) >= c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != b) >= c) || d'\'' '\''(a != b) >= c || d'\''
OK
$ test-expr '\''((a != b) >= c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a != b) >= c) || D'\'' '\''(a != b) >= c || D'\''
OK
$ test-expr '\''((a != b) >= C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != b) >= C) || d'\'' '\''(a != b) >= C || d'\''
OK
$ test-expr '\''((a != b) >= C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a != b) >= C) || D'\'' '\''(a != b) >= C || D'\''
OK
$ test-expr '\''((a != B) >= c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != B) >= c) || d'\'' '\''(a != B) >= c || d'\''
OK
$ test-expr '\''((a != B) >= c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a != B) >= c) || D'\'' '\''(a != B) >= c || D'\''
OK
$ test-expr '\''((a != B) >= C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a != B) >= C) || d'\'' '\''(a != B) >= C || d'\''
OK
$ test-expr '\''((a != B) >= C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a != B) >= C) || D'\'' '\''(a != B) >= C || D'\''
OK
$ test-expr '\''((A != b) >= c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != b) >= c) || d'\'' '\''(A != b) >= c || d'\''
OK
$ test-expr '\''((A != b) >= c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A != b) >= c) || D'\'' '\''(A != b) >= c || D'\''
OK
$ test-expr '\''((A != b) >= C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != b) >= C) || d'\'' '\''(A != b) >= C || d'\''
OK
$ test-expr '\''((A != b) >= C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A != b) >= C) || D'\'' '\''(A != b) >= C || D'\''
OK
$ test-expr '\''((A != B) >= c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != B) >= c) || d'\'' '\''(A != B) >= c || d'\''
OK
$ test-expr '\''((A != B) >= c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A != B) >= c) || D'\'' '\''(A != B) >= c || D'\''
OK
$ test-expr '\''((A != B) >= C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A != B) >= C) || d'\'' '\''(A != B) >= C || d'\''
OK
$ test-expr '\''((A != B) >= C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A != B) >= C) || D'\'' '\''(A != B) >= C || D'\''
OK
$ test-expr '\''((a && b) >= c) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a && b) >= c) || d'\'' '\''(a && b) >= c || d'\''
OK
$ test-expr '\''((a && b) >= c) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a && b) >= c) || D'\'' '\''(a && b) >= c || D'\''
OK
$ test-expr '\''((a && b) >= C) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a && b) >= C) || d'\'' '\''(a && b) >= C || d'\''
OK
$ test-expr '\''((a && b) >= C) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a && b) >= C) || D'\'' '\''(a && b) >= C || D'\''
OK
$ test-expr '\''((a && B) >= c) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a && B) >= c) || d'\'' '\''(a && B) >= c || d'\''
OK
$ test-expr '\''((a && B) >= c) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a && B) >= c) || D'\'' '\''(a && B) >= c || D'\''
OK
$ test-expr '\''((a && B) >= C) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a && B) >= C) || d'\'' '\''(a && B) >= C || d'\''
OK
$ test-expr '\''((a && B) >= C) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a && B) >= C) || D'\'' '\''(a && B) >= C || D'\''
OK
$ test-expr '\''((A && b) >= c) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A && b) >= c) || d'\'' '\''(A && b) >= c || d'\''
OK
$ test-expr '\''((A && b) >= c) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A && b) >= c) || D'\'' '\''(A && b) >= c || D'\''
OK
$ test-expr '\''((A && b) >= C) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A && b) >= C) || d'\'' '\''(A && b) >= C || d'\''
OK
$ test-expr '\''((A && b) >= C) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A && b) >= C) || D'\'' '\''(A && b) >= C || D'\''
OK
$ test-expr '\''((A && B) >= c) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A && B) >= c) || d'\'' '\''(A && B) >= c || d'\''
OK
$ test-expr '\''((A && B) >= c) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A && B) >= c) || D'\'' '\''(A && B) >= c || D'\''
OK
$ test-expr '\''((A && B) >= C) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A && B) >= C) || d'\'' '\''(A && B) >= C || d'\''
OK
$ test-expr '\''((A && B) >= C) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A && B) >= C) || D'\'' '\''(A && B) >= C || D'\''
OK
$ test-expr '\''((a && b) != c) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a && b) != c) || d'\'' '\''(a && b) != c || d'\''
OK
$ test-expr '\''((a && b) != c) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a && b) != c) || D'\'' '\''(a && b) != c || D'\''
OK
$ test-expr '\''((a && b) != C) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a && b) != C) || d'\'' '\''(a && b) != C || d'\''
OK
$ test-expr '\''((a && b) != C) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((a && b) != C) || D'\'' '\''(a && b) != C || D'\''
OK
$ test-expr '\''((a && B) != c) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a && B) != c) || d'\'' '\''(a && B) != c || d'\''
OK
$ test-expr '\''((a && B) != c) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a && B) != c) || D'\'' '\''(a && B) != c || D'\''
OK
$ test-expr '\''((a && B) != C) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a && B) != C) || d'\'' '\''(a && B) != C || d'\''
OK
$ test-expr '\''((a && B) != C) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((a && B) != C) || D'\'' '\''(a && B) != C || D'\''
OK
$ test-expr '\''((A && b) != c) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A && b) != c) || d'\'' '\''(A && b) != c || d'\''
OK
$ test-expr '\''((A && b) != c) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A && b) != c) || D'\'' '\''(A && b) != c || D'\''
OK
$ test-expr '\''((A && b) != C) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A && b) != C) || d'\'' '\''(A && b) != C || d'\''
OK
$ test-expr '\''((A && b) != C) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(D)
$ diff-expr '\''((A && b) != C) || D'\'' '\''(A && b) != C || D'\''
OK
$ test-expr '\''((A && B) != c) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A && B) != c) || d'\'' '\''(A && B) != c || d'\''
OK
$ test-expr '\''((A && B) != c) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A && B) != c) || D'\'' '\''(A && B) != c || D'\''
OK
$ test-expr '\''((A && B) != C) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A && B) != C) || d'\'' '\''(A && B) != C || d'\''
OK
$ test-expr '\''((A && B) != C) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''((A && B) != C) || D'\'' '\''(A && B) != C || D'\''
OK
$ test-expr '\''a != ((b >= c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((b >= c) && d)'\'' '\''a != (b >= c && d)'\''
OK
$ test-expr '\''a != ((b >= c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((b >= c) && D)'\'' '\''a != (b >= c && D)'\''
OK
$ test-expr '\''a != ((b >= C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((b >= C) && d)'\'' '\''a != (b >= C && d)'\''
OK
$ test-expr '\''a != ((b >= C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((b >= C) && D)'\'' '\''a != (b >= C && D)'\''
OK
$ test-expr '\''a != ((B >= c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((B >= c) && d)'\'' '\''a != (B >= c && d)'\''
OK
$ test-expr '\''a != ((B >= c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((B >= c) && D)'\'' '\''a != (B >= c && D)'\''
OK
$ test-expr '\''a != ((B >= C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((B >= C) && d)'\'' '\''a != (B >= C && d)'\''
OK
$ test-expr '\''a != ((B >= C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((B >= C) && D)'\'' '\''a != (B >= C && D)'\''
OK
$ test-expr '\''A != ((b >= c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((b >= c) && d)'\'' '\''A != (b >= c && d)'\''
OK
$ test-expr '\''A != ((b >= c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((b >= c) && D)'\'' '\''A != (b >= c && D)'\''
OK
$ test-expr '\''A != ((b >= C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((b >= C) && d)'\'' '\''A != (b >= C && d)'\''
OK
$ test-expr '\''A != ((b >= C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((b >= C) && D)'\'' '\''A != (b >= C && D)'\''
OK
$ test-expr '\''A != ((B >= c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((B >= c) && d)'\'' '\''A != (B >= c && d)'\''
OK
$ test-expr '\''A != ((B >= c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((B >= c) && D)'\'' '\''A != (B >= c && D)'\''
OK
$ test-expr '\''A != ((B >= C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((B >= C) && d)'\'' '\''A != (B >= C && d)'\''
OK
$ test-expr '\''A != ((B >= C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((B >= C) && D)'\'' '\''A != (B >= C && D)'\''
OK
$ test-expr '\''a != ((b >= c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((b >= c) || d)'\'' '\''a != (b >= c || d)'\''
OK
$ test-expr '\''a != ((b >= c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((b >= c) || D)'\'' '\''a != (b >= c || D)'\''
OK
$ test-expr '\''a != ((b >= C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((b >= C) || d)'\'' '\''a != (b >= C || d)'\''
OK
$ test-expr '\''a != ((b >= C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((b >= C) || D)'\'' '\''a != (b >= C || D)'\''
OK
$ test-expr '\''a != ((B >= c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((B >= c) || d)'\'' '\''a != (B >= c || d)'\''
OK
$ test-expr '\''a != ((B >= c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((B >= c) || D)'\'' '\''a != (B >= c || D)'\''
OK
$ test-expr '\''a != ((B >= C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a != ((B >= C) || d)'\'' '\''a != (B >= C || d)'\''
OK
$ test-expr '\''a != ((B >= C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a != ((B >= C) || D)'\'' '\''a != (B >= C || D)'\''
OK
$ test-expr '\''A != ((b >= c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((b >= c) || d)'\'' '\''A != (b >= c || d)'\''
OK
$ test-expr '\''A != ((b >= c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((b >= c) || D)'\'' '\''A != (b >= c || D)'\''
OK
$ test-expr '\''A != ((b >= C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((b >= C) || d)'\'' '\''A != (b >= C || d)'\''
OK
$ test-expr '\''A != ((b >= C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((b >= C) || D)'\'' '\''A != (b >= C || D)'\''
OK
$ test-expr '\''A != ((B >= c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((B >= c) || d)'\'' '\''A != (B >= c || d)'\''
OK
$ test-expr '\''A != ((B >= c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((B >= c) || D)'\'' '\''A != (B >= c || D)'\''
OK
$ test-expr '\''A != ((B >= C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A != ((B >= C) || d)'\'' '\''A != (B >= C || d)'\''
OK
$ test-expr '\''A != ((B >= C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A != ((B >= C) || D)'\'' '\''A != (B >= C || D)'\''
OK
$ test-expr '\''a && ((b >= c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((b >= c) || d)'\'' '\''a && (b >= c || d)'\''
OK
$ test-expr '\''a && ((b >= c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((b >= c) || D)'\'' '\''a && (b >= c || D)'\''
OK
$ test-expr '\''a && ((b >= C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((b >= C) || d)'\'' '\''a && (b >= C || d)'\''
OK
$ test-expr '\''a && ((b >= C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((b >= C) || D)'\'' '\''a && (b >= C || D)'\''
OK
$ test-expr '\''a && ((B >= c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((B >= c) || d)'\'' '\''a && (B >= c || d)'\''
OK
$ test-expr '\''a && ((B >= c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((B >= c) || D)'\'' '\''a && (B >= c || D)'\''
OK
$ test-expr '\''a && ((B >= C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((B >= C) || d)'\'' '\''a && (B >= C || d)'\''
OK
$ test-expr '\''a && ((B >= C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((B >= C) || D)'\'' '\''a && (B >= C || D)'\''
OK
$ test-expr '\''A && ((b >= c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((b >= c) || d)'\'' '\''A && (b >= c || d)'\''
OK
$ test-expr '\''A && ((b >= c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((b >= c) || D)'\'' '\''A && (b >= c || D)'\''
OK
$ test-expr '\''A && ((b >= C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((b >= C) || d)'\'' '\''A && (b >= C || d)'\''
OK
$ test-expr '\''A && ((b >= C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((b >= C) || D)'\'' '\''A && (b >= C || D)'\''
OK
$ test-expr '\''A && ((B >= c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((B >= c) || d)'\'' '\''A && (B >= c || d)'\''
OK
$ test-expr '\''A && ((B >= c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((B >= c) || D)'\'' '\''A && (B >= c || D)'\''
OK
$ test-expr '\''A && ((B >= C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((B >= C) || d)'\'' '\''A && (B >= C || d)'\''
OK
$ test-expr '\''A && ((B >= C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((B >= C) || D)'\'' '\''A && (B >= C || D)'\''
OK
$ test-expr '\''a && ((b != c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((b != c) || d)'\'' '\''a && (b != c || d)'\''
OK
$ test-expr '\''a && ((b != c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((b != c) || D)'\'' '\''a && (b != c || D)'\''
OK
$ test-expr '\''a && ((b != C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((b != C) || d)'\'' '\''a && (b != C || d)'\''
OK
$ test-expr '\''a && ((b != C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((b != C) || D)'\'' '\''a && (b != C || D)'\''
OK
$ test-expr '\''a && ((B != c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((B != c) || d)'\'' '\''a && (B != c || d)'\''
OK
$ test-expr '\''a && ((B != c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((B != c) || D)'\'' '\''a && (B != c || D)'\''
OK
$ test-expr '\''a && ((B != C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a && ((B != C) || d)'\'' '\''a && (B != C || d)'\''
OK
$ test-expr '\''a && ((B != C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''a && ((B != C) || D)'\'' '\''a && (B != C || D)'\''
OK
$ test-expr '\''A && ((b != c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((b != c) || d)'\'' '\''A && (b != c || d)'\''
OK
$ test-expr '\''A && ((b != c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((b != c) || D)'\'' '\''A && (b != c || D)'\''
OK
$ test-expr '\''A && ((b != C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((b != C) || d)'\'' '\''A && (b != C || d)'\''
OK
$ test-expr '\''A && ((b != C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((b != C) || D)'\'' '\''A && (b != C || D)'\''
OK
$ test-expr '\''A && ((B != c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((B != c) || d)'\'' '\''A && (B != c || d)'\''
OK
$ test-expr '\''A && ((B != c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((B != c) || D)'\'' '\''A && (B != c || D)'\''
OK
$ test-expr '\''A && ((B != C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A && ((B != C) || d)'\'' '\''A && (B != C || d)'\''
OK
$ test-expr '\''A && ((B != C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''A && ((B != C) || D)'\'' '\''A && (B != C || D)'\''
OK
$ test-expr '\''(a != (b >= c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (b >= c)) && d'\'' '\''a != (b >= c) && d'\''
OK
$ diff-expr '\''(a != (b >= c)) && d'\'' '\''a != b >= c && d'\''
OK
$ diff-expr '\''(a != (b >= c)) && d'\'' '\''(a != b >= c) && d'\''
OK
$ test-expr '\''(a != (b >= c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (b >= c)) && D'\'' '\''a != (b >= c) && D'\''
OK
$ diff-expr '\''(a != (b >= c)) && D'\'' '\''a != b >= c && D'\''
OK
$ diff-expr '\''(a != (b >= c)) && D'\'' '\''(a != b >= c) && D'\''
OK
$ test-expr '\''(a != (b >= C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (b >= C)) && d'\'' '\''a != (b >= C) && d'\''
OK
$ diff-expr '\''(a != (b >= C)) && d'\'' '\''a != b >= C && d'\''
OK
$ diff-expr '\''(a != (b >= C)) && d'\'' '\''(a != b >= C) && d'\''
OK
$ test-expr '\''(a != (b >= C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (b >= C)) && D'\'' '\''a != (b >= C) && D'\''
OK
$ diff-expr '\''(a != (b >= C)) && D'\'' '\''a != b >= C && D'\''
OK
$ diff-expr '\''(a != (b >= C)) && D'\'' '\''(a != b >= C) && D'\''
OK
$ test-expr '\''(a != (B >= c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (B >= c)) && d'\'' '\''a != (B >= c) && d'\''
OK
$ diff-expr '\''(a != (B >= c)) && d'\'' '\''a != B >= c && d'\''
OK
$ diff-expr '\''(a != (B >= c)) && d'\'' '\''(a != B >= c) && d'\''
OK
$ test-expr '\''(a != (B >= c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (B >= c)) && D'\'' '\''a != (B >= c) && D'\''
OK
$ diff-expr '\''(a != (B >= c)) && D'\'' '\''a != B >= c && D'\''
OK
$ diff-expr '\''(a != (B >= c)) && D'\'' '\''(a != B >= c) && D'\''
OK
$ test-expr '\''(a != (B >= C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (B >= C)) && d'\'' '\''a != (B >= C) && d'\''
OK
$ diff-expr '\''(a != (B >= C)) && d'\'' '\''a != B >= C && d'\''
OK
$ diff-expr '\''(a != (B >= C)) && d'\'' '\''(a != B >= C) && d'\''
OK
$ test-expr '\''(a != (B >= C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (B >= C)) && D'\'' '\''a != (B >= C) && D'\''
OK
$ diff-expr '\''(a != (B >= C)) && D'\'' '\''a != B >= C && D'\''
OK
$ diff-expr '\''(a != (B >= C)) && D'\'' '\''(a != B >= C) && D'\''
OK
$ test-expr '\''(A != (b >= c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (b >= c)) && d'\'' '\''A != (b >= c) && d'\''
OK
$ diff-expr '\''(A != (b >= c)) && d'\'' '\''A != b >= c && d'\''
OK
$ diff-expr '\''(A != (b >= c)) && d'\'' '\''(A != b >= c) && d'\''
OK
$ test-expr '\''(A != (b >= c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (b >= c)) && D'\'' '\''A != (b >= c) && D'\''
OK
$ diff-expr '\''(A != (b >= c)) && D'\'' '\''A != b >= c && D'\''
OK
$ diff-expr '\''(A != (b >= c)) && D'\'' '\''(A != b >= c) && D'\''
OK
$ test-expr '\''(A != (b >= C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (b >= C)) && d'\'' '\''A != (b >= C) && d'\''
OK
$ diff-expr '\''(A != (b >= C)) && d'\'' '\''A != b >= C && d'\''
OK
$ diff-expr '\''(A != (b >= C)) && d'\'' '\''(A != b >= C) && d'\''
OK
$ test-expr '\''(A != (b >= C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (b >= C)) && D'\'' '\''A != (b >= C) && D'\''
OK
$ diff-expr '\''(A != (b >= C)) && D'\'' '\''A != b >= C && D'\''
OK
$ diff-expr '\''(A != (b >= C)) && D'\'' '\''(A != b >= C) && D'\''
OK
$ test-expr '\''(A != (B >= c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (B >= c)) && d'\'' '\''A != (B >= c) && d'\''
OK
$ diff-expr '\''(A != (B >= c)) && d'\'' '\''A != B >= c && d'\''
OK
$ diff-expr '\''(A != (B >= c)) && d'\'' '\''(A != B >= c) && d'\''
OK
$ test-expr '\''(A != (B >= c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (B >= c)) && D'\'' '\''A != (B >= c) && D'\''
OK
$ diff-expr '\''(A != (B >= c)) && D'\'' '\''A != B >= c && D'\''
OK
$ diff-expr '\''(A != (B >= c)) && D'\'' '\''(A != B >= c) && D'\''
OK
$ test-expr '\''(A != (B >= C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (B >= C)) && d'\'' '\''A != (B >= C) && d'\''
OK
$ diff-expr '\''(A != (B >= C)) && d'\'' '\''A != B >= C && d'\''
OK
$ diff-expr '\''(A != (B >= C)) && d'\'' '\''(A != B >= C) && d'\''
OK
$ test-expr '\''(A != (B >= C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (B >= C)) && D'\'' '\''A != (B >= C) && D'\''
OK
$ diff-expr '\''(A != (B >= C)) && D'\'' '\''A != B >= C && D'\''
OK
$ diff-expr '\''(A != (B >= C)) && D'\'' '\''(A != B >= C) && D'\''
OK
$ test-expr '\''(a != (b >= c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (b >= c)) || d'\'' '\''a != (b >= c) || d'\''
OK
$ diff-expr '\''(a != (b >= c)) || d'\'' '\''a != b >= c || d'\''
OK
$ diff-expr '\''(a != (b >= c)) || d'\'' '\''(a != b >= c) || d'\''
OK
$ test-expr '\''(a != (b >= c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (b >= c)) || D'\'' '\''a != (b >= c) || D'\''
OK
$ diff-expr '\''(a != (b >= c)) || D'\'' '\''a != b >= c || D'\''
OK
$ diff-expr '\''(a != (b >= c)) || D'\'' '\''(a != b >= c) || D'\''
OK
$ test-expr '\''(a != (b >= C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (b >= C)) || d'\'' '\''a != (b >= C) || d'\''
OK
$ diff-expr '\''(a != (b >= C)) || d'\'' '\''a != b >= C || d'\''
OK
$ diff-expr '\''(a != (b >= C)) || d'\'' '\''(a != b >= C) || d'\''
OK
$ test-expr '\''(a != (b >= C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (b >= C)) || D'\'' '\''a != (b >= C) || D'\''
OK
$ diff-expr '\''(a != (b >= C)) || D'\'' '\''a != b >= C || D'\''
OK
$ diff-expr '\''(a != (b >= C)) || D'\'' '\''(a != b >= C) || D'\''
OK
$ test-expr '\''(a != (B >= c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (B >= c)) || d'\'' '\''a != (B >= c) || d'\''
OK
$ diff-expr '\''(a != (B >= c)) || d'\'' '\''a != B >= c || d'\''
OK
$ diff-expr '\''(a != (B >= c)) || d'\'' '\''(a != B >= c) || d'\''
OK
$ test-expr '\''(a != (B >= c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (B >= c)) || D'\'' '\''a != (B >= c) || D'\''
OK
$ diff-expr '\''(a != (B >= c)) || D'\'' '\''a != B >= c || D'\''
OK
$ diff-expr '\''(a != (B >= c)) || D'\'' '\''(a != B >= c) || D'\''
OK
$ test-expr '\''(a != (B >= C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a != (B >= C)) || d'\'' '\''a != (B >= C) || d'\''
OK
$ diff-expr '\''(a != (B >= C)) || d'\'' '\''a != B >= C || d'\''
OK
$ diff-expr '\''(a != (B >= C)) || d'\'' '\''(a != B >= C) || d'\''
OK
$ test-expr '\''(a != (B >= C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a != (B >= C)) || D'\'' '\''a != (B >= C) || D'\''
OK
$ diff-expr '\''(a != (B >= C)) || D'\'' '\''a != B >= C || D'\''
OK
$ diff-expr '\''(a != (B >= C)) || D'\'' '\''(a != B >= C) || D'\''
OK
$ test-expr '\''(A != (b >= c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (b >= c)) || d'\'' '\''A != (b >= c) || d'\''
OK
$ diff-expr '\''(A != (b >= c)) || d'\'' '\''A != b >= c || d'\''
OK
$ diff-expr '\''(A != (b >= c)) || d'\'' '\''(A != b >= c) || d'\''
OK
$ test-expr '\''(A != (b >= c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (b >= c)) || D'\'' '\''A != (b >= c) || D'\''
OK
$ diff-expr '\''(A != (b >= c)) || D'\'' '\''A != b >= c || D'\''
OK
$ diff-expr '\''(A != (b >= c)) || D'\'' '\''(A != b >= c) || D'\''
OK
$ test-expr '\''(A != (b >= C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (b >= C)) || d'\'' '\''A != (b >= C) || d'\''
OK
$ diff-expr '\''(A != (b >= C)) || d'\'' '\''A != b >= C || d'\''
OK
$ diff-expr '\''(A != (b >= C)) || d'\'' '\''(A != b >= C) || d'\''
OK
$ test-expr '\''(A != (b >= C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (b >= C)) || D'\'' '\''A != (b >= C) || D'\''
OK
$ diff-expr '\''(A != (b >= C)) || D'\'' '\''A != b >= C || D'\''
OK
$ diff-expr '\''(A != (b >= C)) || D'\'' '\''(A != b >= C) || D'\''
OK
$ test-expr '\''(A != (B >= c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (B >= c)) || d'\'' '\''A != (B >= c) || d'\''
OK
$ diff-expr '\''(A != (B >= c)) || d'\'' '\''A != B >= c || d'\''
OK
$ diff-expr '\''(A != (B >= c)) || d'\'' '\''(A != B >= c) || d'\''
OK
$ test-expr '\''(A != (B >= c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (B >= c)) || D'\'' '\''A != (B >= c) || D'\''
OK
$ diff-expr '\''(A != (B >= c)) || D'\'' '\''A != B >= c || D'\''
OK
$ diff-expr '\''(A != (B >= c)) || D'\'' '\''(A != B >= c) || D'\''
OK
$ test-expr '\''(A != (B >= C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A != (B >= C)) || d'\'' '\''A != (B >= C) || d'\''
OK
$ diff-expr '\''(A != (B >= C)) || d'\'' '\''A != B >= C || d'\''
OK
$ diff-expr '\''(A != (B >= C)) || d'\'' '\''(A != B >= C) || d'\''
OK
$ test-expr '\''(A != (B >= C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A != (B >= C)) || D'\'' '\''A != (B >= C) || D'\''
OK
$ diff-expr '\''(A != (B >= C)) || D'\'' '\''A != B >= C || D'\''
OK
$ diff-expr '\''(A != (B >= C)) || D'\'' '\''(A != B >= C) || D'\''
OK
$ test-expr '\''(a && (b >= c)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (b >= c)) || d'\'' '\''a && (b >= c) || d'\''
OK
$ diff-expr '\''(a && (b >= c)) || d'\'' '\''a && b >= c || d'\''
OK
$ diff-expr '\''(a && (b >= c)) || d'\'' '\''(a && b >= c) || d'\''
OK
$ test-expr '\''(a && (b >= c)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (b >= c)) || D'\'' '\''a && (b >= c) || D'\''
OK
$ diff-expr '\''(a && (b >= c)) || D'\'' '\''a && b >= c || D'\''
OK
$ diff-expr '\''(a && (b >= c)) || D'\'' '\''(a && b >= c) || D'\''
OK
$ test-expr '\''(a && (b >= C)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (b >= C)) || d'\'' '\''a && (b >= C) || d'\''
OK
$ diff-expr '\''(a && (b >= C)) || d'\'' '\''a && b >= C || d'\''
OK
$ diff-expr '\''(a && (b >= C)) || d'\'' '\''(a && b >= C) || d'\''
OK
$ test-expr '\''(a && (b >= C)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (b >= C)) || D'\'' '\''a && (b >= C) || D'\''
OK
$ diff-expr '\''(a && (b >= C)) || D'\'' '\''a && b >= C || D'\''
OK
$ diff-expr '\''(a && (b >= C)) || D'\'' '\''(a && b >= C) || D'\''
OK
$ test-expr '\''(a && (B >= c)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (B >= c)) || d'\'' '\''a && (B >= c) || d'\''
OK
$ diff-expr '\''(a && (B >= c)) || d'\'' '\''a && B >= c || d'\''
OK
$ diff-expr '\''(a && (B >= c)) || d'\'' '\''(a && B >= c) || d'\''
OK
$ test-expr '\''(a && (B >= c)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (B >= c)) || D'\'' '\''a && (B >= c) || D'\''
OK
$ diff-expr '\''(a && (B >= c)) || D'\'' '\''a && B >= c || D'\''
OK
$ diff-expr '\''(a && (B >= c)) || D'\'' '\''(a && B >= c) || D'\''
OK
$ test-expr '\''(a && (B >= C)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (B >= C)) || d'\'' '\''a && (B >= C) || d'\''
OK
$ diff-expr '\''(a && (B >= C)) || d'\'' '\''a && B >= C || d'\''
OK
$ diff-expr '\''(a && (B >= C)) || d'\'' '\''(a && B >= C) || d'\''
OK
$ test-expr '\''(a && (B >= C)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (B >= C)) || D'\'' '\''a && (B >= C) || D'\''
OK
$ diff-expr '\''(a && (B >= C)) || D'\'' '\''a && B >= C || D'\''
OK
$ diff-expr '\''(a && (B >= C)) || D'\'' '\''(a && B >= C) || D'\''
OK
$ test-expr '\''(A && (b >= c)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (b >= c)) || d'\'' '\''A && (b >= c) || d'\''
OK
$ diff-expr '\''(A && (b >= c)) || d'\'' '\''A && b >= c || d'\''
OK
$ diff-expr '\''(A && (b >= c)) || d'\'' '\''(A && b >= c) || d'\''
OK
$ test-expr '\''(A && (b >= c)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (b >= c)) || D'\'' '\''A && (b >= c) || D'\''
OK
$ diff-expr '\''(A && (b >= c)) || D'\'' '\''A && b >= c || D'\''
OK
$ diff-expr '\''(A && (b >= c)) || D'\'' '\''(A && b >= c) || D'\''
OK
$ test-expr '\''(A && (b >= C)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (b >= C)) || d'\'' '\''A && (b >= C) || d'\''
OK
$ diff-expr '\''(A && (b >= C)) || d'\'' '\''A && b >= C || d'\''
OK
$ diff-expr '\''(A && (b >= C)) || d'\'' '\''(A && b >= C) || d'\''
OK
$ test-expr '\''(A && (b >= C)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (b >= C)) || D'\'' '\''A && (b >= C) || D'\''
OK
$ diff-expr '\''(A && (b >= C)) || D'\'' '\''A && b >= C || D'\''
OK
$ diff-expr '\''(A && (b >= C)) || D'\'' '\''(A && b >= C) || D'\''
OK
$ test-expr '\''(A && (B >= c)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (B >= c)) || d'\'' '\''A && (B >= c) || d'\''
OK
$ diff-expr '\''(A && (B >= c)) || d'\'' '\''A && B >= c || d'\''
OK
$ diff-expr '\''(A && (B >= c)) || d'\'' '\''(A && B >= c) || d'\''
OK
$ test-expr '\''(A && (B >= c)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (B >= c)) || D'\'' '\''A && (B >= c) || D'\''
OK
$ diff-expr '\''(A && (B >= c)) || D'\'' '\''A && B >= c || D'\''
OK
$ diff-expr '\''(A && (B >= c)) || D'\'' '\''(A && B >= c) || D'\''
OK
$ test-expr '\''(A && (B >= C)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (B >= C)) || d'\'' '\''A && (B >= C) || d'\''
OK
$ diff-expr '\''(A && (B >= C)) || d'\'' '\''A && B >= C || d'\''
OK
$ diff-expr '\''(A && (B >= C)) || d'\'' '\''(A && B >= C) || d'\''
OK
$ test-expr '\''(A && (B >= C)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (B >= C)) || D'\'' '\''A && (B >= C) || D'\''
OK
$ diff-expr '\''(A && (B >= C)) || D'\'' '\''A && B >= C || D'\''
OK
$ diff-expr '\''(A && (B >= C)) || D'\'' '\''(A && B >= C) || D'\''
OK
$ test-expr '\''(a && (b != c)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (b != c)) || d'\'' '\''a && (b != c) || d'\''
OK
$ diff-expr '\''(a && (b != c)) || d'\'' '\''a && b != c || d'\''
OK
$ diff-expr '\''(a && (b != c)) || d'\'' '\''(a && b != c) || d'\''
OK
$ test-expr '\''(a && (b != c)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (b != c)) || D'\'' '\''a && (b != c) || D'\''
OK
$ diff-expr '\''(a && (b != c)) || D'\'' '\''a && b != c || D'\''
OK
$ diff-expr '\''(a && (b != c)) || D'\'' '\''(a && b != c) || D'\''
OK
$ test-expr '\''(a && (b != C)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (b != C)) || d'\'' '\''a && (b != C) || d'\''
OK
$ diff-expr '\''(a && (b != C)) || d'\'' '\''a && b != C || d'\''
OK
$ diff-expr '\''(a && (b != C)) || d'\'' '\''(a && b != C) || d'\''
OK
$ test-expr '\''(a && (b != C)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (b != C)) || D'\'' '\''a && (b != C) || D'\''
OK
$ diff-expr '\''(a && (b != C)) || D'\'' '\''a && b != C || D'\''
OK
$ diff-expr '\''(a && (b != C)) || D'\'' '\''(a && b != C) || D'\''
OK
$ test-expr '\''(a && (B != c)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (B != c)) || d'\'' '\''a && (B != c) || d'\''
OK
$ diff-expr '\''(a && (B != c)) || d'\'' '\''a && B != c || d'\''
OK
$ diff-expr '\''(a && (B != c)) || d'\'' '\''(a && B != c) || d'\''
OK
$ test-expr '\''(a && (B != c)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (B != c)) || D'\'' '\''a && (B != c) || D'\''
OK
$ diff-expr '\''(a && (B != c)) || D'\'' '\''a && B != c || D'\''
OK
$ diff-expr '\''(a && (B != c)) || D'\'' '\''(a && B != c) || D'\''
OK
$ test-expr '\''(a && (B != C)) || d'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a && (B != C)) || d'\'' '\''a && (B != C) || d'\''
OK
$ diff-expr '\''(a && (B != C)) || d'\'' '\''a && B != C || d'\''
OK
$ diff-expr '\''(a && (B != C)) || d'\'' '\''(a && B != C) || d'\''
OK
$ test-expr '\''(a && (B != C)) || D'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(a && (B != C)) || D'\'' '\''a && (B != C) || D'\''
OK
$ diff-expr '\''(a && (B != C)) || D'\'' '\''a && B != C || D'\''
OK
$ diff-expr '\''(a && (B != C)) || D'\'' '\''(a && B != C) || D'\''
OK
$ test-expr '\''(A && (b != c)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (b != c)) || d'\'' '\''A && (b != c) || d'\''
OK
$ diff-expr '\''(A && (b != c)) || d'\'' '\''A && b != c || d'\''
OK
$ diff-expr '\''(A && (b != c)) || d'\'' '\''(A && b != c) || d'\''
OK
$ test-expr '\''(A && (b != c)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (b != c)) || D'\'' '\''A && (b != c) || D'\''
OK
$ diff-expr '\''(A && (b != c)) || D'\'' '\''A && b != c || D'\''
OK
$ diff-expr '\''(A && (b != c)) || D'\'' '\''(A && b != c) || D'\''
OK
$ test-expr '\''(A && (b != C)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (b != C)) || d'\'' '\''A && (b != C) || d'\''
OK
$ diff-expr '\''(A && (b != C)) || d'\'' '\''A && b != C || d'\''
OK
$ diff-expr '\''(A && (b != C)) || d'\'' '\''(A && b != C) || d'\''
OK
$ test-expr '\''(A && (b != C)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (b != C)) || D'\'' '\''A && (b != C) || D'\''
OK
$ diff-expr '\''(A && (b != C)) || D'\'' '\''A && b != C || D'\''
OK
$ diff-expr '\''(A && (b != C)) || D'\'' '\''(A && b != C) || D'\''
OK
$ test-expr '\''(A && (B != c)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (B != c)) || d'\'' '\''A && (B != c) || d'\''
OK
$ diff-expr '\''(A && (B != c)) || d'\'' '\''A && B != c || d'\''
OK
$ diff-expr '\''(A && (B != c)) || d'\'' '\''(A && B != c) || d'\''
OK
$ test-expr '\''(A && (B != c)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (B != c)) || D'\'' '\''A && (B != c) || D'\''
OK
$ diff-expr '\''(A && (B != c)) || D'\'' '\''A && B != c || D'\''
OK
$ diff-expr '\''(A && (B != c)) || D'\'' '\''(A && B != c) || D'\''
OK
$ test-expr '\''(A && (B != C)) || d'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A && (B != C)) || d'\'' '\''A && (B != C) || d'\''
OK
$ diff-expr '\''(A && (B != C)) || d'\'' '\''A && B != C || d'\''
OK
$ diff-expr '\''(A && (B != C)) || d'\'' '\''(A && B != C) || d'\''
OK
$ test-expr '\''(A && (B != C)) || D'\''
0 call_builtin(A)
1 jump_false*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(D)
$ diff-expr '\''(A && (B != C)) || D'\'' '\''A && (B != C) || D'\''
OK
$ diff-expr '\''(A && (B != C)) || D'\'' '\''A && B != C || D'\''
OK
$ diff-expr '\''(A && (B != C)) || D'\'' '\''(A && B != C) || D'\''
OK
$ test-expr '\''(a != b) >= (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != b) >= (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != b) >= (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != b) >= (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != B) >= (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != B) >= (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != B) >= (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != B) >= (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != b) >= (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != b) >= (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != b) >= (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != b) >= (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != B) >= (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != B) >= (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != B) >= (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != B) >= (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != b) >= (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != b) >= (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != b) >= (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != b) >= (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != B) >= (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != B) >= (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != B) >= (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a != B) >= (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != b) >= (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != b) >= (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != b) >= (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != b) >= (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != B) >= (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != B) >= (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != B) >= (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A != B) >= (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a && b) >= (c || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(a && b) >= (c || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a && b) >= (C || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(a && b) >= (C || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a && B) >= (c || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a && B) >= (c || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a && B) >= (C || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a && B) >= (C || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A && b) >= (c || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(A && b) >= (c || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A && b) >= (C || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(A && b) >= (C || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A && B) >= (c || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A && B) >= (c || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A && B) >= (C || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A && B) >= (C || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a && b) != (c || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(a && b) != (c || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(a && b) != (C || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(a && b) != (C || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(a && B) != (c || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(a && B) != (c || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(a && B) != (C || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(a && B) != (C || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(A && b) != (c || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(A && b) != (c || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(A && b) != (C || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(A && b) != (C || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(A && B) != (c || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(A && B) != (c || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(A && B) != (C || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(A && B) != (C || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a != (b >= (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (b >= (c && d))'\'' '\''a != b >= (c && d)'\''
OK
$ test-expr '\''a != (b >= (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b >= (c && D))'\'' '\''a != b >= (c && D)'\''
OK
$ test-expr '\''a != (b >= (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (b >= (C && d))'\'' '\''a != b >= (C && d)'\''
OK
$ test-expr '\''a != (b >= (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b >= (C && D))'\'' '\''a != b >= (C && D)'\''
OK
$ test-expr '\''a != (B >= (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (B >= (c && d))'\'' '\''a != B >= (c && d)'\''
OK
$ test-expr '\''a != (B >= (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B >= (c && D))'\'' '\''a != B >= (c && D)'\''
OK
$ test-expr '\''a != (B >= (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (B >= (C && d))'\'' '\''a != B >= (C && d)'\''
OK
$ test-expr '\''a != (B >= (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B >= (C && D))'\'' '\''a != B >= (C && D)'\''
OK
$ test-expr '\''A != (b >= (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (b >= (c && d))'\'' '\''A != b >= (c && d)'\''
OK
$ test-expr '\''A != (b >= (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b >= (c && D))'\'' '\''A != b >= (c && D)'\''
OK
$ test-expr '\''A != (b >= (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (b >= (C && d))'\'' '\''A != b >= (C && d)'\''
OK
$ test-expr '\''A != (b >= (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b >= (C && D))'\'' '\''A != b >= (C && D)'\''
OK
$ test-expr '\''A != (B >= (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (B >= (c && d))'\'' '\''A != B >= (c && d)'\''
OK
$ test-expr '\''A != (B >= (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B >= (c && D))'\'' '\''A != B >= (c && D)'\''
OK
$ test-expr '\''A != (B >= (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (B >= (C && d))'\'' '\''A != B >= (C && d)'\''
OK
$ test-expr '\''A != (B >= (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B >= (C && D))'\'' '\''A != B >= (C && D)'\''
OK
$ test-expr '\''a != (b >= (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (b >= (c || d))'\'' '\''a != b >= (c || d)'\''
OK
$ test-expr '\''a != (b >= (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b >= (c || D))'\'' '\''a != b >= (c || D)'\''
OK
$ test-expr '\''a != (b >= (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (b >= (C || d))'\'' '\''a != b >= (C || d)'\''
OK
$ test-expr '\''a != (b >= (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b >= (C || D))'\'' '\''a != b >= (C || D)'\''
OK
$ test-expr '\''a != (B >= (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (B >= (c || d))'\'' '\''a != B >= (c || d)'\''
OK
$ test-expr '\''a != (B >= (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B >= (c || D))'\'' '\''a != B >= (c || D)'\''
OK
$ test-expr '\''a != (B >= (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != (B >= (C || d))'\'' '\''a != B >= (C || d)'\''
OK
$ test-expr '\''a != (B >= (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B >= (C || D))'\'' '\''a != B >= (C || D)'\''
OK
$ test-expr '\''A != (b >= (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (b >= (c || d))'\'' '\''A != b >= (c || d)'\''
OK
$ test-expr '\''A != (b >= (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b >= (c || D))'\'' '\''A != b >= (c || D)'\''
OK
$ test-expr '\''A != (b >= (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (b >= (C || d))'\'' '\''A != b >= (C || d)'\''
OK
$ test-expr '\''A != (b >= (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b >= (C || D))'\'' '\''A != b >= (C || D)'\''
OK
$ test-expr '\''A != (B >= (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (B >= (c || d))'\'' '\''A != B >= (c || d)'\''
OK
$ test-expr '\''A != (B >= (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B >= (c || D))'\'' '\''A != B >= (c || D)'\''
OK
$ test-expr '\''A != (B >= (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != (B >= (C || d))'\'' '\''A != B >= (C || d)'\''
OK
$ test-expr '\''A != (B >= (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B >= (C || D))'\'' '\''A != B >= (C || D)'\''
OK
$ test-expr '\''a && (b >= (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a && (b >= (c || d))'\'' '\''a && b >= (c || d)'\''
OK
$ test-expr '\''a && (b >= (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (b >= (c || D))'\'' '\''a && b >= (c || D)'\''
OK
$ test-expr '\''a && (b >= (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a && (b >= (C || d))'\'' '\''a && b >= (C || d)'\''
OK
$ test-expr '\''a && (b >= (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (b >= (C || D))'\'' '\''a && b >= (C || D)'\''
OK
$ test-expr '\''a && (B >= (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a && (B >= (c || d))'\'' '\''a && B >= (c || d)'\''
OK
$ test-expr '\''a && (B >= (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (B >= (c || D))'\'' '\''a && B >= (c || D)'\''
OK
$ test-expr '\''a && (B >= (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a && (B >= (C || d))'\'' '\''a && B >= (C || d)'\''
OK
$ test-expr '\''a && (B >= (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (B >= (C || D))'\'' '\''a && B >= (C || D)'\''
OK
$ test-expr '\''A && (b >= (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A && (b >= (c || d))'\'' '\''A && b >= (c || d)'\''
OK
$ test-expr '\''A && (b >= (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (b >= (c || D))'\'' '\''A && b >= (c || D)'\''
OK
$ test-expr '\''A && (b >= (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A && (b >= (C || d))'\'' '\''A && b >= (C || d)'\''
OK
$ test-expr '\''A && (b >= (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (b >= (C || D))'\'' '\''A && b >= (C || D)'\''
OK
$ test-expr '\''A && (B >= (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A && (B >= (c || d))'\'' '\''A && B >= (c || d)'\''
OK
$ test-expr '\''A && (B >= (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (B >= (c || D))'\'' '\''A && B >= (c || D)'\''
OK
$ test-expr '\''A && (B >= (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A && (B >= (C || d))'\'' '\''A && B >= (C || d)'\''
OK
$ test-expr '\''A && (B >= (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (B >= (C || D))'\'' '\''A && B >= (C || D)'\''
OK
$ test-expr '\''a && (b != (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a && (b != (c || d))'\'' '\''a && b != (c || d)'\''
OK
$ test-expr '\''a && (b != (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (b != (c || D))'\'' '\''a && b != (c || D)'\''
OK
$ test-expr '\''a && (b != (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a && (b != (C || d))'\'' '\''a && b != (C || d)'\''
OK
$ test-expr '\''a && (b != (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (b != (C || D))'\'' '\''a && b != (C || D)'\''
OK
$ test-expr '\''a && (B != (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a && (B != (c || d))'\'' '\''a && B != (c || d)'\''
OK
$ test-expr '\''a && (B != (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (B != (c || D))'\'' '\''a && B != (c || D)'\''
OK
$ test-expr '\''a && (B != (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a && (B != (C || d))'\'' '\''a && B != (C || d)'\''
OK
$ test-expr '\''a && (B != (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (B != (C || D))'\'' '\''a && B != (C || D)'\''
OK
$ test-expr '\''A && (b != (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A && (b != (c || d))'\'' '\''A && b != (c || d)'\''
OK
$ test-expr '\''A && (b != (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (b != (c || D))'\'' '\''A && b != (c || D)'\''
OK
$ test-expr '\''A && (b != (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A && (b != (C || d))'\'' '\''A && b != (C || d)'\''
OK
$ test-expr '\''A && (b != (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (b != (C || D))'\'' '\''A && b != (C || D)'\''
OK
$ test-expr '\''A && (B != (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A && (B != (c || d))'\'' '\''A && B != (c || d)'\''
OK
$ test-expr '\''A && (B != (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (B != (c || D))'\'' '\''A && B != (c || D)'\''
OK
$ test-expr '\''A && (B != (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A && (B != (C || d))'\'' '\''A && B != (C || d)'\''
OK
$ test-expr '\''A && (B != (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (B != (C || D))'\'' '\''A && B != (C || D)'\''
OK
$ test-expr '\''((a != b) && c) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((a != b) && c) >= d'\'' '\''(a != b && c) >= d'\''
OK
$ test-expr '\''((a != b) && c) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((a != b) && c) >= D'\'' '\''(a != b && c) >= D'\''
OK
$ test-expr '\''((a != b) && C) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((a != b) && C) >= d'\'' '\''(a != b && C) >= d'\''
OK
$ test-expr '\''((a != b) && C) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((a != b) && C) >= D'\'' '\''(a != b && C) >= D'\''
OK
$ test-expr '\''((a != B) && c) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((a != B) && c) >= d'\'' '\''(a != B && c) >= d'\''
OK
$ test-expr '\''((a != B) && c) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((a != B) && c) >= D'\'' '\''(a != B && c) >= D'\''
OK
$ test-expr '\''((a != B) && C) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((a != B) && C) >= d'\'' '\''(a != B && C) >= d'\''
OK
$ test-expr '\''((a != B) && C) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((a != B) && C) >= D'\'' '\''(a != B && C) >= D'\''
OK
$ test-expr '\''((A != b) && c) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((A != b) && c) >= d'\'' '\''(A != b && c) >= d'\''
OK
$ test-expr '\''((A != b) && c) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((A != b) && c) >= D'\'' '\''(A != b && c) >= D'\''
OK
$ test-expr '\''((A != b) && C) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((A != b) && C) >= d'\'' '\''(A != b && C) >= d'\''
OK
$ test-expr '\''((A != b) && C) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((A != b) && C) >= D'\'' '\''(A != b && C) >= D'\''
OK
$ test-expr '\''((A != B) && c) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((A != B) && c) >= d'\'' '\''(A != B && c) >= d'\''
OK
$ test-expr '\''((A != B) && c) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((A != B) && c) >= D'\'' '\''(A != B && c) >= D'\''
OK
$ test-expr '\''((A != B) && C) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((A != B) && C) >= d'\'' '\''(A != B && C) >= d'\''
OK
$ test-expr '\''((A != B) && C) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((A != B) && C) >= D'\'' '\''(A != B && C) >= D'\''
OK
$ test-expr '\''((a != b) || c) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((a != b) || c) >= d'\'' '\''(a != b || c) >= d'\''
OK
$ test-expr '\''((a != b) || c) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((a != b) || c) >= D'\'' '\''(a != b || c) >= D'\''
OK
$ test-expr '\''((a != b) || C) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((a != b) || C) >= d'\'' '\''(a != b || C) >= d'\''
OK
$ test-expr '\''((a != b) || C) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((a != b) || C) >= D'\'' '\''(a != b || C) >= D'\''
OK
$ test-expr '\''((a != B) || c) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((a != B) || c) >= d'\'' '\''(a != B || c) >= d'\''
OK
$ test-expr '\''((a != B) || c) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((a != B) || c) >= D'\'' '\''(a != B || c) >= D'\''
OK
$ test-expr '\''((a != B) || C) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((a != B) || C) >= d'\'' '\''(a != B || C) >= d'\''
OK
$ test-expr '\''((a != B) || C) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((a != B) || C) >= D'\'' '\''(a != B || C) >= D'\''
OK
$ test-expr '\''((A != b) || c) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((A != b) || c) >= d'\'' '\''(A != b || c) >= d'\''
OK
$ test-expr '\''((A != b) || c) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((A != b) || c) >= D'\'' '\''(A != b || c) >= D'\''
OK
$ test-expr '\''((A != b) || C) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((A != b) || C) >= d'\'' '\''(A != b || C) >= d'\''
OK
$ test-expr '\''((A != b) || C) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((A != b) || C) >= D'\'' '\''(A != b || C) >= D'\''
OK
$ test-expr '\''((A != B) || c) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((A != B) || c) >= d'\'' '\''(A != B || c) >= d'\''
OK
$ test-expr '\''((A != B) || c) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((A != B) || c) >= D'\'' '\''(A != B || c) >= D'\''
OK
$ test-expr '\''((A != B) || C) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((A != B) || C) >= d'\'' '\''(A != B || C) >= d'\''
OK
$ test-expr '\''((A != B) || C) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((A != B) || C) >= D'\'' '\''(A != B || C) >= D'\''
OK
$ test-expr '\''((a && b) || c) >= d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ge)
$ diff-expr '\''((a && b) || c) >= d'\'' '\''(a && b || c) >= d'\''
OK
$ test-expr '\''((a && b) || c) >= D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ge)
$ diff-expr '\''((a && b) || c) >= D'\'' '\''(a && b || c) >= D'\''
OK
$ test-expr '\''((a && b) || C) >= d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((a && b) || C) >= d'\'' '\''(a && b || C) >= d'\''
OK
$ test-expr '\''((a && b) || C) >= D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((a && b) || C) >= D'\'' '\''(a && b || C) >= D'\''
OK
$ test-expr '\''((a && B) || c) >= d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((a && B) || c) >= d'\'' '\''(a && B || c) >= d'\''
OK
$ test-expr '\''((a && B) || c) >= D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((a && B) || c) >= D'\'' '\''(a && B || c) >= D'\''
OK
$ test-expr '\''((a && B) || C) >= d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((a && B) || C) >= d'\'' '\''(a && B || C) >= d'\''
OK
$ test-expr '\''((a && B) || C) >= D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((a && B) || C) >= D'\'' '\''(a && B || C) >= D'\''
OK
$ test-expr '\''((A && b) || c) >= d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ge)
$ diff-expr '\''((A && b) || c) >= d'\'' '\''(A && b || c) >= d'\''
OK
$ test-expr '\''((A && b) || c) >= D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ge)
$ diff-expr '\''((A && b) || c) >= D'\'' '\''(A && b || c) >= D'\''
OK
$ test-expr '\''((A && b) || C) >= d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((A && b) || C) >= d'\'' '\''(A && b || C) >= d'\''
OK
$ test-expr '\''((A && b) || C) >= D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((A && b) || C) >= D'\'' '\''(A && b || C) >= D'\''
OK
$ test-expr '\''((A && B) || c) >= d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''((A && B) || c) >= d'\'' '\''(A && B || c) >= d'\''
OK
$ test-expr '\''((A && B) || c) >= D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''((A && B) || c) >= D'\'' '\''(A && B || c) >= D'\''
OK
$ test-expr '\''((A && B) || C) >= d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''((A && B) || C) >= d'\'' '\''(A && B || C) >= d'\''
OK
$ test-expr '\''((A && B) || C) >= D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''((A && B) || C) >= D'\'' '\''(A && B || C) >= D'\''
OK
$ test-expr '\''((a && b) || c) != d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ne)
$ diff-expr '\''((a && b) || c) != d'\'' '\''(a && b || c) != d'\''
OK
$ test-expr '\''((a && b) || c) != D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ne)
$ diff-expr '\''((a && b) || c) != D'\'' '\''(a && b || c) != D'\''
OK
$ test-expr '\''((a && b) || C) != d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a && b) || C) != d'\'' '\''(a && b || C) != d'\''
OK
$ test-expr '\''((a && b) || C) != D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a && b) || C) != D'\'' '\''(a && b || C) != D'\''
OK
$ test-expr '\''((a && B) || c) != d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a && B) || c) != d'\'' '\''(a && B || c) != d'\''
OK
$ test-expr '\''((a && B) || c) != D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a && B) || c) != D'\'' '\''(a && B || c) != D'\''
OK
$ test-expr '\''((a && B) || C) != d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a && B) || C) != d'\'' '\''(a && B || C) != d'\''
OK
$ test-expr '\''((a && B) || C) != D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a && B) || C) != D'\'' '\''(a && B || C) != D'\''
OK
$ test-expr '\''((A && b) || c) != d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ne)
$ diff-expr '\''((A && b) || c) != d'\'' '\''(A && b || c) != d'\''
OK
$ test-expr '\''((A && b) || c) != D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ne)
$ diff-expr '\''((A && b) || c) != D'\'' '\''(A && b || c) != D'\''
OK
$ test-expr '\''((A && b) || C) != d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A && b) || C) != d'\'' '\''(A && b || C) != d'\''
OK
$ test-expr '\''((A && b) || C) != D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A && b) || C) != D'\'' '\''(A && b || C) != D'\''
OK
$ test-expr '\''((A && B) || c) != d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A && B) || c) != d'\'' '\''(A && B || c) != d'\''
OK
$ test-expr '\''((A && B) || c) != D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A && B) || c) != D'\'' '\''(A && B || c) != D'\''
OK
$ test-expr '\''((A && B) || C) != d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A && B) || C) != d'\'' '\''(A && B || C) != d'\''
OK
$ test-expr '\''((A && B) || C) != D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A && B) || C) != D'\'' '\''(A && B || C) != D'\''
OK
$ test-expr '\''a != ((b && c) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((b && c) >= d)'\'' '\''a != (b && c) >= d'\''
OK
$ test-expr '\''a != ((b && c) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((b && c) >= D)'\'' '\''a != (b && c) >= D'\''
OK
$ test-expr '\''a != ((b && C) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((b && C) >= d)'\'' '\''a != (b && C) >= d'\''
OK
$ test-expr '\''a != ((b && C) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((b && C) >= D)'\'' '\''a != (b && C) >= D'\''
OK
$ test-expr '\''a != ((B && c) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((B && c) >= d)'\'' '\''a != (B && c) >= d'\''
OK
$ test-expr '\''a != ((B && c) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((B && c) >= D)'\'' '\''a != (B && c) >= D'\''
OK
$ test-expr '\''a != ((B && C) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((B && C) >= d)'\'' '\''a != (B && C) >= d'\''
OK
$ test-expr '\''a != ((B && C) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((B && C) >= D)'\'' '\''a != (B && C) >= D'\''
OK
$ test-expr '\''A != ((b && c) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((b && c) >= d)'\'' '\''A != (b && c) >= d'\''
OK
$ test-expr '\''A != ((b && c) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((b && c) >= D)'\'' '\''A != (b && c) >= D'\''
OK
$ test-expr '\''A != ((b && C) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((b && C) >= d)'\'' '\''A != (b && C) >= d'\''
OK
$ test-expr '\''A != ((b && C) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((b && C) >= D)'\'' '\''A != (b && C) >= D'\''
OK
$ test-expr '\''A != ((B && c) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((B && c) >= d)'\'' '\''A != (B && c) >= d'\''
OK
$ test-expr '\''A != ((B && c) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((B && c) >= D)'\'' '\''A != (B && c) >= D'\''
OK
$ test-expr '\''A != ((B && C) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((B && C) >= d)'\'' '\''A != (B && C) >= d'\''
OK
$ test-expr '\''A != ((B && C) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((B && C) >= D)'\'' '\''A != (B && C) >= D'\''
OK
$ test-expr '\''a != ((b || c) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((b || c) >= d)'\'' '\''a != (b || c) >= d'\''
OK
$ test-expr '\''a != ((b || c) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((b || c) >= D)'\'' '\''a != (b || c) >= D'\''
OK
$ test-expr '\''a != ((b || C) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((b || C) >= d)'\'' '\''a != (b || C) >= d'\''
OK
$ test-expr '\''a != ((b || C) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((b || C) >= D)'\'' '\''a != (b || C) >= D'\''
OK
$ test-expr '\''a != ((B || c) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((B || c) >= d)'\'' '\''a != (B || c) >= d'\''
OK
$ test-expr '\''a != ((B || c) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''a != ((B || c) >= D)'\'' '\''a != (B || c) >= D'\''
OK
$ test-expr '\''a != ((B || C) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((B || C) >= d)'\'' '\''a != (B || C) >= d'\''
OK
$ test-expr '\''a != ((B || C) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != ((B || C) >= D)'\'' '\''a != (B || C) >= D'\''
OK
$ test-expr '\''A != ((b || c) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((b || c) >= d)'\'' '\''A != (b || c) >= d'\''
OK
$ test-expr '\''A != ((b || c) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((b || c) >= D)'\'' '\''A != (b || c) >= D'\''
OK
$ test-expr '\''A != ((b || C) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((b || C) >= d)'\'' '\''A != (b || C) >= d'\''
OK
$ test-expr '\''A != ((b || C) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((b || C) >= D)'\'' '\''A != (b || C) >= D'\''
OK
$ test-expr '\''A != ((B || c) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((B || c) >= d)'\'' '\''A != (B || c) >= d'\''
OK
$ test-expr '\''A != ((B || c) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''A != ((B || c) >= D)'\'' '\''A != (B || c) >= D'\''
OK
$ test-expr '\''A != ((B || C) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((B || C) >= d)'\'' '\''A != (B || C) >= d'\''
OK
$ test-expr '\''A != ((B || C) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != ((B || C) >= D)'\'' '\''A != (B || C) >= D'\''
OK
$ test-expr '\''a && ((b || c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''a && ((b || c) >= d)'\'' '\''a && (b || c) >= d'\''
OK
$ test-expr '\''a && ((b || c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''a && ((b || c) >= D)'\'' '\''a && (b || c) >= D'\''
OK
$ test-expr '\''a && ((b || C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && ((b || C) >= d)'\'' '\''a && (b || C) >= d'\''
OK
$ test-expr '\''a && ((b || C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && ((b || C) >= D)'\'' '\''a && (b || C) >= D'\''
OK
$ test-expr '\''a && ((B || c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''a && ((B || c) >= d)'\'' '\''a && (B || c) >= d'\''
OK
$ test-expr '\''a && ((B || c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''a && ((B || c) >= D)'\'' '\''a && (B || c) >= D'\''
OK
$ test-expr '\''a && ((B || C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && ((B || C) >= d)'\'' '\''a && (B || C) >= d'\''
OK
$ test-expr '\''a && ((B || C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && ((B || C) >= D)'\'' '\''a && (B || C) >= D'\''
OK
$ test-expr '\''A && ((b || c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''A && ((b || c) >= d)'\'' '\''A && (b || c) >= d'\''
OK
$ test-expr '\''A && ((b || c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''A && ((b || c) >= D)'\'' '\''A && (b || c) >= D'\''
OK
$ test-expr '\''A && ((b || C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && ((b || C) >= d)'\'' '\''A && (b || C) >= d'\''
OK
$ test-expr '\''A && ((b || C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && ((b || C) >= D)'\'' '\''A && (b || C) >= D'\''
OK
$ test-expr '\''A && ((B || c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''A && ((B || c) >= d)'\'' '\''A && (B || c) >= d'\''
OK
$ test-expr '\''A && ((B || c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''A && ((B || c) >= D)'\'' '\''A && (B || c) >= D'\''
OK
$ test-expr '\''A && ((B || C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && ((B || C) >= d)'\'' '\''A && (B || C) >= d'\''
OK
$ test-expr '\''A && ((B || C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && ((B || C) >= D)'\'' '\''A && (B || C) >= D'\''
OK
$ test-expr '\''a && ((b || c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''a && ((b || c) != d)'\'' '\''a && (b || c) != d'\''
OK
$ test-expr '\''a && ((b || c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''a && ((b || c) != D)'\'' '\''a && (b || c) != D'\''
OK
$ test-expr '\''a && ((b || C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && ((b || C) != d)'\'' '\''a && (b || C) != d'\''
OK
$ test-expr '\''a && ((b || C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && ((b || C) != D)'\'' '\''a && (b || C) != D'\''
OK
$ test-expr '\''a && ((B || c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''a && ((B || c) != d)'\'' '\''a && (B || c) != d'\''
OK
$ test-expr '\''a && ((B || c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''a && ((B || c) != D)'\'' '\''a && (B || c) != D'\''
OK
$ test-expr '\''a && ((B || C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && ((B || C) != d)'\'' '\''a && (B || C) != d'\''
OK
$ test-expr '\''a && ((B || C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && ((B || C) != D)'\'' '\''a && (B || C) != D'\''
OK
$ test-expr '\''A && ((b || c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''A && ((b || c) != d)'\'' '\''A && (b || c) != d'\''
OK
$ test-expr '\''A && ((b || c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''A && ((b || c) != D)'\'' '\''A && (b || c) != D'\''
OK
$ test-expr '\''A && ((b || C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && ((b || C) != d)'\'' '\''A && (b || C) != d'\''
OK
$ test-expr '\''A && ((b || C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && ((b || C) != D)'\'' '\''A && (b || C) != D'\''
OK
$ test-expr '\''A && ((B || c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''A && ((B || c) != d)'\'' '\''A && (B || c) != d'\''
OK
$ test-expr '\''A && ((B || c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''A && ((B || c) != D)'\'' '\''A && (B || c) != D'\''
OK
$ test-expr '\''A && ((B || C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && ((B || C) != d)'\'' '\''A && (B || C) != d'\''
OK
$ test-expr '\''A && ((B || C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && ((B || C) != D)'\'' '\''A && (B || C) != D'\''
OK
$ test-expr '\''(a != (b && c)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(a != (b && c)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a != (b && C)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(a != (b && C)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != (B && c)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(a != (B && c)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a != (B && C)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(a != (B && C)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != (b && c)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(A != (b && c)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A != (b && C)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(A != (b && C)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != (B && c)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(A != (B && c)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A != (B && C)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(A != (B && C)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != (b || c)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(a != (b || c)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a != (b || C)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(a != (b || C)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a != (B || c)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(a != (B || c)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a != (B || C)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(a != (B || C)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != (b || c)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(A != (b || c)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A != (b || C)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(A != (b || C)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A != (B || c)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(A != (B || c)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A != (B || C)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(A != (B || C)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a && (b || c)) >= d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(a && (b || c)) >= D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a && (b || C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(a && (b || C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a && (B || c)) >= d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(a && (B || c)) >= D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a && (B || C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(a && (B || C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A && (b || c)) >= d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(A && (b || c)) >= D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A && (b || C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(A && (b || C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A && (B || c)) >= d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''(A && (B || c)) >= D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A && (B || C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''(A && (B || C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a && (b || c)) != d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''(a && (b || c)) != D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(a && (b || C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ test-expr '\''(a && (b || C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(a && (B || c)) != d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''(a && (B || c)) != D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(a && (B || C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ test-expr '\''(a && (B || C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(A && (b || c)) != d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''(A && (b || c)) != D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(A && (b || C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ test-expr '\''(A && (b || C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(A && (B || c)) != d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''(A && (B || c)) != D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(A && (B || C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ test-expr '\''(A && (B || C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(a != b) && (c >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != b) && (c >= d)'\'' '\''a != b && (c >= d)'\''
OK
$ diff-expr '\''(a != b) && (c >= d)'\'' '\''a != b && c >= d'\''
OK
$ diff-expr '\''(a != b) && (c >= d)'\'' '\''(a != b) && c >= d'\''
OK
$ test-expr '\''(a != b) && (c >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != b) && (c >= D)'\'' '\''a != b && (c >= D)'\''
OK
$ diff-expr '\''(a != b) && (c >= D)'\'' '\''a != b && c >= D'\''
OK
$ diff-expr '\''(a != b) && (c >= D)'\'' '\''(a != b) && c >= D'\''
OK
$ test-expr '\''(a != b) && (C >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != b) && (C >= d)'\'' '\''a != b && (C >= d)'\''
OK
$ diff-expr '\''(a != b) && (C >= d)'\'' '\''a != b && C >= d'\''
OK
$ diff-expr '\''(a != b) && (C >= d)'\'' '\''(a != b) && C >= d'\''
OK
$ test-expr '\''(a != b) && (C >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != b) && (C >= D)'\'' '\''a != b && (C >= D)'\''
OK
$ diff-expr '\''(a != b) && (C >= D)'\'' '\''a != b && C >= D'\''
OK
$ diff-expr '\''(a != b) && (C >= D)'\'' '\''(a != b) && C >= D'\''
OK
$ test-expr '\''(a != B) && (c >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != B) && (c >= d)'\'' '\''a != B && (c >= d)'\''
OK
$ diff-expr '\''(a != B) && (c >= d)'\'' '\''a != B && c >= d'\''
OK
$ diff-expr '\''(a != B) && (c >= d)'\'' '\''(a != B) && c >= d'\''
OK
$ test-expr '\''(a != B) && (c >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != B) && (c >= D)'\'' '\''a != B && (c >= D)'\''
OK
$ diff-expr '\''(a != B) && (c >= D)'\'' '\''a != B && c >= D'\''
OK
$ diff-expr '\''(a != B) && (c >= D)'\'' '\''(a != B) && c >= D'\''
OK
$ test-expr '\''(a != B) && (C >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != B) && (C >= d)'\'' '\''a != B && (C >= d)'\''
OK
$ diff-expr '\''(a != B) && (C >= d)'\'' '\''a != B && C >= d'\''
OK
$ diff-expr '\''(a != B) && (C >= d)'\'' '\''(a != B) && C >= d'\''
OK
$ test-expr '\''(a != B) && (C >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != B) && (C >= D)'\'' '\''a != B && (C >= D)'\''
OK
$ diff-expr '\''(a != B) && (C >= D)'\'' '\''a != B && C >= D'\''
OK
$ diff-expr '\''(a != B) && (C >= D)'\'' '\''(a != B) && C >= D'\''
OK
$ test-expr '\''(A != b) && (c >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != b) && (c >= d)'\'' '\''A != b && (c >= d)'\''
OK
$ diff-expr '\''(A != b) && (c >= d)'\'' '\''A != b && c >= d'\''
OK
$ diff-expr '\''(A != b) && (c >= d)'\'' '\''(A != b) && c >= d'\''
OK
$ test-expr '\''(A != b) && (c >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != b) && (c >= D)'\'' '\''A != b && (c >= D)'\''
OK
$ diff-expr '\''(A != b) && (c >= D)'\'' '\''A != b && c >= D'\''
OK
$ diff-expr '\''(A != b) && (c >= D)'\'' '\''(A != b) && c >= D'\''
OK
$ test-expr '\''(A != b) && (C >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != b) && (C >= d)'\'' '\''A != b && (C >= d)'\''
OK
$ diff-expr '\''(A != b) && (C >= d)'\'' '\''A != b && C >= d'\''
OK
$ diff-expr '\''(A != b) && (C >= d)'\'' '\''(A != b) && C >= d'\''
OK
$ test-expr '\''(A != b) && (C >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != b) && (C >= D)'\'' '\''A != b && (C >= D)'\''
OK
$ diff-expr '\''(A != b) && (C >= D)'\'' '\''A != b && C >= D'\''
OK
$ diff-expr '\''(A != b) && (C >= D)'\'' '\''(A != b) && C >= D'\''
OK
$ test-expr '\''(A != B) && (c >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != B) && (c >= d)'\'' '\''A != B && (c >= d)'\''
OK
$ diff-expr '\''(A != B) && (c >= d)'\'' '\''A != B && c >= d'\''
OK
$ diff-expr '\''(A != B) && (c >= d)'\'' '\''(A != B) && c >= d'\''
OK
$ test-expr '\''(A != B) && (c >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != B) && (c >= D)'\'' '\''A != B && (c >= D)'\''
OK
$ diff-expr '\''(A != B) && (c >= D)'\'' '\''A != B && c >= D'\''
OK
$ diff-expr '\''(A != B) && (c >= D)'\'' '\''(A != B) && c >= D'\''
OK
$ test-expr '\''(A != B) && (C >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != B) && (C >= d)'\'' '\''A != B && (C >= d)'\''
OK
$ diff-expr '\''(A != B) && (C >= d)'\'' '\''A != B && C >= d'\''
OK
$ diff-expr '\''(A != B) && (C >= d)'\'' '\''(A != B) && C >= d'\''
OK
$ test-expr '\''(A != B) && (C >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != B) && (C >= D)'\'' '\''A != B && (C >= D)'\''
OK
$ diff-expr '\''(A != B) && (C >= D)'\'' '\''A != B && C >= D'\''
OK
$ diff-expr '\''(A != B) && (C >= D)'\'' '\''(A != B) && C >= D'\''
OK
$ test-expr '\''(a != b) || (c >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != b) || (c >= d)'\'' '\''a != b || (c >= d)'\''
OK
$ diff-expr '\''(a != b) || (c >= d)'\'' '\''a != b || c >= d'\''
OK
$ diff-expr '\''(a != b) || (c >= d)'\'' '\''(a != b) || c >= d'\''
OK
$ test-expr '\''(a != b) || (c >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != b) || (c >= D)'\'' '\''a != b || (c >= D)'\''
OK
$ diff-expr '\''(a != b) || (c >= D)'\'' '\''a != b || c >= D'\''
OK
$ diff-expr '\''(a != b) || (c >= D)'\'' '\''(a != b) || c >= D'\''
OK
$ test-expr '\''(a != b) || (C >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != b) || (C >= d)'\'' '\''a != b || (C >= d)'\''
OK
$ diff-expr '\''(a != b) || (C >= d)'\'' '\''a != b || C >= d'\''
OK
$ diff-expr '\''(a != b) || (C >= d)'\'' '\''(a != b) || C >= d'\''
OK
$ test-expr '\''(a != b) || (C >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != b) || (C >= D)'\'' '\''a != b || (C >= D)'\''
OK
$ diff-expr '\''(a != b) || (C >= D)'\'' '\''a != b || C >= D'\''
OK
$ diff-expr '\''(a != b) || (C >= D)'\'' '\''(a != b) || C >= D'\''
OK
$ test-expr '\''(a != B) || (c >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != B) || (c >= d)'\'' '\''a != B || (c >= d)'\''
OK
$ diff-expr '\''(a != B) || (c >= d)'\'' '\''a != B || c >= d'\''
OK
$ diff-expr '\''(a != B) || (c >= d)'\'' '\''(a != B) || c >= d'\''
OK
$ test-expr '\''(a != B) || (c >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != B) || (c >= D)'\'' '\''a != B || (c >= D)'\''
OK
$ diff-expr '\''(a != B) || (c >= D)'\'' '\''a != B || c >= D'\''
OK
$ diff-expr '\''(a != B) || (c >= D)'\'' '\''(a != B) || c >= D'\''
OK
$ test-expr '\''(a != B) || (C >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a != B) || (C >= d)'\'' '\''a != B || (C >= d)'\''
OK
$ diff-expr '\''(a != B) || (C >= d)'\'' '\''a != B || C >= d'\''
OK
$ diff-expr '\''(a != B) || (C >= d)'\'' '\''(a != B) || C >= d'\''
OK
$ test-expr '\''(a != B) || (C >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a != B) || (C >= D)'\'' '\''a != B || (C >= D)'\''
OK
$ diff-expr '\''(a != B) || (C >= D)'\'' '\''a != B || C >= D'\''
OK
$ diff-expr '\''(a != B) || (C >= D)'\'' '\''(a != B) || C >= D'\''
OK
$ test-expr '\''(A != b) || (c >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != b) || (c >= d)'\'' '\''A != b || (c >= d)'\''
OK
$ diff-expr '\''(A != b) || (c >= d)'\'' '\''A != b || c >= d'\''
OK
$ diff-expr '\''(A != b) || (c >= d)'\'' '\''(A != b) || c >= d'\''
OK
$ test-expr '\''(A != b) || (c >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != b) || (c >= D)'\'' '\''A != b || (c >= D)'\''
OK
$ diff-expr '\''(A != b) || (c >= D)'\'' '\''A != b || c >= D'\''
OK
$ diff-expr '\''(A != b) || (c >= D)'\'' '\''(A != b) || c >= D'\''
OK
$ test-expr '\''(A != b) || (C >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != b) || (C >= d)'\'' '\''A != b || (C >= d)'\''
OK
$ diff-expr '\''(A != b) || (C >= d)'\'' '\''A != b || C >= d'\''
OK
$ diff-expr '\''(A != b) || (C >= d)'\'' '\''(A != b) || C >= d'\''
OK
$ test-expr '\''(A != b) || (C >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != b) || (C >= D)'\'' '\''A != b || (C >= D)'\''
OK
$ diff-expr '\''(A != b) || (C >= D)'\'' '\''A != b || C >= D'\''
OK
$ diff-expr '\''(A != b) || (C >= D)'\'' '\''(A != b) || C >= D'\''
OK
$ test-expr '\''(A != B) || (c >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != B) || (c >= d)'\'' '\''A != B || (c >= d)'\''
OK
$ diff-expr '\''(A != B) || (c >= d)'\'' '\''A != B || c >= d'\''
OK
$ diff-expr '\''(A != B) || (c >= d)'\'' '\''(A != B) || c >= d'\''
OK
$ test-expr '\''(A != B) || (c >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != B) || (c >= D)'\'' '\''A != B || (c >= D)'\''
OK
$ diff-expr '\''(A != B) || (c >= D)'\'' '\''A != B || c >= D'\''
OK
$ diff-expr '\''(A != B) || (c >= D)'\'' '\''(A != B) || c >= D'\''
OK
$ test-expr '\''(A != B) || (C >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A != B) || (C >= d)'\'' '\''A != B || (C >= d)'\''
OK
$ diff-expr '\''(A != B) || (C >= d)'\'' '\''A != B || C >= d'\''
OK
$ diff-expr '\''(A != B) || (C >= d)'\'' '\''(A != B) || C >= d'\''
OK
$ test-expr '\''(A != B) || (C >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A != B) || (C >= D)'\'' '\''A != B || (C >= D)'\''
OK
$ diff-expr '\''(A != B) || (C >= D)'\'' '\''A != B || C >= D'\''
OK
$ diff-expr '\''(A != B) || (C >= D)'\'' '\''(A != B) || C >= D'\''
OK
$ test-expr '\''(a && b) || (c >= d)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(a && b) || (c >= d)'\'' '\''a && b || (c >= d)'\''
OK
$ diff-expr '\''(a && b) || (c >= d)'\'' '\''a && b || c >= d'\''
OK
$ diff-expr '\''(a && b) || (c >= d)'\'' '\''(a && b) || c >= d'\''
OK
$ test-expr '\''(a && b) || (c >= D)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(a && b) || (c >= D)'\'' '\''a && b || (c >= D)'\''
OK
$ diff-expr '\''(a && b) || (c >= D)'\'' '\''a && b || c >= D'\''
OK
$ diff-expr '\''(a && b) || (c >= D)'\'' '\''(a && b) || c >= D'\''
OK
$ test-expr '\''(a && b) || (C >= d)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(a && b) || (C >= d)'\'' '\''a && b || (C >= d)'\''
OK
$ diff-expr '\''(a && b) || (C >= d)'\'' '\''a && b || C >= d'\''
OK
$ diff-expr '\''(a && b) || (C >= d)'\'' '\''(a && b) || C >= d'\''
OK
$ test-expr '\''(a && b) || (C >= D)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(a && b) || (C >= D)'\'' '\''a && b || (C >= D)'\''
OK
$ diff-expr '\''(a && b) || (C >= D)'\'' '\''a && b || C >= D'\''
OK
$ diff-expr '\''(a && b) || (C >= D)'\'' '\''(a && b) || C >= D'\''
OK
$ test-expr '\''(a && B) || (c >= d)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a && B) || (c >= d)'\'' '\''a && B || (c >= d)'\''
OK
$ diff-expr '\''(a && B) || (c >= d)'\'' '\''a && B || c >= d'\''
OK
$ diff-expr '\''(a && B) || (c >= d)'\'' '\''(a && B) || c >= d'\''
OK
$ test-expr '\''(a && B) || (c >= D)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a && B) || (c >= D)'\'' '\''a && B || (c >= D)'\''
OK
$ diff-expr '\''(a && B) || (c >= D)'\'' '\''a && B || c >= D'\''
OK
$ diff-expr '\''(a && B) || (c >= D)'\'' '\''(a && B) || c >= D'\''
OK
$ test-expr '\''(a && B) || (C >= d)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a && B) || (C >= d)'\'' '\''a && B || (C >= d)'\''
OK
$ diff-expr '\''(a && B) || (C >= d)'\'' '\''a && B || C >= d'\''
OK
$ diff-expr '\''(a && B) || (C >= d)'\'' '\''(a && B) || C >= d'\''
OK
$ test-expr '\''(a && B) || (C >= D)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a && B) || (C >= D)'\'' '\''a && B || (C >= D)'\''
OK
$ diff-expr '\''(a && B) || (C >= D)'\'' '\''a && B || C >= D'\''
OK
$ diff-expr '\''(a && B) || (C >= D)'\'' '\''(a && B) || C >= D'\''
OK
$ test-expr '\''(A && b) || (c >= d)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(A && b) || (c >= d)'\'' '\''A && b || (c >= d)'\''
OK
$ diff-expr '\''(A && b) || (c >= d)'\'' '\''A && b || c >= d'\''
OK
$ diff-expr '\''(A && b) || (c >= d)'\'' '\''(A && b) || c >= d'\''
OK
$ test-expr '\''(A && b) || (c >= D)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(A && b) || (c >= D)'\'' '\''A && b || (c >= D)'\''
OK
$ diff-expr '\''(A && b) || (c >= D)'\'' '\''A && b || c >= D'\''
OK
$ diff-expr '\''(A && b) || (c >= D)'\'' '\''(A && b) || c >= D'\''
OK
$ test-expr '\''(A && b) || (C >= d)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(A && b) || (C >= d)'\'' '\''A && b || (C >= d)'\''
OK
$ diff-expr '\''(A && b) || (C >= d)'\'' '\''A && b || C >= d'\''
OK
$ diff-expr '\''(A && b) || (C >= d)'\'' '\''(A && b) || C >= d'\''
OK
$ test-expr '\''(A && b) || (C >= D)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(A && b) || (C >= D)'\'' '\''A && b || (C >= D)'\''
OK
$ diff-expr '\''(A && b) || (C >= D)'\'' '\''A && b || C >= D'\''
OK
$ diff-expr '\''(A && b) || (C >= D)'\'' '\''(A && b) || C >= D'\''
OK
$ test-expr '\''(A && B) || (c >= d)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A && B) || (c >= d)'\'' '\''A && B || (c >= d)'\''
OK
$ diff-expr '\''(A && B) || (c >= d)'\'' '\''A && B || c >= d'\''
OK
$ diff-expr '\''(A && B) || (c >= d)'\'' '\''(A && B) || c >= d'\''
OK
$ test-expr '\''(A && B) || (c >= D)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A && B) || (c >= D)'\'' '\''A && B || (c >= D)'\''
OK
$ diff-expr '\''(A && B) || (c >= D)'\'' '\''A && B || c >= D'\''
OK
$ diff-expr '\''(A && B) || (c >= D)'\'' '\''(A && B) || c >= D'\''
OK
$ test-expr '\''(A && B) || (C >= d)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A && B) || (C >= d)'\'' '\''A && B || (C >= d)'\''
OK
$ diff-expr '\''(A && B) || (C >= d)'\'' '\''A && B || C >= d'\''
OK
$ diff-expr '\''(A && B) || (C >= d)'\'' '\''(A && B) || C >= d'\''
OK
$ test-expr '\''(A && B) || (C >= D)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A && B) || (C >= D)'\'' '\''A && B || (C >= D)'\''
OK
$ diff-expr '\''(A && B) || (C >= D)'\'' '\''A && B || C >= D'\''
OK
$ diff-expr '\''(A && B) || (C >= D)'\'' '\''(A && B) || C >= D'\''
OK
$ test-expr '\''(a && b) || (c != d)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a && b) || (c != d)'\'' '\''a && b || (c != d)'\''
OK
$ diff-expr '\''(a && b) || (c != d)'\'' '\''a && b || c != d'\''
OK
$ diff-expr '\''(a && b) || (c != d)'\'' '\''(a && b) || c != d'\''
OK
$ test-expr '\''(a && b) || (c != D)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a && b) || (c != D)'\'' '\''a && b || (c != D)'\''
OK
$ diff-expr '\''(a && b) || (c != D)'\'' '\''a && b || c != D'\''
OK
$ diff-expr '\''(a && b) || (c != D)'\'' '\''(a && b) || c != D'\''
OK
$ test-expr '\''(a && b) || (C != d)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a && b) || (C != d)'\'' '\''a && b || (C != d)'\''
OK
$ diff-expr '\''(a && b) || (C != d)'\'' '\''a && b || C != d'\''
OK
$ diff-expr '\''(a && b) || (C != d)'\'' '\''(a && b) || C != d'\''
OK
$ test-expr '\''(a && b) || (C != D)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a && b) || (C != D)'\'' '\''a && b || (C != D)'\''
OK
$ diff-expr '\''(a && b) || (C != D)'\'' '\''a && b || C != D'\''
OK
$ diff-expr '\''(a && b) || (C != D)'\'' '\''(a && b) || C != D'\''
OK
$ test-expr '\''(a && B) || (c != d)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a && B) || (c != d)'\'' '\''a && B || (c != d)'\''
OK
$ diff-expr '\''(a && B) || (c != d)'\'' '\''a && B || c != d'\''
OK
$ diff-expr '\''(a && B) || (c != d)'\'' '\''(a && B) || c != d'\''
OK
$ test-expr '\''(a && B) || (c != D)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a && B) || (c != D)'\'' '\''a && B || (c != D)'\''
OK
$ diff-expr '\''(a && B) || (c != D)'\'' '\''a && B || c != D'\''
OK
$ diff-expr '\''(a && B) || (c != D)'\'' '\''(a && B) || c != D'\''
OK
$ test-expr '\''(a && B) || (C != d)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a && B) || (C != d)'\'' '\''a && B || (C != d)'\''
OK
$ diff-expr '\''(a && B) || (C != d)'\'' '\''a && B || C != d'\''
OK
$ diff-expr '\''(a && B) || (C != d)'\'' '\''(a && B) || C != d'\''
OK
$ test-expr '\''(a && B) || (C != D)'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a && B) || (C != D)'\'' '\''a && B || (C != D)'\''
OK
$ diff-expr '\''(a && B) || (C != D)'\'' '\''a && B || C != D'\''
OK
$ diff-expr '\''(a && B) || (C != D)'\'' '\''(a && B) || C != D'\''
OK
$ test-expr '\''(A && b) || (c != d)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A && b) || (c != d)'\'' '\''A && b || (c != d)'\''
OK
$ diff-expr '\''(A && b) || (c != d)'\'' '\''A && b || c != d'\''
OK
$ diff-expr '\''(A && b) || (c != d)'\'' '\''(A && b) || c != d'\''
OK
$ test-expr '\''(A && b) || (c != D)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A && b) || (c != D)'\'' '\''A && b || (c != D)'\''
OK
$ diff-expr '\''(A && b) || (c != D)'\'' '\''A && b || c != D'\''
OK
$ diff-expr '\''(A && b) || (c != D)'\'' '\''(A && b) || c != D'\''
OK
$ test-expr '\''(A && b) || (C != d)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A && b) || (C != d)'\'' '\''A && b || (C != d)'\''
OK
$ diff-expr '\''(A && b) || (C != d)'\'' '\''A && b || C != d'\''
OK
$ diff-expr '\''(A && b) || (C != d)'\'' '\''(A && b) || C != d'\''
OK
$ test-expr '\''(A && b) || (C != D)'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A && b) || (C != D)'\'' '\''A && b || (C != D)'\''
OK
$ diff-expr '\''(A && b) || (C != D)'\'' '\''A && b || C != D'\''
OK
$ diff-expr '\''(A && b) || (C != D)'\'' '\''(A && b) || C != D'\''
OK
$ test-expr '\''(A && B) || (c != d)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A && B) || (c != d)'\'' '\''A && B || (c != d)'\''
OK
$ diff-expr '\''(A && B) || (c != d)'\'' '\''A && B || c != d'\''
OK
$ diff-expr '\''(A && B) || (c != d)'\'' '\''(A && B) || c != d'\''
OK
$ test-expr '\''(A && B) || (c != D)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A && B) || (c != D)'\'' '\''A && B || (c != D)'\''
OK
$ diff-expr '\''(A && B) || (c != D)'\'' '\''A && B || c != D'\''
OK
$ diff-expr '\''(A && B) || (c != D)'\'' '\''(A && B) || c != D'\''
OK
$ test-expr '\''(A && B) || (C != d)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A && B) || (C != d)'\'' '\''A && B || (C != d)'\''
OK
$ diff-expr '\''(A && B) || (C != d)'\'' '\''A && B || C != d'\''
OK
$ diff-expr '\''(A && B) || (C != d)'\'' '\''(A && B) || C != d'\''
OK
$ test-expr '\''(A && B) || (C != D)'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A && B) || (C != D)'\'' '\''A && B || (C != D)'\''
OK
$ diff-expr '\''(A && B) || (C != D)'\'' '\''A && B || C != D'\''
OK
$ diff-expr '\''(A && B) || (C != D)'\'' '\''(A && B) || C != D'\''
OK
$ test-expr '\''a != (b && (c >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b && (c >= d))'\'' '\''a != (b && c >= d)'\''
OK
$ test-expr '\''a != (b && (c >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b && (c >= D))'\'' '\''a != (b && c >= D)'\''
OK
$ test-expr '\''a != (b && (C >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b && (C >= d))'\'' '\''a != (b && C >= d)'\''
OK
$ test-expr '\''a != (b && (C >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b && (C >= D))'\'' '\''a != (b && C >= D)'\''
OK
$ test-expr '\''a != (B && (c >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B && (c >= d))'\'' '\''a != (B && c >= d)'\''
OK
$ test-expr '\''a != (B && (c >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B && (c >= D))'\'' '\''a != (B && c >= D)'\''
OK
$ test-expr '\''a != (B && (C >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B && (C >= d))'\'' '\''a != (B && C >= d)'\''
OK
$ test-expr '\''a != (B && (C >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B && (C >= D))'\'' '\''a != (B && C >= D)'\''
OK
$ test-expr '\''A != (b && (c >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b && (c >= d))'\'' '\''A != (b && c >= d)'\''
OK
$ test-expr '\''A != (b && (c >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b && (c >= D))'\'' '\''A != (b && c >= D)'\''
OK
$ test-expr '\''A != (b && (C >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b && (C >= d))'\'' '\''A != (b && C >= d)'\''
OK
$ test-expr '\''A != (b && (C >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b && (C >= D))'\'' '\''A != (b && C >= D)'\''
OK
$ test-expr '\''A != (B && (c >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B && (c >= d))'\'' '\''A != (B && c >= d)'\''
OK
$ test-expr '\''A != (B && (c >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B && (c >= D))'\'' '\''A != (B && c >= D)'\''
OK
$ test-expr '\''A != (B && (C >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B && (C >= d))'\'' '\''A != (B && C >= d)'\''
OK
$ test-expr '\''A != (B && (C >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B && (C >= D))'\'' '\''A != (B && C >= D)'\''
OK
$ test-expr '\''a != (b || (c >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b || (c >= d))'\'' '\''a != (b || c >= d)'\''
OK
$ test-expr '\''a != (b || (c >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b || (c >= D))'\'' '\''a != (b || c >= D)'\''
OK
$ test-expr '\''a != (b || (C >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b || (C >= d))'\'' '\''a != (b || C >= d)'\''
OK
$ test-expr '\''a != (b || (C >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (b || (C >= D))'\'' '\''a != (b || C >= D)'\''
OK
$ test-expr '\''a != (B || (c >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B || (c >= d))'\'' '\''a != (B || c >= d)'\''
OK
$ test-expr '\''a != (B || (c >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B || (c >= D))'\'' '\''a != (B || c >= D)'\''
OK
$ test-expr '\''a != (B || (C >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B || (C >= d))'\'' '\''a != (B || C >= d)'\''
OK
$ test-expr '\''a != (B || (C >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a != (B || (C >= D))'\'' '\''a != (B || C >= D)'\''
OK
$ test-expr '\''A != (b || (c >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b || (c >= d))'\'' '\''A != (b || c >= d)'\''
OK
$ test-expr '\''A != (b || (c >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b || (c >= D))'\'' '\''A != (b || c >= D)'\''
OK
$ test-expr '\''A != (b || (C >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b || (C >= d))'\'' '\''A != (b || C >= d)'\''
OK
$ test-expr '\''A != (b || (C >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (b || (C >= D))'\'' '\''A != (b || C >= D)'\''
OK
$ test-expr '\''A != (B || (c >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B || (c >= d))'\'' '\''A != (B || c >= d)'\''
OK
$ test-expr '\''A != (B || (c >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B || (c >= D))'\'' '\''A != (B || c >= D)'\''
OK
$ test-expr '\''A != (B || (C >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B || (C >= d))'\'' '\''A != (B || C >= d)'\''
OK
$ test-expr '\''A != (B || (C >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A != (B || (C >= D))'\'' '\''A != (B || C >= D)'\''
OK
$ test-expr '\''a && (b || (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && (b || (c >= d))'\'' '\''a && (b || c >= d)'\''
OK
$ test-expr '\''a && (b || (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (b || (c >= D))'\'' '\''a && (b || c >= D)'\''
OK
$ test-expr '\''a && (b || (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && (b || (C >= d))'\'' '\''a && (b || C >= d)'\''
OK
$ test-expr '\''a && (b || (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (b || (C >= D))'\'' '\''a && (b || C >= D)'\''
OK
$ test-expr '\''a && (B || (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && (B || (c >= d))'\'' '\''a && (B || c >= d)'\''
OK
$ test-expr '\''a && (B || (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (B || (c >= D))'\'' '\''a && (B || c >= D)'\''
OK
$ test-expr '\''a && (B || (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && (B || (C >= d))'\'' '\''a && (B || C >= d)'\''
OK
$ test-expr '\''a && (B || (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && (B || (C >= D))'\'' '\''a && (B || C >= D)'\''
OK
$ test-expr '\''A && (b || (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && (b || (c >= d))'\'' '\''A && (b || c >= d)'\''
OK
$ test-expr '\''A && (b || (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (b || (c >= D))'\'' '\''A && (b || c >= D)'\''
OK
$ test-expr '\''A && (b || (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && (b || (C >= d))'\'' '\''A && (b || C >= d)'\''
OK
$ test-expr '\''A && (b || (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (b || (C >= D))'\'' '\''A && (b || C >= D)'\''
OK
$ test-expr '\''A && (B || (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && (B || (c >= d))'\'' '\''A && (B || c >= d)'\''
OK
$ test-expr '\''A && (B || (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (B || (c >= D))'\'' '\''A && (B || c >= D)'\''
OK
$ test-expr '\''A && (B || (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && (B || (C >= d))'\'' '\''A && (B || C >= d)'\''
OK
$ test-expr '\''A && (B || (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && (B || (C >= D))'\'' '\''A && (B || C >= D)'\''
OK
$ test-expr '\''a && (b || (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && (b || (c != d))'\'' '\''a && (b || c != d)'\''
OK
$ test-expr '\''a && (b || (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (b || (c != D))'\'' '\''a && (b || c != D)'\''
OK
$ test-expr '\''a && (b || (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && (b || (C != d))'\'' '\''a && (b || C != d)'\''
OK
$ test-expr '\''a && (b || (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (b || (C != D))'\'' '\''a && (b || C != D)'\''
OK
$ test-expr '\''a && (B || (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && (B || (c != d))'\'' '\''a && (B || c != d)'\''
OK
$ test-expr '\''a && (B || (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (B || (c != D))'\'' '\''a && (B || c != D)'\''
OK
$ test-expr '\''a && (B || (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && (B || (C != d))'\'' '\''a && (B || C != d)'\''
OK
$ test-expr '\''a && (B || (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && (B || (C != D))'\'' '\''a && (B || C != D)'\''
OK
$ test-expr '\''A && (b || (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && (b || (c != d))'\'' '\''A && (b || c != d)'\''
OK
$ test-expr '\''A && (b || (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (b || (c != D))'\'' '\''A && (b || c != D)'\''
OK
$ test-expr '\''A && (b || (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && (b || (C != d))'\'' '\''A && (b || C != d)'\''
OK
$ test-expr '\''A && (b || (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (b || (C != D))'\'' '\''A && (b || C != D)'\''
OK
$ test-expr '\''A && (B || (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && (B || (c != d))'\'' '\''A && (B || c != d)'\''
OK
$ test-expr '\''A && (B || (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (B || (c != D))'\'' '\''A && (B || c != D)'\''
OK
$ test-expr '\''A && (B || (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && (B || (C != d))'\'' '\''A && (B || C != d)'\''
OK
$ test-expr '\''A && (B || (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && (B || (C != D))'\'' '\''A && (B || C != D)'\''
OK
$ test-expr '\''((a && b) >= c) != d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a && b) >= c) != d'\'' '\''(a && b) >= c != d'\''
OK
$ test-expr '\''((a && b) >= c) != D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a && b) >= c) != D'\'' '\''(a && b) >= c != D'\''
OK
$ test-expr '\''((a && b) >= C) != d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a && b) >= C) != d'\'' '\''(a && b) >= C != d'\''
OK
$ test-expr '\''((a && b) >= C) != D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a && b) >= C) != D'\'' '\''(a && b) >= C != D'\''
OK
$ test-expr '\''((a && B) >= c) != d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a && B) >= c) != d'\'' '\''(a && B) >= c != d'\''
OK
$ test-expr '\''((a && B) >= c) != D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a && B) >= c) != D'\'' '\''(a && B) >= c != D'\''
OK
$ test-expr '\''((a && B) >= C) != d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a && B) >= C) != d'\'' '\''(a && B) >= C != d'\''
OK
$ test-expr '\''((a && B) >= C) != D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a && B) >= C) != D'\'' '\''(a && B) >= C != D'\''
OK
$ test-expr '\''((A && b) >= c) != d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A && b) >= c) != d'\'' '\''(A && b) >= c != d'\''
OK
$ test-expr '\''((A && b) >= c) != D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A && b) >= c) != D'\'' '\''(A && b) >= c != D'\''
OK
$ test-expr '\''((A && b) >= C) != d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A && b) >= C) != d'\'' '\''(A && b) >= C != d'\''
OK
$ test-expr '\''((A && b) >= C) != D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A && b) >= C) != D'\'' '\''(A && b) >= C != D'\''
OK
$ test-expr '\''((A && B) >= c) != d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A && B) >= c) != d'\'' '\''(A && B) >= c != d'\''
OK
$ test-expr '\''((A && B) >= c) != D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A && B) >= c) != D'\'' '\''(A && B) >= c != D'\''
OK
$ test-expr '\''((A && B) >= C) != d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A && B) >= C) != d'\'' '\''(A && B) >= C != d'\''
OK
$ test-expr '\''((A && B) >= C) != D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A && B) >= C) != D'\'' '\''(A && B) >= C != D'\''
OK
$ test-expr '\''((a || b) >= c) != d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a || b) >= c) != d'\'' '\''(a || b) >= c != d'\''
OK
$ test-expr '\''((a || b) >= c) != D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a || b) >= c) != D'\'' '\''(a || b) >= c != D'\''
OK
$ test-expr '\''((a || b) >= C) != d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((a || b) >= C) != d'\'' '\''(a || b) >= C != d'\''
OK
$ test-expr '\''((a || b) >= C) != D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((a || b) >= C) != D'\'' '\''(a || b) >= C != D'\''
OK
$ test-expr '\''((a || B) >= c) != d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a || B) >= c) != d'\'' '\''(a || B) >= c != d'\''
OK
$ test-expr '\''((a || B) >= c) != D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a || B) >= c) != D'\'' '\''(a || B) >= c != D'\''
OK
$ test-expr '\''((a || B) >= C) != d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((a || B) >= C) != d'\'' '\''(a || B) >= C != d'\''
OK
$ test-expr '\''((a || B) >= C) != D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((a || B) >= C) != D'\'' '\''(a || B) >= C != D'\''
OK
$ test-expr '\''((A || b) >= c) != d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A || b) >= c) != d'\'' '\''(A || b) >= c != d'\''
OK
$ test-expr '\''((A || b) >= c) != D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A || b) >= c) != D'\'' '\''(A || b) >= c != D'\''
OK
$ test-expr '\''((A || b) >= C) != d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''((A || b) >= C) != d'\'' '\''(A || b) >= C != d'\''
OK
$ test-expr '\''((A || b) >= C) != D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''((A || b) >= C) != D'\'' '\''(A || b) >= C != D'\''
OK
$ test-expr '\''((A || B) >= c) != d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A || B) >= c) != d'\'' '\''(A || B) >= c != d'\''
OK
$ test-expr '\''((A || B) >= c) != D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A || B) >= c) != D'\'' '\''(A || B) >= c != D'\''
OK
$ test-expr '\''((A || B) >= C) != d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''((A || B) >= C) != d'\'' '\''(A || B) >= C != d'\''
OK
$ test-expr '\''((A || B) >= C) != D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''((A || B) >= C) != D'\'' '\''(A || B) >= C != D'\''
OK
$ test-expr '\''((a || b) >= c) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a || b) >= c) && d'\'' '\''(a || b) >= c && d'\''
OK
$ test-expr '\''((a || b) >= c) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a || b) >= c) && D'\'' '\''(a || b) >= c && D'\''
OK
$ test-expr '\''((a || b) >= C) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a || b) >= C) && d'\'' '\''(a || b) >= C && d'\''
OK
$ test-expr '\''((a || b) >= C) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a || b) >= C) && D'\'' '\''(a || b) >= C && D'\''
OK
$ test-expr '\''((a || B) >= c) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a || B) >= c) && d'\'' '\''(a || B) >= c && d'\''
OK
$ test-expr '\''((a || B) >= c) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a || B) >= c) && D'\'' '\''(a || B) >= c && D'\''
OK
$ test-expr '\''((a || B) >= C) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a || B) >= C) && d'\'' '\''(a || B) >= C && d'\''
OK
$ test-expr '\''((a || B) >= C) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a || B) >= C) && D'\'' '\''(a || B) >= C && D'\''
OK
$ test-expr '\''((A || b) >= c) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A || b) >= c) && d'\'' '\''(A || b) >= c && d'\''
OK
$ test-expr '\''((A || b) >= c) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A || b) >= c) && D'\'' '\''(A || b) >= c && D'\''
OK
$ test-expr '\''((A || b) >= C) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A || b) >= C) && d'\'' '\''(A || b) >= C && d'\''
OK
$ test-expr '\''((A || b) >= C) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A || b) >= C) && D'\'' '\''(A || b) >= C && D'\''
OK
$ test-expr '\''((A || B) >= c) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A || B) >= c) && d'\'' '\''(A || B) >= c && d'\''
OK
$ test-expr '\''((A || B) >= c) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A || B) >= c) && D'\'' '\''(A || B) >= c && D'\''
OK
$ test-expr '\''((A || B) >= C) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A || B) >= C) && d'\'' '\''(A || B) >= C && d'\''
OK
$ test-expr '\''((A || B) >= C) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A || B) >= C) && D'\'' '\''(A || B) >= C && D'\''
OK
$ test-expr '\''((a || b) != c) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a || b) != c) && d'\'' '\''(a || b) != c && d'\''
OK
$ test-expr '\''((a || b) != c) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a || b) != c) && D'\'' '\''(a || b) != c && D'\''
OK
$ test-expr '\''((a || b) != C) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((a || b) != C) && d'\'' '\''(a || b) != C && d'\''
OK
$ test-expr '\''((a || b) != C) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((a || b) != C) && D'\'' '\''(a || b) != C && D'\''
OK
$ test-expr '\''((a || B) != c) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a || B) != c) && d'\'' '\''(a || B) != c && d'\''
OK
$ test-expr '\''((a || B) != c) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a || B) != c) && D'\'' '\''(a || B) != c && D'\''
OK
$ test-expr '\''((a || B) != C) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((a || B) != C) && d'\'' '\''(a || B) != C && d'\''
OK
$ test-expr '\''((a || B) != C) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((a || B) != C) && D'\'' '\''(a || B) != C && D'\''
OK
$ test-expr '\''((A || b) != c) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A || b) != c) && d'\'' '\''(A || b) != c && d'\''
OK
$ test-expr '\''((A || b) != c) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A || b) != c) && D'\'' '\''(A || b) != c && D'\''
OK
$ test-expr '\''((A || b) != C) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ diff-expr '\''((A || b) != C) && d'\'' '\''(A || b) != C && d'\''
OK
$ test-expr '\''((A || b) != C) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(D)
$ diff-expr '\''((A || b) != C) && D'\'' '\''(A || b) != C && D'\''
OK
$ test-expr '\''((A || B) != c) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A || B) != c) && d'\'' '\''(A || B) != c && d'\''
OK
$ test-expr '\''((A || B) != c) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A || B) != c) && D'\'' '\''(A || B) != c && D'\''
OK
$ test-expr '\''((A || B) != C) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''((A || B) != C) && d'\'' '\''(A || B) != C && d'\''
OK
$ test-expr '\''((A || B) != C) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''((A || B) != C) && D'\'' '\''(A || B) != C && D'\''
OK
$ test-expr '\''a && ((b >= c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && ((b >= c) != d)'\'' '\''a && (b >= c) != d'\''
OK
$ diff-expr '\''a && ((b >= c) != d)'\'' '\''a && b >= c != d'\''
OK
$ diff-expr '\''a && ((b >= c) != d)'\'' '\''a && (b >= c != d)'\''
OK
$ test-expr '\''a && ((b >= c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && ((b >= c) != D)'\'' '\''a && (b >= c) != D'\''
OK
$ diff-expr '\''a && ((b >= c) != D)'\'' '\''a && b >= c != D'\''
OK
$ diff-expr '\''a && ((b >= c) != D)'\'' '\''a && (b >= c != D)'\''
OK
$ test-expr '\''a && ((b >= C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && ((b >= C) != d)'\'' '\''a && (b >= C) != d'\''
OK
$ diff-expr '\''a && ((b >= C) != d)'\'' '\''a && b >= C != d'\''
OK
$ diff-expr '\''a && ((b >= C) != d)'\'' '\''a && (b >= C != d)'\''
OK
$ test-expr '\''a && ((b >= C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && ((b >= C) != D)'\'' '\''a && (b >= C) != D'\''
OK
$ diff-expr '\''a && ((b >= C) != D)'\'' '\''a && b >= C != D'\''
OK
$ diff-expr '\''a && ((b >= C) != D)'\'' '\''a && (b >= C != D)'\''
OK
$ test-expr '\''a && ((B >= c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && ((B >= c) != d)'\'' '\''a && (B >= c) != d'\''
OK
$ diff-expr '\''a && ((B >= c) != d)'\'' '\''a && B >= c != d'\''
OK
$ diff-expr '\''a && ((B >= c) != d)'\'' '\''a && (B >= c != d)'\''
OK
$ test-expr '\''a && ((B >= c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && ((B >= c) != D)'\'' '\''a && (B >= c) != D'\''
OK
$ diff-expr '\''a && ((B >= c) != D)'\'' '\''a && B >= c != D'\''
OK
$ diff-expr '\''a && ((B >= c) != D)'\'' '\''a && (B >= c != D)'\''
OK
$ test-expr '\''a && ((B >= C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a && ((B >= C) != d)'\'' '\''a && (B >= C) != d'\''
OK
$ diff-expr '\''a && ((B >= C) != d)'\'' '\''a && B >= C != d'\''
OK
$ diff-expr '\''a && ((B >= C) != d)'\'' '\''a && (B >= C != d)'\''
OK
$ test-expr '\''a && ((B >= C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a && ((B >= C) != D)'\'' '\''a && (B >= C) != D'\''
OK
$ diff-expr '\''a && ((B >= C) != D)'\'' '\''a && B >= C != D'\''
OK
$ diff-expr '\''a && ((B >= C) != D)'\'' '\''a && (B >= C != D)'\''
OK
$ test-expr '\''A && ((b >= c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && ((b >= c) != d)'\'' '\''A && (b >= c) != d'\''
OK
$ diff-expr '\''A && ((b >= c) != d)'\'' '\''A && b >= c != d'\''
OK
$ diff-expr '\''A && ((b >= c) != d)'\'' '\''A && (b >= c != d)'\''
OK
$ test-expr '\''A && ((b >= c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && ((b >= c) != D)'\'' '\''A && (b >= c) != D'\''
OK
$ diff-expr '\''A && ((b >= c) != D)'\'' '\''A && b >= c != D'\''
OK
$ diff-expr '\''A && ((b >= c) != D)'\'' '\''A && (b >= c != D)'\''
OK
$ test-expr '\''A && ((b >= C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && ((b >= C) != d)'\'' '\''A && (b >= C) != d'\''
OK
$ diff-expr '\''A && ((b >= C) != d)'\'' '\''A && b >= C != d'\''
OK
$ diff-expr '\''A && ((b >= C) != d)'\'' '\''A && (b >= C != d)'\''
OK
$ test-expr '\''A && ((b >= C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && ((b >= C) != D)'\'' '\''A && (b >= C) != D'\''
OK
$ diff-expr '\''A && ((b >= C) != D)'\'' '\''A && b >= C != D'\''
OK
$ diff-expr '\''A && ((b >= C) != D)'\'' '\''A && (b >= C != D)'\''
OK
$ test-expr '\''A && ((B >= c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && ((B >= c) != d)'\'' '\''A && (B >= c) != d'\''
OK
$ diff-expr '\''A && ((B >= c) != d)'\'' '\''A && B >= c != d'\''
OK
$ diff-expr '\''A && ((B >= c) != d)'\'' '\''A && (B >= c != d)'\''
OK
$ test-expr '\''A && ((B >= c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && ((B >= c) != D)'\'' '\''A && (B >= c) != D'\''
OK
$ diff-expr '\''A && ((B >= c) != D)'\'' '\''A && B >= c != D'\''
OK
$ diff-expr '\''A && ((B >= c) != D)'\'' '\''A && (B >= c != D)'\''
OK
$ test-expr '\''A && ((B >= C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A && ((B >= C) != d)'\'' '\''A && (B >= C) != d'\''
OK
$ diff-expr '\''A && ((B >= C) != d)'\'' '\''A && B >= C != d'\''
OK
$ diff-expr '\''A && ((B >= C) != d)'\'' '\''A && (B >= C != d)'\''
OK
$ test-expr '\''A && ((B >= C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A && ((B >= C) != D)'\'' '\''A && (B >= C) != D'\''
OK
$ diff-expr '\''A && ((B >= C) != D)'\'' '\''A && B >= C != D'\''
OK
$ diff-expr '\''A && ((B >= C) != D)'\'' '\''A && (B >= C != D)'\''
OK
$ test-expr '\''a || ((b >= c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || ((b >= c) != d)'\'' '\''a || (b >= c) != d'\''
OK
$ diff-expr '\''a || ((b >= c) != d)'\'' '\''a || b >= c != d'\''
OK
$ diff-expr '\''a || ((b >= c) != d)'\'' '\''a || (b >= c != d)'\''
OK
$ test-expr '\''a || ((b >= c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || ((b >= c) != D)'\'' '\''a || (b >= c) != D'\''
OK
$ diff-expr '\''a || ((b >= c) != D)'\'' '\''a || b >= c != D'\''
OK
$ diff-expr '\''a || ((b >= c) != D)'\'' '\''a || (b >= c != D)'\''
OK
$ test-expr '\''a || ((b >= C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || ((b >= C) != d)'\'' '\''a || (b >= C) != d'\''
OK
$ diff-expr '\''a || ((b >= C) != d)'\'' '\''a || b >= C != d'\''
OK
$ diff-expr '\''a || ((b >= C) != d)'\'' '\''a || (b >= C != d)'\''
OK
$ test-expr '\''a || ((b >= C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || ((b >= C) != D)'\'' '\''a || (b >= C) != D'\''
OK
$ diff-expr '\''a || ((b >= C) != D)'\'' '\''a || b >= C != D'\''
OK
$ diff-expr '\''a || ((b >= C) != D)'\'' '\''a || (b >= C != D)'\''
OK
$ test-expr '\''a || ((B >= c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || ((B >= c) != d)'\'' '\''a || (B >= c) != d'\''
OK
$ diff-expr '\''a || ((B >= c) != d)'\'' '\''a || B >= c != d'\''
OK
$ diff-expr '\''a || ((B >= c) != d)'\'' '\''a || (B >= c != d)'\''
OK
$ test-expr '\''a || ((B >= c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || ((B >= c) != D)'\'' '\''a || (B >= c) != D'\''
OK
$ diff-expr '\''a || ((B >= c) != D)'\'' '\''a || B >= c != D'\''
OK
$ diff-expr '\''a || ((B >= c) != D)'\'' '\''a || (B >= c != D)'\''
OK
$ test-expr '\''a || ((B >= C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || ((B >= C) != d)'\'' '\''a || (B >= C) != d'\''
OK
$ diff-expr '\''a || ((B >= C) != d)'\'' '\''a || B >= C != d'\''
OK
$ diff-expr '\''a || ((B >= C) != d)'\'' '\''a || (B >= C != d)'\''
OK
$ test-expr '\''a || ((B >= C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || ((B >= C) != D)'\'' '\''a || (B >= C) != D'\''
OK
$ diff-expr '\''a || ((B >= C) != D)'\'' '\''a || B >= C != D'\''
OK
$ diff-expr '\''a || ((B >= C) != D)'\'' '\''a || (B >= C != D)'\''
OK
$ test-expr '\''A || ((b >= c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || ((b >= c) != d)'\'' '\''A || (b >= c) != d'\''
OK
$ diff-expr '\''A || ((b >= c) != d)'\'' '\''A || b >= c != d'\''
OK
$ diff-expr '\''A || ((b >= c) != d)'\'' '\''A || (b >= c != d)'\''
OK
$ test-expr '\''A || ((b >= c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || ((b >= c) != D)'\'' '\''A || (b >= c) != D'\''
OK
$ diff-expr '\''A || ((b >= c) != D)'\'' '\''A || b >= c != D'\''
OK
$ diff-expr '\''A || ((b >= c) != D)'\'' '\''A || (b >= c != D)'\''
OK
$ test-expr '\''A || ((b >= C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || ((b >= C) != d)'\'' '\''A || (b >= C) != d'\''
OK
$ diff-expr '\''A || ((b >= C) != d)'\'' '\''A || b >= C != d'\''
OK
$ diff-expr '\''A || ((b >= C) != d)'\'' '\''A || (b >= C != d)'\''
OK
$ test-expr '\''A || ((b >= C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || ((b >= C) != D)'\'' '\''A || (b >= C) != D'\''
OK
$ diff-expr '\''A || ((b >= C) != D)'\'' '\''A || b >= C != D'\''
OK
$ diff-expr '\''A || ((b >= C) != D)'\'' '\''A || (b >= C != D)'\''
OK
$ test-expr '\''A || ((B >= c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || ((B >= c) != d)'\'' '\''A || (B >= c) != d'\''
OK
$ diff-expr '\''A || ((B >= c) != d)'\'' '\''A || B >= c != d'\''
OK
$ diff-expr '\''A || ((B >= c) != d)'\'' '\''A || (B >= c != d)'\''
OK
$ test-expr '\''A || ((B >= c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || ((B >= c) != D)'\'' '\''A || (B >= c) != D'\''
OK
$ diff-expr '\''A || ((B >= c) != D)'\'' '\''A || B >= c != D'\''
OK
$ diff-expr '\''A || ((B >= c) != D)'\'' '\''A || (B >= c != D)'\''
OK
$ test-expr '\''A || ((B >= C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || ((B >= C) != d)'\'' '\''A || (B >= C) != d'\''
OK
$ diff-expr '\''A || ((B >= C) != d)'\'' '\''A || B >= C != d'\''
OK
$ diff-expr '\''A || ((B >= C) != d)'\'' '\''A || (B >= C != d)'\''
OK
$ test-expr '\''A || ((B >= C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || ((B >= C) != D)'\'' '\''A || (B >= C) != D'\''
OK
$ diff-expr '\''A || ((B >= C) != D)'\'' '\''A || B >= C != D'\''
OK
$ diff-expr '\''A || ((B >= C) != D)'\'' '\''A || (B >= C != D)'\''
OK
$ test-expr '\''a || ((b >= c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((b >= c) && d)'\'' '\''a || (b >= c) && d'\''
OK
$ diff-expr '\''a || ((b >= c) && d)'\'' '\''a || b >= c && d'\''
OK
$ diff-expr '\''a || ((b >= c) && d)'\'' '\''a || (b >= c && d)'\''
OK
$ test-expr '\''a || ((b >= c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((b >= c) && D)'\'' '\''a || (b >= c) && D'\''
OK
$ diff-expr '\''a || ((b >= c) && D)'\'' '\''a || b >= c && D'\''
OK
$ diff-expr '\''a || ((b >= c) && D)'\'' '\''a || (b >= c && D)'\''
OK
$ test-expr '\''a || ((b >= C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((b >= C) && d)'\'' '\''a || (b >= C) && d'\''
OK
$ diff-expr '\''a || ((b >= C) && d)'\'' '\''a || b >= C && d'\''
OK
$ diff-expr '\''a || ((b >= C) && d)'\'' '\''a || (b >= C && d)'\''
OK
$ test-expr '\''a || ((b >= C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((b >= C) && D)'\'' '\''a || (b >= C) && D'\''
OK
$ diff-expr '\''a || ((b >= C) && D)'\'' '\''a || b >= C && D'\''
OK
$ diff-expr '\''a || ((b >= C) && D)'\'' '\''a || (b >= C && D)'\''
OK
$ test-expr '\''a || ((B >= c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((B >= c) && d)'\'' '\''a || (B >= c) && d'\''
OK
$ diff-expr '\''a || ((B >= c) && d)'\'' '\''a || B >= c && d'\''
OK
$ diff-expr '\''a || ((B >= c) && d)'\'' '\''a || (B >= c && d)'\''
OK
$ test-expr '\''a || ((B >= c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((B >= c) && D)'\'' '\''a || (B >= c) && D'\''
OK
$ diff-expr '\''a || ((B >= c) && D)'\'' '\''a || B >= c && D'\''
OK
$ diff-expr '\''a || ((B >= c) && D)'\'' '\''a || (B >= c && D)'\''
OK
$ test-expr '\''a || ((B >= C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((B >= C) && d)'\'' '\''a || (B >= C) && d'\''
OK
$ diff-expr '\''a || ((B >= C) && d)'\'' '\''a || B >= C && d'\''
OK
$ diff-expr '\''a || ((B >= C) && d)'\'' '\''a || (B >= C && d)'\''
OK
$ test-expr '\''a || ((B >= C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((B >= C) && D)'\'' '\''a || (B >= C) && D'\''
OK
$ diff-expr '\''a || ((B >= C) && D)'\'' '\''a || B >= C && D'\''
OK
$ diff-expr '\''a || ((B >= C) && D)'\'' '\''a || (B >= C && D)'\''
OK
$ test-expr '\''A || ((b >= c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((b >= c) && d)'\'' '\''A || (b >= c) && d'\''
OK
$ diff-expr '\''A || ((b >= c) && d)'\'' '\''A || b >= c && d'\''
OK
$ diff-expr '\''A || ((b >= c) && d)'\'' '\''A || (b >= c && d)'\''
OK
$ test-expr '\''A || ((b >= c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((b >= c) && D)'\'' '\''A || (b >= c) && D'\''
OK
$ diff-expr '\''A || ((b >= c) && D)'\'' '\''A || b >= c && D'\''
OK
$ diff-expr '\''A || ((b >= c) && D)'\'' '\''A || (b >= c && D)'\''
OK
$ test-expr '\''A || ((b >= C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((b >= C) && d)'\'' '\''A || (b >= C) && d'\''
OK
$ diff-expr '\''A || ((b >= C) && d)'\'' '\''A || b >= C && d'\''
OK
$ diff-expr '\''A || ((b >= C) && d)'\'' '\''A || (b >= C && d)'\''
OK
$ test-expr '\''A || ((b >= C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((b >= C) && D)'\'' '\''A || (b >= C) && D'\''
OK
$ diff-expr '\''A || ((b >= C) && D)'\'' '\''A || b >= C && D'\''
OK
$ diff-expr '\''A || ((b >= C) && D)'\'' '\''A || (b >= C && D)'\''
OK
$ test-expr '\''A || ((B >= c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((B >= c) && d)'\'' '\''A || (B >= c) && d'\''
OK
$ diff-expr '\''A || ((B >= c) && d)'\'' '\''A || B >= c && d'\''
OK
$ diff-expr '\''A || ((B >= c) && d)'\'' '\''A || (B >= c && d)'\''
OK
$ test-expr '\''A || ((B >= c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((B >= c) && D)'\'' '\''A || (B >= c) && D'\''
OK
$ diff-expr '\''A || ((B >= c) && D)'\'' '\''A || B >= c && D'\''
OK
$ diff-expr '\''A || ((B >= c) && D)'\'' '\''A || (B >= c && D)'\''
OK
$ test-expr '\''A || ((B >= C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((B >= C) && d)'\'' '\''A || (B >= C) && d'\''
OK
$ diff-expr '\''A || ((B >= C) && d)'\'' '\''A || B >= C && d'\''
OK
$ diff-expr '\''A || ((B >= C) && d)'\'' '\''A || (B >= C && d)'\''
OK
$ test-expr '\''A || ((B >= C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((B >= C) && D)'\'' '\''A || (B >= C) && D'\''
OK
$ diff-expr '\''A || ((B >= C) && D)'\'' '\''A || B >= C && D'\''
OK
$ diff-expr '\''A || ((B >= C) && D)'\'' '\''A || (B >= C && D)'\''
OK
$ test-expr '\''a || ((b != c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((b != c) && d)'\'' '\''a || (b != c) && d'\''
OK
$ diff-expr '\''a || ((b != c) && d)'\'' '\''a || b != c && d'\''
OK
$ diff-expr '\''a || ((b != c) && d)'\'' '\''a || (b != c && d)'\''
OK
$ test-expr '\''a || ((b != c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((b != c) && D)'\'' '\''a || (b != c) && D'\''
OK
$ diff-expr '\''a || ((b != c) && D)'\'' '\''a || b != c && D'\''
OK
$ diff-expr '\''a || ((b != c) && D)'\'' '\''a || (b != c && D)'\''
OK
$ test-expr '\''a || ((b != C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((b != C) && d)'\'' '\''a || (b != C) && d'\''
OK
$ diff-expr '\''a || ((b != C) && d)'\'' '\''a || b != C && d'\''
OK
$ diff-expr '\''a || ((b != C) && d)'\'' '\''a || (b != C && d)'\''
OK
$ test-expr '\''a || ((b != C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((b != C) && D)'\'' '\''a || (b != C) && D'\''
OK
$ diff-expr '\''a || ((b != C) && D)'\'' '\''a || b != C && D'\''
OK
$ diff-expr '\''a || ((b != C) && D)'\'' '\''a || (b != C && D)'\''
OK
$ test-expr '\''a || ((B != c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((B != c) && d)'\'' '\''a || (B != c) && d'\''
OK
$ diff-expr '\''a || ((B != c) && d)'\'' '\''a || B != c && d'\''
OK
$ diff-expr '\''a || ((B != c) && d)'\'' '\''a || (B != c && d)'\''
OK
$ test-expr '\''a || ((B != c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((B != c) && D)'\'' '\''a || (B != c) && D'\''
OK
$ diff-expr '\''a || ((B != c) && D)'\'' '\''a || B != c && D'\''
OK
$ diff-expr '\''a || ((B != c) && D)'\'' '\''a || (B != c && D)'\''
OK
$ test-expr '\''a || ((B != C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''a || ((B != C) && d)'\'' '\''a || (B != C) && d'\''
OK
$ diff-expr '\''a || ((B != C) && d)'\'' '\''a || B != C && d'\''
OK
$ diff-expr '\''a || ((B != C) && d)'\'' '\''a || (B != C && d)'\''
OK
$ test-expr '\''a || ((B != C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''a || ((B != C) && D)'\'' '\''a || (B != C) && D'\''
OK
$ diff-expr '\''a || ((B != C) && D)'\'' '\''a || B != C && D'\''
OK
$ diff-expr '\''a || ((B != C) && D)'\'' '\''a || (B != C && D)'\''
OK
$ test-expr '\''A || ((b != c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((b != c) && d)'\'' '\''A || (b != c) && d'\''
OK
$ diff-expr '\''A || ((b != c) && d)'\'' '\''A || b != c && d'\''
OK
$ diff-expr '\''A || ((b != c) && d)'\'' '\''A || (b != c && d)'\''
OK
$ test-expr '\''A || ((b != c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((b != c) && D)'\'' '\''A || (b != c) && D'\''
OK
$ diff-expr '\''A || ((b != c) && D)'\'' '\''A || b != c && D'\''
OK
$ diff-expr '\''A || ((b != c) && D)'\'' '\''A || (b != c && D)'\''
OK
$ test-expr '\''A || ((b != C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((b != C) && d)'\'' '\''A || (b != C) && d'\''
OK
$ diff-expr '\''A || ((b != C) && d)'\'' '\''A || b != C && d'\''
OK
$ diff-expr '\''A || ((b != C) && d)'\'' '\''A || (b != C && d)'\''
OK
$ test-expr '\''A || ((b != C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((b != C) && D)'\'' '\''A || (b != C) && D'\''
OK
$ diff-expr '\''A || ((b != C) && D)'\'' '\''A || b != C && D'\''
OK
$ diff-expr '\''A || ((b != C) && D)'\'' '\''A || (b != C && D)'\''
OK
$ test-expr '\''A || ((B != c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((B != c) && d)'\'' '\''A || (B != c) && d'\''
OK
$ diff-expr '\''A || ((B != c) && d)'\'' '\''A || B != c && d'\''
OK
$ diff-expr '\''A || ((B != c) && d)'\'' '\''A || (B != c && d)'\''
OK
$ test-expr '\''A || ((B != c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((B != c) && D)'\'' '\''A || (B != c) && D'\''
OK
$ diff-expr '\''A || ((B != c) && D)'\'' '\''A || B != c && D'\''
OK
$ diff-expr '\''A || ((B != c) && D)'\'' '\''A || (B != c && D)'\''
OK
$ test-expr '\''A || ((B != C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''A || ((B != C) && d)'\'' '\''A || (B != C) && d'\''
OK
$ diff-expr '\''A || ((B != C) && d)'\'' '\''A || B != C && d'\''
OK
$ diff-expr '\''A || ((B != C) && d)'\'' '\''A || (B != C && d)'\''
OK
$ test-expr '\''A || ((B != C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''A || ((B != C) && D)'\'' '\''A || (B != C) && D'\''
OK
$ diff-expr '\''A || ((B != C) && D)'\'' '\''A || B != C && D'\''
OK
$ diff-expr '\''A || ((B != C) && D)'\'' '\''A || (B != C && D)'\''
OK
$ test-expr '\''(a && (b >= c)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a && (b >= c)) != d'\'' '\''(a && b >= c) != d'\''
OK
$ test-expr '\''(a && (b >= c)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a && (b >= c)) != D'\'' '\''(a && b >= c) != D'\''
OK
$ test-expr '\''(a && (b >= C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a && (b >= C)) != d'\'' '\''(a && b >= C) != d'\''
OK
$ test-expr '\''(a && (b >= C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a && (b >= C)) != D'\'' '\''(a && b >= C) != D'\''
OK
$ test-expr '\''(a && (B >= c)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a && (B >= c)) != d'\'' '\''(a && B >= c) != d'\''
OK
$ test-expr '\''(a && (B >= c)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a && (B >= c)) != D'\'' '\''(a && B >= c) != D'\''
OK
$ test-expr '\''(a && (B >= C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a && (B >= C)) != d'\'' '\''(a && B >= C) != d'\''
OK
$ test-expr '\''(a && (B >= C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a && (B >= C)) != D'\'' '\''(a && B >= C) != D'\''
OK
$ test-expr '\''(A && (b >= c)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A && (b >= c)) != d'\'' '\''(A && b >= c) != d'\''
OK
$ test-expr '\''(A && (b >= c)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A && (b >= c)) != D'\'' '\''(A && b >= c) != D'\''
OK
$ test-expr '\''(A && (b >= C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A && (b >= C)) != d'\'' '\''(A && b >= C) != d'\''
OK
$ test-expr '\''(A && (b >= C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A && (b >= C)) != D'\'' '\''(A && b >= C) != D'\''
OK
$ test-expr '\''(A && (B >= c)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A && (B >= c)) != d'\'' '\''(A && B >= c) != d'\''
OK
$ test-expr '\''(A && (B >= c)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A && (B >= c)) != D'\'' '\''(A && B >= c) != D'\''
OK
$ test-expr '\''(A && (B >= C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A && (B >= C)) != d'\'' '\''(A && B >= C) != d'\''
OK
$ test-expr '\''(A && (B >= C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A && (B >= C)) != D'\'' '\''(A && B >= C) != D'\''
OK
$ test-expr '\''(a || (b >= c)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || (b >= c)) != d'\'' '\''(a || b >= c) != d'\''
OK
$ test-expr '\''(a || (b >= c)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || (b >= c)) != D'\'' '\''(a || b >= c) != D'\''
OK
$ test-expr '\''(a || (b >= C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || (b >= C)) != d'\'' '\''(a || b >= C) != d'\''
OK
$ test-expr '\''(a || (b >= C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || (b >= C)) != D'\'' '\''(a || b >= C) != D'\''
OK
$ test-expr '\''(a || (B >= c)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || (B >= c)) != d'\'' '\''(a || B >= c) != d'\''
OK
$ test-expr '\''(a || (B >= c)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || (B >= c)) != D'\'' '\''(a || B >= c) != D'\''
OK
$ test-expr '\''(a || (B >= C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || (B >= C)) != d'\'' '\''(a || B >= C) != d'\''
OK
$ test-expr '\''(a || (B >= C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || (B >= C)) != D'\'' '\''(a || B >= C) != D'\''
OK
$ test-expr '\''(A || (b >= c)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || (b >= c)) != d'\'' '\''(A || b >= c) != d'\''
OK
$ test-expr '\''(A || (b >= c)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || (b >= c)) != D'\'' '\''(A || b >= c) != D'\''
OK
$ test-expr '\''(A || (b >= C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || (b >= C)) != d'\'' '\''(A || b >= C) != d'\''
OK
$ test-expr '\''(A || (b >= C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || (b >= C)) != D'\'' '\''(A || b >= C) != D'\''
OK
$ test-expr '\''(A || (B >= c)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || (B >= c)) != d'\'' '\''(A || B >= c) != d'\''
OK
$ test-expr '\''(A || (B >= c)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || (B >= c)) != D'\'' '\''(A || B >= c) != D'\''
OK
$ test-expr '\''(A || (B >= C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || (B >= C)) != d'\'' '\''(A || B >= C) != d'\''
OK
$ test-expr '\''(A || (B >= C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || (B >= C)) != D'\'' '\''(A || B >= C) != D'\''
OK
$ test-expr '\''(a || (b >= c)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (b >= c)) && d'\'' '\''(a || b >= c) && d'\''
OK
$ test-expr '\''(a || (b >= c)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (b >= c)) && D'\'' '\''(a || b >= c) && D'\''
OK
$ test-expr '\''(a || (b >= C)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (b >= C)) && d'\'' '\''(a || b >= C) && d'\''
OK
$ test-expr '\''(a || (b >= C)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (b >= C)) && D'\'' '\''(a || b >= C) && D'\''
OK
$ test-expr '\''(a || (B >= c)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (B >= c)) && d'\'' '\''(a || B >= c) && d'\''
OK
$ test-expr '\''(a || (B >= c)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (B >= c)) && D'\'' '\''(a || B >= c) && D'\''
OK
$ test-expr '\''(a || (B >= C)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (B >= C)) && d'\'' '\''(a || B >= C) && d'\''
OK
$ test-expr '\''(a || (B >= C)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (B >= C)) && D'\'' '\''(a || B >= C) && D'\''
OK
$ test-expr '\''(A || (b >= c)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (b >= c)) && d'\'' '\''(A || b >= c) && d'\''
OK
$ test-expr '\''(A || (b >= c)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (b >= c)) && D'\'' '\''(A || b >= c) && D'\''
OK
$ test-expr '\''(A || (b >= C)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (b >= C)) && d'\'' '\''(A || b >= C) && d'\''
OK
$ test-expr '\''(A || (b >= C)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (b >= C)) && D'\'' '\''(A || b >= C) && D'\''
OK
$ test-expr '\''(A || (B >= c)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (B >= c)) && d'\'' '\''(A || B >= c) && d'\''
OK
$ test-expr '\''(A || (B >= c)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (B >= c)) && D'\'' '\''(A || B >= c) && D'\''
OK
$ test-expr '\''(A || (B >= C)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (B >= C)) && d'\'' '\''(A || B >= C) && d'\''
OK
$ test-expr '\''(A || (B >= C)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (B >= C)) && D'\'' '\''(A || B >= C) && D'\''
OK
$ test-expr '\''(a || (b != c)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (b != c)) && d'\'' '\''(a || b != c) && d'\''
OK
$ test-expr '\''(a || (b != c)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (b != c)) && D'\'' '\''(a || b != c) && D'\''
OK
$ test-expr '\''(a || (b != C)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (b != C)) && d'\'' '\''(a || b != C) && d'\''
OK
$ test-expr '\''(a || (b != C)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (b != C)) && D'\'' '\''(a || b != C) && D'\''
OK
$ test-expr '\''(a || (B != c)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (B != c)) && d'\'' '\''(a || B != c) && d'\''
OK
$ test-expr '\''(a || (B != c)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (B != c)) && D'\'' '\''(a || B != c) && D'\''
OK
$ test-expr '\''(a || (B != C)) && d'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(a || (B != C)) && d'\'' '\''(a || B != C) && d'\''
OK
$ test-expr '\''(a || (B != C)) && D'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(a || (B != C)) && D'\'' '\''(a || B != C) && D'\''
OK
$ test-expr '\''(A || (b != c)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (b != c)) && d'\'' '\''(A || b != c) && d'\''
OK
$ test-expr '\''(A || (b != c)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (b != c)) && D'\'' '\''(A || b != c) && D'\''
OK
$ test-expr '\''(A || (b != C)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (b != C)) && d'\'' '\''(A || b != C) && d'\''
OK
$ test-expr '\''(A || (b != C)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (b != C)) && D'\'' '\''(A || b != C) && D'\''
OK
$ test-expr '\''(A || (B != c)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (B != c)) && d'\'' '\''(A || B != c) && d'\''
OK
$ test-expr '\''(A || (B != c)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (B != c)) && D'\'' '\''(A || B != c) && D'\''
OK
$ test-expr '\''(A || (B != C)) && d'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 make_bool()
$ diff-expr '\''(A || (B != C)) && d'\'' '\''(A || B != C) && d'\''
OK
$ test-expr '\''(A || (B != C)) && D'\''
0 call_builtin(A)
1 jump_true*(6)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(D)
$ diff-expr '\''(A || (B != C)) && D'\'' '\''(A || B != C) && D'\''
OK
$ test-expr '\''(a && b) >= (c != d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a && b) >= (c != D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a && b) >= (C != d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a && b) >= (C != D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a && B) >= (c != d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a && B) >= (c != D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a && B) >= (C != d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a && B) >= (C != D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A && b) >= (c != d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A && b) >= (c != D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A && b) >= (C != d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A && b) >= (C != D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A && B) >= (c != d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A && B) >= (c != D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A && B) >= (C != d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A && B) >= (C != D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a || b) >= (c != d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a || b) >= (c != D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a || b) >= (C != d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a || b) >= (C != D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(a || B) >= (c != d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a || B) >= (c != D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a || B) >= (C != d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a || B) >= (C != D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A || b) >= (c != d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A || b) >= (c != D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A || b) >= (C != d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A || b) >= (C != D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''(A || B) >= (c != d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A || B) >= (c != D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A || B) >= (C != d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(A || B) >= (C != D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ test-expr '\''(a || b) >= (c && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(a || b) >= (c && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a || b) >= (C && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(a || b) >= (C && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(a || B) >= (c && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a || B) >= (c && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a || B) >= (C && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(a || B) >= (C && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A || b) >= (c && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(A || b) >= (c && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A || b) >= (C && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''(A || b) >= (C && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''(A || B) >= (c && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A || B) >= (c && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(A || B) >= (C && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ test-expr '\''(A || B) >= (C && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''(a || b) != (c && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(a || b) != (c && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(a || b) != (C && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(a || b) != (C && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(a || B) != (c && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(a || B) != (c && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(a || B) != (C && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(a || B) != (C && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(A || b) != (c && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(A || b) != (c && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(A || b) != (C && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''(A || b) != (C && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''(A || B) != (c && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(A || B) != (c && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''(A || B) != (C && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ test-expr '\''(A || B) != (C && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a && (b >= (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (b >= (c != d))'\'' '\''a && b >= (c != d)'\''
OK
$ test-expr '\''a && (b >= (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (b >= (c != D))'\'' '\''a && b >= (c != D)'\''
OK
$ test-expr '\''a && (b >= (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (b >= (C != d))'\'' '\''a && b >= (C != d)'\''
OK
$ test-expr '\''a && (b >= (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (b >= (C != D))'\'' '\''a && b >= (C != D)'\''
OK
$ test-expr '\''a && (B >= (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (B >= (c != d))'\'' '\''a && B >= (c != d)'\''
OK
$ test-expr '\''a && (B >= (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (B >= (c != D))'\'' '\''a && B >= (c != D)'\''
OK
$ test-expr '\''a && (B >= (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (B >= (C != d))'\'' '\''a && B >= (C != d)'\''
OK
$ test-expr '\''a && (B >= (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a && (B >= (C != D))'\'' '\''a && B >= (C != D)'\''
OK
$ test-expr '\''A && (b >= (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (b >= (c != d))'\'' '\''A && b >= (c != d)'\''
OK
$ test-expr '\''A && (b >= (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (b >= (c != D))'\'' '\''A && b >= (c != D)'\''
OK
$ test-expr '\''A && (b >= (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (b >= (C != d))'\'' '\''A && b >= (C != d)'\''
OK
$ test-expr '\''A && (b >= (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (b >= (C != D))'\'' '\''A && b >= (C != D)'\''
OK
$ test-expr '\''A && (B >= (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (B >= (c != d))'\'' '\''A && B >= (c != d)'\''
OK
$ test-expr '\''A && (B >= (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (B >= (c != D))'\'' '\''A && B >= (c != D)'\''
OK
$ test-expr '\''A && (B >= (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (B >= (C != d))'\'' '\''A && B >= (C != d)'\''
OK
$ test-expr '\''A && (B >= (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A && (B >= (C != D))'\'' '\''A && B >= (C != D)'\''
OK
$ test-expr '\''a || (b >= (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (b >= (c != d))'\'' '\''a || b >= (c != d)'\''
OK
$ test-expr '\''a || (b >= (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (b >= (c != D))'\'' '\''a || b >= (c != D)'\''
OK
$ test-expr '\''a || (b >= (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (b >= (C != d))'\'' '\''a || b >= (C != d)'\''
OK
$ test-expr '\''a || (b >= (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (b >= (C != D))'\'' '\''a || b >= (C != D)'\''
OK
$ test-expr '\''a || (B >= (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (B >= (c != d))'\'' '\''a || B >= (c != d)'\''
OK
$ test-expr '\''a || (B >= (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (B >= (c != D))'\'' '\''a || B >= (c != D)'\''
OK
$ test-expr '\''a || (B >= (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (B >= (C != d))'\'' '\''a || B >= (C != d)'\''
OK
$ test-expr '\''a || (B >= (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''a || (B >= (C != D))'\'' '\''a || B >= (C != D)'\''
OK
$ test-expr '\''A || (b >= (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (b >= (c != d))'\'' '\''A || b >= (c != d)'\''
OK
$ test-expr '\''A || (b >= (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (b >= (c != D))'\'' '\''A || b >= (c != D)'\''
OK
$ test-expr '\''A || (b >= (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (b >= (C != d))'\'' '\''A || b >= (C != d)'\''
OK
$ test-expr '\''A || (b >= (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (b >= (C != D))'\'' '\''A || b >= (C != D)'\''
OK
$ test-expr '\''A || (B >= (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (B >= (c != d))'\'' '\''A || B >= (c != d)'\''
OK
$ test-expr '\''A || (B >= (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (B >= (c != D))'\'' '\''A || B >= (c != D)'\''
OK
$ test-expr '\''A || (B >= (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (B >= (C != d))'\'' '\''A || B >= (C != d)'\''
OK
$ test-expr '\''A || (B >= (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
$ diff-expr '\''A || (B >= (C != D))'\'' '\''A || B >= (C != D)'\''
OK
$ test-expr '\''a || (b >= (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a || (b >= (c && d))'\'' '\''a || b >= (c && d)'\''
OK
$ test-expr '\''a || (b >= (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (b >= (c && D))'\'' '\''a || b >= (c && D)'\''
OK
$ test-expr '\''a || (b >= (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a || (b >= (C && d))'\'' '\''a || b >= (C && d)'\''
OK
$ test-expr '\''a || (b >= (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (b >= (C && D))'\'' '\''a || b >= (C && D)'\''
OK
$ test-expr '\''a || (B >= (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a || (B >= (c && d))'\'' '\''a || B >= (c && d)'\''
OK
$ test-expr '\''a || (B >= (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (B >= (c && D))'\'' '\''a || B >= (c && D)'\''
OK
$ test-expr '\''a || (B >= (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''a || (B >= (C && d))'\'' '\''a || B >= (C && d)'\''
OK
$ test-expr '\''a || (B >= (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (B >= (C && D))'\'' '\''a || B >= (C && D)'\''
OK
$ test-expr '\''A || (b >= (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A || (b >= (c && d))'\'' '\''A || b >= (c && d)'\''
OK
$ test-expr '\''A || (b >= (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (b >= (c && D))'\'' '\''A || b >= (c && D)'\''
OK
$ test-expr '\''A || (b >= (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A || (b >= (C && d))'\'' '\''A || b >= (C && d)'\''
OK
$ test-expr '\''A || (b >= (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (b >= (C && D))'\'' '\''A || b >= (C && D)'\''
OK
$ test-expr '\''A || (B >= (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A || (B >= (c && d))'\'' '\''A || B >= (c && d)'\''
OK
$ test-expr '\''A || (B >= (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (B >= (c && D))'\'' '\''A || B >= (c && D)'\''
OK
$ test-expr '\''A || (B >= (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
$ diff-expr '\''A || (B >= (C && d))'\'' '\''A || B >= (C && d)'\''
OK
$ test-expr '\''A || (B >= (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (B >= (C && D))'\'' '\''A || B >= (C && D)'\''
OK
$ test-expr '\''a || (b != (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a || (b != (c && d))'\'' '\''a || b != (c && d)'\''
OK
$ test-expr '\''a || (b != (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (b != (c && D))'\'' '\''a || b != (c && D)'\''
OK
$ test-expr '\''a || (b != (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a || (b != (C && d))'\'' '\''a || b != (C && d)'\''
OK
$ test-expr '\''a || (b != (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (b != (C && D))'\'' '\''a || b != (C && D)'\''
OK
$ test-expr '\''a || (B != (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a || (B != (c && d))'\'' '\''a || B != (c && d)'\''
OK
$ test-expr '\''a || (B != (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (B != (c && D))'\'' '\''a || B != (c && D)'\''
OK
$ test-expr '\''a || (B != (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''a || (B != (C && d))'\'' '\''a || B != (C && d)'\''
OK
$ test-expr '\''a || (B != (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (B != (C && D))'\'' '\''a || B != (C && D)'\''
OK
$ test-expr '\''A || (b != (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A || (b != (c && d))'\'' '\''A || b != (c && d)'\''
OK
$ test-expr '\''A || (b != (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (b != (c && D))'\'' '\''A || b != (c && D)'\''
OK
$ test-expr '\''A || (b != (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A || (b != (C && d))'\'' '\''A || b != (C && d)'\''
OK
$ test-expr '\''A || (b != (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (b != (C && D))'\'' '\''A || b != (C && D)'\''
OK
$ test-expr '\''A || (B != (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A || (B != (c && d))'\'' '\''A || B != (c && d)'\''
OK
$ test-expr '\''A || (B != (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (B != (c && D))'\'' '\''A || B != (c && D)'\''
OK
$ test-expr '\''A || (B != (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
$ diff-expr '\''A || (B != (C && d))'\'' '\''A || B != (C && d)'\''
OK
$ test-expr '\''A || (B != (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (B != (C && D))'\'' '\''A || B != (C && D)'\''
OK
$ test-expr '\''((a && b) != c) >= d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((a && b) != c) >= D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((a && b) != C) >= d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((a && b) != C) >= D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((a && B) != c) >= d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((a && B) != c) >= D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((a && B) != C) >= d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((a && B) != C) >= D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((A && b) != c) >= d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((A && b) != c) >= D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((A && b) != C) >= d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((A && b) != C) >= D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((A && B) != c) >= d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((A && B) != c) >= D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((A && B) != C) >= d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((A && B) != C) >= D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((a || b) != c) >= d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((a || b) != c) >= D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((a || b) != C) >= d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((a || b) != C) >= D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((a || B) != c) >= d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((a || B) != c) >= D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((a || B) != C) >= d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((a || B) != C) >= D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((A || b) != c) >= d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((A || b) != c) >= D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((A || b) != C) >= d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((A || b) != C) >= D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((A || B) != c) >= d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((A || B) != c) >= D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((A || B) != C) >= d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((A || B) != C) >= D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((a || b) && c) >= d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''((a || b) && c) >= D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''((a || b) && C) >= d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((a || b) && C) >= D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((a || B) && c) >= d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((a || B) && c) >= D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((a || B) && C) >= d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((a || B) && C) >= D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((A || b) && c) >= d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''((A || b) && c) >= D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''((A || b) && C) >= d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((A || b) && C) >= D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((A || B) && c) >= d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''((A || B) && c) >= D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''((A || B) && C) >= d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ test-expr '\''((A || B) && C) >= D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ test-expr '\''((a || b) && c) != d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''((a || b) && c) != D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''((a || b) && C) != d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''((a || b) && C) != D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''((a || B) && c) != d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''((a || B) && c) != D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''((a || B) && C) != d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ test-expr '\''((a || B) && C) != D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''((A || b) && c) != d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''((A || b) && c) != D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''((A || b) && C) != d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''((A || b) && C) != D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''((A || B) && c) != d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''((A || B) && c) != D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''((A || B) && C) != d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ test-expr '\''((A || B) && C) != D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ test-expr '\''a && ((b != c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && ((b != c) >= d)'\'' '\''a && (b != c) >= d'\''
OK
$ test-expr '\''a && ((b != c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && ((b != c) >= D)'\'' '\''a && (b != c) >= D'\''
OK
$ test-expr '\''a && ((b != C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && ((b != C) >= d)'\'' '\''a && (b != C) >= d'\''
OK
$ test-expr '\''a && ((b != C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && ((b != C) >= D)'\'' '\''a && (b != C) >= D'\''
OK
$ test-expr '\''a && ((B != c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && ((B != c) >= d)'\'' '\''a && (B != c) >= d'\''
OK
$ test-expr '\''a && ((B != c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && ((B != c) >= D)'\'' '\''a && (B != c) >= D'\''
OK
$ test-expr '\''a && ((B != C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a && ((B != C) >= d)'\'' '\''a && (B != C) >= d'\''
OK
$ test-expr '\''a && ((B != C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a && ((B != C) >= D)'\'' '\''a && (B != C) >= D'\''
OK
$ test-expr '\''A && ((b != c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && ((b != c) >= d)'\'' '\''A && (b != c) >= d'\''
OK
$ test-expr '\''A && ((b != c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && ((b != c) >= D)'\'' '\''A && (b != c) >= D'\''
OK
$ test-expr '\''A && ((b != C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && ((b != C) >= d)'\'' '\''A && (b != C) >= d'\''
OK
$ test-expr '\''A && ((b != C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && ((b != C) >= D)'\'' '\''A && (b != C) >= D'\''
OK
$ test-expr '\''A && ((B != c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && ((B != c) >= d)'\'' '\''A && (B != c) >= d'\''
OK
$ test-expr '\''A && ((B != c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && ((B != c) >= D)'\'' '\''A && (B != c) >= D'\''
OK
$ test-expr '\''A && ((B != C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A && ((B != C) >= d)'\'' '\''A && (B != C) >= d'\''
OK
$ test-expr '\''A && ((B != C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A && ((B != C) >= D)'\'' '\''A && (B != C) >= D'\''
OK
$ test-expr '\''a || ((b != c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || ((b != c) >= d)'\'' '\''a || (b != c) >= d'\''
OK
$ test-expr '\''a || ((b != c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || ((b != c) >= D)'\'' '\''a || (b != c) >= D'\''
OK
$ test-expr '\''a || ((b != C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || ((b != C) >= d)'\'' '\''a || (b != C) >= d'\''
OK
$ test-expr '\''a || ((b != C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || ((b != C) >= D)'\'' '\''a || (b != C) >= D'\''
OK
$ test-expr '\''a || ((B != c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || ((B != c) >= d)'\'' '\''a || (B != c) >= d'\''
OK
$ test-expr '\''a || ((B != c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || ((B != c) >= D)'\'' '\''a || (B != c) >= D'\''
OK
$ test-expr '\''a || ((B != C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || ((B != C) >= d)'\'' '\''a || (B != C) >= d'\''
OK
$ test-expr '\''a || ((B != C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || ((B != C) >= D)'\'' '\''a || (B != C) >= D'\''
OK
$ test-expr '\''A || ((b != c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || ((b != c) >= d)'\'' '\''A || (b != c) >= d'\''
OK
$ test-expr '\''A || ((b != c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || ((b != c) >= D)'\'' '\''A || (b != c) >= D'\''
OK
$ test-expr '\''A || ((b != C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || ((b != C) >= d)'\'' '\''A || (b != C) >= d'\''
OK
$ test-expr '\''A || ((b != C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || ((b != C) >= D)'\'' '\''A || (b != C) >= D'\''
OK
$ test-expr '\''A || ((B != c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || ((B != c) >= d)'\'' '\''A || (B != c) >= d'\''
OK
$ test-expr '\''A || ((B != c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || ((B != c) >= D)'\'' '\''A || (B != c) >= D'\''
OK
$ test-expr '\''A || ((B != C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || ((B != C) >= d)'\'' '\''A || (B != C) >= d'\''
OK
$ test-expr '\''A || ((B != C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || ((B != C) >= D)'\'' '\''A || (B != C) >= D'\''
OK
$ test-expr '\''a || ((b && c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''a || ((b && c) >= d)'\'' '\''a || (b && c) >= d'\''
OK
$ test-expr '\''a || ((b && c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''a || ((b && c) >= D)'\'' '\''a || (b && c) >= D'\''
OK
$ test-expr '\''a || ((b && C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || ((b && C) >= d)'\'' '\''a || (b && C) >= d'\''
OK
$ test-expr '\''a || ((b && C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || ((b && C) >= D)'\'' '\''a || (b && C) >= D'\''
OK
$ test-expr '\''a || ((B && c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''a || ((B && c) >= d)'\'' '\''a || (B && c) >= d'\''
OK
$ test-expr '\''a || ((B && c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''a || ((B && c) >= D)'\'' '\''a || (B && c) >= D'\''
OK
$ test-expr '\''a || ((B && C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || ((B && C) >= d)'\'' '\''a || (B && C) >= d'\''
OK
$ test-expr '\''a || ((B && C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || ((B && C) >= D)'\'' '\''a || (B && C) >= D'\''
OK
$ test-expr '\''A || ((b && c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''A || ((b && c) >= d)'\'' '\''A || (b && c) >= d'\''
OK
$ test-expr '\''A || ((b && c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''A || ((b && c) >= D)'\'' '\''A || (b && c) >= D'\''
OK
$ test-expr '\''A || ((b && C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || ((b && C) >= d)'\'' '\''A || (b && C) >= d'\''
OK
$ test-expr '\''A || ((b && C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || ((b && C) >= D)'\'' '\''A || (b && C) >= D'\''
OK
$ test-expr '\''A || ((B && c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''A || ((B && c) >= d)'\'' '\''A || (B && c) >= d'\''
OK
$ test-expr '\''A || ((B && c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''A || ((B && c) >= D)'\'' '\''A || (B && c) >= D'\''
OK
$ test-expr '\''A || ((B && C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || ((B && C) >= d)'\'' '\''A || (B && C) >= d'\''
OK
$ test-expr '\''A || ((B && C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || ((B && C) >= D)'\'' '\''A || (B && C) >= D'\''
OK
$ test-expr '\''a || ((b && c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''a || ((b && c) != d)'\'' '\''a || (b && c) != d'\''
OK
$ test-expr '\''a || ((b && c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''a || ((b && c) != D)'\'' '\''a || (b && c) != D'\''
OK
$ test-expr '\''a || ((b && C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || ((b && C) != d)'\'' '\''a || (b && C) != d'\''
OK
$ test-expr '\''a || ((b && C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || ((b && C) != D)'\'' '\''a || (b && C) != D'\''
OK
$ test-expr '\''a || ((B && c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''a || ((B && c) != d)'\'' '\''a || (B && c) != d'\''
OK
$ test-expr '\''a || ((B && c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''a || ((B && c) != D)'\'' '\''a || (B && c) != D'\''
OK
$ test-expr '\''a || ((B && C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || ((B && C) != d)'\'' '\''a || (B && C) != d'\''
OK
$ test-expr '\''a || ((B && C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || ((B && C) != D)'\'' '\''a || (B && C) != D'\''
OK
$ test-expr '\''A || ((b && c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''A || ((b && c) != d)'\'' '\''A || (b && c) != d'\''
OK
$ test-expr '\''A || ((b && c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''A || ((b && c) != D)'\'' '\''A || (b && c) != D'\''
OK
$ test-expr '\''A || ((b && C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || ((b && C) != d)'\'' '\''A || (b && C) != d'\''
OK
$ test-expr '\''A || ((b && C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || ((b && C) != D)'\'' '\''A || (b && C) != D'\''
OK
$ test-expr '\''A || ((B && c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''A || ((B && c) != d)'\'' '\''A || (B && c) != d'\''
OK
$ test-expr '\''A || ((B && c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''A || ((B && c) != D)'\'' '\''A || (B && c) != D'\''
OK
$ test-expr '\''A || ((B && C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || ((B && C) != d)'\'' '\''A || (B && C) != d'\''
OK
$ test-expr '\''A || ((B && C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || ((B && C) != D)'\'' '\''A || (B && C) != D'\''
OK
$ test-expr '\''(a && (b != c)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a && (b != c)) >= d'\'' '\''(a && b != c) >= d'\''
OK
$ test-expr '\''(a && (b != c)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a && (b != c)) >= D'\'' '\''(a && b != c) >= D'\''
OK
$ test-expr '\''(a && (b != C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a && (b != C)) >= d'\'' '\''(a && b != C) >= d'\''
OK
$ test-expr '\''(a && (b != C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a && (b != C)) >= D'\'' '\''(a && b != C) >= D'\''
OK
$ test-expr '\''(a && (B != c)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a && (B != c)) >= d'\'' '\''(a && B != c) >= d'\''
OK
$ test-expr '\''(a && (B != c)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a && (B != c)) >= D'\'' '\''(a && B != c) >= D'\''
OK
$ test-expr '\''(a && (B != C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a && (B != C)) >= d'\'' '\''(a && B != C) >= d'\''
OK
$ test-expr '\''(a && (B != C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a && (B != C)) >= D'\'' '\''(a && B != C) >= D'\''
OK
$ test-expr '\''(A && (b != c)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A && (b != c)) >= d'\'' '\''(A && b != c) >= d'\''
OK
$ test-expr '\''(A && (b != c)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A && (b != c)) >= D'\'' '\''(A && b != c) >= D'\''
OK
$ test-expr '\''(A && (b != C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A && (b != C)) >= d'\'' '\''(A && b != C) >= d'\''
OK
$ test-expr '\''(A && (b != C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A && (b != C)) >= D'\'' '\''(A && b != C) >= D'\''
OK
$ test-expr '\''(A && (B != c)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A && (B != c)) >= d'\'' '\''(A && B != c) >= d'\''
OK
$ test-expr '\''(A && (B != c)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A && (B != c)) >= D'\'' '\''(A && B != c) >= D'\''
OK
$ test-expr '\''(A && (B != C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A && (B != C)) >= d'\'' '\''(A && B != C) >= d'\''
OK
$ test-expr '\''(A && (B != C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A && (B != C)) >= D'\'' '\''(A && B != C) >= D'\''
OK
$ test-expr '\''(a || (b != c)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || (b != c)) >= d'\'' '\''(a || b != c) >= d'\''
OK
$ test-expr '\''(a || (b != c)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || (b != c)) >= D'\'' '\''(a || b != c) >= D'\''
OK
$ test-expr '\''(a || (b != C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || (b != C)) >= d'\'' '\''(a || b != C) >= d'\''
OK
$ test-expr '\''(a || (b != C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || (b != C)) >= D'\'' '\''(a || b != C) >= D'\''
OK
$ test-expr '\''(a || (B != c)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || (B != c)) >= d'\'' '\''(a || B != c) >= d'\''
OK
$ test-expr '\''(a || (B != c)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || (B != c)) >= D'\'' '\''(a || B != c) >= D'\''
OK
$ test-expr '\''(a || (B != C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || (B != C)) >= d'\'' '\''(a || B != C) >= d'\''
OK
$ test-expr '\''(a || (B != C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || (B != C)) >= D'\'' '\''(a || B != C) >= D'\''
OK
$ test-expr '\''(A || (b != c)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || (b != c)) >= d'\'' '\''(A || b != c) >= d'\''
OK
$ test-expr '\''(A || (b != c)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || (b != c)) >= D'\'' '\''(A || b != c) >= D'\''
OK
$ test-expr '\''(A || (b != C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || (b != C)) >= d'\'' '\''(A || b != C) >= d'\''
OK
$ test-expr '\''(A || (b != C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || (b != C)) >= D'\'' '\''(A || b != C) >= D'\''
OK
$ test-expr '\''(A || (B != c)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || (B != c)) >= d'\'' '\''(A || B != c) >= d'\''
OK
$ test-expr '\''(A || (B != c)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || (B != c)) >= D'\'' '\''(A || B != c) >= D'\''
OK
$ test-expr '\''(A || (B != C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || (B != C)) >= d'\'' '\''(A || B != C) >= d'\''
OK
$ test-expr '\''(A || (B != C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || (B != C)) >= D'\'' '\''(A || B != C) >= D'\''
OK
$ test-expr '\''(a || (b && c)) >= d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(a || (b && c)) >= d'\'' '\''(a || b && c) >= d'\''
OK
$ test-expr '\''(a || (b && c)) >= D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(a || (b && c)) >= D'\'' '\''(a || b && c) >= D'\''
OK
$ test-expr '\''(a || (b && C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || (b && C)) >= d'\'' '\''(a || b && C) >= d'\''
OK
$ test-expr '\''(a || (b && C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || (b && C)) >= D'\'' '\''(a || b && C) >= D'\''
OK
$ test-expr '\''(a || (B && c)) >= d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(a || (B && c)) >= d'\'' '\''(a || B && c) >= d'\''
OK
$ test-expr '\''(a || (B && c)) >= D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(a || (B && c)) >= D'\'' '\''(a || B && c) >= D'\''
OK
$ test-expr '\''(a || (B && C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || (B && C)) >= d'\'' '\''(a || B && C) >= d'\''
OK
$ test-expr '\''(a || (B && C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || (B && C)) >= D'\'' '\''(a || B && C) >= D'\''
OK
$ test-expr '\''(A || (b && c)) >= d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(A || (b && c)) >= d'\'' '\''(A || b && c) >= d'\''
OK
$ test-expr '\''(A || (b && c)) >= D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(A || (b && c)) >= D'\'' '\''(A || b && c) >= D'\''
OK
$ test-expr '\''(A || (b && C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || (b && C)) >= d'\'' '\''(A || b && C) >= d'\''
OK
$ test-expr '\''(A || (b && C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || (b && C)) >= D'\'' '\''(A || b && C) >= D'\''
OK
$ test-expr '\''(A || (B && c)) >= d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(A || (B && c)) >= d'\'' '\''(A || B && c) >= d'\''
OK
$ test-expr '\''(A || (B && c)) >= D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(A || (B && c)) >= D'\'' '\''(A || B && c) >= D'\''
OK
$ test-expr '\''(A || (B && C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || (B && C)) >= d'\'' '\''(A || B && C) >= d'\''
OK
$ test-expr '\''(A || (B && C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || (B && C)) >= D'\'' '\''(A || B && C) >= D'\''
OK
$ test-expr '\''(a || (b && c)) != d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a || (b && c)) != d'\'' '\''(a || b && c) != d'\''
OK
$ test-expr '\''(a || (b && c)) != D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a || (b && c)) != D'\'' '\''(a || b && c) != D'\''
OK
$ test-expr '\''(a || (b && C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || (b && C)) != d'\'' '\''(a || b && C) != d'\''
OK
$ test-expr '\''(a || (b && C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || (b && C)) != D'\'' '\''(a || b && C) != D'\''
OK
$ test-expr '\''(a || (B && c)) != d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a || (B && c)) != d'\'' '\''(a || B && c) != d'\''
OK
$ test-expr '\''(a || (B && c)) != D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a || (B && c)) != D'\'' '\''(a || B && c) != D'\''
OK
$ test-expr '\''(a || (B && C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || (B && C)) != d'\'' '\''(a || B && C) != d'\''
OK
$ test-expr '\''(a || (B && C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || (B && C)) != D'\'' '\''(a || B && C) != D'\''
OK
$ test-expr '\''(A || (b && c)) != d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A || (b && c)) != d'\'' '\''(A || b && c) != d'\''
OK
$ test-expr '\''(A || (b && c)) != D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A || (b && c)) != D'\'' '\''(A || b && c) != D'\''
OK
$ test-expr '\''(A || (b && C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || (b && C)) != d'\'' '\''(A || b && C) != d'\''
OK
$ test-expr '\''(A || (b && C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || (b && C)) != D'\'' '\''(A || b && C) != D'\''
OK
$ test-expr '\''(A || (B && c)) != d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A || (B && c)) != d'\'' '\''(A || B && c) != d'\''
OK
$ test-expr '\''(A || (B && c)) != D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A || (B && c)) != D'\'' '\''(A || B && c) != D'\''
OK
$ test-expr '\''(A || (B && C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || (B && C)) != d'\'' '\''(A || B && C) != d'\''
OK
$ test-expr '\''(A || (B && C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || (B && C)) != D'\'' '\''(A || B && C) != D'\''
OK
$ test-expr '\''(a && b) != (c >= d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a && b) != (c >= d)'\'' '\''(a && b) != c >= d'\''
OK
$ test-expr '\''(a && b) != (c >= D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a && b) != (c >= D)'\'' '\''(a && b) != c >= D'\''
OK
$ test-expr '\''(a && b) != (C >= d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a && b) != (C >= d)'\'' '\''(a && b) != C >= d'\''
OK
$ test-expr '\''(a && b) != (C >= D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a && b) != (C >= D)'\'' '\''(a && b) != C >= D'\''
OK
$ test-expr '\''(a && B) != (c >= d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a && B) != (c >= d)'\'' '\''(a && B) != c >= d'\''
OK
$ test-expr '\''(a && B) != (c >= D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a && B) != (c >= D)'\'' '\''(a && B) != c >= D'\''
OK
$ test-expr '\''(a && B) != (C >= d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a && B) != (C >= d)'\'' '\''(a && B) != C >= d'\''
OK
$ test-expr '\''(a && B) != (C >= D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a && B) != (C >= D)'\'' '\''(a && B) != C >= D'\''
OK
$ test-expr '\''(A && b) != (c >= d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A && b) != (c >= d)'\'' '\''(A && b) != c >= d'\''
OK
$ test-expr '\''(A && b) != (c >= D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A && b) != (c >= D)'\'' '\''(A && b) != c >= D'\''
OK
$ test-expr '\''(A && b) != (C >= d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A && b) != (C >= d)'\'' '\''(A && b) != C >= d'\''
OK
$ test-expr '\''(A && b) != (C >= D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A && b) != (C >= D)'\'' '\''(A && b) != C >= D'\''
OK
$ test-expr '\''(A && B) != (c >= d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A && B) != (c >= d)'\'' '\''(A && B) != c >= d'\''
OK
$ test-expr '\''(A && B) != (c >= D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A && B) != (c >= D)'\'' '\''(A && B) != c >= D'\''
OK
$ test-expr '\''(A && B) != (C >= d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A && B) != (C >= d)'\'' '\''(A && B) != C >= d'\''
OK
$ test-expr '\''(A && B) != (C >= D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A && B) != (C >= D)'\'' '\''(A && B) != C >= D'\''
OK
$ test-expr '\''(a || b) != (c >= d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a || b) != (c >= d)'\'' '\''(a || b) != c >= d'\''
OK
$ test-expr '\''(a || b) != (c >= D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a || b) != (c >= D)'\'' '\''(a || b) != c >= D'\''
OK
$ test-expr '\''(a || b) != (C >= d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a || b) != (C >= d)'\'' '\''(a || b) != C >= d'\''
OK
$ test-expr '\''(a || b) != (C >= D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(a || b) != (C >= D)'\'' '\''(a || b) != C >= D'\''
OK
$ test-expr '\''(a || B) != (c >= d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a || B) != (c >= d)'\'' '\''(a || B) != c >= d'\''
OK
$ test-expr '\''(a || B) != (c >= D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a || B) != (c >= D)'\'' '\''(a || B) != c >= D'\''
OK
$ test-expr '\''(a || B) != (C >= d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a || B) != (C >= d)'\'' '\''(a || B) != C >= d'\''
OK
$ test-expr '\''(a || B) != (C >= D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(a || B) != (C >= D)'\'' '\''(a || B) != C >= D'\''
OK
$ test-expr '\''(A || b) != (c >= d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A || b) != (c >= d)'\'' '\''(A || b) != c >= d'\''
OK
$ test-expr '\''(A || b) != (c >= D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A || b) != (c >= D)'\'' '\''(A || b) != c >= D'\''
OK
$ test-expr '\''(A || b) != (C >= d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A || b) != (C >= d)'\'' '\''(A || b) != C >= d'\''
OK
$ test-expr '\''(A || b) != (C >= D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ diff-expr '\''(A || b) != (C >= D)'\'' '\''(A || b) != C >= D'\''
OK
$ test-expr '\''(A || B) != (c >= d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A || B) != (c >= d)'\'' '\''(A || B) != c >= d'\''
OK
$ test-expr '\''(A || B) != (c >= D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A || B) != (c >= D)'\'' '\''(A || B) != c >= D'\''
OK
$ test-expr '\''(A || B) != (C >= d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A || B) != (C >= d)'\'' '\''(A || B) != C >= d'\''
OK
$ test-expr '\''(A || B) != (C >= D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''(A || B) != (C >= D)'\'' '\''(A || B) != C >= D'\''
OK
$ test-expr '\''(a || b) && (c >= d)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(a || b) && (c >= d)'\'' '\''(a || b) && c >= d'\''
OK
$ test-expr '\''(a || b) && (c >= D)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(a || b) && (c >= D)'\'' '\''(a || b) && c >= D'\''
OK
$ test-expr '\''(a || b) && (C >= d)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(a || b) && (C >= d)'\'' '\''(a || b) && C >= d'\''
OK
$ test-expr '\''(a || b) && (C >= D)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(a || b) && (C >= D)'\'' '\''(a || b) && C >= D'\''
OK
$ test-expr '\''(a || B) && (c >= d)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || B) && (c >= d)'\'' '\''(a || B) && c >= d'\''
OK
$ test-expr '\''(a || B) && (c >= D)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || B) && (c >= D)'\'' '\''(a || B) && c >= D'\''
OK
$ test-expr '\''(a || B) && (C >= d)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(a || B) && (C >= d)'\'' '\''(a || B) && C >= d'\''
OK
$ test-expr '\''(a || B) && (C >= D)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(a || B) && (C >= D)'\'' '\''(a || B) && C >= D'\''
OK
$ test-expr '\''(A || b) && (c >= d)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(A || b) && (c >= d)'\'' '\''(A || b) && c >= d'\''
OK
$ test-expr '\''(A || b) && (c >= D)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(A || b) && (c >= D)'\'' '\''(A || b) && c >= D'\''
OK
$ test-expr '\''(A || b) && (C >= d)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ diff-expr '\''(A || b) && (C >= d)'\'' '\''(A || b) && C >= d'\''
OK
$ test-expr '\''(A || b) && (C >= D)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ diff-expr '\''(A || b) && (C >= D)'\'' '\''(A || b) && C >= D'\''
OK
$ test-expr '\''(A || B) && (c >= d)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || B) && (c >= d)'\'' '\''(A || B) && c >= d'\''
OK
$ test-expr '\''(A || B) && (c >= D)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || B) && (c >= D)'\'' '\''(A || B) && c >= D'\''
OK
$ test-expr '\''(A || B) && (C >= d)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''(A || B) && (C >= d)'\'' '\''(A || B) && C >= d'\''
OK
$ test-expr '\''(A || B) && (C >= D)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''(A || B) && (C >= D)'\'' '\''(A || B) && C >= D'\''
OK
$ test-expr '\''(a || b) && (c != d)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a || b) && (c != d)'\'' '\''(a || b) && c != d'\''
OK
$ test-expr '\''(a || b) && (c != D)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a || b) && (c != D)'\'' '\''(a || b) && c != D'\''
OK
$ test-expr '\''(a || b) && (C != d)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(a || b) && (C != d)'\'' '\''(a || b) && C != d'\''
OK
$ test-expr '\''(a || b) && (C != D)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(a || b) && (C != D)'\'' '\''(a || b) && C != D'\''
OK
$ test-expr '\''(a || B) && (c != d)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || B) && (c != d)'\'' '\''(a || B) && c != d'\''
OK
$ test-expr '\''(a || B) && (c != D)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || B) && (c != D)'\'' '\''(a || B) && c != D'\''
OK
$ test-expr '\''(a || B) && (C != d)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(a || B) && (C != d)'\'' '\''(a || B) && C != d'\''
OK
$ test-expr '\''(a || B) && (C != D)'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(a || B) && (C != D)'\'' '\''(a || B) && C != D'\''
OK
$ test-expr '\''(A || b) && (c != d)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A || b) && (c != d)'\'' '\''(A || b) && c != d'\''
OK
$ test-expr '\''(A || b) && (c != D)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A || b) && (c != D)'\'' '\''(A || b) && c != D'\''
OK
$ test-expr '\''(A || b) && (C != d)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ diff-expr '\''(A || b) && (C != d)'\'' '\''(A || b) && C != d'\''
OK
$ test-expr '\''(A || b) && (C != D)'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ diff-expr '\''(A || b) && (C != D)'\'' '\''(A || b) && C != D'\''
OK
$ test-expr '\''(A || B) && (c != d)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || B) && (c != d)'\'' '\''(A || B) && c != d'\''
OK
$ test-expr '\''(A || B) && (c != D)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || B) && (c != D)'\'' '\''(A || B) && c != D'\''
OK
$ test-expr '\''(A || B) && (C != d)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''(A || B) && (C != d)'\'' '\''(A || B) && C != d'\''
OK
$ test-expr '\''(A || B) && (C != D)'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''(A || B) && (C != D)'\'' '\''(A || B) && C != D'\''
OK
$ test-expr '\''a && (b != (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (b != (c >= d))'\'' '\''a && b != (c >= d)'\''
OK
$ diff-expr '\''a && (b != (c >= d))'\'' '\''a && b != c >= d'\''
OK
$ diff-expr '\''a && (b != (c >= d))'\'' '\''a && (b != c >= d)'\''
OK
$ test-expr '\''a && (b != (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (b != (c >= D))'\'' '\''a && b != (c >= D)'\''
OK
$ diff-expr '\''a && (b != (c >= D))'\'' '\''a && b != c >= D'\''
OK
$ diff-expr '\''a && (b != (c >= D))'\'' '\''a && (b != c >= D)'\''
OK
$ test-expr '\''a && (b != (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (b != (C >= d))'\'' '\''a && b != (C >= d)'\''
OK
$ diff-expr '\''a && (b != (C >= d))'\'' '\''a && b != C >= d'\''
OK
$ diff-expr '\''a && (b != (C >= d))'\'' '\''a && (b != C >= d)'\''
OK
$ test-expr '\''a && (b != (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (b != (C >= D))'\'' '\''a && b != (C >= D)'\''
OK
$ diff-expr '\''a && (b != (C >= D))'\'' '\''a && b != C >= D'\''
OK
$ diff-expr '\''a && (b != (C >= D))'\'' '\''a && (b != C >= D)'\''
OK
$ test-expr '\''a && (B != (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (B != (c >= d))'\'' '\''a && B != (c >= d)'\''
OK
$ diff-expr '\''a && (B != (c >= d))'\'' '\''a && B != c >= d'\''
OK
$ diff-expr '\''a && (B != (c >= d))'\'' '\''a && (B != c >= d)'\''
OK
$ test-expr '\''a && (B != (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (B != (c >= D))'\'' '\''a && B != (c >= D)'\''
OK
$ diff-expr '\''a && (B != (c >= D))'\'' '\''a && B != c >= D'\''
OK
$ diff-expr '\''a && (B != (c >= D))'\'' '\''a && (B != c >= D)'\''
OK
$ test-expr '\''a && (B != (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (B != (C >= d))'\'' '\''a && B != (C >= d)'\''
OK
$ diff-expr '\''a && (B != (C >= d))'\'' '\''a && B != C >= d'\''
OK
$ diff-expr '\''a && (B != (C >= d))'\'' '\''a && (B != C >= d)'\''
OK
$ test-expr '\''a && (B != (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a && (B != (C >= D))'\'' '\''a && B != (C >= D)'\''
OK
$ diff-expr '\''a && (B != (C >= D))'\'' '\''a && B != C >= D'\''
OK
$ diff-expr '\''a && (B != (C >= D))'\'' '\''a && (B != C >= D)'\''
OK
$ test-expr '\''A && (b != (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (b != (c >= d))'\'' '\''A && b != (c >= d)'\''
OK
$ diff-expr '\''A && (b != (c >= d))'\'' '\''A && b != c >= d'\''
OK
$ diff-expr '\''A && (b != (c >= d))'\'' '\''A && (b != c >= d)'\''
OK
$ test-expr '\''A && (b != (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (b != (c >= D))'\'' '\''A && b != (c >= D)'\''
OK
$ diff-expr '\''A && (b != (c >= D))'\'' '\''A && b != c >= D'\''
OK
$ diff-expr '\''A && (b != (c >= D))'\'' '\''A && (b != c >= D)'\''
OK
$ test-expr '\''A && (b != (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (b != (C >= d))'\'' '\''A && b != (C >= d)'\''
OK
$ diff-expr '\''A && (b != (C >= d))'\'' '\''A && b != C >= d'\''
OK
$ diff-expr '\''A && (b != (C >= d))'\'' '\''A && (b != C >= d)'\''
OK
$ test-expr '\''A && (b != (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (b != (C >= D))'\'' '\''A && b != (C >= D)'\''
OK
$ diff-expr '\''A && (b != (C >= D))'\'' '\''A && b != C >= D'\''
OK
$ diff-expr '\''A && (b != (C >= D))'\'' '\''A && (b != C >= D)'\''
OK
$ test-expr '\''A && (B != (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (B != (c >= d))'\'' '\''A && B != (c >= d)'\''
OK
$ diff-expr '\''A && (B != (c >= d))'\'' '\''A && B != c >= d'\''
OK
$ diff-expr '\''A && (B != (c >= d))'\'' '\''A && (B != c >= d)'\''
OK
$ test-expr '\''A && (B != (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (B != (c >= D))'\'' '\''A && B != (c >= D)'\''
OK
$ diff-expr '\''A && (B != (c >= D))'\'' '\''A && B != c >= D'\''
OK
$ diff-expr '\''A && (B != (c >= D))'\'' '\''A && (B != c >= D)'\''
OK
$ test-expr '\''A && (B != (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (B != (C >= d))'\'' '\''A && B != (C >= d)'\''
OK
$ diff-expr '\''A && (B != (C >= d))'\'' '\''A && B != C >= d'\''
OK
$ diff-expr '\''A && (B != (C >= d))'\'' '\''A && (B != C >= d)'\''
OK
$ test-expr '\''A && (B != (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A && (B != (C >= D))'\'' '\''A && B != (C >= D)'\''
OK
$ diff-expr '\''A && (B != (C >= D))'\'' '\''A && B != C >= D'\''
OK
$ diff-expr '\''A && (B != (C >= D))'\'' '\''A && (B != C >= D)'\''
OK
$ test-expr '\''a || (b != (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (b != (c >= d))'\'' '\''a || b != (c >= d)'\''
OK
$ diff-expr '\''a || (b != (c >= d))'\'' '\''a || b != c >= d'\''
OK
$ diff-expr '\''a || (b != (c >= d))'\'' '\''a || (b != c >= d)'\''
OK
$ test-expr '\''a || (b != (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (b != (c >= D))'\'' '\''a || b != (c >= D)'\''
OK
$ diff-expr '\''a || (b != (c >= D))'\'' '\''a || b != c >= D'\''
OK
$ diff-expr '\''a || (b != (c >= D))'\'' '\''a || (b != c >= D)'\''
OK
$ test-expr '\''a || (b != (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (b != (C >= d))'\'' '\''a || b != (C >= d)'\''
OK
$ diff-expr '\''a || (b != (C >= d))'\'' '\''a || b != C >= d'\''
OK
$ diff-expr '\''a || (b != (C >= d))'\'' '\''a || (b != C >= d)'\''
OK
$ test-expr '\''a || (b != (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (b != (C >= D))'\'' '\''a || b != (C >= D)'\''
OK
$ diff-expr '\''a || (b != (C >= D))'\'' '\''a || b != C >= D'\''
OK
$ diff-expr '\''a || (b != (C >= D))'\'' '\''a || (b != C >= D)'\''
OK
$ test-expr '\''a || (B != (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (B != (c >= d))'\'' '\''a || B != (c >= d)'\''
OK
$ diff-expr '\''a || (B != (c >= d))'\'' '\''a || B != c >= d'\''
OK
$ diff-expr '\''a || (B != (c >= d))'\'' '\''a || (B != c >= d)'\''
OK
$ test-expr '\''a || (B != (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (B != (c >= D))'\'' '\''a || B != (c >= D)'\''
OK
$ diff-expr '\''a || (B != (c >= D))'\'' '\''a || B != c >= D'\''
OK
$ diff-expr '\''a || (B != (c >= D))'\'' '\''a || (B != c >= D)'\''
OK
$ test-expr '\''a || (B != (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (B != (C >= d))'\'' '\''a || B != (C >= d)'\''
OK
$ diff-expr '\''a || (B != (C >= d))'\'' '\''a || B != C >= d'\''
OK
$ diff-expr '\''a || (B != (C >= d))'\'' '\''a || (B != C >= d)'\''
OK
$ test-expr '\''a || (B != (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''a || (B != (C >= D))'\'' '\''a || B != (C >= D)'\''
OK
$ diff-expr '\''a || (B != (C >= D))'\'' '\''a || B != C >= D'\''
OK
$ diff-expr '\''a || (B != (C >= D))'\'' '\''a || (B != C >= D)'\''
OK
$ test-expr '\''A || (b != (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (b != (c >= d))'\'' '\''A || b != (c >= d)'\''
OK
$ diff-expr '\''A || (b != (c >= d))'\'' '\''A || b != c >= d'\''
OK
$ diff-expr '\''A || (b != (c >= d))'\'' '\''A || (b != c >= d)'\''
OK
$ test-expr '\''A || (b != (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (b != (c >= D))'\'' '\''A || b != (c >= D)'\''
OK
$ diff-expr '\''A || (b != (c >= D))'\'' '\''A || b != c >= D'\''
OK
$ diff-expr '\''A || (b != (c >= D))'\'' '\''A || (b != c >= D)'\''
OK
$ test-expr '\''A || (b != (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (b != (C >= d))'\'' '\''A || b != (C >= d)'\''
OK
$ diff-expr '\''A || (b != (C >= d))'\'' '\''A || b != C >= d'\''
OK
$ diff-expr '\''A || (b != (C >= d))'\'' '\''A || (b != C >= d)'\''
OK
$ test-expr '\''A || (b != (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (b != (C >= D))'\'' '\''A || b != (C >= D)'\''
OK
$ diff-expr '\''A || (b != (C >= D))'\'' '\''A || b != C >= D'\''
OK
$ diff-expr '\''A || (b != (C >= D))'\'' '\''A || (b != C >= D)'\''
OK
$ test-expr '\''A || (B != (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (B != (c >= d))'\'' '\''A || B != (c >= d)'\''
OK
$ diff-expr '\''A || (B != (c >= d))'\'' '\''A || B != c >= d'\''
OK
$ diff-expr '\''A || (B != (c >= d))'\'' '\''A || (B != c >= d)'\''
OK
$ test-expr '\''A || (B != (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (B != (c >= D))'\'' '\''A || B != (c >= D)'\''
OK
$ diff-expr '\''A || (B != (c >= D))'\'' '\''A || B != c >= D'\''
OK
$ diff-expr '\''A || (B != (c >= D))'\'' '\''A || (B != c >= D)'\''
OK
$ test-expr '\''A || (B != (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (B != (C >= d))'\'' '\''A || B != (C >= d)'\''
OK
$ diff-expr '\''A || (B != (C >= d))'\'' '\''A || B != C >= d'\''
OK
$ diff-expr '\''A || (B != (C >= d))'\'' '\''A || (B != C >= d)'\''
OK
$ test-expr '\''A || (B != (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
$ diff-expr '\''A || (B != (C >= D))'\'' '\''A || B != (C >= D)'\''
OK
$ diff-expr '\''A || (B != (C >= D))'\'' '\''A || B != C >= D'\''
OK
$ diff-expr '\''A || (B != (C >= D))'\'' '\''A || (B != C >= D)'\''
OK
$ test-expr '\''a || (b && (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || (b && (c >= d))'\'' '\''a || b && (c >= d)'\''
OK
$ diff-expr '\''a || (b && (c >= d))'\'' '\''a || b && c >= d'\''
OK
$ diff-expr '\''a || (b && (c >= d))'\'' '\''a || (b && c >= d)'\''
OK
$ test-expr '\''a || (b && (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (b && (c >= D))'\'' '\''a || b && (c >= D)'\''
OK
$ diff-expr '\''a || (b && (c >= D))'\'' '\''a || b && c >= D'\''
OK
$ diff-expr '\''a || (b && (c >= D))'\'' '\''a || (b && c >= D)'\''
OK
$ test-expr '\''a || (b && (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || (b && (C >= d))'\'' '\''a || b && (C >= d)'\''
OK
$ diff-expr '\''a || (b && (C >= d))'\'' '\''a || b && C >= d'\''
OK
$ diff-expr '\''a || (b && (C >= d))'\'' '\''a || (b && C >= d)'\''
OK
$ test-expr '\''a || (b && (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (b && (C >= D))'\'' '\''a || b && (C >= D)'\''
OK
$ diff-expr '\''a || (b && (C >= D))'\'' '\''a || b && C >= D'\''
OK
$ diff-expr '\''a || (b && (C >= D))'\'' '\''a || (b && C >= D)'\''
OK
$ test-expr '\''a || (B && (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || (B && (c >= d))'\'' '\''a || B && (c >= d)'\''
OK
$ diff-expr '\''a || (B && (c >= d))'\'' '\''a || B && c >= d'\''
OK
$ diff-expr '\''a || (B && (c >= d))'\'' '\''a || (B && c >= d)'\''
OK
$ test-expr '\''a || (B && (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (B && (c >= D))'\'' '\''a || B && (c >= D)'\''
OK
$ diff-expr '\''a || (B && (c >= D))'\'' '\''a || B && c >= D'\''
OK
$ diff-expr '\''a || (B && (c >= D))'\'' '\''a || (B && c >= D)'\''
OK
$ test-expr '\''a || (B && (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''a || (B && (C >= d))'\'' '\''a || B && (C >= d)'\''
OK
$ diff-expr '\''a || (B && (C >= d))'\'' '\''a || B && C >= d'\''
OK
$ diff-expr '\''a || (B && (C >= d))'\'' '\''a || (B && C >= d)'\''
OK
$ test-expr '\''a || (B && (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''a || (B && (C >= D))'\'' '\''a || B && (C >= D)'\''
OK
$ diff-expr '\''a || (B && (C >= D))'\'' '\''a || B && C >= D'\''
OK
$ diff-expr '\''a || (B && (C >= D))'\'' '\''a || (B && C >= D)'\''
OK
$ test-expr '\''A || (b && (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || (b && (c >= d))'\'' '\''A || b && (c >= d)'\''
OK
$ diff-expr '\''A || (b && (c >= d))'\'' '\''A || b && c >= d'\''
OK
$ diff-expr '\''A || (b && (c >= d))'\'' '\''A || (b && c >= d)'\''
OK
$ test-expr '\''A || (b && (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (b && (c >= D))'\'' '\''A || b && (c >= D)'\''
OK
$ diff-expr '\''A || (b && (c >= D))'\'' '\''A || b && c >= D'\''
OK
$ diff-expr '\''A || (b && (c >= D))'\'' '\''A || (b && c >= D)'\''
OK
$ test-expr '\''A || (b && (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || (b && (C >= d))'\'' '\''A || b && (C >= d)'\''
OK
$ diff-expr '\''A || (b && (C >= d))'\'' '\''A || b && C >= d'\''
OK
$ diff-expr '\''A || (b && (C >= d))'\'' '\''A || (b && C >= d)'\''
OK
$ test-expr '\''A || (b && (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (b && (C >= D))'\'' '\''A || b && (C >= D)'\''
OK
$ diff-expr '\''A || (b && (C >= D))'\'' '\''A || b && C >= D'\''
OK
$ diff-expr '\''A || (b && (C >= D))'\'' '\''A || (b && C >= D)'\''
OK
$ test-expr '\''A || (B && (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || (B && (c >= d))'\'' '\''A || B && (c >= d)'\''
OK
$ diff-expr '\''A || (B && (c >= d))'\'' '\''A || B && c >= d'\''
OK
$ diff-expr '\''A || (B && (c >= d))'\'' '\''A || (B && c >= d)'\''
OK
$ test-expr '\''A || (B && (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (B && (c >= D))'\'' '\''A || B && (c >= D)'\''
OK
$ diff-expr '\''A || (B && (c >= D))'\'' '\''A || B && c >= D'\''
OK
$ diff-expr '\''A || (B && (c >= D))'\'' '\''A || (B && c >= D)'\''
OK
$ test-expr '\''A || (B && (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
$ diff-expr '\''A || (B && (C >= d))'\'' '\''A || B && (C >= d)'\''
OK
$ diff-expr '\''A || (B && (C >= d))'\'' '\''A || B && C >= d'\''
OK
$ diff-expr '\''A || (B && (C >= d))'\'' '\''A || (B && C >= d)'\''
OK
$ test-expr '\''A || (B && (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
$ diff-expr '\''A || (B && (C >= D))'\'' '\''A || B && (C >= D)'\''
OK
$ diff-expr '\''A || (B && (C >= D))'\'' '\''A || B && C >= D'\''
OK
$ diff-expr '\''A || (B && (C >= D))'\'' '\''A || (B && C >= D)'\''
OK
$ test-expr '\''a || (b && (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || (b && (c != d))'\'' '\''a || b && (c != d)'\''
OK
$ diff-expr '\''a || (b && (c != d))'\'' '\''a || b && c != d'\''
OK
$ diff-expr '\''a || (b && (c != d))'\'' '\''a || (b && c != d)'\''
OK
$ test-expr '\''a || (b && (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (b && (c != D))'\'' '\''a || b && (c != D)'\''
OK
$ diff-expr '\''a || (b && (c != D))'\'' '\''a || b && c != D'\''
OK
$ diff-expr '\''a || (b && (c != D))'\'' '\''a || (b && c != D)'\''
OK
$ test-expr '\''a || (b && (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || (b && (C != d))'\'' '\''a || b && (C != d)'\''
OK
$ diff-expr '\''a || (b && (C != d))'\'' '\''a || b && C != d'\''
OK
$ diff-expr '\''a || (b && (C != d))'\'' '\''a || (b && C != d)'\''
OK
$ test-expr '\''a || (b && (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (b && (C != D))'\'' '\''a || b && (C != D)'\''
OK
$ diff-expr '\''a || (b && (C != D))'\'' '\''a || b && C != D'\''
OK
$ diff-expr '\''a || (b && (C != D))'\'' '\''a || (b && C != D)'\''
OK
$ test-expr '\''a || (B && (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || (B && (c != d))'\'' '\''a || B && (c != d)'\''
OK
$ diff-expr '\''a || (B && (c != d))'\'' '\''a || B && c != d'\''
OK
$ diff-expr '\''a || (B && (c != d))'\'' '\''a || (B && c != d)'\''
OK
$ test-expr '\''a || (B && (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (B && (c != D))'\'' '\''a || B && (c != D)'\''
OK
$ diff-expr '\''a || (B && (c != D))'\'' '\''a || B && c != D'\''
OK
$ diff-expr '\''a || (B && (c != D))'\'' '\''a || (B && c != D)'\''
OK
$ test-expr '\''a || (B && (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''a || (B && (C != d))'\'' '\''a || B && (C != d)'\''
OK
$ diff-expr '\''a || (B && (C != d))'\'' '\''a || B && C != d'\''
OK
$ diff-expr '\''a || (B && (C != d))'\'' '\''a || (B && C != d)'\''
OK
$ test-expr '\''a || (B && (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''a || (B && (C != D))'\'' '\''a || B && (C != D)'\''
OK
$ diff-expr '\''a || (B && (C != D))'\'' '\''a || B && C != D'\''
OK
$ diff-expr '\''a || (B && (C != D))'\'' '\''a || (B && C != D)'\''
OK
$ test-expr '\''A || (b && (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || (b && (c != d))'\'' '\''A || b && (c != d)'\''
OK
$ diff-expr '\''A || (b && (c != d))'\'' '\''A || b && c != d'\''
OK
$ diff-expr '\''A || (b && (c != d))'\'' '\''A || (b && c != d)'\''
OK
$ test-expr '\''A || (b && (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (b && (c != D))'\'' '\''A || b && (c != D)'\''
OK
$ diff-expr '\''A || (b && (c != D))'\'' '\''A || b && c != D'\''
OK
$ diff-expr '\''A || (b && (c != D))'\'' '\''A || (b && c != D)'\''
OK
$ test-expr '\''A || (b && (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || (b && (C != d))'\'' '\''A || b && (C != d)'\''
OK
$ diff-expr '\''A || (b && (C != d))'\'' '\''A || b && C != d'\''
OK
$ diff-expr '\''A || (b && (C != d))'\'' '\''A || (b && C != d)'\''
OK
$ test-expr '\''A || (b && (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (b && (C != D))'\'' '\''A || b && (C != D)'\''
OK
$ diff-expr '\''A || (b && (C != D))'\'' '\''A || b && C != D'\''
OK
$ diff-expr '\''A || (b && (C != D))'\'' '\''A || (b && C != D)'\''
OK
$ test-expr '\''A || (B && (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || (B && (c != d))'\'' '\''A || B && (c != d)'\''
OK
$ diff-expr '\''A || (B && (c != d))'\'' '\''A || B && c != d'\''
OK
$ diff-expr '\''A || (B && (c != d))'\'' '\''A || (B && c != d)'\''
OK
$ test-expr '\''A || (B && (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (B && (c != D))'\'' '\''A || B && (c != D)'\''
OK
$ diff-expr '\''A || (B && (c != D))'\'' '\''A || B && c != D'\''
OK
$ diff-expr '\''A || (B && (c != D))'\'' '\''A || (B && c != D)'\''
OK
$ test-expr '\''A || (B && (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
$ diff-expr '\''A || (B && (C != d))'\'' '\''A || B && (C != d)'\''
OK
$ diff-expr '\''A || (B && (C != d))'\'' '\''A || B && C != d'\''
OK
$ diff-expr '\''A || (B && (C != d))'\'' '\''A || (B && C != d)'\''
OK
$ test-expr '\''A || (B && (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(eos)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
$ diff-expr '\''A || (B && (C != D))'\'' '\''A || B && (C != D)'\''
OK
$ diff-expr '\''A || (B && (C != D))'\'' '\''A || B && C != D'\''
OK
$ diff-expr '\''A || (B && (C != D))'\'' '\''A || (B && C != D)'\''
OK'
) -L op6.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }'
diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; } 2>&1 ||
echo 'command failed: diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }'

echo '$ test-expr '\''((a >= b) != c) && d'\'''
test-expr '((a >= b) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != c) && d'\'''

echo '$ diff-expr '\''((a >= b) != c) && d'\'' '\''(a >= b) != c && d'\'''
diff-expr '((a >= b) != c) && d' '(a >= b) != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && d'\'' '\''(a >= b) != c && d'\'''

echo '$ diff-expr '\''((a >= b) != c) && d'\'' '\''a >= b != c && d'\'''
diff-expr '((a >= b) != c) && d' 'a >= b != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && d'\'' '\''a >= b != c && d'\'''

echo '$ diff-expr '\''((a >= b) != c) && d'\'' '\''(a >= b != c) && d'\'''
diff-expr '((a >= b) != c) && d' '(a >= b != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && d'\'' '\''(a >= b != c) && d'\'''

echo '$ test-expr '\''((a >= b) != c) && D'\'''
test-expr '((a >= b) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != c) && D'\'''

echo '$ diff-expr '\''((a >= b) != c) && D'\'' '\''(a >= b) != c && D'\'''
diff-expr '((a >= b) != c) && D' '(a >= b) != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && D'\'' '\''(a >= b) != c && D'\'''

echo '$ diff-expr '\''((a >= b) != c) && D'\'' '\''a >= b != c && D'\'''
diff-expr '((a >= b) != c) && D' 'a >= b != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && D'\'' '\''a >= b != c && D'\'''

echo '$ diff-expr '\''((a >= b) != c) && D'\'' '\''(a >= b != c) && D'\'''
diff-expr '((a >= b) != c) && D' '(a >= b != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && D'\'' '\''(a >= b != c) && D'\'''

echo '$ test-expr '\''((a >= b) != C) && d'\'''
test-expr '((a >= b) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != C) && d'\'''

echo '$ diff-expr '\''((a >= b) != C) && d'\'' '\''(a >= b) != C && d'\'''
diff-expr '((a >= b) != C) && d' '(a >= b) != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) && d'\'' '\''(a >= b) != C && d'\'''

echo '$ diff-expr '\''((a >= b) != C) && d'\'' '\''a >= b != C && d'\'''
diff-expr '((a >= b) != C) && d' 'a >= b != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) && d'\'' '\''a >= b != C && d'\'''

echo '$ diff-expr '\''((a >= b) != C) && d'\'' '\''(a >= b != C) && d'\'''
diff-expr '((a >= b) != C) && d' '(a >= b != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) && d'\'' '\''(a >= b != C) && d'\'''

echo '$ test-expr '\''((a >= b) != C) && D'\'''
test-expr '((a >= b) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != C) && D'\'''

echo '$ diff-expr '\''((a >= b) != C) && D'\'' '\''(a >= b) != C && D'\'''
diff-expr '((a >= b) != C) && D' '(a >= b) != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) && D'\'' '\''(a >= b) != C && D'\'''

echo '$ diff-expr '\''((a >= b) != C) && D'\'' '\''a >= b != C && D'\'''
diff-expr '((a >= b) != C) && D' 'a >= b != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) && D'\'' '\''a >= b != C && D'\'''

echo '$ diff-expr '\''((a >= b) != C) && D'\'' '\''(a >= b != C) && D'\'''
diff-expr '((a >= b) != C) && D' '(a >= b != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) && D'\'' '\''(a >= b != C) && D'\'''

echo '$ test-expr '\''((a >= B) != c) && d'\'''
test-expr '((a >= B) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != c) && d'\'''

echo '$ diff-expr '\''((a >= B) != c) && d'\'' '\''(a >= B) != c && d'\'''
diff-expr '((a >= B) != c) && d' '(a >= B) != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) && d'\'' '\''(a >= B) != c && d'\'''

echo '$ diff-expr '\''((a >= B) != c) && d'\'' '\''a >= B != c && d'\'''
diff-expr '((a >= B) != c) && d' 'a >= B != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) && d'\'' '\''a >= B != c && d'\'''

echo '$ diff-expr '\''((a >= B) != c) && d'\'' '\''(a >= B != c) && d'\'''
diff-expr '((a >= B) != c) && d' '(a >= B != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) && d'\'' '\''(a >= B != c) && d'\'''

echo '$ test-expr '\''((a >= B) != c) && D'\'''
test-expr '((a >= B) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != c) && D'\'''

echo '$ diff-expr '\''((a >= B) != c) && D'\'' '\''(a >= B) != c && D'\'''
diff-expr '((a >= B) != c) && D' '(a >= B) != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) && D'\'' '\''(a >= B) != c && D'\'''

echo '$ diff-expr '\''((a >= B) != c) && D'\'' '\''a >= B != c && D'\'''
diff-expr '((a >= B) != c) && D' 'a >= B != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) && D'\'' '\''a >= B != c && D'\'''

echo '$ diff-expr '\''((a >= B) != c) && D'\'' '\''(a >= B != c) && D'\'''
diff-expr '((a >= B) != c) && D' '(a >= B != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) && D'\'' '\''(a >= B != c) && D'\'''

echo '$ test-expr '\''((a >= B) != C) && d'\'''
test-expr '((a >= B) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != C) && d'\'''

echo '$ diff-expr '\''((a >= B) != C) && d'\'' '\''(a >= B) != C && d'\'''
diff-expr '((a >= B) != C) && d' '(a >= B) != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) && d'\'' '\''(a >= B) != C && d'\'''

echo '$ diff-expr '\''((a >= B) != C) && d'\'' '\''a >= B != C && d'\'''
diff-expr '((a >= B) != C) && d' 'a >= B != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) && d'\'' '\''a >= B != C && d'\'''

echo '$ diff-expr '\''((a >= B) != C) && d'\'' '\''(a >= B != C) && d'\'''
diff-expr '((a >= B) != C) && d' '(a >= B != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) && d'\'' '\''(a >= B != C) && d'\'''

echo '$ test-expr '\''((a >= B) != C) && D'\'''
test-expr '((a >= B) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != C) && D'\'''

echo '$ diff-expr '\''((a >= B) != C) && D'\'' '\''(a >= B) != C && D'\'''
diff-expr '((a >= B) != C) && D' '(a >= B) != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) && D'\'' '\''(a >= B) != C && D'\'''

echo '$ diff-expr '\''((a >= B) != C) && D'\'' '\''a >= B != C && D'\'''
diff-expr '((a >= B) != C) && D' 'a >= B != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) && D'\'' '\''a >= B != C && D'\'''

echo '$ diff-expr '\''((a >= B) != C) && D'\'' '\''(a >= B != C) && D'\'''
diff-expr '((a >= B) != C) && D' '(a >= B != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) && D'\'' '\''(a >= B != C) && D'\'''

echo '$ test-expr '\''((A >= b) != c) && d'\'''
test-expr '((A >= b) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != c) && d'\'''

echo '$ diff-expr '\''((A >= b) != c) && d'\'' '\''(A >= b) != c && d'\'''
diff-expr '((A >= b) != c) && d' '(A >= b) != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) && d'\'' '\''(A >= b) != c && d'\'''

echo '$ diff-expr '\''((A >= b) != c) && d'\'' '\''A >= b != c && d'\'''
diff-expr '((A >= b) != c) && d' 'A >= b != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) && d'\'' '\''A >= b != c && d'\'''

echo '$ diff-expr '\''((A >= b) != c) && d'\'' '\''(A >= b != c) && d'\'''
diff-expr '((A >= b) != c) && d' '(A >= b != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) && d'\'' '\''(A >= b != c) && d'\'''

echo '$ test-expr '\''((A >= b) != c) && D'\'''
test-expr '((A >= b) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != c) && D'\'''

echo '$ diff-expr '\''((A >= b) != c) && D'\'' '\''(A >= b) != c && D'\'''
diff-expr '((A >= b) != c) && D' '(A >= b) != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) && D'\'' '\''(A >= b) != c && D'\'''

echo '$ diff-expr '\''((A >= b) != c) && D'\'' '\''A >= b != c && D'\'''
diff-expr '((A >= b) != c) && D' 'A >= b != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) && D'\'' '\''A >= b != c && D'\'''

echo '$ diff-expr '\''((A >= b) != c) && D'\'' '\''(A >= b != c) && D'\'''
diff-expr '((A >= b) != c) && D' '(A >= b != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) && D'\'' '\''(A >= b != c) && D'\'''

echo '$ test-expr '\''((A >= b) != C) && d'\'''
test-expr '((A >= b) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != C) && d'\'''

echo '$ diff-expr '\''((A >= b) != C) && d'\'' '\''(A >= b) != C && d'\'''
diff-expr '((A >= b) != C) && d' '(A >= b) != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) && d'\'' '\''(A >= b) != C && d'\'''

echo '$ diff-expr '\''((A >= b) != C) && d'\'' '\''A >= b != C && d'\'''
diff-expr '((A >= b) != C) && d' 'A >= b != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) && d'\'' '\''A >= b != C && d'\'''

echo '$ diff-expr '\''((A >= b) != C) && d'\'' '\''(A >= b != C) && d'\'''
diff-expr '((A >= b) != C) && d' '(A >= b != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) && d'\'' '\''(A >= b != C) && d'\'''

echo '$ test-expr '\''((A >= b) != C) && D'\'''
test-expr '((A >= b) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != C) && D'\'''

echo '$ diff-expr '\''((A >= b) != C) && D'\'' '\''(A >= b) != C && D'\'''
diff-expr '((A >= b) != C) && D' '(A >= b) != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) && D'\'' '\''(A >= b) != C && D'\'''

echo '$ diff-expr '\''((A >= b) != C) && D'\'' '\''A >= b != C && D'\'''
diff-expr '((A >= b) != C) && D' 'A >= b != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) && D'\'' '\''A >= b != C && D'\'''

echo '$ diff-expr '\''((A >= b) != C) && D'\'' '\''(A >= b != C) && D'\'''
diff-expr '((A >= b) != C) && D' '(A >= b != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) && D'\'' '\''(A >= b != C) && D'\'''

echo '$ test-expr '\''((A >= B) != c) && d'\'''
test-expr '((A >= B) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != c) && d'\'''

echo '$ diff-expr '\''((A >= B) != c) && d'\'' '\''(A >= B) != c && d'\'''
diff-expr '((A >= B) != c) && d' '(A >= B) != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) && d'\'' '\''(A >= B) != c && d'\'''

echo '$ diff-expr '\''((A >= B) != c) && d'\'' '\''A >= B != c && d'\'''
diff-expr '((A >= B) != c) && d' 'A >= B != c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) && d'\'' '\''A >= B != c && d'\'''

echo '$ diff-expr '\''((A >= B) != c) && d'\'' '\''(A >= B != c) && d'\'''
diff-expr '((A >= B) != c) && d' '(A >= B != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) && d'\'' '\''(A >= B != c) && d'\'''

echo '$ test-expr '\''((A >= B) != c) && D'\'''
test-expr '((A >= B) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != c) && D'\'''

echo '$ diff-expr '\''((A >= B) != c) && D'\'' '\''(A >= B) != c && D'\'''
diff-expr '((A >= B) != c) && D' '(A >= B) != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) && D'\'' '\''(A >= B) != c && D'\'''

echo '$ diff-expr '\''((A >= B) != c) && D'\'' '\''A >= B != c && D'\'''
diff-expr '((A >= B) != c) && D' 'A >= B != c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) && D'\'' '\''A >= B != c && D'\'''

echo '$ diff-expr '\''((A >= B) != c) && D'\'' '\''(A >= B != c) && D'\'''
diff-expr '((A >= B) != c) && D' '(A >= B != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) && D'\'' '\''(A >= B != c) && D'\'''

echo '$ test-expr '\''((A >= B) != C) && d'\'''
test-expr '((A >= B) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != C) && d'\'''

echo '$ diff-expr '\''((A >= B) != C) && d'\'' '\''(A >= B) != C && d'\'''
diff-expr '((A >= B) != C) && d' '(A >= B) != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) && d'\'' '\''(A >= B) != C && d'\'''

echo '$ diff-expr '\''((A >= B) != C) && d'\'' '\''A >= B != C && d'\'''
diff-expr '((A >= B) != C) && d' 'A >= B != C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) && d'\'' '\''A >= B != C && d'\'''

echo '$ diff-expr '\''((A >= B) != C) && d'\'' '\''(A >= B != C) && d'\'''
diff-expr '((A >= B) != C) && d' '(A >= B != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) && d'\'' '\''(A >= B != C) && d'\'''

echo '$ test-expr '\''((A >= B) != C) && D'\'''
test-expr '((A >= B) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != C) && D'\'''

echo '$ diff-expr '\''((A >= B) != C) && D'\'' '\''(A >= B) != C && D'\'''
diff-expr '((A >= B) != C) && D' '(A >= B) != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) && D'\'' '\''(A >= B) != C && D'\'''

echo '$ diff-expr '\''((A >= B) != C) && D'\'' '\''A >= B != C && D'\'''
diff-expr '((A >= B) != C) && D' 'A >= B != C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) && D'\'' '\''A >= B != C && D'\'''

echo '$ diff-expr '\''((A >= B) != C) && D'\'' '\''(A >= B != C) && D'\'''
diff-expr '((A >= B) != C) && D' '(A >= B != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) && D'\'' '\''(A >= B != C) && D'\'''

echo '$ test-expr '\''((a >= b) != c) || d'\'''
test-expr '((a >= b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != c) || d'\'''

echo '$ diff-expr '\''((a >= b) != c) || d'\'' '\''(a >= b) != c || d'\'''
diff-expr '((a >= b) != c) || d' '(a >= b) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || d'\'' '\''(a >= b) != c || d'\'''

echo '$ diff-expr '\''((a >= b) != c) || d'\'' '\''a >= b != c || d'\'''
diff-expr '((a >= b) != c) || d' 'a >= b != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || d'\'' '\''a >= b != c || d'\'''

echo '$ diff-expr '\''((a >= b) != c) || d'\'' '\''(a >= b != c) || d'\'''
diff-expr '((a >= b) != c) || d' '(a >= b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || d'\'' '\''(a >= b != c) || d'\'''

echo '$ test-expr '\''((a >= b) != c) || D'\'''
test-expr '((a >= b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != c) || D'\'''

echo '$ diff-expr '\''((a >= b) != c) || D'\'' '\''(a >= b) != c || D'\'''
diff-expr '((a >= b) != c) || D' '(a >= b) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || D'\'' '\''(a >= b) != c || D'\'''

echo '$ diff-expr '\''((a >= b) != c) || D'\'' '\''a >= b != c || D'\'''
diff-expr '((a >= b) != c) || D' 'a >= b != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || D'\'' '\''a >= b != c || D'\'''

echo '$ diff-expr '\''((a >= b) != c) || D'\'' '\''(a >= b != c) || D'\'''
diff-expr '((a >= b) != c) || D' '(a >= b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || D'\'' '\''(a >= b != c) || D'\'''

echo '$ test-expr '\''((a >= b) != C) || d'\'''
test-expr '((a >= b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != C) || d'\'''

echo '$ diff-expr '\''((a >= b) != C) || d'\'' '\''(a >= b) != C || d'\'''
diff-expr '((a >= b) != C) || d' '(a >= b) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) || d'\'' '\''(a >= b) != C || d'\'''

echo '$ diff-expr '\''((a >= b) != C) || d'\'' '\''a >= b != C || d'\'''
diff-expr '((a >= b) != C) || d' 'a >= b != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) || d'\'' '\''a >= b != C || d'\'''

echo '$ diff-expr '\''((a >= b) != C) || d'\'' '\''(a >= b != C) || d'\'''
diff-expr '((a >= b) != C) || d' '(a >= b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) || d'\'' '\''(a >= b != C) || d'\'''

echo '$ test-expr '\''((a >= b) != C) || D'\'''
test-expr '((a >= b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != C) || D'\'''

echo '$ diff-expr '\''((a >= b) != C) || D'\'' '\''(a >= b) != C || D'\'''
diff-expr '((a >= b) != C) || D' '(a >= b) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) || D'\'' '\''(a >= b) != C || D'\'''

echo '$ diff-expr '\''((a >= b) != C) || D'\'' '\''a >= b != C || D'\'''
diff-expr '((a >= b) != C) || D' 'a >= b != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) || D'\'' '\''a >= b != C || D'\'''

echo '$ diff-expr '\''((a >= b) != C) || D'\'' '\''(a >= b != C) || D'\'''
diff-expr '((a >= b) != C) || D' '(a >= b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != C) || D'\'' '\''(a >= b != C) || D'\'''

echo '$ test-expr '\''((a >= B) != c) || d'\'''
test-expr '((a >= B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != c) || d'\'''

echo '$ diff-expr '\''((a >= B) != c) || d'\'' '\''(a >= B) != c || d'\'''
diff-expr '((a >= B) != c) || d' '(a >= B) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) || d'\'' '\''(a >= B) != c || d'\'''

echo '$ diff-expr '\''((a >= B) != c) || d'\'' '\''a >= B != c || d'\'''
diff-expr '((a >= B) != c) || d' 'a >= B != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) || d'\'' '\''a >= B != c || d'\'''

echo '$ diff-expr '\''((a >= B) != c) || d'\'' '\''(a >= B != c) || d'\'''
diff-expr '((a >= B) != c) || d' '(a >= B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) || d'\'' '\''(a >= B != c) || d'\'''

echo '$ test-expr '\''((a >= B) != c) || D'\'''
test-expr '((a >= B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != c) || D'\'''

echo '$ diff-expr '\''((a >= B) != c) || D'\'' '\''(a >= B) != c || D'\'''
diff-expr '((a >= B) != c) || D' '(a >= B) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) || D'\'' '\''(a >= B) != c || D'\'''

echo '$ diff-expr '\''((a >= B) != c) || D'\'' '\''a >= B != c || D'\'''
diff-expr '((a >= B) != c) || D' 'a >= B != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) || D'\'' '\''a >= B != c || D'\'''

echo '$ diff-expr '\''((a >= B) != c) || D'\'' '\''(a >= B != c) || D'\'''
diff-expr '((a >= B) != c) || D' '(a >= B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != c) || D'\'' '\''(a >= B != c) || D'\'''

echo '$ test-expr '\''((a >= B) != C) || d'\'''
test-expr '((a >= B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != C) || d'\'''

echo '$ diff-expr '\''((a >= B) != C) || d'\'' '\''(a >= B) != C || d'\'''
diff-expr '((a >= B) != C) || d' '(a >= B) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) || d'\'' '\''(a >= B) != C || d'\'''

echo '$ diff-expr '\''((a >= B) != C) || d'\'' '\''a >= B != C || d'\'''
diff-expr '((a >= B) != C) || d' 'a >= B != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) || d'\'' '\''a >= B != C || d'\'''

echo '$ diff-expr '\''((a >= B) != C) || d'\'' '\''(a >= B != C) || d'\'''
diff-expr '((a >= B) != C) || d' '(a >= B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) || d'\'' '\''(a >= B != C) || d'\'''

echo '$ test-expr '\''((a >= B) != C) || D'\'''
test-expr '((a >= B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) != C) || D'\'''

echo '$ diff-expr '\''((a >= B) != C) || D'\'' '\''(a >= B) != C || D'\'''
diff-expr '((a >= B) != C) || D' '(a >= B) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) || D'\'' '\''(a >= B) != C || D'\'''

echo '$ diff-expr '\''((a >= B) != C) || D'\'' '\''a >= B != C || D'\'''
diff-expr '((a >= B) != C) || D' 'a >= B != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) || D'\'' '\''a >= B != C || D'\'''

echo '$ diff-expr '\''((a >= B) != C) || D'\'' '\''(a >= B != C) || D'\'''
diff-expr '((a >= B) != C) || D' '(a >= B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) != C) || D'\'' '\''(a >= B != C) || D'\'''

echo '$ test-expr '\''((A >= b) != c) || d'\'''
test-expr '((A >= b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != c) || d'\'''

echo '$ diff-expr '\''((A >= b) != c) || d'\'' '\''(A >= b) != c || d'\'''
diff-expr '((A >= b) != c) || d' '(A >= b) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) || d'\'' '\''(A >= b) != c || d'\'''

echo '$ diff-expr '\''((A >= b) != c) || d'\'' '\''A >= b != c || d'\'''
diff-expr '((A >= b) != c) || d' 'A >= b != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) || d'\'' '\''A >= b != c || d'\'''

echo '$ diff-expr '\''((A >= b) != c) || d'\'' '\''(A >= b != c) || d'\'''
diff-expr '((A >= b) != c) || d' '(A >= b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) || d'\'' '\''(A >= b != c) || d'\'''

echo '$ test-expr '\''((A >= b) != c) || D'\'''
test-expr '((A >= b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != c) || D'\'''

echo '$ diff-expr '\''((A >= b) != c) || D'\'' '\''(A >= b) != c || D'\'''
diff-expr '((A >= b) != c) || D' '(A >= b) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) || D'\'' '\''(A >= b) != c || D'\'''

echo '$ diff-expr '\''((A >= b) != c) || D'\'' '\''A >= b != c || D'\'''
diff-expr '((A >= b) != c) || D' 'A >= b != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) || D'\'' '\''A >= b != c || D'\'''

echo '$ diff-expr '\''((A >= b) != c) || D'\'' '\''(A >= b != c) || D'\'''
diff-expr '((A >= b) != c) || D' '(A >= b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != c) || D'\'' '\''(A >= b != c) || D'\'''

echo '$ test-expr '\''((A >= b) != C) || d'\'''
test-expr '((A >= b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != C) || d'\'''

echo '$ diff-expr '\''((A >= b) != C) || d'\'' '\''(A >= b) != C || d'\'''
diff-expr '((A >= b) != C) || d' '(A >= b) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) || d'\'' '\''(A >= b) != C || d'\'''

echo '$ diff-expr '\''((A >= b) != C) || d'\'' '\''A >= b != C || d'\'''
diff-expr '((A >= b) != C) || d' 'A >= b != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) || d'\'' '\''A >= b != C || d'\'''

echo '$ diff-expr '\''((A >= b) != C) || d'\'' '\''(A >= b != C) || d'\'''
diff-expr '((A >= b) != C) || d' '(A >= b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) || d'\'' '\''(A >= b != C) || d'\'''

echo '$ test-expr '\''((A >= b) != C) || D'\'''
test-expr '((A >= b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) != C) || D'\'''

echo '$ diff-expr '\''((A >= b) != C) || D'\'' '\''(A >= b) != C || D'\'''
diff-expr '((A >= b) != C) || D' '(A >= b) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) || D'\'' '\''(A >= b) != C || D'\'''

echo '$ diff-expr '\''((A >= b) != C) || D'\'' '\''A >= b != C || D'\'''
diff-expr '((A >= b) != C) || D' 'A >= b != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) || D'\'' '\''A >= b != C || D'\'''

echo '$ diff-expr '\''((A >= b) != C) || D'\'' '\''(A >= b != C) || D'\'''
diff-expr '((A >= b) != C) || D' '(A >= b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) != C) || D'\'' '\''(A >= b != C) || D'\'''

echo '$ test-expr '\''((A >= B) != c) || d'\'''
test-expr '((A >= B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != c) || d'\'''

echo '$ diff-expr '\''((A >= B) != c) || d'\'' '\''(A >= B) != c || d'\'''
diff-expr '((A >= B) != c) || d' '(A >= B) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) || d'\'' '\''(A >= B) != c || d'\'''

echo '$ diff-expr '\''((A >= B) != c) || d'\'' '\''A >= B != c || d'\'''
diff-expr '((A >= B) != c) || d' 'A >= B != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) || d'\'' '\''A >= B != c || d'\'''

echo '$ diff-expr '\''((A >= B) != c) || d'\'' '\''(A >= B != c) || d'\'''
diff-expr '((A >= B) != c) || d' '(A >= B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) || d'\'' '\''(A >= B != c) || d'\'''

echo '$ test-expr '\''((A >= B) != c) || D'\'''
test-expr '((A >= B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != c) || D'\'''

echo '$ diff-expr '\''((A >= B) != c) || D'\'' '\''(A >= B) != c || D'\'''
diff-expr '((A >= B) != c) || D' '(A >= B) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) || D'\'' '\''(A >= B) != c || D'\'''

echo '$ diff-expr '\''((A >= B) != c) || D'\'' '\''A >= B != c || D'\'''
diff-expr '((A >= B) != c) || D' 'A >= B != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) || D'\'' '\''A >= B != c || D'\'''

echo '$ diff-expr '\''((A >= B) != c) || D'\'' '\''(A >= B != c) || D'\'''
diff-expr '((A >= B) != c) || D' '(A >= B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != c) || D'\'' '\''(A >= B != c) || D'\'''

echo '$ test-expr '\''((A >= B) != C) || d'\'''
test-expr '((A >= B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != C) || d'\'''

echo '$ diff-expr '\''((A >= B) != C) || d'\'' '\''(A >= B) != C || d'\'''
diff-expr '((A >= B) != C) || d' '(A >= B) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) || d'\'' '\''(A >= B) != C || d'\'''

echo '$ diff-expr '\''((A >= B) != C) || d'\'' '\''A >= B != C || d'\'''
diff-expr '((A >= B) != C) || d' 'A >= B != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) || d'\'' '\''A >= B != C || d'\'''

echo '$ diff-expr '\''((A >= B) != C) || d'\'' '\''(A >= B != C) || d'\'''
diff-expr '((A >= B) != C) || d' '(A >= B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) || d'\'' '\''(A >= B != C) || d'\'''

echo '$ test-expr '\''((A >= B) != C) || D'\'''
test-expr '((A >= B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) != C) || D'\'''

echo '$ diff-expr '\''((A >= B) != C) || D'\'' '\''(A >= B) != C || D'\'''
diff-expr '((A >= B) != C) || D' '(A >= B) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) || D'\'' '\''(A >= B) != C || D'\'''

echo '$ diff-expr '\''((A >= B) != C) || D'\'' '\''A >= B != C || D'\'''
diff-expr '((A >= B) != C) || D' 'A >= B != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) || D'\'' '\''A >= B != C || D'\'''

echo '$ diff-expr '\''((A >= B) != C) || D'\'' '\''(A >= B != C) || D'\'''
diff-expr '((A >= B) != C) || D' '(A >= B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) != C) || D'\'' '\''(A >= B != C) || D'\'''

echo '$ test-expr '\''((a >= b) && c) || d'\'''
test-expr '((a >= b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && c) || d'\'''

echo '$ diff-expr '\''((a >= b) && c) || d'\'' '\''(a >= b) && c || d'\'''
diff-expr '((a >= b) && c) || d' '(a >= b) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || d'\'' '\''(a >= b) && c || d'\'''

echo '$ diff-expr '\''((a >= b) && c) || d'\'' '\''a >= b && c || d'\'''
diff-expr '((a >= b) && c) || d' 'a >= b && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || d'\'' '\''a >= b && c || d'\'''

echo '$ diff-expr '\''((a >= b) && c) || d'\'' '\''(a >= b && c) || d'\'''
diff-expr '((a >= b) && c) || d' '(a >= b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || d'\'' '\''(a >= b && c) || d'\'''

echo '$ test-expr '\''((a >= b) && c) || D'\'''
test-expr '((a >= b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && c) || D'\'''

echo '$ diff-expr '\''((a >= b) && c) || D'\'' '\''(a >= b) && c || D'\'''
diff-expr '((a >= b) && c) || D' '(a >= b) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || D'\'' '\''(a >= b) && c || D'\'''

echo '$ diff-expr '\''((a >= b) && c) || D'\'' '\''a >= b && c || D'\'''
diff-expr '((a >= b) && c) || D' 'a >= b && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || D'\'' '\''a >= b && c || D'\'''

echo '$ diff-expr '\''((a >= b) && c) || D'\'' '\''(a >= b && c) || D'\'''
diff-expr '((a >= b) && c) || D' '(a >= b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || D'\'' '\''(a >= b && c) || D'\'''

echo '$ test-expr '\''((a >= b) && C) || d'\'''
test-expr '((a >= b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && C) || d'\'''

echo '$ diff-expr '\''((a >= b) && C) || d'\'' '\''(a >= b) && C || d'\'''
diff-expr '((a >= b) && C) || d' '(a >= b) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) || d'\'' '\''(a >= b) && C || d'\'''

echo '$ diff-expr '\''((a >= b) && C) || d'\'' '\''a >= b && C || d'\'''
diff-expr '((a >= b) && C) || d' 'a >= b && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) || d'\'' '\''a >= b && C || d'\'''

echo '$ diff-expr '\''((a >= b) && C) || d'\'' '\''(a >= b && C) || d'\'''
diff-expr '((a >= b) && C) || d' '(a >= b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) || d'\'' '\''(a >= b && C) || d'\'''

echo '$ test-expr '\''((a >= b) && C) || D'\'''
test-expr '((a >= b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && C) || D'\'''

echo '$ diff-expr '\''((a >= b) && C) || D'\'' '\''(a >= b) && C || D'\'''
diff-expr '((a >= b) && C) || D' '(a >= b) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) || D'\'' '\''(a >= b) && C || D'\'''

echo '$ diff-expr '\''((a >= b) && C) || D'\'' '\''a >= b && C || D'\'''
diff-expr '((a >= b) && C) || D' 'a >= b && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) || D'\'' '\''a >= b && C || D'\'''

echo '$ diff-expr '\''((a >= b) && C) || D'\'' '\''(a >= b && C) || D'\'''
diff-expr '((a >= b) && C) || D' '(a >= b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) || D'\'' '\''(a >= b && C) || D'\'''

echo '$ test-expr '\''((a >= B) && c) || d'\'''
test-expr '((a >= B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && c) || d'\'''

echo '$ diff-expr '\''((a >= B) && c) || d'\'' '\''(a >= B) && c || d'\'''
diff-expr '((a >= B) && c) || d' '(a >= B) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) || d'\'' '\''(a >= B) && c || d'\'''

echo '$ diff-expr '\''((a >= B) && c) || d'\'' '\''a >= B && c || d'\'''
diff-expr '((a >= B) && c) || d' 'a >= B && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) || d'\'' '\''a >= B && c || d'\'''

echo '$ diff-expr '\''((a >= B) && c) || d'\'' '\''(a >= B && c) || d'\'''
diff-expr '((a >= B) && c) || d' '(a >= B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) || d'\'' '\''(a >= B && c) || d'\'''

echo '$ test-expr '\''((a >= B) && c) || D'\'''
test-expr '((a >= B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && c) || D'\'''

echo '$ diff-expr '\''((a >= B) && c) || D'\'' '\''(a >= B) && c || D'\'''
diff-expr '((a >= B) && c) || D' '(a >= B) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) || D'\'' '\''(a >= B) && c || D'\'''

echo '$ diff-expr '\''((a >= B) && c) || D'\'' '\''a >= B && c || D'\'''
diff-expr '((a >= B) && c) || D' 'a >= B && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) || D'\'' '\''a >= B && c || D'\'''

echo '$ diff-expr '\''((a >= B) && c) || D'\'' '\''(a >= B && c) || D'\'''
diff-expr '((a >= B) && c) || D' '(a >= B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) || D'\'' '\''(a >= B && c) || D'\'''

echo '$ test-expr '\''((a >= B) && C) || d'\'''
test-expr '((a >= B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && C) || d'\'''

echo '$ diff-expr '\''((a >= B) && C) || d'\'' '\''(a >= B) && C || d'\'''
diff-expr '((a >= B) && C) || d' '(a >= B) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) || d'\'' '\''(a >= B) && C || d'\'''

echo '$ diff-expr '\''((a >= B) && C) || d'\'' '\''a >= B && C || d'\'''
diff-expr '((a >= B) && C) || d' 'a >= B && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) || d'\'' '\''a >= B && C || d'\'''

echo '$ diff-expr '\''((a >= B) && C) || d'\'' '\''(a >= B && C) || d'\'''
diff-expr '((a >= B) && C) || d' '(a >= B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) || d'\'' '\''(a >= B && C) || d'\'''

echo '$ test-expr '\''((a >= B) && C) || D'\'''
test-expr '((a >= B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && C) || D'\'''

echo '$ diff-expr '\''((a >= B) && C) || D'\'' '\''(a >= B) && C || D'\'''
diff-expr '((a >= B) && C) || D' '(a >= B) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) || D'\'' '\''(a >= B) && C || D'\'''

echo '$ diff-expr '\''((a >= B) && C) || D'\'' '\''a >= B && C || D'\'''
diff-expr '((a >= B) && C) || D' 'a >= B && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) || D'\'' '\''a >= B && C || D'\'''

echo '$ diff-expr '\''((a >= B) && C) || D'\'' '\''(a >= B && C) || D'\'''
diff-expr '((a >= B) && C) || D' '(a >= B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) || D'\'' '\''(a >= B && C) || D'\'''

echo '$ test-expr '\''((A >= b) && c) || d'\'''
test-expr '((A >= b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && c) || d'\'''

echo '$ diff-expr '\''((A >= b) && c) || d'\'' '\''(A >= b) && c || d'\'''
diff-expr '((A >= b) && c) || d' '(A >= b) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) || d'\'' '\''(A >= b) && c || d'\'''

echo '$ diff-expr '\''((A >= b) && c) || d'\'' '\''A >= b && c || d'\'''
diff-expr '((A >= b) && c) || d' 'A >= b && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) || d'\'' '\''A >= b && c || d'\'''

echo '$ diff-expr '\''((A >= b) && c) || d'\'' '\''(A >= b && c) || d'\'''
diff-expr '((A >= b) && c) || d' '(A >= b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) || d'\'' '\''(A >= b && c) || d'\'''

echo '$ test-expr '\''((A >= b) && c) || D'\'''
test-expr '((A >= b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && c) || D'\'''

echo '$ diff-expr '\''((A >= b) && c) || D'\'' '\''(A >= b) && c || D'\'''
diff-expr '((A >= b) && c) || D' '(A >= b) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) || D'\'' '\''(A >= b) && c || D'\'''

echo '$ diff-expr '\''((A >= b) && c) || D'\'' '\''A >= b && c || D'\'''
diff-expr '((A >= b) && c) || D' 'A >= b && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) || D'\'' '\''A >= b && c || D'\'''

echo '$ diff-expr '\''((A >= b) && c) || D'\'' '\''(A >= b && c) || D'\'''
diff-expr '((A >= b) && c) || D' '(A >= b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) || D'\'' '\''(A >= b && c) || D'\'''

echo '$ test-expr '\''((A >= b) && C) || d'\'''
test-expr '((A >= b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && C) || d'\'''

echo '$ diff-expr '\''((A >= b) && C) || d'\'' '\''(A >= b) && C || d'\'''
diff-expr '((A >= b) && C) || d' '(A >= b) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) || d'\'' '\''(A >= b) && C || d'\'''

echo '$ diff-expr '\''((A >= b) && C) || d'\'' '\''A >= b && C || d'\'''
diff-expr '((A >= b) && C) || d' 'A >= b && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) || d'\'' '\''A >= b && C || d'\'''

echo '$ diff-expr '\''((A >= b) && C) || d'\'' '\''(A >= b && C) || d'\'''
diff-expr '((A >= b) && C) || d' '(A >= b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) || d'\'' '\''(A >= b && C) || d'\'''

echo '$ test-expr '\''((A >= b) && C) || D'\'''
test-expr '((A >= b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && C) || D'\'''

echo '$ diff-expr '\''((A >= b) && C) || D'\'' '\''(A >= b) && C || D'\'''
diff-expr '((A >= b) && C) || D' '(A >= b) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) || D'\'' '\''(A >= b) && C || D'\'''

echo '$ diff-expr '\''((A >= b) && C) || D'\'' '\''A >= b && C || D'\'''
diff-expr '((A >= b) && C) || D' 'A >= b && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) || D'\'' '\''A >= b && C || D'\'''

echo '$ diff-expr '\''((A >= b) && C) || D'\'' '\''(A >= b && C) || D'\'''
diff-expr '((A >= b) && C) || D' '(A >= b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) || D'\'' '\''(A >= b && C) || D'\'''

echo '$ test-expr '\''((A >= B) && c) || d'\'''
test-expr '((A >= B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && c) || d'\'''

echo '$ diff-expr '\''((A >= B) && c) || d'\'' '\''(A >= B) && c || d'\'''
diff-expr '((A >= B) && c) || d' '(A >= B) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) || d'\'' '\''(A >= B) && c || d'\'''

echo '$ diff-expr '\''((A >= B) && c) || d'\'' '\''A >= B && c || d'\'''
diff-expr '((A >= B) && c) || d' 'A >= B && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) || d'\'' '\''A >= B && c || d'\'''

echo '$ diff-expr '\''((A >= B) && c) || d'\'' '\''(A >= B && c) || d'\'''
diff-expr '((A >= B) && c) || d' '(A >= B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) || d'\'' '\''(A >= B && c) || d'\'''

echo '$ test-expr '\''((A >= B) && c) || D'\'''
test-expr '((A >= B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && c) || D'\'''

echo '$ diff-expr '\''((A >= B) && c) || D'\'' '\''(A >= B) && c || D'\'''
diff-expr '((A >= B) && c) || D' '(A >= B) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) || D'\'' '\''(A >= B) && c || D'\'''

echo '$ diff-expr '\''((A >= B) && c) || D'\'' '\''A >= B && c || D'\'''
diff-expr '((A >= B) && c) || D' 'A >= B && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) || D'\'' '\''A >= B && c || D'\'''

echo '$ diff-expr '\''((A >= B) && c) || D'\'' '\''(A >= B && c) || D'\'''
diff-expr '((A >= B) && c) || D' '(A >= B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) || D'\'' '\''(A >= B && c) || D'\'''

echo '$ test-expr '\''((A >= B) && C) || d'\'''
test-expr '((A >= B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && C) || d'\'''

echo '$ diff-expr '\''((A >= B) && C) || d'\'' '\''(A >= B) && C || d'\'''
diff-expr '((A >= B) && C) || d' '(A >= B) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) || d'\'' '\''(A >= B) && C || d'\'''

echo '$ diff-expr '\''((A >= B) && C) || d'\'' '\''A >= B && C || d'\'''
diff-expr '((A >= B) && C) || d' 'A >= B && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) || d'\'' '\''A >= B && C || d'\'''

echo '$ diff-expr '\''((A >= B) && C) || d'\'' '\''(A >= B && C) || d'\'''
diff-expr '((A >= B) && C) || d' '(A >= B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) || d'\'' '\''(A >= B && C) || d'\'''

echo '$ test-expr '\''((A >= B) && C) || D'\'''
test-expr '((A >= B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && C) || D'\'''

echo '$ diff-expr '\''((A >= B) && C) || D'\'' '\''(A >= B) && C || D'\'''
diff-expr '((A >= B) && C) || D' '(A >= B) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) || D'\'' '\''(A >= B) && C || D'\'''

echo '$ diff-expr '\''((A >= B) && C) || D'\'' '\''A >= B && C || D'\'''
diff-expr '((A >= B) && C) || D' 'A >= B && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) || D'\'' '\''A >= B && C || D'\'''

echo '$ diff-expr '\''((A >= B) && C) || D'\'' '\''(A >= B && C) || D'\'''
diff-expr '((A >= B) && C) || D' '(A >= B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) || D'\'' '\''(A >= B && C) || D'\'''

echo '$ test-expr '\''((a != b) && c) || d'\'''
test-expr '((a != b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && c) || d'\'''

echo '$ diff-expr '\''((a != b) && c) || d'\'' '\''(a != b) && c || d'\'''
diff-expr '((a != b) && c) || d' '(a != b) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || d'\'' '\''(a != b) && c || d'\'''

echo '$ diff-expr '\''((a != b) && c) || d'\'' '\''a != b && c || d'\'''
diff-expr '((a != b) && c) || d' 'a != b && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || d'\'' '\''a != b && c || d'\'''

echo '$ diff-expr '\''((a != b) && c) || d'\'' '\''(a != b && c) || d'\'''
diff-expr '((a != b) && c) || d' '(a != b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || d'\'' '\''(a != b && c) || d'\'''

echo '$ test-expr '\''((a != b) && c) || D'\'''
test-expr '((a != b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && c) || D'\'''

echo '$ diff-expr '\''((a != b) && c) || D'\'' '\''(a != b) && c || D'\'''
diff-expr '((a != b) && c) || D' '(a != b) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || D'\'' '\''(a != b) && c || D'\'''

echo '$ diff-expr '\''((a != b) && c) || D'\'' '\''a != b && c || D'\'''
diff-expr '((a != b) && c) || D' 'a != b && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || D'\'' '\''a != b && c || D'\'''

echo '$ diff-expr '\''((a != b) && c) || D'\'' '\''(a != b && c) || D'\'''
diff-expr '((a != b) && c) || D' '(a != b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || D'\'' '\''(a != b && c) || D'\'''

echo '$ test-expr '\''((a != b) && C) || d'\'''
test-expr '((a != b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && C) || d'\'''

echo '$ diff-expr '\''((a != b) && C) || d'\'' '\''(a != b) && C || d'\'''
diff-expr '((a != b) && C) || d' '(a != b) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) || d'\'' '\''(a != b) && C || d'\'''

echo '$ diff-expr '\''((a != b) && C) || d'\'' '\''a != b && C || d'\'''
diff-expr '((a != b) && C) || d' 'a != b && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) || d'\'' '\''a != b && C || d'\'''

echo '$ diff-expr '\''((a != b) && C) || d'\'' '\''(a != b && C) || d'\'''
diff-expr '((a != b) && C) || d' '(a != b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) || d'\'' '\''(a != b && C) || d'\'''

echo '$ test-expr '\''((a != b) && C) || D'\'''
test-expr '((a != b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && C) || D'\'''

echo '$ diff-expr '\''((a != b) && C) || D'\'' '\''(a != b) && C || D'\'''
diff-expr '((a != b) && C) || D' '(a != b) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) || D'\'' '\''(a != b) && C || D'\'''

echo '$ diff-expr '\''((a != b) && C) || D'\'' '\''a != b && C || D'\'''
diff-expr '((a != b) && C) || D' 'a != b && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) || D'\'' '\''a != b && C || D'\'''

echo '$ diff-expr '\''((a != b) && C) || D'\'' '\''(a != b && C) || D'\'''
diff-expr '((a != b) && C) || D' '(a != b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) || D'\'' '\''(a != b && C) || D'\'''

echo '$ test-expr '\''((a != B) && c) || d'\'''
test-expr '((a != B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && c) || d'\'''

echo '$ diff-expr '\''((a != B) && c) || d'\'' '\''(a != B) && c || d'\'''
diff-expr '((a != B) && c) || d' '(a != B) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) || d'\'' '\''(a != B) && c || d'\'''

echo '$ diff-expr '\''((a != B) && c) || d'\'' '\''a != B && c || d'\'''
diff-expr '((a != B) && c) || d' 'a != B && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) || d'\'' '\''a != B && c || d'\'''

echo '$ diff-expr '\''((a != B) && c) || d'\'' '\''(a != B && c) || d'\'''
diff-expr '((a != B) && c) || d' '(a != B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) || d'\'' '\''(a != B && c) || d'\'''

echo '$ test-expr '\''((a != B) && c) || D'\'''
test-expr '((a != B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && c) || D'\'''

echo '$ diff-expr '\''((a != B) && c) || D'\'' '\''(a != B) && c || D'\'''
diff-expr '((a != B) && c) || D' '(a != B) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) || D'\'' '\''(a != B) && c || D'\'''

echo '$ diff-expr '\''((a != B) && c) || D'\'' '\''a != B && c || D'\'''
diff-expr '((a != B) && c) || D' 'a != B && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) || D'\'' '\''a != B && c || D'\'''

echo '$ diff-expr '\''((a != B) && c) || D'\'' '\''(a != B && c) || D'\'''
diff-expr '((a != B) && c) || D' '(a != B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) || D'\'' '\''(a != B && c) || D'\'''

echo '$ test-expr '\''((a != B) && C) || d'\'''
test-expr '((a != B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && C) || d'\'''

echo '$ diff-expr '\''((a != B) && C) || d'\'' '\''(a != B) && C || d'\'''
diff-expr '((a != B) && C) || d' '(a != B) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) || d'\'' '\''(a != B) && C || d'\'''

echo '$ diff-expr '\''((a != B) && C) || d'\'' '\''a != B && C || d'\'''
diff-expr '((a != B) && C) || d' 'a != B && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) || d'\'' '\''a != B && C || d'\'''

echo '$ diff-expr '\''((a != B) && C) || d'\'' '\''(a != B && C) || d'\'''
diff-expr '((a != B) && C) || d' '(a != B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) || d'\'' '\''(a != B && C) || d'\'''

echo '$ test-expr '\''((a != B) && C) || D'\'''
test-expr '((a != B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && C) || D'\'''

echo '$ diff-expr '\''((a != B) && C) || D'\'' '\''(a != B) && C || D'\'''
diff-expr '((a != B) && C) || D' '(a != B) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) || D'\'' '\''(a != B) && C || D'\'''

echo '$ diff-expr '\''((a != B) && C) || D'\'' '\''a != B && C || D'\'''
diff-expr '((a != B) && C) || D' 'a != B && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) || D'\'' '\''a != B && C || D'\'''

echo '$ diff-expr '\''((a != B) && C) || D'\'' '\''(a != B && C) || D'\'''
diff-expr '((a != B) && C) || D' '(a != B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) || D'\'' '\''(a != B && C) || D'\'''

echo '$ test-expr '\''((A != b) && c) || d'\'''
test-expr '((A != b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && c) || d'\'''

echo '$ diff-expr '\''((A != b) && c) || d'\'' '\''(A != b) && c || d'\'''
diff-expr '((A != b) && c) || d' '(A != b) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) || d'\'' '\''(A != b) && c || d'\'''

echo '$ diff-expr '\''((A != b) && c) || d'\'' '\''A != b && c || d'\'''
diff-expr '((A != b) && c) || d' 'A != b && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) || d'\'' '\''A != b && c || d'\'''

echo '$ diff-expr '\''((A != b) && c) || d'\'' '\''(A != b && c) || d'\'''
diff-expr '((A != b) && c) || d' '(A != b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) || d'\'' '\''(A != b && c) || d'\'''

echo '$ test-expr '\''((A != b) && c) || D'\'''
test-expr '((A != b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && c) || D'\'''

echo '$ diff-expr '\''((A != b) && c) || D'\'' '\''(A != b) && c || D'\'''
diff-expr '((A != b) && c) || D' '(A != b) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) || D'\'' '\''(A != b) && c || D'\'''

echo '$ diff-expr '\''((A != b) && c) || D'\'' '\''A != b && c || D'\'''
diff-expr '((A != b) && c) || D' 'A != b && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) || D'\'' '\''A != b && c || D'\'''

echo '$ diff-expr '\''((A != b) && c) || D'\'' '\''(A != b && c) || D'\'''
diff-expr '((A != b) && c) || D' '(A != b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) || D'\'' '\''(A != b && c) || D'\'''

echo '$ test-expr '\''((A != b) && C) || d'\'''
test-expr '((A != b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && C) || d'\'''

echo '$ diff-expr '\''((A != b) && C) || d'\'' '\''(A != b) && C || d'\'''
diff-expr '((A != b) && C) || d' '(A != b) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) || d'\'' '\''(A != b) && C || d'\'''

echo '$ diff-expr '\''((A != b) && C) || d'\'' '\''A != b && C || d'\'''
diff-expr '((A != b) && C) || d' 'A != b && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) || d'\'' '\''A != b && C || d'\'''

echo '$ diff-expr '\''((A != b) && C) || d'\'' '\''(A != b && C) || d'\'''
diff-expr '((A != b) && C) || d' '(A != b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) || d'\'' '\''(A != b && C) || d'\'''

echo '$ test-expr '\''((A != b) && C) || D'\'''
test-expr '((A != b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && C) || D'\'''

echo '$ diff-expr '\''((A != b) && C) || D'\'' '\''(A != b) && C || D'\'''
diff-expr '((A != b) && C) || D' '(A != b) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) || D'\'' '\''(A != b) && C || D'\'''

echo '$ diff-expr '\''((A != b) && C) || D'\'' '\''A != b && C || D'\'''
diff-expr '((A != b) && C) || D' 'A != b && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) || D'\'' '\''A != b && C || D'\'''

echo '$ diff-expr '\''((A != b) && C) || D'\'' '\''(A != b && C) || D'\'''
diff-expr '((A != b) && C) || D' '(A != b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) || D'\'' '\''(A != b && C) || D'\'''

echo '$ test-expr '\''((A != B) && c) || d'\'''
test-expr '((A != B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && c) || d'\'''

echo '$ diff-expr '\''((A != B) && c) || d'\'' '\''(A != B) && c || d'\'''
diff-expr '((A != B) && c) || d' '(A != B) && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) || d'\'' '\''(A != B) && c || d'\'''

echo '$ diff-expr '\''((A != B) && c) || d'\'' '\''A != B && c || d'\'''
diff-expr '((A != B) && c) || d' 'A != B && c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) || d'\'' '\''A != B && c || d'\'''

echo '$ diff-expr '\''((A != B) && c) || d'\'' '\''(A != B && c) || d'\'''
diff-expr '((A != B) && c) || d' '(A != B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) || d'\'' '\''(A != B && c) || d'\'''

echo '$ test-expr '\''((A != B) && c) || D'\'''
test-expr '((A != B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && c) || D'\'''

echo '$ diff-expr '\''((A != B) && c) || D'\'' '\''(A != B) && c || D'\'''
diff-expr '((A != B) && c) || D' '(A != B) && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) || D'\'' '\''(A != B) && c || D'\'''

echo '$ diff-expr '\''((A != B) && c) || D'\'' '\''A != B && c || D'\'''
diff-expr '((A != B) && c) || D' 'A != B && c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) || D'\'' '\''A != B && c || D'\'''

echo '$ diff-expr '\''((A != B) && c) || D'\'' '\''(A != B && c) || D'\'''
diff-expr '((A != B) && c) || D' '(A != B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) || D'\'' '\''(A != B && c) || D'\'''

echo '$ test-expr '\''((A != B) && C) || d'\'''
test-expr '((A != B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && C) || d'\'''

echo '$ diff-expr '\''((A != B) && C) || d'\'' '\''(A != B) && C || d'\'''
diff-expr '((A != B) && C) || d' '(A != B) && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) || d'\'' '\''(A != B) && C || d'\'''

echo '$ diff-expr '\''((A != B) && C) || d'\'' '\''A != B && C || d'\'''
diff-expr '((A != B) && C) || d' 'A != B && C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) || d'\'' '\''A != B && C || d'\'''

echo '$ diff-expr '\''((A != B) && C) || d'\'' '\''(A != B && C) || d'\'''
diff-expr '((A != B) && C) || d' '(A != B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) || d'\'' '\''(A != B && C) || d'\'''

echo '$ test-expr '\''((A != B) && C) || D'\'''
test-expr '((A != B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && C) || D'\'''

echo '$ diff-expr '\''((A != B) && C) || D'\'' '\''(A != B) && C || D'\'''
diff-expr '((A != B) && C) || D' '(A != B) && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) || D'\'' '\''(A != B) && C || D'\'''

echo '$ diff-expr '\''((A != B) && C) || D'\'' '\''A != B && C || D'\'''
diff-expr '((A != B) && C) || D' 'A != B && C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) || D'\'' '\''A != B && C || D'\'''

echo '$ diff-expr '\''((A != B) && C) || D'\'' '\''(A != B && C) || D'\'''
diff-expr '((A != B) && C) || D' '(A != B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) || D'\'' '\''(A != B && C) || D'\'''

echo '$ test-expr '\''a >= ((b != c) && d)'\'''
test-expr 'a >= ((b != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != c) && d)'\'''

echo '$ diff-expr '\''a >= ((b != c) && d)'\'' '\''a >= (b != c && d)'\'''
diff-expr 'a >= ((b != c) && d)' 'a >= (b != c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) && d)'\'' '\''a >= (b != c && d)'\'''

echo '$ test-expr '\''a >= ((b != c) && D)'\'''
test-expr 'a >= ((b != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != c) && D)'\'''

echo '$ diff-expr '\''a >= ((b != c) && D)'\'' '\''a >= (b != c && D)'\'''
diff-expr 'a >= ((b != c) && D)' 'a >= (b != c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) && D)'\'' '\''a >= (b != c && D)'\'''

echo '$ test-expr '\''a >= ((b != C) && d)'\'''
test-expr 'a >= ((b != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != C) && d)'\'''

echo '$ diff-expr '\''a >= ((b != C) && d)'\'' '\''a >= (b != C && d)'\'''
diff-expr 'a >= ((b != C) && d)' 'a >= (b != C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != C) && d)'\'' '\''a >= (b != C && d)'\'''

echo '$ test-expr '\''a >= ((b != C) && D)'\'''
test-expr 'a >= ((b != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != C) && D)'\'''

echo '$ diff-expr '\''a >= ((b != C) && D)'\'' '\''a >= (b != C && D)'\'''
diff-expr 'a >= ((b != C) && D)' 'a >= (b != C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != C) && D)'\'' '\''a >= (b != C && D)'\'''

echo '$ test-expr '\''a >= ((B != c) && d)'\'''
test-expr 'a >= ((B != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != c) && d)'\'''

echo '$ diff-expr '\''a >= ((B != c) && d)'\'' '\''a >= (B != c && d)'\'''
diff-expr 'a >= ((B != c) && d)' 'a >= (B != c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != c) && d)'\'' '\''a >= (B != c && d)'\'''

echo '$ test-expr '\''a >= ((B != c) && D)'\'''
test-expr 'a >= ((B != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != c) && D)'\'''

echo '$ diff-expr '\''a >= ((B != c) && D)'\'' '\''a >= (B != c && D)'\'''
diff-expr 'a >= ((B != c) && D)' 'a >= (B != c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != c) && D)'\'' '\''a >= (B != c && D)'\'''

echo '$ test-expr '\''a >= ((B != C) && d)'\'''
test-expr 'a >= ((B != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != C) && d)'\'''

echo '$ diff-expr '\''a >= ((B != C) && d)'\'' '\''a >= (B != C && d)'\'''
diff-expr 'a >= ((B != C) && d)' 'a >= (B != C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != C) && d)'\'' '\''a >= (B != C && d)'\'''

echo '$ test-expr '\''a >= ((B != C) && D)'\'''
test-expr 'a >= ((B != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != C) && D)'\'''

echo '$ diff-expr '\''a >= ((B != C) && D)'\'' '\''a >= (B != C && D)'\'''
diff-expr 'a >= ((B != C) && D)' 'a >= (B != C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != C) && D)'\'' '\''a >= (B != C && D)'\'''

echo '$ test-expr '\''A >= ((b != c) && d)'\'''
test-expr 'A >= ((b != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != c) && d)'\'''

echo '$ diff-expr '\''A >= ((b != c) && d)'\'' '\''A >= (b != c && d)'\'''
diff-expr 'A >= ((b != c) && d)' 'A >= (b != c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != c) && d)'\'' '\''A >= (b != c && d)'\'''

echo '$ test-expr '\''A >= ((b != c) && D)'\'''
test-expr 'A >= ((b != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != c) && D)'\'''

echo '$ diff-expr '\''A >= ((b != c) && D)'\'' '\''A >= (b != c && D)'\'''
diff-expr 'A >= ((b != c) && D)' 'A >= (b != c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != c) && D)'\'' '\''A >= (b != c && D)'\'''

echo '$ test-expr '\''A >= ((b != C) && d)'\'''
test-expr 'A >= ((b != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != C) && d)'\'''

echo '$ diff-expr '\''A >= ((b != C) && d)'\'' '\''A >= (b != C && d)'\'''
diff-expr 'A >= ((b != C) && d)' 'A >= (b != C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != C) && d)'\'' '\''A >= (b != C && d)'\'''

echo '$ test-expr '\''A >= ((b != C) && D)'\'''
test-expr 'A >= ((b != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != C) && D)'\'''

echo '$ diff-expr '\''A >= ((b != C) && D)'\'' '\''A >= (b != C && D)'\'''
diff-expr 'A >= ((b != C) && D)' 'A >= (b != C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != C) && D)'\'' '\''A >= (b != C && D)'\'''

echo '$ test-expr '\''A >= ((B != c) && d)'\'''
test-expr 'A >= ((B != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != c) && d)'\'''

echo '$ diff-expr '\''A >= ((B != c) && d)'\'' '\''A >= (B != c && d)'\'''
diff-expr 'A >= ((B != c) && d)' 'A >= (B != c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != c) && d)'\'' '\''A >= (B != c && d)'\'''

echo '$ test-expr '\''A >= ((B != c) && D)'\'''
test-expr 'A >= ((B != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != c) && D)'\'''

echo '$ diff-expr '\''A >= ((B != c) && D)'\'' '\''A >= (B != c && D)'\'''
diff-expr 'A >= ((B != c) && D)' 'A >= (B != c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != c) && D)'\'' '\''A >= (B != c && D)'\'''

echo '$ test-expr '\''A >= ((B != C) && d)'\'''
test-expr 'A >= ((B != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != C) && d)'\'''

echo '$ diff-expr '\''A >= ((B != C) && d)'\'' '\''A >= (B != C && d)'\'''
diff-expr 'A >= ((B != C) && d)' 'A >= (B != C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != C) && d)'\'' '\''A >= (B != C && d)'\'''

echo '$ test-expr '\''A >= ((B != C) && D)'\'''
test-expr 'A >= ((B != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != C) && D)'\'''

echo '$ diff-expr '\''A >= ((B != C) && D)'\'' '\''A >= (B != C && D)'\'''
diff-expr 'A >= ((B != C) && D)' 'A >= (B != C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != C) && D)'\'' '\''A >= (B != C && D)'\'''

echo '$ test-expr '\''a >= ((b != c) || d)'\'''
test-expr 'a >= ((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != c) || d)'\'''

echo '$ diff-expr '\''a >= ((b != c) || d)'\'' '\''a >= (b != c || d)'\'''
diff-expr 'a >= ((b != c) || d)' 'a >= (b != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) || d)'\'' '\''a >= (b != c || d)'\'''

echo '$ test-expr '\''a >= ((b != c) || D)'\'''
test-expr 'a >= ((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != c) || D)'\'''

echo '$ diff-expr '\''a >= ((b != c) || D)'\'' '\''a >= (b != c || D)'\'''
diff-expr 'a >= ((b != c) || D)' 'a >= (b != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) || D)'\'' '\''a >= (b != c || D)'\'''

echo '$ test-expr '\''a >= ((b != C) || d)'\'''
test-expr 'a >= ((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != C) || d)'\'''

echo '$ diff-expr '\''a >= ((b != C) || d)'\'' '\''a >= (b != C || d)'\'''
diff-expr 'a >= ((b != C) || d)' 'a >= (b != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != C) || d)'\'' '\''a >= (b != C || d)'\'''

echo '$ test-expr '\''a >= ((b != C) || D)'\'''
test-expr 'a >= ((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != C) || D)'\'''

echo '$ diff-expr '\''a >= ((b != C) || D)'\'' '\''a >= (b != C || D)'\'''
diff-expr 'a >= ((b != C) || D)' 'a >= (b != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != C) || D)'\'' '\''a >= (b != C || D)'\'''

echo '$ test-expr '\''a >= ((B != c) || d)'\'''
test-expr 'a >= ((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != c) || d)'\'''

echo '$ diff-expr '\''a >= ((B != c) || d)'\'' '\''a >= (B != c || d)'\'''
diff-expr 'a >= ((B != c) || d)' 'a >= (B != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != c) || d)'\'' '\''a >= (B != c || d)'\'''

echo '$ test-expr '\''a >= ((B != c) || D)'\'''
test-expr 'a >= ((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != c) || D)'\'''

echo '$ diff-expr '\''a >= ((B != c) || D)'\'' '\''a >= (B != c || D)'\'''
diff-expr 'a >= ((B != c) || D)' 'a >= (B != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != c) || D)'\'' '\''a >= (B != c || D)'\'''

echo '$ test-expr '\''a >= ((B != C) || d)'\'''
test-expr 'a >= ((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != C) || d)'\'''

echo '$ diff-expr '\''a >= ((B != C) || d)'\'' '\''a >= (B != C || d)'\'''
diff-expr 'a >= ((B != C) || d)' 'a >= (B != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != C) || d)'\'' '\''a >= (B != C || d)'\'''

echo '$ test-expr '\''a >= ((B != C) || D)'\'''
test-expr 'a >= ((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B != C) || D)'\'''

echo '$ diff-expr '\''a >= ((B != C) || D)'\'' '\''a >= (B != C || D)'\'''
diff-expr 'a >= ((B != C) || D)' 'a >= (B != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B != C) || D)'\'' '\''a >= (B != C || D)'\'''

echo '$ test-expr '\''A >= ((b != c) || d)'\'''
test-expr 'A >= ((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != c) || d)'\'''

echo '$ diff-expr '\''A >= ((b != c) || d)'\'' '\''A >= (b != c || d)'\'''
diff-expr 'A >= ((b != c) || d)' 'A >= (b != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != c) || d)'\'' '\''A >= (b != c || d)'\'''

echo '$ test-expr '\''A >= ((b != c) || D)'\'''
test-expr 'A >= ((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != c) || D)'\'''

echo '$ diff-expr '\''A >= ((b != c) || D)'\'' '\''A >= (b != c || D)'\'''
diff-expr 'A >= ((b != c) || D)' 'A >= (b != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != c) || D)'\'' '\''A >= (b != c || D)'\'''

echo '$ test-expr '\''A >= ((b != C) || d)'\'''
test-expr 'A >= ((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != C) || d)'\'''

echo '$ diff-expr '\''A >= ((b != C) || d)'\'' '\''A >= (b != C || d)'\'''
diff-expr 'A >= ((b != C) || d)' 'A >= (b != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != C) || d)'\'' '\''A >= (b != C || d)'\'''

echo '$ test-expr '\''A >= ((b != C) || D)'\'''
test-expr 'A >= ((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b != C) || D)'\'''

echo '$ diff-expr '\''A >= ((b != C) || D)'\'' '\''A >= (b != C || D)'\'''
diff-expr 'A >= ((b != C) || D)' 'A >= (b != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b != C) || D)'\'' '\''A >= (b != C || D)'\'''

echo '$ test-expr '\''A >= ((B != c) || d)'\'''
test-expr 'A >= ((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != c) || d)'\'''

echo '$ diff-expr '\''A >= ((B != c) || d)'\'' '\''A >= (B != c || d)'\'''
diff-expr 'A >= ((B != c) || d)' 'A >= (B != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != c) || d)'\'' '\''A >= (B != c || d)'\'''

echo '$ test-expr '\''A >= ((B != c) || D)'\'''
test-expr 'A >= ((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != c) || D)'\'''

echo '$ diff-expr '\''A >= ((B != c) || D)'\'' '\''A >= (B != c || D)'\'''
diff-expr 'A >= ((B != c) || D)' 'A >= (B != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != c) || D)'\'' '\''A >= (B != c || D)'\'''

echo '$ test-expr '\''A >= ((B != C) || d)'\'''
test-expr 'A >= ((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != C) || d)'\'''

echo '$ diff-expr '\''A >= ((B != C) || d)'\'' '\''A >= (B != C || d)'\'''
diff-expr 'A >= ((B != C) || d)' 'A >= (B != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != C) || d)'\'' '\''A >= (B != C || d)'\'''

echo '$ test-expr '\''A >= ((B != C) || D)'\'''
test-expr 'A >= ((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B != C) || D)'\'''

echo '$ diff-expr '\''A >= ((B != C) || D)'\'' '\''A >= (B != C || D)'\'''
diff-expr 'A >= ((B != C) || D)' 'A >= (B != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B != C) || D)'\'' '\''A >= (B != C || D)'\'''

echo '$ test-expr '\''a >= ((b && c) || d)'\'''
test-expr 'a >= ((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && c) || d)'\'''

echo '$ diff-expr '\''a >= ((b && c) || d)'\'' '\''a >= (b && c || d)'\'''
diff-expr 'a >= ((b && c) || d)' 'a >= (b && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && c) || d)'\'' '\''a >= (b && c || d)'\'''

echo '$ test-expr '\''a >= ((b && c) || D)'\'''
test-expr 'a >= ((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && c) || D)'\'''

echo '$ diff-expr '\''a >= ((b && c) || D)'\'' '\''a >= (b && c || D)'\'''
diff-expr 'a >= ((b && c) || D)' 'a >= (b && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && c) || D)'\'' '\''a >= (b && c || D)'\'''

echo '$ test-expr '\''a >= ((b && C) || d)'\'''
test-expr 'a >= ((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && C) || d)'\'''

echo '$ diff-expr '\''a >= ((b && C) || d)'\'' '\''a >= (b && C || d)'\'''
diff-expr 'a >= ((b && C) || d)' 'a >= (b && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && C) || d)'\'' '\''a >= (b && C || d)'\'''

echo '$ test-expr '\''a >= ((b && C) || D)'\'''
test-expr 'a >= ((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && C) || D)'\'''

echo '$ diff-expr '\''a >= ((b && C) || D)'\'' '\''a >= (b && C || D)'\'''
diff-expr 'a >= ((b && C) || D)' 'a >= (b && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && C) || D)'\'' '\''a >= (b && C || D)'\'''

echo '$ test-expr '\''a >= ((B && c) || d)'\'''
test-expr 'a >= ((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && c) || d)'\'''

echo '$ diff-expr '\''a >= ((B && c) || d)'\'' '\''a >= (B && c || d)'\'''
diff-expr 'a >= ((B && c) || d)' 'a >= (B && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B && c) || d)'\'' '\''a >= (B && c || d)'\'''

echo '$ test-expr '\''a >= ((B && c) || D)'\'''
test-expr 'a >= ((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && c) || D)'\'''

echo '$ diff-expr '\''a >= ((B && c) || D)'\'' '\''a >= (B && c || D)'\'''
diff-expr 'a >= ((B && c) || D)' 'a >= (B && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B && c) || D)'\'' '\''a >= (B && c || D)'\'''

echo '$ test-expr '\''a >= ((B && C) || d)'\'''
test-expr 'a >= ((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && C) || d)'\'''

echo '$ diff-expr '\''a >= ((B && C) || d)'\'' '\''a >= (B && C || d)'\'''
diff-expr 'a >= ((B && C) || d)' 'a >= (B && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B && C) || d)'\'' '\''a >= (B && C || d)'\'''

echo '$ test-expr '\''a >= ((B && C) || D)'\'''
test-expr 'a >= ((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && C) || D)'\'''

echo '$ diff-expr '\''a >= ((B && C) || D)'\'' '\''a >= (B && C || D)'\'''
diff-expr 'a >= ((B && C) || D)' 'a >= (B && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((B && C) || D)'\'' '\''a >= (B && C || D)'\'''

echo '$ test-expr '\''A >= ((b && c) || d)'\'''
test-expr 'A >= ((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && c) || d)'\'''

echo '$ diff-expr '\''A >= ((b && c) || d)'\'' '\''A >= (b && c || d)'\'''
diff-expr 'A >= ((b && c) || d)' 'A >= (b && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b && c) || d)'\'' '\''A >= (b && c || d)'\'''

echo '$ test-expr '\''A >= ((b && c) || D)'\'''
test-expr 'A >= ((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && c) || D)'\'''

echo '$ diff-expr '\''A >= ((b && c) || D)'\'' '\''A >= (b && c || D)'\'''
diff-expr 'A >= ((b && c) || D)' 'A >= (b && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b && c) || D)'\'' '\''A >= (b && c || D)'\'''

echo '$ test-expr '\''A >= ((b && C) || d)'\'''
test-expr 'A >= ((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && C) || d)'\'''

echo '$ diff-expr '\''A >= ((b && C) || d)'\'' '\''A >= (b && C || d)'\'''
diff-expr 'A >= ((b && C) || d)' 'A >= (b && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b && C) || d)'\'' '\''A >= (b && C || d)'\'''

echo '$ test-expr '\''A >= ((b && C) || D)'\'''
test-expr 'A >= ((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && C) || D)'\'''

echo '$ diff-expr '\''A >= ((b && C) || D)'\'' '\''A >= (b && C || D)'\'''
diff-expr 'A >= ((b && C) || D)' 'A >= (b && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((b && C) || D)'\'' '\''A >= (b && C || D)'\'''

echo '$ test-expr '\''A >= ((B && c) || d)'\'''
test-expr 'A >= ((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && c) || d)'\'''

echo '$ diff-expr '\''A >= ((B && c) || d)'\'' '\''A >= (B && c || d)'\'''
diff-expr 'A >= ((B && c) || d)' 'A >= (B && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B && c) || d)'\'' '\''A >= (B && c || d)'\'''

echo '$ test-expr '\''A >= ((B && c) || D)'\'''
test-expr 'A >= ((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && c) || D)'\'''

echo '$ diff-expr '\''A >= ((B && c) || D)'\'' '\''A >= (B && c || D)'\'''
diff-expr 'A >= ((B && c) || D)' 'A >= (B && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B && c) || D)'\'' '\''A >= (B && c || D)'\'''

echo '$ test-expr '\''A >= ((B && C) || d)'\'''
test-expr 'A >= ((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && C) || d)'\'''

echo '$ diff-expr '\''A >= ((B && C) || d)'\'' '\''A >= (B && C || d)'\'''
diff-expr 'A >= ((B && C) || d)' 'A >= (B && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B && C) || d)'\'' '\''A >= (B && C || d)'\'''

echo '$ test-expr '\''A >= ((B && C) || D)'\'''
test-expr 'A >= ((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && C) || D)'\'''

echo '$ diff-expr '\''A >= ((B && C) || D)'\'' '\''A >= (B && C || D)'\'''
diff-expr 'A >= ((B && C) || D)' 'A >= (B && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= ((B && C) || D)'\'' '\''A >= (B && C || D)'\'''

echo '$ test-expr '\''a != ((b && c) || d)'\'''
test-expr 'a != ((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || d)'\'''

echo '$ diff-expr '\''a != ((b && c) || d)'\'' '\''a != (b && c || d)'\'''
diff-expr 'a != ((b && c) || d)' 'a != (b && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) || d)'\'' '\''a != (b && c || d)'\'''

echo '$ test-expr '\''a != ((b && c) || D)'\'''
test-expr 'a != ((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || D)'\'''

echo '$ diff-expr '\''a != ((b && c) || D)'\'' '\''a != (b && c || D)'\'''
diff-expr 'a != ((b && c) || D)' 'a != (b && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) || D)'\'' '\''a != (b && c || D)'\'''

echo '$ test-expr '\''a != ((b && C) || d)'\'''
test-expr 'a != ((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && C) || d)'\'''

echo '$ diff-expr '\''a != ((b && C) || d)'\'' '\''a != (b && C || d)'\'''
diff-expr 'a != ((b && C) || d)' 'a != (b && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && C) || d)'\'' '\''a != (b && C || d)'\'''

echo '$ test-expr '\''a != ((b && C) || D)'\'''
test-expr 'a != ((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && C) || D)'\'''

echo '$ diff-expr '\''a != ((b && C) || D)'\'' '\''a != (b && C || D)'\'''
diff-expr 'a != ((b && C) || D)' 'a != (b && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && C) || D)'\'' '\''a != (b && C || D)'\'''

echo '$ test-expr '\''a != ((B && c) || d)'\'''
test-expr 'a != ((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && c) || d)'\'''

echo '$ diff-expr '\''a != ((B && c) || d)'\'' '\''a != (B && c || d)'\'''
diff-expr 'a != ((B && c) || d)' 'a != (B && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && c) || d)'\'' '\''a != (B && c || d)'\'''

echo '$ test-expr '\''a != ((B && c) || D)'\'''
test-expr 'a != ((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && c) || D)'\'''

echo '$ diff-expr '\''a != ((B && c) || D)'\'' '\''a != (B && c || D)'\'''
diff-expr 'a != ((B && c) || D)' 'a != (B && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && c) || D)'\'' '\''a != (B && c || D)'\'''

echo '$ test-expr '\''a != ((B && C) || d)'\'''
test-expr 'a != ((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && C) || d)'\'''

echo '$ diff-expr '\''a != ((B && C) || d)'\'' '\''a != (B && C || d)'\'''
diff-expr 'a != ((B && C) || d)' 'a != (B && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && C) || d)'\'' '\''a != (B && C || d)'\'''

echo '$ test-expr '\''a != ((B && C) || D)'\'''
test-expr 'a != ((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && C) || D)'\'''

echo '$ diff-expr '\''a != ((B && C) || D)'\'' '\''a != (B && C || D)'\'''
diff-expr 'a != ((B && C) || D)' 'a != (B && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && C) || D)'\'' '\''a != (B && C || D)'\'''

echo '$ test-expr '\''A != ((b && c) || d)'\'''
test-expr 'A != ((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && c) || d)'\'''

echo '$ diff-expr '\''A != ((b && c) || d)'\'' '\''A != (b && c || d)'\'''
diff-expr 'A != ((b && c) || d)' 'A != (b && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && c) || d)'\'' '\''A != (b && c || d)'\'''

echo '$ test-expr '\''A != ((b && c) || D)'\'''
test-expr 'A != ((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && c) || D)'\'''

echo '$ diff-expr '\''A != ((b && c) || D)'\'' '\''A != (b && c || D)'\'''
diff-expr 'A != ((b && c) || D)' 'A != (b && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && c) || D)'\'' '\''A != (b && c || D)'\'''

echo '$ test-expr '\''A != ((b && C) || d)'\'''
test-expr 'A != ((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && C) || d)'\'''

echo '$ diff-expr '\''A != ((b && C) || d)'\'' '\''A != (b && C || d)'\'''
diff-expr 'A != ((b && C) || d)' 'A != (b && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && C) || d)'\'' '\''A != (b && C || d)'\'''

echo '$ test-expr '\''A != ((b && C) || D)'\'''
test-expr 'A != ((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && C) || D)'\'''

echo '$ diff-expr '\''A != ((b && C) || D)'\'' '\''A != (b && C || D)'\'''
diff-expr 'A != ((b && C) || D)' 'A != (b && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && C) || D)'\'' '\''A != (b && C || D)'\'''

echo '$ test-expr '\''A != ((B && c) || d)'\'''
test-expr 'A != ((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && c) || d)'\'''

echo '$ diff-expr '\''A != ((B && c) || d)'\'' '\''A != (B && c || d)'\'''
diff-expr 'A != ((B && c) || d)' 'A != (B && c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && c) || d)'\'' '\''A != (B && c || d)'\'''

echo '$ test-expr '\''A != ((B && c) || D)'\'''
test-expr 'A != ((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && c) || D)'\'''

echo '$ diff-expr '\''A != ((B && c) || D)'\'' '\''A != (B && c || D)'\'''
diff-expr 'A != ((B && c) || D)' 'A != (B && c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && c) || D)'\'' '\''A != (B && c || D)'\'''

echo '$ test-expr '\''A != ((B && C) || d)'\'''
test-expr 'A != ((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && C) || d)'\'''

echo '$ diff-expr '\''A != ((B && C) || d)'\'' '\''A != (B && C || d)'\'''
diff-expr 'A != ((B && C) || d)' 'A != (B && C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && C) || d)'\'' '\''A != (B && C || d)'\'''

echo '$ test-expr '\''A != ((B && C) || D)'\'''
test-expr 'A != ((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && C) || D)'\'''

echo '$ diff-expr '\''A != ((B && C) || D)'\'' '\''A != (B && C || D)'\'''
diff-expr 'A != ((B && C) || D)' 'A != (B && C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && C) || D)'\'' '\''A != (B && C || D)'\'''

echo '$ test-expr '\''(a >= (b != c)) && d'\'''
test-expr '(a >= (b != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != c)) && d'\'''

echo '$ diff-expr '\''(a >= (b != c)) && d'\'' '\''a >= (b != c) && d'\'''
diff-expr '(a >= (b != c)) && d' 'a >= (b != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) && d'\'' '\''a >= (b != c) && d'\'''

echo '$ test-expr '\''(a >= (b != c)) && D'\'''
test-expr '(a >= (b != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != c)) && D'\'''

echo '$ diff-expr '\''(a >= (b != c)) && D'\'' '\''a >= (b != c) && D'\'''
diff-expr '(a >= (b != c)) && D' 'a >= (b != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) && D'\'' '\''a >= (b != c) && D'\'''

echo '$ test-expr '\''(a >= (b != C)) && d'\'''
test-expr '(a >= (b != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != C)) && d'\'''

echo '$ diff-expr '\''(a >= (b != C)) && d'\'' '\''a >= (b != C) && d'\'''
diff-expr '(a >= (b != C)) && d' 'a >= (b != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != C)) && d'\'' '\''a >= (b != C) && d'\'''

echo '$ test-expr '\''(a >= (b != C)) && D'\'''
test-expr '(a >= (b != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != C)) && D'\'''

echo '$ diff-expr '\''(a >= (b != C)) && D'\'' '\''a >= (b != C) && D'\'''
diff-expr '(a >= (b != C)) && D' 'a >= (b != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != C)) && D'\'' '\''a >= (b != C) && D'\'''

echo '$ test-expr '\''(a >= (B != c)) && d'\'''
test-expr '(a >= (B != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != c)) && d'\'''

echo '$ diff-expr '\''(a >= (B != c)) && d'\'' '\''a >= (B != c) && d'\'''
diff-expr '(a >= (B != c)) && d' 'a >= (B != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != c)) && d'\'' '\''a >= (B != c) && d'\'''

echo '$ test-expr '\''(a >= (B != c)) && D'\'''
test-expr '(a >= (B != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != c)) && D'\'''

echo '$ diff-expr '\''(a >= (B != c)) && D'\'' '\''a >= (B != c) && D'\'''
diff-expr '(a >= (B != c)) && D' 'a >= (B != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != c)) && D'\'' '\''a >= (B != c) && D'\'''

echo '$ test-expr '\''(a >= (B != C)) && d'\'''
test-expr '(a >= (B != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != C)) && d'\'''

echo '$ diff-expr '\''(a >= (B != C)) && d'\'' '\''a >= (B != C) && d'\'''
diff-expr '(a >= (B != C)) && d' 'a >= (B != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != C)) && d'\'' '\''a >= (B != C) && d'\'''

echo '$ test-expr '\''(a >= (B != C)) && D'\'''
test-expr '(a >= (B != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != C)) && D'\'''

echo '$ diff-expr '\''(a >= (B != C)) && D'\'' '\''a >= (B != C) && D'\'''
diff-expr '(a >= (B != C)) && D' 'a >= (B != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != C)) && D'\'' '\''a >= (B != C) && D'\'''

echo '$ test-expr '\''(A >= (b != c)) && d'\'''
test-expr '(A >= (b != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != c)) && d'\'''

echo '$ diff-expr '\''(A >= (b != c)) && d'\'' '\''A >= (b != c) && d'\'''
diff-expr '(A >= (b != c)) && d' 'A >= (b != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != c)) && d'\'' '\''A >= (b != c) && d'\'''

echo '$ test-expr '\''(A >= (b != c)) && D'\'''
test-expr '(A >= (b != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != c)) && D'\'''

echo '$ diff-expr '\''(A >= (b != c)) && D'\'' '\''A >= (b != c) && D'\'''
diff-expr '(A >= (b != c)) && D' 'A >= (b != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != c)) && D'\'' '\''A >= (b != c) && D'\'''

echo '$ test-expr '\''(A >= (b != C)) && d'\'''
test-expr '(A >= (b != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != C)) && d'\'''

echo '$ diff-expr '\''(A >= (b != C)) && d'\'' '\''A >= (b != C) && d'\'''
diff-expr '(A >= (b != C)) && d' 'A >= (b != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != C)) && d'\'' '\''A >= (b != C) && d'\'''

echo '$ test-expr '\''(A >= (b != C)) && D'\'''
test-expr '(A >= (b != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != C)) && D'\'''

echo '$ diff-expr '\''(A >= (b != C)) && D'\'' '\''A >= (b != C) && D'\'''
diff-expr '(A >= (b != C)) && D' 'A >= (b != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != C)) && D'\'' '\''A >= (b != C) && D'\'''

echo '$ test-expr '\''(A >= (B != c)) && d'\'''
test-expr '(A >= (B != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != c)) && d'\'''

echo '$ diff-expr '\''(A >= (B != c)) && d'\'' '\''A >= (B != c) && d'\'''
diff-expr '(A >= (B != c)) && d' 'A >= (B != c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != c)) && d'\'' '\''A >= (B != c) && d'\'''

echo '$ test-expr '\''(A >= (B != c)) && D'\'''
test-expr '(A >= (B != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != c)) && D'\'''

echo '$ diff-expr '\''(A >= (B != c)) && D'\'' '\''A >= (B != c) && D'\'''
diff-expr '(A >= (B != c)) && D' 'A >= (B != c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != c)) && D'\'' '\''A >= (B != c) && D'\'''

echo '$ test-expr '\''(A >= (B != C)) && d'\'''
test-expr '(A >= (B != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != C)) && d'\'''

echo '$ diff-expr '\''(A >= (B != C)) && d'\'' '\''A >= (B != C) && d'\'''
diff-expr '(A >= (B != C)) && d' 'A >= (B != C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != C)) && d'\'' '\''A >= (B != C) && d'\'''

echo '$ test-expr '\''(A >= (B != C)) && D'\'''
test-expr '(A >= (B != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != C)) && D'\'''

echo '$ diff-expr '\''(A >= (B != C)) && D'\'' '\''A >= (B != C) && D'\'''
diff-expr '(A >= (B != C)) && D' 'A >= (B != C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != C)) && D'\'' '\''A >= (B != C) && D'\'''

echo '$ test-expr '\''(a >= (b != c)) || d'\'''
test-expr '(a >= (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != c)) || d'\'''

echo '$ diff-expr '\''(a >= (b != c)) || d'\'' '\''a >= (b != c) || d'\'''
diff-expr '(a >= (b != c)) || d' 'a >= (b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) || d'\'' '\''a >= (b != c) || d'\'''

echo '$ test-expr '\''(a >= (b != c)) || D'\'''
test-expr '(a >= (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != c)) || D'\'''

echo '$ diff-expr '\''(a >= (b != c)) || D'\'' '\''a >= (b != c) || D'\'''
diff-expr '(a >= (b != c)) || D' 'a >= (b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) || D'\'' '\''a >= (b != c) || D'\'''

echo '$ test-expr '\''(a >= (b != C)) || d'\'''
test-expr '(a >= (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != C)) || d'\'''

echo '$ diff-expr '\''(a >= (b != C)) || d'\'' '\''a >= (b != C) || d'\'''
diff-expr '(a >= (b != C)) || d' 'a >= (b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != C)) || d'\'' '\''a >= (b != C) || d'\'''

echo '$ test-expr '\''(a >= (b != C)) || D'\'''
test-expr '(a >= (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != C)) || D'\'''

echo '$ diff-expr '\''(a >= (b != C)) || D'\'' '\''a >= (b != C) || D'\'''
diff-expr '(a >= (b != C)) || D' 'a >= (b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != C)) || D'\'' '\''a >= (b != C) || D'\'''

echo '$ test-expr '\''(a >= (B != c)) || d'\'''
test-expr '(a >= (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != c)) || d'\'''

echo '$ diff-expr '\''(a >= (B != c)) || d'\'' '\''a >= (B != c) || d'\'''
diff-expr '(a >= (B != c)) || d' 'a >= (B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != c)) || d'\'' '\''a >= (B != c) || d'\'''

echo '$ test-expr '\''(a >= (B != c)) || D'\'''
test-expr '(a >= (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != c)) || D'\'''

echo '$ diff-expr '\''(a >= (B != c)) || D'\'' '\''a >= (B != c) || D'\'''
diff-expr '(a >= (B != c)) || D' 'a >= (B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != c)) || D'\'' '\''a >= (B != c) || D'\'''

echo '$ test-expr '\''(a >= (B != C)) || d'\'''
test-expr '(a >= (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != C)) || d'\'''

echo '$ diff-expr '\''(a >= (B != C)) || d'\'' '\''a >= (B != C) || d'\'''
diff-expr '(a >= (B != C)) || d' 'a >= (B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != C)) || d'\'' '\''a >= (B != C) || d'\'''

echo '$ test-expr '\''(a >= (B != C)) || D'\'''
test-expr '(a >= (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B != C)) || D'\'''

echo '$ diff-expr '\''(a >= (B != C)) || D'\'' '\''a >= (B != C) || D'\'''
diff-expr '(a >= (B != C)) || D' 'a >= (B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B != C)) || D'\'' '\''a >= (B != C) || D'\'''

echo '$ test-expr '\''(A >= (b != c)) || d'\'''
test-expr '(A >= (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != c)) || d'\'''

echo '$ diff-expr '\''(A >= (b != c)) || d'\'' '\''A >= (b != c) || d'\'''
diff-expr '(A >= (b != c)) || d' 'A >= (b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != c)) || d'\'' '\''A >= (b != c) || d'\'''

echo '$ test-expr '\''(A >= (b != c)) || D'\'''
test-expr '(A >= (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != c)) || D'\'''

echo '$ diff-expr '\''(A >= (b != c)) || D'\'' '\''A >= (b != c) || D'\'''
diff-expr '(A >= (b != c)) || D' 'A >= (b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != c)) || D'\'' '\''A >= (b != c) || D'\'''

echo '$ test-expr '\''(A >= (b != C)) || d'\'''
test-expr '(A >= (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != C)) || d'\'''

echo '$ diff-expr '\''(A >= (b != C)) || d'\'' '\''A >= (b != C) || d'\'''
diff-expr '(A >= (b != C)) || d' 'A >= (b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != C)) || d'\'' '\''A >= (b != C) || d'\'''

echo '$ test-expr '\''(A >= (b != C)) || D'\'''
test-expr '(A >= (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b != C)) || D'\'''

echo '$ diff-expr '\''(A >= (b != C)) || D'\'' '\''A >= (b != C) || D'\'''
diff-expr '(A >= (b != C)) || D' 'A >= (b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b != C)) || D'\'' '\''A >= (b != C) || D'\'''

echo '$ test-expr '\''(A >= (B != c)) || d'\'''
test-expr '(A >= (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != c)) || d'\'''

echo '$ diff-expr '\''(A >= (B != c)) || d'\'' '\''A >= (B != c) || d'\'''
diff-expr '(A >= (B != c)) || d' 'A >= (B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != c)) || d'\'' '\''A >= (B != c) || d'\'''

echo '$ test-expr '\''(A >= (B != c)) || D'\'''
test-expr '(A >= (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != c)) || D'\'''

echo '$ diff-expr '\''(A >= (B != c)) || D'\'' '\''A >= (B != c) || D'\'''
diff-expr '(A >= (B != c)) || D' 'A >= (B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != c)) || D'\'' '\''A >= (B != c) || D'\'''

echo '$ test-expr '\''(A >= (B != C)) || d'\'''
test-expr '(A >= (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != C)) || d'\'''

echo '$ diff-expr '\''(A >= (B != C)) || d'\'' '\''A >= (B != C) || d'\'''
diff-expr '(A >= (B != C)) || d' 'A >= (B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != C)) || d'\'' '\''A >= (B != C) || d'\'''

echo '$ test-expr '\''(A >= (B != C)) || D'\'''
test-expr '(A >= (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B != C)) || D'\'''

echo '$ diff-expr '\''(A >= (B != C)) || D'\'' '\''A >= (B != C) || D'\'''
diff-expr '(A >= (B != C)) || D' 'A >= (B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B != C)) || D'\'' '\''A >= (B != C) || D'\'''

echo '$ test-expr '\''(a >= (b && c)) || d'\'''
test-expr '(a >= (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && c)) || d'\'''

echo '$ diff-expr '\''(a >= (b && c)) || d'\'' '\''a >= (b && c) || d'\'''
diff-expr '(a >= (b && c)) || d' 'a >= (b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) || d'\'' '\''a >= (b && c) || d'\'''

echo '$ test-expr '\''(a >= (b && c)) || D'\'''
test-expr '(a >= (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && c)) || D'\'''

echo '$ diff-expr '\''(a >= (b && c)) || D'\'' '\''a >= (b && c) || D'\'''
diff-expr '(a >= (b && c)) || D' 'a >= (b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) || D'\'' '\''a >= (b && c) || D'\'''

echo '$ test-expr '\''(a >= (b && C)) || d'\'''
test-expr '(a >= (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && C)) || d'\'''

echo '$ diff-expr '\''(a >= (b && C)) || d'\'' '\''a >= (b && C) || d'\'''
diff-expr '(a >= (b && C)) || d' 'a >= (b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && C)) || d'\'' '\''a >= (b && C) || d'\'''

echo '$ test-expr '\''(a >= (b && C)) || D'\'''
test-expr '(a >= (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && C)) || D'\'''

echo '$ diff-expr '\''(a >= (b && C)) || D'\'' '\''a >= (b && C) || D'\'''
diff-expr '(a >= (b && C)) || D' 'a >= (b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && C)) || D'\'' '\''a >= (b && C) || D'\'''

echo '$ test-expr '\''(a >= (B && c)) || d'\'''
test-expr '(a >= (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && c)) || d'\'''

echo '$ diff-expr '\''(a >= (B && c)) || d'\'' '\''a >= (B && c) || d'\'''
diff-expr '(a >= (B && c)) || d' 'a >= (B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && c)) || d'\'' '\''a >= (B && c) || d'\'''

echo '$ test-expr '\''(a >= (B && c)) || D'\'''
test-expr '(a >= (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && c)) || D'\'''

echo '$ diff-expr '\''(a >= (B && c)) || D'\'' '\''a >= (B && c) || D'\'''
diff-expr '(a >= (B && c)) || D' 'a >= (B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && c)) || D'\'' '\''a >= (B && c) || D'\'''

echo '$ test-expr '\''(a >= (B && C)) || d'\'''
test-expr '(a >= (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && C)) || d'\'''

echo '$ diff-expr '\''(a >= (B && C)) || d'\'' '\''a >= (B && C) || d'\'''
diff-expr '(a >= (B && C)) || d' 'a >= (B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && C)) || d'\'' '\''a >= (B && C) || d'\'''

echo '$ test-expr '\''(a >= (B && C)) || D'\'''
test-expr '(a >= (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && C)) || D'\'''

echo '$ diff-expr '\''(a >= (B && C)) || D'\'' '\''a >= (B && C) || D'\'''
diff-expr '(a >= (B && C)) || D' 'a >= (B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && C)) || D'\'' '\''a >= (B && C) || D'\'''

echo '$ test-expr '\''(A >= (b && c)) || d'\'''
test-expr '(A >= (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && c)) || d'\'''

echo '$ diff-expr '\''(A >= (b && c)) || d'\'' '\''A >= (b && c) || d'\'''
diff-expr '(A >= (b && c)) || d' 'A >= (b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && c)) || d'\'' '\''A >= (b && c) || d'\'''

echo '$ test-expr '\''(A >= (b && c)) || D'\'''
test-expr '(A >= (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && c)) || D'\'''

echo '$ diff-expr '\''(A >= (b && c)) || D'\'' '\''A >= (b && c) || D'\'''
diff-expr '(A >= (b && c)) || D' 'A >= (b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && c)) || D'\'' '\''A >= (b && c) || D'\'''

echo '$ test-expr '\''(A >= (b && C)) || d'\'''
test-expr '(A >= (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && C)) || d'\'''

echo '$ diff-expr '\''(A >= (b && C)) || d'\'' '\''A >= (b && C) || d'\'''
diff-expr '(A >= (b && C)) || d' 'A >= (b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && C)) || d'\'' '\''A >= (b && C) || d'\'''

echo '$ test-expr '\''(A >= (b && C)) || D'\'''
test-expr '(A >= (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && C)) || D'\'''

echo '$ diff-expr '\''(A >= (b && C)) || D'\'' '\''A >= (b && C) || D'\'''
diff-expr '(A >= (b && C)) || D' 'A >= (b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && C)) || D'\'' '\''A >= (b && C) || D'\'''

echo '$ test-expr '\''(A >= (B && c)) || d'\'''
test-expr '(A >= (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && c)) || d'\'''

echo '$ diff-expr '\''(A >= (B && c)) || d'\'' '\''A >= (B && c) || d'\'''
diff-expr '(A >= (B && c)) || d' 'A >= (B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && c)) || d'\'' '\''A >= (B && c) || d'\'''

echo '$ test-expr '\''(A >= (B && c)) || D'\'''
test-expr '(A >= (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && c)) || D'\'''

echo '$ diff-expr '\''(A >= (B && c)) || D'\'' '\''A >= (B && c) || D'\'''
diff-expr '(A >= (B && c)) || D' 'A >= (B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && c)) || D'\'' '\''A >= (B && c) || D'\'''

echo '$ test-expr '\''(A >= (B && C)) || d'\'''
test-expr '(A >= (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && C)) || d'\'''

echo '$ diff-expr '\''(A >= (B && C)) || d'\'' '\''A >= (B && C) || d'\'''
diff-expr '(A >= (B && C)) || d' 'A >= (B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && C)) || d'\'' '\''A >= (B && C) || d'\'''

echo '$ test-expr '\''(A >= (B && C)) || D'\'''
test-expr '(A >= (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && C)) || D'\'''

echo '$ diff-expr '\''(A >= (B && C)) || D'\'' '\''A >= (B && C) || D'\'''
diff-expr '(A >= (B && C)) || D' 'A >= (B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && C)) || D'\'' '\''A >= (B && C) || D'\'''

echo '$ test-expr '\''(a != (b && c)) || d'\'''
test-expr '(a != (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && c)) || d'\'''

echo '$ diff-expr '\''(a != (b && c)) || d'\'' '\''a != (b && c) || d'\'''
diff-expr '(a != (b && c)) || d' 'a != (b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && c)) || d'\'' '\''a != (b && c) || d'\'''

echo '$ test-expr '\''(a != (b && c)) || D'\'''
test-expr '(a != (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && c)) || D'\'''

echo '$ diff-expr '\''(a != (b && c)) || D'\'' '\''a != (b && c) || D'\'''
diff-expr '(a != (b && c)) || D' 'a != (b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && c)) || D'\'' '\''a != (b && c) || D'\'''

echo '$ test-expr '\''(a != (b && C)) || d'\'''
test-expr '(a != (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && C)) || d'\'''

echo '$ diff-expr '\''(a != (b && C)) || d'\'' '\''a != (b && C) || d'\'''
diff-expr '(a != (b && C)) || d' 'a != (b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && C)) || d'\'' '\''a != (b && C) || d'\'''

echo '$ test-expr '\''(a != (b && C)) || D'\'''
test-expr '(a != (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && C)) || D'\'''

echo '$ diff-expr '\''(a != (b && C)) || D'\'' '\''a != (b && C) || D'\'''
diff-expr '(a != (b && C)) || D' 'a != (b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && C)) || D'\'' '\''a != (b && C) || D'\'''

echo '$ test-expr '\''(a != (B && c)) || d'\'''
test-expr '(a != (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && c)) || d'\'''

echo '$ diff-expr '\''(a != (B && c)) || d'\'' '\''a != (B && c) || d'\'''
diff-expr '(a != (B && c)) || d' 'a != (B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B && c)) || d'\'' '\''a != (B && c) || d'\'''

echo '$ test-expr '\''(a != (B && c)) || D'\'''
test-expr '(a != (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && c)) || D'\'''

echo '$ diff-expr '\''(a != (B && c)) || D'\'' '\''a != (B && c) || D'\'''
diff-expr '(a != (B && c)) || D' 'a != (B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B && c)) || D'\'' '\''a != (B && c) || D'\'''

echo '$ test-expr '\''(a != (B && C)) || d'\'''
test-expr '(a != (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && C)) || d'\'''

echo '$ diff-expr '\''(a != (B && C)) || d'\'' '\''a != (B && C) || d'\'''
diff-expr '(a != (B && C)) || d' 'a != (B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B && C)) || d'\'' '\''a != (B && C) || d'\'''

echo '$ test-expr '\''(a != (B && C)) || D'\'''
test-expr '(a != (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && C)) || D'\'''

echo '$ diff-expr '\''(a != (B && C)) || D'\'' '\''a != (B && C) || D'\'''
diff-expr '(a != (B && C)) || D' 'a != (B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B && C)) || D'\'' '\''a != (B && C) || D'\'''

echo '$ test-expr '\''(A != (b && c)) || d'\'''
test-expr '(A != (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && c)) || d'\'''

echo '$ diff-expr '\''(A != (b && c)) || d'\'' '\''A != (b && c) || d'\'''
diff-expr '(A != (b && c)) || d' 'A != (b && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b && c)) || d'\'' '\''A != (b && c) || d'\'''

echo '$ test-expr '\''(A != (b && c)) || D'\'''
test-expr '(A != (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && c)) || D'\'''

echo '$ diff-expr '\''(A != (b && c)) || D'\'' '\''A != (b && c) || D'\'''
diff-expr '(A != (b && c)) || D' 'A != (b && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b && c)) || D'\'' '\''A != (b && c) || D'\'''

echo '$ test-expr '\''(A != (b && C)) || d'\'''
test-expr '(A != (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && C)) || d'\'''

echo '$ diff-expr '\''(A != (b && C)) || d'\'' '\''A != (b && C) || d'\'''
diff-expr '(A != (b && C)) || d' 'A != (b && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b && C)) || d'\'' '\''A != (b && C) || d'\'''

echo '$ test-expr '\''(A != (b && C)) || D'\'''
test-expr '(A != (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && C)) || D'\'''

echo '$ diff-expr '\''(A != (b && C)) || D'\'' '\''A != (b && C) || D'\'''
diff-expr '(A != (b && C)) || D' 'A != (b && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b && C)) || D'\'' '\''A != (b && C) || D'\'''

echo '$ test-expr '\''(A != (B && c)) || d'\'''
test-expr '(A != (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && c)) || d'\'''

echo '$ diff-expr '\''(A != (B && c)) || d'\'' '\''A != (B && c) || d'\'''
diff-expr '(A != (B && c)) || d' 'A != (B && c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B && c)) || d'\'' '\''A != (B && c) || d'\'''

echo '$ test-expr '\''(A != (B && c)) || D'\'''
test-expr '(A != (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && c)) || D'\'''

echo '$ diff-expr '\''(A != (B && c)) || D'\'' '\''A != (B && c) || D'\'''
diff-expr '(A != (B && c)) || D' 'A != (B && c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B && c)) || D'\'' '\''A != (B && c) || D'\'''

echo '$ test-expr '\''(A != (B && C)) || d'\'''
test-expr '(A != (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && C)) || d'\'''

echo '$ diff-expr '\''(A != (B && C)) || d'\'' '\''A != (B && C) || d'\'''
diff-expr '(A != (B && C)) || d' 'A != (B && C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B && C)) || d'\'' '\''A != (B && C) || d'\'''

echo '$ test-expr '\''(A != (B && C)) || D'\'''
test-expr '(A != (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && C)) || D'\'''

echo '$ diff-expr '\''(A != (B && C)) || D'\'' '\''A != (B && C) || D'\'''
diff-expr '(A != (B && C)) || D' 'A != (B && C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B && C)) || D'\'' '\''A != (B && C) || D'\'''

echo '$ test-expr '\''(a >= b) != (c && d)'\'''
test-expr '(a >= b) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (c && d)'\'''

echo '$ diff-expr '\''(a >= b) != (c && d)'\'' '\''a >= b != (c && d)'\'''
diff-expr '(a >= b) != (c && d)' 'a >= b != (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c && d)'\'' '\''a >= b != (c && d)'\'''

echo '$ test-expr '\''(a >= b) != (c && D)'\'''
test-expr '(a >= b) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (c && D)'\'''

echo '$ diff-expr '\''(a >= b) != (c && D)'\'' '\''a >= b != (c && D)'\'''
diff-expr '(a >= b) != (c && D)' 'a >= b != (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c && D)'\'' '\''a >= b != (c && D)'\'''

echo '$ test-expr '\''(a >= b) != (C && d)'\'''
test-expr '(a >= b) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (C && d)'\'''

echo '$ diff-expr '\''(a >= b) != (C && d)'\'' '\''a >= b != (C && d)'\'''
diff-expr '(a >= b) != (C && d)' 'a >= b != (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (C && d)'\'' '\''a >= b != (C && d)'\'''

echo '$ test-expr '\''(a >= b) != (C && D)'\'''
test-expr '(a >= b) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (C && D)'\'''

echo '$ diff-expr '\''(a >= b) != (C && D)'\'' '\''a >= b != (C && D)'\'''
diff-expr '(a >= b) != (C && D)' 'a >= b != (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (C && D)'\'' '\''a >= b != (C && D)'\'''

echo '$ test-expr '\''(a >= B) != (c && d)'\'''
test-expr '(a >= B) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (c && d)'\'''

echo '$ diff-expr '\''(a >= B) != (c && d)'\'' '\''a >= B != (c && d)'\'''
diff-expr '(a >= B) != (c && d)' 'a >= B != (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (c && d)'\'' '\''a >= B != (c && d)'\'''

echo '$ test-expr '\''(a >= B) != (c && D)'\'''
test-expr '(a >= B) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (c && D)'\'''

echo '$ diff-expr '\''(a >= B) != (c && D)'\'' '\''a >= B != (c && D)'\'''
diff-expr '(a >= B) != (c && D)' 'a >= B != (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (c && D)'\'' '\''a >= B != (c && D)'\'''

echo '$ test-expr '\''(a >= B) != (C && d)'\'''
test-expr '(a >= B) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (C && d)'\'''

echo '$ diff-expr '\''(a >= B) != (C && d)'\'' '\''a >= B != (C && d)'\'''
diff-expr '(a >= B) != (C && d)' 'a >= B != (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (C && d)'\'' '\''a >= B != (C && d)'\'''

echo '$ test-expr '\''(a >= B) != (C && D)'\'''
test-expr '(a >= B) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (C && D)'\'''

echo '$ diff-expr '\''(a >= B) != (C && D)'\'' '\''a >= B != (C && D)'\'''
diff-expr '(a >= B) != (C && D)' 'a >= B != (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (C && D)'\'' '\''a >= B != (C && D)'\'''

echo '$ test-expr '\''(A >= b) != (c && d)'\'''
test-expr '(A >= b) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (c && d)'\'''

echo '$ diff-expr '\''(A >= b) != (c && d)'\'' '\''A >= b != (c && d)'\'''
diff-expr '(A >= b) != (c && d)' 'A >= b != (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (c && d)'\'' '\''A >= b != (c && d)'\'''

echo '$ test-expr '\''(A >= b) != (c && D)'\'''
test-expr '(A >= b) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (c && D)'\'''

echo '$ diff-expr '\''(A >= b) != (c && D)'\'' '\''A >= b != (c && D)'\'''
diff-expr '(A >= b) != (c && D)' 'A >= b != (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (c && D)'\'' '\''A >= b != (c && D)'\'''

echo '$ test-expr '\''(A >= b) != (C && d)'\'''
test-expr '(A >= b) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (C && d)'\'''

echo '$ diff-expr '\''(A >= b) != (C && d)'\'' '\''A >= b != (C && d)'\'''
diff-expr '(A >= b) != (C && d)' 'A >= b != (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (C && d)'\'' '\''A >= b != (C && d)'\'''

echo '$ test-expr '\''(A >= b) != (C && D)'\'''
test-expr '(A >= b) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (C && D)'\'''

echo '$ diff-expr '\''(A >= b) != (C && D)'\'' '\''A >= b != (C && D)'\'''
diff-expr '(A >= b) != (C && D)' 'A >= b != (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (C && D)'\'' '\''A >= b != (C && D)'\'''

echo '$ test-expr '\''(A >= B) != (c && d)'\'''
test-expr '(A >= B) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (c && d)'\'''

echo '$ diff-expr '\''(A >= B) != (c && d)'\'' '\''A >= B != (c && d)'\'''
diff-expr '(A >= B) != (c && d)' 'A >= B != (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (c && d)'\'' '\''A >= B != (c && d)'\'''

echo '$ test-expr '\''(A >= B) != (c && D)'\'''
test-expr '(A >= B) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (c && D)'\'''

echo '$ diff-expr '\''(A >= B) != (c && D)'\'' '\''A >= B != (c && D)'\'''
diff-expr '(A >= B) != (c && D)' 'A >= B != (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (c && D)'\'' '\''A >= B != (c && D)'\'''

echo '$ test-expr '\''(A >= B) != (C && d)'\'''
test-expr '(A >= B) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (C && d)'\'''

echo '$ diff-expr '\''(A >= B) != (C && d)'\'' '\''A >= B != (C && d)'\'''
diff-expr '(A >= B) != (C && d)' 'A >= B != (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (C && d)'\'' '\''A >= B != (C && d)'\'''

echo '$ test-expr '\''(A >= B) != (C && D)'\'''
test-expr '(A >= B) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (C && D)'\'''

echo '$ diff-expr '\''(A >= B) != (C && D)'\'' '\''A >= B != (C && D)'\'''
diff-expr '(A >= B) != (C && D)' 'A >= B != (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (C && D)'\'' '\''A >= B != (C && D)'\'''

echo '$ test-expr '\''(a >= b) != (c || d)'\'''
test-expr '(a >= b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (c || d)'\'''

echo '$ diff-expr '\''(a >= b) != (c || d)'\'' '\''a >= b != (c || d)'\'''
diff-expr '(a >= b) != (c || d)' 'a >= b != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c || d)'\'' '\''a >= b != (c || d)'\'''

echo '$ test-expr '\''(a >= b) != (c || D)'\'''
test-expr '(a >= b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (c || D)'\'''

echo '$ diff-expr '\''(a >= b) != (c || D)'\'' '\''a >= b != (c || D)'\'''
diff-expr '(a >= b) != (c || D)' 'a >= b != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c || D)'\'' '\''a >= b != (c || D)'\'''

echo '$ test-expr '\''(a >= b) != (C || d)'\'''
test-expr '(a >= b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (C || d)'\'''

echo '$ diff-expr '\''(a >= b) != (C || d)'\'' '\''a >= b != (C || d)'\'''
diff-expr '(a >= b) != (C || d)' 'a >= b != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (C || d)'\'' '\''a >= b != (C || d)'\'''

echo '$ test-expr '\''(a >= b) != (C || D)'\'''
test-expr '(a >= b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (C || D)'\'''

echo '$ diff-expr '\''(a >= b) != (C || D)'\'' '\''a >= b != (C || D)'\'''
diff-expr '(a >= b) != (C || D)' 'a >= b != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (C || D)'\'' '\''a >= b != (C || D)'\'''

echo '$ test-expr '\''(a >= B) != (c || d)'\'''
test-expr '(a >= B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (c || d)'\'''

echo '$ diff-expr '\''(a >= B) != (c || d)'\'' '\''a >= B != (c || d)'\'''
diff-expr '(a >= B) != (c || d)' 'a >= B != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (c || d)'\'' '\''a >= B != (c || d)'\'''

echo '$ test-expr '\''(a >= B) != (c || D)'\'''
test-expr '(a >= B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (c || D)'\'''

echo '$ diff-expr '\''(a >= B) != (c || D)'\'' '\''a >= B != (c || D)'\'''
diff-expr '(a >= B) != (c || D)' 'a >= B != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (c || D)'\'' '\''a >= B != (c || D)'\'''

echo '$ test-expr '\''(a >= B) != (C || d)'\'''
test-expr '(a >= B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (C || d)'\'''

echo '$ diff-expr '\''(a >= B) != (C || d)'\'' '\''a >= B != (C || d)'\'''
diff-expr '(a >= B) != (C || d)' 'a >= B != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (C || d)'\'' '\''a >= B != (C || d)'\'''

echo '$ test-expr '\''(a >= B) != (C || D)'\'''
test-expr '(a >= B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) != (C || D)'\'''

echo '$ diff-expr '\''(a >= B) != (C || D)'\'' '\''a >= B != (C || D)'\'''
diff-expr '(a >= B) != (C || D)' 'a >= B != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) != (C || D)'\'' '\''a >= B != (C || D)'\'''

echo '$ test-expr '\''(A >= b) != (c || d)'\'''
test-expr '(A >= b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (c || d)'\'''

echo '$ diff-expr '\''(A >= b) != (c || d)'\'' '\''A >= b != (c || d)'\'''
diff-expr '(A >= b) != (c || d)' 'A >= b != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (c || d)'\'' '\''A >= b != (c || d)'\'''

echo '$ test-expr '\''(A >= b) != (c || D)'\'''
test-expr '(A >= b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (c || D)'\'''

echo '$ diff-expr '\''(A >= b) != (c || D)'\'' '\''A >= b != (c || D)'\'''
diff-expr '(A >= b) != (c || D)' 'A >= b != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (c || D)'\'' '\''A >= b != (c || D)'\'''

echo '$ test-expr '\''(A >= b) != (C || d)'\'''
test-expr '(A >= b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (C || d)'\'''

echo '$ diff-expr '\''(A >= b) != (C || d)'\'' '\''A >= b != (C || d)'\'''
diff-expr '(A >= b) != (C || d)' 'A >= b != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (C || d)'\'' '\''A >= b != (C || d)'\'''

echo '$ test-expr '\''(A >= b) != (C || D)'\'''
test-expr '(A >= b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) != (C || D)'\'''

echo '$ diff-expr '\''(A >= b) != (C || D)'\'' '\''A >= b != (C || D)'\'''
diff-expr '(A >= b) != (C || D)' 'A >= b != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) != (C || D)'\'' '\''A >= b != (C || D)'\'''

echo '$ test-expr '\''(A >= B) != (c || d)'\'''
test-expr '(A >= B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (c || d)'\'''

echo '$ diff-expr '\''(A >= B) != (c || d)'\'' '\''A >= B != (c || d)'\'''
diff-expr '(A >= B) != (c || d)' 'A >= B != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (c || d)'\'' '\''A >= B != (c || d)'\'''

echo '$ test-expr '\''(A >= B) != (c || D)'\'''
test-expr '(A >= B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (c || D)'\'''

echo '$ diff-expr '\''(A >= B) != (c || D)'\'' '\''A >= B != (c || D)'\'''
diff-expr '(A >= B) != (c || D)' 'A >= B != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (c || D)'\'' '\''A >= B != (c || D)'\'''

echo '$ test-expr '\''(A >= B) != (C || d)'\'''
test-expr '(A >= B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (C || d)'\'''

echo '$ diff-expr '\''(A >= B) != (C || d)'\'' '\''A >= B != (C || d)'\'''
diff-expr '(A >= B) != (C || d)' 'A >= B != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (C || d)'\'' '\''A >= B != (C || d)'\'''

echo '$ test-expr '\''(A >= B) != (C || D)'\'''
test-expr '(A >= B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) != (C || D)'\'''

echo '$ diff-expr '\''(A >= B) != (C || D)'\'' '\''A >= B != (C || D)'\'''
diff-expr '(A >= B) != (C || D)' 'A >= B != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) != (C || D)'\'' '\''A >= B != (C || D)'\'''

echo '$ test-expr '\''(a >= b) && (c || d)'\'''
test-expr '(a >= b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (c || d)'\'''

echo '$ diff-expr '\''(a >= b) && (c || d)'\'' '\''a >= b && (c || d)'\'''
diff-expr '(a >= b) && (c || d)' 'a >= b && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c || d)'\'' '\''a >= b && (c || d)'\'''

echo '$ test-expr '\''(a >= b) && (c || D)'\'''
test-expr '(a >= b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (c || D)'\'''

echo '$ diff-expr '\''(a >= b) && (c || D)'\'' '\''a >= b && (c || D)'\'''
diff-expr '(a >= b) && (c || D)' 'a >= b && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c || D)'\'' '\''a >= b && (c || D)'\'''

echo '$ test-expr '\''(a >= b) && (C || d)'\'''
test-expr '(a >= b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (C || d)'\'''

echo '$ diff-expr '\''(a >= b) && (C || d)'\'' '\''a >= b && (C || d)'\'''
diff-expr '(a >= b) && (C || d)' 'a >= b && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C || d)'\'' '\''a >= b && (C || d)'\'''

echo '$ test-expr '\''(a >= b) && (C || D)'\'''
test-expr '(a >= b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (C || D)'\'''

echo '$ diff-expr '\''(a >= b) && (C || D)'\'' '\''a >= b && (C || D)'\'''
diff-expr '(a >= b) && (C || D)' 'a >= b && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C || D)'\'' '\''a >= b && (C || D)'\'''

echo '$ test-expr '\''(a >= B) && (c || d)'\'''
test-expr '(a >= B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (c || d)'\'''

echo '$ diff-expr '\''(a >= B) && (c || d)'\'' '\''a >= B && (c || d)'\'''
diff-expr '(a >= B) && (c || d)' 'a >= B && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c || d)'\'' '\''a >= B && (c || d)'\'''

echo '$ test-expr '\''(a >= B) && (c || D)'\'''
test-expr '(a >= B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (c || D)'\'''

echo '$ diff-expr '\''(a >= B) && (c || D)'\'' '\''a >= B && (c || D)'\'''
diff-expr '(a >= B) && (c || D)' 'a >= B && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c || D)'\'' '\''a >= B && (c || D)'\'''

echo '$ test-expr '\''(a >= B) && (C || d)'\'''
test-expr '(a >= B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (C || d)'\'''

echo '$ diff-expr '\''(a >= B) && (C || d)'\'' '\''a >= B && (C || d)'\'''
diff-expr '(a >= B) && (C || d)' 'a >= B && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C || d)'\'' '\''a >= B && (C || d)'\'''

echo '$ test-expr '\''(a >= B) && (C || D)'\'''
test-expr '(a >= B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (C || D)'\'''

echo '$ diff-expr '\''(a >= B) && (C || D)'\'' '\''a >= B && (C || D)'\'''
diff-expr '(a >= B) && (C || D)' 'a >= B && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C || D)'\'' '\''a >= B && (C || D)'\'''

echo '$ test-expr '\''(A >= b) && (c || d)'\'''
test-expr '(A >= b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (c || d)'\'''

echo '$ diff-expr '\''(A >= b) && (c || d)'\'' '\''A >= b && (c || d)'\'''
diff-expr '(A >= b) && (c || d)' 'A >= b && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c || d)'\'' '\''A >= b && (c || d)'\'''

echo '$ test-expr '\''(A >= b) && (c || D)'\'''
test-expr '(A >= b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (c || D)'\'''

echo '$ diff-expr '\''(A >= b) && (c || D)'\'' '\''A >= b && (c || D)'\'''
diff-expr '(A >= b) && (c || D)' 'A >= b && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c || D)'\'' '\''A >= b && (c || D)'\'''

echo '$ test-expr '\''(A >= b) && (C || d)'\'''
test-expr '(A >= b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (C || d)'\'''

echo '$ diff-expr '\''(A >= b) && (C || d)'\'' '\''A >= b && (C || d)'\'''
diff-expr '(A >= b) && (C || d)' 'A >= b && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C || d)'\'' '\''A >= b && (C || d)'\'''

echo '$ test-expr '\''(A >= b) && (C || D)'\'''
test-expr '(A >= b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (C || D)'\'''

echo '$ diff-expr '\''(A >= b) && (C || D)'\'' '\''A >= b && (C || D)'\'''
diff-expr '(A >= b) && (C || D)' 'A >= b && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C || D)'\'' '\''A >= b && (C || D)'\'''

echo '$ test-expr '\''(A >= B) && (c || d)'\'''
test-expr '(A >= B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (c || d)'\'''

echo '$ diff-expr '\''(A >= B) && (c || d)'\'' '\''A >= B && (c || d)'\'''
diff-expr '(A >= B) && (c || d)' 'A >= B && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c || d)'\'' '\''A >= B && (c || d)'\'''

echo '$ test-expr '\''(A >= B) && (c || D)'\'''
test-expr '(A >= B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (c || D)'\'''

echo '$ diff-expr '\''(A >= B) && (c || D)'\'' '\''A >= B && (c || D)'\'''
diff-expr '(A >= B) && (c || D)' 'A >= B && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c || D)'\'' '\''A >= B && (c || D)'\'''

echo '$ test-expr '\''(A >= B) && (C || d)'\'''
test-expr '(A >= B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (C || d)'\'''

echo '$ diff-expr '\''(A >= B) && (C || d)'\'' '\''A >= B && (C || d)'\'''
diff-expr '(A >= B) && (C || d)' 'A >= B && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C || d)'\'' '\''A >= B && (C || d)'\'''

echo '$ test-expr '\''(A >= B) && (C || D)'\'''
test-expr '(A >= B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (C || D)'\'''

echo '$ diff-expr '\''(A >= B) && (C || D)'\'' '\''A >= B && (C || D)'\'''
diff-expr '(A >= B) && (C || D)' 'A >= B && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C || D)'\'' '\''A >= B && (C || D)'\'''

echo '$ test-expr '\''(a != b) && (c || d)'\'''
test-expr '(a != b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (c || d)'\'''

echo '$ diff-expr '\''(a != b) && (c || d)'\'' '\''a != b && (c || d)'\'''
diff-expr '(a != b) && (c || d)' 'a != b && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c || d)'\'' '\''a != b && (c || d)'\'''

echo '$ test-expr '\''(a != b) && (c || D)'\'''
test-expr '(a != b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (c || D)'\'''

echo '$ diff-expr '\''(a != b) && (c || D)'\'' '\''a != b && (c || D)'\'''
diff-expr '(a != b) && (c || D)' 'a != b && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c || D)'\'' '\''a != b && (c || D)'\'''

echo '$ test-expr '\''(a != b) && (C || d)'\'''
test-expr '(a != b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (C || d)'\'''

echo '$ diff-expr '\''(a != b) && (C || d)'\'' '\''a != b && (C || d)'\'''
diff-expr '(a != b) && (C || d)' 'a != b && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C || d)'\'' '\''a != b && (C || d)'\'''

echo '$ test-expr '\''(a != b) && (C || D)'\'''
test-expr '(a != b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (C || D)'\'''

echo '$ diff-expr '\''(a != b) && (C || D)'\'' '\''a != b && (C || D)'\'''
diff-expr '(a != b) && (C || D)' 'a != b && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C || D)'\'' '\''a != b && (C || D)'\'''

echo '$ test-expr '\''(a != B) && (c || d)'\'''
test-expr '(a != B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (c || d)'\'''

echo '$ diff-expr '\''(a != B) && (c || d)'\'' '\''a != B && (c || d)'\'''
diff-expr '(a != B) && (c || d)' 'a != B && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c || d)'\'' '\''a != B && (c || d)'\'''

echo '$ test-expr '\''(a != B) && (c || D)'\'''
test-expr '(a != B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (c || D)'\'''

echo '$ diff-expr '\''(a != B) && (c || D)'\'' '\''a != B && (c || D)'\'''
diff-expr '(a != B) && (c || D)' 'a != B && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c || D)'\'' '\''a != B && (c || D)'\'''

echo '$ test-expr '\''(a != B) && (C || d)'\'''
test-expr '(a != B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (C || d)'\'''

echo '$ diff-expr '\''(a != B) && (C || d)'\'' '\''a != B && (C || d)'\'''
diff-expr '(a != B) && (C || d)' 'a != B && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C || d)'\'' '\''a != B && (C || d)'\'''

echo '$ test-expr '\''(a != B) && (C || D)'\'''
test-expr '(a != B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (C || D)'\'''

echo '$ diff-expr '\''(a != B) && (C || D)'\'' '\''a != B && (C || D)'\'''
diff-expr '(a != B) && (C || D)' 'a != B && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C || D)'\'' '\''a != B && (C || D)'\'''

echo '$ test-expr '\''(A != b) && (c || d)'\'''
test-expr '(A != b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (c || d)'\'''

echo '$ diff-expr '\''(A != b) && (c || d)'\'' '\''A != b && (c || d)'\'''
diff-expr '(A != b) && (c || d)' 'A != b && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c || d)'\'' '\''A != b && (c || d)'\'''

echo '$ test-expr '\''(A != b) && (c || D)'\'''
test-expr '(A != b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (c || D)'\'''

echo '$ diff-expr '\''(A != b) && (c || D)'\'' '\''A != b && (c || D)'\'''
diff-expr '(A != b) && (c || D)' 'A != b && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c || D)'\'' '\''A != b && (c || D)'\'''

echo '$ test-expr '\''(A != b) && (C || d)'\'''
test-expr '(A != b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (C || d)'\'''

echo '$ diff-expr '\''(A != b) && (C || d)'\'' '\''A != b && (C || d)'\'''
diff-expr '(A != b) && (C || d)' 'A != b && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C || d)'\'' '\''A != b && (C || d)'\'''

echo '$ test-expr '\''(A != b) && (C || D)'\'''
test-expr '(A != b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (C || D)'\'''

echo '$ diff-expr '\''(A != b) && (C || D)'\'' '\''A != b && (C || D)'\'''
diff-expr '(A != b) && (C || D)' 'A != b && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C || D)'\'' '\''A != b && (C || D)'\'''

echo '$ test-expr '\''(A != B) && (c || d)'\'''
test-expr '(A != B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (c || d)'\'''

echo '$ diff-expr '\''(A != B) && (c || d)'\'' '\''A != B && (c || d)'\'''
diff-expr '(A != B) && (c || d)' 'A != B && (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c || d)'\'' '\''A != B && (c || d)'\'''

echo '$ test-expr '\''(A != B) && (c || D)'\'''
test-expr '(A != B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (c || D)'\'''

echo '$ diff-expr '\''(A != B) && (c || D)'\'' '\''A != B && (c || D)'\'''
diff-expr '(A != B) && (c || D)' 'A != B && (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c || D)'\'' '\''A != B && (c || D)'\'''

echo '$ test-expr '\''(A != B) && (C || d)'\'''
test-expr '(A != B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (C || d)'\'''

echo '$ diff-expr '\''(A != B) && (C || d)'\'' '\''A != B && (C || d)'\'''
diff-expr '(A != B) && (C || d)' 'A != B && (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C || d)'\'' '\''A != B && (C || d)'\'''

echo '$ test-expr '\''(A != B) && (C || D)'\'''
test-expr '(A != B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (C || D)'\'''

echo '$ diff-expr '\''(A != B) && (C || D)'\'' '\''A != B && (C || D)'\'''
diff-expr '(A != B) && (C || D)' 'A != B && (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C || D)'\'' '\''A != B && (C || D)'\'''

echo '$ test-expr '\''a >= (b != (c && d))'\'''
test-expr 'a >= (b != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && d))'\'''

echo '$ test-expr '\''a >= (b != (c && D))'\'''
test-expr 'a >= (b != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && D))'\'''

echo '$ test-expr '\''a >= (b != (C && d))'\'''
test-expr 'a >= (b != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (C && d))'\'''

echo '$ test-expr '\''a >= (b != (C && D))'\'''
test-expr 'a >= (b != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (C && D))'\'''

echo '$ test-expr '\''a >= (B != (c && d))'\'''
test-expr 'a >= (B != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (c && d))'\'''

echo '$ test-expr '\''a >= (B != (c && D))'\'''
test-expr 'a >= (B != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (c && D))'\'''

echo '$ test-expr '\''a >= (B != (C && d))'\'''
test-expr 'a >= (B != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (C && d))'\'''

echo '$ test-expr '\''a >= (B != (C && D))'\'''
test-expr 'a >= (B != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (C && D))'\'''

echo '$ test-expr '\''A >= (b != (c && d))'\'''
test-expr 'A >= (b != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (c && d))'\'''

echo '$ test-expr '\''A >= (b != (c && D))'\'''
test-expr 'A >= (b != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (c && D))'\'''

echo '$ test-expr '\''A >= (b != (C && d))'\'''
test-expr 'A >= (b != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (C && d))'\'''

echo '$ test-expr '\''A >= (b != (C && D))'\'''
test-expr 'A >= (b != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (C && D))'\'''

echo '$ test-expr '\''A >= (B != (c && d))'\'''
test-expr 'A >= (B != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (c && d))'\'''

echo '$ test-expr '\''A >= (B != (c && D))'\'''
test-expr 'A >= (B != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (c && D))'\'''

echo '$ test-expr '\''A >= (B != (C && d))'\'''
test-expr 'A >= (B != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (C && d))'\'''

echo '$ test-expr '\''A >= (B != (C && D))'\'''
test-expr 'A >= (B != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (C && D))'\'''

echo '$ test-expr '\''a >= (b != (c || d))'\'''
test-expr 'a >= (b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || d))'\'''

echo '$ test-expr '\''a >= (b != (c || D))'\'''
test-expr 'a >= (b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || D))'\'''

echo '$ test-expr '\''a >= (b != (C || d))'\'''
test-expr 'a >= (b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (C || d))'\'''

echo '$ test-expr '\''a >= (b != (C || D))'\'''
test-expr 'a >= (b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (C || D))'\'''

echo '$ test-expr '\''a >= (B != (c || d))'\'''
test-expr 'a >= (B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (c || d))'\'''

echo '$ test-expr '\''a >= (B != (c || D))'\'''
test-expr 'a >= (B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (c || D))'\'''

echo '$ test-expr '\''a >= (B != (C || d))'\'''
test-expr 'a >= (B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (C || d))'\'''

echo '$ test-expr '\''a >= (B != (C || D))'\'''
test-expr 'a >= (B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B != (C || D))'\'''

echo '$ test-expr '\''A >= (b != (c || d))'\'''
test-expr 'A >= (b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (c || d))'\'''

echo '$ test-expr '\''A >= (b != (c || D))'\'''
test-expr 'A >= (b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (c || D))'\'''

echo '$ test-expr '\''A >= (b != (C || d))'\'''
test-expr 'A >= (b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (C || d))'\'''

echo '$ test-expr '\''A >= (b != (C || D))'\'''
test-expr 'A >= (b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b != (C || D))'\'''

echo '$ test-expr '\''A >= (B != (c || d))'\'''
test-expr 'A >= (B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (c || d))'\'''

echo '$ test-expr '\''A >= (B != (c || D))'\'''
test-expr 'A >= (B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (c || D))'\'''

echo '$ test-expr '\''A >= (B != (C || d))'\'''
test-expr 'A >= (B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (C || d))'\'''

echo '$ test-expr '\''A >= (B != (C || D))'\'''
test-expr 'A >= (B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B != (C || D))'\'''

echo '$ test-expr '\''a >= (b && (c || d))'\'''
test-expr 'a >= (b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c || d))'\'''

echo '$ test-expr '\''a >= (b && (c || D))'\'''
test-expr 'a >= (b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c || D))'\'''

echo '$ test-expr '\''a >= (b && (C || d))'\'''
test-expr 'a >= (b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (C || d))'\'''

echo '$ test-expr '\''a >= (b && (C || D))'\'''
test-expr 'a >= (b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (C || D))'\'''

echo '$ test-expr '\''a >= (B && (c || d))'\'''
test-expr 'a >= (B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (c || d))'\'''

echo '$ test-expr '\''a >= (B && (c || D))'\'''
test-expr 'a >= (B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (c || D))'\'''

echo '$ test-expr '\''a >= (B && (C || d))'\'''
test-expr 'a >= (B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (C || d))'\'''

echo '$ test-expr '\''a >= (B && (C || D))'\'''
test-expr 'a >= (B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (C || D))'\'''

echo '$ test-expr '\''A >= (b && (c || d))'\'''
test-expr 'A >= (b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (c || d))'\'''

echo '$ test-expr '\''A >= (b && (c || D))'\'''
test-expr 'A >= (b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (c || D))'\'''

echo '$ test-expr '\''A >= (b && (C || d))'\'''
test-expr 'A >= (b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (C || d))'\'''

echo '$ test-expr '\''A >= (b && (C || D))'\'''
test-expr 'A >= (b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (C || D))'\'''

echo '$ test-expr '\''A >= (B && (c || d))'\'''
test-expr 'A >= (B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (c || d))'\'''

echo '$ test-expr '\''A >= (B && (c || D))'\'''
test-expr 'A >= (B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (c || D))'\'''

echo '$ test-expr '\''A >= (B && (C || d))'\'''
test-expr 'A >= (B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (C || d))'\'''

echo '$ test-expr '\''A >= (B && (C || D))'\'''
test-expr 'A >= (B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (C || D))'\'''

echo '$ test-expr '\''a != (b && (c || d))'\'''
test-expr 'a != (b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || d))'\'''

echo '$ test-expr '\''a != (b && (c || D))'\'''
test-expr 'a != (b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || D))'\'''

echo '$ test-expr '\''a != (b && (C || d))'\'''
test-expr 'a != (b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (C || d))'\'''

echo '$ test-expr '\''a != (b && (C || D))'\'''
test-expr 'a != (b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (C || D))'\'''

echo '$ test-expr '\''a != (B && (c || d))'\'''
test-expr 'a != (B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && (c || d))'\'''

echo '$ test-expr '\''a != (B && (c || D))'\'''
test-expr 'a != (B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && (c || D))'\'''

echo '$ test-expr '\''a != (B && (C || d))'\'''
test-expr 'a != (B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && (C || d))'\'''

echo '$ test-expr '\''a != (B && (C || D))'\'''
test-expr 'a != (B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && (C || D))'\'''

echo '$ test-expr '\''A != (b && (c || d))'\'''
test-expr 'A != (b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && (c || d))'\'''

echo '$ test-expr '\''A != (b && (c || D))'\'''
test-expr 'A != (b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && (c || D))'\'''

echo '$ test-expr '\''A != (b && (C || d))'\'''
test-expr 'A != (b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && (C || d))'\'''

echo '$ test-expr '\''A != (b && (C || D))'\'''
test-expr 'A != (b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b && (C || D))'\'''

echo '$ test-expr '\''A != (B && (c || d))'\'''
test-expr 'A != (B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && (c || d))'\'''

echo '$ test-expr '\''A != (B && (c || D))'\'''
test-expr 'A != (B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && (c || D))'\'''

echo '$ test-expr '\''A != (B && (C || d))'\'''
test-expr 'A != (B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && (C || d))'\'''

echo '$ test-expr '\''A != (B && (C || D))'\'''
test-expr 'A != (B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B && (C || D))'\'''

echo '$ test-expr '\''((a >= b) && c) != d'\'''
test-expr '((a >= b) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && c) != d'\'''

echo '$ diff-expr '\''((a >= b) && c) != d'\'' '\''(a >= b && c) != d'\'''
diff-expr '((a >= b) && c) != d' '(a >= b && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) != d'\'' '\''(a >= b && c) != d'\'''

echo '$ test-expr '\''((a >= b) && c) != D'\'''
test-expr '((a >= b) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && c) != D'\'''

echo '$ diff-expr '\''((a >= b) && c) != D'\'' '\''(a >= b && c) != D'\'''
diff-expr '((a >= b) && c) != D' '(a >= b && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) != D'\'' '\''(a >= b && c) != D'\'''

echo '$ test-expr '\''((a >= b) && C) != d'\'''
test-expr '((a >= b) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && C) != d'\'''

echo '$ diff-expr '\''((a >= b) && C) != d'\'' '\''(a >= b && C) != d'\'''
diff-expr '((a >= b) && C) != d' '(a >= b && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) != d'\'' '\''(a >= b && C) != d'\'''

echo '$ test-expr '\''((a >= b) && C) != D'\'''
test-expr '((a >= b) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && C) != D'\'''

echo '$ diff-expr '\''((a >= b) && C) != D'\'' '\''(a >= b && C) != D'\'''
diff-expr '((a >= b) && C) != D' '(a >= b && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && C) != D'\'' '\''(a >= b && C) != D'\'''

echo '$ test-expr '\''((a >= B) && c) != d'\'''
test-expr '((a >= B) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && c) != d'\'''

echo '$ diff-expr '\''((a >= B) && c) != d'\'' '\''(a >= B && c) != d'\'''
diff-expr '((a >= B) && c) != d' '(a >= B && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) != d'\'' '\''(a >= B && c) != d'\'''

echo '$ test-expr '\''((a >= B) && c) != D'\'''
test-expr '((a >= B) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && c) != D'\'''

echo '$ diff-expr '\''((a >= B) && c) != D'\'' '\''(a >= B && c) != D'\'''
diff-expr '((a >= B) && c) != D' '(a >= B && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && c) != D'\'' '\''(a >= B && c) != D'\'''

echo '$ test-expr '\''((a >= B) && C) != d'\'''
test-expr '((a >= B) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && C) != d'\'''

echo '$ diff-expr '\''((a >= B) && C) != d'\'' '\''(a >= B && C) != d'\'''
diff-expr '((a >= B) && C) != d' '(a >= B && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) != d'\'' '\''(a >= B && C) != d'\'''

echo '$ test-expr '\''((a >= B) && C) != D'\'''
test-expr '((a >= B) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) && C) != D'\'''

echo '$ diff-expr '\''((a >= B) && C) != D'\'' '\''(a >= B && C) != D'\'''
diff-expr '((a >= B) && C) != D' '(a >= B && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) && C) != D'\'' '\''(a >= B && C) != D'\'''

echo '$ test-expr '\''((A >= b) && c) != d'\'''
test-expr '((A >= b) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && c) != d'\'''

echo '$ diff-expr '\''((A >= b) && c) != d'\'' '\''(A >= b && c) != d'\'''
diff-expr '((A >= b) && c) != d' '(A >= b && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) != d'\'' '\''(A >= b && c) != d'\'''

echo '$ test-expr '\''((A >= b) && c) != D'\'''
test-expr '((A >= b) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && c) != D'\'''

echo '$ diff-expr '\''((A >= b) && c) != D'\'' '\''(A >= b && c) != D'\'''
diff-expr '((A >= b) && c) != D' '(A >= b && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && c) != D'\'' '\''(A >= b && c) != D'\'''

echo '$ test-expr '\''((A >= b) && C) != d'\'''
test-expr '((A >= b) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && C) != d'\'''

echo '$ diff-expr '\''((A >= b) && C) != d'\'' '\''(A >= b && C) != d'\'''
diff-expr '((A >= b) && C) != d' '(A >= b && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) != d'\'' '\''(A >= b && C) != d'\'''

echo '$ test-expr '\''((A >= b) && C) != D'\'''
test-expr '((A >= b) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) && C) != D'\'''

echo '$ diff-expr '\''((A >= b) && C) != D'\'' '\''(A >= b && C) != D'\'''
diff-expr '((A >= b) && C) != D' '(A >= b && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) && C) != D'\'' '\''(A >= b && C) != D'\'''

echo '$ test-expr '\''((A >= B) && c) != d'\'''
test-expr '((A >= B) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && c) != d'\'''

echo '$ diff-expr '\''((A >= B) && c) != d'\'' '\''(A >= B && c) != d'\'''
diff-expr '((A >= B) && c) != d' '(A >= B && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) != d'\'' '\''(A >= B && c) != d'\'''

echo '$ test-expr '\''((A >= B) && c) != D'\'''
test-expr '((A >= B) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && c) != D'\'''

echo '$ diff-expr '\''((A >= B) && c) != D'\'' '\''(A >= B && c) != D'\'''
diff-expr '((A >= B) && c) != D' '(A >= B && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && c) != D'\'' '\''(A >= B && c) != D'\'''

echo '$ test-expr '\''((A >= B) && C) != d'\'''
test-expr '((A >= B) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && C) != d'\'''

echo '$ diff-expr '\''((A >= B) && C) != d'\'' '\''(A >= B && C) != d'\'''
diff-expr '((A >= B) && C) != d' '(A >= B && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) != d'\'' '\''(A >= B && C) != d'\'''

echo '$ test-expr '\''((A >= B) && C) != D'\'''
test-expr '((A >= B) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) && C) != D'\'''

echo '$ diff-expr '\''((A >= B) && C) != D'\'' '\''(A >= B && C) != D'\'''
diff-expr '((A >= B) && C) != D' '(A >= B && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) && C) != D'\'' '\''(A >= B && C) != D'\'''

echo '$ test-expr '\''((a >= b) || c) != d'\'''
test-expr '((a >= b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || c) != d'\'''

echo '$ diff-expr '\''((a >= b) || c) != d'\'' '\''(a >= b || c) != d'\'''
diff-expr '((a >= b) || c) != d' '(a >= b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) != d'\'' '\''(a >= b || c) != d'\'''

echo '$ test-expr '\''((a >= b) || c) != D'\'''
test-expr '((a >= b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || c) != D'\'''

echo '$ diff-expr '\''((a >= b) || c) != D'\'' '\''(a >= b || c) != D'\'''
diff-expr '((a >= b) || c) != D' '(a >= b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) != D'\'' '\''(a >= b || c) != D'\'''

echo '$ test-expr '\''((a >= b) || C) != d'\'''
test-expr '((a >= b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || C) != d'\'''

echo '$ diff-expr '\''((a >= b) || C) != d'\'' '\''(a >= b || C) != d'\'''
diff-expr '((a >= b) || C) != d' '(a >= b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || C) != d'\'' '\''(a >= b || C) != d'\'''

echo '$ test-expr '\''((a >= b) || C) != D'\'''
test-expr '((a >= b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || C) != D'\'''

echo '$ diff-expr '\''((a >= b) || C) != D'\'' '\''(a >= b || C) != D'\'''
diff-expr '((a >= b) || C) != D' '(a >= b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || C) != D'\'' '\''(a >= b || C) != D'\'''

echo '$ test-expr '\''((a >= B) || c) != d'\'''
test-expr '((a >= B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || c) != d'\'''

echo '$ diff-expr '\''((a >= B) || c) != d'\'' '\''(a >= B || c) != d'\'''
diff-expr '((a >= B) || c) != d' '(a >= B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || c) != d'\'' '\''(a >= B || c) != d'\'''

echo '$ test-expr '\''((a >= B) || c) != D'\'''
test-expr '((a >= B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || c) != D'\'''

echo '$ diff-expr '\''((a >= B) || c) != D'\'' '\''(a >= B || c) != D'\'''
diff-expr '((a >= B) || c) != D' '(a >= B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || c) != D'\'' '\''(a >= B || c) != D'\'''

echo '$ test-expr '\''((a >= B) || C) != d'\'''
test-expr '((a >= B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || C) != d'\'''

echo '$ diff-expr '\''((a >= B) || C) != d'\'' '\''(a >= B || C) != d'\'''
diff-expr '((a >= B) || C) != d' '(a >= B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || C) != d'\'' '\''(a >= B || C) != d'\'''

echo '$ test-expr '\''((a >= B) || C) != D'\'''
test-expr '((a >= B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || C) != D'\'''

echo '$ diff-expr '\''((a >= B) || C) != D'\'' '\''(a >= B || C) != D'\'''
diff-expr '((a >= B) || C) != D' '(a >= B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || C) != D'\'' '\''(a >= B || C) != D'\'''

echo '$ test-expr '\''((A >= b) || c) != d'\'''
test-expr '((A >= b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || c) != d'\'''

echo '$ diff-expr '\''((A >= b) || c) != d'\'' '\''(A >= b || c) != d'\'''
diff-expr '((A >= b) || c) != d' '(A >= b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || c) != d'\'' '\''(A >= b || c) != d'\'''

echo '$ test-expr '\''((A >= b) || c) != D'\'''
test-expr '((A >= b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || c) != D'\'''

echo '$ diff-expr '\''((A >= b) || c) != D'\'' '\''(A >= b || c) != D'\'''
diff-expr '((A >= b) || c) != D' '(A >= b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || c) != D'\'' '\''(A >= b || c) != D'\'''

echo '$ test-expr '\''((A >= b) || C) != d'\'''
test-expr '((A >= b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || C) != d'\'''

echo '$ diff-expr '\''((A >= b) || C) != d'\'' '\''(A >= b || C) != d'\'''
diff-expr '((A >= b) || C) != d' '(A >= b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || C) != d'\'' '\''(A >= b || C) != d'\'''

echo '$ test-expr '\''((A >= b) || C) != D'\'''
test-expr '((A >= b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || C) != D'\'''

echo '$ diff-expr '\''((A >= b) || C) != D'\'' '\''(A >= b || C) != D'\'''
diff-expr '((A >= b) || C) != D' '(A >= b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || C) != D'\'' '\''(A >= b || C) != D'\'''

echo '$ test-expr '\''((A >= B) || c) != d'\'''
test-expr '((A >= B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || c) != d'\'''

echo '$ diff-expr '\''((A >= B) || c) != d'\'' '\''(A >= B || c) != d'\'''
diff-expr '((A >= B) || c) != d' '(A >= B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || c) != d'\'' '\''(A >= B || c) != d'\'''

echo '$ test-expr '\''((A >= B) || c) != D'\'''
test-expr '((A >= B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || c) != D'\'''

echo '$ diff-expr '\''((A >= B) || c) != D'\'' '\''(A >= B || c) != D'\'''
diff-expr '((A >= B) || c) != D' '(A >= B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || c) != D'\'' '\''(A >= B || c) != D'\'''

echo '$ test-expr '\''((A >= B) || C) != d'\'''
test-expr '((A >= B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || C) != d'\'''

echo '$ diff-expr '\''((A >= B) || C) != d'\'' '\''(A >= B || C) != d'\'''
diff-expr '((A >= B) || C) != d' '(A >= B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || C) != d'\'' '\''(A >= B || C) != d'\'''

echo '$ test-expr '\''((A >= B) || C) != D'\'''
test-expr '((A >= B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || C) != D'\'''

echo '$ diff-expr '\''((A >= B) || C) != D'\'' '\''(A >= B || C) != D'\'''
diff-expr '((A >= B) || C) != D' '(A >= B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || C) != D'\'' '\''(A >= B || C) != D'\'''

echo '$ test-expr '\''((a >= b) || c) && d'\'''
test-expr '((a >= b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || c) && d'\'''

echo '$ diff-expr '\''((a >= b) || c) && d'\'' '\''(a >= b || c) && d'\'''
diff-expr '((a >= b) || c) && d' '(a >= b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) && d'\'' '\''(a >= b || c) && d'\'''

echo '$ test-expr '\''((a >= b) || c) && D'\'''
test-expr '((a >= b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || c) && D'\'''

echo '$ diff-expr '\''((a >= b) || c) && D'\'' '\''(a >= b || c) && D'\'''
diff-expr '((a >= b) || c) && D' '(a >= b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) && D'\'' '\''(a >= b || c) && D'\'''

echo '$ test-expr '\''((a >= b) || C) && d'\'''
test-expr '((a >= b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || C) && d'\'''

echo '$ diff-expr '\''((a >= b) || C) && d'\'' '\''(a >= b || C) && d'\'''
diff-expr '((a >= b) || C) && d' '(a >= b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || C) && d'\'' '\''(a >= b || C) && d'\'''

echo '$ test-expr '\''((a >= b) || C) && D'\'''
test-expr '((a >= b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || C) && D'\'''

echo '$ diff-expr '\''((a >= b) || C) && D'\'' '\''(a >= b || C) && D'\'''
diff-expr '((a >= b) || C) && D' '(a >= b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || C) && D'\'' '\''(a >= b || C) && D'\'''

echo '$ test-expr '\''((a >= B) || c) && d'\'''
test-expr '((a >= B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || c) && d'\'''

echo '$ diff-expr '\''((a >= B) || c) && d'\'' '\''(a >= B || c) && d'\'''
diff-expr '((a >= B) || c) && d' '(a >= B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || c) && d'\'' '\''(a >= B || c) && d'\'''

echo '$ test-expr '\''((a >= B) || c) && D'\'''
test-expr '((a >= B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || c) && D'\'''

echo '$ diff-expr '\''((a >= B) || c) && D'\'' '\''(a >= B || c) && D'\'''
diff-expr '((a >= B) || c) && D' '(a >= B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || c) && D'\'' '\''(a >= B || c) && D'\'''

echo '$ test-expr '\''((a >= B) || C) && d'\'''
test-expr '((a >= B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || C) && d'\'''

echo '$ diff-expr '\''((a >= B) || C) && d'\'' '\''(a >= B || C) && d'\'''
diff-expr '((a >= B) || C) && d' '(a >= B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || C) && d'\'' '\''(a >= B || C) && d'\'''

echo '$ test-expr '\''((a >= B) || C) && D'\'''
test-expr '((a >= B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a >= B) || C) && D'\'''

echo '$ diff-expr '\''((a >= B) || C) && D'\'' '\''(a >= B || C) && D'\'''
diff-expr '((a >= B) || C) && D' '(a >= B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= B) || C) && D'\'' '\''(a >= B || C) && D'\'''

echo '$ test-expr '\''((A >= b) || c) && d'\'''
test-expr '((A >= b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || c) && d'\'''

echo '$ diff-expr '\''((A >= b) || c) && d'\'' '\''(A >= b || c) && d'\'''
diff-expr '((A >= b) || c) && d' '(A >= b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || c) && d'\'' '\''(A >= b || c) && d'\'''

echo '$ test-expr '\''((A >= b) || c) && D'\'''
test-expr '((A >= b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || c) && D'\'''

echo '$ diff-expr '\''((A >= b) || c) && D'\'' '\''(A >= b || c) && D'\'''
diff-expr '((A >= b) || c) && D' '(A >= b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || c) && D'\'' '\''(A >= b || c) && D'\'''

echo '$ test-expr '\''((A >= b) || C) && d'\'''
test-expr '((A >= b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || C) && d'\'''

echo '$ diff-expr '\''((A >= b) || C) && d'\'' '\''(A >= b || C) && d'\'''
diff-expr '((A >= b) || C) && d' '(A >= b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || C) && d'\'' '\''(A >= b || C) && d'\'''

echo '$ test-expr '\''((A >= b) || C) && D'\'''
test-expr '((A >= b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= b) || C) && D'\'''

echo '$ diff-expr '\''((A >= b) || C) && D'\'' '\''(A >= b || C) && D'\'''
diff-expr '((A >= b) || C) && D' '(A >= b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= b) || C) && D'\'' '\''(A >= b || C) && D'\'''

echo '$ test-expr '\''((A >= B) || c) && d'\'''
test-expr '((A >= B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || c) && d'\'''

echo '$ diff-expr '\''((A >= B) || c) && d'\'' '\''(A >= B || c) && d'\'''
diff-expr '((A >= B) || c) && d' '(A >= B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || c) && d'\'' '\''(A >= B || c) && d'\'''

echo '$ test-expr '\''((A >= B) || c) && D'\'''
test-expr '((A >= B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || c) && D'\'''

echo '$ diff-expr '\''((A >= B) || c) && D'\'' '\''(A >= B || c) && D'\'''
diff-expr '((A >= B) || c) && D' '(A >= B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || c) && D'\'' '\''(A >= B || c) && D'\'''

echo '$ test-expr '\''((A >= B) || C) && d'\'''
test-expr '((A >= B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || C) && d'\'''

echo '$ diff-expr '\''((A >= B) || C) && d'\'' '\''(A >= B || C) && d'\'''
diff-expr '((A >= B) || C) && d' '(A >= B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || C) && d'\'' '\''(A >= B || C) && d'\'''

echo '$ test-expr '\''((A >= B) || C) && D'\'''
test-expr '((A >= B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A >= B) || C) && D'\'''

echo '$ diff-expr '\''((A >= B) || C) && D'\'' '\''(A >= B || C) && D'\'''
diff-expr '((A >= B) || C) && D' '(A >= B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A >= B) || C) && D'\'' '\''(A >= B || C) && D'\'''

echo '$ test-expr '\''((a != b) || c) && d'\'''
test-expr '((a != b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || c) && d'\'''

echo '$ diff-expr '\''((a != b) || c) && d'\'' '\''(a != b || c) && d'\'''
diff-expr '((a != b) || c) && d' '(a != b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) && d'\'' '\''(a != b || c) && d'\'''

echo '$ test-expr '\''((a != b) || c) && D'\'''
test-expr '((a != b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || c) && D'\'''

echo '$ diff-expr '\''((a != b) || c) && D'\'' '\''(a != b || c) && D'\'''
diff-expr '((a != b) || c) && D' '(a != b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) && D'\'' '\''(a != b || c) && D'\'''

echo '$ test-expr '\''((a != b) || C) && d'\'''
test-expr '((a != b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || C) && d'\'''

echo '$ diff-expr '\''((a != b) || C) && d'\'' '\''(a != b || C) && d'\'''
diff-expr '((a != b) || C) && d' '(a != b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || C) && d'\'' '\''(a != b || C) && d'\'''

echo '$ test-expr '\''((a != b) || C) && D'\'''
test-expr '((a != b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || C) && D'\'''

echo '$ diff-expr '\''((a != b) || C) && D'\'' '\''(a != b || C) && D'\'''
diff-expr '((a != b) || C) && D' '(a != b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || C) && D'\'' '\''(a != b || C) && D'\'''

echo '$ test-expr '\''((a != B) || c) && d'\'''
test-expr '((a != B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || c) && d'\'''

echo '$ diff-expr '\''((a != B) || c) && d'\'' '\''(a != B || c) && d'\'''
diff-expr '((a != B) || c) && d' '(a != B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || c) && d'\'' '\''(a != B || c) && d'\'''

echo '$ test-expr '\''((a != B) || c) && D'\'''
test-expr '((a != B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || c) && D'\'''

echo '$ diff-expr '\''((a != B) || c) && D'\'' '\''(a != B || c) && D'\'''
diff-expr '((a != B) || c) && D' '(a != B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || c) && D'\'' '\''(a != B || c) && D'\'''

echo '$ test-expr '\''((a != B) || C) && d'\'''
test-expr '((a != B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || C) && d'\'''

echo '$ diff-expr '\''((a != B) || C) && d'\'' '\''(a != B || C) && d'\'''
diff-expr '((a != B) || C) && d' '(a != B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || C) && d'\'' '\''(a != B || C) && d'\'''

echo '$ test-expr '\''((a != B) || C) && D'\'''
test-expr '((a != B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || C) && D'\'''

echo '$ diff-expr '\''((a != B) || C) && D'\'' '\''(a != B || C) && D'\'''
diff-expr '((a != B) || C) && D' '(a != B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || C) && D'\'' '\''(a != B || C) && D'\'''

echo '$ test-expr '\''((A != b) || c) && d'\'''
test-expr '((A != b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || c) && d'\'''

echo '$ diff-expr '\''((A != b) || c) && d'\'' '\''(A != b || c) && d'\'''
diff-expr '((A != b) || c) && d' '(A != b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || c) && d'\'' '\''(A != b || c) && d'\'''

echo '$ test-expr '\''((A != b) || c) && D'\'''
test-expr '((A != b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || c) && D'\'''

echo '$ diff-expr '\''((A != b) || c) && D'\'' '\''(A != b || c) && D'\'''
diff-expr '((A != b) || c) && D' '(A != b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || c) && D'\'' '\''(A != b || c) && D'\'''

echo '$ test-expr '\''((A != b) || C) && d'\'''
test-expr '((A != b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || C) && d'\'''

echo '$ diff-expr '\''((A != b) || C) && d'\'' '\''(A != b || C) && d'\'''
diff-expr '((A != b) || C) && d' '(A != b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || C) && d'\'' '\''(A != b || C) && d'\'''

echo '$ test-expr '\''((A != b) || C) && D'\'''
test-expr '((A != b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || C) && D'\'''

echo '$ diff-expr '\''((A != b) || C) && D'\'' '\''(A != b || C) && D'\'''
diff-expr '((A != b) || C) && D' '(A != b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || C) && D'\'' '\''(A != b || C) && D'\'''

echo '$ test-expr '\''((A != B) || c) && d'\'''
test-expr '((A != B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || c) && d'\'''

echo '$ diff-expr '\''((A != B) || c) && d'\'' '\''(A != B || c) && d'\'''
diff-expr '((A != B) || c) && d' '(A != B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || c) && d'\'' '\''(A != B || c) && d'\'''

echo '$ test-expr '\''((A != B) || c) && D'\'''
test-expr '((A != B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || c) && D'\'''

echo '$ diff-expr '\''((A != B) || c) && D'\'' '\''(A != B || c) && D'\'''
diff-expr '((A != B) || c) && D' '(A != B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || c) && D'\'' '\''(A != B || c) && D'\'''

echo '$ test-expr '\''((A != B) || C) && d'\'''
test-expr '((A != B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || C) && d'\'''

echo '$ diff-expr '\''((A != B) || C) && d'\'' '\''(A != B || C) && d'\'''
diff-expr '((A != B) || C) && d' '(A != B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || C) && d'\'' '\''(A != B || C) && d'\'''

echo '$ test-expr '\''((A != B) || C) && D'\'''
test-expr '((A != B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || C) && D'\'''

echo '$ diff-expr '\''((A != B) || C) && D'\'' '\''(A != B || C) && D'\'''
diff-expr '((A != B) || C) && D' '(A != B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || C) && D'\'' '\''(A != B || C) && D'\'''

echo '$ test-expr '\''a >= ((b && c) != d)'\'''
test-expr 'a >= ((b && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && c) != d)'\'''

echo '$ test-expr '\''a >= ((b && c) != D)'\'''
test-expr 'a >= ((b && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && c) != D)'\'''

echo '$ test-expr '\''a >= ((b && C) != d)'\'''
test-expr 'a >= ((b && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && C) != d)'\'''

echo '$ test-expr '\''a >= ((b && C) != D)'\'''
test-expr 'a >= ((b && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && C) != D)'\'''

echo '$ test-expr '\''a >= ((B && c) != d)'\'''
test-expr 'a >= ((B && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && c) != d)'\'''

echo '$ test-expr '\''a >= ((B && c) != D)'\'''
test-expr 'a >= ((B && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && c) != D)'\'''

echo '$ test-expr '\''a >= ((B && C) != d)'\'''
test-expr 'a >= ((B && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && C) != d)'\'''

echo '$ test-expr '\''a >= ((B && C) != D)'\'''
test-expr 'a >= ((B && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B && C) != D)'\'''

echo '$ test-expr '\''A >= ((b && c) != d)'\'''
test-expr 'A >= ((b && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && c) != d)'\'''

echo '$ test-expr '\''A >= ((b && c) != D)'\'''
test-expr 'A >= ((b && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && c) != D)'\'''

echo '$ test-expr '\''A >= ((b && C) != d)'\'''
test-expr 'A >= ((b && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && C) != d)'\'''

echo '$ test-expr '\''A >= ((b && C) != D)'\'''
test-expr 'A >= ((b && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b && C) != D)'\'''

echo '$ test-expr '\''A >= ((B && c) != d)'\'''
test-expr 'A >= ((B && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && c) != d)'\'''

echo '$ test-expr '\''A >= ((B && c) != D)'\'''
test-expr 'A >= ((B && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && c) != D)'\'''

echo '$ test-expr '\''A >= ((B && C) != d)'\'''
test-expr 'A >= ((B && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && C) != d)'\'''

echo '$ test-expr '\''A >= ((B && C) != D)'\'''
test-expr 'A >= ((B && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B && C) != D)'\'''

echo '$ test-expr '\''a >= ((b || c) != d)'\'''
test-expr 'a >= ((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || c) != d)'\'''

echo '$ test-expr '\''a >= ((b || c) != D)'\'''
test-expr 'a >= ((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || c) != D)'\'''

echo '$ test-expr '\''a >= ((b || C) != d)'\'''
test-expr 'a >= ((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || C) != d)'\'''

echo '$ test-expr '\''a >= ((b || C) != D)'\'''
test-expr 'a >= ((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || C) != D)'\'''

echo '$ test-expr '\''a >= ((B || c) != d)'\'''
test-expr 'a >= ((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || c) != d)'\'''

echo '$ test-expr '\''a >= ((B || c) != D)'\'''
test-expr 'a >= ((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || c) != D)'\'''

echo '$ test-expr '\''a >= ((B || C) != d)'\'''
test-expr 'a >= ((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || C) != d)'\'''

echo '$ test-expr '\''a >= ((B || C) != D)'\'''
test-expr 'a >= ((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || C) != D)'\'''

echo '$ test-expr '\''A >= ((b || c) != d)'\'''
test-expr 'A >= ((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || c) != d)'\'''

echo '$ test-expr '\''A >= ((b || c) != D)'\'''
test-expr 'A >= ((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || c) != D)'\'''

echo '$ test-expr '\''A >= ((b || C) != d)'\'''
test-expr 'A >= ((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || C) != d)'\'''

echo '$ test-expr '\''A >= ((b || C) != D)'\'''
test-expr 'A >= ((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || C) != D)'\'''

echo '$ test-expr '\''A >= ((B || c) != d)'\'''
test-expr 'A >= ((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || c) != d)'\'''

echo '$ test-expr '\''A >= ((B || c) != D)'\'''
test-expr 'A >= ((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || c) != D)'\'''

echo '$ test-expr '\''A >= ((B || C) != d)'\'''
test-expr 'A >= ((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || C) != d)'\'''

echo '$ test-expr '\''A >= ((B || C) != D)'\'''
test-expr 'A >= ((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || C) != D)'\'''

echo '$ test-expr '\''a >= ((b || c) && d)'\'''
test-expr 'a >= ((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || c) && d)'\'''

echo '$ test-expr '\''a >= ((b || c) && D)'\'''
test-expr 'a >= ((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || c) && D)'\'''

echo '$ test-expr '\''a >= ((b || C) && d)'\'''
test-expr 'a >= ((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || C) && d)'\'''

echo '$ test-expr '\''a >= ((b || C) && D)'\'''
test-expr 'a >= ((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || C) && D)'\'''

echo '$ test-expr '\''a >= ((B || c) && d)'\'''
test-expr 'a >= ((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || c) && d)'\'''

echo '$ test-expr '\''a >= ((B || c) && D)'\'''
test-expr 'a >= ((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || c) && D)'\'''

echo '$ test-expr '\''a >= ((B || C) && d)'\'''
test-expr 'a >= ((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || C) && d)'\'''

echo '$ test-expr '\''a >= ((B || C) && D)'\'''
test-expr 'a >= ((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((B || C) && D)'\'''

echo '$ test-expr '\''A >= ((b || c) && d)'\'''
test-expr 'A >= ((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || c) && d)'\'''

echo '$ test-expr '\''A >= ((b || c) && D)'\'''
test-expr 'A >= ((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || c) && D)'\'''

echo '$ test-expr '\''A >= ((b || C) && d)'\'''
test-expr 'A >= ((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || C) && d)'\'''

echo '$ test-expr '\''A >= ((b || C) && D)'\'''
test-expr 'A >= ((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((b || C) && D)'\'''

echo '$ test-expr '\''A >= ((B || c) && d)'\'''
test-expr 'A >= ((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || c) && d)'\'''

echo '$ test-expr '\''A >= ((B || c) && D)'\'''
test-expr 'A >= ((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || c) && D)'\'''

echo '$ test-expr '\''A >= ((B || C) && d)'\'''
test-expr 'A >= ((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || C) && d)'\'''

echo '$ test-expr '\''A >= ((B || C) && D)'\'''
test-expr 'A >= ((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= ((B || C) && D)'\'''

echo '$ test-expr '\''a != ((b || c) && d)'\'''
test-expr 'a != ((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && d)'\'''

echo '$ test-expr '\''a != ((b || c) && D)'\'''
test-expr 'a != ((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && D)'\'''

echo '$ test-expr '\''a != ((b || C) && d)'\'''
test-expr 'a != ((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || C) && d)'\'''

echo '$ test-expr '\''a != ((b || C) && D)'\'''
test-expr 'a != ((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || C) && D)'\'''

echo '$ test-expr '\''a != ((B || c) && d)'\'''
test-expr 'a != ((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || c) && d)'\'''

echo '$ test-expr '\''a != ((B || c) && D)'\'''
test-expr 'a != ((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || c) && D)'\'''

echo '$ test-expr '\''a != ((B || C) && d)'\'''
test-expr 'a != ((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || C) && d)'\'''

echo '$ test-expr '\''a != ((B || C) && D)'\'''
test-expr 'a != ((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || C) && D)'\'''

echo '$ test-expr '\''A != ((b || c) && d)'\'''
test-expr 'A != ((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || c) && d)'\'''

echo '$ test-expr '\''A != ((b || c) && D)'\'''
test-expr 'A != ((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || c) && D)'\'''

echo '$ test-expr '\''A != ((b || C) && d)'\'''
test-expr 'A != ((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || C) && d)'\'''

echo '$ test-expr '\''A != ((b || C) && D)'\'''
test-expr 'A != ((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || C) && D)'\'''

echo '$ test-expr '\''A != ((B || c) && d)'\'''
test-expr 'A != ((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || c) && d)'\'''

echo '$ test-expr '\''A != ((B || c) && D)'\'''
test-expr 'A != ((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || c) && D)'\'''

echo '$ test-expr '\''A != ((B || C) && d)'\'''
test-expr 'A != ((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || C) && d)'\'''

echo '$ test-expr '\''A != ((B || C) && D)'\'''
test-expr 'A != ((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || C) && D)'\'''

echo '$ test-expr '\''(a >= (b && c)) != d'\'''
test-expr '(a >= (b && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && c)) != d'\'''

echo '$ diff-expr '\''(a >= (b && c)) != d'\'' '\''a >= (b && c) != d'\'''
diff-expr '(a >= (b && c)) != d' 'a >= (b && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) != d'\'' '\''a >= (b && c) != d'\'''

echo '$ test-expr '\''(a >= (b && c)) != D'\'''
test-expr '(a >= (b && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && c)) != D'\'''

echo '$ diff-expr '\''(a >= (b && c)) != D'\'' '\''a >= (b && c) != D'\'''
diff-expr '(a >= (b && c)) != D' 'a >= (b && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) != D'\'' '\''a >= (b && c) != D'\'''

echo '$ test-expr '\''(a >= (b && C)) != d'\'''
test-expr '(a >= (b && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && C)) != d'\'''

echo '$ diff-expr '\''(a >= (b && C)) != d'\'' '\''a >= (b && C) != d'\'''
diff-expr '(a >= (b && C)) != d' 'a >= (b && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && C)) != d'\'' '\''a >= (b && C) != d'\'''

echo '$ test-expr '\''(a >= (b && C)) != D'\'''
test-expr '(a >= (b && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && C)) != D'\'''

echo '$ diff-expr '\''(a >= (b && C)) != D'\'' '\''a >= (b && C) != D'\'''
diff-expr '(a >= (b && C)) != D' 'a >= (b && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && C)) != D'\'' '\''a >= (b && C) != D'\'''

echo '$ test-expr '\''(a >= (B && c)) != d'\'''
test-expr '(a >= (B && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && c)) != d'\'''

echo '$ diff-expr '\''(a >= (B && c)) != d'\'' '\''a >= (B && c) != d'\'''
diff-expr '(a >= (B && c)) != d' 'a >= (B && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && c)) != d'\'' '\''a >= (B && c) != d'\'''

echo '$ test-expr '\''(a >= (B && c)) != D'\'''
test-expr '(a >= (B && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && c)) != D'\'''

echo '$ diff-expr '\''(a >= (B && c)) != D'\'' '\''a >= (B && c) != D'\'''
diff-expr '(a >= (B && c)) != D' 'a >= (B && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && c)) != D'\'' '\''a >= (B && c) != D'\'''

echo '$ test-expr '\''(a >= (B && C)) != d'\'''
test-expr '(a >= (B && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && C)) != d'\'''

echo '$ diff-expr '\''(a >= (B && C)) != d'\'' '\''a >= (B && C) != d'\'''
diff-expr '(a >= (B && C)) != d' 'a >= (B && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && C)) != d'\'' '\''a >= (B && C) != d'\'''

echo '$ test-expr '\''(a >= (B && C)) != D'\'''
test-expr '(a >= (B && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B && C)) != D'\'''

echo '$ diff-expr '\''(a >= (B && C)) != D'\'' '\''a >= (B && C) != D'\'''
diff-expr '(a >= (B && C)) != D' 'a >= (B && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B && C)) != D'\'' '\''a >= (B && C) != D'\'''

echo '$ test-expr '\''(A >= (b && c)) != d'\'''
test-expr '(A >= (b && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && c)) != d'\'''

echo '$ diff-expr '\''(A >= (b && c)) != d'\'' '\''A >= (b && c) != d'\'''
diff-expr '(A >= (b && c)) != d' 'A >= (b && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && c)) != d'\'' '\''A >= (b && c) != d'\'''

echo '$ test-expr '\''(A >= (b && c)) != D'\'''
test-expr '(A >= (b && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && c)) != D'\'''

echo '$ diff-expr '\''(A >= (b && c)) != D'\'' '\''A >= (b && c) != D'\'''
diff-expr '(A >= (b && c)) != D' 'A >= (b && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && c)) != D'\'' '\''A >= (b && c) != D'\'''

echo '$ test-expr '\''(A >= (b && C)) != d'\'''
test-expr '(A >= (b && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && C)) != d'\'''

echo '$ diff-expr '\''(A >= (b && C)) != d'\'' '\''A >= (b && C) != d'\'''
diff-expr '(A >= (b && C)) != d' 'A >= (b && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && C)) != d'\'' '\''A >= (b && C) != d'\'''

echo '$ test-expr '\''(A >= (b && C)) != D'\'''
test-expr '(A >= (b && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b && C)) != D'\'''

echo '$ diff-expr '\''(A >= (b && C)) != D'\'' '\''A >= (b && C) != D'\'''
diff-expr '(A >= (b && C)) != D' 'A >= (b && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b && C)) != D'\'' '\''A >= (b && C) != D'\'''

echo '$ test-expr '\''(A >= (B && c)) != d'\'''
test-expr '(A >= (B && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && c)) != d'\'''

echo '$ diff-expr '\''(A >= (B && c)) != d'\'' '\''A >= (B && c) != d'\'''
diff-expr '(A >= (B && c)) != d' 'A >= (B && c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && c)) != d'\'' '\''A >= (B && c) != d'\'''

echo '$ test-expr '\''(A >= (B && c)) != D'\'''
test-expr '(A >= (B && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && c)) != D'\'''

echo '$ diff-expr '\''(A >= (B && c)) != D'\'' '\''A >= (B && c) != D'\'''
diff-expr '(A >= (B && c)) != D' 'A >= (B && c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && c)) != D'\'' '\''A >= (B && c) != D'\'''

echo '$ test-expr '\''(A >= (B && C)) != d'\'''
test-expr '(A >= (B && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && C)) != d'\'''

echo '$ diff-expr '\''(A >= (B && C)) != d'\'' '\''A >= (B && C) != d'\'''
diff-expr '(A >= (B && C)) != d' 'A >= (B && C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && C)) != d'\'' '\''A >= (B && C) != d'\'''

echo '$ test-expr '\''(A >= (B && C)) != D'\'''
test-expr '(A >= (B && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B && C)) != D'\'''

echo '$ diff-expr '\''(A >= (B && C)) != D'\'' '\''A >= (B && C) != D'\'''
diff-expr '(A >= (B && C)) != D' 'A >= (B && C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B && C)) != D'\'' '\''A >= (B && C) != D'\'''

echo '$ test-expr '\''(a >= (b || c)) != d'\'''
test-expr '(a >= (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || c)) != d'\'''

echo '$ diff-expr '\''(a >= (b || c)) != d'\'' '\''a >= (b || c) != d'\'''
diff-expr '(a >= (b || c)) != d' 'a >= (b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) != d'\'' '\''a >= (b || c) != d'\'''

echo '$ test-expr '\''(a >= (b || c)) != D'\'''
test-expr '(a >= (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || c)) != D'\'''

echo '$ diff-expr '\''(a >= (b || c)) != D'\'' '\''a >= (b || c) != D'\'''
diff-expr '(a >= (b || c)) != D' 'a >= (b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) != D'\'' '\''a >= (b || c) != D'\'''

echo '$ test-expr '\''(a >= (b || C)) != d'\'''
test-expr '(a >= (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || C)) != d'\'''

echo '$ diff-expr '\''(a >= (b || C)) != d'\'' '\''a >= (b || C) != d'\'''
diff-expr '(a >= (b || C)) != d' 'a >= (b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || C)) != d'\'' '\''a >= (b || C) != d'\'''

echo '$ test-expr '\''(a >= (b || C)) != D'\'''
test-expr '(a >= (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || C)) != D'\'''

echo '$ diff-expr '\''(a >= (b || C)) != D'\'' '\''a >= (b || C) != D'\'''
diff-expr '(a >= (b || C)) != D' 'a >= (b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || C)) != D'\'' '\''a >= (b || C) != D'\'''

echo '$ test-expr '\''(a >= (B || c)) != d'\'''
test-expr '(a >= (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || c)) != d'\'''

echo '$ diff-expr '\''(a >= (B || c)) != d'\'' '\''a >= (B || c) != d'\'''
diff-expr '(a >= (B || c)) != d' 'a >= (B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || c)) != d'\'' '\''a >= (B || c) != d'\'''

echo '$ test-expr '\''(a >= (B || c)) != D'\'''
test-expr '(a >= (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || c)) != D'\'''

echo '$ diff-expr '\''(a >= (B || c)) != D'\'' '\''a >= (B || c) != D'\'''
diff-expr '(a >= (B || c)) != D' 'a >= (B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || c)) != D'\'' '\''a >= (B || c) != D'\'''

echo '$ test-expr '\''(a >= (B || C)) != d'\'''
test-expr '(a >= (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || C)) != d'\'''

echo '$ diff-expr '\''(a >= (B || C)) != d'\'' '\''a >= (B || C) != d'\'''
diff-expr '(a >= (B || C)) != d' 'a >= (B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || C)) != d'\'' '\''a >= (B || C) != d'\'''

echo '$ test-expr '\''(a >= (B || C)) != D'\'''
test-expr '(a >= (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || C)) != D'\'''

echo '$ diff-expr '\''(a >= (B || C)) != D'\'' '\''a >= (B || C) != D'\'''
diff-expr '(a >= (B || C)) != D' 'a >= (B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || C)) != D'\'' '\''a >= (B || C) != D'\'''

echo '$ test-expr '\''(A >= (b || c)) != d'\'''
test-expr '(A >= (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || c)) != d'\'''

echo '$ diff-expr '\''(A >= (b || c)) != d'\'' '\''A >= (b || c) != d'\'''
diff-expr '(A >= (b || c)) != d' 'A >= (b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || c)) != d'\'' '\''A >= (b || c) != d'\'''

echo '$ test-expr '\''(A >= (b || c)) != D'\'''
test-expr '(A >= (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || c)) != D'\'''

echo '$ diff-expr '\''(A >= (b || c)) != D'\'' '\''A >= (b || c) != D'\'''
diff-expr '(A >= (b || c)) != D' 'A >= (b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || c)) != D'\'' '\''A >= (b || c) != D'\'''

echo '$ test-expr '\''(A >= (b || C)) != d'\'''
test-expr '(A >= (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || C)) != d'\'''

echo '$ diff-expr '\''(A >= (b || C)) != d'\'' '\''A >= (b || C) != d'\'''
diff-expr '(A >= (b || C)) != d' 'A >= (b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || C)) != d'\'' '\''A >= (b || C) != d'\'''

echo '$ test-expr '\''(A >= (b || C)) != D'\'''
test-expr '(A >= (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || C)) != D'\'''

echo '$ diff-expr '\''(A >= (b || C)) != D'\'' '\''A >= (b || C) != D'\'''
diff-expr '(A >= (b || C)) != D' 'A >= (b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || C)) != D'\'' '\''A >= (b || C) != D'\'''

echo '$ test-expr '\''(A >= (B || c)) != d'\'''
test-expr '(A >= (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || c)) != d'\'''

echo '$ diff-expr '\''(A >= (B || c)) != d'\'' '\''A >= (B || c) != d'\'''
diff-expr '(A >= (B || c)) != d' 'A >= (B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || c)) != d'\'' '\''A >= (B || c) != d'\'''

echo '$ test-expr '\''(A >= (B || c)) != D'\'''
test-expr '(A >= (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || c)) != D'\'''

echo '$ diff-expr '\''(A >= (B || c)) != D'\'' '\''A >= (B || c) != D'\'''
diff-expr '(A >= (B || c)) != D' 'A >= (B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || c)) != D'\'' '\''A >= (B || c) != D'\'''

echo '$ test-expr '\''(A >= (B || C)) != d'\'''
test-expr '(A >= (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || C)) != d'\'''

echo '$ diff-expr '\''(A >= (B || C)) != d'\'' '\''A >= (B || C) != d'\'''
diff-expr '(A >= (B || C)) != d' 'A >= (B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || C)) != d'\'' '\''A >= (B || C) != d'\'''

echo '$ test-expr '\''(A >= (B || C)) != D'\'''
test-expr '(A >= (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || C)) != D'\'''

echo '$ diff-expr '\''(A >= (B || C)) != D'\'' '\''A >= (B || C) != D'\'''
diff-expr '(A >= (B || C)) != D' 'A >= (B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || C)) != D'\'' '\''A >= (B || C) != D'\'''

echo '$ test-expr '\''(a >= (b || c)) && d'\'''
test-expr '(a >= (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || c)) && d'\'''

echo '$ diff-expr '\''(a >= (b || c)) && d'\'' '\''a >= (b || c) && d'\'''
diff-expr '(a >= (b || c)) && d' 'a >= (b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) && d'\'' '\''a >= (b || c) && d'\'''

echo '$ test-expr '\''(a >= (b || c)) && D'\'''
test-expr '(a >= (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || c)) && D'\'''

echo '$ diff-expr '\''(a >= (b || c)) && D'\'' '\''a >= (b || c) && D'\'''
diff-expr '(a >= (b || c)) && D' 'a >= (b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) && D'\'' '\''a >= (b || c) && D'\'''

echo '$ test-expr '\''(a >= (b || C)) && d'\'''
test-expr '(a >= (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || C)) && d'\'''

echo '$ diff-expr '\''(a >= (b || C)) && d'\'' '\''a >= (b || C) && d'\'''
diff-expr '(a >= (b || C)) && d' 'a >= (b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || C)) && d'\'' '\''a >= (b || C) && d'\'''

echo '$ test-expr '\''(a >= (b || C)) && D'\'''
test-expr '(a >= (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || C)) && D'\'''

echo '$ diff-expr '\''(a >= (b || C)) && D'\'' '\''a >= (b || C) && D'\'''
diff-expr '(a >= (b || C)) && D' 'a >= (b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || C)) && D'\'' '\''a >= (b || C) && D'\'''

echo '$ test-expr '\''(a >= (B || c)) && d'\'''
test-expr '(a >= (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || c)) && d'\'''

echo '$ diff-expr '\''(a >= (B || c)) && d'\'' '\''a >= (B || c) && d'\'''
diff-expr '(a >= (B || c)) && d' 'a >= (B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || c)) && d'\'' '\''a >= (B || c) && d'\'''

echo '$ test-expr '\''(a >= (B || c)) && D'\'''
test-expr '(a >= (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || c)) && D'\'''

echo '$ diff-expr '\''(a >= (B || c)) && D'\'' '\''a >= (B || c) && D'\'''
diff-expr '(a >= (B || c)) && D' 'a >= (B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || c)) && D'\'' '\''a >= (B || c) && D'\'''

echo '$ test-expr '\''(a >= (B || C)) && d'\'''
test-expr '(a >= (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || C)) && d'\'''

echo '$ diff-expr '\''(a >= (B || C)) && d'\'' '\''a >= (B || C) && d'\'''
diff-expr '(a >= (B || C)) && d' 'a >= (B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || C)) && d'\'' '\''a >= (B || C) && d'\'''

echo '$ test-expr '\''(a >= (B || C)) && D'\'''
test-expr '(a >= (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (B || C)) && D'\'''

echo '$ diff-expr '\''(a >= (B || C)) && D'\'' '\''a >= (B || C) && D'\'''
diff-expr '(a >= (B || C)) && D' 'a >= (B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (B || C)) && D'\'' '\''a >= (B || C) && D'\'''

echo '$ test-expr '\''(A >= (b || c)) && d'\'''
test-expr '(A >= (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || c)) && d'\'''

echo '$ diff-expr '\''(A >= (b || c)) && d'\'' '\''A >= (b || c) && d'\'''
diff-expr '(A >= (b || c)) && d' 'A >= (b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || c)) && d'\'' '\''A >= (b || c) && d'\'''

echo '$ test-expr '\''(A >= (b || c)) && D'\'''
test-expr '(A >= (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || c)) && D'\'''

echo '$ diff-expr '\''(A >= (b || c)) && D'\'' '\''A >= (b || c) && D'\'''
diff-expr '(A >= (b || c)) && D' 'A >= (b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || c)) && D'\'' '\''A >= (b || c) && D'\'''

echo '$ test-expr '\''(A >= (b || C)) && d'\'''
test-expr '(A >= (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || C)) && d'\'''

echo '$ diff-expr '\''(A >= (b || C)) && d'\'' '\''A >= (b || C) && d'\'''
diff-expr '(A >= (b || C)) && d' 'A >= (b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || C)) && d'\'' '\''A >= (b || C) && d'\'''

echo '$ test-expr '\''(A >= (b || C)) && D'\'''
test-expr '(A >= (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (b || C)) && D'\'''

echo '$ diff-expr '\''(A >= (b || C)) && D'\'' '\''A >= (b || C) && D'\'''
diff-expr '(A >= (b || C)) && D' 'A >= (b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (b || C)) && D'\'' '\''A >= (b || C) && D'\'''

echo '$ test-expr '\''(A >= (B || c)) && d'\'''
test-expr '(A >= (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || c)) && d'\'''

echo '$ diff-expr '\''(A >= (B || c)) && d'\'' '\''A >= (B || c) && d'\'''
diff-expr '(A >= (B || c)) && d' 'A >= (B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || c)) && d'\'' '\''A >= (B || c) && d'\'''

echo '$ test-expr '\''(A >= (B || c)) && D'\'''
test-expr '(A >= (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || c)) && D'\'''

echo '$ diff-expr '\''(A >= (B || c)) && D'\'' '\''A >= (B || c) && D'\'''
diff-expr '(A >= (B || c)) && D' 'A >= (B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || c)) && D'\'' '\''A >= (B || c) && D'\'''

echo '$ test-expr '\''(A >= (B || C)) && d'\'''
test-expr '(A >= (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || C)) && d'\'''

echo '$ diff-expr '\''(A >= (B || C)) && d'\'' '\''A >= (B || C) && d'\'''
diff-expr '(A >= (B || C)) && d' 'A >= (B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || C)) && d'\'' '\''A >= (B || C) && d'\'''

echo '$ test-expr '\''(A >= (B || C)) && D'\'''
test-expr '(A >= (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A >= (B || C)) && D'\'''

echo '$ diff-expr '\''(A >= (B || C)) && D'\'' '\''A >= (B || C) && D'\'''
diff-expr '(A >= (B || C)) && D' 'A >= (B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= (B || C)) && D'\'' '\''A >= (B || C) && D'\'''

echo '$ test-expr '\''(a != (b || c)) && d'\'''
test-expr '(a != (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || c)) && d'\'''

echo '$ diff-expr '\''(a != (b || c)) && d'\'' '\''a != (b || c) && d'\'''
diff-expr '(a != (b || c)) && d' 'a != (b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || c)) && d'\'' '\''a != (b || c) && d'\'''

echo '$ test-expr '\''(a != (b || c)) && D'\'''
test-expr '(a != (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || c)) && D'\'''

echo '$ diff-expr '\''(a != (b || c)) && D'\'' '\''a != (b || c) && D'\'''
diff-expr '(a != (b || c)) && D' 'a != (b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || c)) && D'\'' '\''a != (b || c) && D'\'''

echo '$ test-expr '\''(a != (b || C)) && d'\'''
test-expr '(a != (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || C)) && d'\'''

echo '$ diff-expr '\''(a != (b || C)) && d'\'' '\''a != (b || C) && d'\'''
diff-expr '(a != (b || C)) && d' 'a != (b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || C)) && d'\'' '\''a != (b || C) && d'\'''

echo '$ test-expr '\''(a != (b || C)) && D'\'''
test-expr '(a != (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || C)) && D'\'''

echo '$ diff-expr '\''(a != (b || C)) && D'\'' '\''a != (b || C) && D'\'''
diff-expr '(a != (b || C)) && D' 'a != (b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || C)) && D'\'' '\''a != (b || C) && D'\'''

echo '$ test-expr '\''(a != (B || c)) && d'\'''
test-expr '(a != (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || c)) && d'\'''

echo '$ diff-expr '\''(a != (B || c)) && d'\'' '\''a != (B || c) && d'\'''
diff-expr '(a != (B || c)) && d' 'a != (B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B || c)) && d'\'' '\''a != (B || c) && d'\'''

echo '$ test-expr '\''(a != (B || c)) && D'\'''
test-expr '(a != (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || c)) && D'\'''

echo '$ diff-expr '\''(a != (B || c)) && D'\'' '\''a != (B || c) && D'\'''
diff-expr '(a != (B || c)) && D' 'a != (B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B || c)) && D'\'' '\''a != (B || c) && D'\'''

echo '$ test-expr '\''(a != (B || C)) && d'\'''
test-expr '(a != (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || C)) && d'\'''

echo '$ diff-expr '\''(a != (B || C)) && d'\'' '\''a != (B || C) && d'\'''
diff-expr '(a != (B || C)) && d' 'a != (B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B || C)) && d'\'' '\''a != (B || C) && d'\'''

echo '$ test-expr '\''(a != (B || C)) && D'\'''
test-expr '(a != (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || C)) && D'\'''

echo '$ diff-expr '\''(a != (B || C)) && D'\'' '\''a != (B || C) && D'\'''
diff-expr '(a != (B || C)) && D' 'a != (B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B || C)) && D'\'' '\''a != (B || C) && D'\'''

echo '$ test-expr '\''(A != (b || c)) && d'\'''
test-expr '(A != (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || c)) && d'\'''

echo '$ diff-expr '\''(A != (b || c)) && d'\'' '\''A != (b || c) && d'\'''
diff-expr '(A != (b || c)) && d' 'A != (b || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b || c)) && d'\'' '\''A != (b || c) && d'\'''

echo '$ test-expr '\''(A != (b || c)) && D'\'''
test-expr '(A != (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || c)) && D'\'''

echo '$ diff-expr '\''(A != (b || c)) && D'\'' '\''A != (b || c) && D'\'''
diff-expr '(A != (b || c)) && D' 'A != (b || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b || c)) && D'\'' '\''A != (b || c) && D'\'''

echo '$ test-expr '\''(A != (b || C)) && d'\'''
test-expr '(A != (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || C)) && d'\'''

echo '$ diff-expr '\''(A != (b || C)) && d'\'' '\''A != (b || C) && d'\'''
diff-expr '(A != (b || C)) && d' 'A != (b || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b || C)) && d'\'' '\''A != (b || C) && d'\'''

echo '$ test-expr '\''(A != (b || C)) && D'\'''
test-expr '(A != (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || C)) && D'\'''

echo '$ diff-expr '\''(A != (b || C)) && D'\'' '\''A != (b || C) && D'\'''
diff-expr '(A != (b || C)) && D' 'A != (b || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b || C)) && D'\'' '\''A != (b || C) && D'\'''

echo '$ test-expr '\''(A != (B || c)) && d'\'''
test-expr '(A != (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || c)) && d'\'''

echo '$ diff-expr '\''(A != (B || c)) && d'\'' '\''A != (B || c) && d'\'''
diff-expr '(A != (B || c)) && d' 'A != (B || c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B || c)) && d'\'' '\''A != (B || c) && d'\'''

echo '$ test-expr '\''(A != (B || c)) && D'\'''
test-expr '(A != (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || c)) && D'\'''

echo '$ diff-expr '\''(A != (B || c)) && D'\'' '\''A != (B || c) && D'\'''
diff-expr '(A != (B || c)) && D' 'A != (B || c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B || c)) && D'\'' '\''A != (B || c) && D'\'''

echo '$ test-expr '\''(A != (B || C)) && d'\'''
test-expr '(A != (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || C)) && d'\'''

echo '$ diff-expr '\''(A != (B || C)) && d'\'' '\''A != (B || C) && d'\'''
diff-expr '(A != (B || C)) && d' 'A != (B || C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B || C)) && d'\'' '\''A != (B || C) && d'\'''

echo '$ test-expr '\''(A != (B || C)) && D'\'''
test-expr '(A != (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || C)) && D'\'''

echo '$ diff-expr '\''(A != (B || C)) && D'\'' '\''A != (B || C) && D'\'''
diff-expr '(A != (B || C)) && D' 'A != (B || C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B || C)) && D'\'' '\''A != (B || C) && D'\'''

echo '$ test-expr '\''(a >= b) && (c != d)'\'''
test-expr '(a >= b) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (c != d)'\'''

echo '$ diff-expr '\''(a >= b) && (c != d)'\'' '\''a >= b && (c != d)'\'''
diff-expr '(a >= b) && (c != d)' 'a >= b && (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != d)'\'' '\''a >= b && (c != d)'\'''

echo '$ diff-expr '\''(a >= b) && (c != d)'\'' '\''a >= b && c != d'\'''
diff-expr '(a >= b) && (c != d)' 'a >= b && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != d)'\'' '\''a >= b && c != d'\'''

echo '$ diff-expr '\''(a >= b) && (c != d)'\'' '\''(a >= b) && c != d'\'''
diff-expr '(a >= b) && (c != d)' '(a >= b) && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != d)'\'' '\''(a >= b) && c != d'\'''

echo '$ test-expr '\''(a >= b) && (c != D)'\'''
test-expr '(a >= b) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (c != D)'\'''

echo '$ diff-expr '\''(a >= b) && (c != D)'\'' '\''a >= b && (c != D)'\'''
diff-expr '(a >= b) && (c != D)' 'a >= b && (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != D)'\'' '\''a >= b && (c != D)'\'''

echo '$ diff-expr '\''(a >= b) && (c != D)'\'' '\''a >= b && c != D'\'''
diff-expr '(a >= b) && (c != D)' 'a >= b && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != D)'\'' '\''a >= b && c != D'\'''

echo '$ diff-expr '\''(a >= b) && (c != D)'\'' '\''(a >= b) && c != D'\'''
diff-expr '(a >= b) && (c != D)' '(a >= b) && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != D)'\'' '\''(a >= b) && c != D'\'''

echo '$ test-expr '\''(a >= b) && (C != d)'\'''
test-expr '(a >= b) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (C != d)'\'''

echo '$ diff-expr '\''(a >= b) && (C != d)'\'' '\''a >= b && (C != d)'\'''
diff-expr '(a >= b) && (C != d)' 'a >= b && (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C != d)'\'' '\''a >= b && (C != d)'\'''

echo '$ diff-expr '\''(a >= b) && (C != d)'\'' '\''a >= b && C != d'\'''
diff-expr '(a >= b) && (C != d)' 'a >= b && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C != d)'\'' '\''a >= b && C != d'\'''

echo '$ diff-expr '\''(a >= b) && (C != d)'\'' '\''(a >= b) && C != d'\'''
diff-expr '(a >= b) && (C != d)' '(a >= b) && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C != d)'\'' '\''(a >= b) && C != d'\'''

echo '$ test-expr '\''(a >= b) && (C != D)'\'''
test-expr '(a >= b) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (C != D)'\'''

echo '$ diff-expr '\''(a >= b) && (C != D)'\'' '\''a >= b && (C != D)'\'''
diff-expr '(a >= b) && (C != D)' 'a >= b && (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C != D)'\'' '\''a >= b && (C != D)'\'''

echo '$ diff-expr '\''(a >= b) && (C != D)'\'' '\''a >= b && C != D'\'''
diff-expr '(a >= b) && (C != D)' 'a >= b && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C != D)'\'' '\''a >= b && C != D'\'''

echo '$ diff-expr '\''(a >= b) && (C != D)'\'' '\''(a >= b) && C != D'\'''
diff-expr '(a >= b) && (C != D)' '(a >= b) && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (C != D)'\'' '\''(a >= b) && C != D'\'''

echo '$ test-expr '\''(a >= B) && (c != d)'\'''
test-expr '(a >= B) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (c != d)'\'''

echo '$ diff-expr '\''(a >= B) && (c != d)'\'' '\''a >= B && (c != d)'\'''
diff-expr '(a >= B) && (c != d)' 'a >= B && (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c != d)'\'' '\''a >= B && (c != d)'\'''

echo '$ diff-expr '\''(a >= B) && (c != d)'\'' '\''a >= B && c != d'\'''
diff-expr '(a >= B) && (c != d)' 'a >= B && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c != d)'\'' '\''a >= B && c != d'\'''

echo '$ diff-expr '\''(a >= B) && (c != d)'\'' '\''(a >= B) && c != d'\'''
diff-expr '(a >= B) && (c != d)' '(a >= B) && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c != d)'\'' '\''(a >= B) && c != d'\'''

echo '$ test-expr '\''(a >= B) && (c != D)'\'''
test-expr '(a >= B) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (c != D)'\'''

echo '$ diff-expr '\''(a >= B) && (c != D)'\'' '\''a >= B && (c != D)'\'''
diff-expr '(a >= B) && (c != D)' 'a >= B && (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c != D)'\'' '\''a >= B && (c != D)'\'''

echo '$ diff-expr '\''(a >= B) && (c != D)'\'' '\''a >= B && c != D'\'''
diff-expr '(a >= B) && (c != D)' 'a >= B && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c != D)'\'' '\''a >= B && c != D'\'''

echo '$ diff-expr '\''(a >= B) && (c != D)'\'' '\''(a >= B) && c != D'\'''
diff-expr '(a >= B) && (c != D)' '(a >= B) && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (c != D)'\'' '\''(a >= B) && c != D'\'''

echo '$ test-expr '\''(a >= B) && (C != d)'\'''
test-expr '(a >= B) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (C != d)'\'''

echo '$ diff-expr '\''(a >= B) && (C != d)'\'' '\''a >= B && (C != d)'\'''
diff-expr '(a >= B) && (C != d)' 'a >= B && (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C != d)'\'' '\''a >= B && (C != d)'\'''

echo '$ diff-expr '\''(a >= B) && (C != d)'\'' '\''a >= B && C != d'\'''
diff-expr '(a >= B) && (C != d)' 'a >= B && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C != d)'\'' '\''a >= B && C != d'\'''

echo '$ diff-expr '\''(a >= B) && (C != d)'\'' '\''(a >= B) && C != d'\'''
diff-expr '(a >= B) && (C != d)' '(a >= B) && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C != d)'\'' '\''(a >= B) && C != d'\'''

echo '$ test-expr '\''(a >= B) && (C != D)'\'''
test-expr '(a >= B) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) && (C != D)'\'''

echo '$ diff-expr '\''(a >= B) && (C != D)'\'' '\''a >= B && (C != D)'\'''
diff-expr '(a >= B) && (C != D)' 'a >= B && (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C != D)'\'' '\''a >= B && (C != D)'\'''

echo '$ diff-expr '\''(a >= B) && (C != D)'\'' '\''a >= B && C != D'\'''
diff-expr '(a >= B) && (C != D)' 'a >= B && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C != D)'\'' '\''a >= B && C != D'\'''

echo '$ diff-expr '\''(a >= B) && (C != D)'\'' '\''(a >= B) && C != D'\'''
diff-expr '(a >= B) && (C != D)' '(a >= B) && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) && (C != D)'\'' '\''(a >= B) && C != D'\'''

echo '$ test-expr '\''(A >= b) && (c != d)'\'''
test-expr '(A >= b) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (c != d)'\'''

echo '$ diff-expr '\''(A >= b) && (c != d)'\'' '\''A >= b && (c != d)'\'''
diff-expr '(A >= b) && (c != d)' 'A >= b && (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c != d)'\'' '\''A >= b && (c != d)'\'''

echo '$ diff-expr '\''(A >= b) && (c != d)'\'' '\''A >= b && c != d'\'''
diff-expr '(A >= b) && (c != d)' 'A >= b && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c != d)'\'' '\''A >= b && c != d'\'''

echo '$ diff-expr '\''(A >= b) && (c != d)'\'' '\''(A >= b) && c != d'\'''
diff-expr '(A >= b) && (c != d)' '(A >= b) && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c != d)'\'' '\''(A >= b) && c != d'\'''

echo '$ test-expr '\''(A >= b) && (c != D)'\'''
test-expr '(A >= b) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (c != D)'\'''

echo '$ diff-expr '\''(A >= b) && (c != D)'\'' '\''A >= b && (c != D)'\'''
diff-expr '(A >= b) && (c != D)' 'A >= b && (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c != D)'\'' '\''A >= b && (c != D)'\'''

echo '$ diff-expr '\''(A >= b) && (c != D)'\'' '\''A >= b && c != D'\'''
diff-expr '(A >= b) && (c != D)' 'A >= b && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c != D)'\'' '\''A >= b && c != D'\'''

echo '$ diff-expr '\''(A >= b) && (c != D)'\'' '\''(A >= b) && c != D'\'''
diff-expr '(A >= b) && (c != D)' '(A >= b) && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (c != D)'\'' '\''(A >= b) && c != D'\'''

echo '$ test-expr '\''(A >= b) && (C != d)'\'''
test-expr '(A >= b) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (C != d)'\'''

echo '$ diff-expr '\''(A >= b) && (C != d)'\'' '\''A >= b && (C != d)'\'''
diff-expr '(A >= b) && (C != d)' 'A >= b && (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C != d)'\'' '\''A >= b && (C != d)'\'''

echo '$ diff-expr '\''(A >= b) && (C != d)'\'' '\''A >= b && C != d'\'''
diff-expr '(A >= b) && (C != d)' 'A >= b && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C != d)'\'' '\''A >= b && C != d'\'''

echo '$ diff-expr '\''(A >= b) && (C != d)'\'' '\''(A >= b) && C != d'\'''
diff-expr '(A >= b) && (C != d)' '(A >= b) && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C != d)'\'' '\''(A >= b) && C != d'\'''

echo '$ test-expr '\''(A >= b) && (C != D)'\'''
test-expr '(A >= b) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) && (C != D)'\'''

echo '$ diff-expr '\''(A >= b) && (C != D)'\'' '\''A >= b && (C != D)'\'''
diff-expr '(A >= b) && (C != D)' 'A >= b && (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C != D)'\'' '\''A >= b && (C != D)'\'''

echo '$ diff-expr '\''(A >= b) && (C != D)'\'' '\''A >= b && C != D'\'''
diff-expr '(A >= b) && (C != D)' 'A >= b && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C != D)'\'' '\''A >= b && C != D'\'''

echo '$ diff-expr '\''(A >= b) && (C != D)'\'' '\''(A >= b) && C != D'\'''
diff-expr '(A >= b) && (C != D)' '(A >= b) && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) && (C != D)'\'' '\''(A >= b) && C != D'\'''

echo '$ test-expr '\''(A >= B) && (c != d)'\'''
test-expr '(A >= B) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (c != d)'\'''

echo '$ diff-expr '\''(A >= B) && (c != d)'\'' '\''A >= B && (c != d)'\'''
diff-expr '(A >= B) && (c != d)' 'A >= B && (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c != d)'\'' '\''A >= B && (c != d)'\'''

echo '$ diff-expr '\''(A >= B) && (c != d)'\'' '\''A >= B && c != d'\'''
diff-expr '(A >= B) && (c != d)' 'A >= B && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c != d)'\'' '\''A >= B && c != d'\'''

echo '$ diff-expr '\''(A >= B) && (c != d)'\'' '\''(A >= B) && c != d'\'''
diff-expr '(A >= B) && (c != d)' '(A >= B) && c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c != d)'\'' '\''(A >= B) && c != d'\'''

echo '$ test-expr '\''(A >= B) && (c != D)'\'''
test-expr '(A >= B) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (c != D)'\'''

echo '$ diff-expr '\''(A >= B) && (c != D)'\'' '\''A >= B && (c != D)'\'''
diff-expr '(A >= B) && (c != D)' 'A >= B && (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c != D)'\'' '\''A >= B && (c != D)'\'''

echo '$ diff-expr '\''(A >= B) && (c != D)'\'' '\''A >= B && c != D'\'''
diff-expr '(A >= B) && (c != D)' 'A >= B && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c != D)'\'' '\''A >= B && c != D'\'''

echo '$ diff-expr '\''(A >= B) && (c != D)'\'' '\''(A >= B) && c != D'\'''
diff-expr '(A >= B) && (c != D)' '(A >= B) && c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (c != D)'\'' '\''(A >= B) && c != D'\'''

echo '$ test-expr '\''(A >= B) && (C != d)'\'''
test-expr '(A >= B) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (C != d)'\'''

echo '$ diff-expr '\''(A >= B) && (C != d)'\'' '\''A >= B && (C != d)'\'''
diff-expr '(A >= B) && (C != d)' 'A >= B && (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C != d)'\'' '\''A >= B && (C != d)'\'''

echo '$ diff-expr '\''(A >= B) && (C != d)'\'' '\''A >= B && C != d'\'''
diff-expr '(A >= B) && (C != d)' 'A >= B && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C != d)'\'' '\''A >= B && C != d'\'''

echo '$ diff-expr '\''(A >= B) && (C != d)'\'' '\''(A >= B) && C != d'\'''
diff-expr '(A >= B) && (C != d)' '(A >= B) && C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C != d)'\'' '\''(A >= B) && C != d'\'''

echo '$ test-expr '\''(A >= B) && (C != D)'\'''
test-expr '(A >= B) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) && (C != D)'\'''

echo '$ diff-expr '\''(A >= B) && (C != D)'\'' '\''A >= B && (C != D)'\'''
diff-expr '(A >= B) && (C != D)' 'A >= B && (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C != D)'\'' '\''A >= B && (C != D)'\'''

echo '$ diff-expr '\''(A >= B) && (C != D)'\'' '\''A >= B && C != D'\'''
diff-expr '(A >= B) && (C != D)' 'A >= B && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C != D)'\'' '\''A >= B && C != D'\'''

echo '$ diff-expr '\''(A >= B) && (C != D)'\'' '\''(A >= B) && C != D'\'''
diff-expr '(A >= B) && (C != D)' '(A >= B) && C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) && (C != D)'\'' '\''(A >= B) && C != D'\'''

echo '$ test-expr '\''(a >= b) || (c != d)'\'''
test-expr '(a >= b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (c != d)'\'''

echo '$ diff-expr '\''(a >= b) || (c != d)'\'' '\''a >= b || (c != d)'\'''
diff-expr '(a >= b) || (c != d)' 'a >= b || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != d)'\'' '\''a >= b || (c != d)'\'''

echo '$ diff-expr '\''(a >= b) || (c != d)'\'' '\''a >= b || c != d'\'''
diff-expr '(a >= b) || (c != d)' 'a >= b || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != d)'\'' '\''a >= b || c != d'\'''

echo '$ diff-expr '\''(a >= b) || (c != d)'\'' '\''(a >= b) || c != d'\'''
diff-expr '(a >= b) || (c != d)' '(a >= b) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != d)'\'' '\''(a >= b) || c != d'\'''

echo '$ test-expr '\''(a >= b) || (c != D)'\'''
test-expr '(a >= b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (c != D)'\'''

echo '$ diff-expr '\''(a >= b) || (c != D)'\'' '\''a >= b || (c != D)'\'''
diff-expr '(a >= b) || (c != D)' 'a >= b || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != D)'\'' '\''a >= b || (c != D)'\'''

echo '$ diff-expr '\''(a >= b) || (c != D)'\'' '\''a >= b || c != D'\'''
diff-expr '(a >= b) || (c != D)' 'a >= b || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != D)'\'' '\''a >= b || c != D'\'''

echo '$ diff-expr '\''(a >= b) || (c != D)'\'' '\''(a >= b) || c != D'\'''
diff-expr '(a >= b) || (c != D)' '(a >= b) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != D)'\'' '\''(a >= b) || c != D'\'''

echo '$ test-expr '\''(a >= b) || (C != d)'\'''
test-expr '(a >= b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (C != d)'\'''

echo '$ diff-expr '\''(a >= b) || (C != d)'\'' '\''a >= b || (C != d)'\'''
diff-expr '(a >= b) || (C != d)' 'a >= b || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C != d)'\'' '\''a >= b || (C != d)'\'''

echo '$ diff-expr '\''(a >= b) || (C != d)'\'' '\''a >= b || C != d'\'''
diff-expr '(a >= b) || (C != d)' 'a >= b || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C != d)'\'' '\''a >= b || C != d'\'''

echo '$ diff-expr '\''(a >= b) || (C != d)'\'' '\''(a >= b) || C != d'\'''
diff-expr '(a >= b) || (C != d)' '(a >= b) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C != d)'\'' '\''(a >= b) || C != d'\'''

echo '$ test-expr '\''(a >= b) || (C != D)'\'''
test-expr '(a >= b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (C != D)'\'''

echo '$ diff-expr '\''(a >= b) || (C != D)'\'' '\''a >= b || (C != D)'\'''
diff-expr '(a >= b) || (C != D)' 'a >= b || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C != D)'\'' '\''a >= b || (C != D)'\'''

echo '$ diff-expr '\''(a >= b) || (C != D)'\'' '\''a >= b || C != D'\'''
diff-expr '(a >= b) || (C != D)' 'a >= b || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C != D)'\'' '\''a >= b || C != D'\'''

echo '$ diff-expr '\''(a >= b) || (C != D)'\'' '\''(a >= b) || C != D'\'''
diff-expr '(a >= b) || (C != D)' '(a >= b) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C != D)'\'' '\''(a >= b) || C != D'\'''

echo '$ test-expr '\''(a >= B) || (c != d)'\'''
test-expr '(a >= B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (c != d)'\'''

echo '$ diff-expr '\''(a >= B) || (c != d)'\'' '\''a >= B || (c != d)'\'''
diff-expr '(a >= B) || (c != d)' 'a >= B || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c != d)'\'' '\''a >= B || (c != d)'\'''

echo '$ diff-expr '\''(a >= B) || (c != d)'\'' '\''a >= B || c != d'\'''
diff-expr '(a >= B) || (c != d)' 'a >= B || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c != d)'\'' '\''a >= B || c != d'\'''

echo '$ diff-expr '\''(a >= B) || (c != d)'\'' '\''(a >= B) || c != d'\'''
diff-expr '(a >= B) || (c != d)' '(a >= B) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c != d)'\'' '\''(a >= B) || c != d'\'''

echo '$ test-expr '\''(a >= B) || (c != D)'\'''
test-expr '(a >= B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (c != D)'\'''

echo '$ diff-expr '\''(a >= B) || (c != D)'\'' '\''a >= B || (c != D)'\'''
diff-expr '(a >= B) || (c != D)' 'a >= B || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c != D)'\'' '\''a >= B || (c != D)'\'''

echo '$ diff-expr '\''(a >= B) || (c != D)'\'' '\''a >= B || c != D'\'''
diff-expr '(a >= B) || (c != D)' 'a >= B || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c != D)'\'' '\''a >= B || c != D'\'''

echo '$ diff-expr '\''(a >= B) || (c != D)'\'' '\''(a >= B) || c != D'\'''
diff-expr '(a >= B) || (c != D)' '(a >= B) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c != D)'\'' '\''(a >= B) || c != D'\'''

echo '$ test-expr '\''(a >= B) || (C != d)'\'''
test-expr '(a >= B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (C != d)'\'''

echo '$ diff-expr '\''(a >= B) || (C != d)'\'' '\''a >= B || (C != d)'\'''
diff-expr '(a >= B) || (C != d)' 'a >= B || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C != d)'\'' '\''a >= B || (C != d)'\'''

echo '$ diff-expr '\''(a >= B) || (C != d)'\'' '\''a >= B || C != d'\'''
diff-expr '(a >= B) || (C != d)' 'a >= B || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C != d)'\'' '\''a >= B || C != d'\'''

echo '$ diff-expr '\''(a >= B) || (C != d)'\'' '\''(a >= B) || C != d'\'''
diff-expr '(a >= B) || (C != d)' '(a >= B) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C != d)'\'' '\''(a >= B) || C != d'\'''

echo '$ test-expr '\''(a >= B) || (C != D)'\'''
test-expr '(a >= B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (C != D)'\'''

echo '$ diff-expr '\''(a >= B) || (C != D)'\'' '\''a >= B || (C != D)'\'''
diff-expr '(a >= B) || (C != D)' 'a >= B || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C != D)'\'' '\''a >= B || (C != D)'\'''

echo '$ diff-expr '\''(a >= B) || (C != D)'\'' '\''a >= B || C != D'\'''
diff-expr '(a >= B) || (C != D)' 'a >= B || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C != D)'\'' '\''a >= B || C != D'\'''

echo '$ diff-expr '\''(a >= B) || (C != D)'\'' '\''(a >= B) || C != D'\'''
diff-expr '(a >= B) || (C != D)' '(a >= B) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C != D)'\'' '\''(a >= B) || C != D'\'''

echo '$ test-expr '\''(A >= b) || (c != d)'\'''
test-expr '(A >= b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (c != d)'\'''

echo '$ diff-expr '\''(A >= b) || (c != d)'\'' '\''A >= b || (c != d)'\'''
diff-expr '(A >= b) || (c != d)' 'A >= b || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c != d)'\'' '\''A >= b || (c != d)'\'''

echo '$ diff-expr '\''(A >= b) || (c != d)'\'' '\''A >= b || c != d'\'''
diff-expr '(A >= b) || (c != d)' 'A >= b || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c != d)'\'' '\''A >= b || c != d'\'''

echo '$ diff-expr '\''(A >= b) || (c != d)'\'' '\''(A >= b) || c != d'\'''
diff-expr '(A >= b) || (c != d)' '(A >= b) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c != d)'\'' '\''(A >= b) || c != d'\'''

echo '$ test-expr '\''(A >= b) || (c != D)'\'''
test-expr '(A >= b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (c != D)'\'''

echo '$ diff-expr '\''(A >= b) || (c != D)'\'' '\''A >= b || (c != D)'\'''
diff-expr '(A >= b) || (c != D)' 'A >= b || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c != D)'\'' '\''A >= b || (c != D)'\'''

echo '$ diff-expr '\''(A >= b) || (c != D)'\'' '\''A >= b || c != D'\'''
diff-expr '(A >= b) || (c != D)' 'A >= b || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c != D)'\'' '\''A >= b || c != D'\'''

echo '$ diff-expr '\''(A >= b) || (c != D)'\'' '\''(A >= b) || c != D'\'''
diff-expr '(A >= b) || (c != D)' '(A >= b) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c != D)'\'' '\''(A >= b) || c != D'\'''

echo '$ test-expr '\''(A >= b) || (C != d)'\'''
test-expr '(A >= b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (C != d)'\'''

echo '$ diff-expr '\''(A >= b) || (C != d)'\'' '\''A >= b || (C != d)'\'''
diff-expr '(A >= b) || (C != d)' 'A >= b || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C != d)'\'' '\''A >= b || (C != d)'\'''

echo '$ diff-expr '\''(A >= b) || (C != d)'\'' '\''A >= b || C != d'\'''
diff-expr '(A >= b) || (C != d)' 'A >= b || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C != d)'\'' '\''A >= b || C != d'\'''

echo '$ diff-expr '\''(A >= b) || (C != d)'\'' '\''(A >= b) || C != d'\'''
diff-expr '(A >= b) || (C != d)' '(A >= b) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C != d)'\'' '\''(A >= b) || C != d'\'''

echo '$ test-expr '\''(A >= b) || (C != D)'\'''
test-expr '(A >= b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (C != D)'\'''

echo '$ diff-expr '\''(A >= b) || (C != D)'\'' '\''A >= b || (C != D)'\'''
diff-expr '(A >= b) || (C != D)' 'A >= b || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C != D)'\'' '\''A >= b || (C != D)'\'''

echo '$ diff-expr '\''(A >= b) || (C != D)'\'' '\''A >= b || C != D'\'''
diff-expr '(A >= b) || (C != D)' 'A >= b || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C != D)'\'' '\''A >= b || C != D'\'''

echo '$ diff-expr '\''(A >= b) || (C != D)'\'' '\''(A >= b) || C != D'\'''
diff-expr '(A >= b) || (C != D)' '(A >= b) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C != D)'\'' '\''(A >= b) || C != D'\'''

echo '$ test-expr '\''(A >= B) || (c != d)'\'''
test-expr '(A >= B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (c != d)'\'''

echo '$ diff-expr '\''(A >= B) || (c != d)'\'' '\''A >= B || (c != d)'\'''
diff-expr '(A >= B) || (c != d)' 'A >= B || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c != d)'\'' '\''A >= B || (c != d)'\'''

echo '$ diff-expr '\''(A >= B) || (c != d)'\'' '\''A >= B || c != d'\'''
diff-expr '(A >= B) || (c != d)' 'A >= B || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c != d)'\'' '\''A >= B || c != d'\'''

echo '$ diff-expr '\''(A >= B) || (c != d)'\'' '\''(A >= B) || c != d'\'''
diff-expr '(A >= B) || (c != d)' '(A >= B) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c != d)'\'' '\''(A >= B) || c != d'\'''

echo '$ test-expr '\''(A >= B) || (c != D)'\'''
test-expr '(A >= B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (c != D)'\'''

echo '$ diff-expr '\''(A >= B) || (c != D)'\'' '\''A >= B || (c != D)'\'''
diff-expr '(A >= B) || (c != D)' 'A >= B || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c != D)'\'' '\''A >= B || (c != D)'\'''

echo '$ diff-expr '\''(A >= B) || (c != D)'\'' '\''A >= B || c != D'\'''
diff-expr '(A >= B) || (c != D)' 'A >= B || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c != D)'\'' '\''A >= B || c != D'\'''

echo '$ diff-expr '\''(A >= B) || (c != D)'\'' '\''(A >= B) || c != D'\'''
diff-expr '(A >= B) || (c != D)' '(A >= B) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c != D)'\'' '\''(A >= B) || c != D'\'''

echo '$ test-expr '\''(A >= B) || (C != d)'\'''
test-expr '(A >= B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (C != d)'\'''

echo '$ diff-expr '\''(A >= B) || (C != d)'\'' '\''A >= B || (C != d)'\'''
diff-expr '(A >= B) || (C != d)' 'A >= B || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C != d)'\'' '\''A >= B || (C != d)'\'''

echo '$ diff-expr '\''(A >= B) || (C != d)'\'' '\''A >= B || C != d'\'''
diff-expr '(A >= B) || (C != d)' 'A >= B || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C != d)'\'' '\''A >= B || C != d'\'''

echo '$ diff-expr '\''(A >= B) || (C != d)'\'' '\''(A >= B) || C != d'\'''
diff-expr '(A >= B) || (C != d)' '(A >= B) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C != d)'\'' '\''(A >= B) || C != d'\'''

echo '$ test-expr '\''(A >= B) || (C != D)'\'''
test-expr '(A >= B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (C != D)'\'''

echo '$ diff-expr '\''(A >= B) || (C != D)'\'' '\''A >= B || (C != D)'\'''
diff-expr '(A >= B) || (C != D)' 'A >= B || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C != D)'\'' '\''A >= B || (C != D)'\'''

echo '$ diff-expr '\''(A >= B) || (C != D)'\'' '\''A >= B || C != D'\'''
diff-expr '(A >= B) || (C != D)' 'A >= B || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C != D)'\'' '\''A >= B || C != D'\'''

echo '$ diff-expr '\''(A >= B) || (C != D)'\'' '\''(A >= B) || C != D'\'''
diff-expr '(A >= B) || (C != D)' '(A >= B) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C != D)'\'' '\''(A >= B) || C != D'\'''

echo '$ test-expr '\''(a >= b) || (c && d)'\'''
test-expr '(a >= b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (c && d)'\'''

echo '$ diff-expr '\''(a >= b) || (c && d)'\'' '\''a >= b || (c && d)'\'''
diff-expr '(a >= b) || (c && d)' 'a >= b || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && d)'\'' '\''a >= b || (c && d)'\'''

echo '$ diff-expr '\''(a >= b) || (c && d)'\'' '\''a >= b || c && d'\'''
diff-expr '(a >= b) || (c && d)' 'a >= b || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && d)'\'' '\''a >= b || c && d'\'''

echo '$ diff-expr '\''(a >= b) || (c && d)'\'' '\''(a >= b) || c && d'\'''
diff-expr '(a >= b) || (c && d)' '(a >= b) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && d)'\'' '\''(a >= b) || c && d'\'''

echo '$ test-expr '\''(a >= b) || (c && D)'\'''
test-expr '(a >= b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (c && D)'\'''

echo '$ diff-expr '\''(a >= b) || (c && D)'\'' '\''a >= b || (c && D)'\'''
diff-expr '(a >= b) || (c && D)' 'a >= b || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && D)'\'' '\''a >= b || (c && D)'\'''

echo '$ diff-expr '\''(a >= b) || (c && D)'\'' '\''a >= b || c && D'\'''
diff-expr '(a >= b) || (c && D)' 'a >= b || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && D)'\'' '\''a >= b || c && D'\'''

echo '$ diff-expr '\''(a >= b) || (c && D)'\'' '\''(a >= b) || c && D'\'''
diff-expr '(a >= b) || (c && D)' '(a >= b) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && D)'\'' '\''(a >= b) || c && D'\'''

echo '$ test-expr '\''(a >= b) || (C && d)'\'''
test-expr '(a >= b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (C && d)'\'''

echo '$ diff-expr '\''(a >= b) || (C && d)'\'' '\''a >= b || (C && d)'\'''
diff-expr '(a >= b) || (C && d)' 'a >= b || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C && d)'\'' '\''a >= b || (C && d)'\'''

echo '$ diff-expr '\''(a >= b) || (C && d)'\'' '\''a >= b || C && d'\'''
diff-expr '(a >= b) || (C && d)' 'a >= b || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C && d)'\'' '\''a >= b || C && d'\'''

echo '$ diff-expr '\''(a >= b) || (C && d)'\'' '\''(a >= b) || C && d'\'''
diff-expr '(a >= b) || (C && d)' '(a >= b) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C && d)'\'' '\''(a >= b) || C && d'\'''

echo '$ test-expr '\''(a >= b) || (C && D)'\'''
test-expr '(a >= b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (C && D)'\'''

echo '$ diff-expr '\''(a >= b) || (C && D)'\'' '\''a >= b || (C && D)'\'''
diff-expr '(a >= b) || (C && D)' 'a >= b || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C && D)'\'' '\''a >= b || (C && D)'\'''

echo '$ diff-expr '\''(a >= b) || (C && D)'\'' '\''a >= b || C && D'\'''
diff-expr '(a >= b) || (C && D)' 'a >= b || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C && D)'\'' '\''a >= b || C && D'\'''

echo '$ diff-expr '\''(a >= b) || (C && D)'\'' '\''(a >= b) || C && D'\'''
diff-expr '(a >= b) || (C && D)' '(a >= b) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (C && D)'\'' '\''(a >= b) || C && D'\'''

echo '$ test-expr '\''(a >= B) || (c && d)'\'''
test-expr '(a >= B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (c && d)'\'''

echo '$ diff-expr '\''(a >= B) || (c && d)'\'' '\''a >= B || (c && d)'\'''
diff-expr '(a >= B) || (c && d)' 'a >= B || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c && d)'\'' '\''a >= B || (c && d)'\'''

echo '$ diff-expr '\''(a >= B) || (c && d)'\'' '\''a >= B || c && d'\'''
diff-expr '(a >= B) || (c && d)' 'a >= B || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c && d)'\'' '\''a >= B || c && d'\'''

echo '$ diff-expr '\''(a >= B) || (c && d)'\'' '\''(a >= B) || c && d'\'''
diff-expr '(a >= B) || (c && d)' '(a >= B) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c && d)'\'' '\''(a >= B) || c && d'\'''

echo '$ test-expr '\''(a >= B) || (c && D)'\'''
test-expr '(a >= B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (c && D)'\'''

echo '$ diff-expr '\''(a >= B) || (c && D)'\'' '\''a >= B || (c && D)'\'''
diff-expr '(a >= B) || (c && D)' 'a >= B || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c && D)'\'' '\''a >= B || (c && D)'\'''

echo '$ diff-expr '\''(a >= B) || (c && D)'\'' '\''a >= B || c && D'\'''
diff-expr '(a >= B) || (c && D)' 'a >= B || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c && D)'\'' '\''a >= B || c && D'\'''

echo '$ diff-expr '\''(a >= B) || (c && D)'\'' '\''(a >= B) || c && D'\'''
diff-expr '(a >= B) || (c && D)' '(a >= B) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (c && D)'\'' '\''(a >= B) || c && D'\'''

echo '$ test-expr '\''(a >= B) || (C && d)'\'''
test-expr '(a >= B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (C && d)'\'''

echo '$ diff-expr '\''(a >= B) || (C && d)'\'' '\''a >= B || (C && d)'\'''
diff-expr '(a >= B) || (C && d)' 'a >= B || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C && d)'\'' '\''a >= B || (C && d)'\'''

echo '$ diff-expr '\''(a >= B) || (C && d)'\'' '\''a >= B || C && d'\'''
diff-expr '(a >= B) || (C && d)' 'a >= B || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C && d)'\'' '\''a >= B || C && d'\'''

echo '$ diff-expr '\''(a >= B) || (C && d)'\'' '\''(a >= B) || C && d'\'''
diff-expr '(a >= B) || (C && d)' '(a >= B) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C && d)'\'' '\''(a >= B) || C && d'\'''

echo '$ test-expr '\''(a >= B) || (C && D)'\'''
test-expr '(a >= B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= B) || (C && D)'\'''

echo '$ diff-expr '\''(a >= B) || (C && D)'\'' '\''a >= B || (C && D)'\'''
diff-expr '(a >= B) || (C && D)' 'a >= B || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C && D)'\'' '\''a >= B || (C && D)'\'''

echo '$ diff-expr '\''(a >= B) || (C && D)'\'' '\''a >= B || C && D'\'''
diff-expr '(a >= B) || (C && D)' 'a >= B || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C && D)'\'' '\''a >= B || C && D'\'''

echo '$ diff-expr '\''(a >= B) || (C && D)'\'' '\''(a >= B) || C && D'\'''
diff-expr '(a >= B) || (C && D)' '(a >= B) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= B) || (C && D)'\'' '\''(a >= B) || C && D'\'''

echo '$ test-expr '\''(A >= b) || (c && d)'\'''
test-expr '(A >= b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (c && d)'\'''

echo '$ diff-expr '\''(A >= b) || (c && d)'\'' '\''A >= b || (c && d)'\'''
diff-expr '(A >= b) || (c && d)' 'A >= b || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c && d)'\'' '\''A >= b || (c && d)'\'''

echo '$ diff-expr '\''(A >= b) || (c && d)'\'' '\''A >= b || c && d'\'''
diff-expr '(A >= b) || (c && d)' 'A >= b || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c && d)'\'' '\''A >= b || c && d'\'''

echo '$ diff-expr '\''(A >= b) || (c && d)'\'' '\''(A >= b) || c && d'\'''
diff-expr '(A >= b) || (c && d)' '(A >= b) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c && d)'\'' '\''(A >= b) || c && d'\'''

echo '$ test-expr '\''(A >= b) || (c && D)'\'''
test-expr '(A >= b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (c && D)'\'''

echo '$ diff-expr '\''(A >= b) || (c && D)'\'' '\''A >= b || (c && D)'\'''
diff-expr '(A >= b) || (c && D)' 'A >= b || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c && D)'\'' '\''A >= b || (c && D)'\'''

echo '$ diff-expr '\''(A >= b) || (c && D)'\'' '\''A >= b || c && D'\'''
diff-expr '(A >= b) || (c && D)' 'A >= b || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c && D)'\'' '\''A >= b || c && D'\'''

echo '$ diff-expr '\''(A >= b) || (c && D)'\'' '\''(A >= b) || c && D'\'''
diff-expr '(A >= b) || (c && D)' '(A >= b) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (c && D)'\'' '\''(A >= b) || c && D'\'''

echo '$ test-expr '\''(A >= b) || (C && d)'\'''
test-expr '(A >= b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (C && d)'\'''

echo '$ diff-expr '\''(A >= b) || (C && d)'\'' '\''A >= b || (C && d)'\'''
diff-expr '(A >= b) || (C && d)' 'A >= b || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C && d)'\'' '\''A >= b || (C && d)'\'''

echo '$ diff-expr '\''(A >= b) || (C && d)'\'' '\''A >= b || C && d'\'''
diff-expr '(A >= b) || (C && d)' 'A >= b || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C && d)'\'' '\''A >= b || C && d'\'''

echo '$ diff-expr '\''(A >= b) || (C && d)'\'' '\''(A >= b) || C && d'\'''
diff-expr '(A >= b) || (C && d)' '(A >= b) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C && d)'\'' '\''(A >= b) || C && d'\'''

echo '$ test-expr '\''(A >= b) || (C && D)'\'''
test-expr '(A >= b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= b) || (C && D)'\'''

echo '$ diff-expr '\''(A >= b) || (C && D)'\'' '\''A >= b || (C && D)'\'''
diff-expr '(A >= b) || (C && D)' 'A >= b || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C && D)'\'' '\''A >= b || (C && D)'\'''

echo '$ diff-expr '\''(A >= b) || (C && D)'\'' '\''A >= b || C && D'\'''
diff-expr '(A >= b) || (C && D)' 'A >= b || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C && D)'\'' '\''A >= b || C && D'\'''

echo '$ diff-expr '\''(A >= b) || (C && D)'\'' '\''(A >= b) || C && D'\'''
diff-expr '(A >= b) || (C && D)' '(A >= b) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= b) || (C && D)'\'' '\''(A >= b) || C && D'\'''

echo '$ test-expr '\''(A >= B) || (c && d)'\'''
test-expr '(A >= B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (c && d)'\'''

echo '$ diff-expr '\''(A >= B) || (c && d)'\'' '\''A >= B || (c && d)'\'''
diff-expr '(A >= B) || (c && d)' 'A >= B || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c && d)'\'' '\''A >= B || (c && d)'\'''

echo '$ diff-expr '\''(A >= B) || (c && d)'\'' '\''A >= B || c && d'\'''
diff-expr '(A >= B) || (c && d)' 'A >= B || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c && d)'\'' '\''A >= B || c && d'\'''

echo '$ diff-expr '\''(A >= B) || (c && d)'\'' '\''(A >= B) || c && d'\'''
diff-expr '(A >= B) || (c && d)' '(A >= B) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c && d)'\'' '\''(A >= B) || c && d'\'''

echo '$ test-expr '\''(A >= B) || (c && D)'\'''
test-expr '(A >= B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (c && D)'\'''

echo '$ diff-expr '\''(A >= B) || (c && D)'\'' '\''A >= B || (c && D)'\'''
diff-expr '(A >= B) || (c && D)' 'A >= B || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c && D)'\'' '\''A >= B || (c && D)'\'''

echo '$ diff-expr '\''(A >= B) || (c && D)'\'' '\''A >= B || c && D'\'''
diff-expr '(A >= B) || (c && D)' 'A >= B || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c && D)'\'' '\''A >= B || c && D'\'''

echo '$ diff-expr '\''(A >= B) || (c && D)'\'' '\''(A >= B) || c && D'\'''
diff-expr '(A >= B) || (c && D)' '(A >= B) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (c && D)'\'' '\''(A >= B) || c && D'\'''

echo '$ test-expr '\''(A >= B) || (C && d)'\'''
test-expr '(A >= B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (C && d)'\'''

echo '$ diff-expr '\''(A >= B) || (C && d)'\'' '\''A >= B || (C && d)'\'''
diff-expr '(A >= B) || (C && d)' 'A >= B || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C && d)'\'' '\''A >= B || (C && d)'\'''

echo '$ diff-expr '\''(A >= B) || (C && d)'\'' '\''A >= B || C && d'\'''
diff-expr '(A >= B) || (C && d)' 'A >= B || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C && d)'\'' '\''A >= B || C && d'\'''

echo '$ diff-expr '\''(A >= B) || (C && d)'\'' '\''(A >= B) || C && d'\'''
diff-expr '(A >= B) || (C && d)' '(A >= B) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C && d)'\'' '\''(A >= B) || C && d'\'''

echo '$ test-expr '\''(A >= B) || (C && D)'\'''
test-expr '(A >= B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A >= B) || (C && D)'\'''

echo '$ diff-expr '\''(A >= B) || (C && D)'\'' '\''A >= B || (C && D)'\'''
diff-expr '(A >= B) || (C && D)' 'A >= B || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C && D)'\'' '\''A >= B || (C && D)'\'''

echo '$ diff-expr '\''(A >= B) || (C && D)'\'' '\''A >= B || C && D'\'''
diff-expr '(A >= B) || (C && D)' 'A >= B || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C && D)'\'' '\''A >= B || C && D'\'''

echo '$ diff-expr '\''(A >= B) || (C && D)'\'' '\''(A >= B) || C && D'\'''
diff-expr '(A >= B) || (C && D)' '(A >= B) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A >= B) || (C && D)'\'' '\''(A >= B) || C && D'\'''

echo '$ test-expr '\''(a != b) || (c && d)'\'''
test-expr '(a != b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (c && d)'\'''

echo '$ diff-expr '\''(a != b) || (c && d)'\'' '\''a != b || (c && d)'\'''
diff-expr '(a != b) || (c && d)' 'a != b || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && d)'\'' '\''a != b || (c && d)'\'''

echo '$ diff-expr '\''(a != b) || (c && d)'\'' '\''a != b || c && d'\'''
diff-expr '(a != b) || (c && d)' 'a != b || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && d)'\'' '\''a != b || c && d'\'''

echo '$ diff-expr '\''(a != b) || (c && d)'\'' '\''(a != b) || c && d'\'''
diff-expr '(a != b) || (c && d)' '(a != b) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && d)'\'' '\''(a != b) || c && d'\'''

echo '$ test-expr '\''(a != b) || (c && D)'\'''
test-expr '(a != b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (c && D)'\'''

echo '$ diff-expr '\''(a != b) || (c && D)'\'' '\''a != b || (c && D)'\'''
diff-expr '(a != b) || (c && D)' 'a != b || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && D)'\'' '\''a != b || (c && D)'\'''

echo '$ diff-expr '\''(a != b) || (c && D)'\'' '\''a != b || c && D'\'''
diff-expr '(a != b) || (c && D)' 'a != b || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && D)'\'' '\''a != b || c && D'\'''

echo '$ diff-expr '\''(a != b) || (c && D)'\'' '\''(a != b) || c && D'\'''
diff-expr '(a != b) || (c && D)' '(a != b) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && D)'\'' '\''(a != b) || c && D'\'''

echo '$ test-expr '\''(a != b) || (C && d)'\'''
test-expr '(a != b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (C && d)'\'''

echo '$ diff-expr '\''(a != b) || (C && d)'\'' '\''a != b || (C && d)'\'''
diff-expr '(a != b) || (C && d)' 'a != b || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C && d)'\'' '\''a != b || (C && d)'\'''

echo '$ diff-expr '\''(a != b) || (C && d)'\'' '\''a != b || C && d'\'''
diff-expr '(a != b) || (C && d)' 'a != b || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C && d)'\'' '\''a != b || C && d'\'''

echo '$ diff-expr '\''(a != b) || (C && d)'\'' '\''(a != b) || C && d'\'''
diff-expr '(a != b) || (C && d)' '(a != b) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C && d)'\'' '\''(a != b) || C && d'\'''

echo '$ test-expr '\''(a != b) || (C && D)'\'''
test-expr '(a != b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (C && D)'\'''

echo '$ diff-expr '\''(a != b) || (C && D)'\'' '\''a != b || (C && D)'\'''
diff-expr '(a != b) || (C && D)' 'a != b || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C && D)'\'' '\''a != b || (C && D)'\'''

echo '$ diff-expr '\''(a != b) || (C && D)'\'' '\''a != b || C && D'\'''
diff-expr '(a != b) || (C && D)' 'a != b || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C && D)'\'' '\''a != b || C && D'\'''

echo '$ diff-expr '\''(a != b) || (C && D)'\'' '\''(a != b) || C && D'\'''
diff-expr '(a != b) || (C && D)' '(a != b) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C && D)'\'' '\''(a != b) || C && D'\'''

echo '$ test-expr '\''(a != B) || (c && d)'\'''
test-expr '(a != B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (c && d)'\'''

echo '$ diff-expr '\''(a != B) || (c && d)'\'' '\''a != B || (c && d)'\'''
diff-expr '(a != B) || (c && d)' 'a != B || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c && d)'\'' '\''a != B || (c && d)'\'''

echo '$ diff-expr '\''(a != B) || (c && d)'\'' '\''a != B || c && d'\'''
diff-expr '(a != B) || (c && d)' 'a != B || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c && d)'\'' '\''a != B || c && d'\'''

echo '$ diff-expr '\''(a != B) || (c && d)'\'' '\''(a != B) || c && d'\'''
diff-expr '(a != B) || (c && d)' '(a != B) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c && d)'\'' '\''(a != B) || c && d'\'''

echo '$ test-expr '\''(a != B) || (c && D)'\'''
test-expr '(a != B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (c && D)'\'''

echo '$ diff-expr '\''(a != B) || (c && D)'\'' '\''a != B || (c && D)'\'''
diff-expr '(a != B) || (c && D)' 'a != B || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c && D)'\'' '\''a != B || (c && D)'\'''

echo '$ diff-expr '\''(a != B) || (c && D)'\'' '\''a != B || c && D'\'''
diff-expr '(a != B) || (c && D)' 'a != B || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c && D)'\'' '\''a != B || c && D'\'''

echo '$ diff-expr '\''(a != B) || (c && D)'\'' '\''(a != B) || c && D'\'''
diff-expr '(a != B) || (c && D)' '(a != B) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c && D)'\'' '\''(a != B) || c && D'\'''

echo '$ test-expr '\''(a != B) || (C && d)'\'''
test-expr '(a != B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (C && d)'\'''

echo '$ diff-expr '\''(a != B) || (C && d)'\'' '\''a != B || (C && d)'\'''
diff-expr '(a != B) || (C && d)' 'a != B || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C && d)'\'' '\''a != B || (C && d)'\'''

echo '$ diff-expr '\''(a != B) || (C && d)'\'' '\''a != B || C && d'\'''
diff-expr '(a != B) || (C && d)' 'a != B || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C && d)'\'' '\''a != B || C && d'\'''

echo '$ diff-expr '\''(a != B) || (C && d)'\'' '\''(a != B) || C && d'\'''
diff-expr '(a != B) || (C && d)' '(a != B) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C && d)'\'' '\''(a != B) || C && d'\'''

echo '$ test-expr '\''(a != B) || (C && D)'\'''
test-expr '(a != B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (C && D)'\'''

echo '$ diff-expr '\''(a != B) || (C && D)'\'' '\''a != B || (C && D)'\'''
diff-expr '(a != B) || (C && D)' 'a != B || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C && D)'\'' '\''a != B || (C && D)'\'''

echo '$ diff-expr '\''(a != B) || (C && D)'\'' '\''a != B || C && D'\'''
diff-expr '(a != B) || (C && D)' 'a != B || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C && D)'\'' '\''a != B || C && D'\'''

echo '$ diff-expr '\''(a != B) || (C && D)'\'' '\''(a != B) || C && D'\'''
diff-expr '(a != B) || (C && D)' '(a != B) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C && D)'\'' '\''(a != B) || C && D'\'''

echo '$ test-expr '\''(A != b) || (c && d)'\'''
test-expr '(A != b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (c && d)'\'''

echo '$ diff-expr '\''(A != b) || (c && d)'\'' '\''A != b || (c && d)'\'''
diff-expr '(A != b) || (c && d)' 'A != b || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c && d)'\'' '\''A != b || (c && d)'\'''

echo '$ diff-expr '\''(A != b) || (c && d)'\'' '\''A != b || c && d'\'''
diff-expr '(A != b) || (c && d)' 'A != b || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c && d)'\'' '\''A != b || c && d'\'''

echo '$ diff-expr '\''(A != b) || (c && d)'\'' '\''(A != b) || c && d'\'''
diff-expr '(A != b) || (c && d)' '(A != b) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c && d)'\'' '\''(A != b) || c && d'\'''

echo '$ test-expr '\''(A != b) || (c && D)'\'''
test-expr '(A != b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (c && D)'\'''

echo '$ diff-expr '\''(A != b) || (c && D)'\'' '\''A != b || (c && D)'\'''
diff-expr '(A != b) || (c && D)' 'A != b || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c && D)'\'' '\''A != b || (c && D)'\'''

echo '$ diff-expr '\''(A != b) || (c && D)'\'' '\''A != b || c && D'\'''
diff-expr '(A != b) || (c && D)' 'A != b || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c && D)'\'' '\''A != b || c && D'\'''

echo '$ diff-expr '\''(A != b) || (c && D)'\'' '\''(A != b) || c && D'\'''
diff-expr '(A != b) || (c && D)' '(A != b) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c && D)'\'' '\''(A != b) || c && D'\'''

echo '$ test-expr '\''(A != b) || (C && d)'\'''
test-expr '(A != b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (C && d)'\'''

echo '$ diff-expr '\''(A != b) || (C && d)'\'' '\''A != b || (C && d)'\'''
diff-expr '(A != b) || (C && d)' 'A != b || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C && d)'\'' '\''A != b || (C && d)'\'''

echo '$ diff-expr '\''(A != b) || (C && d)'\'' '\''A != b || C && d'\'''
diff-expr '(A != b) || (C && d)' 'A != b || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C && d)'\'' '\''A != b || C && d'\'''

echo '$ diff-expr '\''(A != b) || (C && d)'\'' '\''(A != b) || C && d'\'''
diff-expr '(A != b) || (C && d)' '(A != b) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C && d)'\'' '\''(A != b) || C && d'\'''

echo '$ test-expr '\''(A != b) || (C && D)'\'''
test-expr '(A != b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (C && D)'\'''

echo '$ diff-expr '\''(A != b) || (C && D)'\'' '\''A != b || (C && D)'\'''
diff-expr '(A != b) || (C && D)' 'A != b || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C && D)'\'' '\''A != b || (C && D)'\'''

echo '$ diff-expr '\''(A != b) || (C && D)'\'' '\''A != b || C && D'\'''
diff-expr '(A != b) || (C && D)' 'A != b || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C && D)'\'' '\''A != b || C && D'\'''

echo '$ diff-expr '\''(A != b) || (C && D)'\'' '\''(A != b) || C && D'\'''
diff-expr '(A != b) || (C && D)' '(A != b) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C && D)'\'' '\''(A != b) || C && D'\'''

echo '$ test-expr '\''(A != B) || (c && d)'\'''
test-expr '(A != B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (c && d)'\'''

echo '$ diff-expr '\''(A != B) || (c && d)'\'' '\''A != B || (c && d)'\'''
diff-expr '(A != B) || (c && d)' 'A != B || (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c && d)'\'' '\''A != B || (c && d)'\'''

echo '$ diff-expr '\''(A != B) || (c && d)'\'' '\''A != B || c && d'\'''
diff-expr '(A != B) || (c && d)' 'A != B || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c && d)'\'' '\''A != B || c && d'\'''

echo '$ diff-expr '\''(A != B) || (c && d)'\'' '\''(A != B) || c && d'\'''
diff-expr '(A != B) || (c && d)' '(A != B) || c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c && d)'\'' '\''(A != B) || c && d'\'''

echo '$ test-expr '\''(A != B) || (c && D)'\'''
test-expr '(A != B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (c && D)'\'''

echo '$ diff-expr '\''(A != B) || (c && D)'\'' '\''A != B || (c && D)'\'''
diff-expr '(A != B) || (c && D)' 'A != B || (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c && D)'\'' '\''A != B || (c && D)'\'''

echo '$ diff-expr '\''(A != B) || (c && D)'\'' '\''A != B || c && D'\'''
diff-expr '(A != B) || (c && D)' 'A != B || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c && D)'\'' '\''A != B || c && D'\'''

echo '$ diff-expr '\''(A != B) || (c && D)'\'' '\''(A != B) || c && D'\'''
diff-expr '(A != B) || (c && D)' '(A != B) || c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c && D)'\'' '\''(A != B) || c && D'\'''

echo '$ test-expr '\''(A != B) || (C && d)'\'''
test-expr '(A != B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (C && d)'\'''

echo '$ diff-expr '\''(A != B) || (C && d)'\'' '\''A != B || (C && d)'\'''
diff-expr '(A != B) || (C && d)' 'A != B || (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C && d)'\'' '\''A != B || (C && d)'\'''

echo '$ diff-expr '\''(A != B) || (C && d)'\'' '\''A != B || C && d'\'''
diff-expr '(A != B) || (C && d)' 'A != B || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C && d)'\'' '\''A != B || C && d'\'''

echo '$ diff-expr '\''(A != B) || (C && d)'\'' '\''(A != B) || C && d'\'''
diff-expr '(A != B) || (C && d)' '(A != B) || C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C && d)'\'' '\''(A != B) || C && d'\'''

echo '$ test-expr '\''(A != B) || (C && D)'\'''
test-expr '(A != B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (C && D)'\'''

echo '$ diff-expr '\''(A != B) || (C && D)'\'' '\''A != B || (C && D)'\'''
diff-expr '(A != B) || (C && D)' 'A != B || (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C && D)'\'' '\''A != B || (C && D)'\'''

echo '$ diff-expr '\''(A != B) || (C && D)'\'' '\''A != B || C && D'\'''
diff-expr '(A != B) || (C && D)' 'A != B || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C && D)'\'' '\''A != B || C && D'\'''

echo '$ diff-expr '\''(A != B) || (C && D)'\'' '\''(A != B) || C && D'\'''
diff-expr '(A != B) || (C && D)' '(A != B) || C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C && D)'\'' '\''(A != B) || C && D'\'''

echo '$ test-expr '\''a >= (b && (c != d))'\'''
test-expr 'a >= (b && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != d))'\'''

echo '$ diff-expr '\''a >= (b && (c != d))'\'' '\''a >= (b && c != d)'\'''
diff-expr 'a >= (b && (c != d))' 'a >= (b && c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && (c != d))'\'' '\''a >= (b && c != d)'\'''

echo '$ test-expr '\''a >= (b && (c != D))'\'''
test-expr 'a >= (b && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != D))'\'''

echo '$ diff-expr '\''a >= (b && (c != D))'\'' '\''a >= (b && c != D)'\'''
diff-expr 'a >= (b && (c != D))' 'a >= (b && c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && (c != D))'\'' '\''a >= (b && c != D)'\'''

echo '$ test-expr '\''a >= (b && (C != d))'\'''
test-expr 'a >= (b && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (C != d))'\'''

echo '$ diff-expr '\''a >= (b && (C != d))'\'' '\''a >= (b && C != d)'\'''
diff-expr 'a >= (b && (C != d))' 'a >= (b && C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && (C != d))'\'' '\''a >= (b && C != d)'\'''

echo '$ test-expr '\''a >= (b && (C != D))'\'''
test-expr 'a >= (b && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (C != D))'\'''

echo '$ diff-expr '\''a >= (b && (C != D))'\'' '\''a >= (b && C != D)'\'''
diff-expr 'a >= (b && (C != D))' 'a >= (b && C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && (C != D))'\'' '\''a >= (b && C != D)'\'''

echo '$ test-expr '\''a >= (B && (c != d))'\'''
test-expr 'a >= (B && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (c != d))'\'''

echo '$ diff-expr '\''a >= (B && (c != d))'\'' '\''a >= (B && c != d)'\'''
diff-expr 'a >= (B && (c != d))' 'a >= (B && c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B && (c != d))'\'' '\''a >= (B && c != d)'\'''

echo '$ test-expr '\''a >= (B && (c != D))'\'''
test-expr 'a >= (B && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (c != D))'\'''

echo '$ diff-expr '\''a >= (B && (c != D))'\'' '\''a >= (B && c != D)'\'''
diff-expr 'a >= (B && (c != D))' 'a >= (B && c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B && (c != D))'\'' '\''a >= (B && c != D)'\'''

echo '$ test-expr '\''a >= (B && (C != d))'\'''
test-expr 'a >= (B && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (C != d))'\'''

echo '$ diff-expr '\''a >= (B && (C != d))'\'' '\''a >= (B && C != d)'\'''
diff-expr 'a >= (B && (C != d))' 'a >= (B && C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B && (C != d))'\'' '\''a >= (B && C != d)'\'''

echo '$ test-expr '\''a >= (B && (C != D))'\'''
test-expr 'a >= (B && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B && (C != D))'\'''

echo '$ diff-expr '\''a >= (B && (C != D))'\'' '\''a >= (B && C != D)'\'''
diff-expr 'a >= (B && (C != D))' 'a >= (B && C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B && (C != D))'\'' '\''a >= (B && C != D)'\'''

echo '$ test-expr '\''A >= (b && (c != d))'\'''
test-expr 'A >= (b && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (c != d))'\'''

echo '$ diff-expr '\''A >= (b && (c != d))'\'' '\''A >= (b && c != d)'\'''
diff-expr 'A >= (b && (c != d))' 'A >= (b && c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b && (c != d))'\'' '\''A >= (b && c != d)'\'''

echo '$ test-expr '\''A >= (b && (c != D))'\'''
test-expr 'A >= (b && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (c != D))'\'''

echo '$ diff-expr '\''A >= (b && (c != D))'\'' '\''A >= (b && c != D)'\'''
diff-expr 'A >= (b && (c != D))' 'A >= (b && c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b && (c != D))'\'' '\''A >= (b && c != D)'\'''

echo '$ test-expr '\''A >= (b && (C != d))'\'''
test-expr 'A >= (b && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (C != d))'\'''

echo '$ diff-expr '\''A >= (b && (C != d))'\'' '\''A >= (b && C != d)'\'''
diff-expr 'A >= (b && (C != d))' 'A >= (b && C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b && (C != d))'\'' '\''A >= (b && C != d)'\'''

echo '$ test-expr '\''A >= (b && (C != D))'\'''
test-expr 'A >= (b && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b && (C != D))'\'''

echo '$ diff-expr '\''A >= (b && (C != D))'\'' '\''A >= (b && C != D)'\'''
diff-expr 'A >= (b && (C != D))' 'A >= (b && C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b && (C != D))'\'' '\''A >= (b && C != D)'\'''

echo '$ test-expr '\''A >= (B && (c != d))'\'''
test-expr 'A >= (B && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (c != d))'\'''

echo '$ diff-expr '\''A >= (B && (c != d))'\'' '\''A >= (B && c != d)'\'''
diff-expr 'A >= (B && (c != d))' 'A >= (B && c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B && (c != d))'\'' '\''A >= (B && c != d)'\'''

echo '$ test-expr '\''A >= (B && (c != D))'\'''
test-expr 'A >= (B && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (c != D))'\'''

echo '$ diff-expr '\''A >= (B && (c != D))'\'' '\''A >= (B && c != D)'\'''
diff-expr 'A >= (B && (c != D))' 'A >= (B && c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B && (c != D))'\'' '\''A >= (B && c != D)'\'''

echo '$ test-expr '\''A >= (B && (C != d))'\'''
test-expr 'A >= (B && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (C != d))'\'''

echo '$ diff-expr '\''A >= (B && (C != d))'\'' '\''A >= (B && C != d)'\'''
diff-expr 'A >= (B && (C != d))' 'A >= (B && C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B && (C != d))'\'' '\''A >= (B && C != d)'\'''

echo '$ test-expr '\''A >= (B && (C != D))'\'''
test-expr 'A >= (B && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B && (C != D))'\'''

echo '$ diff-expr '\''A >= (B && (C != D))'\'' '\''A >= (B && C != D)'\'''
diff-expr 'A >= (B && (C != D))' 'A >= (B && C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B && (C != D))'\'' '\''A >= (B && C != D)'\'''

echo '$ test-expr '\''a >= (b || (c != d))'\'''
test-expr 'a >= (b || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (c != d))'\'''

echo '$ diff-expr '\''a >= (b || (c != d))'\'' '\''a >= (b || c != d)'\'''
diff-expr 'a >= (b || (c != d))' 'a >= (b || c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c != d))'\'' '\''a >= (b || c != d)'\'''

echo '$ test-expr '\''a >= (b || (c != D))'\'''
test-expr 'a >= (b || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (c != D))'\'''

echo '$ diff-expr '\''a >= (b || (c != D))'\'' '\''a >= (b || c != D)'\'''
diff-expr 'a >= (b || (c != D))' 'a >= (b || c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c != D))'\'' '\''a >= (b || c != D)'\'''

echo '$ test-expr '\''a >= (b || (C != d))'\'''
test-expr 'a >= (b || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (C != d))'\'''

echo '$ diff-expr '\''a >= (b || (C != d))'\'' '\''a >= (b || C != d)'\'''
diff-expr 'a >= (b || (C != d))' 'a >= (b || C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (C != d))'\'' '\''a >= (b || C != d)'\'''

echo '$ test-expr '\''a >= (b || (C != D))'\'''
test-expr 'a >= (b || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (C != D))'\'''

echo '$ diff-expr '\''a >= (b || (C != D))'\'' '\''a >= (b || C != D)'\'''
diff-expr 'a >= (b || (C != D))' 'a >= (b || C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (C != D))'\'' '\''a >= (b || C != D)'\'''

echo '$ test-expr '\''a >= (B || (c != d))'\'''
test-expr 'a >= (B || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (c != d))'\'''

echo '$ diff-expr '\''a >= (B || (c != d))'\'' '\''a >= (B || c != d)'\'''
diff-expr 'a >= (B || (c != d))' 'a >= (B || c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (c != d))'\'' '\''a >= (B || c != d)'\'''

echo '$ test-expr '\''a >= (B || (c != D))'\'''
test-expr 'a >= (B || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (c != D))'\'''

echo '$ diff-expr '\''a >= (B || (c != D))'\'' '\''a >= (B || c != D)'\'''
diff-expr 'a >= (B || (c != D))' 'a >= (B || c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (c != D))'\'' '\''a >= (B || c != D)'\'''

echo '$ test-expr '\''a >= (B || (C != d))'\'''
test-expr 'a >= (B || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (C != d))'\'''

echo '$ diff-expr '\''a >= (B || (C != d))'\'' '\''a >= (B || C != d)'\'''
diff-expr 'a >= (B || (C != d))' 'a >= (B || C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (C != d))'\'' '\''a >= (B || C != d)'\'''

echo '$ test-expr '\''a >= (B || (C != D))'\'''
test-expr 'a >= (B || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (C != D))'\'''

echo '$ diff-expr '\''a >= (B || (C != D))'\'' '\''a >= (B || C != D)'\'''
diff-expr 'a >= (B || (C != D))' 'a >= (B || C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (C != D))'\'' '\''a >= (B || C != D)'\'''

echo '$ test-expr '\''A >= (b || (c != d))'\'''
test-expr 'A >= (b || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (c != d))'\'''

echo '$ diff-expr '\''A >= (b || (c != d))'\'' '\''A >= (b || c != d)'\'''
diff-expr 'A >= (b || (c != d))' 'A >= (b || c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (c != d))'\'' '\''A >= (b || c != d)'\'''

echo '$ test-expr '\''A >= (b || (c != D))'\'''
test-expr 'A >= (b || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (c != D))'\'''

echo '$ diff-expr '\''A >= (b || (c != D))'\'' '\''A >= (b || c != D)'\'''
diff-expr 'A >= (b || (c != D))' 'A >= (b || c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (c != D))'\'' '\''A >= (b || c != D)'\'''

echo '$ test-expr '\''A >= (b || (C != d))'\'''
test-expr 'A >= (b || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (C != d))'\'''

echo '$ diff-expr '\''A >= (b || (C != d))'\'' '\''A >= (b || C != d)'\'''
diff-expr 'A >= (b || (C != d))' 'A >= (b || C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (C != d))'\'' '\''A >= (b || C != d)'\'''

echo '$ test-expr '\''A >= (b || (C != D))'\'''
test-expr 'A >= (b || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (C != D))'\'''

echo '$ diff-expr '\''A >= (b || (C != D))'\'' '\''A >= (b || C != D)'\'''
diff-expr 'A >= (b || (C != D))' 'A >= (b || C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (C != D))'\'' '\''A >= (b || C != D)'\'''

echo '$ test-expr '\''A >= (B || (c != d))'\'''
test-expr 'A >= (B || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (c != d))'\'''

echo '$ diff-expr '\''A >= (B || (c != d))'\'' '\''A >= (B || c != d)'\'''
diff-expr 'A >= (B || (c != d))' 'A >= (B || c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (c != d))'\'' '\''A >= (B || c != d)'\'''

echo '$ test-expr '\''A >= (B || (c != D))'\'''
test-expr 'A >= (B || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (c != D))'\'''

echo '$ diff-expr '\''A >= (B || (c != D))'\'' '\''A >= (B || c != D)'\'''
diff-expr 'A >= (B || (c != D))' 'A >= (B || c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (c != D))'\'' '\''A >= (B || c != D)'\'''

echo '$ test-expr '\''A >= (B || (C != d))'\'''
test-expr 'A >= (B || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (C != d))'\'''

echo '$ diff-expr '\''A >= (B || (C != d))'\'' '\''A >= (B || C != d)'\'''
diff-expr 'A >= (B || (C != d))' 'A >= (B || C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (C != d))'\'' '\''A >= (B || C != d)'\'''

echo '$ test-expr '\''A >= (B || (C != D))'\'''
test-expr 'A >= (B || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (C != D))'\'''

echo '$ diff-expr '\''A >= (B || (C != D))'\'' '\''A >= (B || C != D)'\'''
diff-expr 'A >= (B || (C != D))' 'A >= (B || C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (C != D))'\'' '\''A >= (B || C != D)'\'''

echo '$ test-expr '\''a >= (b || (c && d))'\'''
test-expr 'a >= (b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (c && d))'\'''

echo '$ diff-expr '\''a >= (b || (c && d))'\'' '\''a >= (b || c && d)'\'''
diff-expr 'a >= (b || (c && d))' 'a >= (b || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c && d))'\'' '\''a >= (b || c && d)'\'''

echo '$ test-expr '\''a >= (b || (c && D))'\'''
test-expr 'a >= (b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (c && D))'\'''

echo '$ diff-expr '\''a >= (b || (c && D))'\'' '\''a >= (b || c && D)'\'''
diff-expr 'a >= (b || (c && D))' 'a >= (b || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c && D))'\'' '\''a >= (b || c && D)'\'''

echo '$ test-expr '\''a >= (b || (C && d))'\'''
test-expr 'a >= (b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (C && d))'\'''

echo '$ diff-expr '\''a >= (b || (C && d))'\'' '\''a >= (b || C && d)'\'''
diff-expr 'a >= (b || (C && d))' 'a >= (b || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (C && d))'\'' '\''a >= (b || C && d)'\'''

echo '$ test-expr '\''a >= (b || (C && D))'\'''
test-expr 'a >= (b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (C && D))'\'''

echo '$ diff-expr '\''a >= (b || (C && D))'\'' '\''a >= (b || C && D)'\'''
diff-expr 'a >= (b || (C && D))' 'a >= (b || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (C && D))'\'' '\''a >= (b || C && D)'\'''

echo '$ test-expr '\''a >= (B || (c && d))'\'''
test-expr 'a >= (B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (c && d))'\'''

echo '$ diff-expr '\''a >= (B || (c && d))'\'' '\''a >= (B || c && d)'\'''
diff-expr 'a >= (B || (c && d))' 'a >= (B || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (c && d))'\'' '\''a >= (B || c && d)'\'''

echo '$ test-expr '\''a >= (B || (c && D))'\'''
test-expr 'a >= (B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (c && D))'\'''

echo '$ diff-expr '\''a >= (B || (c && D))'\'' '\''a >= (B || c && D)'\'''
diff-expr 'a >= (B || (c && D))' 'a >= (B || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (c && D))'\'' '\''a >= (B || c && D)'\'''

echo '$ test-expr '\''a >= (B || (C && d))'\'''
test-expr 'a >= (B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (C && d))'\'''

echo '$ diff-expr '\''a >= (B || (C && d))'\'' '\''a >= (B || C && d)'\'''
diff-expr 'a >= (B || (C && d))' 'a >= (B || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (C && d))'\'' '\''a >= (B || C && d)'\'''

echo '$ test-expr '\''a >= (B || (C && D))'\'''
test-expr 'a >= (B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (B || (C && D))'\'''

echo '$ diff-expr '\''a >= (B || (C && D))'\'' '\''a >= (B || C && D)'\'''
diff-expr 'a >= (B || (C && D))' 'a >= (B || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (B || (C && D))'\'' '\''a >= (B || C && D)'\'''

echo '$ test-expr '\''A >= (b || (c && d))'\'''
test-expr 'A >= (b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (c && d))'\'''

echo '$ diff-expr '\''A >= (b || (c && d))'\'' '\''A >= (b || c && d)'\'''
diff-expr 'A >= (b || (c && d))' 'A >= (b || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (c && d))'\'' '\''A >= (b || c && d)'\'''

echo '$ test-expr '\''A >= (b || (c && D))'\'''
test-expr 'A >= (b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (c && D))'\'''

echo '$ diff-expr '\''A >= (b || (c && D))'\'' '\''A >= (b || c && D)'\'''
diff-expr 'A >= (b || (c && D))' 'A >= (b || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (c && D))'\'' '\''A >= (b || c && D)'\'''

echo '$ test-expr '\''A >= (b || (C && d))'\'''
test-expr 'A >= (b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (C && d))'\'''

echo '$ diff-expr '\''A >= (b || (C && d))'\'' '\''A >= (b || C && d)'\'''
diff-expr 'A >= (b || (C && d))' 'A >= (b || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (C && d))'\'' '\''A >= (b || C && d)'\'''

echo '$ test-expr '\''A >= (b || (C && D))'\'''
test-expr 'A >= (b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (b || (C && D))'\'''

echo '$ diff-expr '\''A >= (b || (C && D))'\'' '\''A >= (b || C && D)'\'''
diff-expr 'A >= (b || (C && D))' 'A >= (b || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (b || (C && D))'\'' '\''A >= (b || C && D)'\'''

echo '$ test-expr '\''A >= (B || (c && d))'\'''
test-expr 'A >= (B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (c && d))'\'''

echo '$ diff-expr '\''A >= (B || (c && d))'\'' '\''A >= (B || c && d)'\'''
diff-expr 'A >= (B || (c && d))' 'A >= (B || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (c && d))'\'' '\''A >= (B || c && d)'\'''

echo '$ test-expr '\''A >= (B || (c && D))'\'''
test-expr 'A >= (B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (c && D))'\'''

echo '$ diff-expr '\''A >= (B || (c && D))'\'' '\''A >= (B || c && D)'\'''
diff-expr 'A >= (B || (c && D))' 'A >= (B || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (c && D))'\'' '\''A >= (B || c && D)'\'''

echo '$ test-expr '\''A >= (B || (C && d))'\'''
test-expr 'A >= (B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (C && d))'\'''

echo '$ diff-expr '\''A >= (B || (C && d))'\'' '\''A >= (B || C && d)'\'''
diff-expr 'A >= (B || (C && d))' 'A >= (B || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (C && d))'\'' '\''A >= (B || C && d)'\'''

echo '$ test-expr '\''A >= (B || (C && D))'\'''
test-expr 'A >= (B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= (B || (C && D))'\'''

echo '$ diff-expr '\''A >= (B || (C && D))'\'' '\''A >= (B || C && D)'\'''
diff-expr 'A >= (B || (C && D))' 'A >= (B || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A >= (B || (C && D))'\'' '\''A >= (B || C && D)'\'''

echo '$ test-expr '\''a != (b || (c && d))'\'''
test-expr 'a != (b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && d))'\'''

echo '$ diff-expr '\''a != (b || (c && d))'\'' '\''a != (b || c && d)'\'''
diff-expr 'a != (b || (c && d))' 'a != (b || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (c && d))'\'' '\''a != (b || c && d)'\'''

echo '$ test-expr '\''a != (b || (c && D))'\'''
test-expr 'a != (b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && D))'\'''

echo '$ diff-expr '\''a != (b || (c && D))'\'' '\''a != (b || c && D)'\'''
diff-expr 'a != (b || (c && D))' 'a != (b || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (c && D))'\'' '\''a != (b || c && D)'\'''

echo '$ test-expr '\''a != (b || (C && d))'\'''
test-expr 'a != (b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (C && d))'\'''

echo '$ diff-expr '\''a != (b || (C && d))'\'' '\''a != (b || C && d)'\'''
diff-expr 'a != (b || (C && d))' 'a != (b || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (C && d))'\'' '\''a != (b || C && d)'\'''

echo '$ test-expr '\''a != (b || (C && D))'\'''
test-expr 'a != (b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (C && D))'\'''

echo '$ diff-expr '\''a != (b || (C && D))'\'' '\''a != (b || C && D)'\'''
diff-expr 'a != (b || (C && D))' 'a != (b || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (C && D))'\'' '\''a != (b || C && D)'\'''

echo '$ test-expr '\''a != (B || (c && d))'\'''
test-expr 'a != (B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || (c && d))'\'''

echo '$ diff-expr '\''a != (B || (c && d))'\'' '\''a != (B || c && d)'\'''
diff-expr 'a != (B || (c && d))' 'a != (B || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B || (c && d))'\'' '\''a != (B || c && d)'\'''

echo '$ test-expr '\''a != (B || (c && D))'\'''
test-expr 'a != (B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || (c && D))'\'''

echo '$ diff-expr '\''a != (B || (c && D))'\'' '\''a != (B || c && D)'\'''
diff-expr 'a != (B || (c && D))' 'a != (B || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B || (c && D))'\'' '\''a != (B || c && D)'\'''

echo '$ test-expr '\''a != (B || (C && d))'\'''
test-expr 'a != (B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || (C && d))'\'''

echo '$ diff-expr '\''a != (B || (C && d))'\'' '\''a != (B || C && d)'\'''
diff-expr 'a != (B || (C && d))' 'a != (B || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B || (C && d))'\'' '\''a != (B || C && d)'\'''

echo '$ test-expr '\''a != (B || (C && D))'\'''
test-expr 'a != (B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B || (C && D))'\'''

echo '$ diff-expr '\''a != (B || (C && D))'\'' '\''a != (B || C && D)'\'''
diff-expr 'a != (B || (C && D))' 'a != (B || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B || (C && D))'\'' '\''a != (B || C && D)'\'''

echo '$ test-expr '\''A != (b || (c && d))'\'''
test-expr 'A != (b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || (c && d))'\'''

echo '$ diff-expr '\''A != (b || (c && d))'\'' '\''A != (b || c && d)'\'''
diff-expr 'A != (b || (c && d))' 'A != (b || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b || (c && d))'\'' '\''A != (b || c && d)'\'''

echo '$ test-expr '\''A != (b || (c && D))'\'''
test-expr 'A != (b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || (c && D))'\'''

echo '$ diff-expr '\''A != (b || (c && D))'\'' '\''A != (b || c && D)'\'''
diff-expr 'A != (b || (c && D))' 'A != (b || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b || (c && D))'\'' '\''A != (b || c && D)'\'''

echo '$ test-expr '\''A != (b || (C && d))'\'''
test-expr 'A != (b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || (C && d))'\'''

echo '$ diff-expr '\''A != (b || (C && d))'\'' '\''A != (b || C && d)'\'''
diff-expr 'A != (b || (C && d))' 'A != (b || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b || (C && d))'\'' '\''A != (b || C && d)'\'''

echo '$ test-expr '\''A != (b || (C && D))'\'''
test-expr 'A != (b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b || (C && D))'\'''

echo '$ diff-expr '\''A != (b || (C && D))'\'' '\''A != (b || C && D)'\'''
diff-expr 'A != (b || (C && D))' 'A != (b || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b || (C && D))'\'' '\''A != (b || C && D)'\'''

echo '$ test-expr '\''A != (B || (c && d))'\'''
test-expr 'A != (B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || (c && d))'\'''

echo '$ diff-expr '\''A != (B || (c && d))'\'' '\''A != (B || c && d)'\'''
diff-expr 'A != (B || (c && d))' 'A != (B || c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B || (c && d))'\'' '\''A != (B || c && d)'\'''

echo '$ test-expr '\''A != (B || (c && D))'\'''
test-expr 'A != (B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || (c && D))'\'''

echo '$ diff-expr '\''A != (B || (c && D))'\'' '\''A != (B || c && D)'\'''
diff-expr 'A != (B || (c && D))' 'A != (B || c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B || (c && D))'\'' '\''A != (B || c && D)'\'''

echo '$ test-expr '\''A != (B || (C && d))'\'''
test-expr 'A != (B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || (C && d))'\'''

echo '$ diff-expr '\''A != (B || (C && d))'\'' '\''A != (B || C && d)'\'''
diff-expr 'A != (B || (C && d))' 'A != (B || C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B || (C && d))'\'' '\''A != (B || C && d)'\'''

echo '$ test-expr '\''A != (B || (C && D))'\'''
test-expr 'A != (B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B || (C && D))'\'''

echo '$ diff-expr '\''A != (B || (C && D))'\'' '\''A != (B || C && D)'\'''
diff-expr 'A != (B || (C && D))' 'A != (B || C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B || (C && D))'\'' '\''A != (B || C && D)'\'''

echo '$ test-expr '\''((a != b) >= c) && d'\'''
test-expr '((a != b) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= c) && d'\'''

echo '$ diff-expr '\''((a != b) >= c) && d'\'' '\''(a != b) >= c && d'\'''
diff-expr '((a != b) >= c) && d' '(a != b) >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) && d'\'' '\''(a != b) >= c && d'\'''

echo '$ test-expr '\''((a != b) >= c) && D'\'''
test-expr '((a != b) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= c) && D'\'''

echo '$ diff-expr '\''((a != b) >= c) && D'\'' '\''(a != b) >= c && D'\'''
diff-expr '((a != b) >= c) && D' '(a != b) >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) && D'\'' '\''(a != b) >= c && D'\'''

echo '$ test-expr '\''((a != b) >= C) && d'\'''
test-expr '((a != b) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= C) && d'\'''

echo '$ diff-expr '\''((a != b) >= C) && d'\'' '\''(a != b) >= C && d'\'''
diff-expr '((a != b) >= C) && d' '(a != b) >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= C) && d'\'' '\''(a != b) >= C && d'\'''

echo '$ test-expr '\''((a != b) >= C) && D'\'''
test-expr '((a != b) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= C) && D'\'''

echo '$ diff-expr '\''((a != b) >= C) && D'\'' '\''(a != b) >= C && D'\'''
diff-expr '((a != b) >= C) && D' '(a != b) >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= C) && D'\'' '\''(a != b) >= C && D'\'''

echo '$ test-expr '\''((a != B) >= c) && d'\'''
test-expr '((a != B) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= c) && d'\'''

echo '$ diff-expr '\''((a != B) >= c) && d'\'' '\''(a != B) >= c && d'\'''
diff-expr '((a != B) >= c) && d' '(a != B) >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= c) && d'\'' '\''(a != B) >= c && d'\'''

echo '$ test-expr '\''((a != B) >= c) && D'\'''
test-expr '((a != B) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= c) && D'\'''

echo '$ diff-expr '\''((a != B) >= c) && D'\'' '\''(a != B) >= c && D'\'''
diff-expr '((a != B) >= c) && D' '(a != B) >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= c) && D'\'' '\''(a != B) >= c && D'\'''

echo '$ test-expr '\''((a != B) >= C) && d'\'''
test-expr '((a != B) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= C) && d'\'''

echo '$ diff-expr '\''((a != B) >= C) && d'\'' '\''(a != B) >= C && d'\'''
diff-expr '((a != B) >= C) && d' '(a != B) >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= C) && d'\'' '\''(a != B) >= C && d'\'''

echo '$ test-expr '\''((a != B) >= C) && D'\'''
test-expr '((a != B) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= C) && D'\'''

echo '$ diff-expr '\''((a != B) >= C) && D'\'' '\''(a != B) >= C && D'\'''
diff-expr '((a != B) >= C) && D' '(a != B) >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= C) && D'\'' '\''(a != B) >= C && D'\'''

echo '$ test-expr '\''((A != b) >= c) && d'\'''
test-expr '((A != b) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= c) && d'\'''

echo '$ diff-expr '\''((A != b) >= c) && d'\'' '\''(A != b) >= c && d'\'''
diff-expr '((A != b) >= c) && d' '(A != b) >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= c) && d'\'' '\''(A != b) >= c && d'\'''

echo '$ test-expr '\''((A != b) >= c) && D'\'''
test-expr '((A != b) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= c) && D'\'''

echo '$ diff-expr '\''((A != b) >= c) && D'\'' '\''(A != b) >= c && D'\'''
diff-expr '((A != b) >= c) && D' '(A != b) >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= c) && D'\'' '\''(A != b) >= c && D'\'''

echo '$ test-expr '\''((A != b) >= C) && d'\'''
test-expr '((A != b) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= C) && d'\'''

echo '$ diff-expr '\''((A != b) >= C) && d'\'' '\''(A != b) >= C && d'\'''
diff-expr '((A != b) >= C) && d' '(A != b) >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= C) && d'\'' '\''(A != b) >= C && d'\'''

echo '$ test-expr '\''((A != b) >= C) && D'\'''
test-expr '((A != b) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= C) && D'\'''

echo '$ diff-expr '\''((A != b) >= C) && D'\'' '\''(A != b) >= C && D'\'''
diff-expr '((A != b) >= C) && D' '(A != b) >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= C) && D'\'' '\''(A != b) >= C && D'\'''

echo '$ test-expr '\''((A != B) >= c) && d'\'''
test-expr '((A != B) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= c) && d'\'''

echo '$ diff-expr '\''((A != B) >= c) && d'\'' '\''(A != B) >= c && d'\'''
diff-expr '((A != B) >= c) && d' '(A != B) >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= c) && d'\'' '\''(A != B) >= c && d'\'''

echo '$ test-expr '\''((A != B) >= c) && D'\'''
test-expr '((A != B) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= c) && D'\'''

echo '$ diff-expr '\''((A != B) >= c) && D'\'' '\''(A != B) >= c && D'\'''
diff-expr '((A != B) >= c) && D' '(A != B) >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= c) && D'\'' '\''(A != B) >= c && D'\'''

echo '$ test-expr '\''((A != B) >= C) && d'\'''
test-expr '((A != B) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= C) && d'\'''

echo '$ diff-expr '\''((A != B) >= C) && d'\'' '\''(A != B) >= C && d'\'''
diff-expr '((A != B) >= C) && d' '(A != B) >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= C) && d'\'' '\''(A != B) >= C && d'\'''

echo '$ test-expr '\''((A != B) >= C) && D'\'''
test-expr '((A != B) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= C) && D'\'''

echo '$ diff-expr '\''((A != B) >= C) && D'\'' '\''(A != B) >= C && D'\'''
diff-expr '((A != B) >= C) && D' '(A != B) >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= C) && D'\'' '\''(A != B) >= C && D'\'''

echo '$ test-expr '\''((a != b) >= c) || d'\'''
test-expr '((a != b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= c) || d'\'''

echo '$ diff-expr '\''((a != b) >= c) || d'\'' '\''(a != b) >= c || d'\'''
diff-expr '((a != b) >= c) || d' '(a != b) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) || d'\'' '\''(a != b) >= c || d'\'''

echo '$ test-expr '\''((a != b) >= c) || D'\'''
test-expr '((a != b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= c) || D'\'''

echo '$ diff-expr '\''((a != b) >= c) || D'\'' '\''(a != b) >= c || D'\'''
diff-expr '((a != b) >= c) || D' '(a != b) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) || D'\'' '\''(a != b) >= c || D'\'''

echo '$ test-expr '\''((a != b) >= C) || d'\'''
test-expr '((a != b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= C) || d'\'''

echo '$ diff-expr '\''((a != b) >= C) || d'\'' '\''(a != b) >= C || d'\'''
diff-expr '((a != b) >= C) || d' '(a != b) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= C) || d'\'' '\''(a != b) >= C || d'\'''

echo '$ test-expr '\''((a != b) >= C) || D'\'''
test-expr '((a != b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= C) || D'\'''

echo '$ diff-expr '\''((a != b) >= C) || D'\'' '\''(a != b) >= C || D'\'''
diff-expr '((a != b) >= C) || D' '(a != b) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= C) || D'\'' '\''(a != b) >= C || D'\'''

echo '$ test-expr '\''((a != B) >= c) || d'\'''
test-expr '((a != B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= c) || d'\'''

echo '$ diff-expr '\''((a != B) >= c) || d'\'' '\''(a != B) >= c || d'\'''
diff-expr '((a != B) >= c) || d' '(a != B) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= c) || d'\'' '\''(a != B) >= c || d'\'''

echo '$ test-expr '\''((a != B) >= c) || D'\'''
test-expr '((a != B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= c) || D'\'''

echo '$ diff-expr '\''((a != B) >= c) || D'\'' '\''(a != B) >= c || D'\'''
diff-expr '((a != B) >= c) || D' '(a != B) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= c) || D'\'' '\''(a != B) >= c || D'\'''

echo '$ test-expr '\''((a != B) >= C) || d'\'''
test-expr '((a != B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= C) || d'\'''

echo '$ diff-expr '\''((a != B) >= C) || d'\'' '\''(a != B) >= C || d'\'''
diff-expr '((a != B) >= C) || d' '(a != B) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= C) || d'\'' '\''(a != B) >= C || d'\'''

echo '$ test-expr '\''((a != B) >= C) || D'\'''
test-expr '((a != B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) >= C) || D'\'''

echo '$ diff-expr '\''((a != B) >= C) || D'\'' '\''(a != B) >= C || D'\'''
diff-expr '((a != B) >= C) || D' '(a != B) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) >= C) || D'\'' '\''(a != B) >= C || D'\'''

echo '$ test-expr '\''((A != b) >= c) || d'\'''
test-expr '((A != b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= c) || d'\'''

echo '$ diff-expr '\''((A != b) >= c) || d'\'' '\''(A != b) >= c || d'\'''
diff-expr '((A != b) >= c) || d' '(A != b) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= c) || d'\'' '\''(A != b) >= c || d'\'''

echo '$ test-expr '\''((A != b) >= c) || D'\'''
test-expr '((A != b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= c) || D'\'''

echo '$ diff-expr '\''((A != b) >= c) || D'\'' '\''(A != b) >= c || D'\'''
diff-expr '((A != b) >= c) || D' '(A != b) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= c) || D'\'' '\''(A != b) >= c || D'\'''

echo '$ test-expr '\''((A != b) >= C) || d'\'''
test-expr '((A != b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= C) || d'\'''

echo '$ diff-expr '\''((A != b) >= C) || d'\'' '\''(A != b) >= C || d'\'''
diff-expr '((A != b) >= C) || d' '(A != b) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= C) || d'\'' '\''(A != b) >= C || d'\'''

echo '$ test-expr '\''((A != b) >= C) || D'\'''
test-expr '((A != b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) >= C) || D'\'''

echo '$ diff-expr '\''((A != b) >= C) || D'\'' '\''(A != b) >= C || D'\'''
diff-expr '((A != b) >= C) || D' '(A != b) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) >= C) || D'\'' '\''(A != b) >= C || D'\'''

echo '$ test-expr '\''((A != B) >= c) || d'\'''
test-expr '((A != B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= c) || d'\'''

echo '$ diff-expr '\''((A != B) >= c) || d'\'' '\''(A != B) >= c || d'\'''
diff-expr '((A != B) >= c) || d' '(A != B) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= c) || d'\'' '\''(A != B) >= c || d'\'''

echo '$ test-expr '\''((A != B) >= c) || D'\'''
test-expr '((A != B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= c) || D'\'''

echo '$ diff-expr '\''((A != B) >= c) || D'\'' '\''(A != B) >= c || D'\'''
diff-expr '((A != B) >= c) || D' '(A != B) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= c) || D'\'' '\''(A != B) >= c || D'\'''

echo '$ test-expr '\''((A != B) >= C) || d'\'''
test-expr '((A != B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= C) || d'\'''

echo '$ diff-expr '\''((A != B) >= C) || d'\'' '\''(A != B) >= C || d'\'''
diff-expr '((A != B) >= C) || d' '(A != B) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= C) || d'\'' '\''(A != B) >= C || d'\'''

echo '$ test-expr '\''((A != B) >= C) || D'\'''
test-expr '((A != B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) >= C) || D'\'''

echo '$ diff-expr '\''((A != B) >= C) || D'\'' '\''(A != B) >= C || D'\'''
diff-expr '((A != B) >= C) || D' '(A != B) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) >= C) || D'\'' '\''(A != B) >= C || D'\'''

echo '$ test-expr '\''((a && b) >= c) || d'\'''
test-expr '((a && b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= c) || d'\'''

echo '$ diff-expr '\''((a && b) >= c) || d'\'' '\''(a && b) >= c || d'\'''
diff-expr '((a && b) >= c) || d' '(a && b) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= c) || d'\'' '\''(a && b) >= c || d'\'''

echo '$ test-expr '\''((a && b) >= c) || D'\'''
test-expr '((a && b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= c) || D'\'''

echo '$ diff-expr '\''((a && b) >= c) || D'\'' '\''(a && b) >= c || D'\'''
diff-expr '((a && b) >= c) || D' '(a && b) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= c) || D'\'' '\''(a && b) >= c || D'\'''

echo '$ test-expr '\''((a && b) >= C) || d'\'''
test-expr '((a && b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= C) || d'\'''

echo '$ diff-expr '\''((a && b) >= C) || d'\'' '\''(a && b) >= C || d'\'''
diff-expr '((a && b) >= C) || d' '(a && b) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= C) || d'\'' '\''(a && b) >= C || d'\'''

echo '$ test-expr '\''((a && b) >= C) || D'\'''
test-expr '((a && b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= C) || D'\'''

echo '$ diff-expr '\''((a && b) >= C) || D'\'' '\''(a && b) >= C || D'\'''
diff-expr '((a && b) >= C) || D' '(a && b) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= C) || D'\'' '\''(a && b) >= C || D'\'''

echo '$ test-expr '\''((a && B) >= c) || d'\'''
test-expr '((a && B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) >= c) || d'\'''

echo '$ diff-expr '\''((a && B) >= c) || d'\'' '\''(a && B) >= c || d'\'''
diff-expr '((a && B) >= c) || d' '(a && B) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) >= c) || d'\'' '\''(a && B) >= c || d'\'''

echo '$ test-expr '\''((a && B) >= c) || D'\'''
test-expr '((a && B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) >= c) || D'\'''

echo '$ diff-expr '\''((a && B) >= c) || D'\'' '\''(a && B) >= c || D'\'''
diff-expr '((a && B) >= c) || D' '(a && B) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) >= c) || D'\'' '\''(a && B) >= c || D'\'''

echo '$ test-expr '\''((a && B) >= C) || d'\'''
test-expr '((a && B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) >= C) || d'\'''

echo '$ diff-expr '\''((a && B) >= C) || d'\'' '\''(a && B) >= C || d'\'''
diff-expr '((a && B) >= C) || d' '(a && B) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) >= C) || d'\'' '\''(a && B) >= C || d'\'''

echo '$ test-expr '\''((a && B) >= C) || D'\'''
test-expr '((a && B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) >= C) || D'\'''

echo '$ diff-expr '\''((a && B) >= C) || D'\'' '\''(a && B) >= C || D'\'''
diff-expr '((a && B) >= C) || D' '(a && B) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) >= C) || D'\'' '\''(a && B) >= C || D'\'''

echo '$ test-expr '\''((A && b) >= c) || d'\'''
test-expr '((A && b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) >= c) || d'\'''

echo '$ diff-expr '\''((A && b) >= c) || d'\'' '\''(A && b) >= c || d'\'''
diff-expr '((A && b) >= c) || d' '(A && b) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) >= c) || d'\'' '\''(A && b) >= c || d'\'''

echo '$ test-expr '\''((A && b) >= c) || D'\'''
test-expr '((A && b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) >= c) || D'\'''

echo '$ diff-expr '\''((A && b) >= c) || D'\'' '\''(A && b) >= c || D'\'''
diff-expr '((A && b) >= c) || D' '(A && b) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) >= c) || D'\'' '\''(A && b) >= c || D'\'''

echo '$ test-expr '\''((A && b) >= C) || d'\'''
test-expr '((A && b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) >= C) || d'\'''

echo '$ diff-expr '\''((A && b) >= C) || d'\'' '\''(A && b) >= C || d'\'''
diff-expr '((A && b) >= C) || d' '(A && b) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) >= C) || d'\'' '\''(A && b) >= C || d'\'''

echo '$ test-expr '\''((A && b) >= C) || D'\'''
test-expr '((A && b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) >= C) || D'\'''

echo '$ diff-expr '\''((A && b) >= C) || D'\'' '\''(A && b) >= C || D'\'''
diff-expr '((A && b) >= C) || D' '(A && b) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) >= C) || D'\'' '\''(A && b) >= C || D'\'''

echo '$ test-expr '\''((A && B) >= c) || d'\'''
test-expr '((A && B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) >= c) || d'\'''

echo '$ diff-expr '\''((A && B) >= c) || d'\'' '\''(A && B) >= c || d'\'''
diff-expr '((A && B) >= c) || d' '(A && B) >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) >= c) || d'\'' '\''(A && B) >= c || d'\'''

echo '$ test-expr '\''((A && B) >= c) || D'\'''
test-expr '((A && B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) >= c) || D'\'''

echo '$ diff-expr '\''((A && B) >= c) || D'\'' '\''(A && B) >= c || D'\'''
diff-expr '((A && B) >= c) || D' '(A && B) >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) >= c) || D'\'' '\''(A && B) >= c || D'\'''

echo '$ test-expr '\''((A && B) >= C) || d'\'''
test-expr '((A && B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) >= C) || d'\'''

echo '$ diff-expr '\''((A && B) >= C) || d'\'' '\''(A && B) >= C || d'\'''
diff-expr '((A && B) >= C) || d' '(A && B) >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) >= C) || d'\'' '\''(A && B) >= C || d'\'''

echo '$ test-expr '\''((A && B) >= C) || D'\'''
test-expr '((A && B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) >= C) || D'\'''

echo '$ diff-expr '\''((A && B) >= C) || D'\'' '\''(A && B) >= C || D'\'''
diff-expr '((A && B) >= C) || D' '(A && B) >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) >= C) || D'\'' '\''(A && B) >= C || D'\'''

echo '$ test-expr '\''((a && b) != c) || d'\'''
test-expr '((a && b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != c) || d'\'''

echo '$ diff-expr '\''((a && b) != c) || d'\'' '\''(a && b) != c || d'\'''
diff-expr '((a && b) != c) || d' '(a && b) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != c) || d'\'' '\''(a && b) != c || d'\'''

echo '$ test-expr '\''((a && b) != c) || D'\'''
test-expr '((a && b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != c) || D'\'''

echo '$ diff-expr '\''((a && b) != c) || D'\'' '\''(a && b) != c || D'\'''
diff-expr '((a && b) != c) || D' '(a && b) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != c) || D'\'' '\''(a && b) != c || D'\'''

echo '$ test-expr '\''((a && b) != C) || d'\'''
test-expr '((a && b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != C) || d'\'''

echo '$ diff-expr '\''((a && b) != C) || d'\'' '\''(a && b) != C || d'\'''
diff-expr '((a && b) != C) || d' '(a && b) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != C) || d'\'' '\''(a && b) != C || d'\'''

echo '$ test-expr '\''((a && b) != C) || D'\'''
test-expr '((a && b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != C) || D'\'''

echo '$ diff-expr '\''((a && b) != C) || D'\'' '\''(a && b) != C || D'\'''
diff-expr '((a && b) != C) || D' '(a && b) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != C) || D'\'' '\''(a && b) != C || D'\'''

echo '$ test-expr '\''((a && B) != c) || d'\'''
test-expr '((a && B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) != c) || d'\'''

echo '$ diff-expr '\''((a && B) != c) || d'\'' '\''(a && B) != c || d'\'''
diff-expr '((a && B) != c) || d' '(a && B) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) != c) || d'\'' '\''(a && B) != c || d'\'''

echo '$ test-expr '\''((a && B) != c) || D'\'''
test-expr '((a && B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) != c) || D'\'''

echo '$ diff-expr '\''((a && B) != c) || D'\'' '\''(a && B) != c || D'\'''
diff-expr '((a && B) != c) || D' '(a && B) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) != c) || D'\'' '\''(a && B) != c || D'\'''

echo '$ test-expr '\''((a && B) != C) || d'\'''
test-expr '((a && B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) != C) || d'\'''

echo '$ diff-expr '\''((a && B) != C) || d'\'' '\''(a && B) != C || d'\'''
diff-expr '((a && B) != C) || d' '(a && B) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) != C) || d'\'' '\''(a && B) != C || d'\'''

echo '$ test-expr '\''((a && B) != C) || D'\'''
test-expr '((a && B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) != C) || D'\'''

echo '$ diff-expr '\''((a && B) != C) || D'\'' '\''(a && B) != C || D'\'''
diff-expr '((a && B) != C) || D' '(a && B) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) != C) || D'\'' '\''(a && B) != C || D'\'''

echo '$ test-expr '\''((A && b) != c) || d'\'''
test-expr '((A && b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) != c) || d'\'''

echo '$ diff-expr '\''((A && b) != c) || d'\'' '\''(A && b) != c || d'\'''
diff-expr '((A && b) != c) || d' '(A && b) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) != c) || d'\'' '\''(A && b) != c || d'\'''

echo '$ test-expr '\''((A && b) != c) || D'\'''
test-expr '((A && b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) != c) || D'\'''

echo '$ diff-expr '\''((A && b) != c) || D'\'' '\''(A && b) != c || D'\'''
diff-expr '((A && b) != c) || D' '(A && b) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) != c) || D'\'' '\''(A && b) != c || D'\'''

echo '$ test-expr '\''((A && b) != C) || d'\'''
test-expr '((A && b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) != C) || d'\'''

echo '$ diff-expr '\''((A && b) != C) || d'\'' '\''(A && b) != C || d'\'''
diff-expr '((A && b) != C) || d' '(A && b) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) != C) || d'\'' '\''(A && b) != C || d'\'''

echo '$ test-expr '\''((A && b) != C) || D'\'''
test-expr '((A && b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) != C) || D'\'''

echo '$ diff-expr '\''((A && b) != C) || D'\'' '\''(A && b) != C || D'\'''
diff-expr '((A && b) != C) || D' '(A && b) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) != C) || D'\'' '\''(A && b) != C || D'\'''

echo '$ test-expr '\''((A && B) != c) || d'\'''
test-expr '((A && B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) != c) || d'\'''

echo '$ diff-expr '\''((A && B) != c) || d'\'' '\''(A && B) != c || d'\'''
diff-expr '((A && B) != c) || d' '(A && B) != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) != c) || d'\'' '\''(A && B) != c || d'\'''

echo '$ test-expr '\''((A && B) != c) || D'\'''
test-expr '((A && B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) != c) || D'\'''

echo '$ diff-expr '\''((A && B) != c) || D'\'' '\''(A && B) != c || D'\'''
diff-expr '((A && B) != c) || D' '(A && B) != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) != c) || D'\'' '\''(A && B) != c || D'\'''

echo '$ test-expr '\''((A && B) != C) || d'\'''
test-expr '((A && B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) != C) || d'\'''

echo '$ diff-expr '\''((A && B) != C) || d'\'' '\''(A && B) != C || d'\'''
diff-expr '((A && B) != C) || d' '(A && B) != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) != C) || d'\'' '\''(A && B) != C || d'\'''

echo '$ test-expr '\''((A && B) != C) || D'\'''
test-expr '((A && B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) != C) || D'\'''

echo '$ diff-expr '\''((A && B) != C) || D'\'' '\''(A && B) != C || D'\'''
diff-expr '((A && B) != C) || D' '(A && B) != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) != C) || D'\'' '\''(A && B) != C || D'\'''

echo '$ test-expr '\''a != ((b >= c) && d)'\'''
test-expr 'a != ((b >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && d)'\'''

echo '$ diff-expr '\''a != ((b >= c) && d)'\'' '\''a != (b >= c && d)'\'''
diff-expr 'a != ((b >= c) && d)' 'a != (b >= c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) && d)'\'' '\''a != (b >= c && d)'\'''

echo '$ test-expr '\''a != ((b >= c) && D)'\'''
test-expr 'a != ((b >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && D)'\'''

echo '$ diff-expr '\''a != ((b >= c) && D)'\'' '\''a != (b >= c && D)'\'''
diff-expr 'a != ((b >= c) && D)' 'a != (b >= c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) && D)'\'' '\''a != (b >= c && D)'\'''

echo '$ test-expr '\''a != ((b >= C) && d)'\'''
test-expr 'a != ((b >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= C) && d)'\'''

echo '$ diff-expr '\''a != ((b >= C) && d)'\'' '\''a != (b >= C && d)'\'''
diff-expr 'a != ((b >= C) && d)' 'a != (b >= C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= C) && d)'\'' '\''a != (b >= C && d)'\'''

echo '$ test-expr '\''a != ((b >= C) && D)'\'''
test-expr 'a != ((b >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= C) && D)'\'''

echo '$ diff-expr '\''a != ((b >= C) && D)'\'' '\''a != (b >= C && D)'\'''
diff-expr 'a != ((b >= C) && D)' 'a != (b >= C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= C) && D)'\'' '\''a != (b >= C && D)'\'''

echo '$ test-expr '\''a != ((B >= c) && d)'\'''
test-expr 'a != ((B >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= c) && d)'\'''

echo '$ diff-expr '\''a != ((B >= c) && d)'\'' '\''a != (B >= c && d)'\'''
diff-expr 'a != ((B >= c) && d)' 'a != (B >= c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= c) && d)'\'' '\''a != (B >= c && d)'\'''

echo '$ test-expr '\''a != ((B >= c) && D)'\'''
test-expr 'a != ((B >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= c) && D)'\'''

echo '$ diff-expr '\''a != ((B >= c) && D)'\'' '\''a != (B >= c && D)'\'''
diff-expr 'a != ((B >= c) && D)' 'a != (B >= c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= c) && D)'\'' '\''a != (B >= c && D)'\'''

echo '$ test-expr '\''a != ((B >= C) && d)'\'''
test-expr 'a != ((B >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= C) && d)'\'''

echo '$ diff-expr '\''a != ((B >= C) && d)'\'' '\''a != (B >= C && d)'\'''
diff-expr 'a != ((B >= C) && d)' 'a != (B >= C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= C) && d)'\'' '\''a != (B >= C && d)'\'''

echo '$ test-expr '\''a != ((B >= C) && D)'\'''
test-expr 'a != ((B >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= C) && D)'\'''

echo '$ diff-expr '\''a != ((B >= C) && D)'\'' '\''a != (B >= C && D)'\'''
diff-expr 'a != ((B >= C) && D)' 'a != (B >= C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= C) && D)'\'' '\''a != (B >= C && D)'\'''

echo '$ test-expr '\''A != ((b >= c) && d)'\'''
test-expr 'A != ((b >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= c) && d)'\'''

echo '$ diff-expr '\''A != ((b >= c) && d)'\'' '\''A != (b >= c && d)'\'''
diff-expr 'A != ((b >= c) && d)' 'A != (b >= c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= c) && d)'\'' '\''A != (b >= c && d)'\'''

echo '$ test-expr '\''A != ((b >= c) && D)'\'''
test-expr 'A != ((b >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= c) && D)'\'''

echo '$ diff-expr '\''A != ((b >= c) && D)'\'' '\''A != (b >= c && D)'\'''
diff-expr 'A != ((b >= c) && D)' 'A != (b >= c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= c) && D)'\'' '\''A != (b >= c && D)'\'''

echo '$ test-expr '\''A != ((b >= C) && d)'\'''
test-expr 'A != ((b >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= C) && d)'\'''

echo '$ diff-expr '\''A != ((b >= C) && d)'\'' '\''A != (b >= C && d)'\'''
diff-expr 'A != ((b >= C) && d)' 'A != (b >= C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= C) && d)'\'' '\''A != (b >= C && d)'\'''

echo '$ test-expr '\''A != ((b >= C) && D)'\'''
test-expr 'A != ((b >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= C) && D)'\'''

echo '$ diff-expr '\''A != ((b >= C) && D)'\'' '\''A != (b >= C && D)'\'''
diff-expr 'A != ((b >= C) && D)' 'A != (b >= C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= C) && D)'\'' '\''A != (b >= C && D)'\'''

echo '$ test-expr '\''A != ((B >= c) && d)'\'''
test-expr 'A != ((B >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= c) && d)'\'''

echo '$ diff-expr '\''A != ((B >= c) && d)'\'' '\''A != (B >= c && d)'\'''
diff-expr 'A != ((B >= c) && d)' 'A != (B >= c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= c) && d)'\'' '\''A != (B >= c && d)'\'''

echo '$ test-expr '\''A != ((B >= c) && D)'\'''
test-expr 'A != ((B >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= c) && D)'\'''

echo '$ diff-expr '\''A != ((B >= c) && D)'\'' '\''A != (B >= c && D)'\'''
diff-expr 'A != ((B >= c) && D)' 'A != (B >= c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= c) && D)'\'' '\''A != (B >= c && D)'\'''

echo '$ test-expr '\''A != ((B >= C) && d)'\'''
test-expr 'A != ((B >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= C) && d)'\'''

echo '$ diff-expr '\''A != ((B >= C) && d)'\'' '\''A != (B >= C && d)'\'''
diff-expr 'A != ((B >= C) && d)' 'A != (B >= C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= C) && d)'\'' '\''A != (B >= C && d)'\'''

echo '$ test-expr '\''A != ((B >= C) && D)'\'''
test-expr 'A != ((B >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= C) && D)'\'''

echo '$ diff-expr '\''A != ((B >= C) && D)'\'' '\''A != (B >= C && D)'\'''
diff-expr 'A != ((B >= C) && D)' 'A != (B >= C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= C) && D)'\'' '\''A != (B >= C && D)'\'''

echo '$ test-expr '\''a != ((b >= c) || d)'\'''
test-expr 'a != ((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || d)'\'''

echo '$ diff-expr '\''a != ((b >= c) || d)'\'' '\''a != (b >= c || d)'\'''
diff-expr 'a != ((b >= c) || d)' 'a != (b >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) || d)'\'' '\''a != (b >= c || d)'\'''

echo '$ test-expr '\''a != ((b >= c) || D)'\'''
test-expr 'a != ((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || D)'\'''

echo '$ diff-expr '\''a != ((b >= c) || D)'\'' '\''a != (b >= c || D)'\'''
diff-expr 'a != ((b >= c) || D)' 'a != (b >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) || D)'\'' '\''a != (b >= c || D)'\'''

echo '$ test-expr '\''a != ((b >= C) || d)'\'''
test-expr 'a != ((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= C) || d)'\'''

echo '$ diff-expr '\''a != ((b >= C) || d)'\'' '\''a != (b >= C || d)'\'''
diff-expr 'a != ((b >= C) || d)' 'a != (b >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= C) || d)'\'' '\''a != (b >= C || d)'\'''

echo '$ test-expr '\''a != ((b >= C) || D)'\'''
test-expr 'a != ((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= C) || D)'\'''

echo '$ diff-expr '\''a != ((b >= C) || D)'\'' '\''a != (b >= C || D)'\'''
diff-expr 'a != ((b >= C) || D)' 'a != (b >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= C) || D)'\'' '\''a != (b >= C || D)'\'''

echo '$ test-expr '\''a != ((B >= c) || d)'\'''
test-expr 'a != ((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= c) || d)'\'''

echo '$ diff-expr '\''a != ((B >= c) || d)'\'' '\''a != (B >= c || d)'\'''
diff-expr 'a != ((B >= c) || d)' 'a != (B >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= c) || d)'\'' '\''a != (B >= c || d)'\'''

echo '$ test-expr '\''a != ((B >= c) || D)'\'''
test-expr 'a != ((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= c) || D)'\'''

echo '$ diff-expr '\''a != ((B >= c) || D)'\'' '\''a != (B >= c || D)'\'''
diff-expr 'a != ((B >= c) || D)' 'a != (B >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= c) || D)'\'' '\''a != (B >= c || D)'\'''

echo '$ test-expr '\''a != ((B >= C) || d)'\'''
test-expr 'a != ((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= C) || d)'\'''

echo '$ diff-expr '\''a != ((B >= C) || d)'\'' '\''a != (B >= C || d)'\'''
diff-expr 'a != ((B >= C) || d)' 'a != (B >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= C) || d)'\'' '\''a != (B >= C || d)'\'''

echo '$ test-expr '\''a != ((B >= C) || D)'\'''
test-expr 'a != ((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B >= C) || D)'\'''

echo '$ diff-expr '\''a != ((B >= C) || D)'\'' '\''a != (B >= C || D)'\'''
diff-expr 'a != ((B >= C) || D)' 'a != (B >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B >= C) || D)'\'' '\''a != (B >= C || D)'\'''

echo '$ test-expr '\''A != ((b >= c) || d)'\'''
test-expr 'A != ((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= c) || d)'\'''

echo '$ diff-expr '\''A != ((b >= c) || d)'\'' '\''A != (b >= c || d)'\'''
diff-expr 'A != ((b >= c) || d)' 'A != (b >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= c) || d)'\'' '\''A != (b >= c || d)'\'''

echo '$ test-expr '\''A != ((b >= c) || D)'\'''
test-expr 'A != ((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= c) || D)'\'''

echo '$ diff-expr '\''A != ((b >= c) || D)'\'' '\''A != (b >= c || D)'\'''
diff-expr 'A != ((b >= c) || D)' 'A != (b >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= c) || D)'\'' '\''A != (b >= c || D)'\'''

echo '$ test-expr '\''A != ((b >= C) || d)'\'''
test-expr 'A != ((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= C) || d)'\'''

echo '$ diff-expr '\''A != ((b >= C) || d)'\'' '\''A != (b >= C || d)'\'''
diff-expr 'A != ((b >= C) || d)' 'A != (b >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= C) || d)'\'' '\''A != (b >= C || d)'\'''

echo '$ test-expr '\''A != ((b >= C) || D)'\'''
test-expr 'A != ((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b >= C) || D)'\'''

echo '$ diff-expr '\''A != ((b >= C) || D)'\'' '\''A != (b >= C || D)'\'''
diff-expr 'A != ((b >= C) || D)' 'A != (b >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b >= C) || D)'\'' '\''A != (b >= C || D)'\'''

echo '$ test-expr '\''A != ((B >= c) || d)'\'''
test-expr 'A != ((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= c) || d)'\'''

echo '$ diff-expr '\''A != ((B >= c) || d)'\'' '\''A != (B >= c || d)'\'''
diff-expr 'A != ((B >= c) || d)' 'A != (B >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= c) || d)'\'' '\''A != (B >= c || d)'\'''

echo '$ test-expr '\''A != ((B >= c) || D)'\'''
test-expr 'A != ((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= c) || D)'\'''

echo '$ diff-expr '\''A != ((B >= c) || D)'\'' '\''A != (B >= c || D)'\'''
diff-expr 'A != ((B >= c) || D)' 'A != (B >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= c) || D)'\'' '\''A != (B >= c || D)'\'''

echo '$ test-expr '\''A != ((B >= C) || d)'\'''
test-expr 'A != ((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= C) || d)'\'''

echo '$ diff-expr '\''A != ((B >= C) || d)'\'' '\''A != (B >= C || d)'\'''
diff-expr 'A != ((B >= C) || d)' 'A != (B >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= C) || d)'\'' '\''A != (B >= C || d)'\'''

echo '$ test-expr '\''A != ((B >= C) || D)'\'''
test-expr 'A != ((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B >= C) || D)'\'''

echo '$ diff-expr '\''A != ((B >= C) || D)'\'' '\''A != (B >= C || D)'\'''
diff-expr 'A != ((B >= C) || D)' 'A != (B >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B >= C) || D)'\'' '\''A != (B >= C || D)'\'''

echo '$ test-expr '\''a && ((b >= c) || d)'\'''
test-expr 'a && ((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || d)'\'''

echo '$ diff-expr '\''a && ((b >= c) || d)'\'' '\''a && (b >= c || d)'\'''
diff-expr 'a && ((b >= c) || d)' 'a && (b >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) || d)'\'' '\''a && (b >= c || d)'\'''

echo '$ test-expr '\''a && ((b >= c) || D)'\'''
test-expr 'a && ((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || D)'\'''

echo '$ diff-expr '\''a && ((b >= c) || D)'\'' '\''a && (b >= c || D)'\'''
diff-expr 'a && ((b >= c) || D)' 'a && (b >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) || D)'\'' '\''a && (b >= c || D)'\'''

echo '$ test-expr '\''a && ((b >= C) || d)'\'''
test-expr 'a && ((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= C) || d)'\'''

echo '$ diff-expr '\''a && ((b >= C) || d)'\'' '\''a && (b >= C || d)'\'''
diff-expr 'a && ((b >= C) || d)' 'a && (b >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= C) || d)'\'' '\''a && (b >= C || d)'\'''

echo '$ test-expr '\''a && ((b >= C) || D)'\'''
test-expr 'a && ((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= C) || D)'\'''

echo '$ diff-expr '\''a && ((b >= C) || D)'\'' '\''a && (b >= C || D)'\'''
diff-expr 'a && ((b >= C) || D)' 'a && (b >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= C) || D)'\'' '\''a && (b >= C || D)'\'''

echo '$ test-expr '\''a && ((B >= c) || d)'\'''
test-expr 'a && ((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B >= c) || d)'\'''

echo '$ diff-expr '\''a && ((B >= c) || d)'\'' '\''a && (B >= c || d)'\'''
diff-expr 'a && ((B >= c) || d)' 'a && (B >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B >= c) || d)'\'' '\''a && (B >= c || d)'\'''

echo '$ test-expr '\''a && ((B >= c) || D)'\'''
test-expr 'a && ((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B >= c) || D)'\'''

echo '$ diff-expr '\''a && ((B >= c) || D)'\'' '\''a && (B >= c || D)'\'''
diff-expr 'a && ((B >= c) || D)' 'a && (B >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B >= c) || D)'\'' '\''a && (B >= c || D)'\'''

echo '$ test-expr '\''a && ((B >= C) || d)'\'''
test-expr 'a && ((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B >= C) || d)'\'''

echo '$ diff-expr '\''a && ((B >= C) || d)'\'' '\''a && (B >= C || d)'\'''
diff-expr 'a && ((B >= C) || d)' 'a && (B >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B >= C) || d)'\'' '\''a && (B >= C || d)'\'''

echo '$ test-expr '\''a && ((B >= C) || D)'\'''
test-expr 'a && ((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B >= C) || D)'\'''

echo '$ diff-expr '\''a && ((B >= C) || D)'\'' '\''a && (B >= C || D)'\'''
diff-expr 'a && ((B >= C) || D)' 'a && (B >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B >= C) || D)'\'' '\''a && (B >= C || D)'\'''

echo '$ test-expr '\''A && ((b >= c) || d)'\'''
test-expr 'A && ((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b >= c) || d)'\'''

echo '$ diff-expr '\''A && ((b >= c) || d)'\'' '\''A && (b >= c || d)'\'''
diff-expr 'A && ((b >= c) || d)' 'A && (b >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b >= c) || d)'\'' '\''A && (b >= c || d)'\'''

echo '$ test-expr '\''A && ((b >= c) || D)'\'''
test-expr 'A && ((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b >= c) || D)'\'''

echo '$ diff-expr '\''A && ((b >= c) || D)'\'' '\''A && (b >= c || D)'\'''
diff-expr 'A && ((b >= c) || D)' 'A && (b >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b >= c) || D)'\'' '\''A && (b >= c || D)'\'''

echo '$ test-expr '\''A && ((b >= C) || d)'\'''
test-expr 'A && ((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b >= C) || d)'\'''

echo '$ diff-expr '\''A && ((b >= C) || d)'\'' '\''A && (b >= C || d)'\'''
diff-expr 'A && ((b >= C) || d)' 'A && (b >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b >= C) || d)'\'' '\''A && (b >= C || d)'\'''

echo '$ test-expr '\''A && ((b >= C) || D)'\'''
test-expr 'A && ((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b >= C) || D)'\'''

echo '$ diff-expr '\''A && ((b >= C) || D)'\'' '\''A && (b >= C || D)'\'''
diff-expr 'A && ((b >= C) || D)' 'A && (b >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b >= C) || D)'\'' '\''A && (b >= C || D)'\'''

echo '$ test-expr '\''A && ((B >= c) || d)'\'''
test-expr 'A && ((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B >= c) || d)'\'''

echo '$ diff-expr '\''A && ((B >= c) || d)'\'' '\''A && (B >= c || d)'\'''
diff-expr 'A && ((B >= c) || d)' 'A && (B >= c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B >= c) || d)'\'' '\''A && (B >= c || d)'\'''

echo '$ test-expr '\''A && ((B >= c) || D)'\'''
test-expr 'A && ((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B >= c) || D)'\'''

echo '$ diff-expr '\''A && ((B >= c) || D)'\'' '\''A && (B >= c || D)'\'''
diff-expr 'A && ((B >= c) || D)' 'A && (B >= c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B >= c) || D)'\'' '\''A && (B >= c || D)'\'''

echo '$ test-expr '\''A && ((B >= C) || d)'\'''
test-expr 'A && ((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B >= C) || d)'\'''

echo '$ diff-expr '\''A && ((B >= C) || d)'\'' '\''A && (B >= C || d)'\'''
diff-expr 'A && ((B >= C) || d)' 'A && (B >= C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B >= C) || d)'\'' '\''A && (B >= C || d)'\'''

echo '$ test-expr '\''A && ((B >= C) || D)'\'''
test-expr 'A && ((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B >= C) || D)'\'''

echo '$ diff-expr '\''A && ((B >= C) || D)'\'' '\''A && (B >= C || D)'\'''
diff-expr 'A && ((B >= C) || D)' 'A && (B >= C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B >= C) || D)'\'' '\''A && (B >= C || D)'\'''

echo '$ test-expr '\''a && ((b != c) || d)'\'''
test-expr 'a && ((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || d)'\'''

echo '$ diff-expr '\''a && ((b != c) || d)'\'' '\''a && (b != c || d)'\'''
diff-expr 'a && ((b != c) || d)' 'a && (b != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != c) || d)'\'' '\''a && (b != c || d)'\'''

echo '$ test-expr '\''a && ((b != c) || D)'\'''
test-expr 'a && ((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || D)'\'''

echo '$ diff-expr '\''a && ((b != c) || D)'\'' '\''a && (b != c || D)'\'''
diff-expr 'a && ((b != c) || D)' 'a && (b != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != c) || D)'\'' '\''a && (b != c || D)'\'''

echo '$ test-expr '\''a && ((b != C) || d)'\'''
test-expr 'a && ((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != C) || d)'\'''

echo '$ diff-expr '\''a && ((b != C) || d)'\'' '\''a && (b != C || d)'\'''
diff-expr 'a && ((b != C) || d)' 'a && (b != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != C) || d)'\'' '\''a && (b != C || d)'\'''

echo '$ test-expr '\''a && ((b != C) || D)'\'''
test-expr 'a && ((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != C) || D)'\'''

echo '$ diff-expr '\''a && ((b != C) || D)'\'' '\''a && (b != C || D)'\'''
diff-expr 'a && ((b != C) || D)' 'a && (b != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != C) || D)'\'' '\''a && (b != C || D)'\'''

echo '$ test-expr '\''a && ((B != c) || d)'\'''
test-expr 'a && ((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B != c) || d)'\'''

echo '$ diff-expr '\''a && ((B != c) || d)'\'' '\''a && (B != c || d)'\'''
diff-expr 'a && ((B != c) || d)' 'a && (B != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B != c) || d)'\'' '\''a && (B != c || d)'\'''

echo '$ test-expr '\''a && ((B != c) || D)'\'''
test-expr 'a && ((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B != c) || D)'\'''

echo '$ diff-expr '\''a && ((B != c) || D)'\'' '\''a && (B != c || D)'\'''
diff-expr 'a && ((B != c) || D)' 'a && (B != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B != c) || D)'\'' '\''a && (B != c || D)'\'''

echo '$ test-expr '\''a && ((B != C) || d)'\'''
test-expr 'a && ((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B != C) || d)'\'''

echo '$ diff-expr '\''a && ((B != C) || d)'\'' '\''a && (B != C || d)'\'''
diff-expr 'a && ((B != C) || d)' 'a && (B != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B != C) || d)'\'' '\''a && (B != C || d)'\'''

echo '$ test-expr '\''a && ((B != C) || D)'\'''
test-expr 'a && ((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B != C) || D)'\'''

echo '$ diff-expr '\''a && ((B != C) || D)'\'' '\''a && (B != C || D)'\'''
diff-expr 'a && ((B != C) || D)' 'a && (B != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B != C) || D)'\'' '\''a && (B != C || D)'\'''

echo '$ test-expr '\''A && ((b != c) || d)'\'''
test-expr 'A && ((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b != c) || d)'\'''

echo '$ diff-expr '\''A && ((b != c) || d)'\'' '\''A && (b != c || d)'\'''
diff-expr 'A && ((b != c) || d)' 'A && (b != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b != c) || d)'\'' '\''A && (b != c || d)'\'''

echo '$ test-expr '\''A && ((b != c) || D)'\'''
test-expr 'A && ((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b != c) || D)'\'''

echo '$ diff-expr '\''A && ((b != c) || D)'\'' '\''A && (b != c || D)'\'''
diff-expr 'A && ((b != c) || D)' 'A && (b != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b != c) || D)'\'' '\''A && (b != c || D)'\'''

echo '$ test-expr '\''A && ((b != C) || d)'\'''
test-expr 'A && ((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b != C) || d)'\'''

echo '$ diff-expr '\''A && ((b != C) || d)'\'' '\''A && (b != C || d)'\'''
diff-expr 'A && ((b != C) || d)' 'A && (b != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b != C) || d)'\'' '\''A && (b != C || d)'\'''

echo '$ test-expr '\''A && ((b != C) || D)'\'''
test-expr 'A && ((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b != C) || D)'\'''

echo '$ diff-expr '\''A && ((b != C) || D)'\'' '\''A && (b != C || D)'\'''
diff-expr 'A && ((b != C) || D)' 'A && (b != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b != C) || D)'\'' '\''A && (b != C || D)'\'''

echo '$ test-expr '\''A && ((B != c) || d)'\'''
test-expr 'A && ((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B != c) || d)'\'''

echo '$ diff-expr '\''A && ((B != c) || d)'\'' '\''A && (B != c || d)'\'''
diff-expr 'A && ((B != c) || d)' 'A && (B != c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B != c) || d)'\'' '\''A && (B != c || d)'\'''

echo '$ test-expr '\''A && ((B != c) || D)'\'''
test-expr 'A && ((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B != c) || D)'\'''

echo '$ diff-expr '\''A && ((B != c) || D)'\'' '\''A && (B != c || D)'\'''
diff-expr 'A && ((B != c) || D)' 'A && (B != c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B != c) || D)'\'' '\''A && (B != c || D)'\'''

echo '$ test-expr '\''A && ((B != C) || d)'\'''
test-expr 'A && ((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B != C) || d)'\'''

echo '$ diff-expr '\''A && ((B != C) || d)'\'' '\''A && (B != C || d)'\'''
diff-expr 'A && ((B != C) || d)' 'A && (B != C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B != C) || d)'\'' '\''A && (B != C || d)'\'''

echo '$ test-expr '\''A && ((B != C) || D)'\'''
test-expr 'A && ((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B != C) || D)'\'''

echo '$ diff-expr '\''A && ((B != C) || D)'\'' '\''A && (B != C || D)'\'''
diff-expr 'A && ((B != C) || D)' 'A && (B != C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B != C) || D)'\'' '\''A && (B != C || D)'\'''

echo '$ test-expr '\''(a != (b >= c)) && d'\'''
test-expr '(a != (b >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= c)) && d'\'''

echo '$ diff-expr '\''(a != (b >= c)) && d'\'' '\''a != (b >= c) && d'\'''
diff-expr '(a != (b >= c)) && d' 'a != (b >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && d'\'' '\''a != (b >= c) && d'\'''

echo '$ diff-expr '\''(a != (b >= c)) && d'\'' '\''a != b >= c && d'\'''
diff-expr '(a != (b >= c)) && d' 'a != b >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && d'\'' '\''a != b >= c && d'\'''

echo '$ diff-expr '\''(a != (b >= c)) && d'\'' '\''(a != b >= c) && d'\'''
diff-expr '(a != (b >= c)) && d' '(a != b >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && d'\'' '\''(a != b >= c) && d'\'''

echo '$ test-expr '\''(a != (b >= c)) && D'\'''
test-expr '(a != (b >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= c)) && D'\'''

echo '$ diff-expr '\''(a != (b >= c)) && D'\'' '\''a != (b >= c) && D'\'''
diff-expr '(a != (b >= c)) && D' 'a != (b >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && D'\'' '\''a != (b >= c) && D'\'''

echo '$ diff-expr '\''(a != (b >= c)) && D'\'' '\''a != b >= c && D'\'''
diff-expr '(a != (b >= c)) && D' 'a != b >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && D'\'' '\''a != b >= c && D'\'''

echo '$ diff-expr '\''(a != (b >= c)) && D'\'' '\''(a != b >= c) && D'\'''
diff-expr '(a != (b >= c)) && D' '(a != b >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && D'\'' '\''(a != b >= c) && D'\'''

echo '$ test-expr '\''(a != (b >= C)) && d'\'''
test-expr '(a != (b >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= C)) && d'\'''

echo '$ diff-expr '\''(a != (b >= C)) && d'\'' '\''a != (b >= C) && d'\'''
diff-expr '(a != (b >= C)) && d' 'a != (b >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) && d'\'' '\''a != (b >= C) && d'\'''

echo '$ diff-expr '\''(a != (b >= C)) && d'\'' '\''a != b >= C && d'\'''
diff-expr '(a != (b >= C)) && d' 'a != b >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) && d'\'' '\''a != b >= C && d'\'''

echo '$ diff-expr '\''(a != (b >= C)) && d'\'' '\''(a != b >= C) && d'\'''
diff-expr '(a != (b >= C)) && d' '(a != b >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) && d'\'' '\''(a != b >= C) && d'\'''

echo '$ test-expr '\''(a != (b >= C)) && D'\'''
test-expr '(a != (b >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= C)) && D'\'''

echo '$ diff-expr '\''(a != (b >= C)) && D'\'' '\''a != (b >= C) && D'\'''
diff-expr '(a != (b >= C)) && D' 'a != (b >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) && D'\'' '\''a != (b >= C) && D'\'''

echo '$ diff-expr '\''(a != (b >= C)) && D'\'' '\''a != b >= C && D'\'''
diff-expr '(a != (b >= C)) && D' 'a != b >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) && D'\'' '\''a != b >= C && D'\'''

echo '$ diff-expr '\''(a != (b >= C)) && D'\'' '\''(a != b >= C) && D'\'''
diff-expr '(a != (b >= C)) && D' '(a != b >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) && D'\'' '\''(a != b >= C) && D'\'''

echo '$ test-expr '\''(a != (B >= c)) && d'\'''
test-expr '(a != (B >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= c)) && d'\'''

echo '$ diff-expr '\''(a != (B >= c)) && d'\'' '\''a != (B >= c) && d'\'''
diff-expr '(a != (B >= c)) && d' 'a != (B >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) && d'\'' '\''a != (B >= c) && d'\'''

echo '$ diff-expr '\''(a != (B >= c)) && d'\'' '\''a != B >= c && d'\'''
diff-expr '(a != (B >= c)) && d' 'a != B >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) && d'\'' '\''a != B >= c && d'\'''

echo '$ diff-expr '\''(a != (B >= c)) && d'\'' '\''(a != B >= c) && d'\'''
diff-expr '(a != (B >= c)) && d' '(a != B >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) && d'\'' '\''(a != B >= c) && d'\'''

echo '$ test-expr '\''(a != (B >= c)) && D'\'''
test-expr '(a != (B >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= c)) && D'\'''

echo '$ diff-expr '\''(a != (B >= c)) && D'\'' '\''a != (B >= c) && D'\'''
diff-expr '(a != (B >= c)) && D' 'a != (B >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) && D'\'' '\''a != (B >= c) && D'\'''

echo '$ diff-expr '\''(a != (B >= c)) && D'\'' '\''a != B >= c && D'\'''
diff-expr '(a != (B >= c)) && D' 'a != B >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) && D'\'' '\''a != B >= c && D'\'''

echo '$ diff-expr '\''(a != (B >= c)) && D'\'' '\''(a != B >= c) && D'\'''
diff-expr '(a != (B >= c)) && D' '(a != B >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) && D'\'' '\''(a != B >= c) && D'\'''

echo '$ test-expr '\''(a != (B >= C)) && d'\'''
test-expr '(a != (B >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= C)) && d'\'''

echo '$ diff-expr '\''(a != (B >= C)) && d'\'' '\''a != (B >= C) && d'\'''
diff-expr '(a != (B >= C)) && d' 'a != (B >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) && d'\'' '\''a != (B >= C) && d'\'''

echo '$ diff-expr '\''(a != (B >= C)) && d'\'' '\''a != B >= C && d'\'''
diff-expr '(a != (B >= C)) && d' 'a != B >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) && d'\'' '\''a != B >= C && d'\'''

echo '$ diff-expr '\''(a != (B >= C)) && d'\'' '\''(a != B >= C) && d'\'''
diff-expr '(a != (B >= C)) && d' '(a != B >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) && d'\'' '\''(a != B >= C) && d'\'''

echo '$ test-expr '\''(a != (B >= C)) && D'\'''
test-expr '(a != (B >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= C)) && D'\'''

echo '$ diff-expr '\''(a != (B >= C)) && D'\'' '\''a != (B >= C) && D'\'''
diff-expr '(a != (B >= C)) && D' 'a != (B >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) && D'\'' '\''a != (B >= C) && D'\'''

echo '$ diff-expr '\''(a != (B >= C)) && D'\'' '\''a != B >= C && D'\'''
diff-expr '(a != (B >= C)) && D' 'a != B >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) && D'\'' '\''a != B >= C && D'\'''

echo '$ diff-expr '\''(a != (B >= C)) && D'\'' '\''(a != B >= C) && D'\'''
diff-expr '(a != (B >= C)) && D' '(a != B >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) && D'\'' '\''(a != B >= C) && D'\'''

echo '$ test-expr '\''(A != (b >= c)) && d'\'''
test-expr '(A != (b >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= c)) && d'\'''

echo '$ diff-expr '\''(A != (b >= c)) && d'\'' '\''A != (b >= c) && d'\'''
diff-expr '(A != (b >= c)) && d' 'A != (b >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) && d'\'' '\''A != (b >= c) && d'\'''

echo '$ diff-expr '\''(A != (b >= c)) && d'\'' '\''A != b >= c && d'\'''
diff-expr '(A != (b >= c)) && d' 'A != b >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) && d'\'' '\''A != b >= c && d'\'''

echo '$ diff-expr '\''(A != (b >= c)) && d'\'' '\''(A != b >= c) && d'\'''
diff-expr '(A != (b >= c)) && d' '(A != b >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) && d'\'' '\''(A != b >= c) && d'\'''

echo '$ test-expr '\''(A != (b >= c)) && D'\'''
test-expr '(A != (b >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= c)) && D'\'''

echo '$ diff-expr '\''(A != (b >= c)) && D'\'' '\''A != (b >= c) && D'\'''
diff-expr '(A != (b >= c)) && D' 'A != (b >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) && D'\'' '\''A != (b >= c) && D'\'''

echo '$ diff-expr '\''(A != (b >= c)) && D'\'' '\''A != b >= c && D'\'''
diff-expr '(A != (b >= c)) && D' 'A != b >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) && D'\'' '\''A != b >= c && D'\'''

echo '$ diff-expr '\''(A != (b >= c)) && D'\'' '\''(A != b >= c) && D'\'''
diff-expr '(A != (b >= c)) && D' '(A != b >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) && D'\'' '\''(A != b >= c) && D'\'''

echo '$ test-expr '\''(A != (b >= C)) && d'\'''
test-expr '(A != (b >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= C)) && d'\'''

echo '$ diff-expr '\''(A != (b >= C)) && d'\'' '\''A != (b >= C) && d'\'''
diff-expr '(A != (b >= C)) && d' 'A != (b >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) && d'\'' '\''A != (b >= C) && d'\'''

echo '$ diff-expr '\''(A != (b >= C)) && d'\'' '\''A != b >= C && d'\'''
diff-expr '(A != (b >= C)) && d' 'A != b >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) && d'\'' '\''A != b >= C && d'\'''

echo '$ diff-expr '\''(A != (b >= C)) && d'\'' '\''(A != b >= C) && d'\'''
diff-expr '(A != (b >= C)) && d' '(A != b >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) && d'\'' '\''(A != b >= C) && d'\'''

echo '$ test-expr '\''(A != (b >= C)) && D'\'''
test-expr '(A != (b >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= C)) && D'\'''

echo '$ diff-expr '\''(A != (b >= C)) && D'\'' '\''A != (b >= C) && D'\'''
diff-expr '(A != (b >= C)) && D' 'A != (b >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) && D'\'' '\''A != (b >= C) && D'\'''

echo '$ diff-expr '\''(A != (b >= C)) && D'\'' '\''A != b >= C && D'\'''
diff-expr '(A != (b >= C)) && D' 'A != b >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) && D'\'' '\''A != b >= C && D'\'''

echo '$ diff-expr '\''(A != (b >= C)) && D'\'' '\''(A != b >= C) && D'\'''
diff-expr '(A != (b >= C)) && D' '(A != b >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) && D'\'' '\''(A != b >= C) && D'\'''

echo '$ test-expr '\''(A != (B >= c)) && d'\'''
test-expr '(A != (B >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= c)) && d'\'''

echo '$ diff-expr '\''(A != (B >= c)) && d'\'' '\''A != (B >= c) && d'\'''
diff-expr '(A != (B >= c)) && d' 'A != (B >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) && d'\'' '\''A != (B >= c) && d'\'''

echo '$ diff-expr '\''(A != (B >= c)) && d'\'' '\''A != B >= c && d'\'''
diff-expr '(A != (B >= c)) && d' 'A != B >= c && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) && d'\'' '\''A != B >= c && d'\'''

echo '$ diff-expr '\''(A != (B >= c)) && d'\'' '\''(A != B >= c) && d'\'''
diff-expr '(A != (B >= c)) && d' '(A != B >= c) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) && d'\'' '\''(A != B >= c) && d'\'''

echo '$ test-expr '\''(A != (B >= c)) && D'\'''
test-expr '(A != (B >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= c)) && D'\'''

echo '$ diff-expr '\''(A != (B >= c)) && D'\'' '\''A != (B >= c) && D'\'''
diff-expr '(A != (B >= c)) && D' 'A != (B >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) && D'\'' '\''A != (B >= c) && D'\'''

echo '$ diff-expr '\''(A != (B >= c)) && D'\'' '\''A != B >= c && D'\'''
diff-expr '(A != (B >= c)) && D' 'A != B >= c && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) && D'\'' '\''A != B >= c && D'\'''

echo '$ diff-expr '\''(A != (B >= c)) && D'\'' '\''(A != B >= c) && D'\'''
diff-expr '(A != (B >= c)) && D' '(A != B >= c) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) && D'\'' '\''(A != B >= c) && D'\'''

echo '$ test-expr '\''(A != (B >= C)) && d'\'''
test-expr '(A != (B >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= C)) && d'\'''

echo '$ diff-expr '\''(A != (B >= C)) && d'\'' '\''A != (B >= C) && d'\'''
diff-expr '(A != (B >= C)) && d' 'A != (B >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) && d'\'' '\''A != (B >= C) && d'\'''

echo '$ diff-expr '\''(A != (B >= C)) && d'\'' '\''A != B >= C && d'\'''
diff-expr '(A != (B >= C)) && d' 'A != B >= C && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) && d'\'' '\''A != B >= C && d'\'''

echo '$ diff-expr '\''(A != (B >= C)) && d'\'' '\''(A != B >= C) && d'\'''
diff-expr '(A != (B >= C)) && d' '(A != B >= C) && d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) && d'\'' '\''(A != B >= C) && d'\'''

echo '$ test-expr '\''(A != (B >= C)) && D'\'''
test-expr '(A != (B >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= C)) && D'\'''

echo '$ diff-expr '\''(A != (B >= C)) && D'\'' '\''A != (B >= C) && D'\'''
diff-expr '(A != (B >= C)) && D' 'A != (B >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) && D'\'' '\''A != (B >= C) && D'\'''

echo '$ diff-expr '\''(A != (B >= C)) && D'\'' '\''A != B >= C && D'\'''
diff-expr '(A != (B >= C)) && D' 'A != B >= C && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) && D'\'' '\''A != B >= C && D'\'''

echo '$ diff-expr '\''(A != (B >= C)) && D'\'' '\''(A != B >= C) && D'\'''
diff-expr '(A != (B >= C)) && D' '(A != B >= C) && D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) && D'\'' '\''(A != B >= C) && D'\'''

echo '$ test-expr '\''(a != (b >= c)) || d'\'''
test-expr '(a != (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= c)) || d'\'''

echo '$ diff-expr '\''(a != (b >= c)) || d'\'' '\''a != (b >= c) || d'\'''
diff-expr '(a != (b >= c)) || d' 'a != (b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || d'\'' '\''a != (b >= c) || d'\'''

echo '$ diff-expr '\''(a != (b >= c)) || d'\'' '\''a != b >= c || d'\'''
diff-expr '(a != (b >= c)) || d' 'a != b >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || d'\'' '\''a != b >= c || d'\'''

echo '$ diff-expr '\''(a != (b >= c)) || d'\'' '\''(a != b >= c) || d'\'''
diff-expr '(a != (b >= c)) || d' '(a != b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || d'\'' '\''(a != b >= c) || d'\'''

echo '$ test-expr '\''(a != (b >= c)) || D'\'''
test-expr '(a != (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= c)) || D'\'''

echo '$ diff-expr '\''(a != (b >= c)) || D'\'' '\''a != (b >= c) || D'\'''
diff-expr '(a != (b >= c)) || D' 'a != (b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || D'\'' '\''a != (b >= c) || D'\'''

echo '$ diff-expr '\''(a != (b >= c)) || D'\'' '\''a != b >= c || D'\'''
diff-expr '(a != (b >= c)) || D' 'a != b >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || D'\'' '\''a != b >= c || D'\'''

echo '$ diff-expr '\''(a != (b >= c)) || D'\'' '\''(a != b >= c) || D'\'''
diff-expr '(a != (b >= c)) || D' '(a != b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || D'\'' '\''(a != b >= c) || D'\'''

echo '$ test-expr '\''(a != (b >= C)) || d'\'''
test-expr '(a != (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= C)) || d'\'''

echo '$ diff-expr '\''(a != (b >= C)) || d'\'' '\''a != (b >= C) || d'\'''
diff-expr '(a != (b >= C)) || d' 'a != (b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) || d'\'' '\''a != (b >= C) || d'\'''

echo '$ diff-expr '\''(a != (b >= C)) || d'\'' '\''a != b >= C || d'\'''
diff-expr '(a != (b >= C)) || d' 'a != b >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) || d'\'' '\''a != b >= C || d'\'''

echo '$ diff-expr '\''(a != (b >= C)) || d'\'' '\''(a != b >= C) || d'\'''
diff-expr '(a != (b >= C)) || d' '(a != b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) || d'\'' '\''(a != b >= C) || d'\'''

echo '$ test-expr '\''(a != (b >= C)) || D'\'''
test-expr '(a != (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= C)) || D'\'''

echo '$ diff-expr '\''(a != (b >= C)) || D'\'' '\''a != (b >= C) || D'\'''
diff-expr '(a != (b >= C)) || D' 'a != (b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) || D'\'' '\''a != (b >= C) || D'\'''

echo '$ diff-expr '\''(a != (b >= C)) || D'\'' '\''a != b >= C || D'\'''
diff-expr '(a != (b >= C)) || D' 'a != b >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) || D'\'' '\''a != b >= C || D'\'''

echo '$ diff-expr '\''(a != (b >= C)) || D'\'' '\''(a != b >= C) || D'\'''
diff-expr '(a != (b >= C)) || D' '(a != b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= C)) || D'\'' '\''(a != b >= C) || D'\'''

echo '$ test-expr '\''(a != (B >= c)) || d'\'''
test-expr '(a != (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= c)) || d'\'''

echo '$ diff-expr '\''(a != (B >= c)) || d'\'' '\''a != (B >= c) || d'\'''
diff-expr '(a != (B >= c)) || d' 'a != (B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) || d'\'' '\''a != (B >= c) || d'\'''

echo '$ diff-expr '\''(a != (B >= c)) || d'\'' '\''a != B >= c || d'\'''
diff-expr '(a != (B >= c)) || d' 'a != B >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) || d'\'' '\''a != B >= c || d'\'''

echo '$ diff-expr '\''(a != (B >= c)) || d'\'' '\''(a != B >= c) || d'\'''
diff-expr '(a != (B >= c)) || d' '(a != B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) || d'\'' '\''(a != B >= c) || d'\'''

echo '$ test-expr '\''(a != (B >= c)) || D'\'''
test-expr '(a != (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= c)) || D'\'''

echo '$ diff-expr '\''(a != (B >= c)) || D'\'' '\''a != (B >= c) || D'\'''
diff-expr '(a != (B >= c)) || D' 'a != (B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) || D'\'' '\''a != (B >= c) || D'\'''

echo '$ diff-expr '\''(a != (B >= c)) || D'\'' '\''a != B >= c || D'\'''
diff-expr '(a != (B >= c)) || D' 'a != B >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) || D'\'' '\''a != B >= c || D'\'''

echo '$ diff-expr '\''(a != (B >= c)) || D'\'' '\''(a != B >= c) || D'\'''
diff-expr '(a != (B >= c)) || D' '(a != B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= c)) || D'\'' '\''(a != B >= c) || D'\'''

echo '$ test-expr '\''(a != (B >= C)) || d'\'''
test-expr '(a != (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= C)) || d'\'''

echo '$ diff-expr '\''(a != (B >= C)) || d'\'' '\''a != (B >= C) || d'\'''
diff-expr '(a != (B >= C)) || d' 'a != (B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) || d'\'' '\''a != (B >= C) || d'\'''

echo '$ diff-expr '\''(a != (B >= C)) || d'\'' '\''a != B >= C || d'\'''
diff-expr '(a != (B >= C)) || d' 'a != B >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) || d'\'' '\''a != B >= C || d'\'''

echo '$ diff-expr '\''(a != (B >= C)) || d'\'' '\''(a != B >= C) || d'\'''
diff-expr '(a != (B >= C)) || d' '(a != B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) || d'\'' '\''(a != B >= C) || d'\'''

echo '$ test-expr '\''(a != (B >= C)) || D'\'''
test-expr '(a != (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B >= C)) || D'\'''

echo '$ diff-expr '\''(a != (B >= C)) || D'\'' '\''a != (B >= C) || D'\'''
diff-expr '(a != (B >= C)) || D' 'a != (B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) || D'\'' '\''a != (B >= C) || D'\'''

echo '$ diff-expr '\''(a != (B >= C)) || D'\'' '\''a != B >= C || D'\'''
diff-expr '(a != (B >= C)) || D' 'a != B >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) || D'\'' '\''a != B >= C || D'\'''

echo '$ diff-expr '\''(a != (B >= C)) || D'\'' '\''(a != B >= C) || D'\'''
diff-expr '(a != (B >= C)) || D' '(a != B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (B >= C)) || D'\'' '\''(a != B >= C) || D'\'''

echo '$ test-expr '\''(A != (b >= c)) || d'\'''
test-expr '(A != (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= c)) || d'\'''

echo '$ diff-expr '\''(A != (b >= c)) || d'\'' '\''A != (b >= c) || d'\'''
diff-expr '(A != (b >= c)) || d' 'A != (b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) || d'\'' '\''A != (b >= c) || d'\'''

echo '$ diff-expr '\''(A != (b >= c)) || d'\'' '\''A != b >= c || d'\'''
diff-expr '(A != (b >= c)) || d' 'A != b >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) || d'\'' '\''A != b >= c || d'\'''

echo '$ diff-expr '\''(A != (b >= c)) || d'\'' '\''(A != b >= c) || d'\'''
diff-expr '(A != (b >= c)) || d' '(A != b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) || d'\'' '\''(A != b >= c) || d'\'''

echo '$ test-expr '\''(A != (b >= c)) || D'\'''
test-expr '(A != (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= c)) || D'\'''

echo '$ diff-expr '\''(A != (b >= c)) || D'\'' '\''A != (b >= c) || D'\'''
diff-expr '(A != (b >= c)) || D' 'A != (b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) || D'\'' '\''A != (b >= c) || D'\'''

echo '$ diff-expr '\''(A != (b >= c)) || D'\'' '\''A != b >= c || D'\'''
diff-expr '(A != (b >= c)) || D' 'A != b >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) || D'\'' '\''A != b >= c || D'\'''

echo '$ diff-expr '\''(A != (b >= c)) || D'\'' '\''(A != b >= c) || D'\'''
diff-expr '(A != (b >= c)) || D' '(A != b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= c)) || D'\'' '\''(A != b >= c) || D'\'''

echo '$ test-expr '\''(A != (b >= C)) || d'\'''
test-expr '(A != (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= C)) || d'\'''

echo '$ diff-expr '\''(A != (b >= C)) || d'\'' '\''A != (b >= C) || d'\'''
diff-expr '(A != (b >= C)) || d' 'A != (b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) || d'\'' '\''A != (b >= C) || d'\'''

echo '$ diff-expr '\''(A != (b >= C)) || d'\'' '\''A != b >= C || d'\'''
diff-expr '(A != (b >= C)) || d' 'A != b >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) || d'\'' '\''A != b >= C || d'\'''

echo '$ diff-expr '\''(A != (b >= C)) || d'\'' '\''(A != b >= C) || d'\'''
diff-expr '(A != (b >= C)) || d' '(A != b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) || d'\'' '\''(A != b >= C) || d'\'''

echo '$ test-expr '\''(A != (b >= C)) || D'\'''
test-expr '(A != (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b >= C)) || D'\'''

echo '$ diff-expr '\''(A != (b >= C)) || D'\'' '\''A != (b >= C) || D'\'''
diff-expr '(A != (b >= C)) || D' 'A != (b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) || D'\'' '\''A != (b >= C) || D'\'''

echo '$ diff-expr '\''(A != (b >= C)) || D'\'' '\''A != b >= C || D'\'''
diff-expr '(A != (b >= C)) || D' 'A != b >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) || D'\'' '\''A != b >= C || D'\'''

echo '$ diff-expr '\''(A != (b >= C)) || D'\'' '\''(A != b >= C) || D'\'''
diff-expr '(A != (b >= C)) || D' '(A != b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (b >= C)) || D'\'' '\''(A != b >= C) || D'\'''

echo '$ test-expr '\''(A != (B >= c)) || d'\'''
test-expr '(A != (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= c)) || d'\'''

echo '$ diff-expr '\''(A != (B >= c)) || d'\'' '\''A != (B >= c) || d'\'''
diff-expr '(A != (B >= c)) || d' 'A != (B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) || d'\'' '\''A != (B >= c) || d'\'''

echo '$ diff-expr '\''(A != (B >= c)) || d'\'' '\''A != B >= c || d'\'''
diff-expr '(A != (B >= c)) || d' 'A != B >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) || d'\'' '\''A != B >= c || d'\'''

echo '$ diff-expr '\''(A != (B >= c)) || d'\'' '\''(A != B >= c) || d'\'''
diff-expr '(A != (B >= c)) || d' '(A != B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) || d'\'' '\''(A != B >= c) || d'\'''

echo '$ test-expr '\''(A != (B >= c)) || D'\'''
test-expr '(A != (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= c)) || D'\'''

echo '$ diff-expr '\''(A != (B >= c)) || D'\'' '\''A != (B >= c) || D'\'''
diff-expr '(A != (B >= c)) || D' 'A != (B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) || D'\'' '\''A != (B >= c) || D'\'''

echo '$ diff-expr '\''(A != (B >= c)) || D'\'' '\''A != B >= c || D'\'''
diff-expr '(A != (B >= c)) || D' 'A != B >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) || D'\'' '\''A != B >= c || D'\'''

echo '$ diff-expr '\''(A != (B >= c)) || D'\'' '\''(A != B >= c) || D'\'''
diff-expr '(A != (B >= c)) || D' '(A != B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= c)) || D'\'' '\''(A != B >= c) || D'\'''

echo '$ test-expr '\''(A != (B >= C)) || d'\'''
test-expr '(A != (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= C)) || d'\'''

echo '$ diff-expr '\''(A != (B >= C)) || d'\'' '\''A != (B >= C) || d'\'''
diff-expr '(A != (B >= C)) || d' 'A != (B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) || d'\'' '\''A != (B >= C) || d'\'''

echo '$ diff-expr '\''(A != (B >= C)) || d'\'' '\''A != B >= C || d'\'''
diff-expr '(A != (B >= C)) || d' 'A != B >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) || d'\'' '\''A != B >= C || d'\'''

echo '$ diff-expr '\''(A != (B >= C)) || d'\'' '\''(A != B >= C) || d'\'''
diff-expr '(A != (B >= C)) || d' '(A != B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) || d'\'' '\''(A != B >= C) || d'\'''

echo '$ test-expr '\''(A != (B >= C)) || D'\'''
test-expr '(A != (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B >= C)) || D'\'''

echo '$ diff-expr '\''(A != (B >= C)) || D'\'' '\''A != (B >= C) || D'\'''
diff-expr '(A != (B >= C)) || D' 'A != (B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) || D'\'' '\''A != (B >= C) || D'\'''

echo '$ diff-expr '\''(A != (B >= C)) || D'\'' '\''A != B >= C || D'\'''
diff-expr '(A != (B >= C)) || D' 'A != B >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) || D'\'' '\''A != B >= C || D'\'''

echo '$ diff-expr '\''(A != (B >= C)) || D'\'' '\''(A != B >= C) || D'\'''
diff-expr '(A != (B >= C)) || D' '(A != B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != (B >= C)) || D'\'' '\''(A != B >= C) || D'\'''

echo '$ test-expr '\''(a && (b >= c)) || d'\'''
test-expr '(a && (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= c)) || d'\'''

echo '$ diff-expr '\''(a && (b >= c)) || d'\'' '\''a && (b >= c) || d'\'''
diff-expr '(a && (b >= c)) || d' 'a && (b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || d'\'' '\''a && (b >= c) || d'\'''

echo '$ diff-expr '\''(a && (b >= c)) || d'\'' '\''a && b >= c || d'\'''
diff-expr '(a && (b >= c)) || d' 'a && b >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || d'\'' '\''a && b >= c || d'\'''

echo '$ diff-expr '\''(a && (b >= c)) || d'\'' '\''(a && b >= c) || d'\'''
diff-expr '(a && (b >= c)) || d' '(a && b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || d'\'' '\''(a && b >= c) || d'\'''

echo '$ test-expr '\''(a && (b >= c)) || D'\'''
test-expr '(a && (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= c)) || D'\'''

echo '$ diff-expr '\''(a && (b >= c)) || D'\'' '\''a && (b >= c) || D'\'''
diff-expr '(a && (b >= c)) || D' 'a && (b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || D'\'' '\''a && (b >= c) || D'\'''

echo '$ diff-expr '\''(a && (b >= c)) || D'\'' '\''a && b >= c || D'\'''
diff-expr '(a && (b >= c)) || D' 'a && b >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || D'\'' '\''a && b >= c || D'\'''

echo '$ diff-expr '\''(a && (b >= c)) || D'\'' '\''(a && b >= c) || D'\'''
diff-expr '(a && (b >= c)) || D' '(a && b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || D'\'' '\''(a && b >= c) || D'\'''

echo '$ test-expr '\''(a && (b >= C)) || d'\'''
test-expr '(a && (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= C)) || d'\'''

echo '$ diff-expr '\''(a && (b >= C)) || d'\'' '\''a && (b >= C) || d'\'''
diff-expr '(a && (b >= C)) || d' 'a && (b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= C)) || d'\'' '\''a && (b >= C) || d'\'''

echo '$ diff-expr '\''(a && (b >= C)) || d'\'' '\''a && b >= C || d'\'''
diff-expr '(a && (b >= C)) || d' 'a && b >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= C)) || d'\'' '\''a && b >= C || d'\'''

echo '$ diff-expr '\''(a && (b >= C)) || d'\'' '\''(a && b >= C) || d'\'''
diff-expr '(a && (b >= C)) || d' '(a && b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= C)) || d'\'' '\''(a && b >= C) || d'\'''

echo '$ test-expr '\''(a && (b >= C)) || D'\'''
test-expr '(a && (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= C)) || D'\'''

echo '$ diff-expr '\''(a && (b >= C)) || D'\'' '\''a && (b >= C) || D'\'''
diff-expr '(a && (b >= C)) || D' 'a && (b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= C)) || D'\'' '\''a && (b >= C) || D'\'''

echo '$ diff-expr '\''(a && (b >= C)) || D'\'' '\''a && b >= C || D'\'''
diff-expr '(a && (b >= C)) || D' 'a && b >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= C)) || D'\'' '\''a && b >= C || D'\'''

echo '$ diff-expr '\''(a && (b >= C)) || D'\'' '\''(a && b >= C) || D'\'''
diff-expr '(a && (b >= C)) || D' '(a && b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= C)) || D'\'' '\''(a && b >= C) || D'\'''

echo '$ test-expr '\''(a && (B >= c)) || d'\'''
test-expr '(a && (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B >= c)) || d'\'''

echo '$ diff-expr '\''(a && (B >= c)) || d'\'' '\''a && (B >= c) || d'\'''
diff-expr '(a && (B >= c)) || d' 'a && (B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= c)) || d'\'' '\''a && (B >= c) || d'\'''

echo '$ diff-expr '\''(a && (B >= c)) || d'\'' '\''a && B >= c || d'\'''
diff-expr '(a && (B >= c)) || d' 'a && B >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= c)) || d'\'' '\''a && B >= c || d'\'''

echo '$ diff-expr '\''(a && (B >= c)) || d'\'' '\''(a && B >= c) || d'\'''
diff-expr '(a && (B >= c)) || d' '(a && B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= c)) || d'\'' '\''(a && B >= c) || d'\'''

echo '$ test-expr '\''(a && (B >= c)) || D'\'''
test-expr '(a && (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B >= c)) || D'\'''

echo '$ diff-expr '\''(a && (B >= c)) || D'\'' '\''a && (B >= c) || D'\'''
diff-expr '(a && (B >= c)) || D' 'a && (B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= c)) || D'\'' '\''a && (B >= c) || D'\'''

echo '$ diff-expr '\''(a && (B >= c)) || D'\'' '\''a && B >= c || D'\'''
diff-expr '(a && (B >= c)) || D' 'a && B >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= c)) || D'\'' '\''a && B >= c || D'\'''

echo '$ diff-expr '\''(a && (B >= c)) || D'\'' '\''(a && B >= c) || D'\'''
diff-expr '(a && (B >= c)) || D' '(a && B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= c)) || D'\'' '\''(a && B >= c) || D'\'''

echo '$ test-expr '\''(a && (B >= C)) || d'\'''
test-expr '(a && (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B >= C)) || d'\'''

echo '$ diff-expr '\''(a && (B >= C)) || d'\'' '\''a && (B >= C) || d'\'''
diff-expr '(a && (B >= C)) || d' 'a && (B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= C)) || d'\'' '\''a && (B >= C) || d'\'''

echo '$ diff-expr '\''(a && (B >= C)) || d'\'' '\''a && B >= C || d'\'''
diff-expr '(a && (B >= C)) || d' 'a && B >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= C)) || d'\'' '\''a && B >= C || d'\'''

echo '$ diff-expr '\''(a && (B >= C)) || d'\'' '\''(a && B >= C) || d'\'''
diff-expr '(a && (B >= C)) || d' '(a && B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= C)) || d'\'' '\''(a && B >= C) || d'\'''

echo '$ test-expr '\''(a && (B >= C)) || D'\'''
test-expr '(a && (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B >= C)) || D'\'''

echo '$ diff-expr '\''(a && (B >= C)) || D'\'' '\''a && (B >= C) || D'\'''
diff-expr '(a && (B >= C)) || D' 'a && (B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= C)) || D'\'' '\''a && (B >= C) || D'\'''

echo '$ diff-expr '\''(a && (B >= C)) || D'\'' '\''a && B >= C || D'\'''
diff-expr '(a && (B >= C)) || D' 'a && B >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= C)) || D'\'' '\''a && B >= C || D'\'''

echo '$ diff-expr '\''(a && (B >= C)) || D'\'' '\''(a && B >= C) || D'\'''
diff-expr '(a && (B >= C)) || D' '(a && B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B >= C)) || D'\'' '\''(a && B >= C) || D'\'''

echo '$ test-expr '\''(A && (b >= c)) || d'\'''
test-expr '(A && (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b >= c)) || d'\'''

echo '$ diff-expr '\''(A && (b >= c)) || d'\'' '\''A && (b >= c) || d'\'''
diff-expr '(A && (b >= c)) || d' 'A && (b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= c)) || d'\'' '\''A && (b >= c) || d'\'''

echo '$ diff-expr '\''(A && (b >= c)) || d'\'' '\''A && b >= c || d'\'''
diff-expr '(A && (b >= c)) || d' 'A && b >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= c)) || d'\'' '\''A && b >= c || d'\'''

echo '$ diff-expr '\''(A && (b >= c)) || d'\'' '\''(A && b >= c) || d'\'''
diff-expr '(A && (b >= c)) || d' '(A && b >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= c)) || d'\'' '\''(A && b >= c) || d'\'''

echo '$ test-expr '\''(A && (b >= c)) || D'\'''
test-expr '(A && (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b >= c)) || D'\'''

echo '$ diff-expr '\''(A && (b >= c)) || D'\'' '\''A && (b >= c) || D'\'''
diff-expr '(A && (b >= c)) || D' 'A && (b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= c)) || D'\'' '\''A && (b >= c) || D'\'''

echo '$ diff-expr '\''(A && (b >= c)) || D'\'' '\''A && b >= c || D'\'''
diff-expr '(A && (b >= c)) || D' 'A && b >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= c)) || D'\'' '\''A && b >= c || D'\'''

echo '$ diff-expr '\''(A && (b >= c)) || D'\'' '\''(A && b >= c) || D'\'''
diff-expr '(A && (b >= c)) || D' '(A && b >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= c)) || D'\'' '\''(A && b >= c) || D'\'''

echo '$ test-expr '\''(A && (b >= C)) || d'\'''
test-expr '(A && (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b >= C)) || d'\'''

echo '$ diff-expr '\''(A && (b >= C)) || d'\'' '\''A && (b >= C) || d'\'''
diff-expr '(A && (b >= C)) || d' 'A && (b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= C)) || d'\'' '\''A && (b >= C) || d'\'''

echo '$ diff-expr '\''(A && (b >= C)) || d'\'' '\''A && b >= C || d'\'''
diff-expr '(A && (b >= C)) || d' 'A && b >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= C)) || d'\'' '\''A && b >= C || d'\'''

echo '$ diff-expr '\''(A && (b >= C)) || d'\'' '\''(A && b >= C) || d'\'''
diff-expr '(A && (b >= C)) || d' '(A && b >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= C)) || d'\'' '\''(A && b >= C) || d'\'''

echo '$ test-expr '\''(A && (b >= C)) || D'\'''
test-expr '(A && (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b >= C)) || D'\'''

echo '$ diff-expr '\''(A && (b >= C)) || D'\'' '\''A && (b >= C) || D'\'''
diff-expr '(A && (b >= C)) || D' 'A && (b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= C)) || D'\'' '\''A && (b >= C) || D'\'''

echo '$ diff-expr '\''(A && (b >= C)) || D'\'' '\''A && b >= C || D'\'''
diff-expr '(A && (b >= C)) || D' 'A && b >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= C)) || D'\'' '\''A && b >= C || D'\'''

echo '$ diff-expr '\''(A && (b >= C)) || D'\'' '\''(A && b >= C) || D'\'''
diff-expr '(A && (b >= C)) || D' '(A && b >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b >= C)) || D'\'' '\''(A && b >= C) || D'\'''

echo '$ test-expr '\''(A && (B >= c)) || d'\'''
test-expr '(A && (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B >= c)) || d'\'''

echo '$ diff-expr '\''(A && (B >= c)) || d'\'' '\''A && (B >= c) || d'\'''
diff-expr '(A && (B >= c)) || d' 'A && (B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= c)) || d'\'' '\''A && (B >= c) || d'\'''

echo '$ diff-expr '\''(A && (B >= c)) || d'\'' '\''A && B >= c || d'\'''
diff-expr '(A && (B >= c)) || d' 'A && B >= c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= c)) || d'\'' '\''A && B >= c || d'\'''

echo '$ diff-expr '\''(A && (B >= c)) || d'\'' '\''(A && B >= c) || d'\'''
diff-expr '(A && (B >= c)) || d' '(A && B >= c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= c)) || d'\'' '\''(A && B >= c) || d'\'''

echo '$ test-expr '\''(A && (B >= c)) || D'\'''
test-expr '(A && (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B >= c)) || D'\'''

echo '$ diff-expr '\''(A && (B >= c)) || D'\'' '\''A && (B >= c) || D'\'''
diff-expr '(A && (B >= c)) || D' 'A && (B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= c)) || D'\'' '\''A && (B >= c) || D'\'''

echo '$ diff-expr '\''(A && (B >= c)) || D'\'' '\''A && B >= c || D'\'''
diff-expr '(A && (B >= c)) || D' 'A && B >= c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= c)) || D'\'' '\''A && B >= c || D'\'''

echo '$ diff-expr '\''(A && (B >= c)) || D'\'' '\''(A && B >= c) || D'\'''
diff-expr '(A && (B >= c)) || D' '(A && B >= c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= c)) || D'\'' '\''(A && B >= c) || D'\'''

echo '$ test-expr '\''(A && (B >= C)) || d'\'''
test-expr '(A && (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B >= C)) || d'\'''

echo '$ diff-expr '\''(A && (B >= C)) || d'\'' '\''A && (B >= C) || d'\'''
diff-expr '(A && (B >= C)) || d' 'A && (B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= C)) || d'\'' '\''A && (B >= C) || d'\'''

echo '$ diff-expr '\''(A && (B >= C)) || d'\'' '\''A && B >= C || d'\'''
diff-expr '(A && (B >= C)) || d' 'A && B >= C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= C)) || d'\'' '\''A && B >= C || d'\'''

echo '$ diff-expr '\''(A && (B >= C)) || d'\'' '\''(A && B >= C) || d'\'''
diff-expr '(A && (B >= C)) || d' '(A && B >= C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= C)) || d'\'' '\''(A && B >= C) || d'\'''

echo '$ test-expr '\''(A && (B >= C)) || D'\'''
test-expr '(A && (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B >= C)) || D'\'''

echo '$ diff-expr '\''(A && (B >= C)) || D'\'' '\''A && (B >= C) || D'\'''
diff-expr '(A && (B >= C)) || D' 'A && (B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= C)) || D'\'' '\''A && (B >= C) || D'\'''

echo '$ diff-expr '\''(A && (B >= C)) || D'\'' '\''A && B >= C || D'\'''
diff-expr '(A && (B >= C)) || D' 'A && B >= C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= C)) || D'\'' '\''A && B >= C || D'\'''

echo '$ diff-expr '\''(A && (B >= C)) || D'\'' '\''(A && B >= C) || D'\'''
diff-expr '(A && (B >= C)) || D' '(A && B >= C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B >= C)) || D'\'' '\''(A && B >= C) || D'\'''

echo '$ test-expr '\''(a && (b != c)) || d'\'''
test-expr '(a && (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != c)) || d'\'''

echo '$ diff-expr '\''(a && (b != c)) || d'\'' '\''a && (b != c) || d'\'''
diff-expr '(a && (b != c)) || d' 'a && (b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || d'\'' '\''a && (b != c) || d'\'''

echo '$ diff-expr '\''(a && (b != c)) || d'\'' '\''a && b != c || d'\'''
diff-expr '(a && (b != c)) || d' 'a && b != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || d'\'' '\''a && b != c || d'\'''

echo '$ diff-expr '\''(a && (b != c)) || d'\'' '\''(a && b != c) || d'\'''
diff-expr '(a && (b != c)) || d' '(a && b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || d'\'' '\''(a && b != c) || d'\'''

echo '$ test-expr '\''(a && (b != c)) || D'\'''
test-expr '(a && (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != c)) || D'\'''

echo '$ diff-expr '\''(a && (b != c)) || D'\'' '\''a && (b != c) || D'\'''
diff-expr '(a && (b != c)) || D' 'a && (b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || D'\'' '\''a && (b != c) || D'\'''

echo '$ diff-expr '\''(a && (b != c)) || D'\'' '\''a && b != c || D'\'''
diff-expr '(a && (b != c)) || D' 'a && b != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || D'\'' '\''a && b != c || D'\'''

echo '$ diff-expr '\''(a && (b != c)) || D'\'' '\''(a && b != c) || D'\'''
diff-expr '(a && (b != c)) || D' '(a && b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || D'\'' '\''(a && b != c) || D'\'''

echo '$ test-expr '\''(a && (b != C)) || d'\'''
test-expr '(a && (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != C)) || d'\'''

echo '$ diff-expr '\''(a && (b != C)) || d'\'' '\''a && (b != C) || d'\'''
diff-expr '(a && (b != C)) || d' 'a && (b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != C)) || d'\'' '\''a && (b != C) || d'\'''

echo '$ diff-expr '\''(a && (b != C)) || d'\'' '\''a && b != C || d'\'''
diff-expr '(a && (b != C)) || d' 'a && b != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != C)) || d'\'' '\''a && b != C || d'\'''

echo '$ diff-expr '\''(a && (b != C)) || d'\'' '\''(a && b != C) || d'\'''
diff-expr '(a && (b != C)) || d' '(a && b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != C)) || d'\'' '\''(a && b != C) || d'\'''

echo '$ test-expr '\''(a && (b != C)) || D'\'''
test-expr '(a && (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != C)) || D'\'''

echo '$ diff-expr '\''(a && (b != C)) || D'\'' '\''a && (b != C) || D'\'''
diff-expr '(a && (b != C)) || D' 'a && (b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != C)) || D'\'' '\''a && (b != C) || D'\'''

echo '$ diff-expr '\''(a && (b != C)) || D'\'' '\''a && b != C || D'\'''
diff-expr '(a && (b != C)) || D' 'a && b != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != C)) || D'\'' '\''a && b != C || D'\'''

echo '$ diff-expr '\''(a && (b != C)) || D'\'' '\''(a && b != C) || D'\'''
diff-expr '(a && (b != C)) || D' '(a && b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != C)) || D'\'' '\''(a && b != C) || D'\'''

echo '$ test-expr '\''(a && (B != c)) || d'\'''
test-expr '(a && (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B != c)) || d'\'''

echo '$ diff-expr '\''(a && (B != c)) || d'\'' '\''a && (B != c) || d'\'''
diff-expr '(a && (B != c)) || d' 'a && (B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != c)) || d'\'' '\''a && (B != c) || d'\'''

echo '$ diff-expr '\''(a && (B != c)) || d'\'' '\''a && B != c || d'\'''
diff-expr '(a && (B != c)) || d' 'a && B != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != c)) || d'\'' '\''a && B != c || d'\'''

echo '$ diff-expr '\''(a && (B != c)) || d'\'' '\''(a && B != c) || d'\'''
diff-expr '(a && (B != c)) || d' '(a && B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != c)) || d'\'' '\''(a && B != c) || d'\'''

echo '$ test-expr '\''(a && (B != c)) || D'\'''
test-expr '(a && (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B != c)) || D'\'''

echo '$ diff-expr '\''(a && (B != c)) || D'\'' '\''a && (B != c) || D'\'''
diff-expr '(a && (B != c)) || D' 'a && (B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != c)) || D'\'' '\''a && (B != c) || D'\'''

echo '$ diff-expr '\''(a && (B != c)) || D'\'' '\''a && B != c || D'\'''
diff-expr '(a && (B != c)) || D' 'a && B != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != c)) || D'\'' '\''a && B != c || D'\'''

echo '$ diff-expr '\''(a && (B != c)) || D'\'' '\''(a && B != c) || D'\'''
diff-expr '(a && (B != c)) || D' '(a && B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != c)) || D'\'' '\''(a && B != c) || D'\'''

echo '$ test-expr '\''(a && (B != C)) || d'\'''
test-expr '(a && (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B != C)) || d'\'''

echo '$ diff-expr '\''(a && (B != C)) || d'\'' '\''a && (B != C) || d'\'''
diff-expr '(a && (B != C)) || d' 'a && (B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != C)) || d'\'' '\''a && (B != C) || d'\'''

echo '$ diff-expr '\''(a && (B != C)) || d'\'' '\''a && B != C || d'\'''
diff-expr '(a && (B != C)) || d' 'a && B != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != C)) || d'\'' '\''a && B != C || d'\'''

echo '$ diff-expr '\''(a && (B != C)) || d'\'' '\''(a && B != C) || d'\'''
diff-expr '(a && (B != C)) || d' '(a && B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != C)) || d'\'' '\''(a && B != C) || d'\'''

echo '$ test-expr '\''(a && (B != C)) || D'\'''
test-expr '(a && (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B != C)) || D'\'''

echo '$ diff-expr '\''(a && (B != C)) || D'\'' '\''a && (B != C) || D'\'''
diff-expr '(a && (B != C)) || D' 'a && (B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != C)) || D'\'' '\''a && (B != C) || D'\'''

echo '$ diff-expr '\''(a && (B != C)) || D'\'' '\''a && B != C || D'\'''
diff-expr '(a && (B != C)) || D' 'a && B != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != C)) || D'\'' '\''a && B != C || D'\'''

echo '$ diff-expr '\''(a && (B != C)) || D'\'' '\''(a && B != C) || D'\'''
diff-expr '(a && (B != C)) || D' '(a && B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (B != C)) || D'\'' '\''(a && B != C) || D'\'''

echo '$ test-expr '\''(A && (b != c)) || d'\'''
test-expr '(A && (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b != c)) || d'\'''

echo '$ diff-expr '\''(A && (b != c)) || d'\'' '\''A && (b != c) || d'\'''
diff-expr '(A && (b != c)) || d' 'A && (b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != c)) || d'\'' '\''A && (b != c) || d'\'''

echo '$ diff-expr '\''(A && (b != c)) || d'\'' '\''A && b != c || d'\'''
diff-expr '(A && (b != c)) || d' 'A && b != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != c)) || d'\'' '\''A && b != c || d'\'''

echo '$ diff-expr '\''(A && (b != c)) || d'\'' '\''(A && b != c) || d'\'''
diff-expr '(A && (b != c)) || d' '(A && b != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != c)) || d'\'' '\''(A && b != c) || d'\'''

echo '$ test-expr '\''(A && (b != c)) || D'\'''
test-expr '(A && (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b != c)) || D'\'''

echo '$ diff-expr '\''(A && (b != c)) || D'\'' '\''A && (b != c) || D'\'''
diff-expr '(A && (b != c)) || D' 'A && (b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != c)) || D'\'' '\''A && (b != c) || D'\'''

echo '$ diff-expr '\''(A && (b != c)) || D'\'' '\''A && b != c || D'\'''
diff-expr '(A && (b != c)) || D' 'A && b != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != c)) || D'\'' '\''A && b != c || D'\'''

echo '$ diff-expr '\''(A && (b != c)) || D'\'' '\''(A && b != c) || D'\'''
diff-expr '(A && (b != c)) || D' '(A && b != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != c)) || D'\'' '\''(A && b != c) || D'\'''

echo '$ test-expr '\''(A && (b != C)) || d'\'''
test-expr '(A && (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b != C)) || d'\'''

echo '$ diff-expr '\''(A && (b != C)) || d'\'' '\''A && (b != C) || d'\'''
diff-expr '(A && (b != C)) || d' 'A && (b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != C)) || d'\'' '\''A && (b != C) || d'\'''

echo '$ diff-expr '\''(A && (b != C)) || d'\'' '\''A && b != C || d'\'''
diff-expr '(A && (b != C)) || d' 'A && b != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != C)) || d'\'' '\''A && b != C || d'\'''

echo '$ diff-expr '\''(A && (b != C)) || d'\'' '\''(A && b != C) || d'\'''
diff-expr '(A && (b != C)) || d' '(A && b != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != C)) || d'\'' '\''(A && b != C) || d'\'''

echo '$ test-expr '\''(A && (b != C)) || D'\'''
test-expr '(A && (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b != C)) || D'\'''

echo '$ diff-expr '\''(A && (b != C)) || D'\'' '\''A && (b != C) || D'\'''
diff-expr '(A && (b != C)) || D' 'A && (b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != C)) || D'\'' '\''A && (b != C) || D'\'''

echo '$ diff-expr '\''(A && (b != C)) || D'\'' '\''A && b != C || D'\'''
diff-expr '(A && (b != C)) || D' 'A && b != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != C)) || D'\'' '\''A && b != C || D'\'''

echo '$ diff-expr '\''(A && (b != C)) || D'\'' '\''(A && b != C) || D'\'''
diff-expr '(A && (b != C)) || D' '(A && b != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (b != C)) || D'\'' '\''(A && b != C) || D'\'''

echo '$ test-expr '\''(A && (B != c)) || d'\'''
test-expr '(A && (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B != c)) || d'\'''

echo '$ diff-expr '\''(A && (B != c)) || d'\'' '\''A && (B != c) || d'\'''
diff-expr '(A && (B != c)) || d' 'A && (B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != c)) || d'\'' '\''A && (B != c) || d'\'''

echo '$ diff-expr '\''(A && (B != c)) || d'\'' '\''A && B != c || d'\'''
diff-expr '(A && (B != c)) || d' 'A && B != c || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != c)) || d'\'' '\''A && B != c || d'\'''

echo '$ diff-expr '\''(A && (B != c)) || d'\'' '\''(A && B != c) || d'\'''
diff-expr '(A && (B != c)) || d' '(A && B != c) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != c)) || d'\'' '\''(A && B != c) || d'\'''

echo '$ test-expr '\''(A && (B != c)) || D'\'''
test-expr '(A && (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B != c)) || D'\'''

echo '$ diff-expr '\''(A && (B != c)) || D'\'' '\''A && (B != c) || D'\'''
diff-expr '(A && (B != c)) || D' 'A && (B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != c)) || D'\'' '\''A && (B != c) || D'\'''

echo '$ diff-expr '\''(A && (B != c)) || D'\'' '\''A && B != c || D'\'''
diff-expr '(A && (B != c)) || D' 'A && B != c || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != c)) || D'\'' '\''A && B != c || D'\'''

echo '$ diff-expr '\''(A && (B != c)) || D'\'' '\''(A && B != c) || D'\'''
diff-expr '(A && (B != c)) || D' '(A && B != c) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != c)) || D'\'' '\''(A && B != c) || D'\'''

echo '$ test-expr '\''(A && (B != C)) || d'\'''
test-expr '(A && (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B != C)) || d'\'''

echo '$ diff-expr '\''(A && (B != C)) || d'\'' '\''A && (B != C) || d'\'''
diff-expr '(A && (B != C)) || d' 'A && (B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != C)) || d'\'' '\''A && (B != C) || d'\'''

echo '$ diff-expr '\''(A && (B != C)) || d'\'' '\''A && B != C || d'\'''
diff-expr '(A && (B != C)) || d' 'A && B != C || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != C)) || d'\'' '\''A && B != C || d'\'''

echo '$ diff-expr '\''(A && (B != C)) || d'\'' '\''(A && B != C) || d'\'''
diff-expr '(A && (B != C)) || d' '(A && B != C) || d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != C)) || d'\'' '\''(A && B != C) || d'\'''

echo '$ test-expr '\''(A && (B != C)) || D'\'''
test-expr '(A && (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B != C)) || D'\'''

echo '$ diff-expr '\''(A && (B != C)) || D'\'' '\''A && (B != C) || D'\'''
diff-expr '(A && (B != C)) || D' 'A && (B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != C)) || D'\'' '\''A && (B != C) || D'\'''

echo '$ diff-expr '\''(A && (B != C)) || D'\'' '\''A && B != C || D'\'''
diff-expr '(A && (B != C)) || D' 'A && B != C || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != C)) || D'\'' '\''A && B != C || D'\'''

echo '$ diff-expr '\''(A && (B != C)) || D'\'' '\''(A && B != C) || D'\'''
diff-expr '(A && (B != C)) || D' '(A && B != C) || D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && (B != C)) || D'\'' '\''(A && B != C) || D'\'''

echo '$ test-expr '\''(a != b) >= (c && d)'\'''
test-expr '(a != b) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (c && d)'\'''

echo '$ test-expr '\''(a != b) >= (c && D)'\'''
test-expr '(a != b) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (c && D)'\'''

echo '$ test-expr '\''(a != b) >= (C && d)'\'''
test-expr '(a != b) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (C && d)'\'''

echo '$ test-expr '\''(a != b) >= (C && D)'\'''
test-expr '(a != b) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (C && D)'\'''

echo '$ test-expr '\''(a != B) >= (c && d)'\'''
test-expr '(a != B) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (c && d)'\'''

echo '$ test-expr '\''(a != B) >= (c && D)'\'''
test-expr '(a != B) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (c && D)'\'''

echo '$ test-expr '\''(a != B) >= (C && d)'\'''
test-expr '(a != B) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (C && d)'\'''

echo '$ test-expr '\''(a != B) >= (C && D)'\'''
test-expr '(a != B) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (C && D)'\'''

echo '$ test-expr '\''(A != b) >= (c && d)'\'''
test-expr '(A != b) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (c && d)'\'''

echo '$ test-expr '\''(A != b) >= (c && D)'\'''
test-expr '(A != b) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (c && D)'\'''

echo '$ test-expr '\''(A != b) >= (C && d)'\'''
test-expr '(A != b) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (C && d)'\'''

echo '$ test-expr '\''(A != b) >= (C && D)'\'''
test-expr '(A != b) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (C && D)'\'''

echo '$ test-expr '\''(A != B) >= (c && d)'\'''
test-expr '(A != B) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (c && d)'\'''

echo '$ test-expr '\''(A != B) >= (c && D)'\'''
test-expr '(A != B) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (c && D)'\'''

echo '$ test-expr '\''(A != B) >= (C && d)'\'''
test-expr '(A != B) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (C && d)'\'''

echo '$ test-expr '\''(A != B) >= (C && D)'\'''
test-expr '(A != B) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (C && D)'\'''

echo '$ test-expr '\''(a != b) >= (c || d)'\'''
test-expr '(a != b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (c || d)'\'''

echo '$ test-expr '\''(a != b) >= (c || D)'\'''
test-expr '(a != b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (c || D)'\'''

echo '$ test-expr '\''(a != b) >= (C || d)'\'''
test-expr '(a != b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (C || d)'\'''

echo '$ test-expr '\''(a != b) >= (C || D)'\'''
test-expr '(a != b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (C || D)'\'''

echo '$ test-expr '\''(a != B) >= (c || d)'\'''
test-expr '(a != B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (c || d)'\'''

echo '$ test-expr '\''(a != B) >= (c || D)'\'''
test-expr '(a != B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (c || D)'\'''

echo '$ test-expr '\''(a != B) >= (C || d)'\'''
test-expr '(a != B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (C || d)'\'''

echo '$ test-expr '\''(a != B) >= (C || D)'\'''
test-expr '(a != B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) >= (C || D)'\'''

echo '$ test-expr '\''(A != b) >= (c || d)'\'''
test-expr '(A != b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (c || d)'\'''

echo '$ test-expr '\''(A != b) >= (c || D)'\'''
test-expr '(A != b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (c || D)'\'''

echo '$ test-expr '\''(A != b) >= (C || d)'\'''
test-expr '(A != b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (C || d)'\'''

echo '$ test-expr '\''(A != b) >= (C || D)'\'''
test-expr '(A != b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) >= (C || D)'\'''

echo '$ test-expr '\''(A != B) >= (c || d)'\'''
test-expr '(A != B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (c || d)'\'''

echo '$ test-expr '\''(A != B) >= (c || D)'\'''
test-expr '(A != B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (c || D)'\'''

echo '$ test-expr '\''(A != B) >= (C || d)'\'''
test-expr '(A != B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (C || d)'\'''

echo '$ test-expr '\''(A != B) >= (C || D)'\'''
test-expr '(A != B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) >= (C || D)'\'''

echo '$ test-expr '\''(a && b) >= (c || d)'\'''
test-expr '(a && b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= (c || d)'\'''

echo '$ test-expr '\''(a && b) >= (c || D)'\'''
test-expr '(a && b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= (c || D)'\'''

echo '$ test-expr '\''(a && b) >= (C || d)'\'''
test-expr '(a && b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= (C || d)'\'''

echo '$ test-expr '\''(a && b) >= (C || D)'\'''
test-expr '(a && b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= (C || D)'\'''

echo '$ test-expr '\''(a && B) >= (c || d)'\'''
test-expr '(a && B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) >= (c || d)'\'''

echo '$ test-expr '\''(a && B) >= (c || D)'\'''
test-expr '(a && B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) >= (c || D)'\'''

echo '$ test-expr '\''(a && B) >= (C || d)'\'''
test-expr '(a && B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) >= (C || d)'\'''

echo '$ test-expr '\''(a && B) >= (C || D)'\'''
test-expr '(a && B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) >= (C || D)'\'''

echo '$ test-expr '\''(A && b) >= (c || d)'\'''
test-expr '(A && b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) >= (c || d)'\'''

echo '$ test-expr '\''(A && b) >= (c || D)'\'''
test-expr '(A && b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) >= (c || D)'\'''

echo '$ test-expr '\''(A && b) >= (C || d)'\'''
test-expr '(A && b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) >= (C || d)'\'''

echo '$ test-expr '\''(A && b) >= (C || D)'\'''
test-expr '(A && b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) >= (C || D)'\'''

echo '$ test-expr '\''(A && B) >= (c || d)'\'''
test-expr '(A && B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) >= (c || d)'\'''

echo '$ test-expr '\''(A && B) >= (c || D)'\'''
test-expr '(A && B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) >= (c || D)'\'''

echo '$ test-expr '\''(A && B) >= (C || d)'\'''
test-expr '(A && B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) >= (C || d)'\'''

echo '$ test-expr '\''(A && B) >= (C || D)'\'''
test-expr '(A && B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) >= (C || D)'\'''

echo '$ test-expr '\''(a && b) != (c || d)'\'''
test-expr '(a && b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != (c || d)'\'''

echo '$ test-expr '\''(a && b) != (c || D)'\'''
test-expr '(a && b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != (c || D)'\'''

echo '$ test-expr '\''(a && b) != (C || d)'\'''
test-expr '(a && b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != (C || d)'\'''

echo '$ test-expr '\''(a && b) != (C || D)'\'''
test-expr '(a && b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != (C || D)'\'''

echo '$ test-expr '\''(a && B) != (c || d)'\'''
test-expr '(a && B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) != (c || d)'\'''

echo '$ test-expr '\''(a && B) != (c || D)'\'''
test-expr '(a && B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) != (c || D)'\'''

echo '$ test-expr '\''(a && B) != (C || d)'\'''
test-expr '(a && B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) != (C || d)'\'''

echo '$ test-expr '\''(a && B) != (C || D)'\'''
test-expr '(a && B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) != (C || D)'\'''

echo '$ test-expr '\''(A && b) != (c || d)'\'''
test-expr '(A && b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) != (c || d)'\'''

echo '$ test-expr '\''(A && b) != (c || D)'\'''
test-expr '(A && b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) != (c || D)'\'''

echo '$ test-expr '\''(A && b) != (C || d)'\'''
test-expr '(A && b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) != (C || d)'\'''

echo '$ test-expr '\''(A && b) != (C || D)'\'''
test-expr '(A && b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) != (C || D)'\'''

echo '$ test-expr '\''(A && B) != (c || d)'\'''
test-expr '(A && B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) != (c || d)'\'''

echo '$ test-expr '\''(A && B) != (c || D)'\'''
test-expr '(A && B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) != (c || D)'\'''

echo '$ test-expr '\''(A && B) != (C || d)'\'''
test-expr '(A && B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) != (C || d)'\'''

echo '$ test-expr '\''(A && B) != (C || D)'\'''
test-expr '(A && B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) != (C || D)'\'''

echo '$ test-expr '\''a != (b >= (c && d))'\'''
test-expr 'a != (b >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && d))'\'''

echo '$ diff-expr '\''a != (b >= (c && d))'\'' '\''a != b >= (c && d)'\'''
diff-expr 'a != (b >= (c && d))' 'a != b >= (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c && d))'\'' '\''a != b >= (c && d)'\'''

echo '$ test-expr '\''a != (b >= (c && D))'\'''
test-expr 'a != (b >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && D))'\'''

echo '$ diff-expr '\''a != (b >= (c && D))'\'' '\''a != b >= (c && D)'\'''
diff-expr 'a != (b >= (c && D))' 'a != b >= (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c && D))'\'' '\''a != b >= (c && D)'\'''

echo '$ test-expr '\''a != (b >= (C && d))'\'''
test-expr 'a != (b >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (C && d))'\'''

echo '$ diff-expr '\''a != (b >= (C && d))'\'' '\''a != b >= (C && d)'\'''
diff-expr 'a != (b >= (C && d))' 'a != b >= (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (C && d))'\'' '\''a != b >= (C && d)'\'''

echo '$ test-expr '\''a != (b >= (C && D))'\'''
test-expr 'a != (b >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (C && D))'\'''

echo '$ diff-expr '\''a != (b >= (C && D))'\'' '\''a != b >= (C && D)'\'''
diff-expr 'a != (b >= (C && D))' 'a != b >= (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (C && D))'\'' '\''a != b >= (C && D)'\'''

echo '$ test-expr '\''a != (B >= (c && d))'\'''
test-expr 'a != (B >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (c && d))'\'''

echo '$ diff-expr '\''a != (B >= (c && d))'\'' '\''a != B >= (c && d)'\'''
diff-expr 'a != (B >= (c && d))' 'a != B >= (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (c && d))'\'' '\''a != B >= (c && d)'\'''

echo '$ test-expr '\''a != (B >= (c && D))'\'''
test-expr 'a != (B >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (c && D))'\'''

echo '$ diff-expr '\''a != (B >= (c && D))'\'' '\''a != B >= (c && D)'\'''
diff-expr 'a != (B >= (c && D))' 'a != B >= (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (c && D))'\'' '\''a != B >= (c && D)'\'''

echo '$ test-expr '\''a != (B >= (C && d))'\'''
test-expr 'a != (B >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (C && d))'\'''

echo '$ diff-expr '\''a != (B >= (C && d))'\'' '\''a != B >= (C && d)'\'''
diff-expr 'a != (B >= (C && d))' 'a != B >= (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (C && d))'\'' '\''a != B >= (C && d)'\'''

echo '$ test-expr '\''a != (B >= (C && D))'\'''
test-expr 'a != (B >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (C && D))'\'''

echo '$ diff-expr '\''a != (B >= (C && D))'\'' '\''a != B >= (C && D)'\'''
diff-expr 'a != (B >= (C && D))' 'a != B >= (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (C && D))'\'' '\''a != B >= (C && D)'\'''

echo '$ test-expr '\''A != (b >= (c && d))'\'''
test-expr 'A != (b >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (c && d))'\'''

echo '$ diff-expr '\''A != (b >= (c && d))'\'' '\''A != b >= (c && d)'\'''
diff-expr 'A != (b >= (c && d))' 'A != b >= (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (c && d))'\'' '\''A != b >= (c && d)'\'''

echo '$ test-expr '\''A != (b >= (c && D))'\'''
test-expr 'A != (b >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (c && D))'\'''

echo '$ diff-expr '\''A != (b >= (c && D))'\'' '\''A != b >= (c && D)'\'''
diff-expr 'A != (b >= (c && D))' 'A != b >= (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (c && D))'\'' '\''A != b >= (c && D)'\'''

echo '$ test-expr '\''A != (b >= (C && d))'\'''
test-expr 'A != (b >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (C && d))'\'''

echo '$ diff-expr '\''A != (b >= (C && d))'\'' '\''A != b >= (C && d)'\'''
diff-expr 'A != (b >= (C && d))' 'A != b >= (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (C && d))'\'' '\''A != b >= (C && d)'\'''

echo '$ test-expr '\''A != (b >= (C && D))'\'''
test-expr 'A != (b >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (C && D))'\'''

echo '$ diff-expr '\''A != (b >= (C && D))'\'' '\''A != b >= (C && D)'\'''
diff-expr 'A != (b >= (C && D))' 'A != b >= (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (C && D))'\'' '\''A != b >= (C && D)'\'''

echo '$ test-expr '\''A != (B >= (c && d))'\'''
test-expr 'A != (B >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (c && d))'\'''

echo '$ diff-expr '\''A != (B >= (c && d))'\'' '\''A != B >= (c && d)'\'''
diff-expr 'A != (B >= (c && d))' 'A != B >= (c && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (c && d))'\'' '\''A != B >= (c && d)'\'''

echo '$ test-expr '\''A != (B >= (c && D))'\'''
test-expr 'A != (B >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (c && D))'\'''

echo '$ diff-expr '\''A != (B >= (c && D))'\'' '\''A != B >= (c && D)'\'''
diff-expr 'A != (B >= (c && D))' 'A != B >= (c && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (c && D))'\'' '\''A != B >= (c && D)'\'''

echo '$ test-expr '\''A != (B >= (C && d))'\'''
test-expr 'A != (B >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (C && d))'\'''

echo '$ diff-expr '\''A != (B >= (C && d))'\'' '\''A != B >= (C && d)'\'''
diff-expr 'A != (B >= (C && d))' 'A != B >= (C && d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (C && d))'\'' '\''A != B >= (C && d)'\'''

echo '$ test-expr '\''A != (B >= (C && D))'\'''
test-expr 'A != (B >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (C && D))'\'''

echo '$ diff-expr '\''A != (B >= (C && D))'\'' '\''A != B >= (C && D)'\'''
diff-expr 'A != (B >= (C && D))' 'A != B >= (C && D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (C && D))'\'' '\''A != B >= (C && D)'\'''

echo '$ test-expr '\''a != (b >= (c || d))'\'''
test-expr 'a != (b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || d))'\'''

echo '$ diff-expr '\''a != (b >= (c || d))'\'' '\''a != b >= (c || d)'\'''
diff-expr 'a != (b >= (c || d))' 'a != b >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c || d))'\'' '\''a != b >= (c || d)'\'''

echo '$ test-expr '\''a != (b >= (c || D))'\'''
test-expr 'a != (b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || D))'\'''

echo '$ diff-expr '\''a != (b >= (c || D))'\'' '\''a != b >= (c || D)'\'''
diff-expr 'a != (b >= (c || D))' 'a != b >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c || D))'\'' '\''a != b >= (c || D)'\'''

echo '$ test-expr '\''a != (b >= (C || d))'\'''
test-expr 'a != (b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (C || d))'\'''

echo '$ diff-expr '\''a != (b >= (C || d))'\'' '\''a != b >= (C || d)'\'''
diff-expr 'a != (b >= (C || d))' 'a != b >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (C || d))'\'' '\''a != b >= (C || d)'\'''

echo '$ test-expr '\''a != (b >= (C || D))'\'''
test-expr 'a != (b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (C || D))'\'''

echo '$ diff-expr '\''a != (b >= (C || D))'\'' '\''a != b >= (C || D)'\'''
diff-expr 'a != (b >= (C || D))' 'a != b >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (C || D))'\'' '\''a != b >= (C || D)'\'''

echo '$ test-expr '\''a != (B >= (c || d))'\'''
test-expr 'a != (B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (c || d))'\'''

echo '$ diff-expr '\''a != (B >= (c || d))'\'' '\''a != B >= (c || d)'\'''
diff-expr 'a != (B >= (c || d))' 'a != B >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (c || d))'\'' '\''a != B >= (c || d)'\'''

echo '$ test-expr '\''a != (B >= (c || D))'\'''
test-expr 'a != (B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (c || D))'\'''

echo '$ diff-expr '\''a != (B >= (c || D))'\'' '\''a != B >= (c || D)'\'''
diff-expr 'a != (B >= (c || D))' 'a != B >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (c || D))'\'' '\''a != B >= (c || D)'\'''

echo '$ test-expr '\''a != (B >= (C || d))'\'''
test-expr 'a != (B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (C || d))'\'''

echo '$ diff-expr '\''a != (B >= (C || d))'\'' '\''a != B >= (C || d)'\'''
diff-expr 'a != (B >= (C || d))' 'a != B >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (C || d))'\'' '\''a != B >= (C || d)'\'''

echo '$ test-expr '\''a != (B >= (C || D))'\'''
test-expr 'a != (B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B >= (C || D))'\'''

echo '$ diff-expr '\''a != (B >= (C || D))'\'' '\''a != B >= (C || D)'\'''
diff-expr 'a != (B >= (C || D))' 'a != B >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B >= (C || D))'\'' '\''a != B >= (C || D)'\'''

echo '$ test-expr '\''A != (b >= (c || d))'\'''
test-expr 'A != (b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (c || d))'\'''

echo '$ diff-expr '\''A != (b >= (c || d))'\'' '\''A != b >= (c || d)'\'''
diff-expr 'A != (b >= (c || d))' 'A != b >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (c || d))'\'' '\''A != b >= (c || d)'\'''

echo '$ test-expr '\''A != (b >= (c || D))'\'''
test-expr 'A != (b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (c || D))'\'''

echo '$ diff-expr '\''A != (b >= (c || D))'\'' '\''A != b >= (c || D)'\'''
diff-expr 'A != (b >= (c || D))' 'A != b >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (c || D))'\'' '\''A != b >= (c || D)'\'''

echo '$ test-expr '\''A != (b >= (C || d))'\'''
test-expr 'A != (b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (C || d))'\'''

echo '$ diff-expr '\''A != (b >= (C || d))'\'' '\''A != b >= (C || d)'\'''
diff-expr 'A != (b >= (C || d))' 'A != b >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (C || d))'\'' '\''A != b >= (C || d)'\'''

echo '$ test-expr '\''A != (b >= (C || D))'\'''
test-expr 'A != (b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (b >= (C || D))'\'''

echo '$ diff-expr '\''A != (b >= (C || D))'\'' '\''A != b >= (C || D)'\'''
diff-expr 'A != (b >= (C || D))' 'A != b >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (b >= (C || D))'\'' '\''A != b >= (C || D)'\'''

echo '$ test-expr '\''A != (B >= (c || d))'\'''
test-expr 'A != (B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (c || d))'\'''

echo '$ diff-expr '\''A != (B >= (c || d))'\'' '\''A != B >= (c || d)'\'''
diff-expr 'A != (B >= (c || d))' 'A != B >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (c || d))'\'' '\''A != B >= (c || d)'\'''

echo '$ test-expr '\''A != (B >= (c || D))'\'''
test-expr 'A != (B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (c || D))'\'''

echo '$ diff-expr '\''A != (B >= (c || D))'\'' '\''A != B >= (c || D)'\'''
diff-expr 'A != (B >= (c || D))' 'A != B >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (c || D))'\'' '\''A != B >= (c || D)'\'''

echo '$ test-expr '\''A != (B >= (C || d))'\'''
test-expr 'A != (B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (C || d))'\'''

echo '$ diff-expr '\''A != (B >= (C || d))'\'' '\''A != B >= (C || d)'\'''
diff-expr 'A != (B >= (C || d))' 'A != B >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (C || d))'\'' '\''A != B >= (C || d)'\'''

echo '$ test-expr '\''A != (B >= (C || D))'\'''
test-expr 'A != (B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != (B >= (C || D))'\'''

echo '$ diff-expr '\''A != (B >= (C || D))'\'' '\''A != B >= (C || D)'\'''
diff-expr 'A != (B >= (C || D))' 'A != B >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A != (B >= (C || D))'\'' '\''A != B >= (C || D)'\'''

echo '$ test-expr '\''a && (b >= (c || d))'\'''
test-expr 'a && (b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || d))'\'''

echo '$ diff-expr '\''a && (b >= (c || d))'\'' '\''a && b >= (c || d)'\'''
diff-expr 'a && (b >= (c || d))' 'a && b >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (c || d))'\'' '\''a && b >= (c || d)'\'''

echo '$ test-expr '\''a && (b >= (c || D))'\'''
test-expr 'a && (b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || D))'\'''

echo '$ diff-expr '\''a && (b >= (c || D))'\'' '\''a && b >= (c || D)'\'''
diff-expr 'a && (b >= (c || D))' 'a && b >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (c || D))'\'' '\''a && b >= (c || D)'\'''

echo '$ test-expr '\''a && (b >= (C || d))'\'''
test-expr 'a && (b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (C || d))'\'''

echo '$ diff-expr '\''a && (b >= (C || d))'\'' '\''a && b >= (C || d)'\'''
diff-expr 'a && (b >= (C || d))' 'a && b >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (C || d))'\'' '\''a && b >= (C || d)'\'''

echo '$ test-expr '\''a && (b >= (C || D))'\'''
test-expr 'a && (b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (C || D))'\'''

echo '$ diff-expr '\''a && (b >= (C || D))'\'' '\''a && b >= (C || D)'\'''
diff-expr 'a && (b >= (C || D))' 'a && b >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (C || D))'\'' '\''a && b >= (C || D)'\'''

echo '$ test-expr '\''a && (B >= (c || d))'\'''
test-expr 'a && (B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= (c || d))'\'''

echo '$ diff-expr '\''a && (B >= (c || d))'\'' '\''a && B >= (c || d)'\'''
diff-expr 'a && (B >= (c || d))' 'a && B >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B >= (c || d))'\'' '\''a && B >= (c || d)'\'''

echo '$ test-expr '\''a && (B >= (c || D))'\'''
test-expr 'a && (B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= (c || D))'\'''

echo '$ diff-expr '\''a && (B >= (c || D))'\'' '\''a && B >= (c || D)'\'''
diff-expr 'a && (B >= (c || D))' 'a && B >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B >= (c || D))'\'' '\''a && B >= (c || D)'\'''

echo '$ test-expr '\''a && (B >= (C || d))'\'''
test-expr 'a && (B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= (C || d))'\'''

echo '$ diff-expr '\''a && (B >= (C || d))'\'' '\''a && B >= (C || d)'\'''
diff-expr 'a && (B >= (C || d))' 'a && B >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B >= (C || d))'\'' '\''a && B >= (C || d)'\'''

echo '$ test-expr '\''a && (B >= (C || D))'\'''
test-expr 'a && (B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B >= (C || D))'\'''

echo '$ diff-expr '\''a && (B >= (C || D))'\'' '\''a && B >= (C || D)'\'''
diff-expr 'a && (B >= (C || D))' 'a && B >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B >= (C || D))'\'' '\''a && B >= (C || D)'\'''

echo '$ test-expr '\''A && (b >= (c || d))'\'''
test-expr 'A && (b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= (c || d))'\'''

echo '$ diff-expr '\''A && (b >= (c || d))'\'' '\''A && b >= (c || d)'\'''
diff-expr 'A && (b >= (c || d))' 'A && b >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b >= (c || d))'\'' '\''A && b >= (c || d)'\'''

echo '$ test-expr '\''A && (b >= (c || D))'\'''
test-expr 'A && (b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= (c || D))'\'''

echo '$ diff-expr '\''A && (b >= (c || D))'\'' '\''A && b >= (c || D)'\'''
diff-expr 'A && (b >= (c || D))' 'A && b >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b >= (c || D))'\'' '\''A && b >= (c || D)'\'''

echo '$ test-expr '\''A && (b >= (C || d))'\'''
test-expr 'A && (b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= (C || d))'\'''

echo '$ diff-expr '\''A && (b >= (C || d))'\'' '\''A && b >= (C || d)'\'''
diff-expr 'A && (b >= (C || d))' 'A && b >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b >= (C || d))'\'' '\''A && b >= (C || d)'\'''

echo '$ test-expr '\''A && (b >= (C || D))'\'''
test-expr 'A && (b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b >= (C || D))'\'''

echo '$ diff-expr '\''A && (b >= (C || D))'\'' '\''A && b >= (C || D)'\'''
diff-expr 'A && (b >= (C || D))' 'A && b >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b >= (C || D))'\'' '\''A && b >= (C || D)'\'''

echo '$ test-expr '\''A && (B >= (c || d))'\'''
test-expr 'A && (B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= (c || d))'\'''

echo '$ diff-expr '\''A && (B >= (c || d))'\'' '\''A && B >= (c || d)'\'''
diff-expr 'A && (B >= (c || d))' 'A && B >= (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B >= (c || d))'\'' '\''A && B >= (c || d)'\'''

echo '$ test-expr '\''A && (B >= (c || D))'\'''
test-expr 'A && (B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= (c || D))'\'''

echo '$ diff-expr '\''A && (B >= (c || D))'\'' '\''A && B >= (c || D)'\'''
diff-expr 'A && (B >= (c || D))' 'A && B >= (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B >= (c || D))'\'' '\''A && B >= (c || D)'\'''

echo '$ test-expr '\''A && (B >= (C || d))'\'''
test-expr 'A && (B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= (C || d))'\'''

echo '$ diff-expr '\''A && (B >= (C || d))'\'' '\''A && B >= (C || d)'\'''
diff-expr 'A && (B >= (C || d))' 'A && B >= (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B >= (C || d))'\'' '\''A && B >= (C || d)'\'''

echo '$ test-expr '\''A && (B >= (C || D))'\'''
test-expr 'A && (B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B >= (C || D))'\'''

echo '$ diff-expr '\''A && (B >= (C || D))'\'' '\''A && B >= (C || D)'\'''
diff-expr 'A && (B >= (C || D))' 'A && B >= (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B >= (C || D))'\'' '\''A && B >= (C || D)'\'''

echo '$ test-expr '\''a && (b != (c || d))'\'''
test-expr 'a && (b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || d))'\'''

echo '$ diff-expr '\''a && (b != (c || d))'\'' '\''a && b != (c || d)'\'''
diff-expr 'a && (b != (c || d))' 'a && b != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c || d))'\'' '\''a && b != (c || d)'\'''

echo '$ test-expr '\''a && (b != (c || D))'\'''
test-expr 'a && (b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || D))'\'''

echo '$ diff-expr '\''a && (b != (c || D))'\'' '\''a && b != (c || D)'\'''
diff-expr 'a && (b != (c || D))' 'a && b != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c || D))'\'' '\''a && b != (c || D)'\'''

echo '$ test-expr '\''a && (b != (C || d))'\'''
test-expr 'a && (b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (C || d))'\'''

echo '$ diff-expr '\''a && (b != (C || d))'\'' '\''a && b != (C || d)'\'''
diff-expr 'a && (b != (C || d))' 'a && b != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (C || d))'\'' '\''a && b != (C || d)'\'''

echo '$ test-expr '\''a && (b != (C || D))'\'''
test-expr 'a && (b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (C || D))'\'''

echo '$ diff-expr '\''a && (b != (C || D))'\'' '\''a && b != (C || D)'\'''
diff-expr 'a && (b != (C || D))' 'a && b != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (C || D))'\'' '\''a && b != (C || D)'\'''

echo '$ test-expr '\''a && (B != (c || d))'\'''
test-expr 'a && (B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != (c || d))'\'''

echo '$ diff-expr '\''a && (B != (c || d))'\'' '\''a && B != (c || d)'\'''
diff-expr 'a && (B != (c || d))' 'a && B != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B != (c || d))'\'' '\''a && B != (c || d)'\'''

echo '$ test-expr '\''a && (B != (c || D))'\'''
test-expr 'a && (B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != (c || D))'\'''

echo '$ diff-expr '\''a && (B != (c || D))'\'' '\''a && B != (c || D)'\'''
diff-expr 'a && (B != (c || D))' 'a && B != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B != (c || D))'\'' '\''a && B != (c || D)'\'''

echo '$ test-expr '\''a && (B != (C || d))'\'''
test-expr 'a && (B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != (C || d))'\'''

echo '$ diff-expr '\''a && (B != (C || d))'\'' '\''a && B != (C || d)'\'''
diff-expr 'a && (B != (C || d))' 'a && B != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B != (C || d))'\'' '\''a && B != (C || d)'\'''

echo '$ test-expr '\''a && (B != (C || D))'\'''
test-expr 'a && (B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && (B != (C || D))'\'''

echo '$ diff-expr '\''a && (B != (C || D))'\'' '\''a && B != (C || D)'\'''
diff-expr 'a && (B != (C || D))' 'a && B != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (B != (C || D))'\'' '\''a && B != (C || D)'\'''

echo '$ test-expr '\''A && (b != (c || d))'\'''
test-expr 'A && (b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != (c || d))'\'''

echo '$ diff-expr '\''A && (b != (c || d))'\'' '\''A && b != (c || d)'\'''
diff-expr 'A && (b != (c || d))' 'A && b != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b != (c || d))'\'' '\''A && b != (c || d)'\'''

echo '$ test-expr '\''A && (b != (c || D))'\'''
test-expr 'A && (b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != (c || D))'\'''

echo '$ diff-expr '\''A && (b != (c || D))'\'' '\''A && b != (c || D)'\'''
diff-expr 'A && (b != (c || D))' 'A && b != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b != (c || D))'\'' '\''A && b != (c || D)'\'''

echo '$ test-expr '\''A && (b != (C || d))'\'''
test-expr 'A && (b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != (C || d))'\'''

echo '$ diff-expr '\''A && (b != (C || d))'\'' '\''A && b != (C || d)'\'''
diff-expr 'A && (b != (C || d))' 'A && b != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b != (C || d))'\'' '\''A && b != (C || d)'\'''

echo '$ test-expr '\''A && (b != (C || D))'\'''
test-expr 'A && (b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (b != (C || D))'\'''

echo '$ diff-expr '\''A && (b != (C || D))'\'' '\''A && b != (C || D)'\'''
diff-expr 'A && (b != (C || D))' 'A && b != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (b != (C || D))'\'' '\''A && b != (C || D)'\'''

echo '$ test-expr '\''A && (B != (c || d))'\'''
test-expr 'A && (B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != (c || d))'\'''

echo '$ diff-expr '\''A && (B != (c || d))'\'' '\''A && B != (c || d)'\'''
diff-expr 'A && (B != (c || d))' 'A && B != (c || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B != (c || d))'\'' '\''A && B != (c || d)'\'''

echo '$ test-expr '\''A && (B != (c || D))'\'''
test-expr 'A && (B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != (c || D))'\'''

echo '$ diff-expr '\''A && (B != (c || D))'\'' '\''A && B != (c || D)'\'''
diff-expr 'A && (B != (c || D))' 'A && B != (c || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B != (c || D))'\'' '\''A && B != (c || D)'\'''

echo '$ test-expr '\''A && (B != (C || d))'\'''
test-expr 'A && (B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != (C || d))'\'''

echo '$ diff-expr '\''A && (B != (C || d))'\'' '\''A && B != (C || d)'\'''
diff-expr 'A && (B != (C || d))' 'A && B != (C || d)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B != (C || d))'\'' '\''A && B != (C || d)'\'''

echo '$ test-expr '\''A && (B != (C || D))'\'''
test-expr 'A && (B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && (B != (C || D))'\'''

echo '$ diff-expr '\''A && (B != (C || D))'\'' '\''A && B != (C || D)'\'''
diff-expr 'A && (B != (C || D))' 'A && B != (C || D)' 2>&1 ||
echo 'command failed: diff-expr '\''A && (B != (C || D))'\'' '\''A && B != (C || D)'\'''

echo '$ test-expr '\''((a != b) && c) >= d'\'''
test-expr '((a != b) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && c) >= d'\'''

echo '$ diff-expr '\''((a != b) && c) >= d'\'' '\''(a != b && c) >= d'\'''
diff-expr '((a != b) && c) >= d' '(a != b && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) >= d'\'' '\''(a != b && c) >= d'\'''

echo '$ test-expr '\''((a != b) && c) >= D'\'''
test-expr '((a != b) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && c) >= D'\'''

echo '$ diff-expr '\''((a != b) && c) >= D'\'' '\''(a != b && c) >= D'\'''
diff-expr '((a != b) && c) >= D' '(a != b && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) >= D'\'' '\''(a != b && c) >= D'\'''

echo '$ test-expr '\''((a != b) && C) >= d'\'''
test-expr '((a != b) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && C) >= d'\'''

echo '$ diff-expr '\''((a != b) && C) >= d'\'' '\''(a != b && C) >= d'\'''
diff-expr '((a != b) && C) >= d' '(a != b && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) >= d'\'' '\''(a != b && C) >= d'\'''

echo '$ test-expr '\''((a != b) && C) >= D'\'''
test-expr '((a != b) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && C) >= D'\'''

echo '$ diff-expr '\''((a != b) && C) >= D'\'' '\''(a != b && C) >= D'\'''
diff-expr '((a != b) && C) >= D' '(a != b && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && C) >= D'\'' '\''(a != b && C) >= D'\'''

echo '$ test-expr '\''((a != B) && c) >= d'\'''
test-expr '((a != B) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && c) >= d'\'''

echo '$ diff-expr '\''((a != B) && c) >= d'\'' '\''(a != B && c) >= d'\'''
diff-expr '((a != B) && c) >= d' '(a != B && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) >= d'\'' '\''(a != B && c) >= d'\'''

echo '$ test-expr '\''((a != B) && c) >= D'\'''
test-expr '((a != B) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && c) >= D'\'''

echo '$ diff-expr '\''((a != B) && c) >= D'\'' '\''(a != B && c) >= D'\'''
diff-expr '((a != B) && c) >= D' '(a != B && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && c) >= D'\'' '\''(a != B && c) >= D'\'''

echo '$ test-expr '\''((a != B) && C) >= d'\'''
test-expr '((a != B) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && C) >= d'\'''

echo '$ diff-expr '\''((a != B) && C) >= d'\'' '\''(a != B && C) >= d'\'''
diff-expr '((a != B) && C) >= d' '(a != B && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) >= d'\'' '\''(a != B && C) >= d'\'''

echo '$ test-expr '\''((a != B) && C) >= D'\'''
test-expr '((a != B) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) && C) >= D'\'''

echo '$ diff-expr '\''((a != B) && C) >= D'\'' '\''(a != B && C) >= D'\'''
diff-expr '((a != B) && C) >= D' '(a != B && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) && C) >= D'\'' '\''(a != B && C) >= D'\'''

echo '$ test-expr '\''((A != b) && c) >= d'\'''
test-expr '((A != b) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && c) >= d'\'''

echo '$ diff-expr '\''((A != b) && c) >= d'\'' '\''(A != b && c) >= d'\'''
diff-expr '((A != b) && c) >= d' '(A != b && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) >= d'\'' '\''(A != b && c) >= d'\'''

echo '$ test-expr '\''((A != b) && c) >= D'\'''
test-expr '((A != b) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && c) >= D'\'''

echo '$ diff-expr '\''((A != b) && c) >= D'\'' '\''(A != b && c) >= D'\'''
diff-expr '((A != b) && c) >= D' '(A != b && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && c) >= D'\'' '\''(A != b && c) >= D'\'''

echo '$ test-expr '\''((A != b) && C) >= d'\'''
test-expr '((A != b) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && C) >= d'\'''

echo '$ diff-expr '\''((A != b) && C) >= d'\'' '\''(A != b && C) >= d'\'''
diff-expr '((A != b) && C) >= d' '(A != b && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) >= d'\'' '\''(A != b && C) >= d'\'''

echo '$ test-expr '\''((A != b) && C) >= D'\'''
test-expr '((A != b) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) && C) >= D'\'''

echo '$ diff-expr '\''((A != b) && C) >= D'\'' '\''(A != b && C) >= D'\'''
diff-expr '((A != b) && C) >= D' '(A != b && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) && C) >= D'\'' '\''(A != b && C) >= D'\'''

echo '$ test-expr '\''((A != B) && c) >= d'\'''
test-expr '((A != B) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && c) >= d'\'''

echo '$ diff-expr '\''((A != B) && c) >= d'\'' '\''(A != B && c) >= d'\'''
diff-expr '((A != B) && c) >= d' '(A != B && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) >= d'\'' '\''(A != B && c) >= d'\'''

echo '$ test-expr '\''((A != B) && c) >= D'\'''
test-expr '((A != B) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && c) >= D'\'''

echo '$ diff-expr '\''((A != B) && c) >= D'\'' '\''(A != B && c) >= D'\'''
diff-expr '((A != B) && c) >= D' '(A != B && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && c) >= D'\'' '\''(A != B && c) >= D'\'''

echo '$ test-expr '\''((A != B) && C) >= d'\'''
test-expr '((A != B) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && C) >= d'\'''

echo '$ diff-expr '\''((A != B) && C) >= d'\'' '\''(A != B && C) >= d'\'''
diff-expr '((A != B) && C) >= d' '(A != B && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) >= d'\'' '\''(A != B && C) >= d'\'''

echo '$ test-expr '\''((A != B) && C) >= D'\'''
test-expr '((A != B) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) && C) >= D'\'''

echo '$ diff-expr '\''((A != B) && C) >= D'\'' '\''(A != B && C) >= D'\'''
diff-expr '((A != B) && C) >= D' '(A != B && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) && C) >= D'\'' '\''(A != B && C) >= D'\'''

echo '$ test-expr '\''((a != b) || c) >= d'\'''
test-expr '((a != b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || c) >= d'\'''

echo '$ diff-expr '\''((a != b) || c) >= d'\'' '\''(a != b || c) >= d'\'''
diff-expr '((a != b) || c) >= d' '(a != b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) >= d'\'' '\''(a != b || c) >= d'\'''

echo '$ test-expr '\''((a != b) || c) >= D'\'''
test-expr '((a != b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || c) >= D'\'''

echo '$ diff-expr '\''((a != b) || c) >= D'\'' '\''(a != b || c) >= D'\'''
diff-expr '((a != b) || c) >= D' '(a != b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) >= D'\'' '\''(a != b || c) >= D'\'''

echo '$ test-expr '\''((a != b) || C) >= d'\'''
test-expr '((a != b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || C) >= d'\'''

echo '$ diff-expr '\''((a != b) || C) >= d'\'' '\''(a != b || C) >= d'\'''
diff-expr '((a != b) || C) >= d' '(a != b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || C) >= d'\'' '\''(a != b || C) >= d'\'''

echo '$ test-expr '\''((a != b) || C) >= D'\'''
test-expr '((a != b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || C) >= D'\'''

echo '$ diff-expr '\''((a != b) || C) >= D'\'' '\''(a != b || C) >= D'\'''
diff-expr '((a != b) || C) >= D' '(a != b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || C) >= D'\'' '\''(a != b || C) >= D'\'''

echo '$ test-expr '\''((a != B) || c) >= d'\'''
test-expr '((a != B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || c) >= d'\'''

echo '$ diff-expr '\''((a != B) || c) >= d'\'' '\''(a != B || c) >= d'\'''
diff-expr '((a != B) || c) >= d' '(a != B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || c) >= d'\'' '\''(a != B || c) >= d'\'''

echo '$ test-expr '\''((a != B) || c) >= D'\'''
test-expr '((a != B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || c) >= D'\'''

echo '$ diff-expr '\''((a != B) || c) >= D'\'' '\''(a != B || c) >= D'\'''
diff-expr '((a != B) || c) >= D' '(a != B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || c) >= D'\'' '\''(a != B || c) >= D'\'''

echo '$ test-expr '\''((a != B) || C) >= d'\'''
test-expr '((a != B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || C) >= d'\'''

echo '$ diff-expr '\''((a != B) || C) >= d'\'' '\''(a != B || C) >= d'\'''
diff-expr '((a != B) || C) >= d' '(a != B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || C) >= d'\'' '\''(a != B || C) >= d'\'''

echo '$ test-expr '\''((a != B) || C) >= D'\'''
test-expr '((a != B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a != B) || C) >= D'\'''

echo '$ diff-expr '\''((a != B) || C) >= D'\'' '\''(a != B || C) >= D'\'''
diff-expr '((a != B) || C) >= D' '(a != B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a != B) || C) >= D'\'' '\''(a != B || C) >= D'\'''

echo '$ test-expr '\''((A != b) || c) >= d'\'''
test-expr '((A != b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || c) >= d'\'''

echo '$ diff-expr '\''((A != b) || c) >= d'\'' '\''(A != b || c) >= d'\'''
diff-expr '((A != b) || c) >= d' '(A != b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || c) >= d'\'' '\''(A != b || c) >= d'\'''

echo '$ test-expr '\''((A != b) || c) >= D'\'''
test-expr '((A != b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || c) >= D'\'''

echo '$ diff-expr '\''((A != b) || c) >= D'\'' '\''(A != b || c) >= D'\'''
diff-expr '((A != b) || c) >= D' '(A != b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || c) >= D'\'' '\''(A != b || c) >= D'\'''

echo '$ test-expr '\''((A != b) || C) >= d'\'''
test-expr '((A != b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || C) >= d'\'''

echo '$ diff-expr '\''((A != b) || C) >= d'\'' '\''(A != b || C) >= d'\'''
diff-expr '((A != b) || C) >= d' '(A != b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || C) >= d'\'' '\''(A != b || C) >= d'\'''

echo '$ test-expr '\''((A != b) || C) >= D'\'''
test-expr '((A != b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != b) || C) >= D'\'''

echo '$ diff-expr '\''((A != b) || C) >= D'\'' '\''(A != b || C) >= D'\'''
diff-expr '((A != b) || C) >= D' '(A != b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != b) || C) >= D'\'' '\''(A != b || C) >= D'\'''

echo '$ test-expr '\''((A != B) || c) >= d'\'''
test-expr '((A != B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || c) >= d'\'''

echo '$ diff-expr '\''((A != B) || c) >= d'\'' '\''(A != B || c) >= d'\'''
diff-expr '((A != B) || c) >= d' '(A != B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || c) >= d'\'' '\''(A != B || c) >= d'\'''

echo '$ test-expr '\''((A != B) || c) >= D'\'''
test-expr '((A != B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || c) >= D'\'''

echo '$ diff-expr '\''((A != B) || c) >= D'\'' '\''(A != B || c) >= D'\'''
diff-expr '((A != B) || c) >= D' '(A != B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || c) >= D'\'' '\''(A != B || c) >= D'\'''

echo '$ test-expr '\''((A != B) || C) >= d'\'''
test-expr '((A != B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || C) >= d'\'''

echo '$ diff-expr '\''((A != B) || C) >= d'\'' '\''(A != B || C) >= d'\'''
diff-expr '((A != B) || C) >= d' '(A != B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || C) >= d'\'' '\''(A != B || C) >= d'\'''

echo '$ test-expr '\''((A != B) || C) >= D'\'''
test-expr '((A != B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A != B) || C) >= D'\'''

echo '$ diff-expr '\''((A != B) || C) >= D'\'' '\''(A != B || C) >= D'\'''
diff-expr '((A != B) || C) >= D' '(A != B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A != B) || C) >= D'\'' '\''(A != B || C) >= D'\'''

echo '$ test-expr '\''((a && b) || c) >= d'\'''
test-expr '((a && b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || c) >= d'\'''

echo '$ diff-expr '\''((a && b) || c) >= d'\'' '\''(a && b || c) >= d'\'''
diff-expr '((a && b) || c) >= d' '(a && b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) >= d'\'' '\''(a && b || c) >= d'\'''

echo '$ test-expr '\''((a && b) || c) >= D'\'''
test-expr '((a && b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || c) >= D'\'''

echo '$ diff-expr '\''((a && b) || c) >= D'\'' '\''(a && b || c) >= D'\'''
diff-expr '((a && b) || c) >= D' '(a && b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) >= D'\'' '\''(a && b || c) >= D'\'''

echo '$ test-expr '\''((a && b) || C) >= d'\'''
test-expr '((a && b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || C) >= d'\'''

echo '$ diff-expr '\''((a && b) || C) >= d'\'' '\''(a && b || C) >= d'\'''
diff-expr '((a && b) || C) >= d' '(a && b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || C) >= d'\'' '\''(a && b || C) >= d'\'''

echo '$ test-expr '\''((a && b) || C) >= D'\'''
test-expr '((a && b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || C) >= D'\'''

echo '$ diff-expr '\''((a && b) || C) >= D'\'' '\''(a && b || C) >= D'\'''
diff-expr '((a && b) || C) >= D' '(a && b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || C) >= D'\'' '\''(a && b || C) >= D'\'''

echo '$ test-expr '\''((a && B) || c) >= d'\'''
test-expr '((a && B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || c) >= d'\'''

echo '$ diff-expr '\''((a && B) || c) >= d'\'' '\''(a && B || c) >= d'\'''
diff-expr '((a && B) || c) >= d' '(a && B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || c) >= d'\'' '\''(a && B || c) >= d'\'''

echo '$ test-expr '\''((a && B) || c) >= D'\'''
test-expr '((a && B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || c) >= D'\'''

echo '$ diff-expr '\''((a && B) || c) >= D'\'' '\''(a && B || c) >= D'\'''
diff-expr '((a && B) || c) >= D' '(a && B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || c) >= D'\'' '\''(a && B || c) >= D'\'''

echo '$ test-expr '\''((a && B) || C) >= d'\'''
test-expr '((a && B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || C) >= d'\'''

echo '$ diff-expr '\''((a && B) || C) >= d'\'' '\''(a && B || C) >= d'\'''
diff-expr '((a && B) || C) >= d' '(a && B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || C) >= d'\'' '\''(a && B || C) >= d'\'''

echo '$ test-expr '\''((a && B) || C) >= D'\'''
test-expr '((a && B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || C) >= D'\'''

echo '$ diff-expr '\''((a && B) || C) >= D'\'' '\''(a && B || C) >= D'\'''
diff-expr '((a && B) || C) >= D' '(a && B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || C) >= D'\'' '\''(a && B || C) >= D'\'''

echo '$ test-expr '\''((A && b) || c) >= d'\'''
test-expr '((A && b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || c) >= d'\'''

echo '$ diff-expr '\''((A && b) || c) >= d'\'' '\''(A && b || c) >= d'\'''
diff-expr '((A && b) || c) >= d' '(A && b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || c) >= d'\'' '\''(A && b || c) >= d'\'''

echo '$ test-expr '\''((A && b) || c) >= D'\'''
test-expr '((A && b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || c) >= D'\'''

echo '$ diff-expr '\''((A && b) || c) >= D'\'' '\''(A && b || c) >= D'\'''
diff-expr '((A && b) || c) >= D' '(A && b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || c) >= D'\'' '\''(A && b || c) >= D'\'''

echo '$ test-expr '\''((A && b) || C) >= d'\'''
test-expr '((A && b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || C) >= d'\'''

echo '$ diff-expr '\''((A && b) || C) >= d'\'' '\''(A && b || C) >= d'\'''
diff-expr '((A && b) || C) >= d' '(A && b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || C) >= d'\'' '\''(A && b || C) >= d'\'''

echo '$ test-expr '\''((A && b) || C) >= D'\'''
test-expr '((A && b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || C) >= D'\'''

echo '$ diff-expr '\''((A && b) || C) >= D'\'' '\''(A && b || C) >= D'\'''
diff-expr '((A && b) || C) >= D' '(A && b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || C) >= D'\'' '\''(A && b || C) >= D'\'''

echo '$ test-expr '\''((A && B) || c) >= d'\'''
test-expr '((A && B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || c) >= d'\'''

echo '$ diff-expr '\''((A && B) || c) >= d'\'' '\''(A && B || c) >= d'\'''
diff-expr '((A && B) || c) >= d' '(A && B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || c) >= d'\'' '\''(A && B || c) >= d'\'''

echo '$ test-expr '\''((A && B) || c) >= D'\'''
test-expr '((A && B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || c) >= D'\'''

echo '$ diff-expr '\''((A && B) || c) >= D'\'' '\''(A && B || c) >= D'\'''
diff-expr '((A && B) || c) >= D' '(A && B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || c) >= D'\'' '\''(A && B || c) >= D'\'''

echo '$ test-expr '\''((A && B) || C) >= d'\'''
test-expr '((A && B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || C) >= d'\'''

echo '$ diff-expr '\''((A && B) || C) >= d'\'' '\''(A && B || C) >= d'\'''
diff-expr '((A && B) || C) >= d' '(A && B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || C) >= d'\'' '\''(A && B || C) >= d'\'''

echo '$ test-expr '\''((A && B) || C) >= D'\'''
test-expr '((A && B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || C) >= D'\'''

echo '$ diff-expr '\''((A && B) || C) >= D'\'' '\''(A && B || C) >= D'\'''
diff-expr '((A && B) || C) >= D' '(A && B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || C) >= D'\'' '\''(A && B || C) >= D'\'''

echo '$ test-expr '\''((a && b) || c) != d'\'''
test-expr '((a && b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || c) != d'\'''

echo '$ diff-expr '\''((a && b) || c) != d'\'' '\''(a && b || c) != d'\'''
diff-expr '((a && b) || c) != d' '(a && b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) != d'\'' '\''(a && b || c) != d'\'''

echo '$ test-expr '\''((a && b) || c) != D'\'''
test-expr '((a && b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || c) != D'\'''

echo '$ diff-expr '\''((a && b) || c) != D'\'' '\''(a && b || c) != D'\'''
diff-expr '((a && b) || c) != D' '(a && b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) != D'\'' '\''(a && b || c) != D'\'''

echo '$ test-expr '\''((a && b) || C) != d'\'''
test-expr '((a && b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || C) != d'\'''

echo '$ diff-expr '\''((a && b) || C) != d'\'' '\''(a && b || C) != d'\'''
diff-expr '((a && b) || C) != d' '(a && b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || C) != d'\'' '\''(a && b || C) != d'\'''

echo '$ test-expr '\''((a && b) || C) != D'\'''
test-expr '((a && b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || C) != D'\'''

echo '$ diff-expr '\''((a && b) || C) != D'\'' '\''(a && b || C) != D'\'''
diff-expr '((a && b) || C) != D' '(a && b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || C) != D'\'' '\''(a && b || C) != D'\'''

echo '$ test-expr '\''((a && B) || c) != d'\'''
test-expr '((a && B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || c) != d'\'''

echo '$ diff-expr '\''((a && B) || c) != d'\'' '\''(a && B || c) != d'\'''
diff-expr '((a && B) || c) != d' '(a && B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || c) != d'\'' '\''(a && B || c) != d'\'''

echo '$ test-expr '\''((a && B) || c) != D'\'''
test-expr '((a && B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || c) != D'\'''

echo '$ diff-expr '\''((a && B) || c) != D'\'' '\''(a && B || c) != D'\'''
diff-expr '((a && B) || c) != D' '(a && B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || c) != D'\'' '\''(a && B || c) != D'\'''

echo '$ test-expr '\''((a && B) || C) != d'\'''
test-expr '((a && B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || C) != d'\'''

echo '$ diff-expr '\''((a && B) || C) != d'\'' '\''(a && B || C) != d'\'''
diff-expr '((a && B) || C) != d' '(a && B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || C) != d'\'' '\''(a && B || C) != d'\'''

echo '$ test-expr '\''((a && B) || C) != D'\'''
test-expr '((a && B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((a && B) || C) != D'\'''

echo '$ diff-expr '\''((a && B) || C) != D'\'' '\''(a && B || C) != D'\'''
diff-expr '((a && B) || C) != D' '(a && B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((a && B) || C) != D'\'' '\''(a && B || C) != D'\'''

echo '$ test-expr '\''((A && b) || c) != d'\'''
test-expr '((A && b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || c) != d'\'''

echo '$ diff-expr '\''((A && b) || c) != d'\'' '\''(A && b || c) != d'\'''
diff-expr '((A && b) || c) != d' '(A && b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || c) != d'\'' '\''(A && b || c) != d'\'''

echo '$ test-expr '\''((A && b) || c) != D'\'''
test-expr '((A && b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || c) != D'\'''

echo '$ diff-expr '\''((A && b) || c) != D'\'' '\''(A && b || c) != D'\'''
diff-expr '((A && b) || c) != D' '(A && b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || c) != D'\'' '\''(A && b || c) != D'\'''

echo '$ test-expr '\''((A && b) || C) != d'\'''
test-expr '((A && b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || C) != d'\'''

echo '$ diff-expr '\''((A && b) || C) != d'\'' '\''(A && b || C) != d'\'''
diff-expr '((A && b) || C) != d' '(A && b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || C) != d'\'' '\''(A && b || C) != d'\'''

echo '$ test-expr '\''((A && b) || C) != D'\'''
test-expr '((A && b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A && b) || C) != D'\'''

echo '$ diff-expr '\''((A && b) || C) != D'\'' '\''(A && b || C) != D'\'''
diff-expr '((A && b) || C) != D' '(A && b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && b) || C) != D'\'' '\''(A && b || C) != D'\'''

echo '$ test-expr '\''((A && B) || c) != d'\'''
test-expr '((A && B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || c) != d'\'''

echo '$ diff-expr '\''((A && B) || c) != d'\'' '\''(A && B || c) != d'\'''
diff-expr '((A && B) || c) != d' '(A && B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || c) != d'\'' '\''(A && B || c) != d'\'''

echo '$ test-expr '\''((A && B) || c) != D'\'''
test-expr '((A && B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || c) != D'\'''

echo '$ diff-expr '\''((A && B) || c) != D'\'' '\''(A && B || c) != D'\'''
diff-expr '((A && B) || c) != D' '(A && B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || c) != D'\'' '\''(A && B || c) != D'\'''

echo '$ test-expr '\''((A && B) || C) != d'\'''
test-expr '((A && B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || C) != d'\'''

echo '$ diff-expr '\''((A && B) || C) != d'\'' '\''(A && B || C) != d'\'''
diff-expr '((A && B) || C) != d' '(A && B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || C) != d'\'' '\''(A && B || C) != d'\'''

echo '$ test-expr '\''((A && B) || C) != D'\'''
test-expr '((A && B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''((A && B) || C) != D'\'''

echo '$ diff-expr '\''((A && B) || C) != D'\'' '\''(A && B || C) != D'\'''
diff-expr '((A && B) || C) != D' '(A && B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''((A && B) || C) != D'\'' '\''(A && B || C) != D'\'''

echo '$ test-expr '\''a != ((b && c) >= d)'\'''
test-expr 'a != ((b && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= d)'\'''

echo '$ diff-expr '\''a != ((b && c) >= d)'\'' '\''a != (b && c) >= d'\'''
diff-expr 'a != ((b && c) >= d)' 'a != (b && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) >= d)'\'' '\''a != (b && c) >= d'\'''

echo '$ test-expr '\''a != ((b && c) >= D)'\'''
test-expr 'a != ((b && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= D)'\'''

echo '$ diff-expr '\''a != ((b && c) >= D)'\'' '\''a != (b && c) >= D'\'''
diff-expr 'a != ((b && c) >= D)' 'a != (b && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) >= D)'\'' '\''a != (b && c) >= D'\'''

echo '$ test-expr '\''a != ((b && C) >= d)'\'''
test-expr 'a != ((b && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && C) >= d)'\'''

echo '$ diff-expr '\''a != ((b && C) >= d)'\'' '\''a != (b && C) >= d'\'''
diff-expr 'a != ((b && C) >= d)' 'a != (b && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && C) >= d)'\'' '\''a != (b && C) >= d'\'''

echo '$ test-expr '\''a != ((b && C) >= D)'\'''
test-expr 'a != ((b && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && C) >= D)'\'''

echo '$ diff-expr '\''a != ((b && C) >= D)'\'' '\''a != (b && C) >= D'\'''
diff-expr 'a != ((b && C) >= D)' 'a != (b && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && C) >= D)'\'' '\''a != (b && C) >= D'\'''

echo '$ test-expr '\''a != ((B && c) >= d)'\'''
test-expr 'a != ((B && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && c) >= d)'\'''

echo '$ diff-expr '\''a != ((B && c) >= d)'\'' '\''a != (B && c) >= d'\'''
diff-expr 'a != ((B && c) >= d)' 'a != (B && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && c) >= d)'\'' '\''a != (B && c) >= d'\'''

echo '$ test-expr '\''a != ((B && c) >= D)'\'''
test-expr 'a != ((B && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && c) >= D)'\'''

echo '$ diff-expr '\''a != ((B && c) >= D)'\'' '\''a != (B && c) >= D'\'''
diff-expr 'a != ((B && c) >= D)' 'a != (B && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && c) >= D)'\'' '\''a != (B && c) >= D'\'''

echo '$ test-expr '\''a != ((B && C) >= d)'\'''
test-expr 'a != ((B && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && C) >= d)'\'''

echo '$ diff-expr '\''a != ((B && C) >= d)'\'' '\''a != (B && C) >= d'\'''
diff-expr 'a != ((B && C) >= d)' 'a != (B && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && C) >= d)'\'' '\''a != (B && C) >= d'\'''

echo '$ test-expr '\''a != ((B && C) >= D)'\'''
test-expr 'a != ((B && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B && C) >= D)'\'''

echo '$ diff-expr '\''a != ((B && C) >= D)'\'' '\''a != (B && C) >= D'\'''
diff-expr 'a != ((B && C) >= D)' 'a != (B && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B && C) >= D)'\'' '\''a != (B && C) >= D'\'''

echo '$ test-expr '\''A != ((b && c) >= d)'\'''
test-expr 'A != ((b && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && c) >= d)'\'''

echo '$ diff-expr '\''A != ((b && c) >= d)'\'' '\''A != (b && c) >= d'\'''
diff-expr 'A != ((b && c) >= d)' 'A != (b && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && c) >= d)'\'' '\''A != (b && c) >= d'\'''

echo '$ test-expr '\''A != ((b && c) >= D)'\'''
test-expr 'A != ((b && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && c) >= D)'\'''

echo '$ diff-expr '\''A != ((b && c) >= D)'\'' '\''A != (b && c) >= D'\'''
diff-expr 'A != ((b && c) >= D)' 'A != (b && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && c) >= D)'\'' '\''A != (b && c) >= D'\'''

echo '$ test-expr '\''A != ((b && C) >= d)'\'''
test-expr 'A != ((b && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && C) >= d)'\'''

echo '$ diff-expr '\''A != ((b && C) >= d)'\'' '\''A != (b && C) >= d'\'''
diff-expr 'A != ((b && C) >= d)' 'A != (b && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && C) >= d)'\'' '\''A != (b && C) >= d'\'''

echo '$ test-expr '\''A != ((b && C) >= D)'\'''
test-expr 'A != ((b && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b && C) >= D)'\'''

echo '$ diff-expr '\''A != ((b && C) >= D)'\'' '\''A != (b && C) >= D'\'''
diff-expr 'A != ((b && C) >= D)' 'A != (b && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b && C) >= D)'\'' '\''A != (b && C) >= D'\'''

echo '$ test-expr '\''A != ((B && c) >= d)'\'''
test-expr 'A != ((B && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && c) >= d)'\'''

echo '$ diff-expr '\''A != ((B && c) >= d)'\'' '\''A != (B && c) >= d'\'''
diff-expr 'A != ((B && c) >= d)' 'A != (B && c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && c) >= d)'\'' '\''A != (B && c) >= d'\'''

echo '$ test-expr '\''A != ((B && c) >= D)'\'''
test-expr 'A != ((B && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && c) >= D)'\'''

echo '$ diff-expr '\''A != ((B && c) >= D)'\'' '\''A != (B && c) >= D'\'''
diff-expr 'A != ((B && c) >= D)' 'A != (B && c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && c) >= D)'\'' '\''A != (B && c) >= D'\'''

echo '$ test-expr '\''A != ((B && C) >= d)'\'''
test-expr 'A != ((B && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && C) >= d)'\'''

echo '$ diff-expr '\''A != ((B && C) >= d)'\'' '\''A != (B && C) >= d'\'''
diff-expr 'A != ((B && C) >= d)' 'A != (B && C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && C) >= d)'\'' '\''A != (B && C) >= d'\'''

echo '$ test-expr '\''A != ((B && C) >= D)'\'''
test-expr 'A != ((B && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B && C) >= D)'\'''

echo '$ diff-expr '\''A != ((B && C) >= D)'\'' '\''A != (B && C) >= D'\'''
diff-expr 'A != ((B && C) >= D)' 'A != (B && C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B && C) >= D)'\'' '\''A != (B && C) >= D'\'''

echo '$ test-expr '\''a != ((b || c) >= d)'\'''
test-expr 'a != ((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= d)'\'''

echo '$ diff-expr '\''a != ((b || c) >= d)'\'' '\''a != (b || c) >= d'\'''
diff-expr 'a != ((b || c) >= d)' 'a != (b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || c) >= d)'\'' '\''a != (b || c) >= d'\'''

echo '$ test-expr '\''a != ((b || c) >= D)'\'''
test-expr 'a != ((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= D)'\'''

echo '$ diff-expr '\''a != ((b || c) >= D)'\'' '\''a != (b || c) >= D'\'''
diff-expr 'a != ((b || c) >= D)' 'a != (b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || c) >= D)'\'' '\''a != (b || c) >= D'\'''

echo '$ test-expr '\''a != ((b || C) >= d)'\'''
test-expr 'a != ((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || C) >= d)'\'''

echo '$ diff-expr '\''a != ((b || C) >= d)'\'' '\''a != (b || C) >= d'\'''
diff-expr 'a != ((b || C) >= d)' 'a != (b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || C) >= d)'\'' '\''a != (b || C) >= d'\'''

echo '$ test-expr '\''a != ((b || C) >= D)'\'''
test-expr 'a != ((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || C) >= D)'\'''

echo '$ diff-expr '\''a != ((b || C) >= D)'\'' '\''a != (b || C) >= D'\'''
diff-expr 'a != ((b || C) >= D)' 'a != (b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || C) >= D)'\'' '\''a != (b || C) >= D'\'''

echo '$ test-expr '\''a != ((B || c) >= d)'\'''
test-expr 'a != ((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || c) >= d)'\'''

echo '$ diff-expr '\''a != ((B || c) >= d)'\'' '\''a != (B || c) >= d'\'''
diff-expr 'a != ((B || c) >= d)' 'a != (B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B || c) >= d)'\'' '\''a != (B || c) >= d'\'''

echo '$ test-expr '\''a != ((B || c) >= D)'\'''
test-expr 'a != ((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || c) >= D)'\'''

echo '$ diff-expr '\''a != ((B || c) >= D)'\'' '\''a != (B || c) >= D'\'''
diff-expr 'a != ((B || c) >= D)' 'a != (B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B || c) >= D)'\'' '\''a != (B || c) >= D'\'''

echo '$ test-expr '\''a != ((B || C) >= d)'\'''
test-expr 'a != ((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || C) >= d)'\'''

echo '$ diff-expr '\''a != ((B || C) >= d)'\'' '\''a != (B || C) >= d'\'''
diff-expr 'a != ((B || C) >= d)' 'a != (B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B || C) >= d)'\'' '\''a != (B || C) >= d'\'''

echo '$ test-expr '\''a != ((B || C) >= D)'\'''
test-expr 'a != ((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((B || C) >= D)'\'''

echo '$ diff-expr '\''a != ((B || C) >= D)'\'' '\''a != (B || C) >= D'\'''
diff-expr 'a != ((B || C) >= D)' 'a != (B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((B || C) >= D)'\'' '\''a != (B || C) >= D'\'''

echo '$ test-expr '\''A != ((b || c) >= d)'\'''
test-expr 'A != ((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || c) >= d)'\'''

echo '$ diff-expr '\''A != ((b || c) >= d)'\'' '\''A != (b || c) >= d'\'''
diff-expr 'A != ((b || c) >= d)' 'A != (b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b || c) >= d)'\'' '\''A != (b || c) >= d'\'''

echo '$ test-expr '\''A != ((b || c) >= D)'\'''
test-expr 'A != ((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || c) >= D)'\'''

echo '$ diff-expr '\''A != ((b || c) >= D)'\'' '\''A != (b || c) >= D'\'''
diff-expr 'A != ((b || c) >= D)' 'A != (b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b || c) >= D)'\'' '\''A != (b || c) >= D'\'''

echo '$ test-expr '\''A != ((b || C) >= d)'\'''
test-expr 'A != ((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || C) >= d)'\'''

echo '$ diff-expr '\''A != ((b || C) >= d)'\'' '\''A != (b || C) >= d'\'''
diff-expr 'A != ((b || C) >= d)' 'A != (b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b || C) >= d)'\'' '\''A != (b || C) >= d'\'''

echo '$ test-expr '\''A != ((b || C) >= D)'\'''
test-expr 'A != ((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((b || C) >= D)'\'''

echo '$ diff-expr '\''A != ((b || C) >= D)'\'' '\''A != (b || C) >= D'\'''
diff-expr 'A != ((b || C) >= D)' 'A != (b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((b || C) >= D)'\'' '\''A != (b || C) >= D'\'''

echo '$ test-expr '\''A != ((B || c) >= d)'\'''
test-expr 'A != ((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || c) >= d)'\'''

echo '$ diff-expr '\''A != ((B || c) >= d)'\'' '\''A != (B || c) >= d'\'''
diff-expr 'A != ((B || c) >= d)' 'A != (B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B || c) >= d)'\'' '\''A != (B || c) >= d'\'''

echo '$ test-expr '\''A != ((B || c) >= D)'\'''
test-expr 'A != ((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || c) >= D)'\'''

echo '$ diff-expr '\''A != ((B || c) >= D)'\'' '\''A != (B || c) >= D'\'''
diff-expr 'A != ((B || c) >= D)' 'A != (B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B || c) >= D)'\'' '\''A != (B || c) >= D'\'''

echo '$ test-expr '\''A != ((B || C) >= d)'\'''
test-expr 'A != ((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || C) >= d)'\'''

echo '$ diff-expr '\''A != ((B || C) >= d)'\'' '\''A != (B || C) >= d'\'''
diff-expr 'A != ((B || C) >= d)' 'A != (B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B || C) >= d)'\'' '\''A != (B || C) >= d'\'''

echo '$ test-expr '\''A != ((B || C) >= D)'\'''
test-expr 'A != ((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != ((B || C) >= D)'\'''

echo '$ diff-expr '\''A != ((B || C) >= D)'\'' '\''A != (B || C) >= D'\'''
diff-expr 'A != ((B || C) >= D)' 'A != (B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A != ((B || C) >= D)'\'' '\''A != (B || C) >= D'\'''

echo '$ test-expr '\''a && ((b || c) >= d)'\'''
test-expr 'a && ((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= d)'\'''

echo '$ diff-expr '\''a && ((b || c) >= d)'\'' '\''a && (b || c) >= d'\'''
diff-expr 'a && ((b || c) >= d)' 'a && (b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) >= d)'\'' '\''a && (b || c) >= d'\'''

echo '$ test-expr '\''a && ((b || c) >= D)'\'''
test-expr 'a && ((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= D)'\'''

echo '$ diff-expr '\''a && ((b || c) >= D)'\'' '\''a && (b || c) >= D'\'''
diff-expr 'a && ((b || c) >= D)' 'a && (b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) >= D)'\'' '\''a && (b || c) >= D'\'''

echo '$ test-expr '\''a && ((b || C) >= d)'\'''
test-expr 'a && ((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || C) >= d)'\'''

echo '$ diff-expr '\''a && ((b || C) >= d)'\'' '\''a && (b || C) >= d'\'''
diff-expr 'a && ((b || C) >= d)' 'a && (b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || C) >= d)'\'' '\''a && (b || C) >= d'\'''

echo '$ test-expr '\''a && ((b || C) >= D)'\'''
test-expr 'a && ((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || C) >= D)'\'''

echo '$ diff-expr '\''a && ((b || C) >= D)'\'' '\''a && (b || C) >= D'\'''
diff-expr 'a && ((b || C) >= D)' 'a && (b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || C) >= D)'\'' '\''a && (b || C) >= D'\'''

echo '$ test-expr '\''a && ((B || c) >= d)'\'''
test-expr 'a && ((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || c) >= d)'\'''

echo '$ diff-expr '\''a && ((B || c) >= d)'\'' '\''a && (B || c) >= d'\'''
diff-expr 'a && ((B || c) >= d)' 'a && (B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || c) >= d)'\'' '\''a && (B || c) >= d'\'''

echo '$ test-expr '\''a && ((B || c) >= D)'\'''
test-expr 'a && ((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || c) >= D)'\'''

echo '$ diff-expr '\''a && ((B || c) >= D)'\'' '\''a && (B || c) >= D'\'''
diff-expr 'a && ((B || c) >= D)' 'a && (B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || c) >= D)'\'' '\''a && (B || c) >= D'\'''

echo '$ test-expr '\''a && ((B || C) >= d)'\'''
test-expr 'a && ((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || C) >= d)'\'''

echo '$ diff-expr '\''a && ((B || C) >= d)'\'' '\''a && (B || C) >= d'\'''
diff-expr 'a && ((B || C) >= d)' 'a && (B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || C) >= d)'\'' '\''a && (B || C) >= d'\'''

echo '$ test-expr '\''a && ((B || C) >= D)'\'''
test-expr 'a && ((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || C) >= D)'\'''

echo '$ diff-expr '\''a && ((B || C) >= D)'\'' '\''a && (B || C) >= D'\'''
diff-expr 'a && ((B || C) >= D)' 'a && (B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || C) >= D)'\'' '\''a && (B || C) >= D'\'''

echo '$ test-expr '\''A && ((b || c) >= d)'\'''
test-expr 'A && ((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || c) >= d)'\'''

echo '$ diff-expr '\''A && ((b || c) >= d)'\'' '\''A && (b || c) >= d'\'''
diff-expr 'A && ((b || c) >= d)' 'A && (b || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || c) >= d)'\'' '\''A && (b || c) >= d'\'''

echo '$ test-expr '\''A && ((b || c) >= D)'\'''
test-expr 'A && ((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || c) >= D)'\'''

echo '$ diff-expr '\''A && ((b || c) >= D)'\'' '\''A && (b || c) >= D'\'''
diff-expr 'A && ((b || c) >= D)' 'A && (b || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || c) >= D)'\'' '\''A && (b || c) >= D'\'''

echo '$ test-expr '\''A && ((b || C) >= d)'\'''
test-expr 'A && ((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || C) >= d)'\'''

echo '$ diff-expr '\''A && ((b || C) >= d)'\'' '\''A && (b || C) >= d'\'''
diff-expr 'A && ((b || C) >= d)' 'A && (b || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || C) >= d)'\'' '\''A && (b || C) >= d'\'''

echo '$ test-expr '\''A && ((b || C) >= D)'\'''
test-expr 'A && ((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || C) >= D)'\'''

echo '$ diff-expr '\''A && ((b || C) >= D)'\'' '\''A && (b || C) >= D'\'''
diff-expr 'A && ((b || C) >= D)' 'A && (b || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || C) >= D)'\'' '\''A && (b || C) >= D'\'''

echo '$ test-expr '\''A && ((B || c) >= d)'\'''
test-expr 'A && ((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || c) >= d)'\'''

echo '$ diff-expr '\''A && ((B || c) >= d)'\'' '\''A && (B || c) >= d'\'''
diff-expr 'A && ((B || c) >= d)' 'A && (B || c) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || c) >= d)'\'' '\''A && (B || c) >= d'\'''

echo '$ test-expr '\''A && ((B || c) >= D)'\'''
test-expr 'A && ((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || c) >= D)'\'''

echo '$ diff-expr '\''A && ((B || c) >= D)'\'' '\''A && (B || c) >= D'\'''
diff-expr 'A && ((B || c) >= D)' 'A && (B || c) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || c) >= D)'\'' '\''A && (B || c) >= D'\'''

echo '$ test-expr '\''A && ((B || C) >= d)'\'''
test-expr 'A && ((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || C) >= d)'\'''

echo '$ diff-expr '\''A && ((B || C) >= d)'\'' '\''A && (B || C) >= d'\'''
diff-expr 'A && ((B || C) >= d)' 'A && (B || C) >= d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || C) >= d)'\'' '\''A && (B || C) >= d'\'''

echo '$ test-expr '\''A && ((B || C) >= D)'\'''
test-expr 'A && ((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || C) >= D)'\'''

echo '$ diff-expr '\''A && ((B || C) >= D)'\'' '\''A && (B || C) >= D'\'''
diff-expr 'A && ((B || C) >= D)' 'A && (B || C) >= D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || C) >= D)'\'' '\''A && (B || C) >= D'\'''

echo '$ test-expr '\''a && ((b || c) != d)'\'''
test-expr 'a && ((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != d)'\'''

echo '$ diff-expr '\''a && ((b || c) != d)'\'' '\''a && (b || c) != d'\'''
diff-expr 'a && ((b || c) != d)' 'a && (b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) != d)'\'' '\''a && (b || c) != d'\'''

echo '$ test-expr '\''a && ((b || c) != D)'\'''
test-expr 'a && ((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != D)'\'''

echo '$ diff-expr '\''a && ((b || c) != D)'\'' '\''a && (b || c) != D'\'''
diff-expr 'a && ((b || c) != D)' 'a && (b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) != D)'\'' '\''a && (b || c) != D'\'''

echo '$ test-expr '\''a && ((b || C) != d)'\'''
test-expr 'a && ((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || C) != d)'\'''

echo '$ diff-expr '\''a && ((b || C) != d)'\'' '\''a && (b || C) != d'\'''
diff-expr 'a && ((b || C) != d)' 'a && (b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || C) != d)'\'' '\''a && (b || C) != d'\'''

echo '$ test-expr '\''a && ((b || C) != D)'\'''
test-expr 'a && ((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || C) != D)'\'''

echo '$ diff-expr '\''a && ((b || C) != D)'\'' '\''a && (b || C) != D'\'''
diff-expr 'a && ((b || C) != D)' 'a && (b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || C) != D)'\'' '\''a && (b || C) != D'\'''

echo '$ test-expr '\''a && ((B || c) != d)'\'''
test-expr 'a && ((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || c) != d)'\'''

echo '$ diff-expr '\''a && ((B || c) != d)'\'' '\''a && (B || c) != d'\'''
diff-expr 'a && ((B || c) != d)' 'a && (B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || c) != d)'\'' '\''a && (B || c) != d'\'''

echo '$ test-expr '\''a && ((B || c) != D)'\'''
test-expr 'a && ((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || c) != D)'\'''

echo '$ diff-expr '\''a && ((B || c) != D)'\'' '\''a && (B || c) != D'\'''
diff-expr 'a && ((B || c) != D)' 'a && (B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || c) != D)'\'' '\''a && (B || c) != D'\'''

echo '$ test-expr '\''a && ((B || C) != d)'\'''
test-expr 'a && ((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || C) != d)'\'''

echo '$ diff-expr '\''a && ((B || C) != d)'\'' '\''a && (B || C) != d'\'''
diff-expr 'a && ((B || C) != d)' 'a && (B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || C) != d)'\'' '\''a && (B || C) != d'\'''

echo '$ test-expr '\''a && ((B || C) != D)'\'''
test-expr 'a && ((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((B || C) != D)'\'''

echo '$ diff-expr '\''a && ((B || C) != D)'\'' '\''a && (B || C) != D'\'''
diff-expr 'a && ((B || C) != D)' 'a && (B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((B || C) != D)'\'' '\''a && (B || C) != D'\'''

echo '$ test-expr '\''A && ((b || c) != d)'\'''
test-expr 'A && ((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || c) != d)'\'''

echo '$ diff-expr '\''A && ((b || c) != d)'\'' '\''A && (b || c) != d'\'''
diff-expr 'A && ((b || c) != d)' 'A && (b || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || c) != d)'\'' '\''A && (b || c) != d'\'''

echo '$ test-expr '\''A && ((b || c) != D)'\'''
test-expr 'A && ((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || c) != D)'\'''

echo '$ diff-expr '\''A && ((b || c) != D)'\'' '\''A && (b || c) != D'\'''
diff-expr 'A && ((b || c) != D)' 'A && (b || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || c) != D)'\'' '\''A && (b || c) != D'\'''

echo '$ test-expr '\''A && ((b || C) != d)'\'''
test-expr 'A && ((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || C) != d)'\'''

echo '$ diff-expr '\''A && ((b || C) != d)'\'' '\''A && (b || C) != d'\'''
diff-expr 'A && ((b || C) != d)' 'A && (b || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || C) != d)'\'' '\''A && (b || C) != d'\'''

echo '$ test-expr '\''A && ((b || C) != D)'\'''
test-expr 'A && ((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((b || C) != D)'\'''

echo '$ diff-expr '\''A && ((b || C) != D)'\'' '\''A && (b || C) != D'\'''
diff-expr 'A && ((b || C) != D)' 'A && (b || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((b || C) != D)'\'' '\''A && (b || C) != D'\'''

echo '$ test-expr '\''A && ((B || c) != d)'\'''
test-expr 'A && ((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || c) != d)'\'''

echo '$ diff-expr '\''A && ((B || c) != d)'\'' '\''A && (B || c) != d'\'''
diff-expr 'A && ((B || c) != d)' 'A && (B || c) != d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || c) != d)'\'' '\''A && (B || c) != d'\'''

echo '$ test-expr '\''A && ((B || c) != D)'\'''
test-expr 'A && ((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || c) != D)'\'''

echo '$ diff-expr '\''A && ((B || c) != D)'\'' '\''A && (B || c) != D'\'''
diff-expr 'A && ((B || c) != D)' 'A && (B || c) != D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || c) != D)'\'' '\''A && (B || c) != D'\'''

echo '$ test-expr '\''A && ((B || C) != d)'\'''
test-expr 'A && ((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || C) != d)'\'''

echo '$ diff-expr '\''A && ((B || C) != d)'\'' '\''A && (B || C) != d'\'''
diff-expr 'A && ((B || C) != d)' 'A && (B || C) != d' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || C) != d)'\'' '\''A && (B || C) != d'\'''

echo '$ test-expr '\''A && ((B || C) != D)'\'''
test-expr 'A && ((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && ((B || C) != D)'\'''

echo '$ diff-expr '\''A && ((B || C) != D)'\'' '\''A && (B || C) != D'\'''
diff-expr 'A && ((B || C) != D)' 'A && (B || C) != D' 2>&1 ||
echo 'command failed: diff-expr '\''A && ((B || C) != D)'\'' '\''A && (B || C) != D'\'''

echo '$ test-expr '\''(a != (b && c)) >= d'\'''
test-expr '(a != (b && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && c)) >= d'\'''

echo '$ test-expr '\''(a != (b && c)) >= D'\'''
test-expr '(a != (b && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && c)) >= D'\'''

echo '$ test-expr '\''(a != (b && C)) >= d'\'''
test-expr '(a != (b && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && C)) >= d'\'''

echo '$ test-expr '\''(a != (b && C)) >= D'\'''
test-expr '(a != (b && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && C)) >= D'\'''

echo '$ test-expr '\''(a != (B && c)) >= d'\'''
test-expr '(a != (B && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && c)) >= d'\'''

echo '$ test-expr '\''(a != (B && c)) >= D'\'''
test-expr '(a != (B && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && c)) >= D'\'''

echo '$ test-expr '\''(a != (B && C)) >= d'\'''
test-expr '(a != (B && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && C)) >= d'\'''

echo '$ test-expr '\''(a != (B && C)) >= D'\'''
test-expr '(a != (B && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B && C)) >= D'\'''

echo '$ test-expr '\''(A != (b && c)) >= d'\'''
test-expr '(A != (b && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && c)) >= d'\'''

echo '$ test-expr '\''(A != (b && c)) >= D'\'''
test-expr '(A != (b && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && c)) >= D'\'''

echo '$ test-expr '\''(A != (b && C)) >= d'\'''
test-expr '(A != (b && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && C)) >= d'\'''

echo '$ test-expr '\''(A != (b && C)) >= D'\'''
test-expr '(A != (b && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b && C)) >= D'\'''

echo '$ test-expr '\''(A != (B && c)) >= d'\'''
test-expr '(A != (B && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && c)) >= d'\'''

echo '$ test-expr '\''(A != (B && c)) >= D'\'''
test-expr '(A != (B && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && c)) >= D'\'''

echo '$ test-expr '\''(A != (B && C)) >= d'\'''
test-expr '(A != (B && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && C)) >= d'\'''

echo '$ test-expr '\''(A != (B && C)) >= D'\'''
test-expr '(A != (B && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B && C)) >= D'\'''

echo '$ test-expr '\''(a != (b || c)) >= d'\'''
test-expr '(a != (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || c)) >= d'\'''

echo '$ test-expr '\''(a != (b || c)) >= D'\'''
test-expr '(a != (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || c)) >= D'\'''

echo '$ test-expr '\''(a != (b || C)) >= d'\'''
test-expr '(a != (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || C)) >= d'\'''

echo '$ test-expr '\''(a != (b || C)) >= D'\'''
test-expr '(a != (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || C)) >= D'\'''

echo '$ test-expr '\''(a != (B || c)) >= d'\'''
test-expr '(a != (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || c)) >= d'\'''

echo '$ test-expr '\''(a != (B || c)) >= D'\'''
test-expr '(a != (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || c)) >= D'\'''

echo '$ test-expr '\''(a != (B || C)) >= d'\'''
test-expr '(a != (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || C)) >= d'\'''

echo '$ test-expr '\''(a != (B || C)) >= D'\'''
test-expr '(a != (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a != (B || C)) >= D'\'''

echo '$ test-expr '\''(A != (b || c)) >= d'\'''
test-expr '(A != (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || c)) >= d'\'''

echo '$ test-expr '\''(A != (b || c)) >= D'\'''
test-expr '(A != (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || c)) >= D'\'''

echo '$ test-expr '\''(A != (b || C)) >= d'\'''
test-expr '(A != (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || C)) >= d'\'''

echo '$ test-expr '\''(A != (b || C)) >= D'\'''
test-expr '(A != (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (b || C)) >= D'\'''

echo '$ test-expr '\''(A != (B || c)) >= d'\'''
test-expr '(A != (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || c)) >= d'\'''

echo '$ test-expr '\''(A != (B || c)) >= D'\'''
test-expr '(A != (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || c)) >= D'\'''

echo '$ test-expr '\''(A != (B || C)) >= d'\'''
test-expr '(A != (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || C)) >= d'\'''

echo '$ test-expr '\''(A != (B || C)) >= D'\'''
test-expr '(A != (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A != (B || C)) >= D'\'''

echo '$ test-expr '\''(a && (b || c)) >= d'\'''
test-expr '(a && (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || c)) >= d'\'''

echo '$ test-expr '\''(a && (b || c)) >= D'\'''
test-expr '(a && (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || c)) >= D'\'''

echo '$ test-expr '\''(a && (b || C)) >= d'\'''
test-expr '(a && (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || C)) >= d'\'''

echo '$ test-expr '\''(a && (b || C)) >= D'\'''
test-expr '(a && (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || C)) >= D'\'''

echo '$ test-expr '\''(a && (B || c)) >= d'\'''
test-expr '(a && (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || c)) >= d'\'''

echo '$ test-expr '\''(a && (B || c)) >= D'\'''
test-expr '(a && (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || c)) >= D'\'''

echo '$ test-expr '\''(a && (B || C)) >= d'\'''
test-expr '(a && (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || C)) >= d'\'''

echo '$ test-expr '\''(a && (B || C)) >= D'\'''
test-expr '(a && (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || C)) >= D'\'''

echo '$ test-expr '\''(A && (b || c)) >= d'\'''
test-expr '(A && (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || c)) >= d'\'''

echo '$ test-expr '\''(A && (b || c)) >= D'\'''
test-expr '(A && (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || c)) >= D'\'''

echo '$ test-expr '\''(A && (b || C)) >= d'\'''
test-expr '(A && (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || C)) >= d'\'''

echo '$ test-expr '\''(A && (b || C)) >= D'\'''
test-expr '(A && (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || C)) >= D'\'''

echo '$ test-expr '\''(A && (B || c)) >= d'\'''
test-expr '(A && (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || c)) >= d'\'''

echo '$ test-expr '\''(A && (B || c)) >= D'\'''
test-expr '(A && (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || c)) >= D'\'''

echo '$ test-expr '\''(A && (B || C)) >= d'\'''
test-expr '(A && (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || C)) >= d'\'''

echo '$ test-expr '\''(A && (B || C)) >= D'\'''
test-expr '(A && (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || C)) >= D'\'''

echo '$ test-expr '\''(a && (b || c)) != d'\'''
test-expr '(a && (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || c)) != d'\'''

echo '$ test-expr '\''(a && (b || c)) != D'\'''
test-expr '(a && (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || c)) != D'\'''

echo '$ test-expr '\''(a && (b || C)) != d'\'''
test-expr '(a && (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || C)) != d'\'''

echo '$ test-expr '\''(a && (b || C)) != D'\'''
test-expr '(a && (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || C)) != D'\'''

echo '$ test-expr '\''(a && (B || c)) != d'\'''
test-expr '(a && (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || c)) != d'\'''

echo '$ test-expr '\''(a && (B || c)) != D'\'''
test-expr '(a && (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || c)) != D'\'''

echo '$ test-expr '\''(a && (B || C)) != d'\'''
test-expr '(a && (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || C)) != d'\'''

echo '$ test-expr '\''(a && (B || C)) != D'\'''
test-expr '(a && (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(a && (B || C)) != D'\'''

echo '$ test-expr '\''(A && (b || c)) != d'\'''
test-expr '(A && (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || c)) != d'\'''

echo '$ test-expr '\''(A && (b || c)) != D'\'''
test-expr '(A && (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || c)) != D'\'''

echo '$ test-expr '\''(A && (b || C)) != d'\'''
test-expr '(A && (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || C)) != d'\'''

echo '$ test-expr '\''(A && (b || C)) != D'\'''
test-expr '(A && (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (b || C)) != D'\'''

echo '$ test-expr '\''(A && (B || c)) != d'\'''
test-expr '(A && (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || c)) != d'\'''

echo '$ test-expr '\''(A && (B || c)) != D'\'''
test-expr '(A && (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || c)) != D'\'''

echo '$ test-expr '\''(A && (B || C)) != d'\'''
test-expr '(A && (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || C)) != d'\'''

echo '$ test-expr '\''(A && (B || C)) != D'\'''
test-expr '(A && (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''(A && (B || C)) != D'\'''

echo '$ test-expr '\''(a != b) && (c >= d)'\'''
test-expr '(a != b) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (c >= d)'\'''

echo '$ diff-expr '\''(a != b) && (c >= d)'\'' '\''a != b && (c >= d)'\'''
diff-expr '(a != b) && (c >= d)' 'a != b && (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= d)'\'' '\''a != b && (c >= d)'\'''

echo '$ diff-expr '\''(a != b) && (c >= d)'\'' '\''a != b && c >= d'\'''
diff-expr '(a != b) && (c >= d)' 'a != b && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= d)'\'' '\''a != b && c >= d'\'''

echo '$ diff-expr '\''(a != b) && (c >= d)'\'' '\''(a != b) && c >= d'\'''
diff-expr '(a != b) && (c >= d)' '(a != b) && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= d)'\'' '\''(a != b) && c >= d'\'''

echo '$ test-expr '\''(a != b) && (c >= D)'\'''
test-expr '(a != b) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (c >= D)'\'''

echo '$ diff-expr '\''(a != b) && (c >= D)'\'' '\''a != b && (c >= D)'\'''
diff-expr '(a != b) && (c >= D)' 'a != b && (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= D)'\'' '\''a != b && (c >= D)'\'''

echo '$ diff-expr '\''(a != b) && (c >= D)'\'' '\''a != b && c >= D'\'''
diff-expr '(a != b) && (c >= D)' 'a != b && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= D)'\'' '\''a != b && c >= D'\'''

echo '$ diff-expr '\''(a != b) && (c >= D)'\'' '\''(a != b) && c >= D'\'''
diff-expr '(a != b) && (c >= D)' '(a != b) && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= D)'\'' '\''(a != b) && c >= D'\'''

echo '$ test-expr '\''(a != b) && (C >= d)'\'''
test-expr '(a != b) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (C >= d)'\'''

echo '$ diff-expr '\''(a != b) && (C >= d)'\'' '\''a != b && (C >= d)'\'''
diff-expr '(a != b) && (C >= d)' 'a != b && (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C >= d)'\'' '\''a != b && (C >= d)'\'''

echo '$ diff-expr '\''(a != b) && (C >= d)'\'' '\''a != b && C >= d'\'''
diff-expr '(a != b) && (C >= d)' 'a != b && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C >= d)'\'' '\''a != b && C >= d'\'''

echo '$ diff-expr '\''(a != b) && (C >= d)'\'' '\''(a != b) && C >= d'\'''
diff-expr '(a != b) && (C >= d)' '(a != b) && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C >= d)'\'' '\''(a != b) && C >= d'\'''

echo '$ test-expr '\''(a != b) && (C >= D)'\'''
test-expr '(a != b) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (C >= D)'\'''

echo '$ diff-expr '\''(a != b) && (C >= D)'\'' '\''a != b && (C >= D)'\'''
diff-expr '(a != b) && (C >= D)' 'a != b && (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C >= D)'\'' '\''a != b && (C >= D)'\'''

echo '$ diff-expr '\''(a != b) && (C >= D)'\'' '\''a != b && C >= D'\'''
diff-expr '(a != b) && (C >= D)' 'a != b && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C >= D)'\'' '\''a != b && C >= D'\'''

echo '$ diff-expr '\''(a != b) && (C >= D)'\'' '\''(a != b) && C >= D'\'''
diff-expr '(a != b) && (C >= D)' '(a != b) && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (C >= D)'\'' '\''(a != b) && C >= D'\'''

echo '$ test-expr '\''(a != B) && (c >= d)'\'''
test-expr '(a != B) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (c >= d)'\'''

echo '$ diff-expr '\''(a != B) && (c >= d)'\'' '\''a != B && (c >= d)'\'''
diff-expr '(a != B) && (c >= d)' 'a != B && (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c >= d)'\'' '\''a != B && (c >= d)'\'''

echo '$ diff-expr '\''(a != B) && (c >= d)'\'' '\''a != B && c >= d'\'''
diff-expr '(a != B) && (c >= d)' 'a != B && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c >= d)'\'' '\''a != B && c >= d'\'''

echo '$ diff-expr '\''(a != B) && (c >= d)'\'' '\''(a != B) && c >= d'\'''
diff-expr '(a != B) && (c >= d)' '(a != B) && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c >= d)'\'' '\''(a != B) && c >= d'\'''

echo '$ test-expr '\''(a != B) && (c >= D)'\'''
test-expr '(a != B) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (c >= D)'\'''

echo '$ diff-expr '\''(a != B) && (c >= D)'\'' '\''a != B && (c >= D)'\'''
diff-expr '(a != B) && (c >= D)' 'a != B && (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c >= D)'\'' '\''a != B && (c >= D)'\'''

echo '$ diff-expr '\''(a != B) && (c >= D)'\'' '\''a != B && c >= D'\'''
diff-expr '(a != B) && (c >= D)' 'a != B && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c >= D)'\'' '\''a != B && c >= D'\'''

echo '$ diff-expr '\''(a != B) && (c >= D)'\'' '\''(a != B) && c >= D'\'''
diff-expr '(a != B) && (c >= D)' '(a != B) && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (c >= D)'\'' '\''(a != B) && c >= D'\'''

echo '$ test-expr '\''(a != B) && (C >= d)'\'''
test-expr '(a != B) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (C >= d)'\'''

echo '$ diff-expr '\''(a != B) && (C >= d)'\'' '\''a != B && (C >= d)'\'''
diff-expr '(a != B) && (C >= d)' 'a != B && (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C >= d)'\'' '\''a != B && (C >= d)'\'''

echo '$ diff-expr '\''(a != B) && (C >= d)'\'' '\''a != B && C >= d'\'''
diff-expr '(a != B) && (C >= d)' 'a != B && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C >= d)'\'' '\''a != B && C >= d'\'''

echo '$ diff-expr '\''(a != B) && (C >= d)'\'' '\''(a != B) && C >= d'\'''
diff-expr '(a != B) && (C >= d)' '(a != B) && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C >= d)'\'' '\''(a != B) && C >= d'\'''

echo '$ test-expr '\''(a != B) && (C >= D)'\'''
test-expr '(a != B) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) && (C >= D)'\'''

echo '$ diff-expr '\''(a != B) && (C >= D)'\'' '\''a != B && (C >= D)'\'''
diff-expr '(a != B) && (C >= D)' 'a != B && (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C >= D)'\'' '\''a != B && (C >= D)'\'''

echo '$ diff-expr '\''(a != B) && (C >= D)'\'' '\''a != B && C >= D'\'''
diff-expr '(a != B) && (C >= D)' 'a != B && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C >= D)'\'' '\''a != B && C >= D'\'''

echo '$ diff-expr '\''(a != B) && (C >= D)'\'' '\''(a != B) && C >= D'\'''
diff-expr '(a != B) && (C >= D)' '(a != B) && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) && (C >= D)'\'' '\''(a != B) && C >= D'\'''

echo '$ test-expr '\''(A != b) && (c >= d)'\'''
test-expr '(A != b) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (c >= d)'\'''

echo '$ diff-expr '\''(A != b) && (c >= d)'\'' '\''A != b && (c >= d)'\'''
diff-expr '(A != b) && (c >= d)' 'A != b && (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c >= d)'\'' '\''A != b && (c >= d)'\'''

echo '$ diff-expr '\''(A != b) && (c >= d)'\'' '\''A != b && c >= d'\'''
diff-expr '(A != b) && (c >= d)' 'A != b && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c >= d)'\'' '\''A != b && c >= d'\'''

echo '$ diff-expr '\''(A != b) && (c >= d)'\'' '\''(A != b) && c >= d'\'''
diff-expr '(A != b) && (c >= d)' '(A != b) && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c >= d)'\'' '\''(A != b) && c >= d'\'''

echo '$ test-expr '\''(A != b) && (c >= D)'\'''
test-expr '(A != b) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (c >= D)'\'''

echo '$ diff-expr '\''(A != b) && (c >= D)'\'' '\''A != b && (c >= D)'\'''
diff-expr '(A != b) && (c >= D)' 'A != b && (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c >= D)'\'' '\''A != b && (c >= D)'\'''

echo '$ diff-expr '\''(A != b) && (c >= D)'\'' '\''A != b && c >= D'\'''
diff-expr '(A != b) && (c >= D)' 'A != b && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c >= D)'\'' '\''A != b && c >= D'\'''

echo '$ diff-expr '\''(A != b) && (c >= D)'\'' '\''(A != b) && c >= D'\'''
diff-expr '(A != b) && (c >= D)' '(A != b) && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (c >= D)'\'' '\''(A != b) && c >= D'\'''

echo '$ test-expr '\''(A != b) && (C >= d)'\'''
test-expr '(A != b) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (C >= d)'\'''

echo '$ diff-expr '\''(A != b) && (C >= d)'\'' '\''A != b && (C >= d)'\'''
diff-expr '(A != b) && (C >= d)' 'A != b && (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C >= d)'\'' '\''A != b && (C >= d)'\'''

echo '$ diff-expr '\''(A != b) && (C >= d)'\'' '\''A != b && C >= d'\'''
diff-expr '(A != b) && (C >= d)' 'A != b && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C >= d)'\'' '\''A != b && C >= d'\'''

echo '$ diff-expr '\''(A != b) && (C >= d)'\'' '\''(A != b) && C >= d'\'''
diff-expr '(A != b) && (C >= d)' '(A != b) && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C >= d)'\'' '\''(A != b) && C >= d'\'''

echo '$ test-expr '\''(A != b) && (C >= D)'\'''
test-expr '(A != b) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) && (C >= D)'\'''

echo '$ diff-expr '\''(A != b) && (C >= D)'\'' '\''A != b && (C >= D)'\'''
diff-expr '(A != b) && (C >= D)' 'A != b && (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C >= D)'\'' '\''A != b && (C >= D)'\'''

echo '$ diff-expr '\''(A != b) && (C >= D)'\'' '\''A != b && C >= D'\'''
diff-expr '(A != b) && (C >= D)' 'A != b && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C >= D)'\'' '\''A != b && C >= D'\'''

echo '$ diff-expr '\''(A != b) && (C >= D)'\'' '\''(A != b) && C >= D'\'''
diff-expr '(A != b) && (C >= D)' '(A != b) && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) && (C >= D)'\'' '\''(A != b) && C >= D'\'''

echo '$ test-expr '\''(A != B) && (c >= d)'\'''
test-expr '(A != B) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (c >= d)'\'''

echo '$ diff-expr '\''(A != B) && (c >= d)'\'' '\''A != B && (c >= d)'\'''
diff-expr '(A != B) && (c >= d)' 'A != B && (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c >= d)'\'' '\''A != B && (c >= d)'\'''

echo '$ diff-expr '\''(A != B) && (c >= d)'\'' '\''A != B && c >= d'\'''
diff-expr '(A != B) && (c >= d)' 'A != B && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c >= d)'\'' '\''A != B && c >= d'\'''

echo '$ diff-expr '\''(A != B) && (c >= d)'\'' '\''(A != B) && c >= d'\'''
diff-expr '(A != B) && (c >= d)' '(A != B) && c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c >= d)'\'' '\''(A != B) && c >= d'\'''

echo '$ test-expr '\''(A != B) && (c >= D)'\'''
test-expr '(A != B) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (c >= D)'\'''

echo '$ diff-expr '\''(A != B) && (c >= D)'\'' '\''A != B && (c >= D)'\'''
diff-expr '(A != B) && (c >= D)' 'A != B && (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c >= D)'\'' '\''A != B && (c >= D)'\'''

echo '$ diff-expr '\''(A != B) && (c >= D)'\'' '\''A != B && c >= D'\'''
diff-expr '(A != B) && (c >= D)' 'A != B && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c >= D)'\'' '\''A != B && c >= D'\'''

echo '$ diff-expr '\''(A != B) && (c >= D)'\'' '\''(A != B) && c >= D'\'''
diff-expr '(A != B) && (c >= D)' '(A != B) && c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (c >= D)'\'' '\''(A != B) && c >= D'\'''

echo '$ test-expr '\''(A != B) && (C >= d)'\'''
test-expr '(A != B) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (C >= d)'\'''

echo '$ diff-expr '\''(A != B) && (C >= d)'\'' '\''A != B && (C >= d)'\'''
diff-expr '(A != B) && (C >= d)' 'A != B && (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C >= d)'\'' '\''A != B && (C >= d)'\'''

echo '$ diff-expr '\''(A != B) && (C >= d)'\'' '\''A != B && C >= d'\'''
diff-expr '(A != B) && (C >= d)' 'A != B && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C >= d)'\'' '\''A != B && C >= d'\'''

echo '$ diff-expr '\''(A != B) && (C >= d)'\'' '\''(A != B) && C >= d'\'''
diff-expr '(A != B) && (C >= d)' '(A != B) && C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C >= d)'\'' '\''(A != B) && C >= d'\'''

echo '$ test-expr '\''(A != B) && (C >= D)'\'''
test-expr '(A != B) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) && (C >= D)'\'''

echo '$ diff-expr '\''(A != B) && (C >= D)'\'' '\''A != B && (C >= D)'\'''
diff-expr '(A != B) && (C >= D)' 'A != B && (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C >= D)'\'' '\''A != B && (C >= D)'\'''

echo '$ diff-expr '\''(A != B) && (C >= D)'\'' '\''A != B && C >= D'\'''
diff-expr '(A != B) && (C >= D)' 'A != B && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C >= D)'\'' '\''A != B && C >= D'\'''

echo '$ diff-expr '\''(A != B) && (C >= D)'\'' '\''(A != B) && C >= D'\'''
diff-expr '(A != B) && (C >= D)' '(A != B) && C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) && (C >= D)'\'' '\''(A != B) && C >= D'\'''

echo '$ test-expr '\''(a != b) || (c >= d)'\'''
test-expr '(a != b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (c >= d)'\'''

echo '$ diff-expr '\''(a != b) || (c >= d)'\'' '\''a != b || (c >= d)'\'''
diff-expr '(a != b) || (c >= d)' 'a != b || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= d)'\'' '\''a != b || (c >= d)'\'''

echo '$ diff-expr '\''(a != b) || (c >= d)'\'' '\''a != b || c >= d'\'''
diff-expr '(a != b) || (c >= d)' 'a != b || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= d)'\'' '\''a != b || c >= d'\'''

echo '$ diff-expr '\''(a != b) || (c >= d)'\'' '\''(a != b) || c >= d'\'''
diff-expr '(a != b) || (c >= d)' '(a != b) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= d)'\'' '\''(a != b) || c >= d'\'''

echo '$ test-expr '\''(a != b) || (c >= D)'\'''
test-expr '(a != b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (c >= D)'\'''

echo '$ diff-expr '\''(a != b) || (c >= D)'\'' '\''a != b || (c >= D)'\'''
diff-expr '(a != b) || (c >= D)' 'a != b || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= D)'\'' '\''a != b || (c >= D)'\'''

echo '$ diff-expr '\''(a != b) || (c >= D)'\'' '\''a != b || c >= D'\'''
diff-expr '(a != b) || (c >= D)' 'a != b || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= D)'\'' '\''a != b || c >= D'\'''

echo '$ diff-expr '\''(a != b) || (c >= D)'\'' '\''(a != b) || c >= D'\'''
diff-expr '(a != b) || (c >= D)' '(a != b) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= D)'\'' '\''(a != b) || c >= D'\'''

echo '$ test-expr '\''(a != b) || (C >= d)'\'''
test-expr '(a != b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (C >= d)'\'''

echo '$ diff-expr '\''(a != b) || (C >= d)'\'' '\''a != b || (C >= d)'\'''
diff-expr '(a != b) || (C >= d)' 'a != b || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C >= d)'\'' '\''a != b || (C >= d)'\'''

echo '$ diff-expr '\''(a != b) || (C >= d)'\'' '\''a != b || C >= d'\'''
diff-expr '(a != b) || (C >= d)' 'a != b || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C >= d)'\'' '\''a != b || C >= d'\'''

echo '$ diff-expr '\''(a != b) || (C >= d)'\'' '\''(a != b) || C >= d'\'''
diff-expr '(a != b) || (C >= d)' '(a != b) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C >= d)'\'' '\''(a != b) || C >= d'\'''

echo '$ test-expr '\''(a != b) || (C >= D)'\'''
test-expr '(a != b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (C >= D)'\'''

echo '$ diff-expr '\''(a != b) || (C >= D)'\'' '\''a != b || (C >= D)'\'''
diff-expr '(a != b) || (C >= D)' 'a != b || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C >= D)'\'' '\''a != b || (C >= D)'\'''

echo '$ diff-expr '\''(a != b) || (C >= D)'\'' '\''a != b || C >= D'\'''
diff-expr '(a != b) || (C >= D)' 'a != b || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C >= D)'\'' '\''a != b || C >= D'\'''

echo '$ diff-expr '\''(a != b) || (C >= D)'\'' '\''(a != b) || C >= D'\'''
diff-expr '(a != b) || (C >= D)' '(a != b) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (C >= D)'\'' '\''(a != b) || C >= D'\'''

echo '$ test-expr '\''(a != B) || (c >= d)'\'''
test-expr '(a != B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (c >= d)'\'''

echo '$ diff-expr '\''(a != B) || (c >= d)'\'' '\''a != B || (c >= d)'\'''
diff-expr '(a != B) || (c >= d)' 'a != B || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c >= d)'\'' '\''a != B || (c >= d)'\'''

echo '$ diff-expr '\''(a != B) || (c >= d)'\'' '\''a != B || c >= d'\'''
diff-expr '(a != B) || (c >= d)' 'a != B || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c >= d)'\'' '\''a != B || c >= d'\'''

echo '$ diff-expr '\''(a != B) || (c >= d)'\'' '\''(a != B) || c >= d'\'''
diff-expr '(a != B) || (c >= d)' '(a != B) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c >= d)'\'' '\''(a != B) || c >= d'\'''

echo '$ test-expr '\''(a != B) || (c >= D)'\'''
test-expr '(a != B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (c >= D)'\'''

echo '$ diff-expr '\''(a != B) || (c >= D)'\'' '\''a != B || (c >= D)'\'''
diff-expr '(a != B) || (c >= D)' 'a != B || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c >= D)'\'' '\''a != B || (c >= D)'\'''

echo '$ diff-expr '\''(a != B) || (c >= D)'\'' '\''a != B || c >= D'\'''
diff-expr '(a != B) || (c >= D)' 'a != B || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c >= D)'\'' '\''a != B || c >= D'\'''

echo '$ diff-expr '\''(a != B) || (c >= D)'\'' '\''(a != B) || c >= D'\'''
diff-expr '(a != B) || (c >= D)' '(a != B) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (c >= D)'\'' '\''(a != B) || c >= D'\'''

echo '$ test-expr '\''(a != B) || (C >= d)'\'''
test-expr '(a != B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (C >= d)'\'''

echo '$ diff-expr '\''(a != B) || (C >= d)'\'' '\''a != B || (C >= d)'\'''
diff-expr '(a != B) || (C >= d)' 'a != B || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C >= d)'\'' '\''a != B || (C >= d)'\'''

echo '$ diff-expr '\''(a != B) || (C >= d)'\'' '\''a != B || C >= d'\'''
diff-expr '(a != B) || (C >= d)' 'a != B || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C >= d)'\'' '\''a != B || C >= d'\'''

echo '$ diff-expr '\''(a != B) || (C >= d)'\'' '\''(a != B) || C >= d'\'''
diff-expr '(a != B) || (C >= d)' '(a != B) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C >= d)'\'' '\''(a != B) || C >= d'\'''

echo '$ test-expr '\''(a != B) || (C >= D)'\'''
test-expr '(a != B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a != B) || (C >= D)'\'''

echo '$ diff-expr '\''(a != B) || (C >= D)'\'' '\''a != B || (C >= D)'\'''
diff-expr '(a != B) || (C >= D)' 'a != B || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C >= D)'\'' '\''a != B || (C >= D)'\'''

echo '$ diff-expr '\''(a != B) || (C >= D)'\'' '\''a != B || C >= D'\'''
diff-expr '(a != B) || (C >= D)' 'a != B || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C >= D)'\'' '\''a != B || C >= D'\'''

echo '$ diff-expr '\''(a != B) || (C >= D)'\'' '\''(a != B) || C >= D'\'''
diff-expr '(a != B) || (C >= D)' '(a != B) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a != B) || (C >= D)'\'' '\''(a != B) || C >= D'\'''

echo '$ test-expr '\''(A != b) || (c >= d)'\'''
test-expr '(A != b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (c >= d)'\'''

echo '$ diff-expr '\''(A != b) || (c >= d)'\'' '\''A != b || (c >= d)'\'''
diff-expr '(A != b) || (c >= d)' 'A != b || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c >= d)'\'' '\''A != b || (c >= d)'\'''

echo '$ diff-expr '\''(A != b) || (c >= d)'\'' '\''A != b || c >= d'\'''
diff-expr '(A != b) || (c >= d)' 'A != b || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c >= d)'\'' '\''A != b || c >= d'\'''

echo '$ diff-expr '\''(A != b) || (c >= d)'\'' '\''(A != b) || c >= d'\'''
diff-expr '(A != b) || (c >= d)' '(A != b) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c >= d)'\'' '\''(A != b) || c >= d'\'''

echo '$ test-expr '\''(A != b) || (c >= D)'\'''
test-expr '(A != b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (c >= D)'\'''

echo '$ diff-expr '\''(A != b) || (c >= D)'\'' '\''A != b || (c >= D)'\'''
diff-expr '(A != b) || (c >= D)' 'A != b || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c >= D)'\'' '\''A != b || (c >= D)'\'''

echo '$ diff-expr '\''(A != b) || (c >= D)'\'' '\''A != b || c >= D'\'''
diff-expr '(A != b) || (c >= D)' 'A != b || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c >= D)'\'' '\''A != b || c >= D'\'''

echo '$ diff-expr '\''(A != b) || (c >= D)'\'' '\''(A != b) || c >= D'\'''
diff-expr '(A != b) || (c >= D)' '(A != b) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (c >= D)'\'' '\''(A != b) || c >= D'\'''

echo '$ test-expr '\''(A != b) || (C >= d)'\'''
test-expr '(A != b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (C >= d)'\'''

echo '$ diff-expr '\''(A != b) || (C >= d)'\'' '\''A != b || (C >= d)'\'''
diff-expr '(A != b) || (C >= d)' 'A != b || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C >= d)'\'' '\''A != b || (C >= d)'\'''

echo '$ diff-expr '\''(A != b) || (C >= d)'\'' '\''A != b || C >= d'\'''
diff-expr '(A != b) || (C >= d)' 'A != b || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C >= d)'\'' '\''A != b || C >= d'\'''

echo '$ diff-expr '\''(A != b) || (C >= d)'\'' '\''(A != b) || C >= d'\'''
diff-expr '(A != b) || (C >= d)' '(A != b) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C >= d)'\'' '\''(A != b) || C >= d'\'''

echo '$ test-expr '\''(A != b) || (C >= D)'\'''
test-expr '(A != b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != b) || (C >= D)'\'''

echo '$ diff-expr '\''(A != b) || (C >= D)'\'' '\''A != b || (C >= D)'\'''
diff-expr '(A != b) || (C >= D)' 'A != b || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C >= D)'\'' '\''A != b || (C >= D)'\'''

echo '$ diff-expr '\''(A != b) || (C >= D)'\'' '\''A != b || C >= D'\'''
diff-expr '(A != b) || (C >= D)' 'A != b || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C >= D)'\'' '\''A != b || C >= D'\'''

echo '$ diff-expr '\''(A != b) || (C >= D)'\'' '\''(A != b) || C >= D'\'''
diff-expr '(A != b) || (C >= D)' '(A != b) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != b) || (C >= D)'\'' '\''(A != b) || C >= D'\'''

echo '$ test-expr '\''(A != B) || (c >= d)'\'''
test-expr '(A != B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (c >= d)'\'''

echo '$ diff-expr '\''(A != B) || (c >= d)'\'' '\''A != B || (c >= d)'\'''
diff-expr '(A != B) || (c >= d)' 'A != B || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c >= d)'\'' '\''A != B || (c >= d)'\'''

echo '$ diff-expr '\''(A != B) || (c >= d)'\'' '\''A != B || c >= d'\'''
diff-expr '(A != B) || (c >= d)' 'A != B || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c >= d)'\'' '\''A != B || c >= d'\'''

echo '$ diff-expr '\''(A != B) || (c >= d)'\'' '\''(A != B) || c >= d'\'''
diff-expr '(A != B) || (c >= d)' '(A != B) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c >= d)'\'' '\''(A != B) || c >= d'\'''

echo '$ test-expr '\''(A != B) || (c >= D)'\'''
test-expr '(A != B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (c >= D)'\'''

echo '$ diff-expr '\''(A != B) || (c >= D)'\'' '\''A != B || (c >= D)'\'''
diff-expr '(A != B) || (c >= D)' 'A != B || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c >= D)'\'' '\''A != B || (c >= D)'\'''

echo '$ diff-expr '\''(A != B) || (c >= D)'\'' '\''A != B || c >= D'\'''
diff-expr '(A != B) || (c >= D)' 'A != B || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c >= D)'\'' '\''A != B || c >= D'\'''

echo '$ diff-expr '\''(A != B) || (c >= D)'\'' '\''(A != B) || c >= D'\'''
diff-expr '(A != B) || (c >= D)' '(A != B) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (c >= D)'\'' '\''(A != B) || c >= D'\'''

echo '$ test-expr '\''(A != B) || (C >= d)'\'''
test-expr '(A != B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (C >= d)'\'''

echo '$ diff-expr '\''(A != B) || (C >= d)'\'' '\''A != B || (C >= d)'\'''
diff-expr '(A != B) || (C >= d)' 'A != B || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C >= d)'\'' '\''A != B || (C >= d)'\'''

echo '$ diff-expr '\''(A != B) || (C >= d)'\'' '\''A != B || C >= d'\'''
diff-expr '(A != B) || (C >= d)' 'A != B || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C >= d)'\'' '\''A != B || C >= d'\'''

echo '$ diff-expr '\''(A != B) || (C >= d)'\'' '\''(A != B) || C >= d'\'''
diff-expr '(A != B) || (C >= d)' '(A != B) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C >= d)'\'' '\''(A != B) || C >= d'\'''

echo '$ test-expr '\''(A != B) || (C >= D)'\'''
test-expr '(A != B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A != B) || (C >= D)'\'''

echo '$ diff-expr '\''(A != B) || (C >= D)'\'' '\''A != B || (C >= D)'\'''
diff-expr '(A != B) || (C >= D)' 'A != B || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C >= D)'\'' '\''A != B || (C >= D)'\'''

echo '$ diff-expr '\''(A != B) || (C >= D)'\'' '\''A != B || C >= D'\'''
diff-expr '(A != B) || (C >= D)' 'A != B || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C >= D)'\'' '\''A != B || C >= D'\'''

echo '$ diff-expr '\''(A != B) || (C >= D)'\'' '\''(A != B) || C >= D'\'''
diff-expr '(A != B) || (C >= D)' '(A != B) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A != B) || (C >= D)'\'' '\''(A != B) || C >= D'\'''

echo '$ test-expr '\''(a && b) || (c >= d)'\'''
test-expr '(a && b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (c >= d)'\'''

echo '$ diff-expr '\''(a && b) || (c >= d)'\'' '\''a && b || (c >= d)'\'''
diff-expr '(a && b) || (c >= d)' 'a && b || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= d)'\'' '\''a && b || (c >= d)'\'''

echo '$ diff-expr '\''(a && b) || (c >= d)'\'' '\''a && b || c >= d'\'''
diff-expr '(a && b) || (c >= d)' 'a && b || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= d)'\'' '\''a && b || c >= d'\'''

echo '$ diff-expr '\''(a && b) || (c >= d)'\'' '\''(a && b) || c >= d'\'''
diff-expr '(a && b) || (c >= d)' '(a && b) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= d)'\'' '\''(a && b) || c >= d'\'''

echo '$ test-expr '\''(a && b) || (c >= D)'\'''
test-expr '(a && b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (c >= D)'\'''

echo '$ diff-expr '\''(a && b) || (c >= D)'\'' '\''a && b || (c >= D)'\'''
diff-expr '(a && b) || (c >= D)' 'a && b || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= D)'\'' '\''a && b || (c >= D)'\'''

echo '$ diff-expr '\''(a && b) || (c >= D)'\'' '\''a && b || c >= D'\'''
diff-expr '(a && b) || (c >= D)' 'a && b || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= D)'\'' '\''a && b || c >= D'\'''

echo '$ diff-expr '\''(a && b) || (c >= D)'\'' '\''(a && b) || c >= D'\'''
diff-expr '(a && b) || (c >= D)' '(a && b) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= D)'\'' '\''(a && b) || c >= D'\'''

echo '$ test-expr '\''(a && b) || (C >= d)'\'''
test-expr '(a && b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (C >= d)'\'''

echo '$ diff-expr '\''(a && b) || (C >= d)'\'' '\''a && b || (C >= d)'\'''
diff-expr '(a && b) || (C >= d)' 'a && b || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C >= d)'\'' '\''a && b || (C >= d)'\'''

echo '$ diff-expr '\''(a && b) || (C >= d)'\'' '\''a && b || C >= d'\'''
diff-expr '(a && b) || (C >= d)' 'a && b || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C >= d)'\'' '\''a && b || C >= d'\'''

echo '$ diff-expr '\''(a && b) || (C >= d)'\'' '\''(a && b) || C >= d'\'''
diff-expr '(a && b) || (C >= d)' '(a && b) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C >= d)'\'' '\''(a && b) || C >= d'\'''

echo '$ test-expr '\''(a && b) || (C >= D)'\'''
test-expr '(a && b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (C >= D)'\'''

echo '$ diff-expr '\''(a && b) || (C >= D)'\'' '\''a && b || (C >= D)'\'''
diff-expr '(a && b) || (C >= D)' 'a && b || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C >= D)'\'' '\''a && b || (C >= D)'\'''

echo '$ diff-expr '\''(a && b) || (C >= D)'\'' '\''a && b || C >= D'\'''
diff-expr '(a && b) || (C >= D)' 'a && b || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C >= D)'\'' '\''a && b || C >= D'\'''

echo '$ diff-expr '\''(a && b) || (C >= D)'\'' '\''(a && b) || C >= D'\'''
diff-expr '(a && b) || (C >= D)' '(a && b) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C >= D)'\'' '\''(a && b) || C >= D'\'''

echo '$ test-expr '\''(a && B) || (c >= d)'\'''
test-expr '(a && B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (c >= d)'\'''

echo '$ diff-expr '\''(a && B) || (c >= d)'\'' '\''a && B || (c >= d)'\'''
diff-expr '(a && B) || (c >= d)' 'a && B || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c >= d)'\'' '\''a && B || (c >= d)'\'''

echo '$ diff-expr '\''(a && B) || (c >= d)'\'' '\''a && B || c >= d'\'''
diff-expr '(a && B) || (c >= d)' 'a && B || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c >= d)'\'' '\''a && B || c >= d'\'''

echo '$ diff-expr '\''(a && B) || (c >= d)'\'' '\''(a && B) || c >= d'\'''
diff-expr '(a && B) || (c >= d)' '(a && B) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c >= d)'\'' '\''(a && B) || c >= d'\'''

echo '$ test-expr '\''(a && B) || (c >= D)'\'''
test-expr '(a && B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (c >= D)'\'''

echo '$ diff-expr '\''(a && B) || (c >= D)'\'' '\''a && B || (c >= D)'\'''
diff-expr '(a && B) || (c >= D)' 'a && B || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c >= D)'\'' '\''a && B || (c >= D)'\'''

echo '$ diff-expr '\''(a && B) || (c >= D)'\'' '\''a && B || c >= D'\'''
diff-expr '(a && B) || (c >= D)' 'a && B || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c >= D)'\'' '\''a && B || c >= D'\'''

echo '$ diff-expr '\''(a && B) || (c >= D)'\'' '\''(a && B) || c >= D'\'''
diff-expr '(a && B) || (c >= D)' '(a && B) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c >= D)'\'' '\''(a && B) || c >= D'\'''

echo '$ test-expr '\''(a && B) || (C >= d)'\'''
test-expr '(a && B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (C >= d)'\'''

echo '$ diff-expr '\''(a && B) || (C >= d)'\'' '\''a && B || (C >= d)'\'''
diff-expr '(a && B) || (C >= d)' 'a && B || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C >= d)'\'' '\''a && B || (C >= d)'\'''

echo '$ diff-expr '\''(a && B) || (C >= d)'\'' '\''a && B || C >= d'\'''
diff-expr '(a && B) || (C >= d)' 'a && B || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C >= d)'\'' '\''a && B || C >= d'\'''

echo '$ diff-expr '\''(a && B) || (C >= d)'\'' '\''(a && B) || C >= d'\'''
diff-expr '(a && B) || (C >= d)' '(a && B) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C >= d)'\'' '\''(a && B) || C >= d'\'''

echo '$ test-expr '\''(a && B) || (C >= D)'\'''
test-expr '(a && B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (C >= D)'\'''

echo '$ diff-expr '\''(a && B) || (C >= D)'\'' '\''a && B || (C >= D)'\'''
diff-expr '(a && B) || (C >= D)' 'a && B || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C >= D)'\'' '\''a && B || (C >= D)'\'''

echo '$ diff-expr '\''(a && B) || (C >= D)'\'' '\''a && B || C >= D'\'''
diff-expr '(a && B) || (C >= D)' 'a && B || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C >= D)'\'' '\''a && B || C >= D'\'''

echo '$ diff-expr '\''(a && B) || (C >= D)'\'' '\''(a && B) || C >= D'\'''
diff-expr '(a && B) || (C >= D)' '(a && B) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C >= D)'\'' '\''(a && B) || C >= D'\'''

echo '$ test-expr '\''(A && b) || (c >= d)'\'''
test-expr '(A && b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (c >= d)'\'''

echo '$ diff-expr '\''(A && b) || (c >= d)'\'' '\''A && b || (c >= d)'\'''
diff-expr '(A && b) || (c >= d)' 'A && b || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c >= d)'\'' '\''A && b || (c >= d)'\'''

echo '$ diff-expr '\''(A && b) || (c >= d)'\'' '\''A && b || c >= d'\'''
diff-expr '(A && b) || (c >= d)' 'A && b || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c >= d)'\'' '\''A && b || c >= d'\'''

echo '$ diff-expr '\''(A && b) || (c >= d)'\'' '\''(A && b) || c >= d'\'''
diff-expr '(A && b) || (c >= d)' '(A && b) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c >= d)'\'' '\''(A && b) || c >= d'\'''

echo '$ test-expr '\''(A && b) || (c >= D)'\'''
test-expr '(A && b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (c >= D)'\'''

echo '$ diff-expr '\''(A && b) || (c >= D)'\'' '\''A && b || (c >= D)'\'''
diff-expr '(A && b) || (c >= D)' 'A && b || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c >= D)'\'' '\''A && b || (c >= D)'\'''

echo '$ diff-expr '\''(A && b) || (c >= D)'\'' '\''A && b || c >= D'\'''
diff-expr '(A && b) || (c >= D)' 'A && b || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c >= D)'\'' '\''A && b || c >= D'\'''

echo '$ diff-expr '\''(A && b) || (c >= D)'\'' '\''(A && b) || c >= D'\'''
diff-expr '(A && b) || (c >= D)' '(A && b) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c >= D)'\'' '\''(A && b) || c >= D'\'''

echo '$ test-expr '\''(A && b) || (C >= d)'\'''
test-expr '(A && b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (C >= d)'\'''

echo '$ diff-expr '\''(A && b) || (C >= d)'\'' '\''A && b || (C >= d)'\'''
diff-expr '(A && b) || (C >= d)' 'A && b || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C >= d)'\'' '\''A && b || (C >= d)'\'''

echo '$ diff-expr '\''(A && b) || (C >= d)'\'' '\''A && b || C >= d'\'''
diff-expr '(A && b) || (C >= d)' 'A && b || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C >= d)'\'' '\''A && b || C >= d'\'''

echo '$ diff-expr '\''(A && b) || (C >= d)'\'' '\''(A && b) || C >= d'\'''
diff-expr '(A && b) || (C >= d)' '(A && b) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C >= d)'\'' '\''(A && b) || C >= d'\'''

echo '$ test-expr '\''(A && b) || (C >= D)'\'''
test-expr '(A && b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (C >= D)'\'''

echo '$ diff-expr '\''(A && b) || (C >= D)'\'' '\''A && b || (C >= D)'\'''
diff-expr '(A && b) || (C >= D)' 'A && b || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C >= D)'\'' '\''A && b || (C >= D)'\'''

echo '$ diff-expr '\''(A && b) || (C >= D)'\'' '\''A && b || C >= D'\'''
diff-expr '(A && b) || (C >= D)' 'A && b || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C >= D)'\'' '\''A && b || C >= D'\'''

echo '$ diff-expr '\''(A && b) || (C >= D)'\'' '\''(A && b) || C >= D'\'''
diff-expr '(A && b) || (C >= D)' '(A && b) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C >= D)'\'' '\''(A && b) || C >= D'\'''

echo '$ test-expr '\''(A && B) || (c >= d)'\'''
test-expr '(A && B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (c >= d)'\'''

echo '$ diff-expr '\''(A && B) || (c >= d)'\'' '\''A && B || (c >= d)'\'''
diff-expr '(A && B) || (c >= d)' 'A && B || (c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c >= d)'\'' '\''A && B || (c >= d)'\'''

echo '$ diff-expr '\''(A && B) || (c >= d)'\'' '\''A && B || c >= d'\'''
diff-expr '(A && B) || (c >= d)' 'A && B || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c >= d)'\'' '\''A && B || c >= d'\'''

echo '$ diff-expr '\''(A && B) || (c >= d)'\'' '\''(A && B) || c >= d'\'''
diff-expr '(A && B) || (c >= d)' '(A && B) || c >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c >= d)'\'' '\''(A && B) || c >= d'\'''

echo '$ test-expr '\''(A && B) || (c >= D)'\'''
test-expr '(A && B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (c >= D)'\'''

echo '$ diff-expr '\''(A && B) || (c >= D)'\'' '\''A && B || (c >= D)'\'''
diff-expr '(A && B) || (c >= D)' 'A && B || (c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c >= D)'\'' '\''A && B || (c >= D)'\'''

echo '$ diff-expr '\''(A && B) || (c >= D)'\'' '\''A && B || c >= D'\'''
diff-expr '(A && B) || (c >= D)' 'A && B || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c >= D)'\'' '\''A && B || c >= D'\'''

echo '$ diff-expr '\''(A && B) || (c >= D)'\'' '\''(A && B) || c >= D'\'''
diff-expr '(A && B) || (c >= D)' '(A && B) || c >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c >= D)'\'' '\''(A && B) || c >= D'\'''

echo '$ test-expr '\''(A && B) || (C >= d)'\'''
test-expr '(A && B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (C >= d)'\'''

echo '$ diff-expr '\''(A && B) || (C >= d)'\'' '\''A && B || (C >= d)'\'''
diff-expr '(A && B) || (C >= d)' 'A && B || (C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C >= d)'\'' '\''A && B || (C >= d)'\'''

echo '$ diff-expr '\''(A && B) || (C >= d)'\'' '\''A && B || C >= d'\'''
diff-expr '(A && B) || (C >= d)' 'A && B || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C >= d)'\'' '\''A && B || C >= d'\'''

echo '$ diff-expr '\''(A && B) || (C >= d)'\'' '\''(A && B) || C >= d'\'''
diff-expr '(A && B) || (C >= d)' '(A && B) || C >= d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C >= d)'\'' '\''(A && B) || C >= d'\'''

echo '$ test-expr '\''(A && B) || (C >= D)'\'''
test-expr '(A && B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (C >= D)'\'''

echo '$ diff-expr '\''(A && B) || (C >= D)'\'' '\''A && B || (C >= D)'\'''
diff-expr '(A && B) || (C >= D)' 'A && B || (C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C >= D)'\'' '\''A && B || (C >= D)'\'''

echo '$ diff-expr '\''(A && B) || (C >= D)'\'' '\''A && B || C >= D'\'''
diff-expr '(A && B) || (C >= D)' 'A && B || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C >= D)'\'' '\''A && B || C >= D'\'''

echo '$ diff-expr '\''(A && B) || (C >= D)'\'' '\''(A && B) || C >= D'\'''
diff-expr '(A && B) || (C >= D)' '(A && B) || C >= D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C >= D)'\'' '\''(A && B) || C >= D'\'''

echo '$ test-expr '\''(a && b) || (c != d)'\'''
test-expr '(a && b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (c != d)'\'''

echo '$ diff-expr '\''(a && b) || (c != d)'\'' '\''a && b || (c != d)'\'''
diff-expr '(a && b) || (c != d)' 'a && b || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != d)'\'' '\''a && b || (c != d)'\'''

echo '$ diff-expr '\''(a && b) || (c != d)'\'' '\''a && b || c != d'\'''
diff-expr '(a && b) || (c != d)' 'a && b || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != d)'\'' '\''a && b || c != d'\'''

echo '$ diff-expr '\''(a && b) || (c != d)'\'' '\''(a && b) || c != d'\'''
diff-expr '(a && b) || (c != d)' '(a && b) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != d)'\'' '\''(a && b) || c != d'\'''

echo '$ test-expr '\''(a && b) || (c != D)'\'''
test-expr '(a && b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (c != D)'\'''

echo '$ diff-expr '\''(a && b) || (c != D)'\'' '\''a && b || (c != D)'\'''
diff-expr '(a && b) || (c != D)' 'a && b || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != D)'\'' '\''a && b || (c != D)'\'''

echo '$ diff-expr '\''(a && b) || (c != D)'\'' '\''a && b || c != D'\'''
diff-expr '(a && b) || (c != D)' 'a && b || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != D)'\'' '\''a && b || c != D'\'''

echo '$ diff-expr '\''(a && b) || (c != D)'\'' '\''(a && b) || c != D'\'''
diff-expr '(a && b) || (c != D)' '(a && b) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != D)'\'' '\''(a && b) || c != D'\'''

echo '$ test-expr '\''(a && b) || (C != d)'\'''
test-expr '(a && b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (C != d)'\'''

echo '$ diff-expr '\''(a && b) || (C != d)'\'' '\''a && b || (C != d)'\'''
diff-expr '(a && b) || (C != d)' 'a && b || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C != d)'\'' '\''a && b || (C != d)'\'''

echo '$ diff-expr '\''(a && b) || (C != d)'\'' '\''a && b || C != d'\'''
diff-expr '(a && b) || (C != d)' 'a && b || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C != d)'\'' '\''a && b || C != d'\'''

echo '$ diff-expr '\''(a && b) || (C != d)'\'' '\''(a && b) || C != d'\'''
diff-expr '(a && b) || (C != d)' '(a && b) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C != d)'\'' '\''(a && b) || C != d'\'''

echo '$ test-expr '\''(a && b) || (C != D)'\'''
test-expr '(a && b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (C != D)'\'''

echo '$ diff-expr '\''(a && b) || (C != D)'\'' '\''a && b || (C != D)'\'''
diff-expr '(a && b) || (C != D)' 'a && b || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C != D)'\'' '\''a && b || (C != D)'\'''

echo '$ diff-expr '\''(a && b) || (C != D)'\'' '\''a && b || C != D'\'''
diff-expr '(a && b) || (C != D)' 'a && b || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C != D)'\'' '\''a && b || C != D'\'''

echo '$ diff-expr '\''(a && b) || (C != D)'\'' '\''(a && b) || C != D'\'''
diff-expr '(a && b) || (C != D)' '(a && b) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (C != D)'\'' '\''(a && b) || C != D'\'''

echo '$ test-expr '\''(a && B) || (c != d)'\'''
test-expr '(a && B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (c != d)'\'''

echo '$ diff-expr '\''(a && B) || (c != d)'\'' '\''a && B || (c != d)'\'''
diff-expr '(a && B) || (c != d)' 'a && B || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c != d)'\'' '\''a && B || (c != d)'\'''

echo '$ diff-expr '\''(a && B) || (c != d)'\'' '\''a && B || c != d'\'''
diff-expr '(a && B) || (c != d)' 'a && B || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c != d)'\'' '\''a && B || c != d'\'''

echo '$ diff-expr '\''(a && B) || (c != d)'\'' '\''(a && B) || c != d'\'''
diff-expr '(a && B) || (c != d)' '(a && B) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c != d)'\'' '\''(a && B) || c != d'\'''

echo '$ test-expr '\''(a && B) || (c != D)'\'''
test-expr '(a && B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (c != D)'\'''

echo '$ diff-expr '\''(a && B) || (c != D)'\'' '\''a && B || (c != D)'\'''
diff-expr '(a && B) || (c != D)' 'a && B || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c != D)'\'' '\''a && B || (c != D)'\'''

echo '$ diff-expr '\''(a && B) || (c != D)'\'' '\''a && B || c != D'\'''
diff-expr '(a && B) || (c != D)' 'a && B || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c != D)'\'' '\''a && B || c != D'\'''

echo '$ diff-expr '\''(a && B) || (c != D)'\'' '\''(a && B) || c != D'\'''
diff-expr '(a && B) || (c != D)' '(a && B) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (c != D)'\'' '\''(a && B) || c != D'\'''

echo '$ test-expr '\''(a && B) || (C != d)'\'''
test-expr '(a && B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (C != d)'\'''

echo '$ diff-expr '\''(a && B) || (C != d)'\'' '\''a && B || (C != d)'\'''
diff-expr '(a && B) || (C != d)' 'a && B || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C != d)'\'' '\''a && B || (C != d)'\'''

echo '$ diff-expr '\''(a && B) || (C != d)'\'' '\''a && B || C != d'\'''
diff-expr '(a && B) || (C != d)' 'a && B || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C != d)'\'' '\''a && B || C != d'\'''

echo '$ diff-expr '\''(a && B) || (C != d)'\'' '\''(a && B) || C != d'\'''
diff-expr '(a && B) || (C != d)' '(a && B) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C != d)'\'' '\''(a && B) || C != d'\'''

echo '$ test-expr '\''(a && B) || (C != D)'\'''
test-expr '(a && B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(a && B) || (C != D)'\'''

echo '$ diff-expr '\''(a && B) || (C != D)'\'' '\''a && B || (C != D)'\'''
diff-expr '(a && B) || (C != D)' 'a && B || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C != D)'\'' '\''a && B || (C != D)'\'''

echo '$ diff-expr '\''(a && B) || (C != D)'\'' '\''a && B || C != D'\'''
diff-expr '(a && B) || (C != D)' 'a && B || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C != D)'\'' '\''a && B || C != D'\'''

echo '$ diff-expr '\''(a && B) || (C != D)'\'' '\''(a && B) || C != D'\'''
diff-expr '(a && B) || (C != D)' '(a && B) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(a && B) || (C != D)'\'' '\''(a && B) || C != D'\'''

echo '$ test-expr '\''(A && b) || (c != d)'\'''
test-expr '(A && b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (c != d)'\'''

echo '$ diff-expr '\''(A && b) || (c != d)'\'' '\''A && b || (c != d)'\'''
diff-expr '(A && b) || (c != d)' 'A && b || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c != d)'\'' '\''A && b || (c != d)'\'''

echo '$ diff-expr '\''(A && b) || (c != d)'\'' '\''A && b || c != d'\'''
diff-expr '(A && b) || (c != d)' 'A && b || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c != d)'\'' '\''A && b || c != d'\'''

echo '$ diff-expr '\''(A && b) || (c != d)'\'' '\''(A && b) || c != d'\'''
diff-expr '(A && b) || (c != d)' '(A && b) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c != d)'\'' '\''(A && b) || c != d'\'''

echo '$ test-expr '\''(A && b) || (c != D)'\'''
test-expr '(A && b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (c != D)'\'''

echo '$ diff-expr '\''(A && b) || (c != D)'\'' '\''A && b || (c != D)'\'''
diff-expr '(A && b) || (c != D)' 'A && b || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c != D)'\'' '\''A && b || (c != D)'\'''

echo '$ diff-expr '\''(A && b) || (c != D)'\'' '\''A && b || c != D'\'''
diff-expr '(A && b) || (c != D)' 'A && b || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c != D)'\'' '\''A && b || c != D'\'''

echo '$ diff-expr '\''(A && b) || (c != D)'\'' '\''(A && b) || c != D'\'''
diff-expr '(A && b) || (c != D)' '(A && b) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (c != D)'\'' '\''(A && b) || c != D'\'''

echo '$ test-expr '\''(A && b) || (C != d)'\'''
test-expr '(A && b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (C != d)'\'''

echo '$ diff-expr '\''(A && b) || (C != d)'\'' '\''A && b || (C != d)'\'''
diff-expr '(A && b) || (C != d)' 'A && b || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C != d)'\'' '\''A && b || (C != d)'\'''

echo '$ diff-expr '\''(A && b) || (C != d)'\'' '\''A && b || C != d'\'''
diff-expr '(A && b) || (C != d)' 'A && b || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C != d)'\'' '\''A && b || C != d'\'''

echo '$ diff-expr '\''(A && b) || (C != d)'\'' '\''(A && b) || C != d'\'''
diff-expr '(A && b) || (C != d)' '(A && b) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C != d)'\'' '\''(A && b) || C != d'\'''

echo '$ test-expr '\''(A && b) || (C != D)'\'''
test-expr '(A && b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && b) || (C != D)'\'''

echo '$ diff-expr '\''(A && b) || (C != D)'\'' '\''A && b || (C != D)'\'''
diff-expr '(A && b) || (C != D)' 'A && b || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C != D)'\'' '\''A && b || (C != D)'\'''

echo '$ diff-expr '\''(A && b) || (C != D)'\'' '\''A && b || C != D'\'''
diff-expr '(A && b) || (C != D)' 'A && b || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C != D)'\'' '\''A && b || C != D'\'''

echo '$ diff-expr '\''(A && b) || (C != D)'\'' '\''(A && b) || C != D'\'''
diff-expr '(A && b) || (C != D)' '(A && b) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && b) || (C != D)'\'' '\''(A && b) || C != D'\'''

echo '$ test-expr '\''(A && B) || (c != d)'\'''
test-expr '(A && B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (c != d)'\'''

echo '$ diff-expr '\''(A && B) || (c != d)'\'' '\''A && B || (c != d)'\'''
diff-expr '(A && B) || (c != d)' 'A && B || (c != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c != d)'\'' '\''A && B || (c != d)'\'''

echo '$ diff-expr '\''(A && B) || (c != d)'\'' '\''A && B || c != d'\'''
diff-expr '(A && B) || (c != d)' 'A && B || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c != d)'\'' '\''A && B || c != d'\'''

echo '$ diff-expr '\''(A && B) || (c != d)'\'' '\''(A && B) || c != d'\'''
diff-expr '(A && B) || (c != d)' '(A && B) || c != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c != d)'\'' '\''(A && B) || c != d'\'''

echo '$ test-expr '\''(A && B) || (c != D)'\'''
test-expr '(A && B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (c != D)'\'''

echo '$ diff-expr '\''(A && B) || (c != D)'\'' '\''A && B || (c != D)'\'''
diff-expr '(A && B) || (c != D)' 'A && B || (c != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c != D)'\'' '\''A && B || (c != D)'\'''

echo '$ diff-expr '\''(A && B) || (c != D)'\'' '\''A && B || c != D'\'''
diff-expr '(A && B) || (c != D)' 'A && B || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c != D)'\'' '\''A && B || c != D'\'''

echo '$ diff-expr '\''(A && B) || (c != D)'\'' '\''(A && B) || c != D'\'''
diff-expr '(A && B) || (c != D)' '(A && B) || c != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (c != D)'\'' '\''(A && B) || c != D'\'''

echo '$ test-expr '\''(A && B) || (C != d)'\'''
test-expr '(A && B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (C != d)'\'''

echo '$ diff-expr '\''(A && B) || (C != d)'\'' '\''A && B || (C != d)'\'''
diff-expr '(A && B) || (C != d)' 'A && B || (C != d)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C != d)'\'' '\''A && B || (C != d)'\'''

echo '$ diff-expr '\''(A && B) || (C != d)'\'' '\''A && B || C != d'\'''
diff-expr '(A && B) || (C != d)' 'A && B || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C != d)'\'' '\''A && B || C != d'\'''

echo '$ diff-expr '\''(A && B) || (C != d)'\'' '\''(A && B) || C != d'\'''
diff-expr '(A && B) || (C != d)' '(A && B) || C != d' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C != d)'\'' '\''(A && B) || C != d'\'''

echo '$ test-expr '\''(A && B) || (C != D)'\'''
test-expr '(A && B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''(A && B) || (C != D)'\'''

echo '$ diff-expr '\''(A && B) || (C != D)'\'' '\''A && B || (C != D)'\'''
diff-expr '(A && B) || (C != D)' 'A && B || (C != D)' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C != D)'\'' '\''A && B || (C != D)'\'''

echo '$ diff-expr '\''(A && B) || (C != D)'\'' '\''A && B || C != D'\'''
diff-expr '(A && B) || (C != D)' 'A && B || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C != D)'\'' '\''A && B || C != D'\'''

echo '$ diff-expr '\''(A && B) || (C != D)'\'' '\''(A && B) || C != D'\'''
diff-expr '(A && B) || (C != D)' '(A && B) || C != D' 2>&1 ||
echo 'command failed: diff-expr '\''(A && B) || (C != D)'\'' '\''(A && B) || C != D'\'''

echo '$ test-expr '\''a != (b && (c >= d))'\'''
test-expr 'a != (b && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= d))'\'''

echo '$ diff-expr '\''a != (b && (c >= d))'\'' '\''a != (b && c >= d)'\'''
diff-expr 'a != (b && (c >= d))' 'a != (b && c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && (c >= d))'\'' '\''a != (b && c >= d)'\'''

echo '$ test-expr '\''a != (b && (c >= D))'\'''
test-expr 'a != (b && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= D))'\'''

echo '$ diff-expr '\''a != (b && (c >= D))'\'' '\''a != (b && c >= D)'\'''
diff-expr 'a != (b && (c >= D))' 'a != (b && c >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && (c >= D))'\'' '\''a != (b && c >= D)'\'''

echo '$ test-expr '\''a != (b && (C >= d))'\'''
test-expr 'a != (b && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (C >= d))'\'''

echo '$ diff-expr '\''a != (b && (C >= d))'\'' '\''a != (b && C >= d)'\'''
diff-expr 'a != (b && (C >= d))' 'a != (b && C >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && (C >= d))'\'' '\''a != (b && C >= d)'\'''

echo '$ test-expr '\''a != (b && (C >= D))'\'''
test-expr 'a != (b && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (C >= D))'\'''

echo '$ diff-expr '\''a != (b && (C >= D))'\'' '\''a != (b && C >= D)'\'''
diff-expr 'a != (b && (C >= D))' 'a != (b && C >= D)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && (C >= D))'\'' '\''a != (b && C >= D)'\'''

echo '$ test-expr '\''a != (B && (c >= d))'\'''
test-expr 'a != (B && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && (c >= d))'\'''

echo '$ diff-expr '\''a != (B && (c >= d))'\'' '\''a != (B && c >= d)'\'''
diff-expr 'a != (B && (c >= d))' 'a != (B && c >= d)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (B && (c >= d))'\'' '\''a != (B && c >= d)'\'''

echo '$ test-expr '\''a != (B && (c >= D))'\'''
test-expr 'a != (B && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != (B && (c >= D))'\'''

echo '$ diff-expr '\''a != (B && (c >= D))'\'' '\''a != (B && c >= D)'\'''
diff-expr 'a != (B && (c >= D))' 'a !