#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-basic-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-basic-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],null]'\''
[[{}],null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],false]'\''
[[{}],false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],true]'\''
[[{}],true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],123]'\''
[[{}],123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],"foo"]'\''
[[{}],"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],{}]'\''
[[{}],{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],[]]'\''
[[{}],[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],null]'\''
[[{}],null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],false]'\''
[[{}],false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],true]'\''
[[{}],true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],123]'\''
[[{}],123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],"foo"]'\''
[[{}],"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],{}]'\''
[[{}],{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],[]]'\''
[[{}],[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,false]'\''
[null,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,true]'\''
[null,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,123]'\''
[null,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,"foo"]'\''
[null,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,{}]'\''
[null,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,[]]'\''
[null,[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,false]'\''
[null,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,true]'\''
[null,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,123]'\''
[null,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,"foo"]'\''
[null,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,{}]'\''
[null,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,[]]'\''
[null,[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,null]'\''
[false,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,123]'\''
[false,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,"foo"]'\''
[false,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,{}]'\''
[false,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,[]]'\''
[false,[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,null]'\''
[false,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,123]'\''
[false,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,"foo"]'\''
[false,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,{}]'\''
[false,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,[]]'\''
[false,[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,null]'\''
[456,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,false]'\''
[456,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,true]'\''
[456,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,123]'\''
[456,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,"foo"]'\''
[456,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,{}]'\''
[456,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,[]]'\''
[456,[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,null]'\''
[456,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,false]'\''
[456,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,true]'\''
[456,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,123]'\''
[456,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,"foo"]'\''
[456,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,{}]'\''
[456,{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,[]]'\''
[456,[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",null]'\''
["bar",null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",false]'\''
["bar",false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",true]'\''
["bar",true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",123]'\''
["bar",123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar","foo"]'\''
["bar","foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",{}]'\''
["bar",{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",[]]'\''
["bar",[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",null]'\''
["bar",null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",false]'\''
["bar",false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",true]'\''
["bar",true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",123]'\''
["bar",123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar","foo"]'\''
["bar","foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",{}]'\''
["bar",{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",[]]'\''
["bar",[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},null]'\''
[{},null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},false]'\''
[{},false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},true]'\''
[{},true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},123]'\''
[{},123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},"foo"]'\''
[{},"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},[]]'\''
[{},[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},null]'\''
[{},null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},false]'\''
[{},false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},true]'\''
[{},true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},123]'\''
[{},123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},"foo"]'\''
[{},"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},[]]'\''
[{},[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],null]'\''
[[],null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],false]'\''
[[],false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],true]'\''
[[],true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],123]'\''
[[],123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],"foo"]'\''
[[],"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],{}]'\''
[[],{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],null]'\''
[[],null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],false]'\''
[[],false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],true]'\''
[[],true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],123]'\''
[[],123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],"foo"]'\''
[[],"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],{}]'\''
[[],{}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],[]]'\''
[[],[]]'
) -L list-closed-array-basic-basic-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","type"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","type"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","null"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","null"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","boolean"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","number"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","number"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","string"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","string"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","object"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","object"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type","array"]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type","array"]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","type"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","type"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","null"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","null"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","boolean"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","number"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","number"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","string"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","string"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","object"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","object"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null","array"]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null","array"]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","type"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","boolean"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","number"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","string"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","object"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","array"]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","type"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","type"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","null"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","null"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","boolean"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","number"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","number"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","string"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","string"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","object"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","object"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number","array"]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number","array"]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","type"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","type"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","null"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","null"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","boolean"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","number"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","number"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","string"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","string"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","object"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","object"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string","array"]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string","array"]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","type"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","type"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","null"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","null"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","boolean"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","number"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","number"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","string"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","string"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","object"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","object"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object","array"]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object","array"]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","type"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","type"]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","null"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","null"]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","boolean"]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","number"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","number"]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","string"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","string"]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","object"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","object"]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array","array"]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array","array"]}]}'\'' <<< '\''[[],[]]'\'''
)

