#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-foo-basic-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-foo-basic-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:70: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:126)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:127: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
) -L list-object-foo-basic-object-foo-basic-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":"object"}]}]}'\'' <<< '\''[]'\'''
)

