#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"zzz":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"zzz":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"zzz":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":1,"zzz":null}'\''
json: error: <stdin>:1:21: type check error: too many arguments
json: error: <stdin>:1:21: {"foo":false,"bar":1,"zzz":null}
json: error: <stdin>:1:21:                     ^
{"foo":false,"bar":1
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":1,"zzz":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zzz":null}'\''
json: error: <stdin>:1:30: type check error: too many arguments
json: error: <stdin>:1:30: {"foo":false,"bar":1,"baz":"","zzz":null}
json: error: <stdin>:1:30:                              ^
{"foo":false,"bar":1,"baz":""
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zzz":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","baa":{},"zzz":null}'\''
json: error: <stdin>:1:31: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:31: {"foo":false,"bar":1,"baz":"","baa":{},"zzz":null}
json: error: <stdin>:1:31:                               ^
{"foo":false,"bar":1,"baz":"",
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","baa":{},"zzz":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[],"zzz":null}'\''
json: error: <stdin>:1:48: type check error: too many arguments
json: error: <stdin>:1:48: ar":1,"baz":"","faa":{},"baa":[],"zzz":null}
json: error: <stdin>:1:48:                                 ^
{"foo":false,"bar":1,"baz":"","faa":{},"baa":[]
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[],"zzz":null}'\'''
) -L object7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"zzz":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":false,"zzz":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"zzz":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":1,"zzz":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}' <<< '{"foo":false,"bar":1,"zzz":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":1,"zzz":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zzz":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}' <<< '{"foo":false,"bar":1,"baz":"","zzz":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zzz":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","baa":{},"zzz":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"foo":false,"bar":1,"baz":"","baa":{},"zzz":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","baa":{},"zzz":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[],"zzz":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"foo":false,"bar":1,"baz":"","faa":{},"baa":[],"zzz":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[],"zzz":null}'\'''
)

