#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array-list7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array-list7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[123,123]'\''
[123,123]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''["bar","bar"]'\''
["bar","bar"]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: [123,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:2: ["bar","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[[],[]]'\''
[[],[]]'
) -L open-array-list7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","object"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["type","array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["type","array"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","type"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","type"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","object"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["null","array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["null","array"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","type"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","type"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","object"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["boolean","array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["boolean","array"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","type"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","type"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","object"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["number","array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["number","array"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","type"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","type"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","object"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["string","array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["string","array"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","type"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","type"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["object","array"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["object","array"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","type"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","type"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","null"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","null"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","boolean"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","boolean"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","number"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","number"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","string"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","string"]}}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":{"type":"list","args":["array","object"]}}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":{"type":"list","args":["array","object"]}}'\'' <<< '\''[[],[]]'\'''
)

