#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-basic-object-plain-val-object-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-basic-object-plain-val-object-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
{"fuu":null,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
{"fuu":null,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
{"fuu":null,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
{"fuu":null,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
{"fuu":null,"baa":456}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
{"fuu":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
{"fuu":null,"baa":"bar"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
{"fuu":null,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
{"fuu":null,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
{"fuu":false,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
{"fuu":false,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
{"fuu":false,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
{"fuu":false,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
{"fuu":false,"baa":456}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
{"fuu":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
{"fuu":false,"baa":"bar"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
{"fuu":false,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
{"fuu":false,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
{"fuu":true,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
{"fuu":true,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
{"fuu":true,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
{"fuu":true,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
{"fuu":true,"baa":456}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
{"fuu":true,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
{"fuu":true,"baa":"bar"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
{"fuu":true,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
{"fuu":true,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
{"fuu":123,"baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
{"fuu":123,"baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
{"fuu":123,"baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
{"fuu":123,"baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
{"fuu":123,"baa":456}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
{"fuu":123,"baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
{"fuu":123,"baa":"bar"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
{"fuu":123,"baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
{"fuu":123,"baa":[]}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
{"fuu":"foo","baa":null}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
{"fuu":"foo","baa":false}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
{"fuu":"foo","baa":true}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
{"fuu":"foo","baa":123}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
{"fuu":"foo","baa":456}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
{"fuu":"foo","baa":"foo"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
{"fuu":"foo","baa":"bar"}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
{"fuu":"foo","baa":{}}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
{"fuu":"foo","baa":[]}
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
{"fuu":null,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
{"fuu":null,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
{"fuu":null,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
{"fuu":null,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
{"fuu":null,"baa":456}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
{"fuu":null,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
{"fuu":null,"baa":"bar"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
{"fuu":null,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
{"fuu":null,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
{"fuu":false,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
{"fuu":false,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
{"fuu":false,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
{"fuu":false,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
{"fuu":false,"baa":456}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
{"fuu":false,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
{"fuu":false,"baa":"bar"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
{"fuu":false,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
{"fuu":false,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
{"fuu":true,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
{"fuu":true,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
{"fuu":true,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
{"fuu":true,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
{"fuu":true,"baa":456}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
{"fuu":true,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
{"fuu":true,"baa":"bar"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
{"fuu":true,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
{"fuu":true,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
{"fuu":123,"baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
{"fuu":123,"baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
{"fuu":123,"baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
{"fuu":123,"baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
{"fuu":123,"baa":456}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
{"fuu":123,"baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
{"fuu":123,"baa":"bar"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
{"fuu":123,"baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
{"fuu":123,"baa":[]}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
{"fuu":"foo","baa":null}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
{"fuu":"foo","baa":false}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
{"fuu":"foo","baa":true}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
{"fuu":"foo","baa":123}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
{"fuu":"foo","baa":456}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
{"fuu":"foo","baa":"foo"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
{"fuu":"foo","baa":"bar"}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
{"fuu":"foo","baa":{}}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
{"fuu":"foo","baa":[]}
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
) -L list-basic-object-plain-val-object-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo","baa":[]}'\'''
)

