#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:closed-array7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L closed-array7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],null]'\''
[[{}],null]
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],false]'\''
[[{}],false]
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],true]'\''
[[{}],true]
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],123]'\''
[[{}],123]
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],"foo"]'\''
[[{}],"foo"]
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],{}]'\''
[[{}],{}]
$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],[]]'\''
[[{}],[]]
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,123]'\''
[456,123]
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar","foo"]'\''
["bar","foo"]
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{}]'\''
[{},{}]
$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[]]'\''
[[],[]]'
) -L closed-array7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"array","args":["type","type"]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","type"]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":["type","null"]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","null"]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"array","args":["type","boolean"]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","boolean"]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":["type","number"]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","number"]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"array","args":["type","string"]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","string"]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"array","args":["type","object"]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","object"]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"array","args":["type","array"]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":["type","array"]}'\'' <<< '\''[[],[]]'\'''
)

