#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object-list7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-list7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}'
) -L object-list7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":null},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":false},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":true},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":123},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[{"plain":"bar"},"array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
)

