#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:utf8-10
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L utf8-10.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }
$ echo -ne '\''\xf5\xea'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5\xea'\''|json -b 1
$ echo -ne '\''\xf5\xea'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5\xea'\''|json -b 2
$ echo -ne '\''\xf5\xea'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5\xea'\''|json -b 3
$ echo -ne '\''\xf5\xd5'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5\xd5'\''|json -b 1
$ echo -ne '\''\xf5\xd5'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5\xd5'\''|json -b 2
$ echo -ne '\''\xf5\xd5'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf5\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf5\xd5'\''|json -b 3
$ echo -ne '\''\xf2\xea'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf2\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf2\xea'\''|json -b 1
$ echo -ne '\''\xf2\xea'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf2\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf2\xea'\''|json -b 2
$ echo -ne '\''\xf2\xea'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf2\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf2\xea'\''|json -b 3
$ echo -ne '\''\xf2\xd5'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf2\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf2\xd5'\''|json -b 1
$ echo -ne '\''\xf2\xd5'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf2\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf2\xd5'\''|json -b 2
$ echo -ne '\''\xf2\xd5'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xf2\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xf2\xd5'\''|json -b 3'
) -L utf8-10.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'

echo '$ echo -ne '\''\xf5\xea'\''|json -b 1'
echo -ne '\xf5\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xea'\''|json -b 1'

echo '$ echo -ne '\''\xf5\xea'\''|json -b 2'
echo -ne '\xf5\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xea'\''|json -b 2'

echo '$ echo -ne '\''\xf5\xea'\''|json -b 3'
echo -ne '\xf5\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xea'\''|json -b 3'

echo '$ echo -ne '\''\xf5\xd5'\''|json -b 1'
echo -ne '\xf5\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xf5\xd5'\''|json -b 2'
echo -ne '\xf5\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xf5\xd5'\''|json -b 3'
echo -ne '\xf5\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xf2\xea'\''|json -b 1'
echo -ne '\xf2\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xea'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xea'\''|json -b 2'
echo -ne '\xf2\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xea'\''|json -b 2'

echo '$ echo -ne '\''\xf2\xea'\''|json -b 3'
echo -ne '\xf2\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xea'\''|json -b 3'

echo '$ echo -ne '\''\xf2\xd5'\''|json -b 1'
echo -ne '\xf2\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xd5'\''|json -b 2'
echo -ne '\xf2\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xf2\xd5'\''|json -b 3'
echo -ne '\xf2\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xd5'\''|json -b 3'
)

