#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-non-ascii
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-non-ascii.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --quote-control --ascii-only -b2 "$@"; }
$ echo -e '\''"\x80"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x80"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x80"'\''|json
$ echo -e '\''"\x81"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x81"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x81"'\''|json
$ echo -e '\''"\x82"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x82"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x82"'\''|json
$ echo -e '\''"\x83"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x83"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x83"'\''|json
$ echo -e '\''"\x84"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x84"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x84"'\''|json
$ echo -e '\''"\x85"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x85"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x85"'\''|json
$ echo -e '\''"\x86"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x86"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x86"'\''|json
$ echo -e '\''"\x87"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x87"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x87"'\''|json
$ echo -e '\''"\x88"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x88"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x88"'\''|json
$ echo -e '\''"\x89"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x89"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x89"'\''|json
$ echo -e '\''"\x8a"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x8a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8a"'\''|json
$ echo -e '\''"\x8b"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x8b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8b"'\''|json
$ echo -e '\''"\x8c"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x8c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8c"'\''|json
$ echo -e '\''"\x8d"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x8d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8d"'\''|json
$ echo -e '\''"\x8e"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x8e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8e"'\''|json
$ echo -e '\''"\x8f"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x8f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8f"'\''|json
$ echo -e '\''"\x90"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x90"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x90"'\''|json
$ echo -e '\''"\x91"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x91"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x91"'\''|json
$ echo -e '\''"\x92"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x92"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x92"'\''|json
$ echo -e '\''"\x93"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x93"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x93"'\''|json
$ echo -e '\''"\x94"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x94"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x94"'\''|json
$ echo -e '\''"\x95"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x95"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x95"'\''|json
$ echo -e '\''"\x96"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x96"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x96"'\''|json
$ echo -e '\''"\x97"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x97"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x97"'\''|json
$ echo -e '\''"\x98"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x98"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x98"'\''|json
$ echo -e '\''"\x99"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x99"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x99"'\''|json
$ echo -e '\''"\x9a"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x9a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9a"'\''|json
$ echo -e '\''"\x9b"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x9b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9b"'\''|json
$ echo -e '\''"\x9c"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x9c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9c"'\''|json
$ echo -e '\''"\x9d"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x9d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9d"'\''|json
$ echo -e '\''"\x9e"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x9e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9e"'\''|json
$ echo -e '\''"\x9f"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x9f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9f"'\''|json
$ echo -e '\''"\xa0"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa0"'\''|json
$ echo -e '\''"\xa1"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa1"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa1"'\''|json
$ echo -e '\''"\xa2"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa2"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa2"'\''|json
$ echo -e '\''"\xa3"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa3"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa3"'\''|json
$ echo -e '\''"\xa4"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa4"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa4"'\''|json
$ echo -e '\''"\xa5"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa5"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa5"'\''|json
$ echo -e '\''"\xa6"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa6"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa6"'\''|json
$ echo -e '\''"\xa7"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa7"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa7"'\''|json
$ echo -e '\''"\xa8"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa8"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa8"'\''|json
$ echo -e '\''"\xa9"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xa9"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa9"'\''|json
$ echo -e '\''"\xaa"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xaa"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xaa"'\''|json
$ echo -e '\''"\xab"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xab"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xab"'\''|json
$ echo -e '\''"\xac"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xac"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xac"'\''|json
$ echo -e '\''"\xad"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xad"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xad"'\''|json
$ echo -e '\''"\xae"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xae"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xae"'\''|json
$ echo -e '\''"\xaf"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xaf"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xaf"'\''|json
$ echo -e '\''"\xb0"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb0"'\''|json
$ echo -e '\''"\xb1"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb1"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb1"'\''|json
$ echo -e '\''"\xb2"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb2"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb2"'\''|json
$ echo -e '\''"\xb3"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb3"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb3"'\''|json
$ echo -e '\''"\xb4"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb4"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb4"'\''|json
$ echo -e '\''"\xb5"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb5"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb5"'\''|json
$ echo -e '\''"\xb6"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb6"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb6"'\''|json
$ echo -e '\''"\xb7"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb7"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb7"'\''|json
$ echo -e '\''"\xb8"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb8"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb8"'\''|json
$ echo -e '\''"\xb9"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xb9"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb9"'\''|json
$ echo -e '\''"\xba"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xba"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xba"'\''|json
$ echo -e '\''"\xbb"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xbb"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xbb"'\''|json
$ echo -e '\''"\xbc"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xbc"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xbc"'\''|json
$ echo -e '\''"\xbd"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xbd"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xbd"'\''|json
$ echo -e '\''"\xbe"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xbe"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xbe"'\''|json
$ echo -e '\''"\xbf"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xbf"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xbf"'\''|json
$ echo -e '\''"\xc0"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc0"'\''|json
$ echo -e '\''"\xc1"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc1"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc1"'\''|json
$ echo -e '\''"\xc2"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc2"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc2"'\''|json
$ echo -e '\''"\xc3"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc3"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc3"'\''|json
$ echo -e '\''"\xc4"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc4"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc4"'\''|json
$ echo -e '\''"\xc5"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc5"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc5"'\''|json
$ echo -e '\''"\xc6"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc6"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc6"'\''|json
$ echo -e '\''"\xc7"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc7"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc7"'\''|json
$ echo -e '\''"\xc8"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc8"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc8"'\''|json
$ echo -e '\''"\xc9"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xc9"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc9"'\''|json
$ echo -e '\''"\xca"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xca"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xca"'\''|json
$ echo -e '\''"\xcb"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xcb"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xcb"'\''|json
$ echo -e '\''"\xcc"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xcc"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xcc"'\''|json
$ echo -e '\''"\xcd"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xcd"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xcd"'\''|json
$ echo -e '\''"\xce"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xce"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xce"'\''|json
$ echo -e '\''"\xcf"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xcf"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xcf"'\''|json
$ echo -e '\''"\xd0"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd0"'\''|json
$ echo -e '\''"\xd1"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd1"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd1"'\''|json
$ echo -e '\''"\xd2"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd2"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd2"'\''|json
$ echo -e '\''"\xd3"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd3"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd3"'\''|json
$ echo -e '\''"\xd4"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd4"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd4"'\''|json
$ echo -e '\''"\xd5"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd5"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd5"'\''|json
$ echo -e '\''"\xd6"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd6"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd6"'\''|json
$ echo -e '\''"\xd7"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd7"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd7"'\''|json
$ echo -e '\''"\xd8"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd8"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd8"'\''|json
$ echo -e '\''"\xd9"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xd9"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd9"'\''|json
$ echo -e '\''"\xda"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xda"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xda"'\''|json
$ echo -e '\''"\xdb"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xdb"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xdb"'\''|json
$ echo -e '\''"\xdc"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xdc"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xdc"'\''|json
$ echo -e '\''"\xdd"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xdd"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xdd"'\''|json
$ echo -e '\''"\xde"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xde"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xde"'\''|json
$ echo -e '\''"\xdf"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xdf"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xdf"'\''|json
$ echo -e '\''"\xe0"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe0"'\''|json
$ echo -e '\''"\xe1"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe1"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe1"'\''|json
$ echo -e '\''"\xe2"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe2"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe2"'\''|json
$ echo -e '\''"\xe3"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe3"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe3"'\''|json
$ echo -e '\''"\xe4"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe4"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe4"'\''|json
$ echo -e '\''"\xe5"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe5"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe5"'\''|json
$ echo -e '\''"\xe6"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe6"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe6"'\''|json
$ echo -e '\''"\xe7"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe7"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe7"'\''|json
$ echo -e '\''"\xe8"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe8"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe8"'\''|json
$ echo -e '\''"\xe9"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xe9"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe9"'\''|json
$ echo -e '\''"\xea"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xea"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xea"'\''|json
$ echo -e '\''"\xeb"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xeb"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xeb"'\''|json
$ echo -e '\''"\xec"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xec"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xec"'\''|json
$ echo -e '\''"\xed"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xed"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xed"'\''|json
$ echo -e '\''"\xee"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xee"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xee"'\''|json
$ echo -e '\''"\xef"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xef"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xef"'\''|json
$ echo -e '\''"\xf0"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf0"'\''|json
$ echo -e '\''"\xf1"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf1"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf1"'\''|json
$ echo -e '\''"\xf2"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf2"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf2"'\''|json
$ echo -e '\''"\xf3"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf3"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf3"'\''|json
$ echo -e '\''"\xf4"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf4"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf4"'\''|json
$ echo -e '\''"\xf5"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf5"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf5"'\''|json
$ echo -e '\''"\xf6"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf6"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf6"'\''|json
$ echo -e '\''"\xf7"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf7"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf7"'\''|json
$ echo -e '\''"\xf8"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf8"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf8"'\''|json
$ echo -e '\''"\xf9"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xf9"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf9"'\''|json
$ echo -e '\''"\xfa"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xfa"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xfa"'\''|json
$ echo -e '\''"\xfb"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xfb"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xfb"'\''|json
$ echo -e '\''"\xfc"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xfc"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xfc"'\''|json
$ echo -e '\''"\xfd"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xfd"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xfd"'\''|json
$ echo -e '\''"\xfe"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xfe"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xfe"'\''|json
$ echo -e '\''"\xff"'\''|json
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\xff"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xff"'\''|json'
) -L string-non-ascii.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --quote-control --ascii-only -b2 "$@"; }'
json() { json0 --literal-value --quote-control --ascii-only -b2 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --quote-control --ascii-only -b2 "$@"; }'

echo '$ echo -e '\''"\x80"'\''|json'
echo -e '"\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x80"'\''|json'

echo '$ echo -e '\''"\x81"'\''|json'
echo -e '"\x81"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x81"'\''|json'

echo '$ echo -e '\''"\x82"'\''|json'
echo -e '"\x82"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x82"'\''|json'

echo '$ echo -e '\''"\x83"'\''|json'
echo -e '"\x83"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x83"'\''|json'

echo '$ echo -e '\''"\x84"'\''|json'
echo -e '"\x84"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x84"'\''|json'

echo '$ echo -e '\''"\x85"'\''|json'
echo -e '"\x85"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x85"'\''|json'

echo '$ echo -e '\''"\x86"'\''|json'
echo -e '"\x86"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x86"'\''|json'

echo '$ echo -e '\''"\x87"'\''|json'
echo -e '"\x87"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x87"'\''|json'

echo '$ echo -e '\''"\x88"'\''|json'
echo -e '"\x88"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x88"'\''|json'

echo '$ echo -e '\''"\x89"'\''|json'
echo -e '"\x89"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x89"'\''|json'

echo '$ echo -e '\''"\x8a"'\''|json'
echo -e '"\x8a"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x8a"'\''|json'

echo '$ echo -e '\''"\x8b"'\''|json'
echo -e '"\x8b"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x8b"'\''|json'

echo '$ echo -e '\''"\x8c"'\''|json'
echo -e '"\x8c"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x8c"'\''|json'

echo '$ echo -e '\''"\x8d"'\''|json'
echo -e '"\x8d"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x8d"'\''|json'

echo '$ echo -e '\''"\x8e"'\''|json'
echo -e '"\x8e"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x8e"'\''|json'

echo '$ echo -e '\''"\x8f"'\''|json'
echo -e '"\x8f"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x8f"'\''|json'

echo '$ echo -e '\''"\x90"'\''|json'
echo -e '"\x90"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x90"'\''|json'

echo '$ echo -e '\''"\x91"'\''|json'
echo -e '"\x91"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x91"'\''|json'

echo '$ echo -e '\''"\x92"'\''|json'
echo -e '"\x92"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x92"'\''|json'

echo '$ echo -e '\''"\x93"'\''|json'
echo -e '"\x93"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x93"'\''|json'

echo '$ echo -e '\''"\x94"'\''|json'
echo -e '"\x94"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x94"'\''|json'

echo '$ echo -e '\''"\x95"'\''|json'
echo -e '"\x95"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x95"'\''|json'

echo '$ echo -e '\''"\x96"'\''|json'
echo -e '"\x96"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x96"'\''|json'

echo '$ echo -e '\''"\x97"'\''|json'
echo -e '"\x97"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x97"'\''|json'

echo '$ echo -e '\''"\x98"'\''|json'
echo -e '"\x98"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x98"'\''|json'

echo '$ echo -e '\''"\x99"'\''|json'
echo -e '"\x99"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x99"'\''|json'

echo '$ echo -e '\''"\x9a"'\''|json'
echo -e '"\x9a"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x9a"'\''|json'

echo '$ echo -e '\''"\x9b"'\''|json'
echo -e '"\x9b"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x9b"'\''|json'

echo '$ echo -e '\''"\x9c"'\''|json'
echo -e '"\x9c"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x9c"'\''|json'

echo '$ echo -e '\''"\x9d"'\''|json'
echo -e '"\x9d"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x9d"'\''|json'

echo '$ echo -e '\''"\x9e"'\''|json'
echo -e '"\x9e"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x9e"'\''|json'

echo '$ echo -e '\''"\x9f"'\''|json'
echo -e '"\x9f"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x9f"'\''|json'

echo '$ echo -e '\''"\xa0"'\''|json'
echo -e '"\xa0"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa0"'\''|json'

echo '$ echo -e '\''"\xa1"'\''|json'
echo -e '"\xa1"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa1"'\''|json'

echo '$ echo -e '\''"\xa2"'\''|json'
echo -e '"\xa2"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa2"'\''|json'

echo '$ echo -e '\''"\xa3"'\''|json'
echo -e '"\xa3"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa3"'\''|json'

echo '$ echo -e '\''"\xa4"'\''|json'
echo -e '"\xa4"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa4"'\''|json'

echo '$ echo -e '\''"\xa5"'\''|json'
echo -e '"\xa5"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa5"'\''|json'

echo '$ echo -e '\''"\xa6"'\''|json'
echo -e '"\xa6"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa6"'\''|json'

echo '$ echo -e '\''"\xa7"'\''|json'
echo -e '"\xa7"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa7"'\''|json'

echo '$ echo -e '\''"\xa8"'\''|json'
echo -e '"\xa8"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa8"'\''|json'

echo '$ echo -e '\''"\xa9"'\''|json'
echo -e '"\xa9"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xa9"'\''|json'

echo '$ echo -e '\''"\xaa"'\''|json'
echo -e '"\xaa"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xaa"'\''|json'

echo '$ echo -e '\''"\xab"'\''|json'
echo -e '"\xab"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xab"'\''|json'

echo '$ echo -e '\''"\xac"'\''|json'
echo -e '"\xac"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xac"'\''|json'

echo '$ echo -e '\''"\xad"'\''|json'
echo -e '"\xad"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xad"'\''|json'

echo '$ echo -e '\''"\xae"'\''|json'
echo -e '"\xae"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xae"'\''|json'

echo '$ echo -e '\''"\xaf"'\''|json'
echo -e '"\xaf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xaf"'\''|json'

echo '$ echo -e '\''"\xb0"'\''|json'
echo -e '"\xb0"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb0"'\''|json'

echo '$ echo -e '\''"\xb1"'\''|json'
echo -e '"\xb1"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb1"'\''|json'

echo '$ echo -e '\''"\xb2"'\''|json'
echo -e '"\xb2"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb2"'\''|json'

echo '$ echo -e '\''"\xb3"'\''|json'
echo -e '"\xb3"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb3"'\''|json'

echo '$ echo -e '\''"\xb4"'\''|json'
echo -e '"\xb4"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb4"'\''|json'

echo '$ echo -e '\''"\xb5"'\''|json'
echo -e '"\xb5"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb5"'\''|json'

echo '$ echo -e '\''"\xb6"'\''|json'
echo -e '"\xb6"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb6"'\''|json'

echo '$ echo -e '\''"\xb7"'\''|json'
echo -e '"\xb7"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb7"'\''|json'

echo '$ echo -e '\''"\xb8"'\''|json'
echo -e '"\xb8"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb8"'\''|json'

echo '$ echo -e '\''"\xb9"'\''|json'
echo -e '"\xb9"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xb9"'\''|json'

echo '$ echo -e '\''"\xba"'\''|json'
echo -e '"\xba"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xba"'\''|json'

echo '$ echo -e '\''"\xbb"'\''|json'
echo -e '"\xbb"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xbb"'\''|json'

echo '$ echo -e '\''"\xbc"'\''|json'
echo -e '"\xbc"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xbc"'\''|json'

echo '$ echo -e '\''"\xbd"'\''|json'
echo -e '"\xbd"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xbd"'\''|json'

echo '$ echo -e '\''"\xbe"'\''|json'
echo -e '"\xbe"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xbe"'\''|json'

echo '$ echo -e '\''"\xbf"'\''|json'
echo -e '"\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xbf"'\''|json'

echo '$ echo -e '\''"\xc0"'\''|json'
echo -e '"\xc0"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc0"'\''|json'

echo '$ echo -e '\''"\xc1"'\''|json'
echo -e '"\xc1"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc1"'\''|json'

echo '$ echo -e '\''"\xc2"'\''|json'
echo -e '"\xc2"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc2"'\''|json'

echo '$ echo -e '\''"\xc3"'\''|json'
echo -e '"\xc3"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc3"'\''|json'

echo '$ echo -e '\''"\xc4"'\''|json'
echo -e '"\xc4"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc4"'\''|json'

echo '$ echo -e '\''"\xc5"'\''|json'
echo -e '"\xc5"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc5"'\''|json'

echo '$ echo -e '\''"\xc6"'\''|json'
echo -e '"\xc6"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc6"'\''|json'

echo '$ echo -e '\''"\xc7"'\''|json'
echo -e '"\xc7"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc7"'\''|json'

echo '$ echo -e '\''"\xc8"'\''|json'
echo -e '"\xc8"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc8"'\''|json'

echo '$ echo -e '\''"\xc9"'\''|json'
echo -e '"\xc9"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc9"'\''|json'

echo '$ echo -e '\''"\xca"'\''|json'
echo -e '"\xca"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xca"'\''|json'

echo '$ echo -e '\''"\xcb"'\''|json'
echo -e '"\xcb"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xcb"'\''|json'

echo '$ echo -e '\''"\xcc"'\''|json'
echo -e '"\xcc"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xcc"'\''|json'

echo '$ echo -e '\''"\xcd"'\''|json'
echo -e '"\xcd"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xcd"'\''|json'

echo '$ echo -e '\''"\xce"'\''|json'
echo -e '"\xce"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xce"'\''|json'

echo '$ echo -e '\''"\xcf"'\''|json'
echo -e '"\xcf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xcf"'\''|json'

echo '$ echo -e '\''"\xd0"'\''|json'
echo -e '"\xd0"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd0"'\''|json'

echo '$ echo -e '\''"\xd1"'\''|json'
echo -e '"\xd1"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd1"'\''|json'

echo '$ echo -e '\''"\xd2"'\''|json'
echo -e '"\xd2"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd2"'\''|json'

echo '$ echo -e '\''"\xd3"'\''|json'
echo -e '"\xd3"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd3"'\''|json'

echo '$ echo -e '\''"\xd4"'\''|json'
echo -e '"\xd4"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd4"'\''|json'

echo '$ echo -e '\''"\xd5"'\''|json'
echo -e '"\xd5"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd5"'\''|json'

echo '$ echo -e '\''"\xd6"'\''|json'
echo -e '"\xd6"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd6"'\''|json'

echo '$ echo -e '\''"\xd7"'\''|json'
echo -e '"\xd7"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd7"'\''|json'

echo '$ echo -e '\''"\xd8"'\''|json'
echo -e '"\xd8"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd8"'\''|json'

echo '$ echo -e '\''"\xd9"'\''|json'
echo -e '"\xd9"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xd9"'\''|json'

echo '$ echo -e '\''"\xda"'\''|json'
echo -e '"\xda"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xda"'\''|json'

echo '$ echo -e '\''"\xdb"'\''|json'
echo -e '"\xdb"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xdb"'\''|json'

echo '$ echo -e '\''"\xdc"'\''|json'
echo -e '"\xdc"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xdc"'\''|json'

echo '$ echo -e '\''"\xdd"'\''|json'
echo -e '"\xdd"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xdd"'\''|json'

echo '$ echo -e '\''"\xde"'\''|json'
echo -e '"\xde"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xde"'\''|json'

echo '$ echo -e '\''"\xdf"'\''|json'
echo -e '"\xdf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xdf"'\''|json'

echo '$ echo -e '\''"\xe0"'\''|json'
echo -e '"\xe0"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe0"'\''|json'

echo '$ echo -e '\''"\xe1"'\''|json'
echo -e '"\xe1"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe1"'\''|json'

echo '$ echo -e '\''"\xe2"'\''|json'
echo -e '"\xe2"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe2"'\''|json'

echo '$ echo -e '\''"\xe3"'\''|json'
echo -e '"\xe3"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe3"'\''|json'

echo '$ echo -e '\''"\xe4"'\''|json'
echo -e '"\xe4"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe4"'\''|json'

echo '$ echo -e '\''"\xe5"'\''|json'
echo -e '"\xe5"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe5"'\''|json'

echo '$ echo -e '\''"\xe6"'\''|json'
echo -e '"\xe6"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe6"'\''|json'

echo '$ echo -e '\''"\xe7"'\''|json'
echo -e '"\xe7"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe7"'\''|json'

echo '$ echo -e '\''"\xe8"'\''|json'
echo -e '"\xe8"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe8"'\''|json'

echo '$ echo -e '\''"\xe9"'\''|json'
echo -e '"\xe9"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xe9"'\''|json'

echo '$ echo -e '\''"\xea"'\''|json'
echo -e '"\xea"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xea"'\''|json'

echo '$ echo -e '\''"\xeb"'\''|json'
echo -e '"\xeb"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xeb"'\''|json'

echo '$ echo -e '\''"\xec"'\''|json'
echo -e '"\xec"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xec"'\''|json'

echo '$ echo -e '\''"\xed"'\''|json'
echo -e '"\xed"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xed"'\''|json'

echo '$ echo -e '\''"\xee"'\''|json'
echo -e '"\xee"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xee"'\''|json'

echo '$ echo -e '\''"\xef"'\''|json'
echo -e '"\xef"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xef"'\''|json'

echo '$ echo -e '\''"\xf0"'\''|json'
echo -e '"\xf0"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0"'\''|json'

echo '$ echo -e '\''"\xf1"'\''|json'
echo -e '"\xf1"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1"'\''|json'

echo '$ echo -e '\''"\xf2"'\''|json'
echo -e '"\xf2"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf2"'\''|json'

echo '$ echo -e '\''"\xf3"'\''|json'
echo -e '"\xf3"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3"'\''|json'

echo '$ echo -e '\''"\xf4"'\''|json'
echo -e '"\xf4"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4"'\''|json'

echo '$ echo -e '\''"\xf5"'\''|json'
echo -e '"\xf5"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf5"'\''|json'

echo '$ echo -e '\''"\xf6"'\''|json'
echo -e '"\xf6"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf6"'\''|json'

echo '$ echo -e '\''"\xf7"'\''|json'
echo -e '"\xf7"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf7"'\''|json'

echo '$ echo -e '\''"\xf8"'\''|json'
echo -e '"\xf8"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf8"'\''|json'

echo '$ echo -e '\''"\xf9"'\''|json'
echo -e '"\xf9"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf9"'\''|json'

echo '$ echo -e '\''"\xfa"'\''|json'
echo -e '"\xfa"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xfa"'\''|json'

echo '$ echo -e '\''"\xfb"'\''|json'
echo -e '"\xfb"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xfb"'\''|json'

echo '$ echo -e '\''"\xfc"'\''|json'
echo -e '"\xfc"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xfc"'\''|json'

echo '$ echo -e '\''"\xfd"'\''|json'
echo -e '"\xfd"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xfd"'\''|json'

echo '$ echo -e '\''"\xfe"'\''|json'
echo -e '"\xfe"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xfe"'\''|json'

echo '$ echo -e '\''"\xff"'\''|json'
echo -e '"\xff"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xff"'\''|json'
)

