#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def-gcc:node-closed-array-dict-any3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-closed-array-dict-any3.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};
$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __1 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __2 = {
    .sym = '\''o'\'',
    .EQ = &__1
};
static const struct json_type_dict_trie_node_t __3 = {
    .sym = '\''o'\'',
    .EQ = &__2
};
static const struct json_type_dict_trie_node_t __4 = {
    .sym = '\''f'\'',
    .EQ = &__3
};
static const struct json_type_dict_trie_t __5 = {
    .root = &__4
};
static const struct json_type_dict_node_arg_t __6[] = {
    {
        .name = (const uchar_t*) "foo",
        .type = &__0
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__5,
    .node.dict = {
        .args = __6,
        .size = 1
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_dict_trie_node_t __9 = {
    .sym = '\''\0'\'',
    .VAL = 0
};
static const struct json_type_dict_trie_node_t __10 = {
    .sym = '\''r'\'',
    .EQ = &__9
};
static const struct json_type_dict_trie_node_t __11 = {
    .sym = '\''a'\'',
    .EQ = &__10
};
static const struct json_type_dict_trie_node_t __12 = {
    .sym = '\''b'\'',
    .EQ = &__11
};
static const struct json_type_dict_trie_t __13 = {
    .root = &__12
};
static const struct json_type_dict_node_arg_t __14[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__8
    }
};
static const struct json_type_node_t __15 = {
    .type = json_type_dict_node_type,
    .attr.dict = &__13,
    .node.dict = {
        .args = __14,
        .size = 1
    }
};
static const struct json_type_node_t* __16[] = {
    &__7,
    &__15,
    NULL
};
static const struct json_type_node_t __17 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __16,
            .size = 2
        }
    }
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_node_type,
    .val.node = &__17
};'
) -L node-closed-array-dict-any3.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'1i\\\\\\#include "json-type.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee /dev/fd/2|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"type"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"null"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"boolean"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"number"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"string"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"object"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"type"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"null"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"boolean"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"number"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"string"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"object"}]}]}'\'''

echo '$ json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
json <<< '{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"array","args":[{"type":"dict","args":[{"name":"foo","type":"array"}]},{"type":"dict","args":[{"name":"bar","type":"array"}]}]}'\'''
)

