#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:literal6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L literal6.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo -n n|json -b 1
json: error: <stdin>:1:2: lex error: invalid literal
json: error: <stdin>:1:2: n
json: error: <stdin>:1:2:  ^
command failed: echo -n n|json -b 1
$ echo -n n|json -b 2
json: error: <stdin>:1:2: lex error: invalid literal
json: error: <stdin>:1:2: n
json: error: <stdin>:1:2:  ^
command failed: echo -n n|json -b 2
$ echo -n nu|json -b 1
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: nu
json: error: <stdin>:1:3:   ^
command failed: echo -n nu|json -b 1
$ echo -n nu|json -b 2
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: nu
json: error: <stdin>:1:3:   ^
command failed: echo -n nu|json -b 2
$ echo -n nu|json -b 3
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: nu
json: error: <stdin>:1:3:   ^
command failed: echo -n nu|json -b 3
$ echo -n nul|json -b 1
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: nul
json: error: <stdin>:1:4:    ^
command failed: echo -n nul|json -b 1
$ echo -n nul|json -b 2
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: nul
json: error: <stdin>:1:4:    ^
command failed: echo -n nul|json -b 2
$ echo -n nul|json -b 3
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: nul
json: error: <stdin>:1:4:    ^
command failed: echo -n nul|json -b 3
$ echo -n nul|json -b 4
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: nul
json: error: <stdin>:1:4:    ^
command failed: echo -n nul|json -b 4
$ echo -n null|json -b 1
null
$ echo -n null|json -b 2
null
$ echo -n null|json -b 3
null
$ echo -n null|json -b 4
null
$ echo -n null|json -b 5
null
$ echo -n f|json -b 1
json: error: <stdin>:1:2: lex error: invalid literal
json: error: <stdin>:1:2: f
json: error: <stdin>:1:2:  ^
command failed: echo -n f|json -b 1
$ echo -n f|json -b 2
json: error: <stdin>:1:2: lex error: invalid literal
json: error: <stdin>:1:2: f
json: error: <stdin>:1:2:  ^
command failed: echo -n f|json -b 2
$ echo -n fa|json -b 1
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: fa
json: error: <stdin>:1:3:   ^
command failed: echo -n fa|json -b 1
$ echo -n fa|json -b 2
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: fa
json: error: <stdin>:1:3:   ^
command failed: echo -n fa|json -b 2
$ echo -n fa|json -b 3
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: fa
json: error: <stdin>:1:3:   ^
command failed: echo -n fa|json -b 3
$ echo -n fal|json -b 1
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: fal
json: error: <stdin>:1:4:    ^
command failed: echo -n fal|json -b 1
$ echo -n fal|json -b 2
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: fal
json: error: <stdin>:1:4:    ^
command failed: echo -n fal|json -b 2
$ echo -n fal|json -b 3
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: fal
json: error: <stdin>:1:4:    ^
command failed: echo -n fal|json -b 3
$ echo -n fal|json -b 4
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: fal
json: error: <stdin>:1:4:    ^
command failed: echo -n fal|json -b 4
$ echo -n fals|json -b 1
json: error: <stdin>:1:5: lex error: invalid literal
json: error: <stdin>:1:5: fals
json: error: <stdin>:1:5:     ^
command failed: echo -n fals|json -b 1
$ echo -n fals|json -b 2
json: error: <stdin>:1:5: lex error: invalid literal
json: error: <stdin>:1:5: fals
json: error: <stdin>:1:5:     ^
command failed: echo -n fals|json -b 2
$ echo -n fals|json -b 3
json: error: <stdin>:1:5: lex error: invalid literal
json: error: <stdin>:1:5: fals
json: error: <stdin>:1:5:     ^
command failed: echo -n fals|json -b 3
$ echo -n fals|json -b 4
json: error: <stdin>:1:5: lex error: invalid literal
json: error: <stdin>:1:5: fals
json: error: <stdin>:1:5:     ^
command failed: echo -n fals|json -b 4
$ echo -n fals|json -b 5
json: error: <stdin>:1:5: lex error: invalid literal
json: error: <stdin>:1:5: fals
json: error: <stdin>:1:5:     ^
command failed: echo -n fals|json -b 5
$ echo -n false|json -b 1
false
$ echo -n false|json -b 2
false
$ echo -n false|json -b 3
false
$ echo -n false|json -b 4
false
$ echo -n false|json -b 5
false
$ echo -n false|json -b 6
false
$ echo -n t|json -b 1
json: error: <stdin>:1:2: lex error: invalid literal
json: error: <stdin>:1:2: t
json: error: <stdin>:1:2:  ^
command failed: echo -n t|json -b 1
$ echo -n t|json -b 2
json: error: <stdin>:1:2: lex error: invalid literal
json: error: <stdin>:1:2: t
json: error: <stdin>:1:2:  ^
command failed: echo -n t|json -b 2
$ echo -n tr|json -b 1
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: tr
json: error: <stdin>:1:3:   ^
command failed: echo -n tr|json -b 1
$ echo -n tr|json -b 2
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: tr
json: error: <stdin>:1:3:   ^
command failed: echo -n tr|json -b 2
$ echo -n tr|json -b 3
json: error: <stdin>:1:3: lex error: invalid literal
json: error: <stdin>:1:3: tr
json: error: <stdin>:1:3:   ^
command failed: echo -n tr|json -b 3
$ echo -n tru|json -b 1
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: tru
json: error: <stdin>:1:4:    ^
command failed: echo -n tru|json -b 1
$ echo -n tru|json -b 2
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: tru
json: error: <stdin>:1:4:    ^
command failed: echo -n tru|json -b 2
$ echo -n tru|json -b 3
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: tru
json: error: <stdin>:1:4:    ^
command failed: echo -n tru|json -b 3
$ echo -n tru|json -b 4
json: error: <stdin>:1:4: lex error: invalid literal
json: error: <stdin>:1:4: tru
json: error: <stdin>:1:4:    ^
command failed: echo -n tru|json -b 4
$ echo -n true|json -b 1
true
$ echo -n true|json -b 2
true
$ echo -n true|json -b 3
true
$ echo -n true|json -b 4
true
$ echo -n true|json -b 5
true'
) -L literal6.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo -n n|json -b 1'
echo -n n|json -b 1 2>&1 ||
echo 'command failed: echo -n n|json -b 1'

echo '$ echo -n n|json -b 2'
echo -n n|json -b 2 2>&1 ||
echo 'command failed: echo -n n|json -b 2'

echo '$ echo -n nu|json -b 1'
echo -n nu|json -b 1 2>&1 ||
echo 'command failed: echo -n nu|json -b 1'

echo '$ echo -n nu|json -b 2'
echo -n nu|json -b 2 2>&1 ||
echo 'command failed: echo -n nu|json -b 2'

echo '$ echo -n nu|json -b 3'
echo -n nu|json -b 3 2>&1 ||
echo 'command failed: echo -n nu|json -b 3'

echo '$ echo -n nul|json -b 1'
echo -n nul|json -b 1 2>&1 ||
echo 'command failed: echo -n nul|json -b 1'

echo '$ echo -n nul|json -b 2'
echo -n nul|json -b 2 2>&1 ||
echo 'command failed: echo -n nul|json -b 2'

echo '$ echo -n nul|json -b 3'
echo -n nul|json -b 3 2>&1 ||
echo 'command failed: echo -n nul|json -b 3'

echo '$ echo -n nul|json -b 4'
echo -n nul|json -b 4 2>&1 ||
echo 'command failed: echo -n nul|json -b 4'

echo '$ echo -n null|json -b 1'
echo -n null|json -b 1 2>&1 ||
echo 'command failed: echo -n null|json -b 1'

echo '$ echo -n null|json -b 2'
echo -n null|json -b 2 2>&1 ||
echo 'command failed: echo -n null|json -b 2'

echo '$ echo -n null|json -b 3'
echo -n null|json -b 3 2>&1 ||
echo 'command failed: echo -n null|json -b 3'

echo '$ echo -n null|json -b 4'
echo -n null|json -b 4 2>&1 ||
echo 'command failed: echo -n null|json -b 4'

echo '$ echo -n null|json -b 5'
echo -n null|json -b 5 2>&1 ||
echo 'command failed: echo -n null|json -b 5'

echo '$ echo -n f|json -b 1'
echo -n f|json -b 1 2>&1 ||
echo 'command failed: echo -n f|json -b 1'

echo '$ echo -n f|json -b 2'
echo -n f|json -b 2 2>&1 ||
echo 'command failed: echo -n f|json -b 2'

echo '$ echo -n fa|json -b 1'
echo -n fa|json -b 1 2>&1 ||
echo 'command failed: echo -n fa|json -b 1'

echo '$ echo -n fa|json -b 2'
echo -n fa|json -b 2 2>&1 ||
echo 'command failed: echo -n fa|json -b 2'

echo '$ echo -n fa|json -b 3'
echo -n fa|json -b 3 2>&1 ||
echo 'command failed: echo -n fa|json -b 3'

echo '$ echo -n fal|json -b 1'
echo -n fal|json -b 1 2>&1 ||
echo 'command failed: echo -n fal|json -b 1'

echo '$ echo -n fal|json -b 2'
echo -n fal|json -b 2 2>&1 ||
echo 'command failed: echo -n fal|json -b 2'

echo '$ echo -n fal|json -b 3'
echo -n fal|json -b 3 2>&1 ||
echo 'command failed: echo -n fal|json -b 3'

echo '$ echo -n fal|json -b 4'
echo -n fal|json -b 4 2>&1 ||
echo 'command failed: echo -n fal|json -b 4'

echo '$ echo -n fals|json -b 1'
echo -n fals|json -b 1 2>&1 ||
echo 'command failed: echo -n fals|json -b 1'

echo '$ echo -n fals|json -b 2'
echo -n fals|json -b 2 2>&1 ||
echo 'command failed: echo -n fals|json -b 2'

echo '$ echo -n fals|json -b 3'
echo -n fals|json -b 3 2>&1 ||
echo 'command failed: echo -n fals|json -b 3'

echo '$ echo -n fals|json -b 4'
echo -n fals|json -b 4 2>&1 ||
echo 'command failed: echo -n fals|json -b 4'

echo '$ echo -n fals|json -b 5'
echo -n fals|json -b 5 2>&1 ||
echo 'command failed: echo -n fals|json -b 5'

echo '$ echo -n false|json -b 1'
echo -n false|json -b 1 2>&1 ||
echo 'command failed: echo -n false|json -b 1'

echo '$ echo -n false|json -b 2'
echo -n false|json -b 2 2>&1 ||
echo 'command failed: echo -n false|json -b 2'

echo '$ echo -n false|json -b 3'
echo -n false|json -b 3 2>&1 ||
echo 'command failed: echo -n false|json -b 3'

echo '$ echo -n false|json -b 4'
echo -n false|json -b 4 2>&1 ||
echo 'command failed: echo -n false|json -b 4'

echo '$ echo -n false|json -b 5'
echo -n false|json -b 5 2>&1 ||
echo 'command failed: echo -n false|json -b 5'

echo '$ echo -n false|json -b 6'
echo -n false|json -b 6 2>&1 ||
echo 'command failed: echo -n false|json -b 6'

echo '$ echo -n t|json -b 1'
echo -n t|json -b 1 2>&1 ||
echo 'command failed: echo -n t|json -b 1'

echo '$ echo -n t|json -b 2'
echo -n t|json -b 2 2>&1 ||
echo 'command failed: echo -n t|json -b 2'

echo '$ echo -n tr|json -b 1'
echo -n tr|json -b 1 2>&1 ||
echo 'command failed: echo -n tr|json -b 1'

echo '$ echo -n tr|json -b 2'
echo -n tr|json -b 2 2>&1 ||
echo 'command failed: echo -n tr|json -b 2'

echo '$ echo -n tr|json -b 3'
echo -n tr|json -b 3 2>&1 ||
echo 'command failed: echo -n tr|json -b 3'

echo '$ echo -n tru|json -b 1'
echo -n tru|json -b 1 2>&1 ||
echo 'command failed: echo -n tru|json -b 1'

echo '$ echo -n tru|json -b 2'
echo -n tru|json -b 2 2>&1 ||
echo 'command failed: echo -n tru|json -b 2'

echo '$ echo -n tru|json -b 3'
echo -n tru|json -b 3 2>&1 ||
echo 'command failed: echo -n tru|json -b 3'

echo '$ echo -n tru|json -b 4'
echo -n tru|json -b 4 2>&1 ||
echo 'command failed: echo -n tru|json -b 4'

echo '$ echo -n true|json -b 1'
echo -n true|json -b 1 2>&1 ||
echo 'command failed: echo -n true|json -b 1'

echo '$ echo -n true|json -b 2'
echo -n true|json -b 2 2>&1 ||
echo 'command failed: echo -n true|json -b 2'

echo '$ echo -n true|json -b 3'
echo -n true|json -b 3 2>&1 ||
echo 'command failed: echo -n true|json -b 3'

echo '$ echo -n true|json -b 4'
echo -n true|json -b 4 2>&1 ||
echo 'command failed: echo -n true|json -b 4'

echo '$ echo -n true|json -b 5'
echo -n true|json -b 5 2>&1 ||
echo 'command failed: echo -n true|json -b 5'
)

