#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def:json-type
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L json-type.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }
$ json <<< '\''{"type":"list","args":[{"plain":"type"},{"plain":"null"},{"plain":"boolean"},{"plain":"number"},{"plain":"string"},{"plain":"object"},{"plain":"array"},{"type":"object","args":[{"name":"plain","type":{"type":"list","args":["null","boolean","number","string"]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"object"}},{"name":"args","type":{"type":"array","args":{"type":"object","args":[{"name":"name","type":"string"},{"name":"type","type":"type"}]}}}]},{"type":"object","args":[{"name":"type","type":{"plain":"array"}},{"name":"args","type":{"type":"list","args":["type",{"type":"array","args":"type"}]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"list"}},{"name":"args","type":{"type":"array","args":"type"}}]}]}'\''
json: error: <stdin>:1:153: attribute error: invalid "list" type object: sort of object of list type not yet supported (the inner list is at 1:201)
command failed: json <<< '\''{"type":"list","args":[{"plain":"type"},{"plain":"null"},{"plain":"boolean"},{"plain":"number"},{"plain":"string"},{"plain":"object"},{"plain":"array"},{"type":"object","args":[{"name":"plain","type":{"type":"list","args":["null","boolean","number","string"]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"object"}},{"name":"args","type":{"type":"array","args":{"type":"object","args":[{"name":"name","type":"string"},{"name":"type","type":"type"}]}}}]},{"type":"object","args":[{"name":"type","type":{"plain":"array"}},{"name":"args","type":{"type":"list","args":["type",{"type":"array","args":"type"}]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"list"}},{"name":"args","type":{"type":"array","args":"type"}}]}]}'\'''
) -L json-type.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''; }'

echo '$ json <<< '\''{"type":"list","args":[{"plain":"type"},{"plain":"null"},{"plain":"boolean"},{"plain":"number"},{"plain":"string"},{"plain":"object"},{"plain":"array"},{"type":"object","args":[{"name":"plain","type":{"type":"list","args":["null","boolean","number","string"]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"object"}},{"name":"args","type":{"type":"array","args":{"type":"object","args":[{"name":"name","type":"string"},{"name":"type","type":"type"}]}}}]},{"type":"object","args":[{"name":"type","type":{"plain":"array"}},{"name":"args","type":{"type":"list","args":["type",{"type":"array","args":"type"}]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"list"}},{"name":"args","type":{"type":"array","args":"type"}}]}]}'\'''
json <<< '{"type":"list","args":[{"plain":"type"},{"plain":"null"},{"plain":"boolean"},{"plain":"number"},{"plain":"string"},{"plain":"object"},{"plain":"array"},{"type":"object","args":[{"name":"plain","type":{"type":"list","args":["null","boolean","number","string"]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"object"}},{"name":"args","type":{"type":"array","args":{"type":"object","args":[{"name":"name","type":"string"},{"name":"type","type":"type"}]}}}]},{"type":"object","args":[{"name":"type","type":{"plain":"array"}},{"name":"args","type":{"type":"list","args":["type",{"type":"array","args":"type"}]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"list"}},{"name":"args","type":{"type":"array","args":"type"}}]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":"type"},{"plain":"null"},{"plain":"boolean"},{"plain":"number"},{"plain":"string"},{"plain":"object"},{"plain":"array"},{"type":"object","args":[{"name":"plain","type":{"type":"list","args":["null","boolean","number","string"]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"object"}},{"name":"args","type":{"type":"array","args":{"type":"object","args":[{"name":"name","type":"string"},{"name":"type","type":"type"}]}}}]},{"type":"object","args":[{"name":"type","type":{"plain":"array"}},{"name":"args","type":{"type":"list","args":["type",{"type":"array","args":"type"}]}}]},{"type":"object","args":[{"name":"type","type":{"plain":"list"}},{"name":"args","type":{"type":"array","args":"type"}}]}]}'\'''
)

