#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-empty-object
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-empty-object.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "object",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": {
            "val": {
                "type": "object",
                "args": []
            },
            "lo": null,
            "hi": null
        },
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\''
json: error: <stdin>:1:52: attribute error: invalid "list" type object: duplicated '\''object'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:52: s":[{"type":"object","args":[]},{"type":"object","args":[]}]}
json: error: <stdin>:1:52:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]},{"type":"object","args":[]}]}'\''
json: error: <stdin>:1:52: attribute error: invalid "list" type object: duplicated '\''object'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:52: s":[{"type":"object","args":[]},{"type":"object","args":[]},{"typ
json: error: <stdin>:1:52:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''
) -L list-empty-object.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]},{"type":"object","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"object","args":[]},{"type":"object","args":[]},{"type":"object","args":[]}]}'\'''
)

