#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number7.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value -b 8 "$@"; }
$ json <<< 0
0
$ json <<< 1
1
$ json <<< 12
12
$ json <<< 1234
1234
$ json <<< 12345678
12345678
$ json <<< 1234567890123456
1234567890123456
$ json <<< 12345678901234567890123456789012
12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0
0.0
$ json <<< 1.1
1.1
$ json <<< 12.12
12.12
$ json <<< 1234.1234
1234.1234
$ json <<< 12345678.12345678
12345678.12345678
$ json <<< 1234567890123456.1234567890123456
1234567890123456.1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0e0
0e0
$ json <<< 1e1
1e1
$ json <<< 12e12
12e12
$ json <<< 1234e1234
1234e1234
$ json <<< 12345678e12345678
12345678e12345678
$ json <<< 1234567890123456e1234567890123456
1234567890123456e1234567890123456
$ json <<< 12345678901234567890123456789012e12345678901234567890123456789012
12345678901234567890123456789012e12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0E0
0E0
$ json <<< 1E1
1E1
$ json <<< 12E12
12E12
$ json <<< 1234E1234
1234E1234
$ json <<< 12345678E12345678
12345678E12345678
$ json <<< 1234567890123456E1234567890123456
1234567890123456E1234567890123456
$ json <<< 12345678901234567890123456789012E12345678901234567890123456789012
12345678901234567890123456789012E12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0e-0
0e-0
$ json <<< 1e-1
1e-1
$ json <<< 12e-12
12e-12
$ json <<< 1234e-1234
1234e-1234
$ json <<< 12345678e-12345678
12345678e-12345678
$ json <<< 1234567890123456e-1234567890123456
1234567890123456e-1234567890123456
$ json <<< 12345678901234567890123456789012e-12345678901234567890123456789012
12345678901234567890123456789012e-12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0E-0
0E-0
$ json <<< 1E-1
1E-1
$ json <<< 12E-12
12E-12
$ json <<< 1234E-1234
1234E-1234
$ json <<< 12345678E-12345678
12345678E-12345678
$ json <<< 1234567890123456E-1234567890123456
1234567890123456E-1234567890123456
$ json <<< 12345678901234567890123456789012E-12345678901234567890123456789012
12345678901234567890123456789012E-12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0e+0
0e+0
$ json <<< 1e+1
1e+1
$ json <<< 12e+12
12e+12
$ json <<< 1234e+1234
1234e+1234
$ json <<< 12345678e+12345678
12345678e+12345678
$ json <<< 1234567890123456e+1234567890123456
1234567890123456e+1234567890123456
$ json <<< 12345678901234567890123456789012e+12345678901234567890123456789012
12345678901234567890123456789012e+12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0E+0
0E+0
$ json <<< 1E+1
1E+1
$ json <<< 12E+12
12E+12
$ json <<< 1234E+1234
1234E+1234
$ json <<< 12345678E+12345678
12345678E+12345678
$ json <<< 1234567890123456E+1234567890123456
1234567890123456E+1234567890123456
$ json <<< 12345678901234567890123456789012E+12345678901234567890123456789012
12345678901234567890123456789012E+12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0e0
0.0e0
$ json <<< 1.1e1
1.1e1
$ json <<< 12.12e12
12.12e12
$ json <<< 1234.1234e1234
1234.1234e1234
$ json <<< 12345678.12345678e12345678
12345678.12345678e12345678
$ json <<< 1234567890123456.1234567890123456e1234567890123456
1234567890123456.1234567890123456e1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012e12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012e12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0E0
0.0E0
$ json <<< 1.1E1
1.1E1
$ json <<< 12.12E12
12.12E12
$ json <<< 1234.1234E1234
1234.1234E1234
$ json <<< 12345678.12345678E12345678
12345678.12345678E12345678
$ json <<< 1234567890123456.1234567890123456E1234567890123456
1234567890123456.1234567890123456E1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012E12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012E12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0e-0
0.0e-0
$ json <<< 1.1e-1
1.1e-1
$ json <<< 12.12e-12
12.12e-12
$ json <<< 1234.1234e-1234
1234.1234e-1234
$ json <<< 12345678.12345678e-12345678
12345678.12345678e-12345678
$ json <<< 1234567890123456.1234567890123456e-1234567890123456
1234567890123456.1234567890123456e-1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012e-12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012e-12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0E-0
0.0E-0
$ json <<< 1.1E-1
1.1E-1
$ json <<< 12.12E-12
12.12E-12
$ json <<< 1234.1234E-1234
1234.1234E-1234
$ json <<< 12345678.12345678E-12345678
12345678.12345678E-12345678
$ json <<< 1234567890123456.1234567890123456E-1234567890123456
1234567890123456.1234567890123456E-1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012E-12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012E-12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0e+0
0.0e+0
$ json <<< 1.1e+1
1.1e+1
$ json <<< 12.12e+12
12.12e+12
$ json <<< 1234.1234e+1234
1234.1234e+1234
$ json <<< 12345678.12345678e+12345678
12345678.12345678e+12345678
$ json <<< 1234567890123456.1234567890123456e+1234567890123456
1234567890123456.1234567890123456e+1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012e+12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012e+12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234
$ json <<< 0.0E+0
0.0E+0
$ json <<< 1.1E+1
1.1E+1
$ json <<< 12.12E+12
12.12E+12
$ json <<< 1234.1234E+1234
1234.1234E+1234
$ json <<< 12345678.12345678E+12345678
12345678.12345678E+12345678
$ json <<< 1234567890123456.1234567890123456E+1234567890123456
1234567890123456.1234567890123456E+1234567890123456
$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012E+12345678901234567890123456789012
12345678901234567890123456789012.12345678901234567890123456789012E+12345678901234567890123456789012
$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234
1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234'
) -L number7.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value -b 8 "$@"; }'
json() { json0 --literal-value -b 8 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value -b 8 "$@"; }'

echo '$ json <<< 0'
json <<< 0 2>&1 ||
echo 'command failed: json <<< 0'

echo '$ json <<< 1'
json <<< 1 2>&1 ||
echo 'command failed: json <<< 1'

echo '$ json <<< 12'
json <<< 12 2>&1 ||
echo 'command failed: json <<< 12'

echo '$ json <<< 1234'
json <<< 1234 2>&1 ||
echo 'command failed: json <<< 1234'

echo '$ json <<< 12345678'
json <<< 12345678 2>&1 ||
echo 'command failed: json <<< 12345678'

echo '$ json <<< 1234567890123456'
json <<< 1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456'

echo '$ json <<< 12345678901234567890123456789012'
json <<< 12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0'
json <<< 0.0 2>&1 ||
echo 'command failed: json <<< 0.0'

echo '$ json <<< 1.1'
json <<< 1.1 2>&1 ||
echo 'command failed: json <<< 1.1'

echo '$ json <<< 12.12'
json <<< 12.12 2>&1 ||
echo 'command failed: json <<< 12.12'

echo '$ json <<< 1234.1234'
json <<< 1234.1234 2>&1 ||
echo 'command failed: json <<< 1234.1234'

echo '$ json <<< 12345678.12345678'
json <<< 12345678.12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678'

echo '$ json <<< 1234567890123456.1234567890123456'
json <<< 1234567890123456.1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0e0'
json <<< 0e0 2>&1 ||
echo 'command failed: json <<< 0e0'

echo '$ json <<< 1e1'
json <<< 1e1 2>&1 ||
echo 'command failed: json <<< 1e1'

echo '$ json <<< 12e12'
json <<< 12e12 2>&1 ||
echo 'command failed: json <<< 12e12'

echo '$ json <<< 1234e1234'
json <<< 1234e1234 2>&1 ||
echo 'command failed: json <<< 1234e1234'

echo '$ json <<< 12345678e12345678'
json <<< 12345678e12345678 2>&1 ||
echo 'command failed: json <<< 12345678e12345678'

echo '$ json <<< 1234567890123456e1234567890123456'
json <<< 1234567890123456e1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456e1234567890123456'

echo '$ json <<< 12345678901234567890123456789012e12345678901234567890123456789012'
json <<< 12345678901234567890123456789012e12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012e12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0E0'
json <<< 0E0 2>&1 ||
echo 'command failed: json <<< 0E0'

echo '$ json <<< 1E1'
json <<< 1E1 2>&1 ||
echo 'command failed: json <<< 1E1'

echo '$ json <<< 12E12'
json <<< 12E12 2>&1 ||
echo 'command failed: json <<< 12E12'

echo '$ json <<< 1234E1234'
json <<< 1234E1234 2>&1 ||
echo 'command failed: json <<< 1234E1234'

echo '$ json <<< 12345678E12345678'
json <<< 12345678E12345678 2>&1 ||
echo 'command failed: json <<< 12345678E12345678'

echo '$ json <<< 1234567890123456E1234567890123456'
json <<< 1234567890123456E1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456E1234567890123456'

echo '$ json <<< 12345678901234567890123456789012E12345678901234567890123456789012'
json <<< 12345678901234567890123456789012E12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012E12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0e-0'
json <<< 0e-0 2>&1 ||
echo 'command failed: json <<< 0e-0'

echo '$ json <<< 1e-1'
json <<< 1e-1 2>&1 ||
echo 'command failed: json <<< 1e-1'

echo '$ json <<< 12e-12'
json <<< 12e-12 2>&1 ||
echo 'command failed: json <<< 12e-12'

echo '$ json <<< 1234e-1234'
json <<< 1234e-1234 2>&1 ||
echo 'command failed: json <<< 1234e-1234'

echo '$ json <<< 12345678e-12345678'
json <<< 12345678e-12345678 2>&1 ||
echo 'command failed: json <<< 12345678e-12345678'

echo '$ json <<< 1234567890123456e-1234567890123456'
json <<< 1234567890123456e-1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456e-1234567890123456'

echo '$ json <<< 12345678901234567890123456789012e-12345678901234567890123456789012'
json <<< 12345678901234567890123456789012e-12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012e-12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0E-0'
json <<< 0E-0 2>&1 ||
echo 'command failed: json <<< 0E-0'

echo '$ json <<< 1E-1'
json <<< 1E-1 2>&1 ||
echo 'command failed: json <<< 1E-1'

echo '$ json <<< 12E-12'
json <<< 12E-12 2>&1 ||
echo 'command failed: json <<< 12E-12'

echo '$ json <<< 1234E-1234'
json <<< 1234E-1234 2>&1 ||
echo 'command failed: json <<< 1234E-1234'

echo '$ json <<< 12345678E-12345678'
json <<< 12345678E-12345678 2>&1 ||
echo 'command failed: json <<< 12345678E-12345678'

echo '$ json <<< 1234567890123456E-1234567890123456'
json <<< 1234567890123456E-1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456E-1234567890123456'

echo '$ json <<< 12345678901234567890123456789012E-12345678901234567890123456789012'
json <<< 12345678901234567890123456789012E-12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012E-12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0e+0'
json <<< 0e+0 2>&1 ||
echo 'command failed: json <<< 0e+0'

echo '$ json <<< 1e+1'
json <<< 1e+1 2>&1 ||
echo 'command failed: json <<< 1e+1'

echo '$ json <<< 12e+12'
json <<< 12e+12 2>&1 ||
echo 'command failed: json <<< 12e+12'

echo '$ json <<< 1234e+1234'
json <<< 1234e+1234 2>&1 ||
echo 'command failed: json <<< 1234e+1234'

echo '$ json <<< 12345678e+12345678'
json <<< 12345678e+12345678 2>&1 ||
echo 'command failed: json <<< 12345678e+12345678'

echo '$ json <<< 1234567890123456e+1234567890123456'
json <<< 1234567890123456e+1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456e+1234567890123456'

echo '$ json <<< 12345678901234567890123456789012e+12345678901234567890123456789012'
json <<< 12345678901234567890123456789012e+12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012e+12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0E+0'
json <<< 0E+0 2>&1 ||
echo 'command failed: json <<< 0E+0'

echo '$ json <<< 1E+1'
json <<< 1E+1 2>&1 ||
echo 'command failed: json <<< 1E+1'

echo '$ json <<< 12E+12'
json <<< 12E+12 2>&1 ||
echo 'command failed: json <<< 12E+12'

echo '$ json <<< 1234E+1234'
json <<< 1234E+1234 2>&1 ||
echo 'command failed: json <<< 1234E+1234'

echo '$ json <<< 12345678E+12345678'
json <<< 12345678E+12345678 2>&1 ||
echo 'command failed: json <<< 12345678E+12345678'

echo '$ json <<< 1234567890123456E+1234567890123456'
json <<< 1234567890123456E+1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456E+1234567890123456'

echo '$ json <<< 12345678901234567890123456789012E+12345678901234567890123456789012'
json <<< 12345678901234567890123456789012E+12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012E+12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0e0'
json <<< 0.0e0 2>&1 ||
echo 'command failed: json <<< 0.0e0'

echo '$ json <<< 1.1e1'
json <<< 1.1e1 2>&1 ||
echo 'command failed: json <<< 1.1e1'

echo '$ json <<< 12.12e12'
json <<< 12.12e12 2>&1 ||
echo 'command failed: json <<< 12.12e12'

echo '$ json <<< 1234.1234e1234'
json <<< 1234.1234e1234 2>&1 ||
echo 'command failed: json <<< 1234.1234e1234'

echo '$ json <<< 12345678.12345678e12345678'
json <<< 12345678.12345678e12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678e12345678'

echo '$ json <<< 1234567890123456.1234567890123456e1234567890123456'
json <<< 1234567890123456.1234567890123456e1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456e1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012e12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012e12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012e12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0E0'
json <<< 0.0E0 2>&1 ||
echo 'command failed: json <<< 0.0E0'

echo '$ json <<< 1.1E1'
json <<< 1.1E1 2>&1 ||
echo 'command failed: json <<< 1.1E1'

echo '$ json <<< 12.12E12'
json <<< 12.12E12 2>&1 ||
echo 'command failed: json <<< 12.12E12'

echo '$ json <<< 1234.1234E1234'
json <<< 1234.1234E1234 2>&1 ||
echo 'command failed: json <<< 1234.1234E1234'

echo '$ json <<< 12345678.12345678E12345678'
json <<< 12345678.12345678E12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678E12345678'

echo '$ json <<< 1234567890123456.1234567890123456E1234567890123456'
json <<< 1234567890123456.1234567890123456E1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456E1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012E12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012E12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012E12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0e-0'
json <<< 0.0e-0 2>&1 ||
echo 'command failed: json <<< 0.0e-0'

echo '$ json <<< 1.1e-1'
json <<< 1.1e-1 2>&1 ||
echo 'command failed: json <<< 1.1e-1'

echo '$ json <<< 12.12e-12'
json <<< 12.12e-12 2>&1 ||
echo 'command failed: json <<< 12.12e-12'

echo '$ json <<< 1234.1234e-1234'
json <<< 1234.1234e-1234 2>&1 ||
echo 'command failed: json <<< 1234.1234e-1234'

echo '$ json <<< 12345678.12345678e-12345678'
json <<< 12345678.12345678e-12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678e-12345678'

echo '$ json <<< 1234567890123456.1234567890123456e-1234567890123456'
json <<< 1234567890123456.1234567890123456e-1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456e-1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012e-12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012e-12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012e-12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e-1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0E-0'
json <<< 0.0E-0 2>&1 ||
echo 'command failed: json <<< 0.0E-0'

echo '$ json <<< 1.1E-1'
json <<< 1.1E-1 2>&1 ||
echo 'command failed: json <<< 1.1E-1'

echo '$ json <<< 12.12E-12'
json <<< 12.12E-12 2>&1 ||
echo 'command failed: json <<< 12.12E-12'

echo '$ json <<< 1234.1234E-1234'
json <<< 1234.1234E-1234 2>&1 ||
echo 'command failed: json <<< 1234.1234E-1234'

echo '$ json <<< 12345678.12345678E-12345678'
json <<< 12345678.12345678E-12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678E-12345678'

echo '$ json <<< 1234567890123456.1234567890123456E-1234567890123456'
json <<< 1234567890123456.1234567890123456E-1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456E-1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012E-12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012E-12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012E-12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E-1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0e+0'
json <<< 0.0e+0 2>&1 ||
echo 'command failed: json <<< 0.0e+0'

echo '$ json <<< 1.1e+1'
json <<< 1.1e+1 2>&1 ||
echo 'command failed: json <<< 1.1e+1'

echo '$ json <<< 12.12e+12'
json <<< 12.12e+12 2>&1 ||
echo 'command failed: json <<< 12.12e+12'

echo '$ json <<< 1234.1234e+1234'
json <<< 1234.1234e+1234 2>&1 ||
echo 'command failed: json <<< 1234.1234e+1234'

echo '$ json <<< 12345678.12345678e+12345678'
json <<< 12345678.12345678e+12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678e+12345678'

echo '$ json <<< 1234567890123456.1234567890123456e+1234567890123456'
json <<< 1234567890123456.1234567890123456e+1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456e+1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012e+12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012e+12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012e+12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234e+1234567890123456789012345678901234567890123456789012345678901234'

echo '$ json <<< 0.0E+0'
json <<< 0.0E+0 2>&1 ||
echo 'command failed: json <<< 0.0E+0'

echo '$ json <<< 1.1E+1'
json <<< 1.1E+1 2>&1 ||
echo 'command failed: json <<< 1.1E+1'

echo '$ json <<< 12.12E+12'
json <<< 12.12E+12 2>&1 ||
echo 'command failed: json <<< 12.12E+12'

echo '$ json <<< 1234.1234E+1234'
json <<< 1234.1234E+1234 2>&1 ||
echo 'command failed: json <<< 1234.1234E+1234'

echo '$ json <<< 12345678.12345678E+12345678'
json <<< 12345678.12345678E+12345678 2>&1 ||
echo 'command failed: json <<< 12345678.12345678E+12345678'

echo '$ json <<< 1234567890123456.1234567890123456E+1234567890123456'
json <<< 1234567890123456.1234567890123456E+1234567890123456 2>&1 ||
echo 'command failed: json <<< 1234567890123456.1234567890123456E+1234567890123456'

echo '$ json <<< 12345678901234567890123456789012.12345678901234567890123456789012E+12345678901234567890123456789012'
json <<< 12345678901234567890123456789012.12345678901234567890123456789012E+12345678901234567890123456789012 2>&1 ||
echo 'command failed: json <<< 12345678901234567890123456789012.12345678901234567890123456789012E+12345678901234567890123456789012'

echo '$ json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234'
json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234 2>&1 ||
echo 'command failed: json <<< 1234567890123456789012345678901234567890123456789012345678901234.1234567890123456789012345678901234567890123456789012345678901234E+1234567890123456789012345678901234567890123456789012345678901234'
)

