/*
    jugtail.h, written by Rhett "Jonzy" Jones 

    Jonzy's Universal Gopher Hierarchy Excavation And Display.
    Excavates through gopher menus and displays the hierarchy
    of the menus encountered

    Copyright (C) 1993, 1994 University of Utah Computer Center.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program (look for the file called COPYING);
    if not, write to the Free Software Foundation, Inc.,
        51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
	                                                                 */

/* Description:	Header file for use with "jugtail.c" and "getargs.c".    */

#ifndef JUGTAIL_H
#define JUGTAIL_H

#include "utils.h"

/* These defines were taken from "GSgopherobj.h". */
#define A_FILE      '0'		/* Types of objects */
#define A_DIRECTORY '1'
#define A_CSO       '2'
#define A_ERROR     '3'
#define A_MACHEX    '4'
#define A_PCBIN     '5'
#define A_INDEX     '7'
#define A_TELNET    '8'
#define A_UNIXBIN   '9'
#define A_SOUND     's'
#define A_EVENT     'e'
#define A_CALENDAR  'c'
#define A_GIF       'g'
#define A_HTML      'h'
#define A_TN3270    'T'
#define A_MIME      'M'
#define A_IMAGE     'I'
#define A_EOI	    '.'

#define BUFFERSIZE	2048	/* The size of our buffer. */
#define DEFAULTPORT	"70"	/* The default port to use. */
#define EMPTYSTRING	""	/* The empty C string. */
#define FIRSTMENU	0	/* The level of indention. */
#define INDENTSTR	"    "	/* What we indent with. */
#define MAXHOSTS	50	/* The maximum number of hosts2search. */

#define YEP		'1'	/* The pathway as been printed. */
#define NOPE		'\0'	/* The pathway has not been printed. */

typedef struct
{
  char *sStr,			/* The selector string. */
   *hStr,			/* The host string. */
   *pStr;			/* The port string. */
} ListInfo;			/* List info about the host or message. */

typedef struct node
{
  ListInfo info;		/* The info contained at this node. */
  struct node *next,		/* Pointer to the next node. */
   *last;			/* The last node before this one. */
} List;

/* The following are declared in "jugtail.c". */
extern char buffer[BUFFERSIZE],
  path[BUFFERSIZE],
  pathPrinted[50],
  *searchHosts[MAXHOSTS],
  *initialHost, *selStr, *hostStr, *portStr, *fileName, *userName, *veronica;
extern int numSearchHosts,
  debug,
  info4dirsOnly,
  info4allItems,
  listHosts,
  listHostsNPorts,
  onlyDoHosts,
  onlyDoHostsT,
  buildDataFile,
  menuFlag, printLineNumbers, printDTree, printDTreeDirs, time2process;
extern short buildIndex, doSearch;
extern List *nogos;

/* The following are declared in "search.c". */
extern char *logFile,
  *hostname,
  *jugtailhelp,
  *errorhost,
  *delimiters,
  *defaultboolop,
  *jugtailhelptitl,
  *usagerror,
  *wildcarderr,
  *tomnyprcserr,
  *noforkerr,
  *gtstrerr, *readerr, *tmpfilename, *catcommand, *sortcommand, *touchcommand;
int port2use, maxprocs, maxitems2return;

extern int GetArguments (int argc, char *argv[], char **fileName,
			 char **logFile);
extern void InitPath (void);

#endif /* JUGTAIL_H */
