/*
  sockets.h, written by Rhett "Jonzy" Jones 

  Jonzy's Universal Gopher Hierarchy Excavation And Display.
  Excavates through gopher menus and displays the hierarchy
  of the menus encountered

  Copyright (C) 1993, 1994 University of Utah Computer Center.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program (look for the file called COPYING);
  if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* Description:	Header file for use with "sockets.c".  Simply defines a type,
 *		prototypes a few routines, and declares a variable as
 *		extern.
 */

#ifndef SOCKETS_H
#define SOCKETS_H

extern void PostContactHostError(int error, char *hostStr, char *portStr);
extern char *GetHostName(char *hostDomainFromConf_h);
extern void IP2Hostname(int sockfd, char *host, char *ip);
extern int SetUpReadNwriter(int theSocket);
extern void CloseReadNwriter(void);
extern int ContactHost(char* theHost, int thePort);
extern int SendBuffer(char *buffer, int bufferSize);
extern int SendString(char *s);
extern char *GetString(FILE *ptr);
extern int ListenerEstablished(int port);
extern int ProcessRequest(int sockfd);

#endif /* SOCKETS_H */
