/*
  tree.h, written by Rhett "Jonzy" Jones 

  Jonzy's Universal Gopher Hierarchy Excavation And Display.
  Excavates through gopher menus and displays the hierarchy
  of the menus encountered

  Copyright (C) 1993, 1994 University of Utah Computer Center.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program (look for the file called COPYING);
  if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * Description:	Header file for use with "tree.c".  Simply defines a type,
 *	prototypes a few routines, and declares a variable as extern.
 *
 */

#ifndef TREE_H
#define TREE_H

typedef struct lNode
{
  long where;			/* The position for a word. */
  struct lNode *next;		/* Next position for a word. */
} ListType;

typedef struct tNode
{
  char *word;			/* A word from the display str. */
  ListType *positions;		/* List of positions. */
  struct tNode *left,		/* Left side of the tree. */
   *right;			/* Right side of the tree. */
} TreeType;

typedef struct
{
  char *word;			/* The word. */
  ListType *positions;		/* List of file positions. */
} Element;

extern short InList (TreeType *node, long where);
extern void DestroyList (ListType *list);
extern ListType *BuildList (ListType *node, long where);
extern long BinarySearch (char *what2Find, Element *data, long size,
			  char **asterik, size_t *asterikPos);
extern long NumberOfLeafs (TreeType *node);
extern TreeType *WhatBranch (TreeType *node, char *word);
extern void BuildTree (TreeType **root, char *word, long where);
extern long NumberOfListNodes (ListType *positions);
extern void PrintTree (TreeType *node, int hostTree);

extern TreeType *root;		/* The root of the tree. */

#endif /* TREE_H */
