/*
  utils.h, written by Rhett "Jonzy" Jones 

  Jonzy's Universal Gopher Hierarchy Excavation And Display.
  Excavates through gopher menus and displays the hierarchy
  of the menus encountered

  Copyright (C) 1993, 1994 University of Utah Computer Center.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program (look for the file called COPYING);
  if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef UTILS_H
#define UTILS_H

extern long NumberOfLines (char *fileName);
extern char *StrToLower (char *str);
extern long GetLong (FILE * fp);
extern int GetInt (FILE * fp);
extern char *GetStr (FILE * fp, char *str, int limit);
extern int Str2Int (char *s);
extern char *Reverse (char *s, char *r);
extern short StrRcmp (char *s1, char *s2);
extern char *Mysprint (char *format, ...);
extern int DoSystemCall (char *command);
extern char *MyStrTok (char *str, char delimeter);
extern char *OnlyDigits (char *s);
extern char *RemoveCRLF (char *line);

#endif /* UTILS_H */
