#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009  John Schneiderman <JohnMS@member.fsf.org>        ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

import os

import wx


class MediaSong():
    """ A container for a song's information. """

    """
     ATTRIBUTES
    """
    # The name of the artist.
    artist = None
    # The title of the song.
    title = None
    # Indicates if the media is a video file.
    blIsVideo = None
    # The absolute path to the media file.
    filePath = None

    def __init__(self, filename=None, isVideo=None):
        """ Default constructor.

         Creates a MediaSong object.
         string filename: is the absolute path to the file, with name.
           The file name must be in the form of ARTIST - TITLE.EXT for it to
           be parsed cleanly. If the file name does not contain a "-" the
           entire file name is placed in the title field.
         boolean isVideo: indicates if the file is a video file.
        """
        if filename is not None:
            (dirName, fileName) = os.path.split(filename)
            (fileBaseName, fileExtension) = os.path.splitext(fileName)

            if len(fileBaseName.split("-")) > 1:
                self.__createSong(fileBaseName.split("-")[0].strip(), \
                    fileBaseName.split("-")[1].strip(), \
                    isVideo, filename)
            elif filename:
                self.__createSong("", fileBaseName.strip(), isVideo, filename)
            else:
                self.__createSong("", "", isVideo, filename)

    def __str__(self):
        """ Format the song information nicely """
        if self.blIsVideo is not None:
            if self.blIsVideo:
                media = "Video"
            else:
                media = "Audio"
        else:
            media = "Not Set"
        return "%s - %s is a %s file located at %s" % (self.artist, \
            self.title, media, self.filePath)

    def __createSong(self, artist, title, isVideo, path):
        """ Populate a media song.

         string artist: is the name of the artist for the song.
         string title: is the name of the song.
         boolean isVideo: indicates if the file is a video file. True if it is,
           and False if it is not.
         string path: is the absolute path to the file.
         return MediaSong: The created MediaSong object
        """
        self.artist = artist
        self.title = title
        self.blIsVideo = isVideo
        self.filePath = path.replace("\"", "\\\"")
