#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

class PlayerSignal():
    """ Abstract interface for players to process signal commands. """

    """
     ATTRIBUTES
    """
    # File path to the currently playing song.
    songFilePath = None
    # Arguments to pass along to the player when starting
    arguments = None
    # Volume level for playing the music
    volumeLevel = 0
    # Total time in seconds of the currently playing song, in seconds.
    totalTime = 0.0
    # Current position in the playing song, in seconds.
    positionTime = 0.0

    def __init__(self, volumeLevel, arguments):
        """ Default constructor

         Initialises the signals for the given player.
         int volumeLevel: is the percentage level for playing music.
         string arguments: are any additional arguments to pass along to the
           player when playing a song in addtion to the standard arguments.
        """
        print "PlayerSignal.__init__(self, volumeLevel, arguments)", self, \
            volumeLevel, arguments
        self.volumeLevel = volumeLevel
        self.arguments = arguments

    def name(self):
        """ Accessor to the player whose signals it handles. """
        print "PlayerSignal.name(self)"
        pass

    def play(self, player):
        """ Handles playing a song to the player.

         Starts playing the song stored in self.songFilePath, as well as
           passing along any additional arguements supplied, through the
           player controller.
         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.play(self, player)"
        pass

    def pause(self, player):
        """ Handles pausing a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.pause(self, player)"
        pass

    def unpause(self, player):
        """ Handles unpausing a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.unpause(self, player)"
        pass

    def stop(self, player):
        """ Handles stoping a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.stop(self, player)"
        pass

    def quit_(self, player):
        """ Handles quiting the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.quit_(self, player)"
        pass

    def setVolume(self, player):
        """ Handles volume of a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.setVolume(self, player)"
        pass

    def playerTotalTime(self, player):
        """ Handles total time of a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.playerTotalTime(self, player)"
        pass

    def playerPositionTime(self, player):
        """ Handles position of a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.playerPositionTime(self, player)"
        pass

    def setPlayerPositionTime(self, player):
        """ Handles setting postion of a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.setPlayerPositionTime(self, player)"
        pass

    def fullScreen(self, player):
        """ Handles playing full screen a song to the player.

         PlayerController player: is the the interface to the OS command line.
        """
        print "PlayerSignal.fullScreen(self, player)"
        pass
