#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

"""
 IMPORTS
"""
import cPickle

import wx


# The drag-and-drop format for a Media Song
mediaSongFormat = wx.CustomDataFormat('KapMediaSong')


class MediaSongDataObject(wx.PyDataObjectSimple):
    """ A container for a song's information for drag and drop support. """

    """
     ATTRIBUTES
    """
    # The media songs to pass
    songs = None
    # The pickled songs
    data = None


    def __init__(self, songs = None):
        """ Default constructor

         Stores any songs for drag-and-drop support.
         list[MediaSong] songs: the list of MediaSongs to drag-and-drop.
        """
        wx.PyDataObjectSimple.__init__(self)
        #print "MediaSongDataObject.__init__(self, songs = None)", self, songs
        self.SetFormat(mediaSongFormat)
        self.songs = songs
        self.data = cPickle.dumps(self.songs)

    def GetDataSize(self):
        """ Accessor to the number size of the data.

         Provides the total number of bytes in the media song list.
         return int: total number of bytes of the stored media song list.
        """
        #print "MediaSongDataObject.GetDataSize(self)", self
        return len(self.data)

    def GetDataHere(self):
        """ Accessor to the MediaSong data.

         Provides the MediaSong data.
         return cPickle: the MediaSong data.
        """
        #print "MediaSongDataObject.GetDataHere(self)", self
        return self.data

    def SetData(self, data):
        """ Modifier to the MediaSong data.

         Sets the data and songs list.
         cPickle data: is the MediaSong data to store.
        """
        #print "MediaSongDataObject.SetData(self, data)", self, data
        self.data = data
        self.songs = cPickle.loads(self.data)
