#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

"""
 IMPORTS
"""
import playerbase as PlayerBase
import mplayerplayer as MPlayerPlayer


class PlayerFactory:
    """ Creates a media player.

     Handles all the media player creation and management.
    """

    """
     MEDIA PLAYER TYPES
    """
    __ID_MPLAYER = "MPlayer" # Supports mplayer

    """
     ATTRIBUTES
    """
    # The media player type to use.
    type_ = None
    # The media player created.
    player = None

    def __init__(self, type_=__ID_MPLAYER):
        """ Default Constructor """
        self.type_ = type_

    def create(self, volumeLevel, additionalArguments):
        """ Creates a new player.

         int volumeLevel: is the percentage volume level.
         string additionalArguments: are the additional arguments to pass
           along to the created player.
        """
        if self.type_ == self.__ID_MPLAYER:
            self.player = MPlayerPlayer.MPlayerPlayer(volumeLevel, \
                additionalArguments)
        else:
            self.player = PlayerBase.PlayerBase()

    def destroy(self):
        """ Destroys a created player """
        del self.player
        self.player = None
