#!/usr/bin/env python
# -*- coding: utf-8 -*-
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

# The current version of Kap
VERSION = "0.7.0"
# The shorted form of the copyright years.
YEARS = "2009 - 2010"
# The database backend to use: file, metakit
DATABASE_BACKEND = "METAKIT"


"""
 IMPORTS
"""
import sys
import ConfigParser
import signal

import wx

import kapwindow as KapApp


def main(args):
    """ Launcher for the Kap stand-alone player.

     Currently there are no command line options.
    """

    # Display license
    print "KAP %s Copyright (C) %s John Schneiderman" % (VERSION, YEARS)
    print "KAP comes with ABSOLUTELY NO WARRANTY;"
    print "This is free software, and you are welcome to redistribute it"
    print "under certain conditions; see the COPYING file for details,"
    print "or the Free Software Foundation's GPL.\n"

    pySmplAppKap = wx.PySimpleApp()
    sfCnfgPrsrKap = ConfigParser.SafeConfigParser()
    sfCnfgPrsrKap.read('kap.config')
    kap = KapApp.KapWindow(None, wx.ID_ANY, sfCnfgPrsrKap)
    signal.signal(signal.SIGINT, kap.signalExit)
    kap.Show(True)
    pySmplAppKap.MainLoop()
    configfile = open('kap.config', 'wb')
    sfCnfgPrsrKap.write(configfile)


if __name__ == "__main__":
    main(sys.argv)
