#!/usr/bin/env python
# -*- coding: utf-8 -*-
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

"""
 IMPORTS
"""
import kaa.metadata
import mediasong

class MediaParser():
    """ Parses a song file's media information details. """

    """
     ATTRIBUTES
    """
    __information = {}

    def __init__(self, song):
        """ Default constructor.

         Creates a FileInformaiton object to provide all information known
           regarding a media file.
         MediaSong song: is the song to get information about.
        """
        dirtyInfo = kaa.metadata.parse(song.filePath)
        if dirtyInfo is None:
            self.__information = None
        else:
            for dirtyKey in dirtyInfo.keys():
                if dirtyInfo[dirtyKey] is None:
                    continue
                cleanKey = unicode(dirtyKey.encode('iso-8859-1'), 'UTF-8')
                if "thumbnail" in cleanKey:
                    continue
                dirtyInfoStr = str(dirtyInfo[dirtyKey])
                cleanInfo = unicode(dirtyInfoStr.encode('iso-8859-1'), 'UTF-8')
                self.__information[cleanKey] = cleanInfo

    def hasInformation(self):
        """ Determines if the media information was extracted.

         return bool: true if the informaiton was found, false elsewise.
        """
        if self.__information is None:
            return False
        else:
            return True

    def information(self):
        """ Accessor to the media information.

         return dictionary: all known information with the type of information
           as the key for each value.
        """
        return self.__information
