/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "carddeck.h"

#include <qstring.h>
#include <cmath>
#include <algorithm>

CardDeck::CardDeck(): CardPile()
{
    time_t seconds;

    time(&seconds);
    srand(seconds);
}

void CardDeck::createDeck()
{
    m_pile.clear();
    for (int i=0; i < Card::NUMBER_OF_SUITS; i++)
        for (int j=0; j < Card::NUMBER_OF_RANKS; j++)
            m_pile.addCard(Card(static_cast<Card::rank_t>(j), static_cast<Card::suit_t>(i)));
}

void CardDeck::shuffle()
{
    random_shuffle(m_pile.begin(), m_pile.end());
}

Card CardDeck::dealCard()
{
    return removeCard();
}

void CardDeck::cutDeck()
{
    // Ensure that we at least select GUARANTEE_CUT_SIZE cards.
    int newTopCard=(rand() % (m_pile.size() - GUARANTEE_CUT_SIZE)) + GUARANTEE_CUT_SIZE, pileSize=m_pile.size();
    CardDeck leftDeck, rightDeck;

    // Cut the deck
    for (int cardIndex=0; cardIndex < pileSize; cardIndex++)
        if (cardIndex < newTopCard)
            leftDeck.addCard(m_pile[cardIndex]);
        else
            rightDeck.addCard(m_pile[cardIndex]);

    // Combine the two decks.
    *this=rightDeck;
    *this+=leftDeck;
}
