/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef CARDDECK_H
#define CARDDECK_H

#include "cardpile.h"

/**
 * This is a deck of cards.
 *
 * @author John Schneiderman
 * @todo create a method that randomly adds all missing cards to the bottom of the deck and then shuffles them. This will add more realism to the game play.
 */
class CardDeck: public CardPile
{
public:
    /**
     * This is the default constructor.
     */
    CardDeck();
    /**
     * This creates an ordered deck of cards based the on suit and rank orders listed in the @ref Card class.
     */
    void createDeck();
    /**
     * Shuffles the deck of cards.
     */
    void shuffle();
    /**
     * This removes a card off the top of the deck.
     * @return the card removed from the top of the deck.
     */
    Card dealCard();
    /**
     * This randomly cuts the deck, and places the bottom half on top of the other half.
     * @note That the cut is guaranteed to be at least GUARANTEE_CUT_SIZE.
     */
    void cutDeck();

private:
    /**
     * The constants used in the card deck.
     * @param GUARANTEE_CUT_SIZE is the minimum number of cards that will be used when cutting the deck.
     */
    enum Constants { GUARANTEE_CUT_SIZE = 10 };
};
#endif
