/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "gamebase.h"
#include "player.h"
#include "computerplayer.h"

GameBase::GameBase(UserProfileDatabase &profileDatabase):m_players(), m_playSequence()
{
    m_roundPoints=0;
    m_dealerIndex=0;
    m_pProfileDatabase=&profileDatabase;
}

GameBase::~GameBase()
{}

void GameBase::addOpponent(ComputerPlayer &opponent)
{
    addPlayer(opponent);
}

void GameBase::addPlayer(Player &player)
{
    m_players.insert(player);
}

void GameBase::resetGame(bool roundOver)
{
    for (int i=0; i < m_players.size(); ++i)
    {
        m_players[i].reset();
        if (roundOver)
            m_players[i].resetRoundScore();
    }
    m_playSequence.clear();
    m_roundPoints=0;
}

void GameBase::nextDealer()
{
    m_players[m_dealerIndex].setDealer(false);
    m_players.setCurrentPlayer(m_players[m_dealerIndex=(m_dealerIndex + 1) % m_players.size()]);
    m_players[m_dealerIndex].setDealer(true);
}
