/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "karddrag.h"
#include "kard.h"

#include <qdatastream.h>
#include <qwidget.h>
#include <qmime.h>

KardDrag::KardDrag(Kard &kard, QWidget *parent, const char *name):QDragObject(parent, name)
{
    m_pKard = new Kard(kard.card(), kard.isFaceUp(), parent, kard.card().toString());
    if (m_pKard->isFaceUp())
        setPixmap(m_pKard->cardFront());
    else
        setPixmap(m_pKard->cardBack());
}

KardDrag::~KardDrag()
{
    if (m_pKard != NULL)
        delete m_pKard;
}

const char * KardDrag::format(int index) const
{
    switch (index)
    {
    case 0:
        return "application/x-kard"; // This is intially defined in the Kard class.
    default:
        return NULL;
    }
}

QByteArray KardDrag::encodedData(const char *format) const
{
    QByteArray data;
    QTextOStream out(data);

    if (qstrcmp(format, "application/x-kard") == 0)
        out << m_pKard->card().toString();
    return data;
}

bool KardDrag::canDecode(const QMimeSource *source)
{
    return source->provides("application/x-kard");
}

bool KardDrag::decode(const QMimeSource *source, Kard &kard)
{
    Card card;
    QString strCard;
    QByteArray data = source->encodedData("application/x-kard");

    strCard = QString::fromLocal8Bit((const char *) data, data.size());
    card.setCard(strCard);
    kard.setCard(card);
    return ! strCard.isEmpty();
}
