/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef ABIGAIL_H
#define ABIGAIL_H

#include "aibase.h"

/**
 * This is the character Abigail.
 * @note Abigail's strategies should be at the level of an Amateur.
 *
 * @author John Schneiderman
 */
class Abigail: public AIBase
{
public:
    /**
     * The default constructor.
     */
    Abigail();
    /**
     * The default destructor.
     */
    ~Abigail();
    /**
     * This selects cards from her hand.
     * @param game is the game or game phase she's playing.
     * @param playSequence is the current play sequence.
     * @param rules are the rules for the game.
     * @param hand is her current hand.
     * @return the cards she selects.
     */
    virtual CardSequence whichCards(const QString& game, const CardSequence& playSequence, const RuleBase& rules, const CardSequence& hand) const;
    /**
     * This gives access to the skill level strategies for a specific game.
     * @param game is the game we want to know her skill level of.
     * @return her skill level.
     */
    virtual Player::skill_Level skillLevel(const QString& game) const;
    /**
     * This gives her name.
     * @return her name.
     */
    virtual QString name() const;
};
#endif
