/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "generalgameai.h"
#include "kardsgterror.h"

GeneralGameAI::GeneralGameAI(const RuleBase &rules, const CardSequence &hand): m_playSequence()
{
    m_pRules = &rules;
    m_hand = hand;
}

GeneralGameAI::GeneralGameAI(const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand)
{
    m_playSequence = playSequence;
    m_pRules = &rules;
    m_hand = hand;
}

GeneralGameAI::~GeneralGameAI()
{}

CardSequence GeneralGameAI::selectCards(int numberOfCards) const
{
    CardSequence cards;
    Player player;

    // Create the necessary player information for the legal play method
    for (int i=0; i < m_hand.size(); ++i)
        player.hand().addCard(m_hand[i]);
    for (int cardIndex=0; (cardIndex < m_hand.size()) && (cards.size() < numberOfCards); ++cardIndex)
        if (m_pRules->isLegalPlay(m_playSequence, m_hand[cardIndex], player))
            cards.addCard(m_hand[cardIndex]);
    if (cards.size() == numberOfCards)
        return cards;
    else
        throw KardsGTError("GeneralGameAI", "selectCards", "Could not find enough cards to play!");
}

CardSequence GeneralGameAI::randomCards(int nummberOfCards) const
{
    CardSequence cards;
    Player player;
    int cardIndex;

    // Create the necessary player information for the legal play method
    for (int i=0; i < m_hand.size(); ++i)
        player.hand().addCard(m_hand[i]);
    // Find our cards to play
    while (cards.size() != nummberOfCards)
    {
        cardIndex=rand() % m_hand.size();
        if (! cards.hasCard(m_hand[cardIndex]))
            if (m_pRules->isLegalPlay(m_playSequence, m_hand[cardIndex], player))
                cards.addCard(m_hand[cardIndex]);
    }
    return cards;
}

CardSequence GeneralGameAI::selectCardsWithNoLegalChecks(int numberOfCards) const
{
    CardSequence cards;

    for (int cardIndex=0; cardIndex < numberOfCards; ++cardIndex)
        cards.addCard(m_hand[cardIndex]);
    return cards;
}

CardSequence GeneralGameAI::randomCardsWithNoLegalChecks(int nummberOfCards) const
{
    CardSequence cards;
    int cardIndex;

    while (cards.size() != nummberOfCards)
    {
        cardIndex=rand() % m_hand.size();
        if (! cards.hasCard(m_hand[cardIndex]))
            cards.addCard(m_hand[cardIndex]);
    }
    return cards;
}
