/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef WALLY_H
#define WALLY_H

#include "aibase.h"
#include "player.h"

class Card;
class CardSequence;
class RuleBase;

/**
 * This is the Wally character.
 * @note Wally's strategies should be at the level of an Aprentice.
 *
 * @author John Schneiderman
 */
class Wally: public AIBase
{
public:
    /**
     * The default constructor.
     */
    Wally();
    /**
     * The default destructor.
     */
    virtual ~Wally();
    /**
     * The name of our player.
     * @return Wally.
     */
    virtual QString name() const;
    /**
     * Selects the cards we want to play.
     * @param game the name of the game or game phase we're currently playing.
     * @param playSequence is the current play sequence.
     * @param rules is the rules to the game.
     * @param hand is our current hand.
     * @return the cards we want to play.
     */
    virtual CardSequence whichCards(const QString &game, const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand) const;
    /**
     * An accessor to our player's skill level.
     * @param game is the game we want to know the skill level for.
     * @return the skill level based on game. If the game is not found the skill level of Newb is returned.
     */
    virtual Player::skill_Level skillLevel(const QString &game) const;
};
#endif
