/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
using std::vector;
using std::pair;

/**
 * Default constructor.
 */
void ConfigureKardsGT::init()
{}

/**
 * This sets the profile database and fills in the fields with the values in the profile for the user.
 * @param profile is the profile database.
 * @param user is the user whose values we're going to use.
 */
void ConfigureKardsGT::setProfileDatabase( const UserProfileDatabase &profile, const QString &user)
{
    database = profile;
    // Set the card image paths
    cardPath->setText(database.pathToCardImages(user));
    backPath->setText(database.pathToCardBackImage(user));
    // Set the player image paths
    neutralMood->setCurrentText(database.userImage(user, "neutral"));
}

/**
 * An accessor to all the settings in the widget.
 * @return all the settings in the widget.
 */
vector<pair<QString, QString> > ConfigureKardsGT::settings()
{
    vector<pair<QString, QString> > userSettings;

    // Save Cards Settings
    userSettings.push_back(pair<QString, QString>("CardImagePath", cardPath->text()));
    userSettings.push_back(pair<QString, QString>("CardBackPath", backPath->text()));
    // Save Player Settings
    userSettings.push_back(pair<QString, QString>("NeutralMood", neutralMood->currentText()));
    return userSettings;
}

/**
 * This provides a dialogue to select an image for the back of the cards.
 */
void ConfigureKardsGT::setCardBackImage()
{
    QString path = QFileDialog::getOpenFileName(".", tr("PNG (*.png)\n" "BMP (*.bmp)\n" "JPEG (*.jpeg)\n" "JPG (*.jpg)\n" "XPM (*.xpm)\n" "All files (*)"), this, "Card Back Image", "Choose the image for the card back");

    if (! path.isEmpty())
        backPath->setText(path);
}

/**
 * This provides a dialogue to select the directory that holds the front images of the cards.
 */
void ConfigureKardsGT::setCardImagePath()
{
    QString path = QFileDialog::getExistingDirectory(
                       ".",
                       this,
                       "get existing directory",
                       "Choose the directory that has the card images",
                       TRUE );

    if (! path.isEmpty())
        cardPath->setText(path);
}

/**
 * This provides a dialogue to select the image for the neutral mood of the player.
 */
void ConfigureKardsGT::setNeutralMoodPath()
{
    QString path = QFileDialog::getOpenFileName(".", tr("PNG (*.png)\n" "BMP (*.bmp)\n" "JPEG (*.jpeg)\n" "JPG (*.jpg)\n" "XPM (*.xpm)\n" "All files (*)"), this, "Neutral Mood Image", "Choose the image for player's neutral mood");

    if (! path.isEmpty())
        neutralMood->setCurrentText(path);
}

/**
 * This displays a message box explaining how to use the configuration widget.
 */
void ConfigureKardsGT::displayHelp()
{
    QMessageBox::information(this, "Configure Help", "Enter the paths you wish to change into the boxes by using the keyboard, or\n using the buttons on the right of the boxes.\n Once you have made the changes you desire, press OK to save.\n If you do not want to save any changes, press cancel.");
}

/**
 * This restores all of the fields to the build-in defaults of the game.
 */
void ConfigureKardsGT::setDefaults()
{
    cardPath->setText("default");
    backPath->setText("cardback.png");
    // Set the player image paths
    neutralMood->setCurrentText("player-male.png");
}
